<?php
class PackagingController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save', 'AutoSave'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        $frm = Yii::app()->request->getParam('frm');
        $hire = Yii::app()->request->getParam('hire');
        $this->render('index', array('frm' => $frm, 'hire' => $hire));
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList()
    {
        $model = new PackagingList();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = Yii::app()->request->getParam('frm');
        $hire = Yii::app()->request->getParam('hire');

        $columns = array(
            0 => 'transaction_id',
            1 => 'file_id',
            2 => 'customer_name',
            3 => 'transaction_date',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1';
        $joinDelivery = false;

        if (!empty($frm)) {
            $condition = "t.status='" . $frm . "'";

            if ($frm == 'D') {
                $joinDelivery = true; // mark to join delivery_note
                if (!isset(Yii::app()->user->havePermissionOn["delivery_view_all"]) && Yii::app()->user->authorised_user != 1) {
                    $condition .= ' AND (delivery_details.lead_owner_id= "' . Yii::app()->user->id . '")';
                }

                if ($hire == 3) {
                    $condition .= ' AND delivery_details.delivery_type="service"';
                } else {
                    $condition .= ' AND delivery_details.delivery_type="sales"';
                }
            }
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (t.transaction_id LIKE '%" . $searchString . "%' 
                          OR t.customer_name LIKE '%" . $searchString . "%' 
                          OR t.packing_frm LIKE '%" . $searchString . "%')";
        }

        // Build SQL dynamically only when join is needed
        if ($joinDelivery) {
            $SQL = "SELECT t.* 
                FROM `view_packaging_list` t 
                LEFT JOIN `erp_delivery_note` delivery_details 
                    ON t.transaction_id = delivery_details.id
                WHERE $condition 
                ORDER BY $orderBy 
                LIMIT $offset, $limit";

            $model = Yii::app()->db->createCommand($SQL)->queryAll();
            $countSQL = "SELECT COUNT(*) 
                     FROM `view_packaging_list` t 
                     LEFT JOIN `erp_delivery_note` delivery_details 
                        ON t.transaction_id = delivery_details.id
                     WHERE $condition";
            // echo $SQL;
            $count = Yii::app()->db->createCommand($countSQL)->queryScalar();
        } else {
            // No join needed
            $count = $model->count(array('condition' => $condition));
            $model = $model->findAll(array(
                'condition' => $condition,
                'limit' => $limit,
                'offset' => $offset,
                'order' => 't.transaction_id desc'
            ));
        }

        // Prepare DataTables response
        $data = array();
        $data['draw'] = $draw;
        $data['recordsTotal'] = $count;
        $data['recordsFiltered'] = $count;
        $rowData = array();
        // print_r($model);
        $rowData = array();

        $rowData = array();

        foreach ($model as $row) {
            // Always reset per row
            $location_to = '';
            $location_from = '';
            $transfer = null; // important! reset to avoid using previous iteration's data

            if ($frm == 'DTOUT') {
                $transaction_id = is_array($row) ? $row['transaction_id'] : $row->transaction_id;

                // Fetch record only once
                $transfer = InventoryDirectTransfer::model()->findByPk($transaction_id);

                if ($transfer) {
                    $location_to = MasInventoryWarehouse::getWarehouseName($transfer->to_warehouse_id);
                    $location_from = MasInventoryWarehouse::getWarehouseName($transfer->from_warehouse_id);
                }
            }

            $transaction_date = date("d/m/Y", strtotime(is_array($row) ? $row['transaction_date'] : $row->transaction_date));

            $rowData[] = array(
                is_array($row) ? $row['transaction_id'] : $row->transaction_id,
                $transaction_date,
                is_array($row) ? $row['customer_name'] : $row->customer_name,
                is_array($row) ? $row['file_id'] : $row->file_id,
                (!$row['status']) ? "Unpackaged" : $row['status'],

                is_array($row) ? $row['status'] : $row->status,
                is_array($row) && isset($row['issue_type']) ? $row['issue_type'] : '',
                $location_to,     // ✅ use variable
                $location_from    // ✅ use variable
            );
        }



        $data['data'] = $rowData;
        $data['con'] = $condition;

        echo json_encode($data);
    }


    public function actionCreate()
    {

        $model = new PackagingList();
        $transaction_id = (int) Yii::app()->request->getParam('id');
        $frm = (int) Yii::app()->request->getParam('frm');
        $status = Yii::app()->request->getParam('status');
        if ($status != '' && $status != 'Unpackaged') {
            if ($status != 'DSI') {
                $cndn = 'transaction_id=' . $transaction_id . ' AND status="' . $status . '"';
            } else {
                $cndn = 'transaction_id=' . $transaction_id . ' AND status="D"';
            }
        } else {
            $cndn = 'transaction_id=' . $transaction_id;
        }

        $model = $model->find(array('condition' => $cndn));

        if (!empty($model)) {
            $status = $model->status;
            if (Yii::app()->request->getParam('status') == 'IDTOUT' || Yii::app()->request->getParam('status') == 'HIDTOUT' || Yii::app()->request->getParam('status') == 'DSI') {
                $status = Yii::app()->request->getParam('status');
            }
            $warehouse = 0;
            $transaction_date = date('Y-m-d');
            if ($status == 'D') {
                $model_master = DeliveryNote::model()->findByPk($transaction_id);
                $model_items = DeliveryNoteItem::model()->findAll(array('condition' => 'delivery_note_id =' . $transaction_id));
                if ($model_master->delivery_date != "0000-00-00") {
                    $transaction_date = $model_master->delivery_date;
                }
            } else if ($status == 'DSI') {
                $model_master = DeliveryNote::model()->findByPk($transaction_id);
                $model_items = DeliveryNoteItem::model()->findAll(array('condition' => 'delivery_note_id =' . $transaction_id));
                if ($model_master->delivery_date != "0000-00-00") {
                    $transaction_date = $model_master->delivery_date;
                }
            } else if ($status == 'GI') {
                $model_master = InventoryGoodsIssue::model()->findByPk($transaction_id);
                $model_items = InventoryGoodsIssueItem::model()->findAll(array('condition' => 'goods_issue_id =' . $transaction_id));
                $warehouse = $model_master->warehouse_id;
                if ($model_master->goods_issue_date != "0000-00-00") {
                    $transaction_date = $model_master->goods_issue_date;
                }
            } else if ($status == 'PDN') {
                $model_master = Purchasingdebitnote::model()->findByPk($transaction_id);
                $model_items = PurchasingdebitnoteItem::model()->findAll(array('condition' => 'purchasing_debitnote_id =' . $transaction_id));
                if ($model_master->debited_date != "0000-00-00") {
                    $transaction_date = $model_master->debited_date;
                }
            } else if ($status == 'PRGI') {
                $model_master = ProductionGoodsIssue::model()->findByPk($transaction_id);
                $model_items = ProductionGoodsIssueItem::model()->findAll(array('condition' => 'PROD_GOODS_ISSUE_id =' . $transaction_id));
                if ($model_master->goods_issue_date != "0000-00-00") {
                    $transaction_date = $model_master->goods_issue_date;
                }
            } else if ($status == 'DTOUT') {
                $model_master = InventoryDirectTransfer::model()->findByPk($transaction_id);
                $warehouse = $model_master->from_warehouse_id;
                $model_items = InventoryDirectTransferItem::model()->findAll(array('condition' => 'direct_transfer_id =' . $transaction_id));
                if ($model_master->transfer_date != "0000-00-00") {
                    $transaction_date = $model_master->transfer_date;
                }
            } else if ($status == 'IDTOUT') {
                $model_master = InventoryIndirectTransfer::model()->findByPk($transaction_id);
                $warehouse = $model_master->from_warehouse_id;
                $model_items = InventoryIndirectTransferItem::model()->findAll(array('condition' => 'indirect_transfer_id =' . $transaction_id));
                if ($model_master->transfer_date != "0000-00-00") {
                    $transaction_date = $model_master->transfer_date;
                }
            }

            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
            $this->render('create', array('model' => $model_master, 'status' => $status, 'model_items' => $model_items, 'warehouse' => $warehouse, 'transaction_date' => $transaction_date, 'frm' => $frm));
        } else {
            echo ' <table class="table table-hover table-bordered personal-task" id="package_item_table">
            <thead>
            <tr>
                    <th style="width:5px">No.</th>
                    <th style="width:5px">Warehouse</th>
                    <th style="width:5px">Available Qty (Base.Unit)</th>
                    <th style="width:5px">Rack</th>
                    <th style="width:5px">Bin</th>
                    <th style="width:10px">Picked Qty (Base.Unit)</th>
                </tr>
                <tr>
                    <th colspan="6" class="text-center">No Item Exist</th>
                </tr>
                </thead>
                </table> ';
        }
    }

    public function actionSave()
    {

        //aaded by priya 0n 11.9.24 check stocklockflag
        $modelCompanySettings = new MasCompanySettings();
        $condition = 'crm_company_id = ' . (int) Yii::app()->user->master_user_company_id;
        $modelCompanySettings = $modelCompanySettings->find(array('condition' => $condition));
        $stock_lock_flag = $modelCompanySettings->stock_lock_flag;
        if ($stock_lock_flag == "N") {

            $transaction_id = $_POST['transaction_id'];
            $package_status = $_POST['package_status'];
            if ($package_status == 'D') {
                $model = new DeliveryNote();

                $transaction_from = 'DELIVERY_NOTE';
            } else if ($package_status == 'DSI') {
                $model = new DeliveryNote();
                $transaction_from = 'DELIVERY_NOTE';
            } else if ($package_status == 'GI') {
                $model = new InventoryGoodsIssue();
                $transaction_from = 'GOODS_ISSUE';
            } else if ($package_status == 'PDN') {
                $model = new Purchasingdebitnote();
                $transaction_from = 'DEBIT_NOTE';
            } else if ($package_status == 'PRGI') {
                $model = new ProductionGoodsIssue();
                $transaction_from = 'PROD_GOODS_ISSUE';
            } else if ($package_status == 'DTOUT') {
                $model = new InventoryDirectTransfer();
                $transaction_from = 'TRANSFER_OUT';
            } else if ($package_status == 'IDTOUT') {
                $model = new InventoryIndirectTransfer();
                $transaction_from = 'INDIRECT_TRANSFER_OUT';
            }

            $model = $model->findByPk($transaction_id);
            $lead_owner_id = 0;

            $customer_vendor_id = 0;
            $file_id = 0;
            $customer_vendor_name = "";
            if ($package_status == 'D') {
                $customer_vendor_id = (int) $model->customer_id;
                if ($customer_vendor_id > 0) {
                    $customer_vendor_name = Customer::GetCustomerName($customer_vendor_id);
                }
                $file_id = (int) $model->file_id;
            } else if ($package_status == 'DSI') {
                $customer_vendor_id = (int) $model->customer_id;
                if ($customer_vendor_id > 0) {
                    $customer_vendor_name = Customer::GetCustomerName($customer_vendor_id);
                }
                $file_id = (int) $model->file_id;
            } else if ($package_status == 'GI') {
                $customer_vendor_id = (int) $model->customer_id;
                $lead_owner_id = $model->lead_owner_id;

                if ($customer_vendor_id > 0) {
                    $customer_vendor_name = Customer::GetCustomerName($customer_vendor_id);
                }
            } else if ($package_status == 'PDN') {
                $customer_vendor_id = (int) $model->vendor_id;
                if ($customer_vendor_id > 0) {
                    $customer_vendor_name = Vendor::GetVendorName($customer_vendor_id);
                }
                $file_id = (int) $model->file_id;
            } else if ($package_status == 'IDTOUT') {
                $customer_vendor_id = (int) $model->customer_id;
                if ($customer_vendor_id > 0) {
                    $customer_vendor_name = Customer::GetCustomerName($customer_vendor_id);
                }
                $file_id = (int) $model->id;
            } else if ($package_status == 'DTOUT') {
                $lead_owner_id = $model->lead_owner_id;
            }

            if (is_array($_POST['StockLedger'])) {
                $k = 0;
                $valid = TRUE;
                $flag = 0;
                $groups = array();
                $other = array();
                foreach ($_POST['StockLedger'] as $i => $item) {


                    $key = $item['product_id'] . "_" . (int) $item['master_stock_ledger_id'];

                    if (!empty($item['quantity'])) {

                        if (!array_key_exists($key, $groups)) {

                            if ($item['quantity'] && $item['unit_factor']) {
                                $qty = $item['quantity'] * $item['unit_factor'];
                            }
                            $groups[$key] = array(
                                'id' => $item['product_id'],
                                'master_stock_ledger_id' => $item['master_stock_ledger_id'],
                                'quantity' => $qty,
                                'unit_id' => $item['unit_id']
                            );
                        } else {
                            $groups[$key]['quantity'] = $groups[$key]['quantity'] + ($item['quantity'] * $item['unit_factor']);
                        }
                    }



                    //$availble_qty = Yii::app()->db->createCommand('SELECT SUM(quantity * unit_factor) as availble_qty FROM `erp_stock_ledger` WHERE product_id='.$item['product_id'])->queryScalar();

                    $arr_warehouse_qty = StockLedger::model()->findByPk((int) $item['master_stock_ledger_id']);

                    $ware_house_qty = (float) $arr_warehouse_qty['quantity'] * $arr_warehouse_qty['unit_factor'];

                    if ($ware_house_qty < 0) {
                        $ware_house_qty = 0;
                    }

                    $out_qty = (int) Yii::app()->db->createCommand('SELECT SUM(quantity * unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . $item['master_stock_ledger_id'] . ' ')->queryScalar();

                    $availble_qty = $ware_house_qty - (-1 * $out_qty);

                    if (is_numeric($item['quantity']) && $item['quantity'] > 0) {



                        $totallocatedQuantity = @AllocatedMaterial::model()->find('product_id=:product_id AND allocation_end_date>=:today', array(':product_id' => $item['product_id'], ':today' => date("Y-m-d")))->quantity;
                        $allocatedQuantityForThis = @AllocatedMaterial::model()->find('file_id=:file_id AND product_id=:product_id AND allocation_end_date>=:today', array(':file_id' => $file_id, ':product_id' => $item['product_id'], ':today' => date("Y-m-d")))->quantity;
                        $availableQty = ($availble_qty + floatval($allocatedQuantityForThis)) - $totallocatedQuantity;

                        if ($availableQty < $item['quantity']) {
                            $flag = 1;
                        }



                        $modelExistingStockLedger = StockLedger::model()->findByPk($item['master_stock_ledger_id']);

                        if ($package_status == 'D') { //delivery
                            $sum_qty_dlvd = Yii::app()->db->createCommand('SELECT IFNULL(SUM(DI.picked_qty*U.factor),0) as picked_qty FROM `erp_delivery_item` DI LEFT JOIN erp_unit_of_measurement U ON U.id=DI.unit_id
                        WHERE delivery_note_id=' . (int) $model->id . ' AND DI.product_id=' . (int) $item['product_id'] . ' AND DI.unit_id=' . (int) $item['unit_id'])->queryScalar();

                            $product = Store::model()->findByPk($key);

                            $item_unit_qty = $item['quantity'] * $item['unit_factor'];
                            // var_dump($item_unit_qty);
                            // var_dump($sum_qty_dlvd);
                            if ((int) $item_unit_qty != (int) $sum_qty_dlvd) {
                                //echo "hhhhhhhhhhhhhh";

                                $arr_uom_details = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);

                                if ((int) $item['unit_factor'] == 0) {
                                    $unit_fact = 1;
                                } else {
                                    $unit_fact = (int) $item['unit_factor'];
                                }
                                $display_qty = ($sum_qty_dlvd / $unit_fact);

                                // $other[] = $product->part_number . ' total deliverable qty : ' . (number_format($display_qty, 2)) . ' ' . $arr_uom_details->name;
                                // $valid = false;
                            }
                        }

                        if (floatval($item['quantity']) > (floatval($availble_qty))) {
                            $valid = FALSE;
                            $error[] = ' Product' . $item['part_number'] . ' has only ' . $availble_qty . ' items. Quantity should be less than available';
                        } else {
                            $modelItem[$k] = new StockLedger();

                            $modelItem[$k]->file_id = $file_id;
                            $modelItem[$k]->header_id = $model->id;
                            $modelItem[$k]->header_item_id = $item['header_item_id'];
                            $modelItem[$k]->customer_vendor_id = $customer_vendor_id;
                            $modelItem[$k]->customer_vendor_name = $customer_vendor_name;
                            $modelItem[$k]->lead_owner_id = $lead_owner_id;
                            $modelItem[$k]->product_id = $item['product_id'];
                            $modelItem[$k]->product_name = $modelExistingStockLedger->product_name;
                            $modelItem[$k]->product_description = $modelExistingStockLedger->product_description;
                            $modelItem[$k]->brand_id = $modelExistingStockLedger->brand_id;
                            $modelItem[$k]->brand_name = $modelExistingStockLedger->brand_name;
                            $modelItem[$k]->warehouse_id = $modelExistingStockLedger->warehouse_id;
                            $modelItem[$k]->warehouse_name = $modelExistingStockLedger->warehouse_name;
                            $modelItem[$k]->rack_id = $modelExistingStockLedger->rack_id;
                            $modelItem[$k]->rack_name = $modelExistingStockLedger->rack_name;
                            $modelItem[$k]->bin_id = $modelExistingStockLedger->bin_id;
                            $modelItem[$k]->bin_name = $modelExistingStockLedger->bin_name;

                            if ($package_status == 'D' && (int) $item['header_item_id'] > 0) {
                                $modelDeliveryItem = DeliveryNoteItem::model()->with('orderitem')->findByPk((int) $item['header_item_id']);
                                $modelItem[$k]->unit_id = $modelDeliveryItem->unit;
                                $modelItem[$k]->unit_name = $modelDeliveryItem->unitdetails->name;
                                $modelItem[$k]->unit_factor = $modelDeliveryItem->unitdetails->factor;
                                if ($modelDeliveryItem->unitdetails->factor > 0) {
                                    $modelItem[$k]->quantity = -1 * ($item['quantity'] / $modelDeliveryItem->unitdetails->factor);
                                } else {
                                    $modelItem[$k]->quantity = -1 * $item['quantity'];
                                }

                                $modelItem[$k]->sales_price = $modelDeliveryItem->orderitem->rate;

                                //echo $modelItem[$k]->sales_price;exit;
                            } else if ($package_status == 'DSI' || $package_status == 'D'/* && (int) $item['header_item_id'] > 0 */) {
                                $modelDeliveryItem = DeliveryNoteItem::model()->findByPk((int) $item['header_item_id']);
                                $modelItem[$k]->unit_id = $item['unit_id'];
                                $modelItem[$k]->unit_name = $item['unit_name'];
                                $modelItem[$k]->unit_factor = $item['unit_factor'];
                                /* if($modelDeliveryItem->unitdetails->factor > 0){
                                  $modelItem[$k]->quantity                = -1 * ($item['quantity'] * $modelDeliveryItem->unitdetails->factor);
                                  }
                                  else{ */
                                $modelItem[$k]->quantity = -1 * $item['quantity'];

                                //code added by mereena on 22/11/2024 to get direct invoice item rate

                                $modelDirectInvoiceItem = DirectInvoiceItem::model()->findByPk((int) $modelDeliveryItem->order_item_id);

                                $modelItem[$k]->sales_price = $modelDirectInvoiceItem->rate;

                                //end
                                //}
                                //echo $modelItem[$k]->unit_name."=".$modelItem[$k]->unit_factor."=qu=".$modelItem[$k]->quantity;
                            } else if ($package_status == 'PDN' && (int) $item['header_item_id'] > 0) {
                                $modelPurchaseDebitNoteItem = PurchasingdebitnoteItem::model()->findByPk((int) $item['header_item_id']);
                                $modelItem[$k]->unit_id = $modelPurchaseDebitNoteItem->returned_unit_id;
                                $modelItem[$k]->unit_name = $modelPurchaseDebitNoteItem->retunitdetails->name;
                                $modelItem[$k]->unit_factor = $modelPurchaseDebitNoteItem->retunitdetails->factor;
                                $modelItem[$k]->reference_id = $model->id;
                                $modelItem[$k]->reference_no = $model->purchasing_invoice_id;
                                /* if($modelPurchaseDebitNoteItem->unitdetails->factor > 0){
                                  $modelItem[$k]->quantity                = -1 * ($item['quantity']/$modelPurchaseDebitNoteItem->unitdetails->factor);
                                  }
                                  else{ */
                                $modelItem[$k]->quantity = -1 * $item['quantity'];
                                //}
                                $modelItem[$k]->buying_price = $item['sales_price'];
                            } else if ($package_status == 'GI' && (int) $item['header_item_id'] > 0) {
                                $modelGoodsIssueItem = InventoryGoodsIssueItem::model()->findByPk((int) $item['header_item_id']);
                                $modelItem[$k]->unit_id = $modelGoodsIssueItem->unit;
                                $modelItem[$k]->unit_name = $modelGoodsIssueItem->uom->name;
                                $modelItem[$k]->unit_factor = $modelGoodsIssueItem->uom->factor;
                                if ($modelGoodsIssueItem->uom->factor > 0) {
                                    $modelItem[$k]->quantity = -1 * ($item['quantity'] / $modelGoodsIssueItem->uom->factor);
                                } else {
                                    $modelItem[$k]->quantity = -1 * $item['quantity'];
                                }
                            } else if ($package_status == 'DTOUT' && (int) $item['header_item_id'] > 0) {

                                $modelDirectTransferItem = InventoryDirectTransferItem::model()->findByPk((int) $item['header_item_id']);
                                $modelItem[$k]->unit_id = $modelDirectTransferItem->unit;
                                $modelItem[$k]->unit_name = $modelDirectTransferItem->unitdetails->name;
                                $modelItem[$k]->unit_factor = $modelDirectTransferItem->unitdetails->factor;
                                if ($modelDirectTransferItem->unitdetails->factor > 0) {
                                    $modelItem[$k]->quantity = -1 * ($item['quantity'] / $modelDirectTransferItem->unitdetails->factor);
                                } else {
                                    $modelItem[$k]->quantity = -1 * $item['quantity'];
                                }
                            } else if ($package_status == 'PRGI') {

                                $modelItem[$k]->unit_id = $item['unit_id'];
                                $modelItem[$k]->unit_name = $item['unit_name'];
                                $modelItem[$k]->unit_factor = $item['unit_factor'];
                                /* if((int) $item['unit_factor'] > 0){
                                  $modelItem[$k]->quantity                = -1 * ($item['quantity']/$item['unit_factor']);
                                  }
                                  else{ */
                                $modelItem[$k]->quantity = -1 * $item['quantity'];
                                //}
                            } else {
                                $modelItem[$k]->unit_id = $modelExistingStockLedger->unit_id;
                                $modelItem[$k]->unit_name = $modelExistingStockLedger->unit_name;
                                $modelItem[$k]->unit_factor = $modelExistingStockLedger->unit_factor;
                                $modelItem[$k]->quantity = -1 * $item['quantity'];
                            }

                            /* echo "uom_id=".$modelItem[$k]->unit_id."<br>";
                              echo "unit_name=".$modelItem[$k]->unit_name."<br>";
                              echo "unit_factor=".$modelItem[$k]->unit_factor."<br>";
                              echo "quantity=".$modelItem[$k]->quantity."<br>";
                              exit; */
                            //code added by mereena on 19/07/2022

                            if ($package_status == 'D' && (int) $model->order_id > 0) {

                                $SQL_OI = "SELECT MAX(rate)  FROM `erp_order_item` WHERE product_id=" . $item['product_id'] . " AND order_id=" . (int) $model->order_id;
                                $product_max_rate = Yii::app()->db->createCommand($SQL_OI)->queryScalar();
                                $item['sales_price'] = $product_max_rate;
                            }
                            //end

                            $modelItem[$k]->available_status = 'U';
                            $modelItem[$k]->batch_no = $modelExistingStockLedger->batch_no;
                            $modelItem[$k]->serial_no = $modelExistingStockLedger->serial_no;
                            $modelItem[$k]->manufacturing_date = $modelExistingStockLedger->manufacturing_date;
                            $modelItem[$k]->expiry_date = $modelExistingStockLedger->expiry_date;
                            $modelItem[$k]->cost_price = $item['cost_price'];
                            if (!isset($modelItem[$k]->sales_price) || (int) $modelItem[$k]->sales_price == 0) {
                                $modelItem[$k]->sales_price = $item['sales_price'];
                            }
                            //$modelItem[$k]->transaction_date        = date("Y-m-d");
                            $modelItem[$k]->transaction_date = $item['transaction_date'];

                            if (!empty($item['batch_date'])) {
                                $modelItem[$k]->batch_date = $item['batch_date'];
                            } else {
                                $modelItem[$k]->batch_date = '0000-00-00';
                            }
                            $modelItem[$k]->transaction_from = $transaction_from;
                            $modelItem[$k]->transaction_type = "OUT";

                            $modelItem[$k]->master_stock_ledger_id = $item['master_stock_ledger_id'];
                            $modelItem[$k]->created_by = Yii::app()->user->id;
                            $modelItem[$k]->created_date = date("Y-m-d H:i:s");

                            if ($package_status == 'DTOUT') {
                                $modelItem[$k]->to_rack_id = $_POST['Data'][$i]['to_rack_id'];
                                $modelItem[$k]->to_bin_id = $_POST['Data'][$i]['to_bin_id'];
                                $modelItem[$k]->to_warehouse_id = $_POST['Data'][$i]['to_warehouse_id'];
                            }

                            if ($package_status == 'IDTOUT') {
                                $modelItem[$k]->to_rack_id = $_POST['Data'][$i]['to_rack_id'];
                                $modelItem[$k]->to_bin_id = $_POST['Data'][$i]['to_bin_id'];
                                $modelItem[$k]->to_warehouse_id = $_POST['Data'][$i]['to_warehouse_id'];
                            }

                            $k++;
                        }
                    }
                }
                //echo "hi";
                // exit;
                // QTY Checking
                if (!empty($groups)) {
                    foreach ($groups as $key => $eachProduct) {

                        $arr_warehouse_qty = StockLedger::model()->findByPk((int) $eachProduct['master_stock_ledger_id']);

                        $ware_house_qty = (float) $arr_warehouse_qty['quantity'] * $arr_warehouse_qty['unit_factor'];

                        /* $sum_qty_dlvd = Yii::app()->db->createCommand('SELECT IFNULL(SUM(DI.picked_qty*U.factor),0) as picked_qty FROM `erp_delivery_item` DI LEFT JOIN erp_unit_of_measurement U ON U.id=DI.unit
                          WHERE delivery_note_id='.(int)$model->id.' AND DI.product_id='.(int)$eachProduct['id'].' AND DI.unit='.(int)$eachProduct['unit_id'])->queryScalar();

                          $product=Store::model()->findByPk($key);
                          if((int)$eachProduct['quantity']!=(int)$sum_qty_dlvd){
                          //echo "hhhhhhhhhhhhhh";
                          $other[]=$product->part_number.' total deliverable qty : '.(number_format($sum_qty_dlvd,2)).' '.$product->unit->unit_name;
                          $valid=false;
                          } */



                        if ($ware_house_qty < 0) {
                            $ware_house_qty = 0;
                        }

                        $out_qty = (int) Yii::app()->db->createCommand('SELECT SUM(quantity * unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . (int) $eachProduct['master_stock_ledger_id'] . ' ')->queryScalar();

                        $availble_qty = $ware_house_qty - (-1 * $out_qty);

                        if (!empty($eachProduct['quantity']) && ($eachProduct['quantity'] > $availble_qty)) {
                            $other[] = $arr_warehouse_qty['product_name'] . ' maximum sellable qty : ' . ($availble_qty);
                            $valid = false;
                        }
                    }
                }

                if ($valid && $flag == 0) {



                    $check_sales_group = 0;
                    if ($package_status == 'D') {
                        $model->ready_to_invoice = 'Y';
                        if ($_REQUEST['frm'] == 3) {
                            $model->delivery_type = 'service';

                        }
                        // $model->driver_name = $_POST['DeliveryNote']['driver_name'];
                        $model->save(false);

                        // inserting to audit log
                        if ($model->id > 0) {
                            AuditLog::saveAuditLogs(
                                'DELIVERY_NOTE',
                                Yii::app()->user->id,
                                'CREATED',
                                " with DLVRY Note No: - {$model->id}  "
                            );
                            // end audit log
                        }
                    } else if ($package_status == 'DSI') {
                        $model->ready_to_invoice = 'Y';
                        $model->driver_name = $_POST['DeliveryNote']['driver_name'];
                        $model->save(false);

                        // inserting to audit log
                        if ($model->id > 0) {
                            AuditLog::saveAuditLogs(
                                'DELIVERY_NOTE',
                                Yii::app()->user->id,
                                'CREATED',
                                " with DLVRY Note No: - {$model->id}  "
                            );
                            // end audit log
                        }
                        //Invoice CREATE start
                        $modelDI = DirectInvoice::model()->find(array('condition' => 'reference=' . (int) $model->id));
                        if (!empty($modelDI)) {
                            $modelInvoice = new Invoice();
                            $modelInvoice->created_by = Yii::app()->user->id;
                            $modelInvoice->created_datetime = date('Y-m-d H:i:s');
                            $modelInvoice->file_id = $model->file_id;
                            $modelInvoice->delivery_ids = $model->id;
                            $total = $net_total = $tot_tax = 0;
                            $modelInvoice->exchange_rate = 1;
                            $modelInvoice->currency = Yii::app()->user->company_base_currency;
                            $modelInvoice->contact_id = $model->contact_id;
                            $modelInvoice->customer_id = $model->customer_id;
                            $modelInvoice->lead_owner_id = Yii::app()->user->id;
                            $modelInvoice->sales_group = 1;
                            $modelInvoice->custom_invoice_no = $modelDI->custom_invoice_no;
                            $modelInvoice->order_id = $modelDI->id;
                            $modelInvoice->terms_and_conditions = $modelDI->terms_and_conditions;
                            $modelInvoice->invoice_date = $modelDI->invoice_date;
                            $modelInvoice->invoice_type = $modelDI->invoice_type;
                            $modelInvoice->payment_terms = $modelDI->payment_terms;
                            $modelInvoice->crm_user_id = Yii::app()->user->id;
                            $modelInvoice->is_direct_invoice = "Y";
                            $modelInvoice->save(false);
                            $modelInvoice->refresh();
                            $grand_total = $tot_tax = 0;
                            $actual_item_quantity = 0;
                            $modelDirectInvoiceItem = DirectInvoiceItem::model()->findAll(array('condition' => 'invoice_id =' . (int) $modelDI->id));
                            if (!empty($modelDirectInvoiceItem)) {
                                foreach ($modelDirectInvoiceItem as $i => $item) {

                                    $modeInvoicelItem[$i] = new InvoiceItem;
                                    $modeInvoicelItem[$i]->product_id = $item['product_id'];
                                    $modeInvoicelItem[$i]->invoice_item_type = 'D';
                                    $modeInvoicelItem[$i]->order_item_id = $item['id'];
                                    $modeInvoicelItem[$i]->invoice_id = $modelInvoice->id;
                                    $modeInvoicelItem[$i]->description = $item['description'];
                                    $modeInvoicelItem[$i]->quantity = $item['quantity'];
                                    $modeInvoicelItem[$i]->bonus_qty = 0;
                                    $modeInvoicelItem[$i]->picked_qty = $item['quantity'];
                                    $modeInvoicelItem[$i]->rate = $item['rate'];
                                    $modeInvoicelItem[$i]->amount = $item['amount'];
                                    $modeInvoicelItem[$i]->id = 0;
                                    $modeInvoicelItem[$i]->tax_vat_amount = $item['tax_vat_amount'];
                                    $modeInvoicelItem[$i]->tax_vat_percentage = $item['tax_vat_percentage'];
                                    $modeInvoicelItem[$i]->deduction_amount = $item['deduction_amount'];
                                    //$modeInvoicelItem[$i]->net_amount = ($item['rate'] - $item['deduction_amount']) * $item['quantity'];
                                    $modeInvoicelItem[$i]->net_amount = $item['net_amount'];
                                    $modeInvoicelItem[$i]->unit_id = $item['unit_id'];
                                    $tot_tax += $item['tax_vat_amount'];
                                    $grand_total += ($item['amount'] + $item['tax_vat_amount']);
                                    $modeInvoicelItem[$i]->save(false);
                                }
                                $modelInvoice->updateByPk($modelInvoice->id, array('grand_total' => $grand_total, 'total_tax_amount' => $tot_tax, 'invoice_no' => $modelInvoice->id));
                                DirectInvoice::model()->updateByPk((int) $modelDI->id, array('posted' => 'Y', 'invoice_id' => (int) $modelInvoice->id));
                            }
                        }
                        //Invoice Create end
                    } else if ($package_status == 'GI') {
                        $model->stock_updated = 'Y';
                        $model->save(false);
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'ISSUES',
                            Yii::app()->user->id,
                            'CREATED',
                            " with Issue No: - {$model->id}  "
                        );
                        // end audit log
                    } else if ($package_status == 'PDN') {
                        $model->is_goods_returned = 'Y';
                        $model->save(false);
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'PURCHASE_RETURN',
                            Yii::app()->user->id,
                            'CREATED',
                            " with Return No: - {$model->id}  "
                        );
                        // end audit log
                    } else if ($package_status == 'PRGI') {
                        $model->is_goods_issued = 'Y';
                        $model->save(false);
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'GOODS_ISSUE',
                            Yii::app()->user->id,
                            'CREATED',
                            " with GI No: - {$model->id}  "
                        );
                        // end audit log
                    } else if ($package_status == 'DTOUT') {
                        $model->status = 'C';
                        $model->save(false);
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'DIRECT_TRANSFER',
                            Yii::app()->user->id,
                            'CREATED',
                            " with Checkin No: - {$model->id}  "
                        );
                        // end audit log
                    } else if ($package_status == 'IDTOUT') {
                        $model->is_complete = 'P';
                        $model->status = 'TO';
                        $model->save(false);
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'INDIRECT_TRANSFER',
                            Yii::app()->user->id,
                            'CREATED',
                            " with Checkin No: - {$model->id}  "
                        );
                        // end audit log
                    }
                    foreach ($modelItem as $w => $eachModel) {

                        $arr_stock_ledger_data = $eachModel;

                        /*                         * ************* Code added by Mereena on 28/11/2018 for purchase return cost rate updating************************* */
                        if ($package_status == 'PDN') {
                            $product_id = $eachModel->product_id;
                            /*                             * ************** Start get debit note item details ****************** */
                            $arr_debit_note_item_details = PurchasingdebitnoteItem::model()->find(array('condition' => 'purchasing_debitnote_id=' . $transaction_id . ' AND product_id=' . $product_id));
                            //echo "returned_amt=".$return_amt;
                            /*                             * ******************* End ***************************************** */

                            $old_total_qty = Yii::app()->db->createCommand('SELECT SUM(quantity*unit_factor) FROM  erp_stock_ledger WHERE product_id=' . $product_id . ' ')->queryScalar();
                            $returned_qty = -1 * ($eachModel->quantity);
                            $return_amt = $arr_debit_note_item_details->rate * $returned_qty;
                            $arr_product_details = Store::model()->findbyPk($product_id);
                            $old_cost_rate = $arr_product_details->rate;
                            $old_amt = $old_cost_rate * $old_total_qty;
                            $new_qty = $old_total_qty - $returned_qty;
                            if ($new_qty > 0) {
                                $cost_rate = ($old_amt - $return_amt) / $new_qty;
                            } else {
                                $cost_rate = $old_cost_rate;
                            }

                            $eachModel->cost_price = $old_cost_rate; //$cost_rate
                            //$arr_product_details->updateByPk($product_id, array('rate' => $cost_rate));
                        }
                        /*                         * ************************** Code end by mereena on 28/11/2018 for purchase return cost rate updating********************************* */


                        if (($package_status == 'D' || $package_status == 'DSI') && (int) $file_id > 0) {

                            //Deallocate products
                            $modelAllocate = new AllocatedMaterial();
                            $modelAllocate = $modelAllocate->find(array('condition' => 'file_id=' . (int) $file_id . ' AND product_id=' . $eachModel->product_id));
                            if (is_countable($modelAllocate) && (!empty($modelAllocate))) {

                                if ($eachModel->quantity == $modelAllocate['quantity']) {
                                    $modelDelAllocate = new AllocatedMaterial();
                                    $modelDelAllocate->deleteByPk($modelAllocate['id']);
                                } else {

                                    $eachItemQuantity = -1 * $eachModel->quantity;
                                    $new_allocate_qty = $modelAllocate['quantity'] - $eachItemQuantity;

                                    if ((int) $new_allocate_qty > 0) {
                                        $modelAllocateQty = new AllocatedMaterial();
                                        $modelAllocateQty->updateByPk($modelAllocate['id'], array('quantity' => $new_allocate_qty));
                                    } else {
                                        $modelDelAllocate = new AllocatedMaterial();
                                        $modelDelAllocate->deleteByPk($modelAllocate['id']);
                                    }
                                }
                            }
                            //End
                        }





                        /* if ($package_status == 'DTOUT') {
                          $eachModel->stock_updated = 'N';
                          } */
                        if ($package_status == 'DTOUT') {

                            $modelTransferInStockLedger = new StockLedger();
                            $modelTransferInStockLedger->file_id = $eachModel->file_id;
                            $modelTransferInStockLedger->header_id = $eachModel->header_id;
                            $modelTransferInStockLedger->header_item_id = $eachModel->header_item_id;
                            $modelTransferInStockLedger->customer_vendor_id = $customer_vendor_id;
                            $modelTransferInStockLedger->customer_vendor_name = $customer_vendor_name;
                            $modelTransferInStockLedger->lead_owner_id = $lead_owner_id;
                            $modelTransferInStockLedger->product_id = $eachModel->product_id;
                            $modelTransferInStockLedger->product_name = $eachModel->product_name;
                            $modelTransferInStockLedger->product_description = $eachModel->product_description;
                            $modelTransferInStockLedger->brand_id = $eachModel->brand_id;
                            $modelTransferInStockLedger->brand_name = $eachModel->brand_name;
                            $modelTransferInStockLedger->warehouse_id = $eachModel->to_warehouse_id;
                            $modelTransferInStockLedger->warehouse_name = MasInventoryWarehouse::getWarehouseName($eachModel->to_warehouse_id);
                            ;
                            $modelTransferInStockLedger->rack_id = $eachModel->to_rack_id;
                            $modelTransferInStockLedger->rack_name = MasInvRack::getRackName($eachModel->to_rack_id);
                            $modelTransferInStockLedger->bin_id = $eachModel->to_bin_id;
                            $modelTransferInStockLedger->bin_name = MasInvBin::getBinName($eachModel->to_bin_id);
                            $modelTransferInStockLedger->unit_id = $eachModel->unit_id;
                            $modelTransferInStockLedger->unit_name = $eachModel->unit_name;
                            $modelTransferInStockLedger->unit_factor = abs($eachModel->unit_factor);
                            $modelTransferInStockLedger->quantity = abs($eachModel->quantity);
                            $modelTransferInStockLedger->available_status = 'A';
                            $modelTransferInStockLedger->batch_no = $eachModel->batch_no;
                            $modelTransferInStockLedger->batch_date = $eachModel->batch_date;
                            $modelTransferInStockLedger->serial_no = $eachModel->serial_no;
                            $modelTransferInStockLedger->manufacturing_date = $eachModel->manufacturing_date;
                            $modelTransferInStockLedger->expiry_date = $eachModel->expiry_date;
                            $modelTransferInStockLedger->cost_price = $eachModel->cost_price;
                            $modelTransferInStockLedger->sales_price = $eachModel->sales_price;
                            //$modelTransferInStockLedger->transaction_date       =   date('Y-m-d');
                            $modelTransferInStockLedger->transaction_date = $eachModel->transaction_date;
                            $modelTransferInStockLedger->transaction_from = 'DIRECT_TRANSFER_IN';
                            $modelTransferInStockLedger->transaction_type = "IN";
                            $modelTransferInStockLedger->created_by = Yii::app()->user->id;
                            $modelTransferInStockLedger->created_date = date("Y-m-d H:i:s");
                            //OUT data save into stockledger
                            $eachModel->save(false);
                            //IN data save into stock ledger
                            $modelTransferInStockLedger->master_stock_ledger_id = $eachModel->id;
                            $modelTransferInStockLedger->save(false);
                        } else if ($package_status == 'IDTOUT') {
                            $modelTransferInStockLedger = new StockLedger();
                            $modelTransferInStockLedger->file_id = $eachModel->file_id;
                            $modelTransferInStockLedger->header_id = $eachModel->header_id;
                            $modelTransferInStockLedger->header_item_id = $eachModel->header_item_id;
                            $modelTransferInStockLedger->customer_vendor_id = $eachModel->customer_vendor_id;
                            $modelTransferInStockLedger->customer_vendor_name = $eachModel->customer_vendor_name;
                            $modelTransferInStockLedger->product_id = $eachModel->product_id;
                            $modelTransferInStockLedger->product_name = $eachModel->product_name;
                            $modelTransferInStockLedger->product_description = $eachModel->product_description;
                            $modelTransferInStockLedger->brand_id = $eachModel->brand_id;
                            $modelTransferInStockLedger->brand_name = $eachModel->brand_name;
                            $modelTransferInStockLedger->warehouse_id = $eachModel->to_warehouse_id;
                            $modelTransferInStockLedger->warehouse_name = MasInventoryWarehouse::getWarehouseName($eachModel->to_warehouse_id);
                            ;
                            $modelTransferInStockLedger->rack_id = $eachModel->to_rack_id;
                            $modelTransferInStockLedger->rack_name = MasInvRack::getRackName($eachModel->to_rack_id);
                            $modelTransferInStockLedger->bin_id = $eachModel->to_bin_id;
                            $modelTransferInStockLedger->bin_name = MasInvBin::getBinName($eachModel->to_bin_id);
                            $modelTransferInStockLedger->unit_id = $eachModel->unit_id;
                            $modelTransferInStockLedger->unit_name = $eachModel->unit_name;
                            $modelTransferInStockLedger->unit_factor = abs($eachModel->unit_factor);
                            $modelTransferInStockLedger->quantity = abs($eachModel->quantity);
                            $modelTransferInStockLedger->available_status = 'A';
                            $modelTransferInStockLedger->batch_no = $eachModel->batch_no;
                            $modelTransferInStockLedger->batch_date = $eachModel->batch_date;
                            $modelTransferInStockLedger->serial_no = $eachModel->serial_no;
                            $modelTransferInStockLedger->manufacturing_date = $eachModel->manufacturing_date;
                            $modelTransferInStockLedger->expiry_date = $eachModel->expiry_date;
                            $modelTransferInStockLedger->cost_price = $eachModel->cost_price;
                            $modelTransferInStockLedger->sales_price = $eachModel->sales_price;
                            //$modelTransferInStockLedger->transaction_date       =   date('Y-m-d');
                            $modelTransferInStockLedger->transaction_date = $eachModel->transaction_date;
                            $modelTransferInStockLedger->transaction_from = 'INDIRECT_TRANSFER_IN';
                            $modelTransferInStockLedger->transaction_type = "IN";
                            $modelTransferInStockLedger->created_by = Yii::app()->user->id;
                            $modelTransferInStockLedger->created_date = date("Y-m-d H:i:s");
                            //OUT data save into stockledger
                            $eachModel->save(false);
                            //IN data save into stock ledger
                            $modelTransferInStockLedger->master_stock_ledger_id = $eachModel->id;
                            $modelTransferInStockLedger->save(false);
                        } else {
                            $eachModel->save(false);

                            if ($package_status == 'D') {
                                $second_factor = $eachModel->unit_factor;
                                if ((int) $second_factor == 0) {
                                    $second_factor = 1;
                                }


                                //Store::model()->updateByPK($eachModel->product_id, array('selling_price_1' =>($eachModel->sales_price/$second_factor),'selling_price_2' =>$eachModel->sales_price));
                            }
                        }

                        if (!empty($eachModel->serial_no)) {
                            StockLedger::model()->updateByPK($eachModel->master_stock_ledger_id, array('available_status' => 'U'));
                        } else {
                            $out_qty = Yii::app()->db->createCommand('SELECT SUM(quantity*unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . $eachModel->master_stock_ledger_id . ' ')->queryScalar();
                            $arr_existing_stock_ledger = StockLedger::model()->findByPK($eachModel->master_stock_ledger_id);
                            $delivered_qty = (-1 * $out_qty);
                            if (($arr_existing_stock_ledger->quantity * $arr_existing_stock_ledger->unit_factor) == $delivered_qty) {
                                StockLedger::model()->updateByPK($eachModel->master_stock_ledger_id, array('available_status' => 'U'));
                            } else {
                                StockLedger::model()->updateByPK($eachModel->master_stock_ledger_id, array('available_status' => 'A'));
                            }
                        }
                    }
                    //Updating status in delivery
                    if ($package_status == 'D') {
                        DeliveryNote::model()->updateByPK($transaction_id, array('status' => 'CL', 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d h:i:s')));
                    }
                    if ($package_status == 'DSI') {
                        DeliveryNote::model()->updateByPK($transaction_id, array('invoiced' => 'Y', 'status' => 'CL', 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d h:i:s')));
                    }
                    // ----------added-by-indhu-30-12-2022---------------------------
                    if ($package_status == 'PDN') {
                        Yii::import('application.modules.accounts.controllers.PostingController');
                        $from = 'debitnote';
                        PostingController::DirectPost((int) $transaction_id, $from);
                    }
                    // ---------------------------------------------------------------
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                } else {
                    //$error = CJSON::encode($error);
                    $error = array();
                    if ($flag == 1) {
                        $error[] = "Insufficient Quantity";
                    }

                    //$error = CJSON::encode($error);

                    $error = CJSON::encode(array_merge_recursive($error, $other));
                    if ($error != '[]')
                        echo $error;
                }
            }
        } else {
            echo CJSON::encode(array('error' => ' Transactions are already locked!'));
        }
    }

    //* Added By jisha - automatic allocation --27-6-22*//
    public function actionAutoSave()
    {

        //aaded by priya 0n 11.9.24 check stocklockflag
        $modelCompanySettings = new MasCompanySettings();
        $condition = 'crm_company_id = ' . (int) Yii::app()->user->master_user_company_id;
        $modelCompanySettings = $modelCompanySettings->find(array('condition' => $condition));
        $modMasCompany = new MasCompany();
        $modMasCompany = $modMasCompany->findBYPK((int) Yii::app()->user->master_user_company_id);
        $package_cost_type = $modMasCompany->packaging_cost;
        $stock_lock_flag = $modelCompanySettings->stock_lock_flag;
        if ($stock_lock_flag == "N") {
            $transaction_id = $_POST['transaction_id'];
            $package_status = $_POST['package_status'];
            if ($package_status == 'D') {
                $model = new DeliveryNote();
                $transaction_from = 'DELIVERY_NOTE';
            } else if ($package_status == 'DSI') {
                $model = new DeliveryNote();
                $transaction_from = 'DELIVERY_NOTE';
            } else if ($package_status == 'GI') {
                $model = new InventoryGoodsIssue();
                $transaction_from = 'GOODS_ISSUE';
            } else if ($package_status == 'PDN') {
                $model = new Purchasingdebitnote();
                $transaction_from = 'DEBIT_NOTE';
            } else if ($package_status == 'PRGI') {
                $model = new ProductionGoodsIssue();
                $transaction_from = 'PROD_GOODS_ISSUE';
            } else if ($package_status == 'DTOUT') {
                $model = new InventoryDirectTransfer();
                $transaction_from = 'TRANSFER_OUT';
            } else if ($package_status == 'IDTOUT') {
                $model = new InventoryIndirectTransfer();
                $transaction_from = 'INDIRECT_TRANSFER_OUT';
            }

            $model = $model->findByPk($transaction_id);
            $customer_vendor_id = 0;
            $file_id = 0;
            $customer_vendor_name = "";
            if ($package_status == 'D') {
                $customer_vendor_id = (int) $model->customer_id;
                if ($customer_vendor_id > 0) {
                    $customer_vendor_name = Customer::GetCustomerName($customer_vendor_id);
                }
                $file_id = (int) $model->file_id;
            } else if ($package_status == 'DSI') {
                $customer_vendor_id = (int) $model->customer_id;
                if ($customer_vendor_id > 0) {
                    $customer_vendor_name = Customer::GetCustomerName($customer_vendor_id);
                }
                $file_id = (int) $model->file_id;
            } else if ($package_status == 'GI') {
                $customer_vendor_id = (int) $model->customer_id;
                if ($customer_vendor_id > 0) {
                    $customer_vendor_name = Customer::GetCustomerName($customer_vendor_id);
                }
            } else if ($package_status == 'PDN') {
                $customer_vendor_id = (int) $model->vendor_id;
                if ($customer_vendor_id > 0) {
                    $customer_vendor_name = Vendor::GetVendorName($customer_vendor_id);
                }
                $file_id = (int) $model->file_id;
            } else if ($package_status == 'DTOUT') {
                $lead_owner_id = $model->lead_owner_id;
            }

            if (is_array($_POST['StockLedger'])) {
                $k = 0;
                $valid = TRUE;
                $flag = 0;
                $groups = array();
                //added By jisha on 17-05-22 start
                $productgroups = array();
                //added By jisha on 17-05-22 end
                $other = array();
                $balance = 0;
                if ($package_status == 'D' || $package_status == 'DSI') {
                    if ($model->status == 'CL') {
                        $other[] = 'DeliveryNote Already Completed Packaging';
                        $valid = false;
                    }
                    if ($model->status == 'CN') {
                        $other[] = 'DeliveryNote Already Cancelled';
                        $valid = false;
                    }
                }
                foreach ($_POST['StockLedger'] as $i => $item) {

                    // echo $item['quantity'];echo "unit_factor=".$item['unit_factor'];
                    // echo ($item['quantity'] * $item['unit_factor']);
                    // exit;

                    $item_qty = ((float) $item['quantity'] * (float) $item['unit_factor']);
                    if ($item_qty > 0) {
                        $cond_pack = 'quantity>0 AND product_id=' . (int) $item['product_id'];
                        if ($item['warehouse_id'] > 0) {
                            $cond_pack .= ' AND warehouse_id = ' . (int) $item['warehouse_id'] . '';
                        }
                        if (!empty($item['batch_no'])) {
                            $cond_pack .= ' AND batch_no = "' . $item['batch_no'] . '"';
                        }
                        $product_items = StockLedger::model()->findAll(array('condition' => $cond_pack, 'order' => 'transaction_date ASC'));

                        //echo '<pre>';
                        //print_r($item);exit;

                        $total_qty = (int) Yii::app()->db->createCommand('SELECT SUM(quantity * unit_factor) FROM  erp_stock_ledger WHERE ' . $cond_pack . '')->queryScalar();
                        if ($total_qty >= $item_qty) {
                            $balance = $item_qty;
                            $mflag = 0;
                            //added By jisha on 17-05-22 start
                            $pkey = $item['product_id'] . '_' . $item['unit_id'];
                            if (!array_key_exists($pkey, $productgroups)) {
                                $productgroups[$pkey] = array(
                                    'id' => $item['product_id'],
                                    'quantity' => $item['quantity'] * $item['unit_factor'],
                                    'unit_id' => $item['unit_id'],
                                    'unit_factor' => $item['unit_factor']
                                );
                            } else {
                                $productgroups[$pkey]['quantity'] = $productgroups[$pkey]['quantity'] + ($item['quantity'] * $item['unit_factor']);
                            }
                            //added By jisha on 17-05-22 end


                            foreach ($product_items as $eachstockledgerentry) {
                                if ($mflag == 1) {
                                    break;
                                }
                                $out_qty = (int) Yii::app()->db->createCommand('SELECT SUM(quantity * unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . $eachstockledgerentry['id'] . ' ')->queryScalar();
                                $availble_qty = $stock_ledger_quantity = ($eachstockledgerentry['quantity'] * $eachstockledgerentry['unit_factor']) - (-1 * $out_qty);
                                if ($stock_ledger_quantity > 0) {
                                    if (($stock_ledger_quantity >= $balance)) {
                                        $picked_qty = $balance;
                                        $mflag = 1;
                                    } else {
                                        $picked_qty = $stock_ledger_quantity;
                                        $balance = $balance - $stock_ledger_quantity;
                                    }
                                    $key = $item['product_id'] . "_" . (int) $eachstockledgerentry['id'];
                                    if (!array_key_exists($key, $groups)) {
                                        $groups[$key] = array(
                                            'id' => $item['product_id'],
                                            'master_stock_ledger_id' => $eachstockledgerentry['id'],
                                            'quantity' => ($picked_qty),
                                            'unit_id' => $item['unit_id'],
                                            'unit_factor' => 1
                                        );
                                    } else {
                                        $groups[$key]['quantity'] = $groups[$key]['quantity'] + ($picked_qty);
                                    }

                                    $modelExistingStockLedger = StockLedger::model()->findByPk($eachstockledgerentry['id']);
                                    $product = Store::model()->findByPk((int) $item['product_id']);

                                    //stockledger entry
                                    $modelItem[$k] = new StockLedger();
                                    $modelItem[$k]->file_id = (int) $file_id;
                                    $modelItem[$k]->header_id = $model->id;
                                    $modelItem[$k]->header_item_id = $item['header_item_id'];
                                    $modelItem[$k]->customer_vendor_id = $customer_vendor_id;
                                    $modelItem[$k]->customer_vendor_name = $customer_vendor_name;
                                    $modelItem[$k]->lead_owner_id = $item['lead_owner_id'];

                                    $modelItem[$k]->product_id = $item['product_id'];
                                    $modelItem[$k]->product_name = $modelExistingStockLedger->product_name;
                                    $modelItem[$k]->product_description = $modelExistingStockLedger->product_description;
                                    $modelItem[$k]->brand_id = $modelExistingStockLedger->brand_id;
                                    $modelItem[$k]->brand_name = $modelExistingStockLedger->brand_name;
                                    $modelItem[$k]->warehouse_id = $modelExistingStockLedger->warehouse_id;
                                    $modelItem[$k]->warehouse_name = $modelExistingStockLedger->warehouse_name;
                                    $modelItem[$k]->rack_id = $modelExistingStockLedger->rack_id;
                                    $modelItem[$k]->rack_name = $modelExistingStockLedger->rack_name;
                                    $modelItem[$k]->bin_id = $modelExistingStockLedger->bin_id;
                                    $modelItem[$k]->bin_name = $modelExistingStockLedger->bin_name;

                                    if ($package_status == 'D' /* && (int) $item['header_item_id'] > 0 */) {
                                        if ((int) $item['header_item_id'] > 0) {
                                            $modelDeliveryItem = DeliveryNoteItem::model()->findByPk((int) $item['header_item_id']);
                                            $modelItem[$k]->sales_price = $modelDeliveryItem->orderitem->rate;
                                        }
                                        $modelItem[$k]->unit_id = $item['unit_id'];
                                        $modelItem[$k]->unit_name = $item['unit_name'];
                                        $modelItem[$k]->unit_factor = $item['unit_factor'];
                                        if ($item['unit_factor'] > 0) {
                                            $modelItem[$k]->quantity = -1 * ($picked_qty / $item['unit_factor']);
                                        } else {
                                            $modelItem[$k]->quantity = -1 * $picked_qty;
                                        }
                                    } else if ($package_status == 'DSI'/* && (int) $item['header_item_id'] > 0 */) {
                                        if ((int) $item['header_item_id'] > 0) {
                                            $modelDeliveryItem = DeliveryNoteItem::model()->findByPk((int) $item['header_item_id']);
                                            $modelDirectInvoiceItem = DirectInvoiceItem::model()->findByPk((int) $modelDeliveryItem->order_item_id);
                                            $modelItem[$k]->sales_price = $modelDirectInvoiceItem->rate;
                                        }
                                        $modelDeliveryItem = DeliveryNoteItem::model()->findByPk((int) $item['header_item_id']);
                                        $modelItem[$k]->unit_id = $item['unit_id'];
                                        $modelItem[$k]->unit_name = $item['unit_name'];
                                        $modelItem[$k]->unit_factor = $item['unit_factor'];
                                        if ($item['unit_factor'] > 0) {
                                            $modelItem[$k]->quantity = -1 * ($picked_qty / $item['unit_factor']);
                                        } else {
                                            $modelItem[$k]->quantity = -1 * $picked_qty;
                                        }
                                    } else if ($package_status == 'PDN' && (int) $item['header_item_id'] > 0) {
                                        $modelPurchaseDebitNoteItem = PurchasingdebitnoteItem::model()->findByPk((int) $item['header_item_id']);
                                        $modelItem[$k]->unit_id = $modelPurchaseDebitNoteItem->returned_unit_id;
                                        $modelItem[$k]->unit_name = $modelPurchaseDebitNoteItem->retunitdetails->name;
                                        $modelItem[$k]->unit_factor = $modelPurchaseDebitNoteItem->retunitdetails->factor;
                                        if ($modelPurchaseDebitNoteItem->retunitdetails->factor > 0) {
                                            $modelItem[$k]->quantity = -1 * ($picked_qty / $modelPurchaseDebitNoteItem->retunitdetails->factor);
                                            $modelItem[$k]->buying_price = $item['sales_price'] / $modelPurchaseDebitNoteItem->retunitdetails->factor;
                                        } else {
                                            $modelItem[$k]->quantity = -1 * $picked_qty;
                                            $modelItem[$k]->buying_price = $item['sales_price'];
                                        }


                                        $modelItem[$k]->reference_id = $model->id;
                                        $modelItem[$k]->reference_no = $model->purchasing_invoice_id;
                                    } else if ($package_status == 'GI' && (int) $item['header_item_id'] > 0) {
                                        $modelGoodsIssueItem = InventoryGoodsIssueItem::model()->findByPk((int) $item['header_item_id']);
                                        $modelItem[$k]->unit_id = $modelGoodsIssueItem->unit;
                                        $modelItem[$k]->unit_name = $modelGoodsIssueItem->uom->name;
                                        $modelItem[$k]->unit_factor = $modelGoodsIssueItem->uom->factor;
                                        // -------added by indhu on 26_10_2023------------------
                                        // --------------------------
                                        if ($modelGoodsIssueItem->uom->factor > 0) {
                                            $modelItem[$k]->quantity = -1 * ($picked_qty / $modelGoodsIssueItem->uom->factor);
                                        } else {
                                            $modelItem[$k]->quantity = -1 * $picked_qty;
                                        }

                                        $modelItem[$k]->reference_id = $model->id;
                                        $modelItem[$k]->reference_no = $model->reference;
                                    } else if ($package_status == 'DTOUT' && (int) $item['header_item_id'] > 0) {

                                        $modelDirectTransferItem = InventoryDirectTransferItem::model()->findByPk((int) $item['header_item_id']);
                                        $modelItem[$k]->unit_id = $modelDirectTransferItem->unit;
                                        $modelItem[$k]->unit_name = $modelDirectTransferItem->unitdetails->name;
                                        $modelItem[$k]->unit_factor = $modelDirectTransferItem->unitdetails->factor;
                                        if ($modelDirectTransferItem->unitdetails->factor > 0) {
                                            $modelItem[$k]->quantity = -1 * ($picked_qty / $modelDirectTransferItem->unitdetails->factor);
                                        } else {
                                            $modelItem[$k]->quantity = -1 * $picked_qty;
                                        }
                                    } else {
                                        $modelItem[$k]->unit_id = $modelExistingStockLedger->unit_id;
                                        $modelItem[$k]->unit_name = $modelExistingStockLedger->unit_name;
                                        $modelItem[$k]->unit_factor = $modelExistingStockLedger->unit_factor;
                                        $modelItem[$k]->quantity = -1 * $picked_qty;
                                        if ($modelExistingStockLedger->unit_factor > 0) {
                                            $modelItem[$k]->quantity = -1 * ($picked_qty / $modelExistingStockLedger->unit_factor);
                                        } else {
                                            $modelItem[$k]->quantity = -1 * $picked_qty;
                                        }
                                    }

                                    $modelItem[$k]->available_status = 'A';
                                    //$modelItem[$k]->batch_no = $modelExistingStockLedger->batch_no;
                                    $modelItem[$k]->batch_no = $item['batch_no'];
                                    $modelItem[$k]->batch_date = $item['batch_date'];

                                    $modelItem[$k]->serial_no = $modelExistingStockLedger->serial_no;
                                    $modelItem[$k]->manufacturing_date = $modelExistingStockLedger->manufacturing_date;
                                    $modelItem[$k]->expiry_date = $modelExistingStockLedger->expiry_date;

                                    if ($package_cost_type == 'FIFO' && ($package_status == 'DSI' || $package_status == 'D' || $package_status == 'GI')) {
                                        // $modelItem[$k]->cost_price = $modelExistingStockLedger->buying_price;
                                        $modelItem[$k]->cost_price = $modelExistingStockLedger->cost_price; // changed by habeeb due to purchase LC

                                    } else {
                                        $modelItem[$k]->cost_price = $eachstockledgerentry->product->rate;
                                    }

                                    if (!isset($modelItem[$k]->sales_price) || (int) $modelItem[$k]->sales_price == 0) {
                                        $modelItem[$k]->sales_price = $item['sales_price'];
                                    }
                                    //$modelItem[$k]->sales_price = $item['sales_price'];
                                    $modelItem[$k]->transaction_date = $item['transaction_date'];
                                    $modelItem[$k]->transaction_from = $transaction_from;
                                    $modelItem[$k]->transaction_type = "OUT";

                                    $modelItem[$k]->master_stock_ledger_id = $eachstockledgerentry['id'];
                                    $modelItem[$k]->created_by = Yii::app()->user->id;
                                    $modelItem[$k]->created_date = date("Y-m-d H:i:s");
                                    if ($package_status == 'DTOUT') {
                                        $modelItem[$k]->to_rack_id = $_POST['Data'][$i]['to_rack_id'];
                                        $modelItem[$k]->to_bin_id = $_POST['Data'][$i]['to_bin_id'];
                                        $modelItem[$k]->to_warehouse_id = $_POST['Data'][$i]['to_warehouse_id'];
                                    }

                                    $k++;
                                }
                            }
                        } else {
                            $valid = FALSE;

                            $error[] = ' Product' . $product->part_number . ' has only ' . $total_qty . ' items. Quantity should be less than available';
                        }
                    }
                }
                //echo '<pre>'.print_r($groups);
                //echo '<pre>'.print_r($modelItem);exit;
                // QTY Checking
                if (!empty($groups)) {
                    foreach ($groups as $key => $eachProduct) {

                        $arr_warehouse_qty = StockLedger::model()->findByPk((int) $eachProduct['master_stock_ledger_id']);

                        $ware_house_qty = (float) $arr_warehouse_qty['quantity'] * $arr_warehouse_qty['unit_factor'];
                        if ($ware_house_qty < 0) {
                            $ware_house_qty = 0;
                        }

                        $sql_ou_qty = 'SELECT SUM(quantity * unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . (int) $eachProduct['master_stock_ledger_id'] . ' ';
                        //echo $sql_ou_qty;
                        $out_qty = (int) Yii::app()->db->createCommand($sql_ou_qty)->queryScalar();

                        $availble_qty = $ware_house_qty - (-1 * $out_qty);

                        if (($eachProduct['quantity']) > $availble_qty) {
                            $other[] = $arr_warehouse_qty['product_name'] . ' maximum sellable qty : ' . ($availble_qty);
                            $valid = false;
                        }
                    }
                }
                if (!empty($productgroups) && ($package_status == 'D' || $package_status == 'DSI')) {
                    foreach ($productgroups as $pkey => $eachProductgp) {
                        $arr_uom_details = UnitOfMeasurement::model()->findByPk((int) $eachProductgp['unit_id']);
                        $product = Store::model()->findByPk((int) $eachProductgp['id']);
                        $sql_qty = 'SELECT IFNULL(SUM(DI.picked_qty*U.factor),0) as picked_qty FROM `erp_delivery_item` DI LEFT JOIN erp_unit_of_measurement U ON U.id=DI.unit_id
                    WHERE delivery_note_id=' . (int) $model->id . ' AND DI.product_id=' . (int) $eachProductgp['id'] . ' AND DI.unit_id=' . (int) $eachProductgp['unit_id'];
                        $sum_qty_dlvd = Yii::app()->db->createCommand($sql_qty)->queryScalar();

                        if ((int) $eachProductgp['unit_factor'] == 0) {
                            $unit_fact = 1;
                        } else {
                            $unit_fact = (int) $eachProductgp['unit_factor'];
                        }
                        $display_qty = ($sum_qty_dlvd / $unit_fact);

                        if ($eachProductgp['quantity'] != $sum_qty_dlvd) {
                            $other[] = $product->part_number . ' total deliverable qty : ' . (number_format($display_qty, 2));
                            $valid = false;
                        }
                    }
                }

                if ($valid && $flag == 0) {
                    $check_sales_group = 0;
                    if ($package_status == 'D') {
                        $model->ready_to_invoice = 'Y';
                        $model->save(false);

                        // inserting to audit log
                        if ($model->id > 0) {
                            AuditLog::saveAuditLogs(
                                'DELIVERY_NOTE',
                                Yii::app()->user->id,
                                'CREATED',
                                " with DLVRY Note No: - {$model->id}  "
                            );
                            // end audit log
                        }
                    } else if ($package_status == 'DSI') {
                        $model->ready_to_invoice = 'Y';
                        //$model->driver_name = $_POST['DeliveryNote']['driver_name'];
                        $model->save(false);

                        // inserting to audit log
                        if ($model->id > 0) {
                            AuditLog::saveAuditLogs(
                                'DELIVERY_NOTE',
                                Yii::app()->user->id,
                                'CREATED',
                                " with DLVRY Note No: - {$model->id}  "
                            );
                            // end audit log

                            $delivery_id = $model->id;
                        }
                        //Invoice CREATE start
                        $modelDI = DirectInvoice::model()->find(array('condition' => 'reference=' . (int) $model->id));
                        if (!empty($modelDI)) {
                            $modelInvoice = new Invoice();
                            $modelInvoice->created_by = Yii::app()->user->id;
                            $modelInvoice->created_datetime = date('Y-m-d H:i:s');
                            $modelInvoice->file_id = $model->file_id;
                            $modelInvoice->delivery_ids = $model->id;
                            $total = $net_total = $tot_tax = 0;
                            $modelInvoice->exchange_rate = 1;
                            $modelInvoice->currency = Yii::app()->user->company_base_currency;
                            $modelInvoice->contact_id = $model->contact_id;
                            $modelInvoice->customer_id = $model->customer_id;
                            $modelInvoice->lead_owner_id = Yii::app()->user->id;
                            $modelInvoice->sales_group_id = 1;
                            $modelInvoice->order_id = $modelDI->id;
                            $modelInvoice->terms_and_conditions = $modelDI->terms_and_conditions;
                            $modelInvoice->invoice_date = $modelDI->invoice_date;
                            $modelInvoice->invoice_type = $modelDI->invoice_type;
                            $modelInvoice->payment_terms_id = $modelDI->payment_terms;
                            $modelInvoice->created_by = Yii::app()->user->id;
                            $modelInvoice->is_direct_invoice = "Y";
                            $modelInvoice->save(false);
                            $modelInvoice->refresh();
                            $grand_total = $tot_tax = 0;
                            $actual_item_quantity = 0;
                            $modelDirectInvoiceItem = DirectInvoiceItem::model()->findAll(array('condition' => 'invoice_id =' . (int) $modelDI->id));
                            if (!empty($modelDirectInvoiceItem)) {
                                foreach ($modelDirectInvoiceItem as $i => $item) {

                                    $modeInvoicelItem[$i] = new InvoiceItem;
                                    $modeInvoicelItem[$i]->product_id = $item['product_id'];
                                    $modeInvoicelItem[$i]->order_item_id = $item['id'];
                                    $modeInvoicelItem[$i]->invoice_id = $modelInvoice->id;
                                    $modeInvoicelItem[$i]->description = $item['description'];
                                    $modeInvoicelItem[$i]->quantity = $item['quantity'];
                                    $modeInvoicelItem[$i]->picked_qty = $item['quantity'];
                                    $modeInvoicelItem[$i]->rate = $item['rate'];
                                    $modeInvoicelItem[$i]->amount = $item['amount'];
                                    $modeInvoicelItem[$i]->id = 0;
                                    $modeInvoicelItem[$i]->tax_vat_amount = $item['tax_vat_amount'];
                                    $modeInvoicelItem[$i]->tax_vat_percentage = $item['tax_vat_percentage'];
                                    $modeInvoicelItem[$i]->deduction_amount = $item['deduction_amount'];
                                    $modeInvoicelItem[$i]->net_amount = $item['amount'] - $item['deduction_amount'];
                                    $modeInvoicelItem[$i]->unit_id = $item['unit_id'];
                                    //for cost rate--jisha--12-9-22--start
                                    $modelStore = new Store();
                                    $modelStore = $modelStore->findByPk($item['product_id']);
                                    $cost_rate = $modelStore->rate;
                                    $modelUOM = new UnitOfMeasurement();
                                    $modelUOM = $modelUOM->findByPK((int) $item['unit_id']);
                                    if (!empty($modelUOM)) {
                                        $unit_cost_rate = $modelStore->rate * $modelUOM->factor;
                                        $modeInvoicelItem[$i]->unit_factor = $modelUOM->factor;
                                        $modeInvoicelItem[$i]->unit_cost_rate = $unit_cost_rate;
                                        $modeInvoicelItem[$i]->base_cost_rate = $cost_rate;
                                        $modeInvoicelItem[$i]->cost_updated = "Y";
                                    }
                                    $modeInvoicelItem[$i]->cost_rate = $cost_rate;
                                    //for cost rate--jisha--12-9-22--end
                                    $tot_tax += $item['tax_vat_amount'];
                                    $grand_total += ($item['amount'] + $item['tax_vat_amount']);
                                    $modeInvoicelItem[$i]->save(false);
                                }


                                //check setting for invoice no generation

                                $modelCompanySettings = new MasCompanySettings();
                                $modelCompanySettings = $modelCompanySettings->find(array('condition' => 'crm_company_id=' . (int) Yii::app()->user->master_user_company_id));

                                $invoice_no = $modelInvoice->id;
                                /*$outlet_id=0;
                                  if(isset($modelCompanySettings->generate_invoice_no) && $modelCompanySettings->generate_invoice_no=='OUTLET'){

                                  if((int) Yii::app()->user->id > 0){
                                  $modelUserDetails = User::model()->findByPk((int) Yii::app()->user->id);
                                  $outlet_id = (int) $modelUserDetails->outlet_id;

                                  if($outlet_id > 0){
                                  $modelMasOutlet = new MasOutlet();
                                  $modelMasOutlet = $modelMasOutlet->findByPk($outlet_id);

                                  $invoice_no = ($modelMasOutlet->current_invoice_no + 1);

                                  }
                                  }


                                  }*/



                                //end
                                // $modelInvoice->updateByPk($modelInvoice->id, array('grand_total' => $grand_total, 'total_tax_amount' => $tot_tax,'invoice_no'=>$modelInvoice->id));
                                $modelInvoice->updateByPk($modelInvoice->id, array('invoice_no' => $invoice_no, 'file_id' => $file_id, 'total_tax_amount' => $tot_tax, 'net_amount' => ($grand_total), 'grand_total' => ($grand_total)/* , 'commision_percentage' => $commision_percentage, 'commision_amount' => $commision_amount*/));

                                DirectInvoice::model()->updateByPk((int) $modelDI->id, array('posted' => 'Y', 'invoice_id' => (int) $modelInvoice->id));
                            }
                        }
                        //Invoice Create end
                    } else if ($package_status == 'GI') {
                        $model->stock_updated = 'Y';
                        $model->save(false);
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'ISSUES',
                            Yii::app()->user->id,
                            'CREATED',
                            " with Issue No: - {$model->id}  "
                        );
                        // end audit log
                    } else if ($package_status == 'PDN') {
                        $model->is_goods_returned = 'Y';
                        $model->save(false);
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'PURCHASE_RETURN',
                            Yii::app()->user->id,
                            'CREATED',
                            " with Return No: - {$model->id}  "
                        );
                        // end audit log
                    } else if ($package_status == 'PRGI') {
                        $model->is_goods_issued = 'Y';
                        $model->save(false);
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'GOODS_ISSUE',
                            Yii::app()->user->id,
                            'CREATED',
                            " with GI No: - {$model->id}  "
                        );
                        // end audit log
                    } else if ($package_status == 'DTOUT') {
                        $model->status = 'C';
                        $model->save(false);
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'DIRECT_TRANSFER',
                            Yii::app()->user->id,
                            'CREATED',
                            " with Checkin No: - {$model->id}  "
                        );
                        // end audit log
                    } else if ($package_status == 'IDTOUT') {
                        $model->is_complete = 'P';
                        $model->save(false);
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'INDIRECT_TRANSFER',
                            Yii::app()->user->id,
                            'CREATED',
                            " with Checkin No: - {$model->id}  "
                        );
                        // end audit log
                    }
                    foreach ($modelItem as $w => $eachModel) {

                        $arr_stock_ledger_data = $eachModel;

                        /*                         * ************* Code added by Mereena on 28/11/2018 for purchase return cost rate updating************************* */
                        if ($package_status == 'PDN') {
                            $product_id = $eachModel->product_id;
                            /*                             * ************** Start get debit note item details ****************** */
                            $arr_debit_note_item_details = PurchasingdebitnoteItem::model()->find(array('condition' => 'purchasing_debitnote_id=' . $transaction_id . ' AND product_id=' . $product_id));
                            //echo "returned_amt=".$return_amt;
                            /*                             * ******************* End ***************************************** */

                            $old_total_qty = Yii::app()->db->createCommand('SELECT SUM(quantity*unit_factor) FROM  erp_stock_ledger WHERE product_id=' . $product_id . ' ')->queryScalar();
                            $returned_qty = -1 * ($eachModel->quantity);
                            $return_amt = $arr_debit_note_item_details->rate * $returned_qty;
                            $arr_product_details = Store::model()->findbyPk($product_id);
                            $old_cost_rate = $arr_product_details->rate;
                            $old_amt = $old_cost_rate * $old_total_qty;
                            $new_qty = $old_total_qty - $returned_qty;
                            if ($new_qty > 0) {
                                $cost_rate = ($old_amt - $return_amt) / $new_qty;
                            } else {
                                $cost_rate = $old_cost_rate;
                            }

                            $eachModel->cost_price = $old_cost_rate; //$cost_rate
                            //$arr_product_details->updateByPk($product_id, array('rate' => $cost_rate));
                        }
                        /*                         * ************************** Code end by mereena on 28/11/2018 for purchase return cost rate updating********************************* */


                        if (($package_status == 'D' || $package_status == 'DSI') && (int) $file_id > 0) {

                            //Deallocate products
                            $modelAllocate = new AllocatedMaterial();
                            $modelAllocate = $modelAllocate->find(array('condition' => 'file_id=' . (int) $file_id . ' AND product_id=' . $eachModel->product_id));
                            if ($modelAllocate != null) {

                                if ($eachModel->quantity == $modelAllocate['quantity']) {
                                    $modelDelAllocate = new AllocatedMaterial();
                                    $modelDelAllocate->deleteByPk($modelAllocate['id']);
                                } else {

                                    $eachItemQuantity = -1 * $eachModel->quantity;
                                    $new_allocate_qty = $modelAllocate['quantity'] - $eachItemQuantity;

                                    if ((int) $new_allocate_qty > 0) {
                                        $modelAllocateQty = new AllocatedMaterial();
                                        $modelAllocateQty->updateByPk($modelAllocate['id'], array('quantity' => $new_allocate_qty));
                                    } else {
                                        $modelDelAllocate = new AllocatedMaterial();
                                        $modelDelAllocate->deleteByPk($modelAllocate['id']);
                                    }
                                }
                            }
                            //End
                        }

                        /* if ($package_status == 'DTOUT') {
                          $eachModel->stock_updated = 'N';
                          } */
                        if ($package_status == 'DTOUT') {
                            $modelTransferInStockLedger = new StockLedger();
                            $modelTransferInStockLedger->file_id = $eachModel->file_id;
                            $modelTransferInStockLedger->header_id = $eachModel->header_id;
                            $modelTransferInStockLedger->header_item_id = $eachModel->header_item_id;
                            $modelTransferInStockLedger->customer_vendor_id = $eachModel->customer_vendor_id;
                            $modelTransferInStockLedger->customer_vendor_name = $eachModel->customer_vendor_name;
                            $modelTransferInStockLedger->product_id = $eachModel->product_id;
                            $modelTransferInStockLedger->product_name = $eachModel->product_name;
                            $modelTransferInStockLedger->product_description = $eachModel->product_description;
                            $modelTransferInStockLedger->brand_id = $eachModel->brand_id;
                            $modelTransferInStockLedger->brand_name = $eachModel->brand_name;
                            $modelTransferInStockLedger->warehouse_id = $eachModel->to_warehouse_id;
                            $modelTransferInStockLedger->warehouse_name = MasInventoryWarehouse::getWarehouseName($eachModel->to_warehouse_id);
                            $modelTransferInStockLedger->rack_id = $eachModel->to_rack_id;
                            $modelTransferInStockLedger->rack_name = MasInvRack::getRackName($eachModel->to_rack_id);
                            $modelTransferInStockLedger->bin_id = $eachModel->to_bin_id;
                            $modelTransferInStockLedger->bin_name = MasInvBin::getBinName($eachModel->to_bin_id);
                            $modelTransferInStockLedger->unit_id = $eachModel->unit_id;
                            $modelTransferInStockLedger->unit_name = $eachModel->unit_name;
                            $modelTransferInStockLedger->unit_factor = abs($eachModel->unit_factor);
                            $modelTransferInStockLedger->quantity = abs($eachModel->quantity);
                            $modelTransferInStockLedger->available_status = 'A';
                            $modelTransferInStockLedger->batch_no = $eachModel->batch_no;
                            $modelTransferInStockLedger->serial_no = $eachModel->serial_no;
                            $modelTransferInStockLedger->manufacturing_date = $eachModel->manufacturing_date;
                            $modelTransferInStockLedger->expiry_date = $eachModel->expiry_date;
                            $modelTransferInStockLedger->cost_price = $eachModel->cost_price;
                            $modelTransferInStockLedger->sales_price = $eachModel->sales_price;
                            //$modelTransferInStockLedger->transaction_date       =   date('Y-m-d');
                            $modelTransferInStockLedger->transaction_date = $eachModel->transaction_date;
                            $modelTransferInStockLedger->transaction_from = 'DIRECT_TRANSFER_IN';
                            $modelTransferInStockLedger->transaction_type = "IN";
                            $modelTransferInStockLedger->created_by = Yii::app()->user->id;
                            $modelTransferInStockLedger->created_date = date("Y-m-d H:i:s");
                            //OUT data save into stockledger
                            $eachModel->save(false);
                            //IN data save into stock ledger
                            $modelTransferInStockLedger->master_stock_ledger_id = $eachModel->id;
                            $modelTransferInStockLedger->save(false);
                        } else {

                            if ($package_status == 'DSI') {
                                $eachModel->reference_id = $modelInvoice->id;
                                $eachModel->reference_no = $invoice_no;
                            }
                            $eachModel->save(false);
                            if ($package_status == 'D') {
                                $second_factor = $eachModel->unit_factor;
                                if ((int) $second_factor == 0) {
                                    $second_factor = 1;
                                }
                                //Store::model()->updateByPK($eachModel->product_id, array('selling_price_1' =>($eachModel->sales_price/$second_factor),'selling_price_2' =>$eachModel->sales_price));
                            }
                        }
                        if (!empty($eachModel->serial_no)) {
                            StockLedger::model()->updateByPK($eachModel->master_stock_ledger_id, array('available_status' => 'U'));
                        } else {
                            $out_qty = Yii::app()->db->createCommand('SELECT SUM(quantity*unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . $eachModel->master_stock_ledger_id . ' ')->queryScalar();
                            $arr_existing_stock_ledger = StockLedger::model()->findByPK($eachModel->master_stock_ledger_id);
                            $delivered_qty = (-1 * $out_qty);
                            if (($arr_existing_stock_ledger->quantity * $arr_existing_stock_ledger->unit_factor) == $delivered_qty) {
                                StockLedger::model()->updateByPK($eachModel->master_stock_ledger_id, array('available_status' => 'U'));
                            } else {
                                StockLedger::model()->updateByPK($eachModel->master_stock_ledger_id, array('available_status' => 'A'));
                            }
                        }
                    }
                    //Updating status in delivery
                    if ($package_status == 'D') {
                        DeliveryNote::model()->updateByPK($transaction_id, array('status' => 'CL', 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d h:i:s')));
                    }
                    if ($package_status == 'DSI') {
                        DeliveryNote::model()->updateByPK($transaction_id, array('invoiced' => 'Y', 'status' => 'CL', 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d h:i:s')));
                    }
                    // ----------added-by-indhu-30-12-2022---------------------------
                    //             if ($package_status == 'PDN') {
                    //                 Yii::import('application.modules.accounts.controllers.PostingController');
                    //                 $from = 'debitnote';
                    //                 PostingController::DirectPost((int) $transaction_id, $from);
                    //             }
                    //             // ---------------------------------------------------------------
                    //             $jsonData['status'] = 'success';
                    //             echo CJSON::encode($jsonData);
                    //         } else {
                    //             //$error = CJSON::encode($error);
                    //             //$error = array();
                    //             if ($flag == 1) {
                    //                 $error[] = "Insufficient Quantity";
                    //             }
                    //             // echo "error in saving";
                    //             $error = CJSON::encode(array_merge_recursive($error, $other));
                    //             if ($error != '[]')
                    //                 echo $error;
                    //         }
                    //     } else {
                    //         echo "Outer elese error in saving";
                    //     }
                    // }else{
                    //     echo CJSON::encode( array( 'error' => ' Transactions are already locked!' ));
                    //    }
                    // }
                    if ($package_status == 'PDN') {
                        Yii::import('application.modules.accounts.controllers.PostingController');
                        $from = 'debitnote';
                        PostingController::DirectPost((int) $transaction_id, $from);
                    }

                    // Initialize $error as an empty array if it's not already set
                    if (!isset($error)) {
                        $error = array(); // Ensure $error is an array
                    }

                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                } else {
                    if ($flag == 1) {
                        $error[] = "Insufficient Quantity";
                    }

                    // Check if $error is an array before merging
                    if (!is_array($error)) {
                        $error = array();
                    }

                    $error = CJSON::encode(array_merge_recursive($error, $other));

                    if ($error != '[]') {
                        echo $error;
                    }
                }
            } else {
                echo "Outer else error in saving";
            }
        } else {
            echo CJSON::encode(array('error' => 'Transactions are already locked!'));
        }
    }
}
