<?php

class OpeningcashController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'save'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }

    public function actionGetList() {

        $model = new OpeningCash();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'opening_date',
            2 => 'opening_cash',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = ' 1=1';

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset + 1;
        foreach ($model as $row) {
            $rowData[] = array($m,
                date("d/m/Y", strtotime($row->opening_date)),
                $row->warehouse->warehouse_name,
                number_format((float) $row->opening_cash, 2),
                ['id' => $row->id],
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new OpeningCash();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSave() {
        $model = new OpeningCash();
        if (isset($_POST['OpeningCash'])) {

            if ((int) @$_POST['OpeningCash']['id'] > 0) {
                $id = (int) @$_POST['OpeningCash']['id'];
                $model = $model->findByPk($id);

                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['OpeningCash'];
            if ($_POST['OpeningCash']['opening_date'] != '00/00/0000' && $_POST['OpeningCash']['opening_date'] != '') {
                $model->opening_date = str_replace('/', '-', $_POST['OpeningCash']['opening_date']);
                $model->opening_date = date("Y-m-d", strtotime($model->opening_date));
            }
            if ($model->save()) {
                // inserting to audit log
//                AuditLog::saveAuditLogs(
//                        'OPEN_CASH', Yii::app()->user->id, $audit_type, " with ABRVTN: - {$model->leave_abbreviation}  "
//                );
//                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

}
