<?php

class MigrationController extends Controller
{
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('BuildStockLedger','TruncateStockLedger','DeleteOpeningStockLedger','BuildStockLedgerInAllWarehouse','BuildStockLedgerFromReceipts','UpdateReceiptItem','UpdateReceiptItemSubmit','UpdateQuantityReceiptStockLedger','LoadStockLedgerReceipts','UpdateStockLedgerDetails'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
	
	
	public function actionBuildStockLedgerInAllWarehouse(){
        
        $model=new Store();
        
        $modelStore=$model->findAll(array('condition'=>'inventory_item_type=1'));
                
        $modelInventoryWarehouse=new MasInventoryWarehouse();
       
        //$condition = 'isActive="Y" AND warehouse_code!="DAM" AND isBaseWareHouse="N"';
        $condition = 'isActive="Y" AND warehouse_code!="DAM"';
        $arr_warehouse_list = $modelInventoryWarehouse->findAll(array('condition' => $condition));
        
        foreach($arr_warehouse_list as $warehouse_list){
        
            $transaction_date = "2022-12-21";
            $default_warehouse_id           =   $warehouse_list->id;
            $default_warehouse              =   $warehouse_list->warehouse_name; 
            //echo $default_warehouse."<br>";
            foreach($modelStore as $eachItem){
                $modelStockLedger = new StockLedger();
                $modelStockLedger = $modelStockLedger->find(array('condition'=>'product_id='.$eachItem->id.' AND transaction_from="OPENING_STOCK"'));
                $modelUnitMeasurement   = new UnitOfMeasurement();
                $modelUnitMeasurement = $modelUnitMeasurement->find(array('condition'=>'product_id='.$eachItem->id.' AND unit_id='.$eachItem->unit_id));
                //if(empty($modelStockLedger)){
                    $SQL = "INSERT INTO erp_stock_ledger (file_id, header_id, header_item_id, customer_vendor_id, customer_vendor_name, product_id, product_name, product_description, brand_id, brand_name, warehouse_id, warehouse_name, rack_id, rack_name, bin_id, bin_name, unit_id, unit_name, unit_factor, quantity, available_status, batch_no, serial_no, manufacturing_date, expiry_date, buying_price, cost_price, sales_price, stock_after_transaction, stock_value_after_transaction, transaction_date, transaction_from, transaction_type, master_stock_ledger_id, stock_updated, created_by, created_date) VALUES 
                    (0, 0, 0, 0,'',".$eachItem->id.",'".$eachItem->part_number."','".$eachItem->description."','".$eachItem->brand_class_id."','',$default_warehouse_id,'".$default_warehouse."',1,'None',1,'None',".$modelUnitMeasurement->unit_id.",'".$modelUnitMeasurement->name."',1,1000,'A','','','0000-00-00','0000-00-00','',".$eachItem->rate.",'','','','".$transaction_date."','OPENING_STOCK','IN',0,'Y',1,'".date('Y-m-d h:i:s')."')";
                    //echo $SQL;
                    //exit;
                    Yii::app()->db->createCommand($SQL)->execute();
                //}
            }
        }
        $json['status'] = "success";
        
        echo json_encode($json);
        
    }
    
    public function actionBuildStockLedger(){
        
        $model=new Store();
        
        $modelStore=$model->findAll(array('condition'=>'inventory_item_type=1'));
                
       $modelInventoryWarehouse=new MasInventoryWarehouse();
       
        
        $transaction_date = "2022-11-12";
        $default_warehouse_id=2;
        $default_warehouse="SCC"; 
        foreach($modelStore as $eachItem){
            $modelStockLedger = new StockLedger();
            $modelStockLedger = $modelStockLedger->find(array('condition'=>'product_id='.$eachItem->id.' AND transaction_from="OPENING_STOCK"'));
            $modelUnitMeasurement   = new UnitOfMeasurement();
            $modelUnitMeasurement = $modelUnitMeasurement->find(array('condition'=>'product_id='.$eachItem->id.' AND unit_id='.$eachItem->unit_id));
            //if(empty($modelStockLedger)){
                $SQL = "INSERT INTO erp_stock_ledger (file_id, header_id, header_item_id, customer_vendor_id, customer_vendor_name, product_id, product_name, product_description, brand_id, brand_name, warehouse_id, warehouse_name, rack_id, rack_name, bin_id, bin_name, unit_id, unit_name, unit_factor, quantity, available_status, batch_no, serial_no, manufacturing_date, expiry_date, buying_price, cost_price, sales_price, stock_after_transaction, stock_value_after_transaction, transaction_date, transaction_from, transaction_type, master_stock_ledger_id, stock_updated, created_by, created_date) VALUES 
                (0, 0, 0, 0,'',".$eachItem->id.",'".$eachItem->part_number."','".$eachItem->description."','".$eachItem->brand_class_id."','',$default_warehouse_id,'".$default_warehouse."',1,'None',1,'None',".$modelUnitMeasurement->unit_id.",'".$modelUnitMeasurement->name."',1,1000,'A','','','0000-00-00','0000-00-00','',".$eachItem->rate.",'','','','".$transaction_date."','OPENING_STOCK','IN',0,'Y',1,'".date('Y-m-d h:i:s')."')";
                //echo $SQL;
                //exit;
                Yii::app()->db->createCommand($SQL)->execute();
            //}
        }
        $json['status'] = "success";
        
        echo json_encode($json);
        
    }
    
    public function actionTruncateStockLedger(){
        
        $model=new Store();
        
        $modelStore=$model->findAll(array('condition'=>'inventory_item_type=1'));
                
        $modelStockLedger = new StockLedger();
        
        $SQL="TRUNCATE erp_stock_ledger";
        
        Yii::app()->db->createCommand($SQL)->execute();
        $json['status'] = "success";
        
        echo json_encode($json);
        
    }
    
     public function actionDeleteOpeningStockLedger(){
        
        $model=new Store();
        
        $modelStore=$model->findAll(array('condition'=>'inventory_item_type=1'));
                
        $modelStockLedger = new StockLedger();
        
        $SQL="DELETE FROM erp_stock_ledger WHERE transaction_from='OPENING_STOCK'";
        
        Yii::app()->db->createCommand($SQL)->execute();
        $json['status'] = "success";
        
        echo json_encode($json);
        
    }
	public function actionBuildStockLedgerFromReceipts(){
	     $modelStockLedger = new StockLedger();
	     $modelReceipts = new InventoryGoodsReceiptItem();
	     
	     $modelReceipts = $modelReceipts->findAll();
	     
	     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('receipt_stock_mismatch', array('model' => $modelReceipts), false, false);
	}
	public function actionUpdateReceiptItem(){
	    $receipt_item_id = (int)Yii::app()->request->getParam('receipt_item_id');
	    $modelReceipts = new InventoryGoodsReceiptItem();
        if ($receipt_item_id > 0) {
            $modelReceipts = $modelReceipts->findByPk($receipt_item_id);
        }
	     
	      Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
         $this->render('update_receipt_item', array('model' => $modelReceipts), false, false);
	}
	public function actionUpdateReceiptItemSubmit(){
	        $modelStockLedger = new StockLedger();
	        $modelInventoryGoodsReceiptItem = new InventoryGoodsReceiptItem();
            if (isset($_POST['InventoryGoodsReceiptItem'])) {
                if ((int)@$_POST['InventoryGoodsReceiptItem']['id'] > 0) {
                    $id = (int)@$_POST['InventoryGoodsReceiptItem']['id'];
                    $modelInventoryGoodsReceiptItem = $modelInventoryGoodsReceiptItem->findByPk($id);
                    
                        $warehouse_id = (int) $_POST['InventoryGoodsReceiptItem']['warehouse_id'];
                        
                        $product_id = (int) $modelInventoryGoodsReceiptItem->product_id;
                        $modelStore = new Store();
                        
                        $modelStore = $modelStore->findByPk($product_id);
                        
                        $modelMasInventoryWarehouse = new MasInventoryWarehouse();
                        $modelMasInventoryWarehouse = $modelMasInventoryWarehouse->findByPk($warehouse_id);
                        
                        
                        
                        //update cost
                        $rate = $modelStore->rate;
                        $existing_qty = $modelStore->totalQuantity;

                        $new_cost_price = $modelInventoryGoodsReceiptItem->rate * $modelInventoryGoodsReceiptItem->picked_qty;
                        $new_cost_price = round($new_cost_price, 6);
                        $unit_factor=1;
                        $quantity_with_unit_factor = $modelInventoryGoodsReceiptItem->picked_qty * $unit_factor;
                        $variance_value = ($quantity_with_unit_factor > 0) ? $new_cost_price / $quantity_with_unit_factor : 0;
                        $variance_value = round($variance_value, 6);
                        $cost_with_variance = $variance_value;

                        $cur_total = $cost_with_variance * $quantity_with_unit_factor;
                        $existing_amount = $rate * $existing_qty;
                        $total_quantity = $existing_qty + $quantity_with_unit_factor;
                        $total_amount = $existing_amount + $cur_total;
                        $new_amount = ($total_quantity > 0) ? $total_amount / $total_quantity : 0;
                        $new_amount = round($new_amount, 6);
				        
				        $cost_price = $new_amount;
				        
				        Store::model()->updateByPk($product_id, array('rate' => $new_amount));
                        //end
                        
                        //echo "cost_price=".$cost_price;
                        $modelStockLedger                         =   new StockLedger();
                        $modelStockLedger->file_id                =   0;   
                        $modelStockLedger->header_id              =   $modelInventoryGoodsReceiptItem->inventory_goods_receipt_id;   
                        $modelStockLedger->header_item_id         =   $modelInventoryGoodsReceiptItem->id;  
                        $modelStockLedger->customer_vendor_id     =   $modelInventoryGoodsReceiptItem->inventorygoodsreceipt->customer_id;
                        $modelStockLedger->customer_vendor_name   =   $modelInventoryGoodsReceiptItem->inventorygoodsreceipt->customer->customer_name;  
                        $modelStockLedger->product_id             =   $product_id;
                        $modelStockLedger->product_name           =   $modelInventoryGoodsReceiptItem->product_name;  
                        $modelStockLedger->product_description    =   $modelInventoryGoodsReceiptItem->description;
                        $modelStockLedger->brand_id               =   $modelStore->brand_class_id;  
                        $modelStockLedger->brand_name             =   $modelStore->brand_detail->product_class;
                        $modelStockLedger->warehouse_id           =   $warehouse_id;  
                        $modelStockLedger->warehouse_name         =   $modelMasInventoryWarehouse->warehouse_name;
                        $modelRack = new MasInvRack();
                        $modelStockLedger->rack_id                =   $modelRack->getDefaultRackId();  
                        $modelStockLedger->rack_name              =   MasInvRack::getRackName((int) $modelStockLedger->rack_id);
                        $modelBin = new MasInvBin();
                        $modelStockLedger->bin_id                 =   $modelBin->getDefaultBinId();  
                        $modelStockLedger->bin_name               =   MasInvBin::getBinName($modelStockLedger->bin_id);
                        $modelStockLedger->unit_id                =   $modelInventoryGoodsReceiptItem->unit; 
                        $modelUOM = new UnitOfMeasurement();
                        $modelStockLedger->unit_name              =   $modelUOM->getUOMName((int) $modelInventoryGoodsReceiptItem->unit);
                        $modelStockLedger->unit_factor            =   1;  
                        $modelStockLedger->quantity               =   $modelInventoryGoodsReceiptItem->picked_qty;
                        $modelStockLedger->available_status       =   'A';
                        $modelStockLedger->batch_no               =   '';  
                        $modelStockLedger->serial_no              =   '';
                        $modelStockLedger->manufacturing_date     =   '0000-00-00';  
                        $modelStockLedger->expiry_date            =   '0000-00-00';  
                        $modelStockLedger->buying_price           =   0;  
                        $modelStockLedger->cost_price             =   $cost_price;  
                        $modelStockLedger->sales_price            =   0;
                        $modelStockLedger->stock_after_transaction =   0;
                        $modelStockLedger->stock_value_after_transaction =   0;
                        $modelStockLedger->transaction_date       =   $modelInventoryGoodsReceiptItem->inventorygoodsreceipt->goods_receipt_date;
                        $modelStockLedger->transaction_from       =   'INVENTORY_GOODS_RECEIPT';
                        $modelStockLedger->transaction_type       =   "IN";   
                        $modelStockLedger->master_stock_ledger_id  =   0;        
                        $modelStockLedger->stock_updated          =  'Y';        
                        $modelStockLedger->created_by             =   $modelInventoryGoodsReceiptItem->created_by;
                        $modelStockLedger->created_date           =   $modelInventoryGoodsReceiptItem->created_date_time;   
                        $modelStockLedger->save(false);
                        //echo '<pre>';
                        //print_r($modelStockLedger);
                        
                        echo CJSON::encode( array( 'status' => 'success' ));
                    
                    
                }
            }
            else{
                	echo CJSON::encode( array( 'status' => 'failed' ));
            }
	}
	
	
	public function actionUpdateQuantityReceiptStockLedger(){
	     
	     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
         $this->render('update_item_quantity', '', false, false);
	}
	
	public function actionLoadStockLedgerReceipts(){
	    $warehouse_id   =   (int) Yii::app()->request->getParam('warehouse_id');
        $product_id     =   (int) Yii::app()->request->getParam('product_id');
	    Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('load_update_item_quantity', array('warehouse_id'=>$warehouse_id,'product_id'=>$product_id), false, false);
	}
	
	public function actionUpdateStockLedgerDetails(){
        $stock_ledger_id    =   (int) Yii::app()->request->getParam('stock_ledger_id');
	    $warehouse_id       =   (int) Yii::app()->request->getParam('warehouse_id');
        $product_id         =   (int) Yii::app()->request->getParam('product_id');
        $header_id          =   (int) Yii::app()->request->getParam('header_id');
        $header_item_id     =   (int) Yii::app()->request->getParam('header_item_id');
        $quantity           =   (int) Yii::app()->request->getParam('quantity');
        $frm                =   Yii::app()->request->getParam('frm');
        
        if($stock_ledger_id > 0){
            $modelStockLedger = new StockLedger();
            $modelStockLedger->updateByPk($stock_ledger_id, array('quantity' => $quantity));
        }
        if($header_item_id > 0){
            $modelInventoryGoodsReceiptItem = new InventoryGoodsReceiptItem();
            $modelInventoryGoodsReceiptItem->updateByPk($header_item_id, array('picked_qty' => $quantity));
        }
        
        echo "success";
        
        
       /* if($frm=='stockledger'){
            
            echo "success";
        }
        elseif($frm=='receipt'){
             $modelInventoryGoodsReceiptItem = new InventoryGoodsReceiptItem();
             $modelInventoryGoodsReceiptItem->updateByPk($header_item_id, array('picked_qty' => $quantity));
             echo "success";
        }
        else{
            echo "failed";
        }*/
        
        /*echo "stock_ledger_id=".$stock_ledger_id."<br>";
        echo "product_id=".$product_id."<br>";
        echo "header_id=".$header_id."<br>";
        echo $quantity;*/
	}
	
	
	
}