<?php

class MeetingtypeController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Getlist', 'Create', 'Save'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $cid = (int) Yii::app()->request->getParam('cid');
        $lid = (int) Yii::app()->request->getParam('lid');
        $category = (int) Yii::app()->request->getParam('category');
        $this->render('index', array('cid' => $cid, 'lid' => $lid, 'category' => $category));
    }

    public function actionGetlist() {
        $model = new MeetingType;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $orderBy = 't.type_name asc ';
        $condition = '1=1';
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $i => $row) {
            $btn = "";
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["meeting_type_edit"])) {
                $btn .= '&nbsp;<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'meetingtype/create&id=' . $row['id'] . '\', \'Inspection View\');"><i class="fa fa-eye"></i></button>';
            }
            $rowData[] = array(($i + 1), $row['type_name'], $btn);
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new MeetingType;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model));
    }

    public function actionSave() {
        if (isset($_POST['MeetingType'])) {
            $model = new MeetingType;
            if ((int) $_POST['MeetingType']['id'] > 0) {
                $model = $model->findbypk($_POST['MeetingType']['id']);
            }
            $model->attributes = $_POST['MeetingType'];
            if ($model->validate() && $model->save()) {
                echo json_encode(['status' => 'success']);
            } else {
                echo json_encode($model->getErrors());
            }
        }
    }

}
