<?php

class MeetingController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Getlist', 'getAllLocations','getAllEmployee', 'Create', 'Save','CreateMeetingTransaction','SaveMeetingTransaction'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /** 
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */

    public function actionIndex() {
        $this->render('index');
    }
    
    public function actionGetlist() {
        $model = new Meeting;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'meeting_date',
            2 => 'type',
            3 => 'meeting_title',
            4 => 'id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition =" ( meeting_title LIKE '%" . $searchString . "%'  OR  type LIKE '%" . $searchString ."%' )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        
        foreach ($model as $i => $row)
        {
            $div ='';
           
            $div = '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'meeting/create&id='.$row['id'].'\',\''.$row['id'].' : '.$row['type'].'\',\'md\')"><i class="fa fa-pencil"></i></button>';
             $div .= '&nbsp;<button class="btn btn-primary btn-xs" title ="add" onclick="loadPopupModal(\'meeting/CreateMeetingTransaction&meeting_id='.$row['id'].'\',\''.$row['id'].' : '.$row['type'].'\',\'md\')"><i class="fa  fa-exchange"></i></button>';
           $meeting_date = $row['meeting_date'];
           $meeting_date_arr = explode("-", $meeting_date); 
           $meeting_date = $meeting_date_arr[2] ."/" . $meeting_date_arr[1] ."/". $meeting_date_arr[0];
           $rowData[] = array(($i+1), $meeting_date ." ".$row["meeting_time"], $row["type"], $row["meeting_title"], '<div class="btn-wrap text-center">'.$div.'</div>');
            
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    
    public function actionCreate() {
        
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Meeting;
        if ($id > 0) {
            $model = $model->findByPk($id);
            $date_array = explode("-", $model->meeting_date);
            $model->meeting_date = $date_array[2] . "/" . $date_array[1] . "/" . $date_array[0];
        }
        else{
        	 $model->meeting_date = date('d/m/y');
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model));
       
    }
    public function actionCreateMeetingTransaction(){
    	$id = (int) Yii::app()->request->getParam('id');
    	$meeting_id = (int) Yii::app()->request->getParam('meeting_id');
        $model = new MeetingTransaction;
        if ($id > 0) {
            $model = $model->findByPk($id);
            $date_array = explode("-", $model->closing_date);
            $model->closing_date = $date_array[2] . "/" . $date_array[1] . "/" . $date_array[0];
        }
        else{
        	 $model->closing_date = date('d/m/y');
        	 $model->meeting_id = $meeting_id;
        	 $model->serial_no = "00";
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create_trans', array('model' => $model));
    }
	public function actionSaveMeetingTransaction(){
		if(isset($_POST)){
           date_default_timezone_set("Asia/Dubai");
            $model = new MeetingTransaction;
            if( (int) $_POST['MeetingTransaction']['id'] > 0 ){
                $model = $model->findByPk( $_POST['MeetingTransaction']['id'] );
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            else{
            	$model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['MeetingTransaction'];
             
            /*
            $person = $_POST['person'];
            if(!empty($person)){
            	$model->person = implode(",",$person);
            } */
            if($model->closing_date != ""){
            	$date_array = explode("/", $model->closing_date);
            	$model->closing_date = $date_array[2] . "-" . $date_array[1] . "-" . $date_array[0];
            }
            if( $model->validate() ){
                echo json_encode(array('status' => 'success'));
                $model->save();
            }else{
                echo CActiveForm::validate($model, '', false);
            }
        }
	}
    public function actionSave(){
        if(isset($_POST)){
           date_default_timezone_set("Asia/Dubai");
            $model = new Meeting;
            if( (int) $_POST['Meeting']['id'] > 0 ){
                $model = $model->findByPk( $_POST['Meeting']['id'] );
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
                
            $model->attributes = $_POST['Meeting'];
            $conducted_array = $_POST["conducted_by"];            
            $attendees_array = $_POST["attendees"];
            if(!empty($conducted_array)){
            	$model->conducted_by = implode(",",$conducted_array);
            }
            if(!empty($attendees_array)){
            	$model->attendees = implode(",",$attendees_array);
            }
            if($model->meeting_date != ""){
            	$date_array = explode("/", $model->meeting_date);
            	$model->meeting_date = $date_array[2] . "-" . $date_array[1] . "-" . $date_array[0];
            }
            if( $model->validate() ){
                echo json_encode(array('status' => 'success'));
                $model->save();
            }else{
                echo CActiveForm::validate($model, '', false);
            }
        }
    }

    // All Employee
    public function actiongetAllEmployee()
    {
    	$condition = " t.isActive = 'Y' ";
    	 $location_id =  Yii::app()->request->getparam("location_id");
    	 if($location_id>0){
            $condition.=" AND t.location = ".$location_id;
        }
        $model = new Employee;
        $model_emp = $model->with('loc')->findAll(array('condition' => $condition));
        $emp_details  = CHtml::listData($model_emp, 'id', 'name');
        $conducted = CHtml::dropDownList('conducted_by', "Meeting[conducted_by]", $emp_details, array('multiple'=>true, 'class'=>'form-control multi-select','name' => "Meeting[conducted_by]", 'data-label'=>'Conducted by <span style="color:red;">*</span>','title'=>'Conducted by'));
        $attendees = CHtml::dropDownList('attendees', "Meeting[attendees]", $emp_details, array('multiple'=>true, 'class'=>'form-control multi-select', 'name' => "Meeting[attendees]",'data-label'=>'Conducted by <span style="color:red;">*</span>','title'=>'Conducted by'));
        $status=array("conducted" => $conducted,
        	"attendees" => $attendees);
        echo CJSON::encode($status);
    }
    // All location from country
    public function actiongetAllLocations()
    {
        $countryid =  Yii::app()->request->getparam("countryid"); 
        $select_id =  Yii::app()->request->getparam("select_id");  
        
        $condition = '1=1';
        if($countryid>0){
            $condition .= ' AND t.country_id ="' . $countryid.'"';
        }        
        if(Yii::app()->user->authorised_user == 1){            
            
            $modelLocation = MasLocations::model()->findAll(array('condition'=>$condition));   
            $location_details  = CHtml::listData($modelLocation, 'id', 'location');
            $dropBuilding = CHtml::dropDownList('Meeting[location_id]', $select_id, $location_details,array('class'=>'form-control multi-select', 'onchange' => ' getAllEmployee(this.value);', 'name' => "Meeting[location_id]", "empty" => "select" ,'data-label'=>'Location <span style="color:red;">*</span>','title'=>'Location'));
        }
        else{
            
            $con = '1=1';
            if($countryid > 0){
                $con.= ' AND country_id ='.$countryid;
            }
            $total_location = MasLocations::model()->count(array('condition'=>$con));
            $check_location = MasLocations::model()->findAll(array('condition'=>$con));
            
            $u_locs    = Yii::app()->user->user_locations;    
            $loc_array = explode(',', $u_locs);
            
            $count_user_location  = 0;
            if(!empty($check_location)){ 
                foreach ($check_location as $value) {
                    if (in_array($value->id, $loc_array)){
                        $count_user_location++;
                    }
                }
            }
            //echo $total_location." = ".$count_user_location."<br/>";
            $location_array = array();
            
            if($total_location == $count_user_location AND $count_user_location>0){
               
               
            }   
            else{
             
            }         
            if(count($loc_array)>0){
            
                $location_array[0]['id']   = '';
               $location_array[0]['name'] = 'All';
               
               $j  = 1;
               $condition .= ' AND `id` IN ('.$u_locs.')';
               $modelLocation = MasLocations::model()->findAll(array('condition'=>$condition)); 
               if(!empty($modelLocation)){
                    foreach($modelLocation as $row) {
                        if(!empty($row->id)){
                            $location_array[$j]['id'] = $row->id;
                            $location_array[$j]['name'] = $row->location;
                            $j++;
                        }                    
                    } 
               }
               else{
                $location_array[0]['id']   = 1000000;
                $location_array[0]['name'] = 'No Location';
               }
                
            }
            else{                
                $location_array[0]['id']   = 1000000;
                $location_array[0]['name'] = 'No Location';
            }
            $dropBuilding = CHtml::dropDownList('Meeting[location_id]', $select_id, CHtml::listData($location_array, 'id', 'name'),array('class'=>'form-control multi-select',"empty" => "select" , 'name' => "Meeting[location_id]", 'onchange' => 'getAllEmployee(this.value);','data-label'=>'Location <span style="color:red;">*</span>'));
        } 
             
        $status=array("location" => $dropBuilding);
        echo CJSON::encode($status);
    }


 
}
