<?php

class MeetingController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Getlist', 'getAllLocations', 'getAllEmployee', 'Create', 'Save', 'CreateMeetingTransaction',
                    'SaveMeetingTransaction', 'GetDetailsList', 'CreateSingleTransation', 'CloseTransation', 'getdropdown', 'Upload',
                    'downloadFile', 'Print', 'getCalendarDetails', 'MailSend', 'getemployeelist', 'getselectedemployeelist', 'DeleteMeeting'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetlist() {
        $model = new Meeting;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];



        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'meeting_date',
            2 => 'type',
            3 => 'meeting_title',
            4 => 'id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = " ( meeting_title LIKE '%" . $searchString . "%'  )";
        }
        if (isset($_POST['isMeeting']) && trim($_POST['isMeeting']) != "") {
            $isMeeting = $_POST['isMeeting'];
            $condition .= " AND  ismeeting = '{$isMeeting}' ";
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $i => $row) {
            $div = '';

            $div = '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'meeting/create&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['type'] . '\',\'lg\')"><i class="fa fa-tasks"></i></button>';
            $div .= '&nbsp;<a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=meeting/print&amp;id=' . $row['id'] . '&amp;type=RM"><i class="fa fa-file-pdf-o"></i></a>';
            $div .= '&nbsp; <button class="btn btn-primary btn-xs" title ="Send Mail" onclick="sendMail(' . $row['id'] . ')"><i class="fa fa-envelope"></i></button>';



            $div .= '&nbsp; <button class="btn btn-danger btn-xs" title ="Send Mail" onclick="deleteMeeting(' . $row['id'] . ')"><i class="fa fa-trash"></i></button>';

            // $div .= '&nbsp;<button class="btn btn-primary btn-xs" title ="add" onclick="loadPopupModal(\'meeting/CreateMeetingTransaction&meeting_id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['type'] . '\',\'md\')"><i class="fa  fa-exchange"></i></button>';
            $meeting_date = $row['meeting_date'];
            $meeting_date_arr = explode("-", $meeting_date);
            $meeting_date = $meeting_date_arr[2] . "/" . $meeting_date_arr[1] . "/" . $meeting_date_arr[0];
            $rowData[] = array($row->id, $meeting_date." ".$row["meeting_time"] , $row->types->type_name, 
                $row["meeting_title"],
                $row->Category,
                $row->host, $row->completed, '<div class="btn-wrap text-center">' . $div . '</div>', $row->isDue);
        }
        $data['cond'] = $condition;
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetDetailsList() {


        $status = Array(1 => "On Hold", 2 => "Open", 3 => 'Closed');
        $model = new MeetingTransaction;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.id',
            2 => 'meeting_date',
            3 => 'heading',
            4 => 'meeting_details',
            5 => 't.id',
            6 => 'closing_date',
            7 => 'complete_status',
            8 => "t.id"
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = ' t.complete_status IN (1,2) ';
        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = " ( t.heading LIKE '%" . $searchString . "%'  OR  t.meeting_details LIKE '%" . $searchString . "%'  OR t.action_taken  LIKE '%" . $searchString . "%'     OR meeting.meeting_title LIKE '%{$searchString}%' OR  meeting.id  LIKE '%{$searchString}%' OR employee.name LIKE '%{$searchString}%' )";
        }
        if (isset($_POST['isMeeting']) && trim($_POST['isMeeting']) != "") {
            $isMeeting = $_POST['isMeeting'];
            $condition .= " AND  meeting.ismeeting = '{$isMeeting}' ";
        }

        $orderBy = "meeting_date desc, complete_status asc ";
        $count = $model->with("meeting", "employee")->count(array('condition' => $condition));
        $model = $model->with("meeting", "employee")->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $i => $row) {
            $div = '';


            $div = '<button class="btn btn-primary btn-xs" title ="add" onclick="loadPopupModal(\'meetingactivity/Create&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['heading'] . '\',\'lg\')"><i class="fa   fa-tasks"></i></button>';

//            if ($row['complete_status'] != "3") {
//                $div .= '&nbsp;<button class="btn btn-success  btn-xs" title ="Close" onclick="CloseTransation(' . $row['id'] . ')"><i class="fa  fa-check"></i></button>';
//            }
            $meeting_date = $row['meeting']['meeting_date'];
            $meeting_date_arr = explode("-", $meeting_date);
            $meeting_date = $meeting_date_arr[2] . "/" . $meeting_date_arr[1] . "/" . $meeting_date_arr[0];

            $closing_time = $row['closing_date'];

            $closing_time_arr = explode("-", $closing_time);
            $closing_time = $closing_time_arr[2] . "/" . $closing_time_arr[1] . "/" . $closing_time_arr[0];
            $due = false;
            if (strtotime($row['closing_date']) < strtotime('now')) {
                if ($row['complete_status'] != "3") {
                    $due = true;
                }
            }

            $rowData[] = array(($i + 1),
                $row['meeting_id'] . ": " . $row['meeting']["meeting_title"],
                $meeting_date . " " . $row['meeting']["meeting_time"],
                $row["heading"],
                $row->shortDeatils,
                $row->stortActionTaken,
                $row->PersonName,
                $closing_time,
                $row->closed_at,
                $status[$row['complete_status']],
                '<div class="btn-wrap text-center">' . $div . ' </div>',
                $due
            );
        }
        $data['con'] = $condition;
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {

        $id = (int) Yii::app()->request->getParam('id');
        $model = new Meeting;
        $meeting_id = "0";
        if ($id > 0) {
            $model = $model->findByPk($id);
            $meeting_id = $model->id;
            $date_array = explode("-", $model->meeting_date);
            $model->meeting_date = $date_array[2] . "/" . $date_array[1] . "/" . $date_array[0];
        } else {
            $model->meeting_date = date('d/m/y');
        }
        $modeltransations = MeetingTransaction::model()->findAll([
            'condition' => 'meeting_id =' . $meeting_id,
            'order' => 'serial_no asc'
        ]);
        if (empty($modeltransations)) {

            $modeltransations = array(new MeetingTransaction);
            $modeltransations[0]->closing_date = date('y-m-d');
            $modeltransations[0]->meeting_id = $meeting_id;
            $modeltransations[0]->serial_no = "00";
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create', array('model' => $model, 'modeltransations' => $modeltransations));
    }

    public function actionCreateMeetingTransaction() {

        $meeting_id = (int) Yii::app()->request->getParam('meeting_id');

        $model = MeetingTransaction::model()->findAll('meeting_id =' . $meeting_id);
        if (empty($model)) {

            $model = array(new MeetingTransaction);
            $model[0]->closing_date = date('y-m-d');
            $model[0]->meeting_id = $meeting_id;
            $model[0]->serial_no = "00";
        }


        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create_trans', array('model' => $model, 'meeting_id' => $meeting_id));
    }

    public function actionSaveMeetingTransaction() {
        if (isset($_POST)) {
            date_default_timezone_set("Asia/Dubai");
            $models = array();
            $i = 0;
            $valid = true;
            $meeting_id = $_POST["meeting_id"];
            foreach ($_POST['MeetingTransaction'] as $key => $each) {
                $id = $_POST['MeetingTransaction'][$i]['id'];
                if ($id == "") {
                    $models[$i] = new MeetingTransaction;
                    $models[$i]->created_by = Yii::app()->user->id;
                    $models[$i]->created_date_time = date('Y-m-d H:i:s');
                } else {
                    $models[$i] = MeetingTransaction::model()->findByPk($id);
                }

                $models[$i]->updated_by = Yii::app()->user->id;
                $models[$i]->updated_date_time = date('Y-m-d H:i:s');

                $models[$i]->serial_no = $i;
                $models[$i]->meeting_id = $_POST["meeting_id"];
                $models[$i]->attributes = $_POST['MeetingTransaction'][$i];
                $closing_date = $_POST['MeetingTransaction'][$i]['closing_date'];
                if ($closing_date != "") {
                    $date_array = explode("/", $closing_date);
                    $models[$i]->closing_date = $date_array[2] . "-" . $date_array[1] . "-" . $date_array[0];
                }
                $valid = $valid && $models[$i]->validate();
                $i++;
            }
            if ($valid) {

                foreach ($models as $key => $value) {
                    $models[$key]->save();
                }
                echo json_encode(array('status' => 'success'));
            } else {
                $error_1 = json_decode(CActiveForm::validateTabular($models, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error_1));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionSave() {
        if (isset($_POST)) {
            date_default_timezone_set("Asia/Dubai");
            $model = new Meeting;
            if ((int) $_POST['Meeting']['id'] > 0) {
                $model = $model->findByPk($_POST['Meeting']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }

            $model->attributes = $_POST['Meeting'];
            $conducted_array = $_POST["conducted_by"];
            $attendees_array = $_POST["attendees"];
            $model->location_id = implode(',', $_POST['Meeting']['location_id']);
            $model->country_id = implode(',', $_POST['Meeting']['country_id']);
            $notify_array = $_POST["notify"];

            if (!empty($conducted_array)) {
                $model->conducted_by = implode(",", $conducted_array);
            }
            if (!empty($attendees_array)) {
                $model->attendees = implode(",", $attendees_array);
            }
            if (!empty($notify_array)) {
                $model->notify = implode(",", $notify_array);
            }

            if ($model->meeting_date != "") {
                $date_array = explode("/", $model->meeting_date);
                $model->meeting_date = $date_array[2] . "-" . $date_array[1] . "-" . $date_array[0];
            }
            $valid = $model->validate();

            $meetingTransaction = array();
            $i = 0;
            foreach ($_POST['MeetingTransaction'] as $key => $each) {
                $id = $_POST['MeetingTransaction'][$i]['id'];
                if ($id == "") {
                    $meetingTransaction[$i] = new MeetingTransaction;
                    $meetingTransaction[$i]->created_by = Yii::app()->user->id;
                    $meetingTransaction[$i]->created_date_time = date('Y-m-d H:i:s');
                } else {
                    $meetingTransaction[$i] = MeetingTransaction::model()->findByPk($id);
                }

                $meetingTransaction[$i]->updated_by = Yii::app()->user->id;
                $meetingTransaction[$i]->updated_date_time = date('Y-m-d H:i:s');


                $meetingTransaction[$i]->meeting_id = 0;

                $meetingTransaction[$i]->attributes = $_POST['MeetingTransaction'][$i];
                if (!is_numeric($meetingTransaction[$i]->person)) {
                    $meetingTransaction[$i]->other_email = $meetingTransaction[$i]->person;
                    $meetingTransaction[$i]->person = 0;
                }
                if (empty($meetingTransaction[$i]->serial_no)) {
                    $meetingTransaction[$i]->serial_no = $i;
                }
                $meetingTransaction[$i]->filename = $_POST['MeetingTransaction'][$i]['filename'];

                $closing_date = $_POST['MeetingTransaction'][$i]['closing_date'];
                if ($closing_date != "") {
                    $date_array = explode("/", $closing_date);
                    $meetingTransaction[$i]->closing_date = $date_array[2] . "-" . $date_array[1] . "-" . $date_array[0];
                }

                $valid = $valid && $meetingTransaction[$i]->validate();
                $i++;
            }


            if ($valid) {

                $model->save();
                foreach ($meetingTransaction as $value) {
                    $value->meeting_id = $model->id;
                    $value->save();
                }
                echo json_encode(array('status' => 'success'));
            } else {

                $error_1 = json_decode(CActiveForm::validateTabular($model, '', false), true);

                $error_2 = json_decode(CActiveForm::validateTabular($meetingTransaction, '', false), true);

                $error = CJSON::encode(array_merge_recursive($error_1, $error_2));

                echo $error;
            }
        }
    }

    // All Employee
    public function actiongetAllEmployee() {
        $condition = " t.isActive = 'Y' ";
        $location_id = Yii::app()->request->getparam("location_id");
        if ($location_id != '') {
            $condition .= " AND t.location IN(" . $location_id . ")";
        }
        $model = new Employee;
        $model_emp = $model->with('loc')->findAll(array('condition' => $condition, 'order' => 'name'));
        $emp_details = CHtml::listData($model_emp, 'id', 'name');
        $conducted = CHtml::dropDownList('conducted_by', "Meeting[conducted_by]", $emp_details, array('data-search' => true, 'multiple' => true, 'class' => 'form-control multi-select', 'name' => "Meeting[conducted_by]", 'data-label' => 'Conducted by <span style="color:red;">*</span>', 'title' => 'Conducted by', 'onchange' => 'updateDropDown()'));
        $attendees = CHtml::dropDownList('attendees', "Meeting[attendees]", $emp_details, array('data-search' => true, 'multiple' => true, 'class' => 'form-control multi-select', 'name' => "Meeting[attendees]", 'data-label' => 'Attendees <span style="color:red;">*</span>', 'title' => 'Conducted by', 'onchange' => 'updateDropDown()'));
        $notify = CHtml::dropDownList('notify', "Meeting[notify]", $emp_details, array('data-search' => true, 'multiple' => true, 'class' => 'form-control multi-select', 'name' => "Meeting[notify]", 'data-label' => 'Notify', 'title' => 'Notify'));
        $status = array("conducted" => $conducted,
            "attendees" => $attendees,
            'notify' => $notify,
            'data' => $emp_details,
        );
        echo CJSON::encode($status);
    }

    // All location from country
    public function actiongetAllLocations() {
        $countryid = Yii::app()->request->getparam("countryid");
        $select_id = Yii::app()->request->getparam("select_id");

        $condition = '1=1';
        if ($countryid != '') {
            $condition .= ' AND t.country_id IN(' . $countryid . ')';
        }


//        $modelLocation = MasLocations::model()->findAll(array('condition' => $condition));
//        $location_details = CHtml::listData($modelLocation, 'id', 'location');
        $dropBuilding = CHtml::dropDownList('Meeting[location_id]', "", [], array('class' => 'form-control', 'onchange' => ' getAllEmployee(this.id);', 'name' => "Meeting[location_id]", "data-search" => "true", 'data-label' => 'Location <span style="color:red;">*</span>', 'title' => 'Location', 'multiple' => true));


        $status = array("location" => $dropBuilding);
        echo CJSON::encode($status);
    }

    public function actionCreateSingleTransation() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new MeetingTransaction();
        $model = $model->findByPk($id);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('create_trans_single', array('model' => $model));
    }

    public function actionCloseTransation() {
        date_default_timezone_set("Asia/Dubai");
        $id = (int) Yii::app()->request->getParam('id');
        $model = new MeetingTransaction();
        $model = $model->findByPk($id);
        $model->complete_status = 3;
        $model->updated_by = Yii::app()->user->id;
        $model->updated_date_time = date('Y-m-d H:i:s');
        $model->closed_on = date('Y-m-d');
        $model->save();
        echo json_encode(array('status' => 'success'));
    }

    public function actiongetdropdown() {
        $data = Yii::app()->request->getParam('datas');
        $temp = array_filter(explode(",", $data));
        $condition = " id in (" . implode(",", $temp) . ")";
        $model = new Employee;
        $model_emp = $model->findAll(array('condition' => $condition));

        $result = "";
        foreach ($model_emp as $value) {
            $result .= '<option value="' . $value->id . '">' . $value->employeefullname . '</option>';
        }
        echo json_encode(array(
            "data" => $result
        ));
    }

    public function actionUpload() {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/uploads/agenda/';
// make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
//chmod($folder, 0755);
        }

        $allowedExtensions = array();
        $sizeLimit = 1 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $this->CropIfImage($folder, $fileName, 100, 100);
        echo $return; // it's array
    }

    public function actiondownloadFile() {
        $id = Yii::app()->request->getParam('id');
        $model = MeetingTransaction::model()->findByPk($id);
        $filename = Yii::app()->getBaseUrl(true) . 'uploads/agenda/' . $model->filename;
        header('Content-Type: application/octet-stream');
        header("Content-Transfer-Encoding: Binary");
        header("Content-disposition: attachment; filename=\"" . $model->filename . "\"");
        readfile($filename);
    }

    public function actionPrint() {
        $id = Yii::app()->request->getParam('id');
        $model = Meeting::model()->findByPk($id);
        $viewpage = "print";
        $title = "Minutes Of Meeting";
        //$this->renderPartial('application.views.front.meeting.' . $viewpage, array('model' => $model), true);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.meeting.' . $viewpage, array('model' => $model, 'title' => "Meeting Minutes"), true));
        $mPDF1->SetTitle($title);
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actiongetCalendarDetails() {
        $mine = isset(Yii::app()->user->havePermissionOn['meeting_mine']);
        $view_all = isset(Yii::app()->user->havePermissionOn['meeting_all']);
        $view = ($mine || $view_all || (Yii::app()->user->authorised_user == '1'));
        $edit = (Yii::app()->user->authorised_user == '1') || isset(Yii::app()->user->havePermissionOn['meeting_edit']);
        $start = Yii::app()->request->getParam('start');
        $end = Yii::app()->request->getParam('end');
        $condition = "t.closing_date >= '" . $start . "' and t.closing_date <= '" . $end . "'  AND complete_status != 3";
        $condition_act = "t.callback >= '" . $start . "' and t.callback <= '" . $end . "'";
        if (!$view_all) {
            if (Yii::app()->user->authorised_user != '1' && $mine) {
                $user_id = Yii::app()->user->id;
                $model_user = User::model()->findByPK($user_id);
                $emp_id = $model_user->connected_employee_id;
                $condition .= ' AND  t.person =  ' . $emp_id;
                $condition_act .= ' AND  transation.person =  ' . $emp_id;
            }
        }
        if (!$view) {
            $condition = "t.id=0";
        }
        $models = MeetingTransaction::model()->findAll(array(
            "condition" => $condition
        ));
        $data = array();

        foreach ($models as $value) {
            $data[] = array(
                "title" => $value->heading . "(" . $value->PersonName . ")",
                'start' => $value->closing_date,
                'color' => 'green',
                'trans_id' => $value->id,
                'tooltip' => "Agenda: " . $value->heading . "(" . $value->PersonName . ")<br>" . $value->meeting_details,
            );
        }

        $activity = MeetingActivity::model()->with('transation')->findAll(array(
            "condition" => $condition_act
        ));
        foreach ($activity as $value) {
            $data[] = array(
                "title" => $value->transation->heading . "(" . $value->transation->PersonName . ")",
                'start' => $value->callback,
                'color' => 'blue',
                'trans_id' => $value->transation_id,
                'tooltip' => "Activity : " . $value->transation->heading . "(" . $value->transation->PersonName . ")<br>" . $value->transation->meeting_details,
            );
        }
        echo json_encode($data);
    }

    public function actionMailSend() {

        $id = Yii::app()->request->getParam('id');
        $model = Meeting::model()->findByPk($id);
        $isActionList = ($model->isMeeting == 'N');
        $empModel = array();
        $notify = "0";
        $attendees = "0";
        $conducted_by = "0";
        if ($model->conducted_by != "") {
            $conducted_by = $model->conducted_by;
        }
        if ($model->notify != "") {
            $notify = $model->notify;
        }
        if ($model->attendees != "") {
            $attendees = $model->attendees;
        }
        $empModel = Employee::model()->findAll(array("condition" => ' t.id in (' . $notify . ')  OR   t.id in ( ' . $attendees . ') OR t.id IN ( ' . $conducted_by . ')'));

        $viewpage = "print";
        $subject = "Minutes Of Meeting - {$model->id} : " . $model->meeting_title;
        $filename = 'minutes_of_Meeting.pdf';
        if ($isActionList) {
            $subject = "Action List - {$model->id} : " . $model->meeting_title;
            $filename = 'action_list.pdf';
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.meeting.' . $viewpage, array('model' => $model, 'title' => $isActionList ? "Action List" : "Meeting Minutes"), true));
        $mPDF1->SetTitle($subject);
        if ($isActionList) {
            $file_path = 'uploads/agenda/action_list.pdf';
        } else {
            $file_path = 'uploads/agenda/minutes_of_Meeting.pdf';
        }
        $mPDF1->Output($file_path, 'F');
        $message = new YiiMailMessage;
        $mailContent = array();
        $mailContent["model"] = $model;
        $mailContent['title'] = 'Digitalog ';
        $mailContent['baseurl'] = "https://blueskyprojects.me" . Yii::app()->baseUrl;
        $message->view = "meeting_mail";
        $message->setBody(array('mailContent' => $mailContent), 'text/html');
        $message->subject = $subject;
        $message->from = ['digitalog_meeting@blueskyerp.me' => 'Digitalog Meeting'];
        foreach ($empModel as $value) {
            if ($value->email_id != "") {
                $message->addTo(trim($value->email_id));
            }
        }
        if (!empty($model->others)) {
            $other_array = json_decode($model->others);
            foreach ($other_array as $value) {
                if ($value->email != "") {
                    $message->addTo(trim($value->email));
                }
            }
        }
        $message->addBCC('manu.varghese236@gmail.com');
        // $message->addBCC('arunjv@gmail.com');
        $swiftAttachment = Swift_Attachment::fromPath($file_path)->setFilename($subject . '.pdf'); // create a Swift Attachment          
        $message->attach($swiftAttachment);
        $result = Yii::app()->mail->send($message);
        if ($result) {
            $json['status'] = 'success';
            $json['result'] = $result;
        } else {
            $json['status'] = 'error';
        }

        echo json_encode($json);
        Yii::app()->end();
    }

    public function actionmailinvestigationExcel() {
        $country = Yii::app()->request->getParam('country');
        $location = Yii::app()->request->getParam('location');
        $department = Yii::app()->request->getParam('department');
        $incident_report_from_date = Yii::app()->request->getParam('incident_report_from_date');
        $incident_report_to_date = Yii::app()->request->getParam('incident_report_to_date');

        $incident_from_date = Yii::app()->request->getParam('incident_from_date');
        $incident_to_date = Yii::app()->request->getParam('incident_to_date');
        $incident_type = Yii::app()->request->getParam('incident_type');
        $involved_person = Yii::app()->request->getParam('involved_person');
        $first_aid_applied = Yii::app()->request->getParam('first_aid_applied');


        $incident_classification = Yii::app()->request->getParam('incident_classification');
        $loss_classification = Yii::app()->request->getParam('loss_classification');
        $reporting_criteria = Yii::app()->request->getParam('reporting_criteria');
        $dart_days = Yii::app()->request->getParam('dart_days');
        $Severity = Yii::app()->request->getParam('Severity');
        $closed_date = Yii::app()->request->getParam('closed_date');

        $closed_date_to = Yii::app()->request->getParam('closed_date_to');
        $closed_status = Yii::app()->request->getParam('closed_status');

        //Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $param = array('country' => $country,
            'location' => $location,
            'department' => $department,
            'incident_report_from_date' => $incident_report_from_date,
            'incident_report_to_date' => $incident_report_to_date,
            'incident_from_date' => $incident_from_date,
            'incident_to_date' => $incident_to_date,
            'reporting_criteria' => $reporting_criteria,
            'dart_days' => $dart_days,
            'Severity' => $Severity,
            'incident_type' => $incident_type,
            'involved_person' => $involved_person,
            'first_aid_applied' => $first_aid_applied,
            'incident_classification' => $incident_classification,
            'loss_classification' => $loss_classification,
            'closed_date' => $closed_date,
            'closed_date_to' => $closed_date_to,
            'closed_status' => $closed_status
        );
        $filename = 'Investigation_List.xls';
        date_default_timezone_set("Asia/Dubai");
        $message = new YiiMailMessage;
        $subject = 'Investigation_Report';
        $mailContent = array();
        $mailContent['title'] = 'Digitalog - Investigation Report';
        $mailContent['baseurl'] = "https://blueskyprojects.me" . Yii::app()->baseUrl;
        $view = 'investigation_report_mail';
        //pdf upload
        /* $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
          $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
          $mPDF1->WriteHTML($stylesheet, 1);
          $mPDF1->WriteHTML($this->renderPartial('application.views.front.report.pdf.investigation_list',$param, true));
          $mPDF1->SetTitle($subject);
          $file_path = 'uploads/excel/'.$subject.'.pdf';
          $mPDF1->Output($file_path, 'F'); */
        //excel download        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');
        file_put_contents('uploads/excel/filedetail.xls', $this->renderPartial('application.views.front.excel.investigation_list', $param, true));
        //excel download  end
        $message->view = $view;
        $message->setBody(array('mailContent' => $mailContent), 'text/html');
        $message->subject = $subject;
        $message->from = 'digitalog@blueskyerp.me';
        $message->addTo('arun@mailbluesky.com');
        $message->addCC('arunjv@gmail.com');
        $message->addCC('jisha@mailbluesky.com');
        $message->addCC('jishajacob11@gmail.com');
        $message->addCC('dksnrajan@gmail.com');
        $swiftAttachment = Swift_Attachment::fromPath('uploads/excel/filedetail.xls')->setFilename($subject . '.xls'); // create a Swift Attachment          
        $message->attach($swiftAttachment);
        Yii::app()->mail->send($message);
        $json['mailstatus'] = 'mailsuccess';
        echo json_encode($json);
        Yii::app()->end();
    }

    public function actiongetemployeelist() {
        $id = Yii::app()->request->getParam('id');
        $id = implode(",", $id);
        $data = [];
        if (!empty($id)) {
            $condition = "t.id IN ({$id}) ";
            $string = "";
            $models = MasEmployeeGroup::model()->findAll(['condition' => $condition]);
            foreach ($models as $key => $value) {
                $string .= "," . $value->employee_ids;
            }
            $data = explode(",", $string);
        }
        echo json_encode(['data' => $data]);
    }

    function actiongetselectedemployeelist() {
        $attendees = Yii::app()->request->getParam('attendees');
        $conducted_by = Yii::app()->request->getParam('conducted_by');
        $others = Yii::app()->request->getParam('others');
        if (is_array($attendees)) {
            $attendees = implode(",", $attendees);
        }
        $notify = Yii::app()->request->getParam('notify');
        if (is_array($notify)) {
            $notify = implode(",", $notify);
        }
        if (is_array($conducted_by)) {
            $conducted_by = implode(",", $conducted_by);
        }
        $this->renderPartial('emp_list', array('attendees' => $attendees, 'notify' => $notify, 'conducted_by' => $conducted_by, 'others' => $others));
    }

    public function actionDeleteMeeting() {
        $id = Yii::app()->request->getParam('id');
        Meeting::model()->deleteByPk($id);
        MeetingTransaction::model()->deleteAll("meeting_id ={$id}");
        MeetingActivity::model()->deleteAll("meeting_id ={$id}");
        $json['status'] = 'success';
        echo json_encode($json);
        Yii::app()->end();
    }

}
