<?php
class MaterialReceiptController extends Controller
{
    public $layout = 'layout';
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'Savematerial', 'UploadDocuments', 'GetMaterialRequestList', 'Print'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {

        return array('accessControl'); // perform access control for CRUD operations

    }

    function getRemaining($order_item_id, $quantity)
    {
        $remianing = 0;
        if ($order_item_id > 0) {
            // echo 'SELECT (SUM(received_quantity)-SUM(damaged_quantity)) FROM erp_purchasing_material_receipt_item WHERE order_item_id=' . $order_item_id;
            $received = Yii::app()->db->createCommand('SELECT (SUM(received_quantity)-SUM(damaged_quantity)) FROM erp_purchasing_material_receipt_item WHERE order_item_id=' . $order_item_id)->queryScalar();
            $remianing = $quantity - $received;
        }
        return $remianing;
    }

    function getReceived($purchase_order_id)
    {
        $query = 'SELECT ( SUM(received_quantity)-SUM(damaged_quantity) ) AS received_quantity FROM erp_purchasing_material_receipt_item MI LEFT JOIN erp_purchasing_material_receipt MR ON MR.id = MI.purchasing_materialreceipt_id WHERE MR.po_id=' . $purchase_order_id;
        return Yii::app()->db->createCommand($query)->queryScalar();
    }

    public function actionIndex()
    {
        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['purchase_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['purchase_material_view']) &&
                Yii::app()->user->havePermissionOn['purchase_menu_view'] &&
                Yii::app()->user->havePermissionOn['purchase_material_view']
            )
        ) {
            $this->render('index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }
    public function actionCreate()
    {

        $order_id = (int) Yii::app()->request->getParam('order_id');
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $id = (int) Yii::app()->request->getParam('id');

        $model = new PurchasingMaterialreceipt();
        $modelMaterialRecieptItems = array(new PurchasingMaterialreceiptItem());
        $modelDocument = new Document();
        $modelNotes = new FileNotes();
        $modelBill = new MasBillType();

        if ($order_id > 0) {
            $model_order = PurchasingOrder::model()->findByPk($order_id);
            $model->attributes = $model_order->attributes;

            $model->po_id = $model_order->id;
            $model->file_id = $model_order->file_id;
            $model->ticket_id = $model_order->ticket_id;
            $model->project_classification_id = $model_order->project_classification_id;
            $model->contract_id = $model_order->contract_id;
            //$modelOrderItems = PurchasingOrderStockItem::model()->with('product')->findAll(array('condition'=>'t.purchasing_order_id = "'.$order_id.'" AND NOT product.inventory_item_type="2"'));
            $modelOrderItems = PurchasingOrderStockItem::model()->with('product')->findAll(array('condition' => 't.purchasing_order_id = "' . $order_id . '"'));
            $k = 0;
            $i = 0;

            foreach ($modelOrderItems as $eachItem) {
                $remaining_qty = $this->getRemaining((int) $eachItem->id, (float) $eachItem->stock_item_quantity);
                // var_dump($remaining_qty);
                if ($remaining_qty > 0 && $eachItem->stock_item_id > 0):

                    $modelMaterialRecieptItems[$i] = new PurchasingMaterialreceiptItem;
                    $modelMaterialRecieptItems[$i]->order_item_id = $eachItem->id;
                    $modelMaterialRecieptItems[$i]->product_id = $eachItem->stock_item_id;
                    $modelMaterialRecieptItems[$i]->product_name = $eachItem->stock_item_name;
                    $modelMaterialRecieptItems[$i]->part_no = $eachItem->product->part_number;
                    $modelMaterialRecieptItems[$i]->description = $eachItem->stock_item_description;
                    $modelMaterialRecieptItems[$i]->unit = $eachItem->unitdetails->name;
                    $modelMaterialRecieptItems[$i]->unit_id = $eachItem->unitdetails->id;
                    $modelMaterialRecieptItems[$i]->quantity = $eachItem->stock_item_quantity;
                    $modelMaterialRecieptItems[$i]->max_quantity = $eachItem->stock_item_max_qty;
                    $modelMaterialRecieptItems[$i]->remaining_quantity = $remaining_qty;
                    $modelMaterialRecieptItems[$i]->rate = $eachItem->stock_item_rate;
                    $modelMaterialRecieptItems[$i]->received_quantity = $remaining_qty;
                    $i++;
                endif;
            }
        }
        if ($id > 0) {
            $model = PurchasingMaterialreceipt::model()->findByPk($id);
            $model = $model->items;
        }
        if ($model->mrv_receipt_date != '' && $model->mrv_receipt_date != '0000-00-00') {
            $model->mrv_receipt_date = date('d/m/y', strtotime($model->mrv_receipt_date));
        } else {
            $model->mrv_receipt_date = date('d/m/Y');
        }
        if ($model->dly_date != '' && $model->dly_date != '0000-00-00') {
            $model->dly_date = date('d/m/y', strtotime($model->dly_date));
        } else {
            $model->dly_date = '';
        }
        if (empty($modelMaterialRecieptItems)) {
            $modelMaterialRecieptItems = array(new PurchasingMaterialreceiptItem());
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array(
            'model' => $model,
            'file_id' => $file_id,
            'modelDocument' => $modelDocument,
            'modelNotes' => $modelNotes,
            'modelMaterialRecieptItems' => $modelMaterialRecieptItems,
            'po_id' => $order_id,
            'modelBill' => $modelBill
        ));
    }



    public function actionSavematerial()
    {


        $other_err = array();
        $modelMaterial = new PurchasingMaterialreceipt();

        if (isset($_POST['PurchasingMaterialreceipt'])) {
            //aaded by priya 0n 11.9.24 check stocklockflag
            $modelCompanySettings = new MasCompanySettings();
            $condition = 'crm_company_id = ' . (int) Yii::app()->user->master_user_company_id;
            $modelCompanySettings = $modelCompanySettings->find(array('condition' => $condition));
            $stock_lock_flag = $modelCompanySettings->stock_lock_flag;
            if ($stock_lock_flag == "N") {
                /////////////

                $scenario = '';
                if ((int) $_POST['PurchasingMaterialreceipt']['id'] > 0) {
                    $modelMaterial = $modelMaterial->findByPK($_POST['PurchasingMaterialreceipt']['id']);
                    $modelMaterial->scenario = 'update';
                    $scenario = 'update';
                    $audit_type = 'UPDATED'; // for audit log changes
                } else {
                    $modelMaterial->created_by = Yii::app()->user->id;
                    $modelMaterial->created_datetime = date('Y-m-d H:i:s');
                    $scenario = 'add';
                    $audit_type = 'CREATED'; // for audit log changes    
                }
                $modelMaterial->updated_by = Yii::app()->user->id;
                $modelMaterial->updated_datetime = date('Y-m-d H:i:s');
                $modelMaterial->attributes = $_POST['PurchasingMaterialreceipt'];
                if ($_POST['PurchasingMaterialreceipt']['dly_date'] != '00/00/0000' && $_POST['PurchasingMaterialreceipt']['dly_date'] != '') {
                    $modelMaterial->dly_date = str_replace('/', '-', $_POST['PurchasingMaterialreceipt']['dly_date']);
                    $modelMaterial->dly_date = date("Y-m-d", strtotime($modelMaterial->dly_date));
                }
                if ($_POST['PurchasingMaterialreceipt']['mrv_receipt_date'] != '00/00/0000' && $_POST['PurchasingMaterialreceipt']['mrv_receipt_date'] != '') {
                    $modelMaterial->mrv_receipt_date = str_replace('/', '-', $_POST['PurchasingMaterialreceipt']['mrv_receipt_date']);
                    $modelMaterial->mrv_receipt_date = date("Y-m-d", strtotime($modelMaterial->mrv_receipt_date));
                }

                $modelMaterial->crm_user_id = Yii::app()->user->id;
                $modelMaterial->created_by = Yii::app()->user->id;
                $modelMaterial->created_datetime = date('Y-m-d H:i:s');
                $modelMaterial->updated_by = Yii::app()->user->id;
                $modelMaterial->updated_datetime = date('Y-m-d H:i:s');
                $modelMaterial->ticket_id = $_POST['PurchasingMaterialreceipt']['ticket_id'];
                $modelMaterial->project_classification_id = $_POST['PurchasingMaterialreceipt']['project_classification_id'];
                $modelMaterial->contract_id = $_POST['PurchasingMaterialreceipt']['contract_id'];

                $valid = $modelMaterial->validate();

                if (!empty($_POST['PurchasingMaterialreceiptItem'])) {

                    foreach ($_POST['PurchasingMaterialreceiptItem'] as $i => $item) {
                        if ($item['product_id'] > 0) {
                            $arr_product_details = Store::model()->findByPk($item['product_id']);

                            $modelItem[$i] = new PurchasingMaterialreceiptItem();
                            $modelItem[$i]->created_by = Yii::app()->user->id;
                            $modelItem[$i]->created_datetime = date('Y-m-d h:i:s');
                            $modelItem[$i]->attributes = $item;
                            $modelItem[$i]->description = $arr_product_details->description;
                            $modelItem[$i]->updated_by = Yii::app()->user->id;
                            $modelItem[$i]->updated_datetime = date('Y-m-d h:i:s');
                            $modelItem[$i]->purchasing_materialreceipt_id = '0';
                            $valid = $modelItem[$i]->validate() && $valid;

                            $remianing = $this->getRemaining($item['order_item_id'], $item['max_quantity']);
                            if ($item['received_quantity'] > $remianing) {
                                $valid = false;
                                $other_err[] = 'Item ' . $item['product_name'] . ' is already received!';
                            }
                        }
                    }
                }

                if ($valid) {

                    echo CJSON::encode(array('status' => 'success'));

                    $modelMaterial->save();

                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'MATERIAL_RECEIPT',
                        Yii::app()->user->id,
                        $audit_type,
                        " MTRL ID - {$modelMaterial->id} "
                    );
                    // end audit log 
                    $modelMaterial->tracking_no = (trim($modelMaterial->tracking_no) == '') ? $modelMaterial->id : $modelMaterial->tracking_no;
                    $modelMaterial->batch_no = (trim($modelMaterial->batch_no) == '') ? $modelMaterial->id : $modelMaterial->batch_no;
                    $modelMaterial->update();
                    foreach ($modelItem as $eachItem) {
                        $eachItem->purchasing_materialreceipt_id = $modelMaterial->id;
                        $eachItem->save(false);
                    }

                    $totalReceived = $this->getReceived($modelMaterial->po_id);
                    $orderModel = PurchasingOrder::model()->findBypk($modelMaterial->po_id);
                    $completed = ($totalReceived >= $orderModel->totalordered) ? true : false;
                    $orderModel->completed = ($completed) ? 'Y' : 'P';
                    $orderModel->convert_status = ($completed) ? 'N' : 'Y';
                    $orderModel->save(false);

                    if ($_POST['FileNotes']['notes'] != '') {
                        if ((int) @$_POST['FileNotes']['id'] > 0) {
                            $notes_id = (int) @$_POST['FileNotes']['id'];
                            $modelNotes = $modelNotes->findByPk($notes_id);
                            $modelNotes->updated_by = Yii::app()->user->id;
                            $modelNotes->updated_datetime = date('Y-m-d h:i:s');
                        } else {
                            $modelNotes->created_by = Yii::app()->user->id;
                            $modelNotes->created_datetime = date('Y-m-d h:i:s');
                        }
                        $modelNotes->notes = $_POST['FileNotes']['notes'];
                        $modelNotes->crm_user_id = Yii::app()->user->id;
                        $modelNotes->customer_vendor_id = $model->vendor_id;
                        $modelNotes->customer_vendor_type = 2;
                        $modelNotes->file_note_from = 1;
                        $modelNotes->file_id = $model->file_id;
                        $modelNotes->attributes = $_POST['FileNotes'];
                        $modelNotes->save(false);
                    }
                    if ($_POST['Icon']['file'] != '') {
                        if (implode(',', $_POST['Icon']['file']) != '') {
                            if ((int) @$_POST['Document']['id'] > 0) {
                                $doc_id = (int) @$_POST['Document']['id'];
                                $modelDocument = Document::model()->findByPk($doc_id);
                                $modelDocument->updated_by = Yii::app()->user->id;
                                $modelDocument->updated_datetime = date('Y-m-d h:i:s');
                                $arr_doc_photos = $_POST['Icon']['file'];
                                if (!empty($arr_doc_photos)) {
                                    Document::model()->updateByPk($modelDocument->id, array('document_name' => 'JA'));
                                }
                            } else {
                                $modelDocument = new Document;
                                $arr_doc_photos = $_POST['Icon']['file'];
                                if (!empty($arr_doc_photos)) {
                                    $modelDocument->uploaded_from = "M_R";
                                }
                                $modelDocument->file_id = $modelMaterial->file_id;
                                $modelDocument->created_by = Yii::app()->user->id;
                                $modelDocument->created_datetime = date('Y-m-d h:i:s');
                            }
                            $modelDocument->document_name = implode(',', $arr_doc_photos);
                            $modelDocument->save(false);
                        }
                    }
                    if ($modelMaterial->file_id != '')
                        MasterFile::model()->updateByPk($modelMaterial->file_id, array('current_process_status' => "M_R"));

                    if ($scenario == 'add') {
                        $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="15"'));
                        Yii::import('application.controllers.front.MasternotificationController');
                        /*
                        if($model_mail_setting->mail_required=='Y'){      
                            MasternotificationController::sendmail(15,$modelMaterial->id);
                        }
                        if($model_mail_setting->notification_required=='Y'){                    
                            MasternotificationController::sendnotification(15,$modelMaterial->id);
                        }
                        if($model_mail_setting->sms_required=='Y'){                    
                            MasternotificationController::sendsms(15,$modelMaterial->id);
                        }
                        */
                    }
                } else {
                    $error4 = array();
                    $error1 = json_decode(CActiveForm::validate($modelMaterial, '', false), true);
                    if ($modelItem[0]->product_name != '')
                        $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                    else
                        $error2[] = "Please add atleast one line item";
                    $error = CJSON::encode(array_merge_recursive($error1, $error2, $other_err, $error4));
                    if ($error != '[]' || $error != '')
                        echo $error;
                }

            } else {
                echo CJSON::encode(array('error' => ' Transactions are already locked, so we cannot convert them to a Material Receipt!'));
            }
        }


    }

    public function actionGetMaterialRequestList()
    {

        //$model = new PurchasingOrder();
        $model = new PurchasingMaterialreceipt();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.po_id',
            2 => 't.id',
            3 => 'vendor_details.vendor_name',
            4 => 't.qcchecked',
            5 => 'file.current_process_status',
            6 => 't.mrv_receipt_date',
            7 => 't.id',
            8 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "file.current_process_status = 'M_R' ";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "t.po_id LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR vendor_details.vendor_name LIKE '%" . $searchString . "%' ";
        }
        $count = $model->with('file', 'vendor_details')->count(array('condition' => $condition));
        $model = $model->with('file', 'vendor_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));


        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $i = 1;
        foreach ($model as $row) {
            $req_date = date("d/m/Y", strtotime($row->mrv_receipt_date));
            if ($row['qcchecked'] == 'N') {
                $quality_control_status = "Not Done";
            } else {
                $quality_control_status = "Completed";
            }
            $edit = '';
            // if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_material_view"])){
            //     $edit = ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'materialreceipt/create&id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\'Material Receipt - ' . $row['file_id'] . '\',\'xl\')" title="View"><i class="fa fa-eye" aria-hidden="true"></i></i></button>';
            // }
            if (Yii::app()->user->authorised_user == 1 || isset(Yii::app()->user->havePermissionOn["purchase_material_print"]))
                $edit .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=materialreceipt/Print&id=' . $row['id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
            if ($row['file']['current_process_status'] == 'P_O') {
                $status = 'Order';
            } else if ($row['file']['current_process_status'] == 'M_R') {
                $status = 'Material Reciept';
            } else if ($row['file']['current_process_status'] == 'Q_C') {
                $status = 'Quality Checked';
            } else if ($row['file']['current_process_status'] == 'P_I') {
                $status = 'Purchase Invoice';
            }
            $rowData[] = array($i, $row['file_id'], $row['po_id'], $row['id'], $row['vendor_details']['vendor_name'], $quality_control_status, $req_date, $status);
            $i++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }


    public function actionPrint()
    {

        $id = Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        $printtype = Yii::app()->request->getParam('printtype');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        // $mPDF1->SetWatermarkImage('images/watermark.jpg');
        // $mPDF1->showWatermarkImage = true;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        if ($printtype == 'summary') {
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.material_receipt_summary', array('id' => $id, 'type' => $type,'printtype' => $printtype), true));
        } else {
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.material_receipt', array('id' => $id, 'type' => $type,'printtype' => $printtype), true));

        }
        $mPDF1->Output("MATERIAL_RECEIPT_" . $id . ".pdf", 'I');
    }

}