<?php

class MastersettingsController extends Controller
{
	public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','CreateBankDetails','BankDetailsSave','GetBankDetailsList','SaveCompany','SaveSettings','SaveModule',
                      'UploadProfilePhoto','DeleteBankDetails','AddSettingsPwd','SaveSettingsPassword','SettimgsLogin','MasSettingsLogin','SaveMascode',
                      'GetValue','DeleteValue','Reset'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
    
    public function actionIndex()
    {
        $model = new MasCompany();
        
        $model_settings = new MasCompanySettings();
        

        $id  = (int) Yii::app()->request->getParam('id');
        $tab = Yii::app()->request->getParam('tab');

        $id = 1;
        $company_id   = "";

        if ($id > 0) {

            $model = $model->findByPk($id);
            $company_id = $id;

        }        

        $modelCountry = MasCountry::model()->findAll();

        $countryList = CHtml::listData($modelCountry, 'id', 'country_name');
        
        $modelCurrency = MasCurrency::model()->findAll();

        $currencyList = CHtml::listData($modelCurrency, 'id', 'currency');
        
        $model_terms = MasCompanyTermsConditions::model()->findAll();
        if(empty($model_terms)){
            $model_terms=array(new MasCompanyTermsConditions());
        } 
        
        
        
        $se_condition    = 'crm_company_id='.$company_id;
        $count           = $model_settings->count(array('condition'=>$se_condition));
        if ($count > 0) {
            $settings           = $model_settings->find(array('condition'=>$se_condition));
           /* print_r($settings);
           die(); */
            $model_settings_id  = $settings->id;
            $model_settings     = $model_settings->findByPk($model_settings_id);
        }
        

        //if (Yii::app()->session['master_settings_login'] != ''){
            
            $this->render('index', array('model' => $model,'model_settings'=>$model_settings, 'countryList' => $countryList, 'currencyList' => $currencyList,'tab'=>$tab,'company_id'=>$company_id,'model_terms'=>$model_terms), false, true);
            
        /* }
        else{
            
            $this->redirect('index.php?r=site/index');
        } */
        
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false, '*.css' => false);
        //$this->render('index', array('model' => $model), false, true);
        //$this->render('index');
    }
    
    public function actionCreateBankDetails(){

        

        $model = new MasCompanyBankDetails();

        

        //for country dropdown

        $modelCountry = MasCurrency::model()->findAll();

        $countryList = CHtml::listData($modelCountry, 'id', 'currency');

        

        //for bank dropdown

        $modelBank = MasBank::model()->findAll();

        $bankList = CHtml::listData($modelBank, 'id', 'bank_name');

        

        $id = (int) Yii::app()->request->getParam('id');

        

        if( $id > 0 ){

                $model = $model->findByPk($id);

        }

        

        //$this->render('company_bank_details_form', array('model' => $model, 'currencyList' => $countryList, 'bankLIst' => $bankList), false, true);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('company_bank_details_form', array('model' => $model, 'currencyList' => $countryList, 'bankLIst' => $bankList), false, true);
        
        
        

    }
    
    public function actionBankDetailsSave(){

        

        $model=new MasCompanyBankDetails();

    	/************ START Code for Save ***************/

    	if (isset($_POST['MasCompanyBankDetails'])) {

    		

    		if ((int) @$_POST['MasCompanyBankDetails']['id'] > 0) {

                        $model->id = (int) $_POST['MasCompanyBankDetails']['id'];

                        $model = $model->findByPK($model->id);

                }else{

                }

                

            $model->attributes=$_POST['MasCompanyBankDetails'];

            if ($model->save())

                {

                        $jsonData['status'] = 'success';

                        $jsonData['frm'] = $_POST['company_bank_details_form'];

                        $jsonData['id'] = $model->id;

	                echo CJSON::encode($jsonData);

                }

                else

                {

                        $error = CActiveForm::validate($model, '', false);

                        if ($error != '[]')

		               echo $error;

                }



        }

        

    }
    
    public function actionGetBankDetailsList(){

        

        

        $model=new MasCompanyBankDetails();

                $draw    = $_POST['draw'];

                $offset = $_POST['start'];

                $limit  = $_POST['length'];

                $columns = array(

                // datatable column index  => database column name

                   0 =>'bank_account_name',

                   1 =>'bank_id',

                   2 =>'currency_id',

                   3 =>'bank_branch',

                   4 =>'bank_ac_no',

                   5 =>'bank_tax_id',

                   6 =>'bank_iban',

                   7 =>'bank_swift',

                   8 =>'bank_ifsc',

                   9 =>'bank_others',

                 

                   );

                $filterColumn = $columns[$_POST['order'][0]['column']];

                $filterOrder  = $_POST['order'][0]['dir'];

                $orderBy   = $filterColumn." ".$filterOrder;

                $condition = 't.isActive="Y"';

                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")

                {

                  $searchString = $_POST['search']['value'];

                  $condition.=" and (bank_account_name LIKE '%".$searchString."%')";

                }

                $count = $model->count(array('condition'=>$condition));

                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));

                $recordsTotal = $count;

                $recordsFiltered = $count;

                $data['draw'] = $draw;

                $data['recordsTotal'] = $recordsTotal;

                $data['recordsFiltered'] = $recordsFiltered;

                $rowData=array();

                $m=1;

                foreach ($model as $row)

                {

                    $rowData[]=array($m,$row->bank['bank_name'],$row['bank_branch'],$row['bank_account_name'],$row['bank_ac_no'],$row['bank_ifsc'],

              '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'mastersettings/CreateBankDetails&id='.$row['id'].'\',\'Edit Bank\',\'lg\');return false;"><i class="fa fa-pencil"></i></button> '

             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteBankDetails('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');

                    $m++;

                }

                $data['data'] = $rowData;

                echo json_encode($data);

        

    }
    
    
    public function actionSaveCompany() {

        $model = new MasCompany();

        /*         * ********** START Code for Save ************** */

        if (isset($_POST['MasCompany'])) {

            if ((int) @$_POST['MasCompany']['id'] > 0) {

                $model->id = (int) $_POST['MasCompany']['id'];

                $model = $model->findByPK($model->id);

                $model->crm_user_id = Yii::app()->user->id;

            } else {

                

            }

            $model->attributes = $_POST['MasCompany'];

            $model->company_logo = $_POST['Icon']['file'];
            
            $validate=$model->validate();
            
            if (isset($_POST['MasCompanyTermsConditions'])) {
                    foreach ($_POST['MasCompanyTermsConditions'] as $i => $items) {
                        if ($items['id']>0) {
                            $modal_terms[$i] = MasCompanyTermsConditions::model()->findByPK($items['id']);   
                        }else{
                            $modal_terms[$i] = new MasCompanyTermsConditions;   
                        }
                        $modal_terms[$i]->type  = $items['type'];
                        $modal_terms[$i]->terms_conditions = $items['terms_conditions'];
                        
                        $validate = $modal_terms[$i]->validate() && $validate;                   
                    }
                }

            //if ($model->save()) {
            if($validate){
                
                $model->save();
                
                if(!empty($modal_terms)){
                    //MasCompanyTermsConditions::model()->deleteAll();
                        foreach ($modal_terms as $eachModel) {
                            $eachModel->save();   
                        }
                }

                $jsonData['status'] = 'success';

                $jsonData['frm'] = $_POST['company-form'];

                $jsonData['id'] = $model->id;

                echo CJSON::encode($jsonData);

            } else {
                
                
                $error = json_decode(CActiveForm::validate($model, '', false), true); 
                $error1 = json_decode(CActiveForm::validate($modal_terms, '', false), true);                    
                $error = CJSON::encode(array_merge_recursive($error,$error1));
                if ($error != '[]')
                echo $error;
                
            }

        }

    }
    
    
    
    public function actionSaveSettings() {



        $model = new MasCompanySettings();

        /*         * ********** START Code for Save ************** */
//die();
        if (isset($_POST['MasCompanySettings'])) {

            if ((int) @$_POST['MasCompanySettings']['id'] > 0) {

                $model->id = (int) $_POST['MasCompanySettings']['id'];

                $model = $model->findByPK($model->id);

                $model->crm_user_id = Yii::app()->user->id;

            } 

            $company_id   =  $_POST['companyid'];
            if($company_id >0){
                $model->attributes     = $_POST['MasCompanySettings'];            
                $model->crm_user_id    = Yii::app()->user->id;
                $model->create_by      = Yii::app()->user->id;
                $model->qualitycontrol = $_POST['MasCompanySettings']['qualitycontrol'];
                $model->direct_invoive = $_POST['MasCompanySettings']['direct_invoive'];
                $model->print_type = $_POST['MasCompanySettings']['print_type'];
                $model->stock_updates_on = $_POST['MasCompanySettings']['stock_updates_on'];
                $model->direct_order = $_POST['MasCompanySettings']['direct_order'];
                $model->direct_quotation = $_POST['MasCompanySettings']['direct_quotation'];
                $model->direct_purchase_order = $_POST['MasCompanySettings']['direct_purchase_order'];
                $model->direct_purchase_enquiry = $_POST['MasCompanySettings']['direct_purchase_enquiry'];
                $model->sales_return = $_POST['MasCompanySettings']['sales_return'];
                $model->allow_change_description = $_POST['MasCompanySettings']['allow_change_description'];
                $model->crm_company_id =  $_POST['companyid'];
                $model->include_vat = $_POST['MasCompanySettings']['include_vat'];
                if ($model->save()) {
                    $jsonData['status'] = 'success';
    
                    $jsonData['frm'] = $_POST['company-form'];
    
                    $jsonData['id'] = $model->id;
    
                    echo CJSON::encode($jsonData);
    
                } else {
    
                    $error = CActiveForm::validate($model, '', false);
    
                    if ($error != '[]')
    
                        echo $error;
    
                }
            }
            else
            {
                $jsonData['status'] = 'Company Not Registered';
                echo CJSON::encode($jsonData);
            }
        }

    }
    
    
    public function actionSaveModule() {

    
    
    $model = new MasCompanySettings();

        /*         * ********** START Code for Save ************** */
//die();
        if (isset($_POST['MasCompanySettings'])) {
            
            if ((int) @$_POST['MasCompanySettings']['id'] > 0) {
                        //$model->updated_by = Yii::app()->user->id;
                        //$model->updated_datetime =date('Y-m-d h:i:s');
    			$model->id = (int) $_POST['MasCompanySettings']['id'];
    			$model = $model->findByPK($model->id);
    		}
            $model->attributes = $_POST['MasCompanySettings'];
            $allPermissions = array();
            foreach ($_POST['MasCompanySettings']['permissions'] as $eachPermissionArray)
            { 
                if (is_array($eachPermissionArray)){ 
                    foreach ($eachPermissionArray as $eachPermission){
                        $allPermissions[$eachPermission] = 1;
                    }
                }
            }
            $model->permissions = json_encode($allPermissions);
            
            //echo $allPermissions;
            if ($model->save())
            {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
            else
            {
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                        echo $error;
            }
            


            

        }

        /*$model = new MasCompanySettings();

        
        if (isset($_POST['MasCompanySettings'])) {

            if ((int) @$_POST['MasCompanySettings']['id'] > 0) {

                $model->id = (int) $_POST['MasCompanySettings']['id'];

                $model = $model->findByPK($model->id);

                $model->crm_user_id = Yii::app()->user->id;

            } 

            $company_id   =  $_POST['companyid'];
            if($company_id >0){
                $model->attributes  = $_POST['MasCompanySettings'];            
                $model->crm_user_id = Yii::app()->user->id;
                $model->create_by = Yii::app()->user->id;
                $model->sales_lead      = $_POST['MasCompanySettings']['sales_lead'];
                $model->sales_quotation = $_POST['MasCompanySettings']['sales_quotation'];
                $model->sales_order     = $_POST['MasCompanySettings']['sales_order'];
                $model->sales_contract  = $_POST['MasCompanySettings']['sales_contract'];
                
                $model->sales_invoice      = $_POST['MasCompanySettings']['sales_invoice'];
                $model->sales_creditnote = $_POST['MasCompanySettings']['sales_creditnote'];
                $model->execution_assignment_master     = $_POST['MasCompanySettings']['execution_assignment_master'];
                $model->execution_assignment  = $_POST['MasCompanySettings']['execution_assignment'];
                
                $model->inventory_service      = $_POST['MasCompanySettings']['inventory_service'];
                
                $model->crm_company_id   =  $_POST['companyid'];
            
                if ($model->save()) {
    
                    $jsonData['status'] = 'success';
    
                    $jsonData['frm'] = $_POST['company-form'];
    
                    $jsonData['id'] = $model->id;
    
                    echo CJSON::encode($jsonData);
    
                } else {
    
                    $error = CActiveForm::validate($model, '', false);
    
                    if ($error != '[]')
    
                        echo $error;
    
                }
            }
            else
            {
                $jsonData['status'] = 'Company Not Registered';
                echo CJSON::encode($jsonData);
            }


            

        }*/

    }
    
    
    public function actionDeleteBankDetails(){

     

        	$id = $_POST['id'];

                $model=new MasCompanyBankDetails();

                $model->deleteByPk($id);

                echo "success";
        
    }
    
    public function actionAddSettingsPwd()
    {
        $model     = new MasSettingsLogin();
        $count     = $model->count();
        if ($count > 0) {
            $modelid   = $model->find();
            $id        = $modelid->id;
            if($id>0){
                $model     = $model->findByPk($id);
            }
        }
        
            
            //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('set_password', array('model' => $model));
    }
    
    //SaveSettingsPassword
    public function actionSaveSettingsPassword() {



        $model = new MasSettingsLogin();
            
            if (isset($_POST['MasSettingsLogin']))
            {
                $model->create_by        = Yii::app()->user->id;
                $model->create_date_time = date('Y-m-d h:i:s');
                
                $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
                $password = crypt($_POST['MasSettingsLogin']['password'], $salt);
                
                
                if ((int) @$_POST['MasSettingsLogin']['id'] > 0)
                {   
                    $id= (int) @$_POST['MasSettingsLogin']['id']; 
                    $model=$model->findByPk($id); 
                                                                             
                }
                
                $model->attributes=$_POST['MasSettingsLogin'];
                $model->password  = $password;
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['category-form'];
                        $jsonData['id'] = $model->id;
	                   echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }

    }
    
    
    public function actionSettimgsLogin()
    {
        $model = new MasSettingsLogin();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('settings_login_form', array('model' => $model));
    }
    
    //MasSettingsLogin
    
    public function actionMasSettingsLogin(){
        $model = new MasSettingsLogin();
    if(isset($_POST['MasSettingsLogin']))
    {
        $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password = crypt($_POST['MasSettingsLogin']['password'], $salt);
        
        
        
        //$login_condition = "crm_company_id='1'";
        //$common_login = MasSettingsLogin::model()->find(array("condition"=>$login_condition));
        $common_login = MasSettingsLogin::model()->find();
        
        if($common_login->password != $password)
        {
            $error['status'] = "error";
            $error['msg'] = "Invalid password!";
        }
        else
        {
            Yii::app()->session['master_settings_login'] =  $common_login->id;            
            $error['status'] = "success";
            $error['msg']    = "Login Success";
            
        }        
        echo CJSON::encode($error);
    }
    else
    {
            $error = CActiveForm::validate($model, '', false);
            if ($error != '[]')
            echo $error;
    }
    
}
    public function actionSaveMascode() {
        $model = new MasCode();

        /*         * ********** START Code for Save ************** */
        if (isset($_POST['MasCode'])) {

            if ((int) @$_POST['MasCode']['id'] > 0) {

                $model->id = (int) $_POST['MasCode']['id'];

                $model = $model->findByPK($model->id);
            $SQL="SELECT sum(no_char) from crm_mas_code where id NOT IN(".$model->id.")";
            $tot = Yii::app()->db->createCommand($SQL)->queryScalar();
            }
            else {
            $SQL="SELECT sum(no_char) from crm_mas_code";
            $tot = Yii::app()->db->createCommand($SQL)->queryScalar();
            }
            $tot+=$_POST['MasCode']['no_char'];
            if($tot<=15){
                $model->attributes     = $_POST['MasCode']; 
                $allPermissions = array();
                foreach ($_POST['MasCode']['mandatory_fields'] as $eachPermissionArray)
                { 
                    if (is_array($eachPermissionArray)){ 
                        foreach ($eachPermissionArray as $eachPermission){
                            $allPermissions[$eachPermission] = 1;
                        }
                    }
                }
                $model->mandatory_fields = json_encode($allPermissions);
                if ($model->save()) {
    
                    $jsonData['status'] = 'success';
    
                    $jsonData['frm'] = $_POST['company-form'];
    
                    $jsonData['id'] = $model->id;
    
                    echo CJSON::encode($jsonData);
    
                } else {
    
                    $error = CActiveForm::validate($model, '', false);
    
                    if ($error != '[]')
    
                        echo $error;
    
                }
            }
            else
            {
                $jsonData['status'] = 'total';
                echo CJSON::encode($jsonData);
            }
        }

    }
     public function actionGetValue() {
         $id=$id = (int) Yii::app()->request->getParam('id');
            if ($id > 0) {
                $model = MasCode::model()->findByPK($id);
                    $jsonData['status'] = 'success';
                    $jsonData['dt'] = $model;
                    echo CJSON::encode($jsonData);
                } 
    }  
    public function actionDeleteValue() {
         $id=$id = (int) Yii::app()->request->getParam('id');
            if ($id > 0) {
                $model = MasCode::model()->deleteByPK($id);
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                } 
    }

    public function actionReset(){
         $Tables = array();
         $Tables[] = 'crm_activity';
         $Tables[] = 'crm_direct_order';
         $Tables[] = 'crm_direct_order_addition';
         $Tables[] = 'crm_direct_order_deduction';
         $Tables[] = 'crm_direct_order_deduction';
         $Tables[] = 'crm_direct_order_item';
         $Tables[] = 'crm_direct_purchase_order_general';
         $Tables[] = 'crm_direct_purchase_order_items';
         $Tables[] = 'crm_direct_purchasing_order_addition';
         $Tables[] = 'crm_direct_purchasing_order_deduction';
         $Tables[] = 'crm_fin_general_ledger';
         $Tables[] = 'crm_fin_general_ledger_head';
         $Tables[] = 'crm_fin_voucher_allocation';
         $Tables[] = 'crm_fin_voucher_allocation_head';
         $Tables[] = 'crm_fin_voucher_allocation_head_delete';
         $Tables[] = 'crm_inventory_direct_transfer';
         $Tables[] = 'crm_inventory_direct_transfer_item';
         $Tables[] = 'crm_inventory_goods_issue';
         $Tables[] = 'crm_inventory_goods_issue_item';
         $Tables[] = 'crm_inventory_goods_receipt';
         $Tables[] = 'crm_inventory_goods_receipt_item';
         $Tables[] = 'crm_inventory_indirect_received';
         $Tables[] = 'crm_inventory_indirect_received_items';
         $Tables[] = 'crm_inventory_indirect_transfer';
         $Tables[] = 'crm_inventory_indirect_transfer_item';
         $Tables[] = 'crm_invoice';
         $Tables[] = 'crm_invoice_addition';
         $Tables[] = 'crm_invoice_deduction';
         $Tables[] = 'crm_master_file';
         $Tables[] = 'crm_order';
         $Tables[] = 'crm_order_addition';
         $Tables[] = 'crm_order_deduction';
         $Tables[] = 'crm_order_item';
         $Tables[] = 'crm_pdc';
         $Tables[] = 'crm_purchasinginvoice';
         $Tables[] = 'crm_purchasinginvoice_item';
         $Tables[] = 'crm_purchasing_debit_note';
         $Tables[] = 'crm_purchasing_debit_note_addition';
         $Tables[] = 'crm_purchasing_debit_note_deduction';
         $Tables[] = 'crm_purchasing_debit_note_item';
         $Tables[] = 'crm_purchasing_invoice_addition';
         $Tables[] = 'crm_purchasing_invoice_deduction';
         $Tables[] = 'crm_purchasing_order';
         $Tables[] = 'crm_purchasing_order_addition';
         $Tables[] = 'crm_purchasing_order_deduction';
         $Tables[] = 'crm_purchasing_order_item';
         $Tables[] = 'crm_purchasing_order_stock_item';
         $Tables[] = 'crm_quotes';
         $Tables[] = 'crm_quotes_addition';
         $Tables[] = 'crm_quotes_deduction';
         $Tables[] = 'crm_quotes_item';
         $Tables[] = 'crm_stock_ledger';
         $Tables[] = 'crm_stock_ledger_opening';
         $Tables[] = 'crm_creditnote';
         $Tables[] = 'crm_creditnote_addition';
         $Tables[] = 'crm_creditnote_deduction';
         $Tables[] = 'crm_creditnote_item';
         $Tables[] = 'crm_purchasing_debit_note';
         $Tables[] = 'crm_purchasing_debit_note_addition';
         $Tables[] = 'crm_purchasing_debit_note_deduction';
         $Tables[] = 'crm_purchasing_debit_note_item';
         $Tables[] = 'crm_delivery_note';
         $Tables[] = 'crm_delivery_item';
         foreach ($Tables as $each){
             Yii::app()->db->createCommand("TRUNCATE TABLE ".$each."")->query();
         }
         $value = MasNumberSettings::model()->findByPk(13)->value;
         Yii::app()->db->createCommand("ALTER TABLE crm_master_file AUTO_INCREMENT=".$value." ")->query();
         $jsonData['status'] = 'success';
         echo CJSON::encode($jsonData);
    }
	
}