<?php

class MassuppliertypesController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveDocumenttype', 'UnBlockMassuppliertypes','BlockMassuppliertypes'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new MasSupplierTypes();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'supplier_type',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition  = "  (supplier_type LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            if(isset(Yii::app()->user->havePermissionOn['mas_supplier_type_edit']) ||  Yii::app()->user->authorised_user == 1)
            {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Massuppliertypes/create&id=' . $row['id'] . '\',\'Edit Supplier Type\',\'lg\')"><i class="fa fa-pencil"></i></button>';             

            }
            if(isset(Yii::app()->user->havePermissionOn['mas_supplier_type_disable']) ||  Yii::app()->user->authorised_user == 1)
            {

              if ($row->isActive == "Y") 
              {
                $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disableMassuppliertypes(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
              }
              if ($row->isActive == 'N') 
              {
                    $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enableMassuppliertypes(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
              }            
            
            }

           
            $rowData[] = array($m,
                $row['supplier_type'],
                '<div class="btn-wrap">' . $div . '</div>',
                $row['isActive'],
            );
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasSupplierTypes();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('supplier_type_form', array('model' => $model), false, false);
    }

    public function actionSaveDocumenttype() {
        $model = new MasSupplierTypes();
        if (isset($_POST['MasSupplierTypes'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime =date('Y-m-d h:i:s');
            if ((int) @$_POST['MasSupplierTypes']['id'] > 0) {
                
                $id = (int) @$_POST['MasSupplierTypes']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime =date('Y-m-d h:i:s');
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasSupplierTypes'];
            $model->supplier_type = $_POST['MasSupplierTypes']['supplier_type'];
            if ($model->save()) {
                // inserting to audit log
				 AuditLog::saveAuditLogs(
                    'SUPPLIER_TYPE',
                    Yii::app()->user->id,
                    $audit_type,
                    " with type : - {$_POST['MasSupplierTypes']['supplier_type']}"
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['supplier-form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionBlockMassuppliertypes() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasSupplierTypes::model()->updateByPK($id, array('isActive' => "N"));
             // inserting to audit log
             $model=new MasSupplierTypes();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'SUPPLIER_TYPE',
                 Yii::app()->user->id,
                 'BLOCKED',
                 " with name: - {$upt->supplier_type}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlockMassuppliertypes() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasSupplierTypes::model()->updateByPK($id, array('isActive' => "Y"));
             // inserting to audit log
             $model=new MasSupplierTypes();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'SUPPLIER_TYPE',
                 Yii::app()->user->id,
                 'UNBLOCKED',
                 " with name: - {$upt->supplier_type}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }



}
