<?php

class MasoutletController extends Controller
{
    
    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveOutlet', 'DeleteOutlet', 'DirectAdd', 'BlockMasOutlet', 'DeleteAllFiles','UnBlockMasOutlet'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    // Uncomment the following methods and override them if needed

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    
    public function actionIndex()
    {
        $this->render('index');
    }


    public function actionGetList()
    {
        $model = new MasOutlet();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'outlet_name',
            2 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (outlet_name LIKE '%" . $searchString . "%' )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["master_outlet_edit"])){
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Masoutlet/create&id=' . $row['id'] . '\',\'Edit outlet\',\'lg\')"><i class="fa fa-pencil"></i></button>';             
            }
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["master_outlet_delete"])){
             //   $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteGeneric('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            }

            if(isset(Yii::app()->user->havePermissionOn['master_outlet_disable']) ||  Yii::app()->user->authorised_user == 1)
            {

            if ($row->isActive == "Y") 
            {
                $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disableMasOutlet(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
            }
            if ($row->isActive == 'N') 
            {
                    $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enableMasOutlet(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
            }            
            
            }
            $rowData[] = array($m,
                $row['outlet_name'],
                $row['current_invoice_no'],
                '<div class="btn-wrap">' . $div . '</div>',
                $row['isActive'],
            );

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model = new MasOutlet();
        $id = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

	public function actionSaveOutlet()
    {
        $model = new MasOutlet();
        if (isset($_POST['MasOutlet'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int)@$_POST['MasOutlet']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int)@$_POST['MasOutlet']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasOutlet'];
           
            if ($model->save()) {
                
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['loc_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
}