<?php

class MasitemtypeController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveItemtype', 'UnBlock','Block','GetLedger','Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['mas_item_type_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['mas_item_type_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    // public function actionGetList() {
    //     $model = new MasInventoryItemType();
    //     $draw = $_POST['draw'];
    //     $offset = $_POST['start'];
    //     $limit = $_POST['length'];
    //     $columns = array(
    //         // datatable column index  => database column name
    //         0 => 'id',
    //         1 => 'item_type',
    //     );
    //     $filterColumn = $columns[$_POST['order'][0]['column']];
    //     $filterOrder = $_POST['order'][0]['dir'];
    //     $orderBy = $filterColumn . " " . $filterOrder;
    //     $condition = '1=1';
    //     if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
    //         $searchString = $_POST['search']['value'];
    //         $condition = " (item_type LIKE '%" . $searchString . "%')";
    //     }
    //     $count = $model->count(array('condition' => $condition));
    //     $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
    //     $recordsTotal = $count;
    //     $recordsFiltered = $count;
    //     $data['draw'] = $draw;
    //     $data['recordsTotal'] = $recordsTotal;
    //     $data['recordsFiltered'] = $recordsFiltered;
    //     $rowData = array();
    //     $m = 1;
    //     foreach ($model as $row) {
    //         $div = '';
    //             if( Yii::app()->user->authorised_user == 1)
    //             {
    //                 $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Masitemtype/create&id=' . $row['id'] . '\',\'Edit Item Type\',\'lg\')"><i class="fa fa-pencil"></i></button>';             

    //             }
    //             if(   Yii::app()->user->authorised_user == 1)
    //             {

    //               if ($row->isActive == "Y") 
    //               {
    //                 $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disableType(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
    //               }
    //               if ($row->isActive == 'N') 
    //               {
    //                     $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enableType(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
    //               }            
                
    //             }
           
    //         $rowData[] = array($m,
    //             $row['item_type'],
    //             '<div class="btn-wrap">' . $div . '</div>',
    //             $row['isActive'],
    //         );

    //         $m++;
    //     }

    //     $data['data'] = $rowData;
    //     echo json_encode($data);
    // }
    public function actionGetList() {
        $model = new MasInventoryItemType();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1=>'t.item_type',
            );
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder  = $_POST['order'][0]['dir'];
            $orderBy      = $filterColumn." ".$filterOrder;
            // $condition = '1=1';
            if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                $searchString = $_POST['search']['value'];
                $condition = " (item_type LIKE '%" . $searchString . "%')";
            }
            $count = $model->count(array('condition'=>$condition));
            $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset));
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData=array();
            $div='';
            $m=1;
            foreach ($model as $row)
            {
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_item_type_edit"])){

                $div='<div class="btn-wrap text-center">'
                    . '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Masitemtype/create&id='.$row['id'].'\',\'Edit Item Type\',\'lg\')" title="Edit Item Type">'
                    . '<i class="fa fa-edit"></i></button></div>';
            }
                $rowData[]=array($m,
                    $row['item_type'],
                    // $div,
                    $row['isDefault'],
                  array('id' => $row['id'],'code'=>'Edit Item Type','status' => $row->isActive),);
            $m++;
            }
            $data['data'] = $rowData;
            echo json_encode($data);
    }
    public function actionCreate() {
        $model = new MasInventoryItemType();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSaveItemtype() {
        $model = new MasInventoryItemType();
        if (isset($_POST['MasInventoryItemType'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time =date('Y-m-d h:i:s');
            if ((int) @$_POST['MasInventoryItemType']['id'] > 0) {
                
                $id = (int) @$_POST['MasInventoryItemType']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time =date('Y-m-d h:i:s');
                $audit_type = 'UPDATED';  
            }else{
                $audit_type = 'CREATED';
            }
            if($_POST['MasInventoryItemType']['isDefault'] == "Y"){
                MasInventoryItemType::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            }
            $model->isDefault = $_POST['MasInventoryItemType']['isDefault'];
            $model->attributes = $_POST['MasInventoryItemType'];
            $model->item_type = $_POST['MasInventoryItemType']['item_type'];
            $model->income_ledger_id = $_POST['MasInventoryItemType']['income_ledger_id'];
            $model->inventory_ledger_id = $_POST['MasInventoryItemType']['inventory_ledger_id'];
            $model->ledger_id = $_POST['MasInventoryItemType']['ledger_id'];
            if ($model->save()) {
                // inserting to audit log
				//  AuditLog::saveAuditLogs(
    //                 'itemtype',
    //                 Yii::app()->user->id,
    //                 $audit_type,
    //                 " with type : - {$_POST['MasInventoryItemType']['itemtype']}"
    //             );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['item_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
        
   
    public function actionBlock() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasInventoryItemType::model()->updateByPK($id, array('isActive' => "N"));
             // inserting to audit log
            //  $model=new MasInventoryItemType();
            //  $upt = $model->findByPk($id); // audit log changes
            //  AuditLog::saveAuditLogs(
            //      'itemtype',
            //      Yii::app()->user->id,
            //      'BLOCKED',
            //      " with type: - {$_POST['MasInventoryItemType']['itemtype']}  "
            //  );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlock() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasInventoryItemType::model()->updateByPK($id, array('isActive' => "Y"));
             // inserting to audit log
            //  $model=new MasInventoryItemType();
            //  $upt = $model->findByPk($id); // audit log changes
            //  AuditLog::saveAuditLogs(
            //      'itemtype',
            //      Yii::app()->user->id,
            //      'UNBLOCKED',
            //      " with type: - {$_POST['MasInventoryItemType']['itemtype']}  "
            //  );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
 public function actionGetLedger() {
        $data['status'] ="error";
        $type = (int) $_POST['type'];
        $condition = ' t.id='.$type;
        $model = MasInventoryItemType::model()->findByPk($type);
        $data = array();
        if(!empty($model))
        {
        $data['value'] = $model->ledger_id; 
        $data['status'] ="success";
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasInventoryItemType();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    
}
