<?php

class MasemployeetypeController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','deleteSalaryType','SaveSalaryType','GetList','DirectAdd', 'Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
         }
         
        public function actionGetList()
         {
 
            $model=new MasEmployeeType();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'t.id',
                   1 =>'employee_type_name',
                   2 =>'da_per_hour',
                   3 =>'ot_per_hour',
                 
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                             $condition =" (employee_type_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $button_string="";
                    
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_emp_type_edit'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'masemployeetype/create&id='.$row['id'].'\',\'Edit Employee Type\',\'lg\')"><i class="fa fa-edit"></i></button>';
                    }
//                    $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteSalaryType('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                        
                        
                  $rowData[]=array($m,$row['employee_type_name'],$row['da_per_hour'],$row['ot_per_hour'], array(
                "id" => $row['id'],
                'status' => $row['isActive']
            ));
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasEmployeeType(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                   
            
       Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('employee_type_form', array('model' => $model), false, true);
    }
    public function actionSaveSalaryType()
        {
            $model = new MasEmployeeType();
            if (isset($_POST['MasEmployeeType']))
            {
                $model->isActive = "Y";
    		
    		if ((int) @$_POST['MasEmployeeType']['id'] > 0)
                {
                    $id= (int) @$_POST['MasEmployeeType']['id'];
                    $model=$model->findByPk($id); 
                    $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
                $audit_type = 'UPDATED';  
                }else{
                    $audit_type = 'CREATED';
                }
                $model->attributes=$_POST['MasEmployeeType'];
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                if($model->save())
                {       
                        // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'EMPLOYEE_TYPE',
                        Yii::app()->user->id,
                        $audit_type,
                        " with type: - {$_POST['MasEmployeeType']['employee_type_name']}  "
                    );
                    // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['mas-employee-type-form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                       // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
            }
        }
        public function actiondeleteEmployeeType(){
        
            $id = $_POST['id'];
            if($id>0){
            
                $model = new MasEmployeeType();                
                $model->deleteByPk($id);
                echo "success";
            }
            else{
                echo "fail";
            }
        
        }
   /* public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $status =  array();
           $drop = '';
           if($name != ''){
               $modelBank = new MasBank;
               $modelBank->bank_name = $name;
               if($modelBank->save()){
                    $status['status']= "success";
                    $data  = MasBank::getBanks();
                    if($from == 'vendor'){
                        $model = new Vendor;
                        $field_name = 'vendor_bank_name';
                    }
                    $model->$field_name = $modelBank->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Bank'));  
                    $status['drop']= $drop;
                    echo CJSON::encode($status); 
               }else{
                    $error = CActiveForm::validate($modelBank, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
        }*/
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasEmployeeType();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }  
}