<?php

class MasProject1Controller extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteWarehouse','SaveMasProject1','GetMasProjcet1List','DirectAdd', 'Disable','UploadImage'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex()
        {
           if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['projects_masster1_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['projects_masster1_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
                $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
        }
         
        public function actionGetMasProjcet1List()
         {
 
            $model=new MasProject1();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                0 =>'t.id',
                1 => 'master_name',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                // $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (master_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'master_name ASC'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $div='';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_warehouse_edit"])){
                        $div.='<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'master1/create&id='.$row['id'].'\',\'Master1 - '.$row['master_name'].' \',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                    }
                    $rowData[]=array($m,
                        $row['master_name'],
              '<div class="btn-wrap text-center">'.$div.'</div>',
                        
                        $row['isMasterBase'],
                            
                     array('id' => $row['id'],'code'=>$row['master_name'] , 'status' => $row->isActive));       
                    
                    
                    
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasProject1(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
             Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('mas_project_1_form', array('model' => $model), false, true);
    }
    public function actionSaveMasProject1()
        {
            $model = new MasProject1();
            if (isset($_POST['MasProject1']))
             {   
             $model->created_by = Yii::app()->user->id;
             $model->created_datetime =date('Y-m-d h:i:s');
    		
    		if ((int) @$_POST['MasProject1']['id'] > 0)
                 {   $model->updated_by = Yii::app()->user->id;
                     $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasProject1']['id'];
                    $model=$model->findByPk($id); 
                    $audit_type = 'UPDATED';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                }
                if($_POST['MasProject1']['isMasterBase'] == "Y"){
                	MasProject1::model()->updateAll(array( 'isMasterBase' => 'N' ), 'isMasterBase = "Y"' );
            	}
                $model->attributes			=	$_POST['MasProject1'];
                if($model->save())
                {
                                        
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'PROJECT_MASTER1',
                            Yii::app()->user->id,
                            $audit_type,
                            " with name: - {$model->master_name}  "
                        );
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['mas-projcet-1'];
                        $jsonData['id'] = $model->id;
	                	echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }
        }
        public function actionDeleteWarehouse()
    {
		$id = $_POST['id'];
                $store = Yii::app()->db->createCommand('SELECT COUNT(*) FROM crm_store WHERE default_warehouse_id = '.$id.' ')->queryScalar();
                $location = Yii::app()->db->createCommand('SELECT COUNT(*) FROM crm_product_location WHERE warehouse_id = '.$id.' ')->queryScalar();
                if($store > 0 ||  $location > 0){
                    echo "fail";
                }else{
                    $model=new MasInventoryWarehouse();
                    $warehouse = $model->findByPk($id);
                    $model->deleteByPk($id);
                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'WAREHOUSE_MASTER',
                        Yii::app()->user->id,
                        'DELETED',
                        " with name: - {$warehouse->warehouse_name}  "
                    );
                    // end audit log
                    echo "success";
                }
                
    }
    
    public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           if($name != ''){
               $modelWarehouse = new MasInventoryWarehouse;
               $modelWarehouse->warehouse_name = $name;
               if($modelWarehouse->save()){
                    $data  = MasInventoryWarehouse::getWarehouse();
                    if($from == 'inventory'){
                        $model = new ProductLocation;
                        $field_name = 'warehouse_id';
                    }
                    $model->$field_name = $modelWarehouse->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Warehouse <span style="color:red;">*<span>'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
               }else{
                    $error = CActiveForm::validate($modelWarehouse, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
          
            
         }
        
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasProject1();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}