<?php

class MasPaymentTypeController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetPaymentList', 'Savepaymenttype', 'Disablepaymenttype', 'CheckPaymentCodeDetails'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {


        if (isset(Yii::app()->user->havePermissionOn['mas_payment_type_view']) || Yii::app()->user->authorised_user == 1) {

            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access');
        }
    }

    // Uncomment the following methods and override them if needed

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetPaymentList()
    {
        $model = new MasPaymentType();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'payment_type',
            2 => 'payment_code',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        // $condition = 't.isActive="Y"';
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $condition = "1=1 ";
            $searchString = $_POST['search']['value'];
            $condition .= " and (payment_type LIKE '%" . $searchString . "%' OR payment_code LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {

            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["payment_type_edit"])) {
                //  $div .=   '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'payment_type/create&id='.$row['id'].'\',\'Edit payment_type\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["payment_type_delete"])) {
                // $div .=  ' <a href ="#" class="btn btn-danger btn-xs" onclick="deletepayment_type('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            }
            $rowData[] = array(
                $m,
                $row['payment_type'],
                $row['payment_code'],

                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['payment_type'], 'isActive' => $row['isActive']),
            );

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model = new MasPaymentType();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSavepaymenttype()
    {

        $valid = true;
        $other =  array();

        $model = new MasPaymentType();
        if (isset($_POST['MasPaymentType'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['MasPaymentType']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasPaymentType']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasPaymentType'];
            $model->payment_code = trim($_POST['MasPaymentType']['payment_code']);
            $model->payment_type = trim($_POST['MasPaymentType']['payment_type']);
            $model->show_received_cash_amount = trim($_POST['MasPaymentType']['show_received_cash_amount']);
            $model->show_received_card_amount = trim($_POST['MasPaymentType']['show_received_card_amount']);
            $model->show_received_amount = trim($_POST['MasPaymentType']['show_received_amount']);
            $model->show_authorization_code = trim($_POST['MasPaymentType']['show_authorization_code']);

            $valid = ctype_upper($model->payment_code);
            if (!$valid) {
                $other[] = "Payment Code Must Be Upper Case";
            }


            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'MasPaymentType',
                    Yii::app()->user->id,
                    $audit_type,
                    " with code: - {$model->payment_code}  "
                );
                // end audit log 
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['payment_type_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
                // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
            } else {
                $error1 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $other));
                if ($error != '[]') {
                    echo $error;
                }
            }
            // $this->render('payment_type_form', array('model' => $model), false, true);
        }
    }

    public function actionDisablepaymenttype()
    {
        date_default_timezone_set("Asia/Dubai");
        $id = $_POST['id'];

        if (!empty($id)) {
            $model = new MasPaymentType();
            $model = $model->findByPk($id);
            if ($model->isActive == 'N') {
                $model->isActive = 'Y';
            } else {
                $model->isActive = 'N';
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_datetime = date('Y-m-d h:i:s');
            $model->save(FALSE);
            echo "success";
        } else {
            echo "fail";
        }
    }

    public function actionCheckPaymentCodeDetails()
    {
        $modecode = $_POST['modecode'];
        $model  = new MasPaymentType();
        // $model  = $model->findByPk($modecode);
        $model = $model->find(array('condition' => "t.payment_code = '{$modecode}'"));

        $data['id']           =   $model->id;
        $data['payment_code']         =  $model->payment_code;
        $data['received_cash_amount']    =  $model->show_received_cash_amount;
        $data['received_card_amount']      =  $model->show_received_card_amount;
        $data['received_amount']    =  $model->show_received_amount;
        $data['authorization_code']  =  $model->show_authorization_code;
        echo json_encode($data);
    }
}
