<?php

class MasLocationController extends Controller
{
	  public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveCountry', 'DeleteCountry', 'DirectAdd', 'BlockMasLocation', 'DeleteAllFiles','UnBlockMasLocation'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        $this->render('index');
    }

    // Uncomment the following methods and override them if needed

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList()
    {
        $model = new MasLocation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'location_name',
            2 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (location_name LIKE '%" . $searchString . "%' )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["master_location_edit"])){
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'MasLocation/create&id=' . $row['id'] . '\',\'Edit Location\',\'lg\')"><i class="fa fa-pencil"></i></button>';             
            }
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["master_location_delete"])){
             //   $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteGeneric('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            }

            if(isset(Yii::app()->user->havePermissionOn['master_location_disable']) ||  Yii::app()->user->authorised_user == 1)
            {

            if ($row->isActive == "Y") 
            {
                $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disableMasLocation(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
            }
            if ($row->isActive == 'N') 
            {
                    $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enableMasLocation(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
            }            
            
            }
            $rowData[] = array($m,
                $row['location_name'],
                '<div class="btn-wrap">' . $div . '</div>',
                $row['isActive'],
            );

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model = new MasLocation();
        $id = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('loc_from', array('model' => $model), false, false);
    }

    public function actionSaveCountry()
    {
        $model = new MasLocation();
        if (isset($_POST['MasLocation'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int)@$_POST['MasLocation']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int)@$_POST['MasLocation']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasLocation'];
           
            if ($model->save()) {
                
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['loc_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    

    public function actionBlockMasLocation() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasLocation::model()->updateByPK($id, array('isActive' => "N"));
             // inserting to audit log
             $model=new MasLocation();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'LOCATION',
                 Yii::app()->user->id,
                 'BLOCKED',
                 " with name: - {$upt->location_name }  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlockMasLocation() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasLocation::model()->updateByPK($id, array('isActive' => "Y"));
             // inserting to audit log
             $model=new MasLocation();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'LOCATION',
                 Yii::app()->user->id,
                 'UNBLOCKED',
                 " with name: - {$upt->location_name }  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }



    
}