<?php

class MasInventoryStockAdjustmentTypeController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SavestockAdjustmentType', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        $this->render('index');
    }

    // Uncomment the following methods and override them if needed

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList()
    {
        $model = new MasInventoryStockAdjustmentType();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $type_code = $_POST['type_code'];

        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'description',
            2 => 'description',
            3 => 'ledger.ledger_acc_name',
            4 => 'subledger.subledger_name',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        
        
         if (!empty($type_code)) {
           
            $condition .= " AND t.type ="  . "'$type_code'" ;
        }
        
        
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (description LIKE '%" . $searchString . "%' OR ledger.ledger_acc_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('subledger', 'ledger')->count(array('condition' => $condition));
        $model = $model->with('subledger', 'ledger')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';

            if ($row['type'] == 'I') {
                $type = 'ISSUE';
            } else if ($row['type'] == 'R') {
                $type = 'RECEIPT';
            } else {
                $type = 'None';
            }

            $rowData[] = array(
                $m,
                $row['description'], $type, $row->ledger->ledger_acc_name,  $row->subledger->subledger_name,
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'description' => $row['description'], 'status' => $row->isActive),
            );

            $m++;
        }


        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model = new MasInventoryStockAdjustmentType();
        $id = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('type_form', array('model' => $model), false, false);
    }

    public function actionSavestockAdjustmentType()
    {
        $model = new MasInventoryStockAdjustmentType();

        if (isset($_POST['MasInventoryStockAdjustmentType'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int)@$_POST['MasInventoryStockAdjustmentType']['id'] > 0) {

                $id = (int)@$_POST['MasInventoryStockAdjustmentType']['id'];
                $model = $model->findByPk($id);

                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');

                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasInventoryStockAdjustmentType'];

            $model->description = $_POST['MasInventoryStockAdjustmentType']['description'];


            if ($model->save()) {


                //inserting to audit log

                AuditLog::saveAuditLogs(
                    'StockAdjustmentType',
                    Yii::app()->user->id,
                    $audit_type,
                    " with id : - {$model->id}"
                );
                // end audit log


                $jsonData['status'] = 'success';
              //  $jsonData['frm'] = $_POST['type_form'];
              //  $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }




    public function actionDisable()
    {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasInventoryStockAdjustmentType();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y") ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}
