<?php

class MasCurrencyExchangeController extends Controller
{

	public function accessRules()
	{
		return array(
			array(
				'allow', // allow all users to perform 'index' and 'view' actions
				'actions' => array('login', 'error', 'logout'),
				'users' => array('*'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('Index', 'Create', 'GetCurrencyExchangeList', 'SaveCurrencyExchange','View'),
				'expression' => '$user->isMember()',
			),
			array(
				'deny', // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionIndex()
	{
		Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
		$this->render('index');
	}

	// Uncomment the following methods and override them if needed

	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	public function actionGetCurrencyExchangeList()
	{
		$model = new MasCurrencyExchange();
		$draw = $_POST['draw'];
		$offset = $_POST['start'];
		$limit = $_POST['length'];
		$columns = array(
			// datatable column index  => database column name
			0 => 'id',
			1 => 'currency_code',
			2 => 'id',
			3 => 'isActive'
		);
		$filterColumn = $columns[$_POST['order'][0]['column']];
		$filterOrder = $_POST['order'][0]['dir'];
		$orderBy = $filterColumn . " " . $filterOrder;
		$condition = "1=1 ";
		if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

			$searchString = $_POST['search']['value'];
			$condition .= " and (currency_code LIKE '%" . $searchString . "%' OR currency_code LIKE '%" . $searchString . "%' OR currency_code LIKE '%" . $searchString . "%')";
		}
		$count = $model->count(array('condition' => $condition));
		$model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
		$recordsTotal = $count;
		$recordsFiltered = $count;
		$data['draw'] = $draw;
		$data['recordsTotal'] = $recordsTotal;
		$data['recordsFiltered'] = $recordsFiltered;
		$rowData = array();
		$m = 1;
		foreach ($model as $row) {

			$div = '';
			if (isset(Yii::app()->user->havePermissionOn['currency_exchange_edit']) ||  Yii::app()->user->authorised_user == 1) {
				$div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'masCurrencyExchange/create&id=' . $row['id'] . '\',\'Edit Currency\',\'lg\')"><i class="fa fa-pencil"></i></button>';
			}

			$rowData[] = array(
				$m,
				$row['currency_code'],
				'<div class="btn-wrap text-center">' . $div . '</div>',
				$row['isActive']
			);
			$m++;
		}
		$data['data'] = $rowData;
		echo json_encode($data);
	}

	public function actionCreate()
	{
		$model = new MasCurrencyExchange();
		$id = (int) Yii::app()->request->getParam('id');
		if ($id > 0) {
			$model = $model->findByPk($id);
		}
		Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
		$this->render('currency_exchange', array('model' => $model), false, false);
	}


	public function actionView()
	{
		$model = new MasCurrencyExchange();
		$id = (int) Yii::app()->request->getParam('id');
		if ($id > 0) {
			$model = $model->findByPk($id);
		}
		Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
		$this->render('currency_exchange_view', array('model' => $model), false, false);
	}

	public function actionSaveCurrencyExchange()
	{
		$model = new MasCurrencyExchange();
		if (isset($_POST['MasCurrencyExchange'])) {
			$model->created_by = Yii::app()->user->id;
			$model->created_datetime = date('Y-m-d h:i:s');
			if ((int) @$_POST['MasCurrencyExchange']['id'] > 0) {
				$model->updated_by = Yii::app()->user->id;
				$model->updated_datetime = date('Y-m-d h:i:s');
				$id = (int) @$_POST['MasCurrencyExchange']['id'];
				$model = $model->findByPk($id);
				$audit_type = 'UPDATED';
			} else {
				$audit_type = 'CREATED';
			}

			$model->attributes    = $_POST['MasCurrencyExchange'];
			// Manually set additional attributes
			foreach ($_POST['MasCurrencyExchange'] as $key => $value) {
				//if (!in_array($key, $model->attributeNames())) {
					$model->$key = $value;
				//}
			}
			$model->currency_code = trim($_POST['MasCurrencyExchange']['currency_code']);
			if ($model->save()) {
				// inserting to audit log
				AuditLog::saveAuditLogs(
					'CURRENCIES',
					Yii::app()->user->id,
					$audit_type,
					" with code: - {$model->currency_code}  "
				);
				// end audit log 
				$jsonData['status'] = 'success';
				$jsonData['frm'] = $_POST['currency_form'];
				$jsonData['id'] = $model->id;
				echo CJSON::encode($jsonData);
				// $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
			} else {
				$error = CActiveForm::validate($model, '', false);
				if ($error != '[]')
					echo $error;
			}
			// $this->render('currency_form', array('model' => $model), false, true);
		}
	}
}
