<?php

class MachineprofileController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Create','SaveDetails','Upload','RemovelineItem','deleteuploadedfile','DownloadDocument','Getdocumenttype',
                                    'PrintSnapshot'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $loc_id = (int) Yii::app()->request->getParam('loc_id');
        $serial_no =Yii::app()->request->getParam('serial_no');
        $model= new MachineProfile();
        $model_parts = array(new MachineProfileParts());
        $model_service_detail = array(new MachineServiceDetail());
        $model_document = array(new MachineDocumentDetail());
        if($id>0 && $loc_id>0){
            $model= MachineProfile::model()->find(array('condition'=>'product_id ="'.$id.'" and serial_no="'.$serial_no.'"'));
            if($model->id==''){
                $model= new MachineProfile();
            }
            $model_parts= MachineProfileParts::model()->findAll(array('condition'=>'product_id ="'.$id.'" and serial_no="'.$serial_no.'"'));
            if(empty($model_parts)){
                $model_parts = array(new MachineProfileParts());
            }
            $model_service_detail= MachineServiceDetail::model()->findAll(array('condition'=>'product_id ="'.$id.'" and serial_no="'.$serial_no.'"'));
            if(empty($model_service_detail)){
                $model_service_detail = array(new MachineServiceDetail());
            }
            $model_document= MachineDocumentDetail::model()->findAll(array('condition'=>'product_id ="'.$id.'" and serial_no="'.$serial_no.'"'));
            if(empty($model_document)){
                $model_document = array(new MachineDocumentDetail());
            }
        }
        $model_store=Store::model()->findbyPK($id);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('id' => $id,'loc_id' => $loc_id,'serial_no'=>$serial_no,
                                    'model' => $model,
                                    'model_parts' => $model_parts,
                                    'model_service_detail' => $model_service_detail,
                                    'model_document' => $model_document,
                                    'model_store'=>$model_store
                ));
    }
    public function actionSaveDetails() {       // print_r($_POST); die();
        if ((isset($_POST['MachineProfile']))) {
            $valid=true;
            if ((int) @$_POST['MachineProfile']['id'] > 0) {                
                $model = MachineProfile::model()->findByPK($_POST['MachineProfile']['id']);
                $model->id = (int) $_POST['MachineProfile']['id'];         
                $model->scenario = 'update';
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $model= new MachineProfile();
                $model->scenario = 'add';
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['MachineProfile'];
            if(isset($_POST['MachineProfile']['application']) && count($_POST['MachineProfile']['application']) > 0){
                $model->application = implode(',',$_POST['MachineProfile']['application']);
            }else{
                $model->application = "";
            }
            $valid=$model->validate(); //Machine Part Details
            $i=0;
            //Machine Profile Details
            if (is_array($_POST['MachineProfileParts'])) {
                $i=0;                
                foreach ($_POST['MachineProfileParts'] as $j => $items) {
                    if($items['part']!=''){
                        if($items['id']>0){
                            $model_parts[$i] = MachineProfileParts::model()->findByPK($items['id']);
                            $model_parts[$i]->updated_by= Yii::app()->user->id;
                            $model_parts[$i]->updated_date_time = date('Y-m-d h:i:s');
                        }else{
                            $model_parts[$i] = new MachineProfileParts();
                            $model_parts[$i]->created_by= Yii::app()->user->id;
                            $model_parts[$i]->created_date_time = date('Y-m-d h:i:s');
                        }
                        $model_parts[$i]->attributes = $_POST['MachineProfileParts'][$j];
                        $valid = $model_parts[$i]->validate() && $valid;
                        $i++;
                    }
                }
            } 
            //Machine Service Details
            if (is_array($_POST['MachineServiceDetail'])) {
                $i=0;
                foreach ($_POST['MachineServiceDetail'] as $k => $items) {
                    if($items['job_card_no']!=''){
                        if($items['id']>0){
                            $model_service[$i] = MachineServiceDetail::model()->findByPK($items['id']);
                            $model_service[$i]->updated_by= Yii::app()->user->id;
                            $model_service[$i]->updated_date_time = date('Y-m-d h:i:s');
                        }else{
                            $model_service[$i] = new MachineServiceDetail();
                            $model_service[$i]->created_by= Yii::app()->user->id;
                            $model_service[$i]->created_date_time = date('Y-m-d h:i:s');
                        }
                        $model_service[$i]->attributes = $_POST['MachineServiceDetail'][$i];
                        if ($items['date_service'] != '0000-00-00' && $items['date_service'] != '') {
                            $model_service[$i]->date_service = date("Y-m-d", strtotime(str_replace('/', '-', $items['date_service'])));
                        }
                        if ($items['next_service_date'] != '0000-00-00' && $items['next_service_date'] != '') {
                            $model_service[$i]->next_service_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['next_service_date'])));
                        }
                        $valid = $model_service[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            //Machine Document Details
            if (is_array($_POST['MachineDocumentDetail'])) {
                $i=0;
                foreach ($_POST['MachineDocumentDetail'] as $l => $items) {
                    if($items['document_id']!=''){
                        if($items['id']>0){
                            $model_document[$i] = MachineDocumentDetail::model()->findByPK($items['id']);
                            $model_document[$i]->updated_by= Yii::app()->user->id;
                            $model_document[$i]->updated_date_time = date('Y-m-d h:i:s');
                        }else{
                            $model_document[$i] = new MachineDocumentDetail();
                            $model_document[$i]->created_by= Yii::app()->user->id;
                            $model_document[$i]->created_date_time = date('Y-m-d h:i:s');
                        }
                        $model_document[$i]->attributes = $_POST['MachineDocumentDetail'][$i];
                        if ($items['date_valid'] != '0000-00-00' && $items['date_valid'] != '') {
                            $model_document[$i]->date_valid = date("Y-m-d", strtotime(str_replace('/', '-', $items['date_valid'])));
                        }
                        if ($items['date_reminder'] != '0000-00-00' && $items['date_reminder'] != '') {
                            $model_document[$i]->date_reminder = date("Y-m-d", strtotime(str_replace('/', '-', $items['date_reminder'])));
                        }
                        $valid = $model_document[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            if ($valid) {
                $model->save();
                if (!empty($model_parts)) {
                    foreach ($model_parts as $eachModel) {
                        $eachModel->save();
                    } 
                }
                if (!empty($model_service)) {
                    foreach ($model_service as $eachModel) {
                        $eachModel->save();
                    } 
                }
                if (!empty($model_document)) {
                    foreach ($model_document as $eachModel) {
                        $eachModel->save();
                    } 
                }
                $jsonData['product_id'] =$_POST['MachineProfile']['product_id'];
                $jsonData['loc_id'] = $_POST['MachineProfile']['pdt_location_id'];
                $jsonData['serial_no'] = $_POST['MachineProfile']['serial_no'];
                $jsonData['part_number'] = Store::model()->findbyPK($_POST['MachineProfile']['product_id'])->part_number;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($model_parts, '', false), true);
                $error3 = json_decode(CActiveForm::validateTabular($model_service, '', false), true);
                $error4 = json_decode(CActiveForm::validateTabular($model_document, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4));
                if($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionRemovelineItem(){
        $id = $_POST['id'];
        $frm = $_POST['frm'];
        if($id>0){
            if($frm=='parts'){
                $model =MachineProfileParts::model()->findByPk($id);
                $doc_file=$model->document_upload;
                if($model->document_upload!=''){
                    $arr_doc_val = explode(',', $doc_file);      
                    $status=0;
                    if (count($arr_doc_val) > 1) {
                        foreach ($arr_doc_val as $value) {
                            $path = Yii::getPathOfAlias('webroot') . "/uploads/machineprofile/".$value; 
                            if (unlink($path)) {
                                $status=1;
                            }
                        }
                        if ($status==1) {
                            MachineProfileParts::model()->deleteByPk($id);
                            $jsonData['status'] = 'success';
                        }else{
                            $jsonData['status'] = 'error';
                        }

                    }else{
                        $path = Yii::getPathOfAlias('webroot') . "/uploads/machineprofile/".$doc_file; 
                        if (unlink($path)) {
                            MachineProfileParts::model()->deleteByPk($id);
                            $jsonData['status'] = 'success';
                        }else{
                            $jsonData['status'] = 'error';
                        }
                    }
                }else{
                    MachineProfileParts::model()->deleteByPk($id);
                    $jsonData['status'] = 'success';
                }
            }else if($frm=='service'){  
                MachineServiceDetail::model()->deleteByPk($id);
                $jsonData['status'] = 'success';
            }else if($frm=='document'){ 
                $model =MachineDocumentDetail::model()->findByPk($id);
                $doc_file=$model->document_upload;
                if($model->document_upload!=''){
                    $arr_doc_val = explode(',', $doc_file);      
                    $status=0;
                    if (count($arr_doc_val) > 1) {
                        foreach ($arr_doc_val as $value) {
                            $path = Yii::getPathOfAlias('webroot') . "/uploads/machineprofile/".$value; 
                            if (unlink($path)) {
                                $status=1;
                            }
                        }
                        if ($status==1) {
                            MachineProfileParts::model()->deleteByPk($id);
                            $jsonData['status'] = 'success';
                        }else{
                            $jsonData['status'] = 'error';
                        }

                    }else{
                        $path = Yii::getPathOfAlias('webroot') . "/uploads/machineprofile/".$doc_file; 
                        if (unlink($path)) {
                            MachineProfileParts::model()->deleteByPk($id);
                            $jsonData['status'] = 'success';
                        }else{
                            $jsonData['status'] = 'error';
                        }
                    }
                }else{
                    MachineProfileParts::model()->deleteByPk($id);
                    $jsonData['status'] = 'success';
                }
            }        
        }else{
            $status['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
     
     }
    public function actionUpload($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array();
        $sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; 
    }
    public function actiondeleteuploadedfile() {
        $id = $_POST['id'];
        $file_name = $_POST['file_name'];
        $i = $_POST['row_field'];
        $frm = $_POST['frm'];
        $span='';
        if($frm==1){
            $model=new MachineProfileParts();
            $span='spanpartfile_'.$i;
        }else if($frm==2){
            $model=new MachineDocumentDetail();
            $span='spanfile_'.$i;
        }
        $model_docs=$model->findByPk($id); 
        $image_file_array=  explode(',', $model_docs->document_upload);   
        if (($key = array_search($file_name, $image_file_array)) !== false) {
            unset($image_file_array[$key]);
            $files = implode(',',$image_file_array);
            $model->updateByPK($id, array('document_upload' => $files));
            if($file_name!=''){
                $path = Yii::getPathOfAlias('webroot') . "/uploads/machineprofile/".$file_name;
                unlink($path);
            }
            $div_file='<span id="'.$span.'">';
            foreach ($image_file_array as $value_file) {
                $f_name="'".$value_file."'";
                $div_file.=$value_file.'<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete this file" onclick="deleteuploadedfile('.$i.','.$id.','.$f_name.','.$frm.');"><i class="fa fa-trash"></i></a><br>';
            }
            $div_file.='</span>';
            $div_file.= CHtml::activeHiddenField($model, "[" . $i . "]document_upload",array('value'=>$files));
            echo $div_file;
        }
    }
    public function actionDownloadDocument() {
        $id = (int) Yii::app()->request->getParam('id');
        $frm = (int) Yii::app()->request->getParam('frm');
        if($frm==1){
            $model=new MachineProfileParts();
        }else if($frm==2){
            $model=new MachineDocumentDetail();
            $fil_nm=$arr_employee_document->document->document_name;
        }
        $arr_employee_document =$model->findByPk($id);
        $file = $arr_employee_document->document_upload;
        $fil_nm='';
        if($frm==1){
            $fil_nm='machine_parts_document';
        }else if($frm==2){
            $model=new MachineDocumentDetail();
            $fil_nm=$arr_employee_document->document->document_name;
        }
        $arr_doc_val = explode(',', $arr_employee_document->document_upload);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/machineprofile/" .$fil_nm. "_" . date('d-m-Y') . ".zip";
            if ($zip->open($zip_file_path, 1 ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/machineprofile/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            Yii::app()->end();
        } else {
            $file = $arr_employee_document->document_upload;
            $path = Yii::getPathOfAlias('webroot') . "/uploads/machineprofile/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
    public function actionGetdocumenttype() {
        $id = Yii::app()->request->getparam('id');
        $model = MachineDocument::model()->findByPk($id);
        $data['document'] = $model->document_type;
        echo CJSON::encode($data);
        Yii::app()->end();

    }
    public function actionPrintSnapshot() {
        $id    = $_GET['id'];
        $serial_no    = $_GET['serialno'];
        $model= MachineProfile::model()->find(array('condition'=>'product_id ="'.$id.'" and serial_no="'.$serial_no.'"'));
        $model_parts= MachineProfileParts::model()->findAll(array('condition'=>'product_id ="'.$id.'" and serial_no="'.$serial_no.'"'));
        $model_service_detail= MachineServiceDetail::model()->findAll(array('condition'=>'product_id ="'.$id.'" and serial_no="'.$serial_no.'"'));
        $model_document= MachineDocumentDetail::model()->findAll(array('condition'=>'product_id ="'.$id.'" and serial_no="'.$serial_no.'"'));
        $model_store=Store::model()->findbyPK($id);
        $file_name=$model_store->part_number.' '.$serial_no;
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.machineprofile.pdf_snapshot', array('serial_no'=>$serial_no,'model' => $model,'model_store' => $model_store,'model_parts' => $model_parts,'model_service_detail' => $model_service_detail,'model_document' => $model_document),true));
        $mPDF1->Output($file_name, 'I');
    }
} 
?>