<?php

class LeadController extends Controller
{
    public $layout = 'layout';
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetSalesLeadList',
                    'Create',
                    'SaveLead',
                    'getCustomerContactDetails',
                    'FetchContactDetails',
                    'GetDocumentList',
                    'UploadDocument',
                    'DocumentUpload',
                    'DeleteDocument',
                    'DownloadDocument',
                    'GetNotesList',
                    'CreateNote',
                    'SaveNote',
                    'DeleteNote',
                    'PrintLeadReportPDF',
                    'GetExchangeRate',
                    'SendLeadConversionMail',
                    'PrintLeadList',
                    'SalesButton',
                    'GetFilterleadData',
                    'UploadDocumentLead',
                    'ApproveLevel'
                ),
                'expression' => '$user->isMember()',

            ),

            array(
                'deny', // deny all users

                'users' => array('*'),
            ),
        );
    }
    public function filters()
    {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex()
    {
        $frm = (int) Yii::app()->request->getParam('frm');

        // Disable certain default scripts
        Yii::app()->clientScript->scriptMap = array(
            '*jquery.js' => false,
            '*jquery.min.js' => false,
            'jquery.min.js' => false,
            '*jquery-ui.js' => false,
            '*jquery-ui.min.js' => false
        );

        // Check user permissions
        $prefix = ($frm == 3) ? 'service_lead' : 'lead';
        $prefix_menu = ($frm == 3) ? 'service' : 'sales';
        // echo isset(Yii::app()->user->havePermissionOn["{$prefix_menu}_menu_view"]);
        // echo "{$prefix}_view";
        // echo isset(Yii::app()->user->havePermissionOn["{$prefix}_view"]);

        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn["{$prefix_menu}_menu_view"]) &&
                isset(Yii::app()->user->havePermissionOn["{$prefix}_view"]) &&
                Yii::app()->user->havePermissionOn["{$prefix_menu}_menu_view"] &&
                Yii::app()->user->havePermissionOn["{$prefix}_view"]
            )
        ) {
            // Authorized: render the main view
            $this->render('index', array('frm' => $frm));
        } else {
            // Unauthorized: show custom unauthorized page
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }

    }

    /*
     * function to getlist for lead datatable
     * modified by jisha on 17-9-18. 
     */
    public function actionGetSalesLeadList()
    {
        $model = new Lead();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];


        $frm = $_POST['frm'];
        $prefix = ($frm == 3) ? 'service_lead' : 'lead';
        $columns = array(
            // datatable column index  => database column name

            0 => 't.file_id',
            1 => 't.id',
            2 => 'customer.customer_name',
            3 => 'leadowner.first_name',
            4 => 't.enq_date',
            5 => 't.closing_date',
            6 => 't.value',
            7 => 't.status',
            8 => 't.id',
            11 => 't.created_by'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";

        if (isset($_POST['lead_status']) && $_POST['lead_status'] != "") {
            $condition .= " AND lead_status='" . $_POST['lead_status'] . "'";
        } else {
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_view_all"])) {
                if ($frm != 3) {
                    $condition .= ' AND  t.isActive="Y" AND (file.current_process_status="L")  AND t.lead_type="sale"';
                }
                if ($frm == 3) {
                    $condition .= ' AND  t.isActive="Y" AND (file.current_process_status="L")  AND t.lead_type="service"';

                }
            } else {
                $condition .= ' AND  t.isActive="Y" AND (file.current_process_status="L") AND t.lead_owner_id= "' . Yii::app()->user->id . '"   AND t.lead_type="sale" ';
            }
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_view_all"])) {
                if ($frm != 3) {
                    $condition = 't.isActive="Y"   AND t.lead_type="sale" ';
                }
                if ($frm == 3) {
                    $condition = 't.isActive="Y"   AND t.lead_type="service" ';

                }
            } else {
                if ($frm != 3) {
                    $condition = 't.isActive="Y" AND t.lead_owner_id= "' . Yii::app()->user->id . '"   AND t.lead_type="sale" ';
                }
                if ($frm == 3) {
                    $condition = 't.isActive="Y" AND t.lead_owner_id= "' . Yii::app()->user->id . '"   AND t.lead_type="service" ';

                }
            }
            // echo $condition;
            $searchString = $_POST['search']['value'];
            $condition .= " AND (leadowner.first_name LIKE '%" . $searchString . "%' OR leadowner.last_name LIKE '%" . $searchString . "%' OR CONCAT(leadowner.first_name, ' ', leadowner.last_name) LIKE '%" . $searchString . "%'  OR file.file_title LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR customer.customer_name LIKE '%" . $searchString . "%')";
        }

        // echo $condition;
        $count = $model->with('file', 'customer', 'crmUser', 'leadowner')->count(array('condition' => $condition));
        $model = $model->with('file', 'customer', 'crmUser', 'leadowner')->findAll(array('condition' => $condition, 'order' => $orderBy, 'limit' => $limit, 'offset' => $offset));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $row) {
            $status = $row['StatusOfLead'];
            $file_status = $row['file']['Status'].' - '.ucfirst($row['lead_type']);
            $lead_status = "";
            if ($row['lead_status'] == "M") {
                $lead_status = "Medium";
            } elseif ($row['lead_status'] == "H") {
                $lead_status = "High";
            } elseif ($row['lead_status'] == "L") {
                $lead_status = "Low";
            }
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_edit"])) {
                if ($row->file->current_process_status == 'L') {
                    $div .= ' <button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'lead/create&id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\'F-' . $row['file_id'] . ' /  L-' . $row['id'] . '\',\'xl\')"><i class="fa fa-edit"></i></button>';

                } else {
                    $div .= ' <button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'lead/create&view=1&id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\'F-' . $row['file_id'] . ' /  L-' . $row['id'] . '\',\'xl\')"><i class="fa fa-eye"></i></button>';

                }
            }
            if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_convert"])) && $row->file->current_process_status == "L") {
                $div .= ' <button id="convert_to_quotes" title="Convert to Quotation" value="' . $row['file']['current_process_status'] . '" class="btn btn-primary btn-xs" onclick="loadPopupModal(\'quotation/create&lead_id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\'Convert To Quotation \',\'xl\');check_convert(' . "'" . $row['file']['current_process_status'] . "'" . ');"><i class="fa fa-retweet"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["{$prefix}_pdf"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=lead/PrintLeadReportPDF&id=' . $row['id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"])) {
                $div .= ' <button class="btn btn-primary btn-xs" title ="Edit Activity" onclick="loadPopupModal(\'activity/create&file_id=' . $row['file_id'] . '&customer_id=' . $row['customer_id'] . '&frm=L&ftype=1\',\'' . $row['file_id'] . ' : ' . $row['customer']['customer_name'] . ' - Activities ' . '\',\'lg\')"><i class="fa fa-certificate"></i></button>';
            }
            Yii::import('application.modules.features.models.FeaturesApproveLevel');
            $model_approval = new FeaturesApproveLevel();
            $approvalType = 'LE';
            $currentApproveLevel = $model_approval->getCurrentApproveLevel($approvalType, $row['file_id']);
            $accessApproveLevel = $model_approval->getAccessApproveLevel($currentApproveLevel, Yii::app()->user->id, $approvalType);
            $rowData[] = array(
                $row['file_id'],
                $row['id'],
                $row->customer->customer_name,
                $row->leadowner->first_name . " " . $row->leadowner->last_name,
                date("d/m/Y", strtotime($row['enq_date'])),
                date("d/m/Y", strtotime($row['closing_date'])),
                $status,
                $file_status,
                $lead_status,
                $row['customer_id'],
                $row->file->current_process_status,
                $row->Created_user,
                array(
                    'currentApproveLevel' => $currentApproveLevel,
                    'accessApproveLevel' => $accessApproveLevel,
                    'is_approved' => $row->file->is_approved
                )
            );

        }
        $data['data'] = $rowData;
        $data['con'] = $condition;

        echo json_encode($data);

    }
    /*
     * function to create lead
     * modified by jisha on 17-9-18. 
     */
    public function actionCreate()
    {
        $model = new Lead();
        $modelMasterSalesGroup = new MasSalesGroup();
        $modelMasterCurrency = new MasCurrency();
        $modelNotes = new Activity();
        $modelMaster = new MasterFile();
        $modelDocument = new Document();
         
        $id = (int) Yii::app()->request->getParam('id');
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $view = (int) Yii::app()->request->getParam('view');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $frm = (int) Yii::app()->request->getParam('frm');

        //echo $id;
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelMaster = $modelMaster->findByPk($model->file_id);
             
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('view' => $view, 'model' => $model, 'modelMaster' => $modelMaster, 'modelDocument' => $modelDocument, 'modelNotes' => $modelNotes, 'modelMasterSalesGroup' => $modelMasterSalesGroup, 'modelMasterCurrency' => $modelMasterCurrency, 'id' => $id, 'file_id' => $file_id, 'sales_group' => $sales_group, 'frm' => $frm ));
    }
    /*
     * function to get customerdetails for lead
     * modified by jisha on 17-9-18. 
     */
    public function actionGetCustomerContactdetails()
    {
        $id = Yii::app()->request->getparam("id");
        $currency_id = Yii::app()->request->getparam("currency_id");
        $models = CustomerContact::getCustomerContacts($id);
        $drop = '<li class="col-sm-3">';
        $model = new Lead;
        $drop .= CHtml::activedropDownList($model, 'contact_id', $models, array('class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Contact <span style="color:red">*</span>', 'data-search' => true, 'onchange' => 'getcontactdetails(this.value)'));
        $drop .= '</li>';
        $model_customer = Customer::model()->findByPk($id);
        $lead_owner_id = $model_customer->lead_owner_id;
        if ($lead_owner_id == 0) {
            $lead_owner_id = Yii::app()->user->id;
            // $lead_owner_id=explode(',',$lead_owner_id);
        }
        // echo $lead_owner_id;exit;
        $drop_1 = '<li class="col-sm-3">';
        $drop_1 .= CHtml::activedropDownList($model, 'lead_owner_id', User::getUserbyId($lead_owner_id), array('class' => 'tooltipster', 'title' => 'Please Select Sales Man', 'data-label' => 'Sales Man <span style="color:red">*</span>', 'data-search' => true));
        $drop_1 .= '</li>';

        $model_lead = Lead::model()->findAll(array('condition' => 'customer_id="' . $id . '" and status="O"'));
        if (!empty($model_lead)) {
            $lead .= '1';
        } else {
            $lead .= '2';
        }
        $salesDrop = CHtml::activedropDownList($model, 'sales_group_id', MasSalesGroup::getSalesGroup(), array('class' => 'tooltipster', 'title' => 'Sales Group', 'data-label' => 'Sales Group', 'data-search' => true));
        $currency_drop_down = CHtml::activedropDownList($model, 'currency', MasCurrency::getCurrency(), array('onChange' => 'getExchangeRate(this.id)', 'title' => 'Currency', 'data-label' => 'Currency', 'options' => array($currency_id => array('selected' => true))));

        $status = array("dt" => $drop, "owner" => $drop_1, "lead" => $lead, 'currency' => $currency_drop_down, 'salesDrop' => $salesDrop);
        echo CJSON::encode($status);
    }
    /*
     * function to get customercontactdetails for lead
     * modified by jisha on 17-9-18. 
     */
    public function actionFetchContactDetails()
    {
        $data = CustomerContact::model()->find('id=:c_id', array(':c_id' => (int) $_POST['contact_id']));
        echo CJSON::encode($data);
    }
    /*
     * function to get document tab details for lead
     * modified by jisha on 17-9-18. 
     */
    public function actionDocumentUpload()
    {
        $file_id = Yii::app()->request->getparam("file_id");
        $frm = Yii::app()->request->getparam("frm");
        $modelDocument = new Document();

        if ($file_id > 0) {
            $modelDocument = Document::model()->find(array('condition' => 'file_id = "' . $file_id . '"'));
            if (empty($modelDocument)) {
                $modelDocument = new Document();
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('document_index', array('modelDocument' => $modelDocument, 'file_id' => $file_id, 'frm' => $frm), false, true);
    }
    /*
     * function to get document datatable details for lead
     * modified by jisha on 17-9-18. 
     */
    public function actionGetDocumentList()
    {

        $model = new Document();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',
            4 => 't.id',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" AND t.file_id = "' . $_POST['file_id'] . '" AND t.file_id > 0';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            if (isset(Yii::app()->user->havePermissionOn['lead_document']) || Yii::app()->user->authorised_user == 1) {
                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';
            }
            $document_name = preg_replace('/^\d{4}-\d{2}-\d{2}-/', '', $row['document_name']);
            $button_string .= '<a href ="' . Yii::app()->createUrl('lead/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            $rowData[] = array($m, $document_name, $model2->username, date("d/m/Y h:m:s", strtotime($row['created_datetime'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    /*
     * function to get notes datatable details for lead
     * modified by jisha on 17-9-18. 
     */
    public function actionGetNotesList()
    {
        $id = $_POST['id'];
        $model = new Activity();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.notes',
            2 => 't.created_by',
            3 => 't.created_datetime',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;
        if ($id == '') {
            $id = 0;
        }
        //$condition = 't.file_id="'.$id.'" AND type_of_activity="N" AND crm_user_id='.Yii::app()->user->id;
        $condition = 't.file_id="' . $id . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (notes LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'created_date_time desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            $rowData[] = array($m, $row['notes'], $model2->username, date("d/m/Y h:m:s", strtotime($row['created_date_time'])));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    /*
     * function to delete doc in datatable details for lead,order
     * modified by jisha on 17-9-18. 
     */
    public function actionDeleteDocument()
    {
        $id = $_POST['id'];
        $modelDocument = new Document();
        $model_doc = Document::model()->findbyPK($id);
        $document_details = explode(',', $model_doc->document_name);
        foreach ($document_details as $value) {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;
            unlink($path);
        }
        $modelDocument->deleteByPk($id);
        echo "success";
    }
    /*
     * function to delete note in datatable details for lead
     * modified by jisha on 17-9-18. 
     */
    public function actionDeleteNote()
    {
        $id = $_POST['id'];
        $modelNote = new Activity();
        $modelNote->deleteByPk($id);
        echo "success";
    }
    public function actiondownloaddocument()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $arr_employee_doc = Document::model()->findByPk($id);
        $file = $arr_employee_doc->document_name;
        $arr_doc_val = explode(',', $arr_employee_doc->document_name);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $arr_employee_doc->document_name . "_" . date('d-m-Y') . ".zip";
            if ($zip->open($zip_file_path, 1 ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "images/attachment/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            //if you want to read text file using text/plain header
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            Yii::app()->end();
        } else {
            $file = $arr_employee_doc->document_name;
            //$file="Purchase Order-20210606-050221.pdf";
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            //header('Content-Type:text/plain; charset=ISO-8859-15');
            //if you want to read text file using text/plain header
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }

        /* $path = Yii::getPathOfAlias('webroot') . "/uploads/quotationpdf/" . $file;

         header("Content-type:application/octet-stream"); //for txt file
         header("Content-Type: application/download");
         header('Content-Disposition: attachment; filename="' . basename($path) . '"');
         header('Content-Length: ' . filesize($path));
         flush(); // Flush system output buffer
         readfile($path);
         Yii::app()->end();*/




    }
    public function actionSaveLead()
    {
        $model = new Lead();
        $modelDocument = new Document();
        $modelMaster = new MasterFile();
        $modelNotes = new Activity();
         
        if (isset($_POST['Lead'])) {
            $scenario = '';
            if ((int) @$_POST['Lead']['id'] > 0) {
                $model->id = (int) $_POST['Lead']['id'];
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $model = $model->findByPK($model->id);
                $model->scenario = 'update';
                $scenario = 'update';
                $lead_type = 'UPDATED';

            } else {
                $model->crm_user_id = Yii::app()->user->id;
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('Y-m-d h:i:s');
                $model->scenario = 'add';
                $scenario = 'add';
                $lead_type = 'CREATED';
            }
            $model->attributes = $_POST['Lead'];
            $model->currency = $_POST['Lead']['currency'];
            $model->value = $_POST['Lead']['value'];
            $model->sales_group_id = $_POST['Lead']['sales_group_id'];
            $model->source_of_lead = $_POST['Lead']['source_of_lead'];
            $model->remarks = $_POST['Lead']['remarks'];
            if ($_POST['frm'] == '3') {

                $model->lead_type = 'service';
                // var_dump($model->lead_type);
            }
            if ($_POST['Lead']['enq_date'] != '00/00/0000') {
                $model->enq_date = str_replace('/', '-', $_POST['Lead']['enq_date']);
                $model->enq_date = date("Y-m-d", strtotime($model->enq_date));
            }
            if ($_POST['Lead']['closing_date'] != '00/00/0000') {
                $model->closing_date = str_replace('/', '-', $_POST['Lead']['closing_date']);
                $model->closing_date = date("Y-m-d", strtotime($model->closing_date));
            }
                      
            if ($model->validate()) {

                if ((int) @$_POST['MasterFile']['id'] > 0) {
                    $id = (int) @$_POST['MasterFile']['id'];
                    $modelMaster = $modelMaster->findByPk($id);
                } else {
                    $modelMaster->customer_id = $_POST['Lead']['customer_id'];
                    $modelMaster->current_process_status = "L";
                    $modelMaster->crm_user_id = Yii::app()->user->id;
                    $modelMaster->created_by = Yii::app()->user->id;
                    $modelMaster->created_datetime = date('Y-m-d h:i:s');
                    $modelMaster->file_title = $_POST['Lead']['title'];
                    $modelMaster->lead_owner_id = $_POST['Lead']['lead_owner_id'];

                    $modelMaster->save(false);
                }
                if ($_POST['Lead']['file_id'] == "") {
                    $model->file_id = $modelMaster->id;
                } else {
                    $model->file_id = $_POST['Lead']['file_id'];
                }
                $model->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'LEADS',
                    Yii::app()->user->id,
                    $lead_type,
                    " with Lead No - {$model->id}  "
                );
                // end audit log 
                if ($scenario == 'add') {
                    $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="2"'));
                    Yii::import('application.controllers.front.MasternotificationController');
                    if ($model_mail_setting->mail_required == 'Y') {
                        // MasternotificationController::sendmail(2,$model->id);
                    }
                    if ($model_mail_setting->notification_required == 'Y') {
                        // MasternotificationController::sendnotification(2,$model->id);
                    }
                    if ($model_mail_setting->sms_required == 'Y') {
                        // MasternotificationController::sendsms(2,$model->id);
                    }
                }
                echo CJSON::encode(array('status' => 'success'));

                if (!empty($_POST['Activity'])) {
                    if ((int) @$_POST['Activity']['id'] > 0) {
                        $id = (int) @$_POST['Activity']['id'];
                        $modelNotes->updated_by = Yii::app()->user->id;
                        $modelNotes->updated_date_time = date('Y-m-d h:i:s');
                        $modelNotes = $modelNotes->findByPk($id);

                    } else {
                        $modelNotes->created_by = Yii::app()->user->id;
                        $modelNotes->created_date_time = date('Y-m-d h:i:s');
                        $modelNotes->notes = $_POST['Activity']['notes'];

                        $modelNotes->crm_user_id = Yii::app()->user->id;
                        $modelNotes->customer_id = $model->customer_id;
                        $modelNotes->contact_id = $model->contact_id;
                        $modelNotes->added_from = 'L';
                        $modelNotes->file_id = $model->file_id;
                    }
                    $modelNotes->attributes = $_POST['Activity'];
                    $modelNotes->date_of_activity = date("Y-m-d H:i:s");
                    $modelNotes->save(false);
                }

                if (isset($_POST['Icon']['file']) && $_POST['Icon']['file'] != '') {
                    $doc_test = Document::model()->find(array('condition' => 'file_id=' . $model->file_id . ' AND document_name="' . $_POST['Icon']['file'] . '"'));
                    if (empty($doc_test)) {
                        $modelDocument = new Document;
                        $modelDocument->uploaded_from = "L";
                        $modelDocument->file_id = $model->file_id;
                        $modelDocument->created_by = Yii::app()->user->id;
                        $modelDocument->created_datetime = date('Y-m-d h:i:s');
                        $modelDocument->document_name = $_POST['Icon']['file'];
                        $modelDocument->save(false);
                    }
                }
                Yii::import('application.modules.features.models.FeaturesOperations');
                Yii::import('application.modules.features.models.FeaturesApproveLevel');
                $operationType = "LE";
                $model_level_approval = FeaturesApproveLevel::model()->find(array('condition' => ' operations_type="' . $operationType .'"'));
                $approveStatus = "N";
                if ($model_level_approval->max_level == 0) {
                    $approveStatus = "Y";
                }
                FeaturesOperations::model()->updateAll(
                    array(
                        'is_active' => "N",
                        'updated_by' => Yii::app()->user->id,
                        'updated_date_time' => date('Y-m-d H:i:s'),
                    ),
                    'file_no = :fid',
                    array(':fid' => (int)$model->file_id)
                );
                MasterFile::model()->updateByPk($model->file_id, array('current_process_status' => "L", 'is_approved' => $approveStatus, 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s')));
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionCreateNote()
    {

        $model = new Activity();
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $id = (int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('note_add_details_2', array('modelNotes' => $model, 'id' => $id, 'file_id' => $file_id, 'customer_id' => $customer_id));

    }
    public function actionSaveNote()
    {
        $modelNotes = new Activity();

        if (!empty($_POST['Activity'])) {
            if ((int) @$_POST['Activity']['id'] > 0) {
                $id = (int) @$_POST['Activity']['id'];
                $modelNotes->updated_by = Yii::app()->user->id;
                $modelNotes->updated_date_time = date('Y-m-d h:i:s');
                $modelNotes = $modelNotes->findByPk($id);
            } else {
                $modelNotes->created_by = Yii::app()->user->id;
                $modelNotes->created_date_time = date('Y-m-d h:i:s');
                $modelNotes->notes = $_POST['Activity']['notes'];
            }
            $modelNotes->attributes = $_POST['Activity'];
            $modelNotes->date_of_activity = date("Y-m-d H:i:s");
            $modelNotes->crm_user_id = Yii::app()->user->id;
            $modelNotes->contact_id = $_POST['contact_id'];
            $modelNotes->file_id = $_POST['file_id'];
            $modelNotes->type_of_activity = 'N';
            $modelNotes->save(false);

            $jsonData['status'] = 'success';
            $jsonData['frm'] = $_POST['requisition-form'];
            $model1 = Lead::model()->find(array('condition' => 't.file_id = "' . $_POST['file_id'] . '"'));
            $jsonData['id'] = $model1->id;
            echo CJSON::encode($jsonData);
        }
    }
    public function actionPrintLeadReportPDF()
    {

        $model = new Lead();
        $id = Yii::app()->request->getParam('id');
        if ($id > 0)
            $model = Lead::model()->findByPk($id);
        $c_id = Yii::app()->request->getParam('c_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $page_title = $id . '-L-' . $model->customer->customer_name . '.pdf';
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.lead_list_individual', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title), true));
        $mPDF1->Output($page_title, 'I');
    }
    /** used in order
     * jisha
     **/

    public function actionGetExchangeRate()
    {

        $currency_id = $_POST['currency_id'];

        $modelCurrency = MasCurrency::model()->find(array('select' => 'exchange_rate', 'condition' => 'id="' . $currency_id . '"'));

        echo $modelCurrency->exchange_rate;

    }
    public function actionSendLeadConversionMail()
    {
        $subject = "Mail Regarding Open Leads that were not Converted to Quotation";
        $view = "lead_notification_mail";
        $from = 'john@mailbluesky.com';
        $to = 'jisha@mailbluesky.com';
        $content = '';
        $applicant_name = 'Diatech ERP TEAM';
        $salutation = 'Dear Sir';
        //setting details
        $model_settings = new MasCompanySettings();
        $crm_login_company_id = Yii::app()->user->master_user_company_id;
        $model_settings = $model_settings->find(array('condition' => 'crm_company_id=' . $crm_login_company_id));
        $lead_to_quotation_days = $model_settings->lead_to_quotation_days;
        //lead details
        $condition = 't.status = "O" AND t.isActive="Y"';
        if ($lead_to_quotation_days > 0) {
            $condition .= ' AND TIMESTAMPDIFF(day,t.created_datetime,NOW())>' . $lead_to_quotation_days;
        }
        $model_lead = Lead::model()->findAll(array('condition' => $condition));
        //SELECT * FROM `erp_lead` `t` WHERE t.status = "O" AND t.isActive="Y"AND TIMESTAMPDIFF(day,t.created_datetime,NOW())>1
        if (!empty($model_lead)) {
            $content .= '<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">
                        File #
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">
                        Lead #
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="12px">
                        Customer
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="12px">
                        Lead Owner
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">
                        Enquiry Date
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">
                        Closing Date
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;" width="10px">
                        Lead Status
                        </th>
                    </tr>';
            foreach ($model_lead as $value) {
                $enq_date = '-';
                if ($value->enq_date != '' && $value->enq_date != '0000-00-00') {
                    $enq_date = date("d/m/Y", strtotime($value->enq_date));
                }
                $closng_date = '-';
                if ($value->closing_date != '' && $value->closing_date != '0000-00-00') {
                    $closng_date = date("d/m/Y", strtotime($value->closing_date));
                }
                $lead_status = "";
                if ($value['lead_status'] == "M") {
                    $lead_status = "Medium";
                } elseif ($value['lead_status'] == "H") {
                    $lead_status = "High";
                } elseif ($value['lead_status'] == "L") {
                    $lead_status = "Low";
                }
                $content .= '<tr>
                    <td style="border: 1px solid #666;padding: 4px 5px;">' . $value['file_id'] . '</td>
                    <td style="border: 1px solid #666;padding: 4px 5px;">' . $value['id'] . '</td>
                    <td style="border: 1px solid #666;padding: 4px 5px;text-align: left;">' . $value->customer->customer_name . '</td>
                    <td style="border: 1px solid #666;padding: 4px 5px;text-align: left;">' . $value->leadowner->first_name . " " . $value->leadowner->last_name . '</td>
                    <td style="border: 1px solid #666;padding: 4px 5px;">' . $enq_date . '</td>
                    <td style="border: 1px solid #666;padding: 4px 5px;;">' . $closng_date . '</td>
                    <td style="border: 1px solid #666;padding: 4px 5px; "">' . $lead_status . '</td>
                    </tr>';
            }
            $content .= '</tbody>
            </table>';
            $mailContent = array();
            $mailContent['body'] = '
                <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit">
                    <tbody>
                        <tr style="vertical-align: top">
                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                                <div>' . $salutation . ',</div>                                              
                            </td>
                        </tr>                                      
                        <tr>
                            <td height="30"></td>
                        </tr>
                        <tr style="vertical-align: top">
                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                                <strong style="font-size: 15px">Sub: ' . $subject . '</strong>
                            </td>
                        </tr>
                        <tr>
                            <td height="30"></td>
                        </tr>
                        <tr style="vertical-align: top">
                            <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">'
                . $content . '<br>
                                <br>
                                <br>
                                Thanking you,
                                <br>
                                <br>
                                Yours sincerely,
                                <br>
                                <br>
                                ' . $applicant_name . '
                            </td>
                        </tr>
                    </tbody>
                </table>';
            ////End Mail Content
            $message = new YiiMailMessage;
            $message->view = $view;
            $message->setBody(array('mailContent' => $mailContent), 'text/html');
            $message->subject = $subject;
            $message->from = $from;
            $message->addTo($to);
            //$message->addCC($custom_mail_id);
            Yii::app()->mail->send($message);
            echo CJSON::encode(array('status' => 'success'));
        }
    }
    /*     public function actionSalesButton()
    {
            $this->render('sales_master');
        }


 public function actionGetCurrency() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'currency LIKE "%' . $searchTerm . '%"';
        $model = new Store();
        $model = $model->findAll(array('select' => 'id,currency,exchange_rate', 'condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->currency;
            $data[$i]['description'] = $eachModel->exchange_rate;

            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }



     public function actionPrintLeadList()
            {
                $id=Yii::app()->request->getparam("id"); 
                $model= Lead::model()->with('customer')->find(array('condition'=>'t.id="'.$id.'"'));
                $title= 'Lead';
                $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
                $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
                $mPDF1->WriteHTML($stylesheet, 1);
                $mPDF1->WriteHTML($this->renderPartial('application.views.front.lead.print_lead_list', array('title'=>$title,'model'=>$model), true));
                $mPDF1->Output('Lead List', 'I'); 
        }

    */


    public function actionGetFilterleadData()
    {

        $filter = Yii::app()->request->getPost('filter');
        $frm = Yii::app()->request->getPost('frm');
        $prefix = ($frm == 3) ? 'service_lead' : 'lead';

        $model = new Lead();

        $qty = 0;
        $extra_years = [];
        $current_year = date('Y');

        // Helper function to get date range for filter and year offset
        $getDateRange = function ($filter, $yearOffset = 0) {
            $targetDate = strtotime("-{$yearOffset} year");
            $year = date('Y', $targetDate);

            switch ($filter) {
                case 'today':
                    $date = date('Y-m-d', $targetDate);
                    return [$date, $date, $year];

                case 'yesterday':
                    $date = date('Y-m-d', strtotime('-1 day', $targetDate));
                    return [$date, $date, $year];

                case 'this_month':
                    $month = date('m');
                    $start = "{$year}-{$month}-01";
                    $end = date('Y-m-t', strtotime($start));
                    return [$start, $end, $year];

                case 'this_year':
                    return ["{$year}-01-01", "{$year}-12-31", $year];

                case 'this_week':
                    $monday = date('Y-m-d', strtotime("monday this week", $targetDate));
                    $sunday = date('Y-m-d', strtotime("sunday this week", $targetDate));
                    return [$monday, $sunday, $year];

                case 'last_week':
                    $monday = date('Y-m-d', strtotime("monday last week", $targetDate));
                    $sunday = date('Y-m-d', strtotime("sunday last week", $targetDate));
                    return [$monday, $sunday, $year];

                case 'quarterly':
                    $month = date('n', $targetDate); // 1-12
                    if ($month >= 1 && $month <= 3) {
                        $start = "$year-01-01";
                        $end = "$year-03-31";
                    } elseif ($month >= 4 && $month <= 6) {
                        $start = "$year-04-01";
                        $end = "$year-06-30";
                    } elseif ($month >= 7 && $month <= 9) {
                        $start = "$year-07-01";
                        $end = "$year-09-30";
                    } else {
                        $start = "$year-10-01";
                        $end = "$year-12-31";
                    }
                    return [$start, $end, $year];

                default:
                    return [null, null, null];
            }
        };

        // Step 1: Get current period range
        list($startDate, $endDate, $current_year) = $getDateRange($filter, 0);

        if (!$startDate || !$endDate) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Invalid filter']);
            Yii::app()->end();
        }

        // Step 2: Fetch current data
        $condition = 'enq_date >= :startDate AND enq_date <= :endDate';
        $params = [':startDate' => $startDate, ':endDate' => $endDate];
        if ($frm == 3) {
            $condition .= ' AND lead_type="service"';
        }
        if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["{$prefix}_view_all"])) {
            $condition .= ' AND t.lead_owner_id = :leadOwnerId';
            $params[':leadOwnerId'] = Yii::app()->user->id;
        }

        $leads = $model->findAll($condition, $params);
        $qty = count($leads);

        // Step 3: Fetch previous 2 years
        for ($i = 1; $i <= 2; $i++) {
            list($prevStart, $prevEnd, $yearLabel) = $getDateRange($filter, $i);

            $conditionPrev = 'enq_date >= :startDate AND enq_date <= :endDate';
            $paramsPrev = [':startDate' => $prevStart, ':endDate' => $prevEnd];

            if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["{$prefix}_view_all"])) {
                $conditionPrev .= ' AND t.lead_owner_id = :leadOwnerId';
                $paramsPrev[':leadOwnerId'] = Yii::app()->user->id;
            }
            $prevQuotes = $model->findAll($conditionPrev, $paramsPrev);
            $prevQty = count($prevQuotes);


            $extra_years[] = [
                'year' => $yearLabel,
                'qty' => $prevQty,
                'date' => in_array($filter, ['today', 'yesterday'])
                    ? date('d-m-Y', strtotime($prevStart))
                    : null,
            ];
        }

        // Final output
        echo CJSON::encode([
            'status' => 'success',
            'data' => [
                'qty' => $qty,
                'current_period' => in_array($filter, ['today', 'yesterday'])
                    ? date('d-m-Y', strtotime($startDate))
                    : $current_year,
                'previous_years' => $extra_years,
            ]
        ]);
        Yii::app()->end();
    }
    public function actionUploadDocumentLead()
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $_GET['folder'] . '/'; // target folder
        $allowedExtensions = array("jpg", "png", "doc", "docx", "xls", "xlsx", "pdf", "bmp", "jpeg");
        $sizeLimit = 1 * 1024 * 1024; // 1MB limit

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);

        if ($result['success']) {
            $originalFile = $result['filename'];
            $extension = pathinfo($originalFile, PATHINFO_EXTENSION);
            $datePrefix = date('Y-m-d') . '-';

            $newFileName = $datePrefix . $originalFile;
            $oldPath = $folder . $originalFile;
            $newPath = $folder . $newFileName;

            if (file_exists($oldPath)) {
                rename($oldPath, $newPath);
            }

            $result['filename'] = $newFileName;
            $result['fileType'] = strtolower($extension);
        }

        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }

    public function actionApproveLevel() {
        $model = new Lead();
        $modelMasterSalesGroup = new MasSalesGroup();
        $modelMasterCurrency = new MasCurrency();
        $modelNotes = new Activity();
        $modelMaster = new MasterFile();
        $modelDocument = new Document();
        $level = (int) Yii::app()->request->getParam('level');
        $id = (int) Yii::app()->request->getParam('id');
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $view = (int) Yii::app()->request->getParam('view');
        $sales_group = Yii::app()->request->getParam('sales_group');
        $frm = (int) Yii::app()->request->getParam('frm');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelMaster = $modelMaster->findByPk($model->file_id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('approvelevel', array('view' => $view, 'model' => $model, 'modelMaster' => $modelMaster, 'modelDocument' => $modelDocument, 'modelNotes' => $modelNotes, 'modelMasterSalesGroup' => $modelMasterSalesGroup, 'modelMasterCurrency' => $modelMasterCurrency, 'id' => $id, 'file_id' => $file_id, 'sales_group' => $sales_group, 'frm' => $frm, 'level' => $level));
    }
}