<?php

class KitController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Delete','Save','GetList'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
         }
         
        public function actionGetList()
         {
 
            $model=new InventoryKit();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 => 'id',
                   1 => 'kit_name',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 'isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" AND (kit_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'kit_name'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $button_string="";
                        if(isset(Yii::app()->user->havePermissionOn['kit_edit']) ||  Yii::app()->user->authorised_user == 1)
                        {
                            $button_string = '<div class="text-center"><button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'kit/create&id='.$row['id'].'\',\'Edit Kit \',\'lg\')"><i class="fa fa-edit"></i></button></div>';
                        }
//                        if(isset(Yii::app()->user->havePermissionOn['bank_delete']) ||  Yii::app()->user->authorised_user == 1)
//                        {
//                            $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteBank('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>';
//                        }
                    $items = '';
                    $data = array_map(function($obj) {return $obj->product->part_number; },$row->items);
                    $items = implode(',', $data);
                    $rowData[]=array($m,$row['kit_name'],$items,$button_string);
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new InventoryKit(); 
        $modelItems = array(new InventoryKitItems);
        $id= Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
            $modelItems = InventoryKitItems::model()->findAll(array('condition' => 'kit_id='.$id));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'modelItems' => $modelItems), false, true);
    }
    public function actionSave()
        {
            $model = new InventoryKit();
            if (isset($_POST['InventoryKit']))
            {
               
    		if ((int) @$_POST['InventoryKit']['id'] > 0)
                {
                    $id= (int) @$_POST['InventoryKit']['id'];
                    $model=$model->findByPk($id); 
                  
                }
                $model->attributes=$_POST['InventoryKit'];
                $valid = $model->validate();
                if(is_array($_POST['InventoryKitItems'])){
                    foreach ($_POST['InventoryKitItems'] as $i => $each){
                        if($each['item'] > 0){
                            $modelItem[$i] = new InventoryKitItems;
                            if($each['id'] > 0){
                                 $modelItem[$i] =  $modelItem[$i]->findBypk($each['id']);
                            }
                            $modelItem[$i]->attributes = $each;
                            $valid =  $modelItem[$i]->validate() && $valid;
                        }
                    }
                }
                if($_POST['InventoryKit']['kit_name'] != ''){
                    $store = Store::model()->findAll(array('condition' => 'part_number="'.$_POST['InventoryKit']['kit_name'].'"'));
                    if(!empty($store)){
                            $valid = false;
                            $flag = 1;
                    }
                }
                if($valid)
                {       
                        $model->save();
                        foreach ($modelItem as $eachItem){
                            $eachItem->kit_id = $model->id;
                            $eachItem->save();
                        }
                        $jsonData['status'] = 'success';
                        echo CJSON::encode($jsonData);
                      
                }
                else
                {
                        $error1 = $error2 = array();
                        $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                        if ($modelItem[0]->item != '')
                                $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                            else
                                $error2[] = "Please add atleast one item";
                            
                        if($flag == 1)
                                $error2[] = "An Item is exist with same name";
                        $error = CJSON::encode(array_merge_recursive($error2,$error1));
                        if ($error != '[]')
		               echo $error;
                }
             

            }
        }
        public function actionDelete()
    {
//		$id = $_POST['id'];
//                $model_c = Customer::model()->findAll(array('condition'=>'customer_bank_id='.$id.''));
//                $model_v = Vendor::model()->findAll(array('condition'=>'vendor_category='.$id.''));
              //  if(empty($model_c) && empty($model_v)){
                        $model=new InventoryKitItems();
                        $model->deleteByPk($id);
                        $jsonData['status'] = "success";
                        echo CJSON::encode($jsonData);
             //   }
             //   else{
                   //   echo "fail";
             //   }
              
    }
  
  
}