<?php

class IwarehouseController extends Controller
{
    public function accessRules()
    {

        return array(

            array(
                'allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

            ),

            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array(
                    'Index',
                    'Create',
                    'Receive',
                    'Transfer',
                    'SaveTransfer',
                    'Warehousetransfer',
                    'GetList',
                    'GetReceiveItems',
                    'GetItem',
                    'DirectIndex',
                    'InDirectIndex',
                    'DirectCreate',
                    'InDirectCreate',
                    'GetToWarehouse',
                    'GetIndirectList',
                    'SaveIndirectTransfer',
                    'ConvertTransfer',
                    'CheckWarehouse',
                    'CheckQuantity',
                    'getStockQty',
                    'ReceiveItems',
                    'SaveReceiveItems',
                    'GetProducts',
                    'PrintIndirectReceivePDF',
                    'PrintDirectTransferPDF',
                    'PrintInDirectTransferPDF',
                    'GetStockDetails',
                    'getStockDetails_indirectTrans',
                    'GetFactor',
                    'Getunitdrop',
                    'getTowarehouseLocation',
                    'Getmtomlist',
                    'Mtomtransferindex',
                    'Mtomtransfercreate',
                    'Unitdrop',
                    'GetProductsmtom',
                    'GetWarehousedata',
                    'Savemtomtransfer',
                    'PrintMtomTransferPDF',
                    'FetchMaterialDetailsWithSerialNo',
                    'createRakeBin',
                    'SaveChangeRackBinSerialno',
                    'Changerackbin',
                    'FetchMaterialDetails',
                    'GetRackBinProduct',
                    'Getbin',
                    'SaveChangeRackBin',
                    'GetIndirectCheckinList',
                    'GetIndirecttransactionlist',
                    'Hiringindirectindex',
                    'GetHireIndirectList',
                    'GetHireIndirectCheckinList',
                    'GetHireIndirecttransactionlist',
                    'HireInDirectCreate',
                    'GetHireProducts',
                    'SaveHireIndirectTransfer',
                    'PrintHireInDirectTransferPDF',
                    'GetBinsWithItems',
                    'GetProductOtherDetails',
                    'GetAllProducts',
                    'PrintDirectTransferExcel',

                    'Directindex_sample',
                    'Getlistsample',
                    'DirectCreatesample',
                    'PrintSampleTransferPDF',
                    'PrintsampleTransferExcel',
                    'SaveTransfersample',
                    'GetProductsWithBarcode',
                    'PackagingGetList',
                    'SaveIndirectTransferIn',
                    'GetIndirecttransactionlistTransit',
                    'GetIndirecttransactionlistIn',
                    'getDestinationwarehouseLocation',
                    'getReferenceIds',
                    'getItemDetails',
                    'Indexmeterial',
                    'Getlistmeterial',
                    'Createmeterial',
                    'GetInvoiceDropdown',
                    'getCustomerShippingdetails',
                    'SaveTransferMeterial',
                    'SaveTransferIssue',
                    'Convertmeterial',
                    'Getmachinedetails',
                    'GetContractFragranceDetails',
                    'Approve',
                    'PrintMachine',
                    'IndexMachineTransfer',
                    'GetMachineTransferlist',
                    'CreateMachineTransfer',
                    'SaveMachineTransfer',
                    'GetMachineOrderItemDetails'
                ),


                'expression' => '$user->isMember()', /**copied by jisha from bouleward on 8-11-17**/

            ),

            array(
                'deny', // deny all users

                'users' => array('*'),

            ),

        );
    }
    /**copied by jisha from bouleward on 8-11-17**/
    public function actionWarehousetransfer()
    {
        $model = array(new InventoryDirectTransferItem());
        $model_main = new InventoryDirectTransfer();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('warehousetransfer', array('model' => $model, 'model_main' => $model_main));

    }
    public function actionGetToWarehouse()
    {
        $id = (int) Yii::app()->request->getparam("id");
        $type = (int) Yii::app()->request->getparam("type");
        //print_r($id);die();
        $models = MasInventoryWarehouse::getToWarehouses($id);
        $drop = '<li class="col-sm-3">';
        if ($type == 1) {
            $drop = '<li class="col-sm-3">';
            $model = new InventoryDirectTransfer;
        } else if ($type == 2) {
            $drop = '<li class="col-sm-4">';
            $model = new InventoryIndirectTransfer;
        }
        $drop .= CHtml::activedropDownList($model, 'to_warehouse_id', $models, array('empty' => 'Select', 'class' => 'tooltipster', 'title' => 'Please Select To Warehouse', 'data-label' => 'To Warehouse *'));
        $drop .= '</li>';
        $status = array("dt" => $drop);
        echo CJSON::encode($status);

    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionDirectIndex()
    {

        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['inventory_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['direct_transfer_view']) &&
                Yii::app()->user->havePermissionOn['inventory_menu_view'] &&
                Yii::app()->user->havePermissionOn['direct_transfer_view']
            )
        ) {
            $this->render('direct_index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }
    public function actionInDirectIndex()
    {
        $frm = Yii::app()->request->getParam('frm');
        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['inventory_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['direct_transfer_in_view']) ||
                isset(Yii::app()->user->havePermissionOn['direct_transfer_out_view']) &&
                Yii::app()->user->havePermissionOn['inventory_menu_view'] &&
                Yii::app()->user->havePermissionOn['direct_transfer_view']
            )
        ) {
            if ($frm == 'out') {
                $this->render('indirect_index', array('frm' => $frm));

            }
            if ($frm == 'in') {
                $this->render('indirect_in_index', array('frm' => $frm));

            }
            if ($frm == 'InTransit') {
                $this->render('inTransit_index', array('frm' => $frm));

            }
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }
    public function actionReceive()
    {
        $this->render('receive_index');
    }
    public function actionGetList()
    {

        $model = new InventoryDirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            1 => 'warehouseTo.warehouse_name',
            2 => 'warehouseFrom.warehouse_name',
            3 => 'direct_transfer_description',
            4 => 'reference',
            5 => 'transfer_date',
            6 => 't.id'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = "t.id DESC";
        // $condition = 't.status="C"';
        //   --------added-by-indhu-21-01-2023--------------
        $condition = 't.status="C"   AND  t.added_from="DT" AND t.type = "T" '; //DT = Direct transfer
        //   ---------------------------


        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and t.id LIKE '%" . $searchString . "%'  OR t.reference LIKE '%" . $searchString . "%' OR user_det.first_name LIKE '%" . $searchString . "%'
    OR user_det.last_name LIKE '%" . $searchString . "%'
    OR CONCAT(user_det.first_name, ' ', user_det.last_name) LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%'";
        }
        $count = $model->with('warehouseTo', 'warehouseFrom','user_det')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom','user_det')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row->transfer_date) && ($row->transfer_date != "")) {
                $req_date = date("d/m/Y", strtotime($row->transfer_date));
            }

            $div = '';
            /*if (isset(Yii::app()->user->havePermissionOn['direct_transfer_view']) || Yii::app()->user->authorised_user == 1) {
                $div = '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'iwarehouse/directcreate&type=view&id=' . $row['id'] . '\',\'Direct Transfer\',\'xl\')"><i class="fa fa-eye"></i></button>';
            }*/
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_print"])) {
                //$div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintDirectTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_excel"])) {
                // $div .= '&nbsp;<button class="btn btn-success  btn-xs" title="Excel" onclick="window.open(\'index.php?r=iwarehouse/PrintDirectTransferExcel&id='. $row['id'].'\')"><i class="fa fa-file-excel-o"></i></button> ';
            }
            if ($row['lead_owner_id'] > 0) {
                $user = $row['user_det']['first_name'] . ' ' . $row['user_det']['last_name'];

            } else {
                $user = '';
            }
            $rowData[] = array( $row['id'],$req_date, $row['warehouseFrom']['warehouse_name'], $row['warehouseTo']['warehouse_name'], $user, $row['direct_transfer_description'], $row['reference'],  '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }


    public function actionGetIndirectList()
    {

        $model = new InventoryIndirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            //1 =>'warehouseTo.warehouse_name',
            //2 =>'warehouseFrom.warehouse_name',                                     
            //3 =>'direct_transfer_description',
            //4 =>'reference', 
            //5 =>'transfer_date', 
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 AND is_complete="N"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = '1=1 AND is_complete="N"';
            $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%' OR t.indirect_transfer_description LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('warehouseTo', 'warehouseFrom')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row->transfer_date) && ($row->transfer_date != ""))
                $req_date = date("d/m/Y", strtotime($row->transfer_date));//,$row['warehouseTo']['warehouse_name']
            $div = '';
            if (isset(Yii::app()->user->havePermissionOn['indirect_transfer_view']) || Yii::app()->user->authorised_user == 1) {
                $div = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'iwarehouse/indirectcreate&type=view&id=' . $row['id'] . '\',\'External Transfer\',\'xl\')"><i class="fa fa-eye"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_indirecttransfer_pdf"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintInDirectTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';

            }
            if (isset(Yii::app()->user->havePermissionOn['indirect_transfer_add']) || Yii::app()->user->authorised_user == 1 && $row->is_complete == 'N') {
                $div .= ' <button class="btn btn-primary btn-xs" title="Convert" onclick="loadPopupModal(\'packaging/create&status=IDTOUT&id=' . $row['id'] . '\',\'External Transfer\',\'xl\')"><i class="fa fa-retweet"></i></button>';

            }
            $rowData[] = array($row['id'], $row['warehouseFrom']['warehouse_name'], $row['intermediate_location'], $row['indirect_transfer_description'], $row['reference'], $req_date, '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetReceiveItems()
    {

        $model = new InventoryIndirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            1 => 'from_warehouse',
            2 => 'intermediate_location',
            3 => 'reference',
            4 => 'transfer_date',
            5 => 'id'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (from_warehouse LIKE '%" . $searchString . "%' OR intermediate_location LIKE '%" . $searchString . "%' OR transfer_id LIKE '%" . $searchString . "%'OR reference LIKE '%" . $searchString . "%')";
        }
        $sql_command = "SELECT * FROM ((SELECT  IR.id,'I' AS type,'0' AS transfer_id, IFW.warehouse_name as from_warehouse,intermediate_location,reference,transfer_date
                                    from crm_inventory_indirect_transfer IR 
                                    LEFT JOIN crm_mas_inv_warehouse IFW ON IFW.id=IR.from_warehouse_id
                                    WHERE IR.is_complete!='Y'
                                )    
                                UNION ALL                                     
                                (    SELECT  IR.id AS id,'R' AS type,IR.indirect_transfer_id AS transfer_id,IFW.warehouse_name as from_warehouse,intermediate_location,reference,transfer_date
                                    from crm_inventory_indirect_received IR 
                                    LEFT JOIN crm_mas_inv_warehouse IFW ON IFW.id=IR.from_warehouse_id
                                ))A
                                WHERE " . $condition . "
                                    ORDER BY A.id DESC";
        $model = Yii::app()->db->createCommand($sql_command)->queryAll();
        $count = count($model);
        //$count = $model->with('warehouseTo','warehouseFrom')->count(array('condition'=>$condition));
        //$model=$model->with('warehouseTo','warehouseFrom')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row['transfer_date']) && ($row['transfer_date'] != ""))
                $req_date = date("d/m/Y", strtotime($row['transfer_date']));//,$row['warehouseTo']['warehouse_name']
            $div = ' ';
            if ($row['type'] == "I") {
                if (isset(Yii::app()->user->havePermissionOn['inv_recieveditem_receive']) || Yii::app()->user->authorised_user == 1) {
                    $div .= '<button class="btn btn-primary btn-xs" title="Receive Items" onclick="loadPopupModal(\'iwarehouse/receiveitems&transfer_id=' . $row['id'] . '\',\'Receive Items\',\'xl\')"><i class="fa fa-repeat"></i></button>';
                }
                $id = $row['id'];

            } else {
                if (isset(Yii::app()->user->havePermissionOn['inv_recieveditem_view']) || Yii::app()->user->authorised_user == 1) {
                    $div .= '  <button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'iwarehouse/receiveitems&type=view&id=' . $row['id'] . '\',\'Transferd Items\',\'xl\')"><i class="fa fa-eye"></i></button>';

                }
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_receiveditem_pdf"])) {
                    $div .= '  <a class="btn btn-primary btn-xs" title="Print Receipt" target="_blank" href="index.php?r=iwarehouse/PrintIndirectReceivePDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';

                }
                $id = $row['transfer_id'];
            }
            $rowData[] = array($id, $row['from_warehouse'], $row['intermediate_location'], $row['reference'], $req_date, '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetItem()
    {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'part_number LIKE "%' . $searchTerm . '%"'; // AND t.customer_vendor_type = 1
        $model = new Store();
        $model = $model->findAll(array('select' => 'description', 'condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['description'] = $eachModel->description;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionDirectCreate()
    {
        $model = new InventoryDirectTransfer();
        $model_items = array(new InventoryDirectTransferItem());
        $id = (int) Yii::app()->request->getParam('id');
        $type = (int) Yii::app()->request->getParam('type');
        if ($id > 0) {

            $model = $model->findByPk($id);
            // var_dump($model);die();
            $transfer_date = str_replace('/', '-', $model->transfer_date);
            $transfer_date = date('d/m/Y', strtotime($transfer_date));
            $model->transfer_date = $transfer_date;
            $model_items = InventoryDirectTransferItem::model()->findAll(array('condition' => 'direct_transfer_id="' . $id . '"'));
            if (empty($model_items)) {
                $model_items = array(new InventoryDirectTransferItem());
            }

        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('directtransfer_create', array('model' => $model, 'model_items' => $model_items, 'type' => $type));
    }
    public function actionInDirectCreate()
    {
        $model = new InventoryIndirectTransfer();
        $model_items = array(new InventoryIndirectTransferItem());
        $id = (int) Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        $frm = Yii::app()->request->getParam('frm');
        $req_id = (int) Yii::app()->request->getParam('req_id');

        //$model_material_stock=array(new MaterialReceiptStockDetails());

        if ($id > 0) {
            $model = $model->findByPk($id);
            $transfer_date = str_replace('/', '-', $model->transfer_date);
            $transfer_date = date('d/m/Y', strtotime($transfer_date));
            $model->transfer_date = $transfer_date;
            $model_items = InventoryIndirectTransferItem::model()->findAll(array('condition' => 'indirect_transfer_id="' . $id . '"'));
            if (empty($model_items)) {
                $model_items = array(new InventoryIndirectTransferItem());
            }


        }
        if ($req_id > 0) {
            $requisition = PurchasingRequisition::model()->findByPk($req_id);

            if ($requisition !== null) {
                $model_items = array(); // Initialize array
                $warehouse_id = $requisition->warehouse_id;
                $defaultWarehouse_id = MasInventoryWarehouse::getDefaultWarehouse();
                $model->from_warehouse_id = $defaultWarehouse_id;
                $model->to_warehouse_id = $warehouse_id;
                $model->reference = $req_id;
                foreach ($requisition->stockitems as $stockitem) {
                    $item = new InventoryIndirectTransferItem(); // Must match model in loop

                    $item->item_id = $stockitem->stock_item_id;
                    $item->item_name = $stockitem->stock_item_name;
                    $item->item_description = $stockitem->stock_item_description;
                    $item->unit = $stockitem->stock_item_unit;
                    $item->transfer_qty = $stockitem->stock_item_quantity;
                    // $total_allocated_product = AllocatedMaterial::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $item->item_id . '"'))->quantity;
                    $total_available_product = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $item->item_id . '"'))->quantity;
                    $item->total_qty = (float) $total_available_product;

                    $condition = '1=1';

                    $qtycondition = ' WHERE quantity > 0 ';

                    if ((int) $defaultWarehouse_id > 0) {
                        $condition .= ' AND (warehouse_id = ' . (int) $defaultWarehouse_id . ' OR warehouse_id = 0)';
                    }

                    $condition .= ' AND product_id = "' . $item->item_id . '"';

                    $query = '
                    SELECT SUM(quantity) AS total_quantity
                    FROM (
                        SELECT 
                            SUM(quantity) AS quantity
                        FROM view_warehousewise_stock
                        WHERE ' . $condition . '
                        GROUP BY product_id
                    ) A ' . $qtycondition;
                    $connection = Yii::app()->db;
                    $command = $connection->createCommand($query);
                    $result = $command->queryRow();

                    $total_allocated_product = isset($result['total_quantity']) ? (float) $result['total_quantity'] : 0;
                    $item->allocated_qty = (float) $total_allocated_product;
                    // Optional default values if needed:
                    // $item->total_qty = 0;
                    // $item->allocated_qty = 0;
                    // $item->pickable_quantity = 0;

                    $model_items[] = $item;
                }
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if ($frm == 'out') {
            $this->render('indirecttransfer_create', array('model' => $model, 'model_items' => $model_items, 'type' => $type, 'frm' => $frm, 'req_id' => $req_id));
        }
        if ($frm == 'in') {
            $this->render('indirecttransfer_create_in', array('model' => $model, 'model_items' => $model_items, 'type' => $type, 'frm' => $frm));
        }
    }
    public function actionConvertTransfer()
    {
        $model = new InventoryIndirectTransfer();
        $model_items = array(new InventoryIndirectTransferItem());
        $id = (int) Yii::app()->request->getParam('id');

        if ($id > 0) {

            $model = $model->findByPk($id);
            $transfer_date = str_replace('/', '-', $model->transfer_date);
            $transfer_date = date('d/m/Y', strtotime($transfer_date));
            $model->transfer_date = $transfer_date;
            $model_items = InventoryIndirectTransferItem::model()->findAll(array('condition' => 'indirect_transfer_id="' . $id . '"'));
            if (empty($model_items)) {
                $model_items = array(new InventoryIndirectTransferItem());
            }

        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('convert_indirect_transfer', array('model' => $model, 'model_items' => $model_items));
    }
    public function actionTransfer()
    {
        $model = new Store();
        $date = date("Y-m-d H:i:s");

        if (isset($_POST['Store'])) {
            if ((int) @$_POST['Store']['id'] > 0) {
                $id = (int) @$_POST['Store']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = $date;
            }

            $model->attributes = $_POST['Store'];
            StockLedger::model()->stock_id = $model->id;
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = $date;
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = $date;
            $model->inventory_item_type = '1';

            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['inventory_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionCheckWarehouse()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $fw = (int) Yii::app()->request->getParam('fw');
        //              print_r($id); print_r($fw);die();
        $model_from_store = StockLedger::model()->find(array('condition' => 'stock_id=' . $id . ' and warehouse_id=' . $fw));
        if (empty($model_from_store)) {
            $jsonData['id'] = $id;
            $jsonData['status'] = 'error';
            echo CJSON::encode($jsonData);
        }
    }

    public function actionGetProducts()
    {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $warehouse_id = 0;
        if (isset($_GET['term']) && $_GET['term'] != "") {
            $warehouse_id = $_GET['frm_warehouse_id'];
        }
        if (isset($_GET['from_warehouse_id'])) {
            $warehouse_id = $_GET['from_warehouse_id'];
        }
        $searchTerm = $_GET['term'];
        $condition = 'isActive = "Y" AND ( inventory_item_type =1 OR inventory_item_type=3) AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';

        $model = new Store();
        $model = $model->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {

            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number . ' : ' . $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            //$data[$i]['supercede_id'] = $eachModel->supercede_id;
            //$data[$i]['supercede_name'] = $eachModel->supercede->part_number;
            //$data[$i]['supercede_des'] = $eachModel->supercede->description;
            //$data[$i]['supercede_unit_name'] = $eachModel->supercede->unit->symbol;
            //$data[$i]['supercede_unit_id'] = $eachModel->supercede->unit->id;
            $total_allocated_product = AllocatedMaterial::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $eachModel->id . '"'))->quantity;
            $total_available_product = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $eachModel->id . '"'))->quantity;
            $available_qty = 0;
            if ($warehouse_id > 0) {
                $available_qty = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $eachModel->id . '" AND warehouse_id=' . $warehouse_id))->quantity;
            }
            $data[$i]['total_qty'] = (float) $total_available_product;
            $data[$i]['allocated_qty'] = (float) $total_allocated_product;
            $data[$i]['other'] = (float) $available_qty;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionCheckQuantity()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $qty = (int) Yii::app()->request->getParam('qty');
        $fw = (int) Yii::app()->request->getParam('fw');
        $model_from_store = StockLedger::model()->find(array('condition' => 'stock_id=' . $id . ' and warehouse_id=' . $fw));
        if ($model_from_store->quantity < $qty) {
            $jsonData['id'] = $id;
            $jsonData['quantity'] = $model_from_store->quantity;
            $jsonData['status'] = 'error';
            echo CJSON::encode($jsonData);
        }
    }
    public function actionGetStockQty()
    {
        $item_id = (int) Yii::app()->request->getParam('item_id');
        $ware_house_id = (int) Yii::app()->request->getParam('ware_house_id');
        $model_from_store = StockLedger::model()->find(array('condition' => 'stock_id=' . $item_id . ' and warehouse_id=' . $ware_house_id));
        $jsonData['id'] = $model_from_store->id;
        $jsonData['quantity'] = $model_from_store->quantity;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);

    }


    public function actionSaveTransfer()
    {

        $model = new InventoryDirectTransfer();

        /************ START Code for Save ***************/

        if (isset($_POST['InventoryDirectTransfer'])) {

            if ((int) @$_POST['InventoryDirectTransfer']['id'] > 0) {

                $id = (int) @$_POST['InventoryDirectTransfer']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('y-m-d');
                $audit_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('y-m-d h:m:s');
                $audit_type = 'CREATED';
            }

            $model->attributes = $_POST['InventoryDirectTransfer'];
            $model->direct_transfer_description = $_POST['InventoryDirectTransfer']['direct_transfer_description'];
            $model->reference = $_POST['InventoryDirectTransfer']['reference'];
            //$model->lead_owner_id = $_POST['InventoryDirectTransfer']['lead_owner_id'];
            
           // $model->customer_id = $_POST['InventoryDirectTransfer']['customer_id'];
            //$model->file_id = $_POST['InventoryDirectTransfer']['file_id'];
            //$model->outlet_id = $_POST['InventoryDirectTransfer']['outlet_id'];

            if ($_POST['InventoryDirectTransfer']['transfer_date'] != '' && $_POST['InventoryDirectTransfer']['transfer_date'] != '0000-00-00') {
                $model->transfer_date = str_replace('/', '-', $_POST['InventoryDirectTransfer']['transfer_date']);
                $model->transfer_date = date("Y-m-d", strtotime($model->transfer_date));
            }
            $valid = $model->validate();
            $other_errors = array();

            //   ---------------------AccAuditClose check------------------------------------


            $transfer_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['InventoryDirectTransfer']['transfer_date'])));

            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
            $transfer_date = strtotime($transfer_datex);
            if ($transfer_date <= $existing_date) {
                $valid = false;
                $other_errors[] = ' Given Transfer Date must be greater than Audit Close Date :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';

            }
            //   --------------------//-AccAuditClose check------------------------------------



            if (isset($_POST['InventoryDirectTransferItem'])) {

                foreach ($_POST['InventoryDirectTransferItem'] as $i => $items) {
                    $model_item[$i] = new InventoryDirectTransferItem();
                    $model_item[$i]->item_id = $items['item_id'];
                    $model_item[$i]->item_description = $items['item_description'];
                    $model_item[$i]->item_name = $items['item_name'];
                    $model_item[$i]->transfer_qty = $items['transfer_qty'];
                    $model_item[$i]->unit = $items['unit'];
                    $valid = $model_item[$i]->validate() && $valid;

                }

            }
            if ($valid) {

                $model->save();

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'DIRECT_TRANSFER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with PKGNo: - {$model->id}  "
                );
                // end audit log 
                InventoryDirectTransferItem::model()->deleteAll('direct_transfer_id=:refer_id', array(':refer_id' => $model->id));
                foreach ($model_item as $each) {
                    $each->direct_transfer_id = $model->id;
                    $each->save();
                }
                $jsonData['id'] = $model->id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_item[0]->item_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other_errors));
                if ($error != '[]') {
                    echo $error;
                }

            }
        }
    }

    public function actionSaveIndirectTransfer()
    {

        $model = new InventoryIndirectTransfer();
        $other_errors = array();
        $req_id = $_REQUEST['hide_req_id'];
        if (isset($_POST['InventoryIndirectTransfer'])) {

            if ((int) @$_POST['InventoryIndirectTransfer']['id'] > 0) {

                $id = (int) @$_POST['InventoryIndirectTransfer']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('y-m-d');
                $audit_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('y-m-d');
                $audit_type = 'CREATED';
                $scenario = 'add';
            }

            $model->attributes = $_POST['InventoryIndirectTransfer'];
            $model->indirect_transfer_description = $_POST['InventoryIndirectTransfer']['indirect_transfer_description'];
            $model->intermediate_location = $_POST['InventoryIndirectTransfer']['intermediate_location'];
            $model->to_warehouse_id = $_POST['InventoryIndirectTransfer']['to_warehouse_id'];
            $model->customer_name = $_POST['InventoryIndirectTransfer']['customer_name'];
            $model->customer_id = $_POST['InventoryIndirectTransfer']['customer_id'];
            $model->reference = $_POST['InventoryIndirectTransfer']['reference'];
            if ($_POST['InventoryIndirectTransfer']['transfer_date'] != '' && $_POST['InventoryIndirectTransfer']['transfer_date'] != '0000-00-00') {
                $model->transfer_date = str_replace('/', '-', $_POST['InventoryIndirectTransfer']['transfer_date']);
                $model->transfer_date = date("Y-m-d", strtotime($model->transfer_date));
            }
            $valid = $model->validate();
            if (isset($_POST['InventoryIndirectTransferItem'])) {

                $arr_item_ids = array_column($_POST['InventoryIndirectTransferItem'], 'item_id');
                $arr_avail_qty = [];
                if (!empty($arr_item_ids)) {
                    $mod_avail_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty,product_id FROM `erp_stock_ledger` WHERE stock_updated="Y" AND  product_id iN(' . implode(",", $arr_item_ids) . ') AND warehouse_id=' . (int) $model->from_warehouse_id . ' GROUP BY product_id,warehouse_id')->queryAll();
                    foreach ($mod_avail_qty as $rowavailqty) {
                        $arr_avail_qty[$rowavailqty['product_id']] = (float) $rowavailqty['availble_qty'];
                    }
                }

                $arr_unit_ids = array_column($_POST['InventoryIndirectTransferItem'], 'unit');
                $arr_sec_unt = [];
                if (!empty($arr_unit_ids)) {
                    $mod_avail_units = UnitOfMeasurement::model()->findAll(['condition' => 'id IN(' . implode(",", $arr_unit_ids) . ')']);
                    foreach ($mod_avail_units as $eachunit) {
                        $arr_sec_unt[$eachunit['id']] = $eachunit;
                    }
                }

                foreach ($_POST['InventoryIndirectTransferItem'] as $i => $items) {

                    if ($items['id'] > 0) {
                        $model_item[$i] = InventoryIndirectTransferItem::model()->findByPK($items['id']);

                    } else {
                        $model_item[$i] = new InventoryIndirectTransferItem();
                    }

                    $modelStore = new Store();
                    $modelStore = $modelStore->findByPk($items['item_id']);
                    $model_item[$i]->item_id = $items['item_id'];
                    $model_item[$i]->item_description = $items['item_description'];
                    $model_item[$i]->item_name = $items['item_name'];
                    $model_item[$i]->transfer_qty = $items['transfer_qty'];
                    $model_item[$i]->unit = $items['unit'];
                    $arr_secondary_unit = (isset($arr_sec_unt[$items['unit']]) ? $arr_sec_unt[$items['unit']] : []);

                    $availble_qty = (float) (isset($arr_avail_qty[$items['item_id']]) ? $arr_avail_qty[$items['item_id']] : '0');
                    if ((int) $items['transfer_qty'] <= 0) {
                        $other_errors[] = 'Quantity should be greater than zero';
                        $valid = false;
                    }

                    $total_qty = $items['transfer_qty'] * (float) $arr_secondary_unit['factor'];
                    if ((float) $total_qty > (float) $availble_qty && $modelStore->inventory_item_type != 2) {
                        $other_errors[] = 'Available Quantity for ' . $modelStore->part_number . ' is ' . (float) $availble_qty;
                        $valid = false;
                    }

                    $valid = $model_item[$i]->validate() && $valid;
                    $model_item[$i]->available_qty = $availble_qty;
                }

            }

            if ($valid) {

                $model->save();
                $header_id = $model->id;
                $customer_vendor_id = $model->customer_id;
                $customer_vendor_name = $model->customer_name;
                // var_dump($customer_vendor_id);
                // var_dump($customer_vendor_name);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'INDIRECT_TRANSFER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with Transfer No: - {$model->id}  "
                );
                // end audit log 
                $modelMasCompanySettings = new MasCompany();
                $company_id = Yii::app()->user->master_user_company_id;
                $modelMasCompanySettings = $modelMasCompanySettings->findByPK($company_id);
                $packaging = $modelMasCompanySettings->packaging;

                $wnameOut = MasInventoryWarehouse::getWarehouseName($model->from_warehouse_id);
                $wnameIn = MasInventoryWarehouse::getWarehouseName($model->intermediate_location);
                $file_id = 0;
                foreach ($model_item as $each) {
                    $each->indirect_transfer_id = $model->id;
                    $each->save();

                    $product = Store::model()->findByPk($each->item_id);
                    $arr_secondary_unit = (isset($arr_sec_unt[$each['unit']]) ? $arr_sec_unt[$each['unit']] : []);
                    if ($packaging != 'Y'):
                        $stockLedgerOut = new StockLedger();
                        $stockLedgerOut->file_id = $file_id;
                        $stockLedgerOut->header_id = $header_id;
                        $stockLedgerOut->reference_id = $header_id;
                        $stockLedgerOut->reference_no = $model->reference;
                        $stockLedgerOut->header_item_id = $each->id;
                        $stockLedgerOut->customer_vendor_id = $customer_vendor_id;
                        $stockLedgerOut->customer_vendor_name = $customer_vendor_name;
                        $stockLedgerOut->product_id = $each->item_id;
                        $stockLedgerOut->product_name = $each->item_name;
                        $stockLedgerOut->product_description = $each->item_description;
                        $stockLedgerOut->brand_id = $product->brand_class_id ?? 0;
                        $stockLedgerOut->brand_name = $product->brand_detail->brand_name ?? '';
                        $stockLedgerOut->warehouse_id = $model->from_warehouse_id;
                        $stockLedgerOut->warehouse_name = $wnameOut;
                        $stockLedgerOut->rack_id = $product->rack_id ?? 0;
                        $stockLedgerOut->rack_name = MasInvRack::getRackName($product->rack_id);
                        $stockLedgerOut->bin_id = $product->bin_id ?? 0;
                        $stockLedgerOut->bin_name = MasInvBin::getBinName($product->bin_id);
                        $stockLedgerOut->unit_id = $arr_secondary_unit->id ?? 0;
                        $stockLedgerOut->unit_name = $arr_secondary_unit->name ?? '';
                        $stockLedgerOut->unit_factor = $arr_secondary_unit->factor ?? '';
                        $stockLedgerOut->quantity = (-1 * $each->transfer_qty);
                        $stockLedgerOut->cost_price = 0;
                        $stockLedgerOut->sales_price = 0;
                        $stockLedgerOut->available_status = 'U';

                        $stockLedgerOut->batch_no = '';
                        $stockLedgerOut->serial_no = '';
                        $stockLedgerOut->manufacturing_date = '';
                        $stockLedgerOut->expiry_date = '';

                        $stockLedgerOut->transaction_date = $model->transfer_date;
                        $stockLedgerOut->transaction_from = 'INDIRECT_TRANSFER_OUT';
                        $stockLedgerOut->transaction_type = 'OUT';
                        $stockLedgerOut->created_by = Yii::app()->user->id;
                        $stockLedgerOut->created_date = date('Y-m-d H:i:s');
                        $stockLedgerOut->master_stock_ledger_id = '0';

                        $stockLedgerOut->save(false);

                        // 
                        $stockLedgerIn = new StockLedger();
                        $stockLedgerIn->file_id = $file_id;
                        $stockLedgerIn->header_id = $model->id;
                        $stockLedgerIn->reference_id = $model->id;
                        $stockLedgerIn->reference_no = $model->reference;
                        $stockLedgerIn->header_item_id = $each->id;
                        $stockLedgerIn->customer_vendor_id = $customer_vendor_id;
                        $stockLedgerIn->customer_vendor_name = $customer_vendor_name;
                        $stockLedgerIn->product_id = $each->item_id;
                        $stockLedgerIn->product_name = $each->item_name;
                        $stockLedgerIn->product_description = $each->item_description;
                        $stockLedgerIn->brand_id = $product->brand_class_id ?? 0;
                        $stockLedgerIn->brand_name = $product->brand_detail->brand_name ?? '';
                        $stockLedgerIn->warehouse_id = $model->intermediate_location;
                        $stockLedgerIn->warehouse_name = $wnameIn;
                        $stockLedgerIn->rack_id = $product->rack_id ?? 0;
                        $stockLedgerIn->rack_name = MasInvRack::getRackName($product->rack_id);
                        $stockLedgerIn->bin_id = $product->bin_id ?? 0;
                        $stockLedgerIn->bin_name = MasInvBin::getBinName($product->bin_id);
                        $stockLedgerIn->unit_id = $arr_secondary_unit->id ?? 0;
                        $stockLedgerIn->unit_name = $arr_secondary_unit->name ?? '';
                        $stockLedgerIn->unit_factor = $arr_secondary_unit->factor ?? '';
                        $stockLedgerIn->quantity = (1 * $each->transfer_qty);
                        $stockLedgerIn->cost_price = 0;
                        $stockLedgerIn->sales_price = 0;
                        $stockLedgerIn->available_status = 'A';

                        $stockLedgerIn->batch_no = '';
                        $stockLedgerIn->serial_no = '';
                        $stockLedgerIn->manufacturing_date = '';
                        $stockLedgerIn->expiry_date = '';

                        $stockLedgerIn->transaction_date = $model->transfer_date;
                        $stockLedgerIn->transaction_from = 'INDIRECT_TRANSFER_IN';
                        $stockLedgerIn->transaction_type = 'IN';
                        $stockLedgerIn->created_by = Yii::app()->user->id;
                        $stockLedgerIn->created_date = date('Y-m-d H:i:s');
                        $stockLedgerIn->master_stock_ledger_id = '0';

                        $stockLedgerIn->save(false);
                    endif;
                    if ($scenario == 'add') {
                        // $userIds = User::getWarehouseUser($model->to_warehouse_id);
                        // $userIdsString = implode(',', $userIds);

                        // $notification = new MasErpNotification();
                        // $notification->reference_no = $model->id;
                        // $notification->user_ids = $userIdsString;
                        // $notification->notes = "New Indirect Transfer Out Created. Req No: " . $model->id;
                        // $notification->notification_date_time = date('Y-m-d H:i:s');
                        // $notification->status = 'O';
                        // $notification->notification_type = 18;
                        // $notification->created_by = Yii::app()->user->id;
                        // $notification->created_date_time = date('Y-m-d H:i:s');

                        // if ($notification->save(false)) {  // save once and check success
                        //     foreach ($userIds as $userId) {
                        //         $history = new UserNotificationHistory();
                        //         $history->notification_id = $notification->id;
                        //         $history->user_id = $userId;
                        //         $history->notif_status = 'N'; // Not read
                        //         $history->created_by = Yii::app()->user->id;
                        //         $history->created_date_time = date('Y-m-d H:i:s');
                        //         $history->save(false);
                        //     }
                        // }
                    }








                }

                if ($req_id > 0) {
                    $requisition = PurchasingRequisition::model()->findByPk($req_id);
                    if ($requisition !== null) {
                        $requisition->convert_status = 0;
                        $requisition->save();
                    }
                }

                $jsonData['id'] = $model->id;
                ;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                // echo '1';
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_item[0]->item_id))
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other_errors));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionSaveIndirectTransferIn()
    {
        $other_errors = [];
        $postData = Yii::app()->request->getPost('InventoryIndirectTransfer');
        $itemData = Yii::app()->request->getPost('InventoryIndirectTransferItem');

        $references = isset($postData['reference']) ? $postData['reference'] : [];

        // Group items by indirect_transfer_id
        $itemsByTransfer = [];
        foreach ($itemData as $item) {
            $itemsByTransfer[$item['indirect_transfer_id']][] = $item;
        }

        $validItems = [];
        $modelsToMarkComplete = [];
        $arr_unit_ids = array_column($itemData, 'unit');
        $arr_sec_unt = [];
        if (!empty($arr_unit_ids)) {
            $mod_avail_units = UnitOfMeasurement::model()->findAll([
                'condition' => 'id IN(' . implode(",", $arr_unit_ids) . ')'
            ]);
            foreach ($mod_avail_units as $eachunit) {
                $arr_sec_unt[$eachunit['id']] = $eachunit;
            }
        }

        foreach ($references as $refId) {
            $model = InventoryIndirectTransfer::model()->findByPk($refId);


            if ($model === null) {
                $other_errors[] = "Transfer ID $refId not found.";
                continue;
            }

            if (!empty($itemsByTransfer[$refId])) {
                foreach ($itemsByTransfer[$refId] as $item) {

                    $transferQty = (float) ($item['transfer_qty'] ?? 0);
                    $transferredQty = (float) ($item['transferred_qty'] ?? 0);
                    $missingQty = (float) ($item['missing_qty'] ?? 0);
                    $damagedQty = (float) ($item['damaged_qty'] ?? 0);
                    $sumQty = $transferredQty + $missingQty + $damagedQty;
                    if (abs($transferQty - $sumQty) > 0.001) {
                        $other_errors[] = "Total Quantity is not equal to Received Qty + Missing Qty + Damaged Qty for Reference ID $refId, Item ID " . $item['item_name'];
                        continue;
                    }

                    $itemModel = InventoryIndirectTransferItem::model()->findByPk($item['id']);
                    if ($itemModel === null) {
                        $other_errors[] = "Transfer item ID " . $item['id'] . " not found.";
                        continue;
                    }
                    $validItems[$refId][] = [
                        'model' => $model,
                        'itemModel' => $itemModel,
                        'itemData' => $item,
                    ];
                }
            }

            $modelsToMarkComplete[$refId] = $model;
        }

        if (!empty($other_errors)) {
            echo json_encode([
                'status' => 'error',
                'errors' => $other_errors,
            ]);
            Yii::app()->end();
        }
        $modelMasCompanySettings = new MasCompany();
        $company_id = Yii::app()->user->master_user_company_id;
        $modelMasCompanySettings = $modelMasCompanySettings->findByPK($company_id);
        $packaging = $modelMasCompanySettings->packaging;
        foreach ($validItems as $refId => $items) {
            $model = $modelsToMarkComplete[$refId];

            foreach ($items as $entry) {
                $itemModel = $entry['itemModel'];
                $item = $entry['itemData'];

                $transferQty = (float) ($item['transfer_qty'] ?? 0);
                $transferredQty = (float) ($item['transferred_qty'] ?? 0);
                $missingQty = (float) ($item['missing_qty'] ?? 0);
                $damagedQty = (float) ($item['damaged_qty'] ?? 0);

                $itemModel->transferred_qty = $transferredQty;
                $itemModel->missing_qty = $missingQty;
                $itemModel->damaged_qty = $damagedQty;
                $itemModel->to_warehouse_id = $postData['to_warehouse_id'];

                if (!$itemModel->save()) {
                    $other_errors[] = "Failed to update transfer item ID " . $item['id'];
                    continue;
                }

                $product = Store::model()->findByPk($itemModel->item_id);
                $arr_secondary_unit = isset($arr_sec_unt[$itemModel['unit']]) ? $arr_sec_unt[$itemModel['unit']] : [];

                $wnameOut = MasInventoryWarehouse::getWarehouseName($postData['from_warehouse_id']);
                $wnameIn = MasInventoryWarehouse::getWarehouseName($postData['to_warehouse_id']);
                $wnameMis = MasInventoryWarehouse::getWarehouseName(MasInventoryWarehouse::getWarehouseIdByCode('MIS'));
                $wnameDam = MasInventoryWarehouse::getWarehouseName(MasInventoryWarehouse::getWarehouseIdByCode('DAM'));
                $customer_vendor_id = 0;
                $customer_vendor_name = '';
                $file_id = 0;

                // Stock Ledger OUT
                if ($packaging != 'Y'):
                    $stockLedgerOut = new StockLedger();
                    $stockLedgerOut->file_id = $file_id;
                    $stockLedgerOut->header_id = $model->id;
                    $stockLedgerOut->reference_id = $model->id;
                    $stockLedgerOut->reference_no = $model->reference;
                    $stockLedgerOut->header_item_id = $itemModel->id;
                    $stockLedgerOut->customer_vendor_id = $customer_vendor_id;
                    $stockLedgerOut->customer_vendor_name = $customer_vendor_name;
                    $stockLedgerOut->product_id = $itemModel->item_id;
                    $stockLedgerOut->product_name = $itemModel->item_name;
                    $stockLedgerOut->product_description = $itemModel->item_description;
                    $stockLedgerOut->brand_id = $product->brand_class_id ?? 0;
                    $stockLedgerOut->brand_name = $product->brand_detail->brand_name ?? '';
                    $stockLedgerOut->warehouse_id = $postData['from_warehouse_id'];
                    $stockLedgerOut->warehouse_name = $wnameOut;
                    $stockLedgerOut->rack_id = $product->rack_id ?? 0;
                    $stockLedgerOut->rack_name = MasInvRack::getRackName($product->rack_id);
                    $stockLedgerOut->bin_id = $product->bin_id ?? 0;
                    $stockLedgerOut->bin_name = MasInvBin::getBinName($product->bin_id);
                    $stockLedgerOut->unit_id = $arr_secondary_unit->id ?? 0;
                    $stockLedgerOut->unit_name = $arr_secondary_unit->name ?? '';
                    $stockLedgerOut->unit_factor = $arr_secondary_unit->factor ?? '';
                    $stockLedgerOut->quantity = (-1 * $transferQty);
                    $stockLedgerOut->cost_price = 0;
                    $stockLedgerOut->sales_price = 0;
                    $stockLedgerOut->available_status = 'U';
                    $stockLedgerOut->transaction_date = $model->transfer_date;
                    $stockLedgerOut->transaction_from = 'INDIRECT_TRANSFER_OUT';
                    $stockLedgerOut->transaction_type = 'OUT';
                    $stockLedgerOut->created_by = Yii::app()->user->id;
                    $stockLedgerOut->created_date = date('Y-m-d H:i:s');
                    $stockLedgerOut->master_stock_ledger_id = '0';
                    $stockLedgerOut->save(false);

                    // Stock Ledger IN
                    $stockLedgerIn = new StockLedger();
                    $stockLedgerIn->attributes = $stockLedgerOut->attributes;
                    $stockLedgerIn->warehouse_id = $postData['to_warehouse_id'];
                    $stockLedgerIn->warehouse_name = $wnameIn;
                    $stockLedgerIn->quantity = $transferredQty;
                    $stockLedgerIn->available_status = 'A';
                    $stockLedgerIn->transaction_from = 'INDIRECT_TRANSFER_IN';
                    $stockLedgerIn->transaction_type = 'IN';
                    $stockLedgerIn->save(false);
                    if ($missingQty > 0) {
                        // Stock Ledger IN
                        $stockLedgerIn = new StockLedger();
                        $stockLedgerIn->attributes = $stockLedgerOut->attributes;
                        $stockLedgerIn->warehouse_id = MasInventoryWarehouse::getWarehouseIdByCode('MIS');
                        $stockLedgerIn->warehouse_name = $wnameMis;
                        $stockLedgerIn->quantity = $missingQty;
                        $stockLedgerIn->available_status = 'A';
                        $stockLedgerIn->transaction_from = 'INDIRECT_TRANSFER_IN';
                        $stockLedgerIn->transaction_type = 'IN';
                        $stockLedgerIn->save(false);
                    }

                    if ($damagedQty > 0) {
                        // Stock Ledger IN
                        $stockLedgerIn = new StockLedger();
                        $stockLedgerIn->attributes = $stockLedgerOut->attributes;
                        $stockLedgerIn->warehouse_id = MasInventoryWarehouse::getWarehouseIdByCode('DAM');
                        $stockLedgerIn->warehouse_name = $wnameDam;
                        $stockLedgerIn->quantity = $damagedQty;
                        $stockLedgerIn->available_status = 'A';
                        $stockLedgerIn->transaction_from = 'INDIRECT_TRANSFER_IN';
                        $stockLedgerIn->transaction_type = 'IN';
                        $stockLedgerIn->save(false);
                    }
                endif;
            }

            // $model->is_complete = 'Y';
            $model->status = 'C';
            if (!$model->save()) {
                $other_errors[] = "Failed to mark transfer ID $refId as complete.";
            }
        }

        if (!empty($other_errors)) {
            echo json_encode([
                'status' => 'error',
                'errors' => $other_errors,
            ]);
            Yii::app()->end();
        }

        echo json_encode([
            'status' => 'success',
            'message' => 'All transfers and items validated and saved successfully.',
        ]);
    }

    public function actionGetIndirecttransactionlistTransit()
    {

        $model = new InventoryIndirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            //1 =>'warehouseTo.warehouse_name',
            //2 =>'warehouseFrom.warehouse_name',                                     
            //3 =>'direct_transfer_description',
            //4 =>'reference', 
            //5 =>'transfer_date', 
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $ModelUser = User::model()->findByPk((int) Yii::app()->user->id);
        $condition = '1=1 AND is_complete = "P" AND (status = "TO" OR status = "TI")';

        // $condition .= ' AND (from_warehouse_id IN (' . $ModelUser->available_warehouses . ') OR to_warehouse_id IN (' . $ModelUser->available_warehouses . '))';


        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = '1=1 AND is_complete="N"';
            $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%' OR t.indirect_transfer_description LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }

        $count = $model->with('warehouseTo', 'warehouseFrom')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        // $model=Yii::app()->db->createCommand("select * from erp_inventory_indirect_transfer where $condition")->queryAll();
        $count = count($model);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row['transfer_date']) && ($row['transfer_date'] != ""))
                $req_date = date("d/m/Y", strtotime($row['transfer_date']));//,$row['warehouseTo']['warehouse_name']
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_in_print"]) || ((int) Yii::app()->user->havePermissionOn["direct_transfer_out_print"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintInDirectTransferPDF&frm=transit&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            $rowData[] = array($row['id'], $req_date, $row['warehouseFrom']['warehouse_name'], $row['warehouseTo']['warehouse_name'], $row['reference'], $row['indirect_transfer_description'], '<div class="btn-wrap text-center">' . $div . '</div>', $row['status']);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionReceiveItems()
    {
        $model = new InventoryIndirectReceived();
        $model_items = array(new InventoryIndirectReceivedItems());
        $id = (int) Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        $transfer_id = Yii::app()->request->getParam('transfer_id');
        $model_material_stock = array(new MaterialReceiptStockDetails());
        if ($id > 0) {

            $model = $model->findByPk($id);
            $transfer_date = str_replace('/', '-', $model->transfer_date);
            $transfer_date = date('d/m/Y', strtotime($transfer_date));
            $model->transfer_date = $transfer_date;
            $model_items = InventoryIndirectReceivedItems::model()->findAll(array('condition' => 'indirect_receive_transfer_id="' . $id . '"'));
            if (empty($model_items)) {
                $model_items = array(new InventoryIndirectReceivedItems());
            }

            $model_material_stock = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'material_receipt_id="' . $id . '" AND transaction_type="In Direct Transfer"'));
            if (empty($model_material_stock)) {
                $model_material_stock = array(new MaterialReceiptStockDetails());
            }

        } else if ($transfer_id > 0) {
            $model_transfer = InventoryIndirectTransfer::model()->findByPk($transfer_id);
            $model->from_warehouse_id = $model_transfer->from_warehouse_id;
            $model->intermediate_location = $model_transfer->intermediate_location;
            $model->indirect_transfer_id = $model_transfer->id;
            $transfer_date = str_replace('/', '-', $model_transfer->transfer_date);
            $transfer_date = date('d/m/Y', strtotime($transfer_date));
            $model->receive_date = $transfer_date;
            $model_transfer_items = InventoryIndirectTransferItem::model()->findAll(array('condition' => 'indirect_transfer_id="' . $transfer_id . '"'));
            foreach ($model_transfer_items as $i => $each_item) {
                $model_material_stock_detail = InventoryInDirectTransferItemDetails::model()->with('mr_indirect')->find(array('condition' => 'indirect_transfer_id="' . $transfer_id . '" and mr_indirect.product_id="' . $each_item->item_id . '"', 'join' => 'LEFT JOIN crm_material_receipt_stock_details AS stock ON t.from_material_receipt= stock.id'));
                $model_items[$i] = new InventoryIndirectReceivedItems;
                $model_items[$i]->item_name = $each_item->item_name;
                $model_items[$i]->item_id = $each_item->item_id;
                $model_items[$i]->indirect_transferitem_id = $each_item->id;
                $model_items[$i]->item_description = $each_item->item_description;
                $bal_qty = $each_item->transfer_qty - ($each_item->transferred_qty + $each_item->damaged_qty);
                $model_items[$i]->transfer_qty = $bal_qty;
                $model_items[$i]->unit = $each_item->unit;
                $model_items[$i]->from_material_receipt = $model_material_stock_detail->from_material_receipt;
            }

        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('receive_create', array('model' => $model, 'model_items' => $model_items, 'type' => $type, 'model_material_stock' => $model_material_stock));
    }

    public function actionSaveReceiveItems()
    {

        $model = new InventoryIndirectReceived();
        $model_indirect_transfer = new InventoryIndirectTransfer();

        if (isset($_POST['InventoryIndirectReceived'])) {
            $model->attributes = $_POST['InventoryIndirectReceived'];
            if ($_POST['InventoryIndirectReceived']['transfer_date'] != '' && $_POST['InventoryIndirectReceived']['transfer_date'] != '0000-00-00') {
                $model->transfer_date = str_replace('/', '-', $_POST['InventoryIndirectReceived']['transfer_date']);
                $model->transfer_date = date("Y-m-d", strtotime($model->transfer_date));
            }
            $model->reference = $_POST['InventoryIndirectReceived']['reference'];
            $model->indirect_transfer_description = $_POST['InventoryIndirectReceived']['indirect_transfer_description'];
            $to_warehouse_id = $_POST['InventoryIndirectReceived']['to_warehouse_id'];
            $indirect_transfer_id = $_POST['InventoryIndirectReceived']['indirect_transfer_id'];
            $model_indirect_transfer = $model_indirect_transfer->findByPk($indirect_transfer_id);
            $valid = $model->validate();
            if (is_array($_POST['InventoryIndirectReceivedItems'])) {
                $error3 = array();
                foreach ($_POST['InventoryIndirectReceivedItems'] as $i => $rowItem) {
                    if ($rowItem['receive_qty'] == '')
                        $rowItem['receive_qty'] = 0;
                    if ($rowItem['damaged_qty'] == '')
                        $rowItem['damaged_qty'] = 0;
                    if ($rowItem['receive_qty'] > 0 || $rowItem['damaged_qty'] > 0) {
                        $model_item[$i] = new InventoryIndirectReceivedItems();
                        $model_item[$i]->indirect_receive_transfer_id = 0;
                        $model_item[$i]->indirect_transferitem_id = $rowItem['indirect_transferitem_id'];
                        $model_item[$i]->item_id = $rowItem['item_id'];
                        $model_item[$i]->unit = $rowItem['unit'];
                        $model_item[$i]->item_name = $rowItem['item_name'];
                        $model_item[$i]->item_description = $rowItem['item_description'];
                        $model_item[$i]->receive_qty = $rowItem['receive_qty'];
                        $model_item[$i]->transfer_qty = $rowItem['transfer_qty'];
                        $model_item[$i]->damaged_qty = $rowItem['damaged_qty'];
                        $valid = $model_item[$i]->validate() && $valid;
                    }
                }

            }
            if (!empty($_POST['MaterialReceiptStockDetails'])) {

                foreach ($_POST['MaterialReceiptStockDetails'] as $i => $item) {
                    if ($item['quantity'] > 0) {
                        $model_stock_item[$i] = new MaterialReceiptStockDetails();
                        $model_stock_item[$i]->created_by = Yii::app()->user->id;
                        $model_stock_item[$i]->created_date = date('Y-m-d');
                        $model_stock_item[$i]->attributes = $_POST['MaterialReceiptStockDetails'][$i];
                        $model_stock_item[$i]->warehouse_id = $to_warehouse_id;
                        $model_stock_item[$i]->rack_id = $item['rack_id'];
                        $model_stock_item[$i]->bin_id = $item['bin_id'];
                        $model_stock_item[$i]->material_receipt_date = "0000-00-00";
                        $model_stock_item[$i]->stock_affect_date = date("Y-m-d");
                        $batch_mandty = $item['batch_mandty'];
                        $serial_mandty = $item['serial_mandty'];
                        if ($batch_mandty == 1) {
                            $model_stock_item[$i]->batch_no = $item['batch_no'];
                            $item['expiry_date'] = str_replace('/', '-', $item['expiry_date']);
                            $model_stock_item[$i]->expiry_date = date("Y-m-d", strtotime($item['expiry_date']));
                            $item['manufacture_date'] = str_replace('/', '-', $item['manufacture_date']);
                            $model_stock_item[$i]->manufacture_date = date("Y-m-d", strtotime($item['manufacture_date']));
                        }

                        if ($serial_mandty == 1) {
                            $model_stock_item[$i]->serial_no = $item['serial_no'];
                        }
                        $model_stock_item[$i]->transaction_type = 'In Direct Transfer';
                        $model_stock_item[$i]->material_receipt_id = '0';

                        /**Updating Product Location */
                        $con = 'stock_id=' . $item['product_id'];
                        if ($_POST['InventoryIndirectReceived']['to_warehouse_id'] > 0)
                            $con .= ' AND warehouse_id=' . $_POST['InventoryIndirectReceived']['to_warehouse_id'];
                        if ($item['rack_id'] > 0)
                            $con .= ' AND rack=' . $item['rack_id'];
                        if ($item['bin_id'] > 0)
                            $con .= ' AND bin=' . $item['bin_id'];
                        $StockLedger = StockLedger::model()->find(array('condition' => $con));
                        if ($StockLedger->id > 0) {
                            $loc = StockLedger::model()->findByPk($StockLedger->id);
                            $loc->quantity = $loc->quantity + $item['quantity'];
                            $loc->save(false);
                        } else {
                            $newloc = new StockLedger;
                            $newloc->stock_id = $item['product_id'];
                            $newloc->warehouse_id = $_POST['InventoryIndirectReceived']['to_warehouse_id'];
                            $newloc->rack = $item['rack_id'];
                            $newloc->bin = $item['bin_id'];
                            $newloc->quantity = $item['quantity'];
                            $newloc->save(false);
                        }
                    }
                }
            }

            if ($valid) {
                $model->save();
                $finish_flag = 0;
                foreach ($model_item as $eachitem) {
                    $eachitem->indirect_receive_transfer_id = $model->id;
                    $eachitem->save();


                    $modelindirectitem = InventoryIndirectTransferItem::model()->findByPK($eachitem->indirect_transferitem_id);
                    $old_qty = $modelindirectitem->transferred_qty + $modelindirectitem->damaged_qty;
                    $cur_qty = $eachitem->receive_qty + $eachitem->damaged_qty;
                    $modelindirectitem->transferred_qty = $modelindirectitem->transferred_qty + $eachitem->receive_qty;
                    $modelindirectitem->damaged_qty = $modelindirectitem->damaged_qty + $eachitem->damaged_qty;
                    $total_qty = $old_qty + $cur_qty;
                    if ($modelindirectitem->transfer_qty > ($total_qty)) {
                        $finish_flag = 1;
                    }
                    $modelindirectitem->save(false);

                }
                if (!empty($model_stock_item)) {
                    //MaterialReceiptStockDetails::model()->deleteAll(array("condition"=>"material_receipt_id='".$modelOrder->id."' AND transaction_type= 'Direct Purchase Order'"));
                    foreach ($model_stock_item as $each_item) {
                        $each_item->material_receipt_id = $model->id;
                        $each_item->tot_quantity = $each_item->quantity;
                        $each_item->quantity = $each_item->quantity;
                        $each_item->save(false);




                    }

                }
                if ($finish_flag == 0) {
                    $model_indirect_transfer->is_complete = 'Y';
                } else {
                    $model_indirect_transfer->is_complete = 'P';
                }
                $model_indirect_transfer->save(false);
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);

                if (!empty($model_item[0]->item_id))
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3));
                if ($error != '[]')
                    echo $error;
            }

        }
    }
    public function actionPrintIndirectReceivePDF()
    {

        $model = new InventoryIndirectReceived();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.inv_transfer_receive', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
    public function actionPrintInDirectTransferPDF()
    {

        $model = new InventoryIndirectTransfer();
        $id = Yii::app()->request->getParam('id');
        $frm = Yii::app()->request->getParam('frm');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.inv_transfer_indirect', array('model' => $model, 'id' => $id, 'title' => $title, 'frm' => $frm), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
    public function actionPrintDirectTransferPDF()
    {

        $model = new InventoryDirectTransfer();
        $id = (int) Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.inv_transfer_direct', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output("DirectTransferReceipt.pdf", 'I');
    }
    /**Jo */
    public function actionGetStockDetails()
    {

        $product_id = $_POST['product_id'];
        $quantity = $_POST['Qty'];
        $length = $_POST['length'];
        $from_warehouse = $_POST['from_warehouse'];
        $to_warehouse = $_POST['to_warehouse'];
        $stock_details = array(new MaterialReceiptStockDetails);

        if ((int) $product_id > 0) {
            $product = Store::model()->findBypk($product_id);
            $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id = ' . $product_id . ' AND quantity > 0 AND warehouse_id = ' . $from_warehouse));
        }

        $table = '';
        if ($stock_details[0]->id > 0) {

            foreach ($stock_details as $each) {


                $table .= '<tr class="TR-' . $length . ' pro' . $product_id . '">';
                $table .= '<td class="bg-success">' . $product->part_number . CHtml::hiddenfield('Data[' . $length . '][product_id]', $product_id) . CHtml::hiddenfield('Data[' . $length . '][material_receipt_id]', $each->id) . '</td>';
                $table .= '<td class="bg-success">' . $each->rack->name . CHtml::hiddenfield('Data[' . $length . '][rack_id]', $each->rack_id) . '</td>';
                $table .= '<td class="bg-success">' . $each->bin->name . CHtml::hiddenfield('Data[' . $length . '][bin_id]', $each->bin_id) . CHtml::hiddenfield('Data[' . $length . '][from_warehouse]', $from_warehouse) . '</td>';
                $table .= '<td class="bg-success">' . CHtml::textfield('Data[' . $length . '][qty_available]', $each->quantity, array('class' => 'form-control text-right', 'readonly' => 'readonly')) . '</td>';
                $table .= '<td class="bg-danger">' . CHtml::dropDownList('Data[' . $length . '][new_rack]', '', MasInvRack::getRacks(), array('class' => 'form-control', 'empty' => '-select-')) . '</td.>';
                $table .= '<td class="bg-danger">' . CHtml::dropDownList('Data[' . $length . '][new_bin]', '', MasInvBin::getBins(), array('class' => 'form-control', 'empty' => '-select-')) . CHtml::hiddenfield('Data[' . $length . '][to_warehouse]', $to_warehouse) . '</td.>';
                $table .= '<td class="bg-danger">' . CHtml::textfield('Data[' . $length . '][picked_qty]', '', array('class' => 'form-control text-right', 'onkeyup' => 'verifyQty(this.id,this.value);')) . '</td>';
                $table .= '</tr>';
                $length++;
            }

        } else {
            if ($length == 0)
                $table .= '<tr class="no-data-tr"><td colspan="7" class="text-center"> No Data </td></tr>';
        }

        echo $table;
    }

    public function actionGetStockDetails_indirectTrans()
    {

        $product_id = $_POST['product_id'];
        $quantity = $_POST['Qty'];
        $length = $_POST['length'];
        $from_warehouse = $_POST['from_warehouse'];
        $to_warehouse = $_POST['to_warehouse'];
        $stock_details = array(new MaterialReceiptStockDetails);

        if ((int) $product_id > 0) {
            $product = Store::model()->findBypk($product_id);
            $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id = ' . $product_id . ' AND quantity > 0 AND warehouse_id = ' . $from_warehouse));
        }

        $table = '';
        if ($stock_details[0]->id > 0) {

            foreach ($stock_details as $each) {
                //                $mod_alloc=new AllocatedMaterial();
//                $alloc_qty=$mod_alloc->find(array('select'=>'SUM(quantity)AS quantity ','condition'=>'product_id = '.$product_id.' AND warehouse_id ='.$from_warehouse))->quantity;
//                $free_qty=(float)((float)$each->quantity-(float)$alloc_qty);


                $table .= '<tr class="TR-' . $length . ' pro' . $product_id . '">';
                $table .= '<td class="bg-success">' . $product->part_number . CHtml::hiddenfield('Data[' . $length . '][product_id]', $product_id) . CHtml::hiddenfield('Data[' . $length . '][material_receipt_id]', $each->id) . '</td>';
                $table .= '<td class="bg-success">' . $each->rack->name . CHtml::hiddenfield('Data[' . $length . '][rack_id]', $each->rack_id) . '</td>';
                $table .= '<td class="bg-success">' . $each->bin->name . CHtml::hiddenfield('Data[' . $length . '][bin_id]', $each->bin_id) . CHtml::hiddenfield('Data[' . $length . '][from_warehouse]', $from_warehouse) . '</td>';
                $table .= '<td class="bg-success">' . CHtml::textfield('Data[' . $length . '][qty_available]', $each->quantity, array('class' => 'form-control text-right', 'readonly' => 'readonly')) . '</td>';
                //$table .= '<td class="bg-danger">'.CHtml::dropDownList('Data['.$length.'][new_rack]','',MasInvRack::getRacks(), array('class'=>'form-control','empty'=>'-select-')).'</td.>';
                //$table .= '<td class="bg-danger">'.CHtml::dropDownList('Data['.$length.'][new_bin]','',MasInvBin::getBins(), array('class'=>'form-control','empty'=>'-select-')).CHtml::hiddenfield('Data['.$length.'][to_warehouse]',$to_warehouse).'</td.>';
                $table .= '<td class="bg-danger">' . CHtml::textfield('Data[' . $length . '][picked_qty]', '', array('class' => 'form-control text-right', 'onkeypress' => 'return isPositiveNumber(event)', 'onkeyup' => 'verifyQty(this.id,this.value);')) . '</td>';
                $table .= '</tr>';
                $length++;
            }

        } else {
            if ($length == 0)
                $table .= '<tr class="no-data-tr"><td colspan="7" class="text-center"> No Data </td></tr>';
        }

        echo $table;
    }

    /*jo*/
    public function actionGetunitdrop()
    {
        $row = $_POST['row_field'];
        $product = $_POST['product_id'];
        $drop = array();
        if ($_POST['type'] == 'direct') {
            $modelOrder = new InventoryDirectTransferItem;
        } else if ($_POST['type'] == 'HT') {
            $modelOrder = new InventoryHiringTransferItem;
        } else {
            $modelOrder = new InventoryIndirectTransferItem;
        }

        if ($product > 0) {
            $modelOrder->unit = UnitOfMeasurement::getBaseunit($product);
            $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit", UnitOfMeasurement::getUnits($product), array('class' => 'unit go', 'onchange' => 'getFactor(this.id,this.value)'));
        }
        echo CJSON::encode($drop);
    }

    public function actionGetFactor()
    {
        $factor = 1;
        if ((int) $_POST['value'] > 0) {
            $factor = UnitOfMeasurement::getFactor($_POST['value']);
        }
        echo $factor;
    }
    /*end*/

    public function actiongetTowarehouseLocation()
    {
        $from_id = $_POST['from_id'];
        $type = $_POST['type'];
        $data = array();
        $model = new InventoryDirectTransfer;
        $erpsettings = MasCompany::getCurrentUserERPSetting();

        if ($erpsettings == 'E') {
            $warehouseArray = MasInventoryWarehouse::getToWarehouses($from_id);
        }
        if ($erpsettings == 'C') {
            $warehouseArray = MasInventoryWarehouse::getToWarehousesCRM($from_id);
        }
        if ($from_id > 0) {
            if ($type) {
                $data['towarehouse'] = CHtml::activedropDownList($model, 'to_warehouse_id', $warehouseArray, array('class' => '', 'data-label' => 'To Warehouse <span style="color:red">*</span>', 'empty' => '--Select--'));
            } else {
                $data['towarehouse'] = CHtml::activedropDownList($model, 'to_warehouse_id', $warehouseArray, array('class' => '', 'data-label' => 'To Warehouse <span style="color:red">*</span>', 'empty' => '--Select--', 'onChange' => 'erpSettingDetails(this.value);'));
            }
            //echo $form->dropDownList($model,'to_warehouse_id',MasInventoryWarehouse::getWarehouses(),array('class' => '','data-label'=>'To Warehouse <span style="color:red">*</span>','empty'=>'--Select--')); 
        }
        echo CJSON::encode($data);
    }
    /**
     * Material to Material Transfer
     * Created on 19-01-2018 jo~
     * Index Function 
     */
    public function actionMtomtransferindex()
    {
        $this->render('mtom_index');
    }
    public function actionMtomtransfercreate()
    {
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $model = new MtomTransfer;
        $this->render('mtom_create', array('model' => $model));
    }
    public function actionGetmtomlist()
    {

        $model = new MtomTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            1 => 't.transfer_date',
            2 => 'fromproduct.part_number',
            3 => 'toproduct.part_number',
            4 => 't.note',
            5 => 't.id',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and t.id LIKE '%" . $searchString . "%' OR fromproduct.part_number LIKE '%" . $searchString . "%' OR toproduct.part_number LIKE '%" . $searchString . "%'";
        }
        $count = $model->with('fromproduct', 'toproduct')->count(array('condition' => $condition));
        $model = $model->with('fromproduct', 'toproduct')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            //  if(!empty($row->transfer_date)&&($row->transfer_date!=""))
            //  $req_date=date("d/m/Y", strtotime($row->transfer_date));
            //  $div='';
            //  if(isset(Yii::app()->user->havePermissionOn['direct_transfer_view']) ||  Yii::app()->user->authorised_user == 1)
            //  {
            //      $div ='<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'iwarehouse/directcreate&type=view&id='.$row['id'].'\',\'Direct Transfer\',\'xl\')"><i class="fa fa-eye"></i></button>';
            //  }
            // if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_directtransfer_pdf"])){ 
            $div = ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintMtomTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';

            // }
            $rowData[] = array($row['id'], date("d/m/Y", strtotime($row->transfer_date)), $row['fromproduct']['part_number'], $row['toproduct']['part_number'], $row['note'], '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionGetProductsmtom()
    {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $from_id = $_GET['from_id'];
        $to_id = $_GET['to_id'];
        $frm_sno = $_GET['frm_sno'];
        $con = '';
        if (!empty($frm_sno)) {
            //have_serial_no
            $con .= ' AND have_serial_no = "' . $frm_sno . '"';
        }
        $condition = 'isActive = "Y" AND ( inventory_item_type =1 OR inventory_item_type=3) AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") ' . $con;
        if ($from_id > 0)
            $condition .= 'AND id !=' . $from_id;
        if ($to_id > 0)
            $condition .= 'AND id !=' . $to_id;
        $model = new Store();
        $model = $model->findAll(array('condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {

            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number . ' : ' . $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $data[$i]['supercede_id'] = $eachModel->supercede_id;
            $data[$i]['supercede_name'] = $eachModel->supercede->part_number;
            $data[$i]['supercede_des'] = $eachModel->supercede->description;
            $data[$i]['supercede_unit_name'] = $eachModel->supercede->unit->symbol;
            $data[$i]['supercede_unit_id'] = $eachModel->supercede->unit->id;
            $data[$i]['serialno'] = $eachModel->have_serial_no;
            $total_allocated_product = AllocatedMaterial::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $eachModel->id . '"'))->quantity;
            $total_available_product = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'stock_id="' . $eachModel->id . '"'))->quantity;
            $data[$i]['total_qty'] = (float) $total_available_product;
            $data[$i]['allocated_qty'] = (float) $total_allocated_product;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionGetWarehousedata()
    {

        $product_id = $_POST['from_product_id'];
        $from_qty = $_POST['from_qty'];
        $to_qty = $_POST['to_qty'];
        $stock_details = array(new MaterialReceiptStockDetails);

        if ((int) $product_id > 0) {
            $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id = ' . $product_id . ' AND quantity > 0'));
        }

        $table = '';
        if ($stock_details[0]->id > 0) {

            $flag = 0;
            $flag1 = 0;
            foreach ($stock_details as $length => $each) {

                //$qty  = "";
                if ($each->quantity <= $from_qty and $flag == 0) {
                    $qty = $each->quantity;
                    $from_qty = $from_qty - $each->quantity;
                } else if ($each->quantity >= $from_qty and $flag == 0) {
                    $qty = $from_qty;
                    $from_qty = 0;
                } else {
                    $from_qty = 0;
                    $flag++;
                }
                if ($qty == '0') {
                    $qty = "";
                }

                if ($each->quantity <= $to_qty and $flag1 == 0) {
                    $t_qty = $each->quantity;
                    $to_qty = $to_qty - $each->quantity;
                } else if ($each->quantity >= $to_qty and $flag1 == 0) {
                    $t_qty = $to_qty;
                    $to_qty = 0;
                } else {
                    $to_qty = 0;
                    $flag1++;
                }
                if ($t_qty == '0') {
                    $t_qty = "";
                }

                $table .= '<tr>';
                $table .= '<td class="bg-success">' . $each->warehousename->warehouse_name . CHtml::hiddenfield('Data[' . $length . '][material_receipt_id]', $each->id) . '</td>';
                $table .= '<td class="bg-success">' . $each->rack->name . '</td>';
                $table .= '<td class="bg-success">' . $each->bin->name . '</td>';
                $table .= '<td class="bg-success">' . $each->serial_no . '</td>';
                $table .= '<td class="bg-success" style="width: 70px;">' . CHtml::textfield('Data[' . $length . '][qty_available]', $each->quantity, array('class' => 'form-control go text-right', 'readonly' => 'readonly')) . '</td>';
                $table .= '<td class="bg-success" style="width: 70px;">' . CHtml::textfield('Data[' . $length . '][picked_qty]', $qty, array('class' => 'form-control go text-right', 'onkeyup' => 'verifyFrmQty(this.id,this.value);')) . '</td>';
                $table .= '<td class="bg-danger">' . CHtml::dropDownList('Data[' . $length . '][new_warehouse]', '', MasInventoryWarehouse::getWarehouse(), array('class' => 'form-control')) . '</td.>';
                $table .= '<td class="bg-danger">' . CHtml::dropDownList('Data[' . $length . '][new_rack]', '', MasInvRack::getRacks(), array('class' => 'form-control go', 'empty' => '-select-')) . '</td.>';
                $table .= '<td class="bg-danger">' . CHtml::dropDownList('Data[' . $length . '][new_bin]', '', MasInvBin::getBins(), array('class' => 'form-control go', 'empty' => '-select-')) . CHtml::hiddenfield('Data[' . $length . '][to_warehouse]', $to_warehouse) . '</td.>';
                $table .= '<td class="bg-danger" style="width: 70px;">' . CHtml::textfield('Data[' . $length . '][new_picked_qty]', $t_qty, array('class' => 'form-control go text-right', 'onkeyup' => 'verifyQty(this.id,this.value);')) . CHtml::hiddenfield('Data[' . $length . '][newserialno]', $each->serial_no) . '</td>';
                $table .= '</tr>';
                $length++;
            }

        } else {
            if ($length == 0)
                $table .= '<tr class="no-data-tr"><td colspan="7" class="text-center"> No Data </td></tr>';
        }

        echo $table;
    }

    public function actionSavemtomtransfer()
    {
        if (isset($_POST['MtomTransfer'])) {
            $model = new MtomTransfer;
            if ((int) $_POST['MtomTransfer']['id'] > 0) {
                $model = $model->updateByPk($_POST['MtomTransfer']['id']);
            }
            $model->attributes = $_POST['MtomTransfer'];
            $model->transfer_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['MtomTransfer']['transfer_date'])));
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('y-m-d H:i:s');
            $model->note = $_POST['MtomTransfer']['note'];
            $valid = $model->validate();
            if ($valid) {
                $model->save();

                /**
                 * Cost Price updation - Original Code
                 * Author Jo~ on 5-2-2018
                 * 
                 * Calculation the quantity factor by  ToQty/FromQty
                 */
                ($_POST['MtomTransfer']['from_qty'] > 0) ? $quantity_factor = $_POST['MtomTransfer']['to_qty'] / $_POST['MtomTransfer']['from_qty'] : $quantity_factor = 0;

                //Cost Rate of From Product
                $from_product_cost_rate = $model->fromproduct->rate;
                //New Rate (from_product_cost_rate/quantity_factor)
                ($quantity_factor > 0) ? $rate = $from_product_cost_rate / $quantity_factor : $rate = 0;
                //cost rate of To product
                $to_product_cost_rate = $model->toproduct->rate;
                //Total Quantity of To product
                ($_POST['MtomTransfer']['to_product'] > 0) ? $old_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  crm_product_location WHERE stock_id=' . $_POST['MtomTransfer']['to_product'])->queryScalar() : $old_qty = 0;
                //Old Total Value
                $old_net_amount = $to_product_cost_rate * $old_qty;
                //Current total
                $current_total = $_POST['MtomTransfer']['to_qty'] * $rate;
                //Total with current total
                $total_amount = $old_net_amount + $current_total;
                //New Cost rate
                $total_quantity = $_POST['MtomTransfer']['to_qty'] + $old_qty;
                $new_rate = $total_amount / $total_quantity;
                Store::model()->updateByPk($_POST['MtomTransfer']['to_product'], array('rate' => $new_rate));
                /** End */

                if (is_array($_POST['Data'])) {
                    foreach ($_POST['Data'] as $each) {
                        if ($each['material_receipt_id'] > 0 && $each['picked_qty'] > 0) {

                            $materialStock = MaterialReceiptStockDetails::model()->findBypk($each['material_receipt_id']);

                            $momItems = new MtomTransferDetails;
                            $momItems->mtom_table_id = $model->id;
                            $momItems->from_material_receipt_stock_id = $each['material_receipt_id'];
                            $momItems->from_product_id = $_POST['MtomTransfer']['from_product'];
                            $momItems->previous_qty = $materialStock->quantity;
                            $momItems->picked_qty = $each['picked_qty'];
                            $momItems->to_product_id = $_POST['MtomTransfer']['to_product'];
                            $momItems->new_warehouse_id = $each['new_warehouse'];
                            $momItems->new_rack_id = $each['new_rack'];
                            $momItems->new_bin_id = $each['new_bin'];
                            $momItems->new_qty = $each['new_picked_qty'];
                            $momItems->save(false);

                            $materialStock->quantity -= $each['picked_qty'];
                            $materialStock->save(false);


                            /**Updating Product Location */
                            $con = 'quantity > 0 AND stock_id=' . $_POST['MtomTransfer']['from_product'];
                            if ($materialStock->warehouse_id > 0)
                                $con .= ' AND warehouse_id=' . $materialStock->warehouse_id;
                            if ($materialStock->rack_id > 0)
                                $con .= ' AND rack=' . $materialStock->rack_id;
                            if ($materialStock->bin_id > 0)
                                $con .= ' AND bin=' . $materialStock->bin_id;
                            $StockLedger = StockLedger::model()->find(array('condition' => $con));
                            if ($StockLedger->id > 0) {
                                $new_in_qty = $StockLedger->quantity - $each['picked_qty'];
                                StockLedger::model()->updateByPk($StockLedger->id, array('quantity' => $new_in_qty));
                            }
                        }

                        if ($each['new_picked_qty'] > 0) {

                            $newmaterialStock = new MaterialReceiptStockDetails;
                            $newmaterialStock->material_receipt_id = $model->id;
                            $newmaterialStock->product_id = $_POST['MtomTransfer']['to_product'];
                            $newmaterialStock->material_receipt_date = date('Y-m-d');
                            $newmaterialStock->stock_affect_date = date('Y-m-d');
                            $newmaterialStock->warehouse_id = $each['new_warehouse'];
                            $newmaterialStock->rack_id = $each['new_rack'];
                            $newmaterialStock->bin_id = $each['new_bin'];
                            $newmaterialStock->transaction_type = "Material to Material Transfer";
                            $newmaterialStock->serial_no = $each['newserialno'];
                            $newmaterialStock->tot_quantity = $each['new_picked_qty'];
                            $newmaterialStock->qc_qty = $each['new_picked_qty'];
                            $newmaterialStock->quantity = $each['new_picked_qty'];
                            $newmaterialStock->bill_entry = $model->id;
                            $newmaterialStock->save(false);


                            /**Updating Product Location */
                            $con = 'stock_id=' . $_POST['MtomTransfer']['to_product'];
                            if ($each['new_warehouse'] > 0)
                                $con .= ' AND warehouse_id=' . $each['new_warehouse'];
                            if ($each['new_rack'] > 0)
                                $con .= ' AND rack=' . $each['new_rack'];
                            if ($each['new_bin'] > 0)
                                $con .= ' AND bin=' . $each['new_bin'];
                            $StockLedger = StockLedger::model()->find(array('condition' => $con));
                            if ($StockLedger->id > 0) {
                                $new_in_qty = $StockLedger->quantity + $each['new_picked_qty'];
                                StockLedger::model()->updateByPk($StockLedger->id, array('quantity' => $new_in_qty));
                            } else {
                                $newloc = new StockLedger;
                                $newloc->stock_id = $_POST['MtomTransfer']['to_product'];
                                $newloc->warehouse_id = $each['new_warehouse'];
                                $newloc->rack = $each['new_rack'];
                                $newloc->bin = $each['new_bin'];
                                $newloc->quantity = $each['new_picked_qty'];
                                $newloc->save(false);
                            }
                        }
                    }
                }
                $this->dailyclosingstock();
                $jsonData['id'] = $model->id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);

            } else {
                $error = json_decode(CActiveForm::validate($model, '', false), true);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    /**End */
    /**Arul 30-1-2018 */
    public function actionPrintMtomTransferPDF()
    {

        $model = new MtomTransfer;
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.inv_transfer_mtom', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output("DirectTransferReceipt.pdf", 'I');
    }
    /**End */


    /********************   arul 13/2/2018 *******************************/
    public function actioncreateRakeBin()
    {
        $model = new MaterialReceiptStockDetails();
        $model_items = array(new MaterialReceiptStockDetails());
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_items = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'id = ' . $id . ''));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('rack_bin_form', array('model' => $model, 'model_items' => $model_items), false, false);
    }
    public function addMR($product_id, $warehouse, $rack, $bin, $quantity, $modelRackBinid)
    {

        $model_MR = new MaterialReceiptStockDetails();
        $model_MR->material_receipt_id = "";
        $model_MR->material_receipt_item_id = "";
        $model_MR->product_id = $product_id;
        $model_MR->material_receipt_date = date('Y-m-d');
        $model_MR->stock_affect_date = date('Y-m-d');
        $model_MR->bill_entry = "";
        $model_MR->bill_exit = "";
        $model_MR->warehouse_id = $warehouse;
        $model_MR->rack_id = $rack;
        $model_MR->bin_id = $bin;
        $model_MR->batch_no = "";
        $model_MR->serial_no = "";
        $model_MR->manufacture_date = "";
        $model_MR->expiry_date = "";
        $model_MR->quantity = $quantity;
        $model_MR->qc_qty = $quantity;
        $model_MR->tot_quantity = $quantity;
        $model_MR->transaction_type = "Change Rack Bin";
        $model_MR->created_by = Yii::app()->user->id;
        $model_MR->created_date = date('Y-m-d h:i:s');
        $model_MR->save(false);

        /*****************   details *************************/
        $model_chaRacBin = new ProLocChangeRackBin();

        $model_chaRacBin->change_rackbin_id = $modelRackBinid;
        $model_chaRacBin->mr_id = $model_MR->id;
        $model_chaRacBin->bin = $rack;
        $model_chaRacBin->rack = $bin;
        $model_chaRacBin->old_rack_id = "";
        $model_chaRacBin->old_bin_id = "";
        $model_chaRacBin->warehouse_id = $warehouse;
        $model_chaRacBin->product_id = $product_id;
        $model_chaRacBin->quantity = $quantity;
        $model_chaRacBin->old_qty = "";
        $model_chaRacBin->action = "A";  // A -> add new row
        $model_chaRacBin->save(false);
    }


    public function actionSaveChangeRackBinSerialno()
    {

        $product_id = $_POST['product_id'];
        $warehouse = $_POST['warehouse_id'];
        $bin_id = $_POST['bin_id'];
        $rack_id = $_POST['rack_id'];
        $totalQty = $_POST['totalQty'];
        if (is_array($_POST['StockLedger'])) {
            $modelRackBin = new ChangeRackBin();
            $modelRackBin->warehouse_id = $warehouse;
            $modelRackBin->partno = $product_id;
            $modelRackBin->rack = $rack_id;
            $modelRackBin->total_qty = $_POST['rack_total_qty'];
            $modelRackBin->bin = $bin_id;
            $modelRackBin->created_by = Yii::app()->user->id;
            $modelRackBin->created_datetime = date('Y-m-d h:i:s');
            $modelRackBin->save(false);

            foreach ($_POST['StockLedger'] as $i => $item) {

                $modelItem = StockLedger::model()->findByPk($item['id']);
                $modelItem->rack_id = $item['rack_id'];
                $modelItem->bin_id = $item['bin_id'];
                $modelItem->save(false);

                /**************  history*****************/
                $model_chaRacBin = new ProLocChangeRackBin();
                $model_chaRacBin->change_rackbin_id = $modelRackBin->id;
                $model_chaRacBin->product_location_id = $item['id'];
                $model_chaRacBin->rack = $item['rack_id'];
                $model_chaRacBin->bin = $item['bin_id'];
                $model_chaRacBin->quantity = 1;
                $model_chaRacBin->product_id = $product_id;
                $model_chaRacBin->warehouse_id = $warehouse;
                $model_chaRacBin->action = "U";
                $model_chaRacBin->save(false);
                /**************  End history *****************/
            }
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'fail';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionGetRackBinProduct()
    {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'part_number LIKE "%' . $searchTerm . '%" AND isActive = "Y"';
        $model = new Store();
        $model = $model->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->part_number;
            $data[$i]['label'] = $eachModel->part_number;
            $data[$i]['product_id'] = $eachModel->id;
            $data[$i]['serialno'] = $eachModel->have_serial_no;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    /*public function actionFetchMaterialDetails(){   
        $product_id    = $_POST['product_id'];
        $warehouse_id  = $_POST['warehouse_id'];
        $rack_id       = $_POST['rack_id'];
        $bin_id        = $_POST['bin_id'];

        $condition  = 't.stock_id ="'.$product_id.'" AND t.warehouse_id ="'.$warehouse_id.'"';
        if($rack_id != ''){
            $condition .= ' AND t.rack="' . $rack_id.'"';
        }
        if($bin_id != ''){
            $condition .= ' AND t.bin="' . $bin_id.'"';
        }
        $condition .= ' AND quantity > 0';

        $stock_details = array(new StockLedger);

        if((int) $product_id > 0){
            $product = Store::model()->findBypk($product_id);           
            $stock_details = StockLedger::model()->findAll(array('condition' => $condition,'order'=>'warehouse_id ASC'));
        }


         $data['table'] = '';
         $data['table'] .= '';
         $quantity   = 0;  

         $data['table'] .= '<table class="table table-hover table-bordered personal-task" id="items_table" style="margin-top : 10px;"><tr>

                                <th>Item</th>
                                <th>Ware House</th>
                                <th>Rack</th>
                                <th style="width: 10%;">Bin</th>                
                                <th style="width: 8%;">Quantity </th>
                                <th style="width: 8%;">
                                    <a class="btn btn-sm btn-theme" href="javascript:void(0);" onclick="addTableRow1($(\'#items_table\'));"><i class="fa fa-plus"></i></a>
                                </th>
                              '; 

        if($stock_details[0]->id > 0){

                $length  = 0;
            foreach($stock_details as $each){

                    $data['table'] .= '<tr class="'.$class.' TR-'.$length.'">
                                            <td>'.$product->part_number.CHtml::hiddenfield('Data['.$length.'][material_receipt_id]',$each->id).CHtml::hiddenfield('Data['.$length.'][id]',$each->id).'</td>                    
                                            <td>'.$each->warehouse->warehouse_name.'</td>
                                            <td>'.CHtml::dropDownList('Data['.$length.'][rack]',$each->rack,MasInvRack::getRacks(),array('class' => 'form-control','empty'=>'Select')).'</td>
                                            <td>'.CHtml::dropDownList('Data['.$length.'][bin]',$each->bin,MasInvBin::getBins(),array('class' => 'form-control','empty'=>'Select')).'</td>
                                            <td>'.CHtml::textfield('Data['.$length.'][quantity]',$each->quantity,array('class' => 'form-control','onkeyup' => 'calculateValue($("#items_table"));','onkeypress' => 'return isPositiveNumber(event)')).CHtml::hiddenfield('Data['.$length.'][old_rackid]',$each->rack).CHtml::hiddenfield('Data['.$length.'][old_binid]',$each->bin).CHtml::hiddenfield('Data['.$length.'][old_quantity]',$each->quantity).'</td>
                                            <td>'.CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-sm btn-danger','onclick' => 'removeTableRow($(\'#items_table\'),this);calculateValue($("#items_table"));', 'title' => 'Remove this item')).'</td>
                                        </tr>';

                    $length++;
                    $quantity+=$each->quantity;
                }

            }else{ 
                if($length == 0)
                    $data['table'] .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
            }
            $data['table'] .= '</table>';

            $data['total_qty']  = $quantity;


            echo CJSON::encode($data);
    }
    public function actioncreateRakeBin(){
            $model = new MaterialReceiptStockDetails();
            $model_items = array(new MaterialReceiptStockDetails());
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id); 
                $model_items = MaterialReceiptStockDetails::model()->findAll(array('condition'=>'id = '.$id.''));               
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('rack_bin_form', array('model' => $model,'model_items'=>$model_items), false, false);
    }



    public function actionSaveChangeRackBin(){

            $product_id  = $_POST['product_id'];
            $warehouse   = $_POST['warehouse_id'];
            $old_bin     = $_POST['old_bin'];
            $old_rack    = $_POST['old_rack'];
            $totalQty    = $_POST['totalQty'];

            $model_pro_location = new StockLedger();
            $model_MR = new MaterialReceiptStockDetails();
            $model_pro_location = new StockLedger();

            if(is_array($_POST['Data'])){
                foreach($_POST['Data'] as $item){
                    if($item['id']>0) {
                        $model_pro_location->deleteByPk($item['id']);
                    }
                }
            }

            if(is_array($_POST['Data'])){

                        foreach($_POST['Data'] as $items){                            
                            if ($items['quantity']>0) {

                                $condition = "stock_id='". $product_id."'";
                                if($warehouse > 0)
                                    $condition .= " AND warehouse_id='".$warehouse."'";
                                if($items['rack'] > 0)
                                    $condition .= " AND rack='".$items['rack']."'";
                                if($items['bin'] > 0)
                                    $condition .= " AND bin='".$items['bin']."'";

                                $StockLedger = StockLedger::model()->find(array('condition' => $condition));
                                if($StockLedger->id > 0){

                                    $loc = StockLedger::model()->findByPk($StockLedger->id);
                                    $loc->quantity = $loc->quantity + $items['quantity'];
                                    $loc->save(false);
                                }
                                else{
                                    $model = new StockLedger();
                                    $model->stock_id  = $product_id;
                                    $model->bin       = $items['bin'];
                                    $model->rack      = $items['rack'];
                                    $model->warehouse_id  = $warehouse;
                                    $model->quantity  = $items['quantity'];
                                    $model->created_by  = Yii::app()->user->id;
                                    $model->created_date_time  = date('Y-m-d h:i:s'); 
                                    $model->save(false);
                                }



                                    $old_rack   = $items['old_rackid'];
                                    $old_bin    = $items['old_binid'];
                                    $old_qty    = $items['old_quantity'];

                                    $old_con = "quantity > 0 AND product_id='". $product_id."'";
                                    if($warehouse > 0)
                                        $old_con .= " AND warehouse_id='".$warehouse."'";
                                    if($old_rack >= 0)
                                        $old_con .= " AND rack_id='".$old_rack."'";
                                    if($old_bin >= 0)
                                        $old_con .= " AND bin_id='".$old_bin."'";

                                    $model_MR_old = MaterialReceiptStockDetails::model()->findAll(array('condition'=>$old_con,'order' => 'quantity ASC'));

                                    if(!empty($model_MR_old)){         

                                        $reduce_qty  = $old_qty;

                                        foreach($model_MR_old as $mr_item){

                                            if($reduce_qty >0){

                                                $update_model_MR            =  MaterialReceiptStockDetails::model()->findByPk($mr_item['id']);
                                                if($mr_item['quantity'] <= $reduce_qty){

                                                    $update_model_MR->quantity  = "0";
                                                    $update_model_MR->save(false);
                                                    $reduce_qty  = $reduce_qty-$mr_item['quantity'];
                                                }
                                                else{

                                                    $a  = $mr_item['quantity']-$reduce_qty;
                                                    $update_model_MR->quantity  = $a;
                                                    $update_model_MR->save(false);
                                                    $reduce_qty  = 0;

                                                }
                                            }

                                        }
                                    }


                                    $total_qty  = $items['quantity'];
                                    $this->addMR($product_id,$warehouse,$items['rack'],$items['bin'],$total_qty);    

                            }
                    }
           }
           $jsonData['status'] = 'success';
            $jsonData['frm'] = $_POST['issues_form'];
            $jsonData['id'] = $model->id;
            $jsonData['data'] = $data;
            echo CJSON::encode($jsonData);


        }
        public function addMR($product_id,$warehouse,$rack,$bin,$quantity){

            $model_MR = new MaterialReceiptStockDetails();
            $model_MR->material_receipt_id  = "";
            $model_MR->material_receipt_item_id  = "";
            $model_MR->product_id  = $product_id;
            $model_MR->material_receipt_date  = date('Y-m-d');
            $model_MR->stock_affect_date  = date('Y-m-d');
            $model_MR->bill_entry  = "";
            $model_MR->bill_exit  = "";
            $model_MR->warehouse_id  = $warehouse;
            $model_MR->rack_id  = $rack;
            $model_MR->bin_id  = $bin;
            $model_MR->batch_no  = "";
            $model_MR->serial_no  = "";
            $model_MR->manufacture_date  = "";
            $model_MR->expiry_date  = "";
            $model_MR->quantity  = $quantity;
            $model_MR->qc_qty  = $quantity;
            $model_MR->tot_quantity  = $quantity;
            $model_MR->transaction_type  = "Change Rack Bin";
            $model_MR->created_by  = Yii::app()->user->id;
            $model_MR->created_date  = date('Y-m-d h:i:s');
            $model_MR->save(false);
    }*/
    public function actionChangerackbin()
    {
        $this->render('change_rack_bin_form');
    }
    public function actionFetchMaterialDetails()
    {   //warehousename
        $product_id = (int) $_POST['product_id'];
        $warehouse_id = $_POST['warehouse_id'];
        $rack_id = $_POST['rack_id'];
        $bin_id = $_POST['bin_id'];
        $serialno = $_POST['serialno'];
        $condition = 't.product_id ="' . $product_id . '" AND t.warehouse_id ="' . $warehouse_id . '" AND quantity>0';
        if ($rack_id != '') {
            $condition .= ' AND t.rack_id="' . $rack_id . '"';
        }
        if ($bin_id != '') {
            $condition .= ' AND t.bin_id="' . $bin_id . '"';
        }
        $model_stock_details = StockLedger::model()->findAll(array('condition' => $condition));
        $model_new_location = new StockLedger();
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        if ($serialno == 'Y') {
            $this->render('change_rack_bin_with_serialno', array('model_new_location' => $model_new_location, 'model_stock_details' => $model_stock_details, 'warehouse_id' => $warehouse_id, 'product_id' => $product_id), false, true);
        } else {
            $this->render('change_rack_bin_item_detail', array('model_new_location' => $model_new_location, 'model_stock_details' => $model_stock_details, 'warehouse_id' => $warehouse_id, 'product_id' => $product_id), false, true);
        }
    }
    public function actionGetbin()
    {
        $row = $_POST['row_field'];
        $rack_id = $_POST['rack_id'];
        $drop = array();
        $model = new StockLedger;
        $drop['dropdown'] = CHtml::activedropdownlist($model, "[" . $row . "]bin_id", MasInvBin::getBins_rackwise($rack_id), array('class' => 'form-control', 'onchange' => 'checkrackbinexist(this.id)', 'empty' => 'Select'));
        echo CJSON::encode($drop);
    }
    public function actionSaveChangeRackBin()
    {
        //Code to save 
        if (isset($_POST['StockLedger'])) {
            date_default_timezone_set("Asia/Dubai");
            $product_id = 0;
            $warehouse_id = 0;
            $rack_id = 0;
            foreach ($_POST['StockLedger'] as $i => $items) {
                if ($items['old_location'] > 0 && $items['quantity'] > 0) {

                    $warehouse_id = $items['warehouse_id'];
                    $rack_id = $items['rack_id'];
                    //EXISTING STOCK LEDGER
                    $modelExistingStockLedger = StockLedger::model()->findByPk($items['old_location']);
                    //PRODUCT DETAILS
                    $arr_product_details = Store::model()->findbyPk($items['product_id']);
                    $model_new_location = new StockLedger();
                    $model_new_location->file_id = 0;
                    $model_new_location->header_id = 0;
                    $model_new_location->header_item_id = 0;
                    $model_new_location->customer_vendor_id = 0;
                    $model_new_location->customer_vendor_name = "";
                    $model_new_location->product_id = $items['product_id'];
                    $model_new_location->product_name = $modelExistingStockLedger->product_name;
                    $model_new_location->product_description = $modelExistingStockLedger->product_description;
                    $model_new_location->brand_id = $modelExistingStockLedger->brand_id;
                    $model_new_location->brand_name = $modelExistingStockLedger->brand_name;
                    $model_new_location->warehouse_id = $items['warehouse_id'];
                    $model_new_location->warehouse_name = $items['warehouse_name'];
                    $model_new_location->rack_id = $items['rack_id'];
                    $model_new_location->rack_name = MasInvRack::getRackName($items['rack_id']);
                    $model_new_location->bin_id = $items['bin_id'];
                    $model_new_location->bin_name = MasInvBin::getBinName($items['bin_id']);
                    $model_new_location->unit_id = $modelExistingStockLedger->unit_id;
                    $model_new_location->unit_name = $modelExistingStockLedger->unit_name;
                    $model_new_location->unit_factor = $modelExistingStockLedger->unit_factor;
                    $model_new_location->quantity = $items['quantity'];
                    $model_new_location->available_status = 'A';
                    $model_new_location->batch_no = $modelExistingStockLedger->batch_no;
                    $model_new_location->serial_no = $modelExistingStockLedger->serial_no;
                    $model_new_location->manufacturing_date = $modelExistingStockLedger->manufacturing_date;
                    $model_new_location->expiry_date = $modelExistingStockLedger->expiry_date;
                    $model_new_location->cost_price = $arr_product_details->rate;
                    $model_new_location->sales_price = $item['sales_price'];
                    $model_new_location->transaction_date = date("Y-m-d");
                    $model_new_location->transaction_from = "Change Rack Bin";
                    $model_new_location->transaction_type = "IN";
                    $model_new_location->master_stock_ledger_id = $modelExistingStockLedger->id;
                    $model_new_location->created_by = Yii::app()->user->id;
                    $model_new_location->created_date = date("Y-m-d H:i:s");
                    $model_new_location->save(false);

                    //Adding to Rack Bin Change History
                    $model_rackbin_history = new StockLedgerChangeRackbin();
                    $model_rackbin_history->old_pdt_location_id = $items['old_location'];
                    $model_rackbin_history->product_location_id = $model_new_location->id;
                    $model_rackbin_history->product_id = $items['product_id'];
                    $model_rackbin_history->quantity = $items['quantity'];
                    $model_rackbin_history->created_by = Yii::app()->user->id;
                    $model_rackbin_history->created_date_time = date('Y-m-d h:i:s');
                    $model_rackbin_history->save();

                    //Updating Old Product Location
                    if ($modelExistingStockLedger->quantity > 0) {
                        $total_quantity = $modelExistingStockLedger->quantity;
                        $transfer_quantity = $items['quantity'];
                        $balance_quantity = $total_quantity - $transfer_quantity;
                        StockLedger::model()->updateByPK($items['old_location'], array('quantity' => $balance_quantity));
                    }
                }
            }
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'CHANGE_RACK_BIN',
                Yii::app()->user->id,
                'CREATED',
                " with PRDT ID: - {$product_id} - and WareHouse ID: - {$warehouse_id} to Rack ID:- {$rack_id}"
            );
            // end audit log
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
            Yii::app()->end();


        }

    }
    public function actionGetIndirectCheckinList()
    {

        $model = new InventoryIndirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            //1 =>'warehouseTo.warehouse_name',
            //2 =>'warehouseFrom.warehouse_name',                                     
            //3 =>'direct_transfer_description',
            //4 =>'reference', 
            //5 =>'transfer_date', 
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 AND is_complete="P" AND status="C"';
        $ModelUser = User::model()->findByPk((int) Yii::app()->user->id);
        $condition .= ' AND (from_warehouse_id IN (' . $ModelUser->available_warehouses . ') OR to_warehouse_id IN (' . $ModelUser->available_warehouses . '))';

        // echo $condition;
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = '1=1 AND is_complete="P"';
            $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%' OR t.indirect_transfer_description LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('warehouseTo', 'warehouseFrom')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        // $model=Yii::app()->db->createCommand("select * from erp_inventory_indirect_transfer where $condition")->queryAll();
        $count = count($model);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row['transfer_date']) && ($row['transfer_date'] != ""))
                $req_date = date("d/m/Y", strtotime($row['transfer_date']));//,$row['warehouseTo']['warehouse_name']
            $div = '';
            // if(isset(Yii::app()->user->havePermissionOn['indirect_transfer_view']) ||  Yii::app()->user->authorised_user == 1)
            // {
            // $div ='<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'iwarehouse/indirectcreate&type=view&id='.$row['id'].'\',\'Indirect Transfer\',\'xl\')"><i class="fa fa-eye"></i></button>';
            // }
            if (isset(Yii::app()->user->havePermissionOn['indirect_transfer_add']) || Yii::app()->user->authorised_user == 1) {
                $div .= ' <button class="btn btn-primary btn-xs" title="Convert" onclick="loadPopupModal(\'checkin/Create&status=IDTCK&id=' . $row['id'] . '\',\'Hire External Transfer\',\'xl\')"><i class="fa fa-retweet"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_indirecttransfer_pdf"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintInDirectTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            if ($row['status'] == 'P') {
                $status = 'Packaging';
            }
            if ($row['status'] == 'TO') {
                $status = 'Transfer Out';
            }
            if ($row['status'] == 'C') {
                $status = 'Check In';
            }
            if ($row['status'] == 'TI') {
                $status = 'Trasnfer IN';
            }
            $rowData[] = array($row['id'], $req_date, $row['warehouseFrom']['warehouse_name'], $row['warehouseInter']['warehouse_name'], $row['reference'], $row['indirect_transfer_description'], $status, $row['status']);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionGetIndirecttransactionlist()
    {

        $model = new InventoryIndirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            //1 =>'warehouseTo.warehouse_name',
            //2 =>'warehouseFrom.warehouse_name',                                     
            //3 =>'direct_transfer_description',
            //4 =>'reference', 
            //5 =>'transfer_date', 
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $ModelUser = User::model()->findByPk((int) Yii::app()->user->id);
        $condition = '1=1 AND is_complete="Y" OR status="TO"';
        $condition .= ' AND from_warehouse_id IN(' . $ModelUser->available_warehouses . ')';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = '1=1 AND is_complete="Y" OR status="TO"';
            $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%' OR t.indirect_transfer_description LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('warehouseTo', 'warehouseFrom')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        // $model=Yii::app()->db->createCommand("select * from erp_inventory_indirect_transfer where $condition")->queryAll();
        $count = count($model);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row['transfer_date']) && ($row['transfer_date'] != ""))
                $req_date = date("d/m/Y", strtotime($row['transfer_date']));//,$row['warehouseTo']['warehouse_name']
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_in_print"]) || ((int) Yii::app()->user->havePermissionOn["direct_transfer_out_print"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintInDirectTransferPDF&frm=out&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            $rowData[] = array($row['id'], $req_date, $row['warehouseFrom']['warehouse_name'], $row['warehouseTo']['warehouse_name'], $row['reference'], $row['indirect_transfer_description'], '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionHiringindirectindex()
    {
        $this->render('hiring_indirect_index');
    }
    public function actionGetHireIndirectList()
    {

        $model = new HireInventoryIndirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            //1 =>'warehouseTo.warehouse_name',
            //2 =>'warehouseFrom.warehouse_name',                                     
            //3 =>'direct_transfer_description',
            //4 =>'reference', 
            //5 =>'transfer_date', 
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 AND is_complete="N"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = '1=1 AND is_complete="N"';
            $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%' OR t.indirect_transfer_description LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('warehouseTo', 'warehouseFrom')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row->transfer_date) && ($row->transfer_date != ""))
                $req_date = date("d/m/Y", strtotime($row->transfer_date));//,$row['warehouseTo']['warehouse_name']
            $div = '';
            if (isset(Yii::app()->user->havePermissionOn['hiring_indirect_transfer_view']) || Yii::app()->user->authorised_user == 1) {
                $div = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'iwarehouse/hireindirectcreate&type=view&id=' . $row['id'] . '\',\'Hire External Transfer\',\'xl\')"><i class="fa fa-eye"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["hiring_inv_indirecttransfer_pdf"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintHireInDirectTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';

            }
            if (isset(Yii::app()->user->havePermissionOn['hiring_indirect_transfer_add']) || Yii::app()->user->authorised_user == 1 && $row->is_complete == 'N') {
                $div .= ' <button class="btn btn-primary btn-xs" title="Convert" onclick="loadPopupModal(\'packaging/create&status=HIDTOUT&id=' . $row['id'] . '\',\'Hiring External Transfer\',\'xl\')"><i class="fa fa-retweet"></i></button>';

            }
            $rowData[] = array($row['id'], $row['warehouseFrom']['warehouse_name'], $row['intermediate_location'], $row['indirect_transfer_description'], $row['reference'], $req_date, '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionGetHireIndirectCheckinList()
    {

        $model = new HireInventoryIndirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            //1 =>'warehouseTo.warehouse_name',
            //2 =>'warehouseFrom.warehouse_name',                                     
            //3 =>'direct_transfer_description',
            //4 =>'reference', 
            //5 =>'transfer_date', 
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 AND is_complete="P"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = '1=1 AND is_complete="P"';
            $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%' OR t.indirect_transfer_description LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('warehouseTo', 'warehouseFrom')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        // $model=Yii::app()->db->createCommand("select * from erp_inventory_indirect_transfer where $condition")->queryAll();
        $count = count($model);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row['transfer_date']) && ($row['transfer_date'] != ""))
                $req_date = date("d/m/Y", strtotime($row['transfer_date']));//,$row['warehouseTo']['warehouse_name']
            $div = '';
            // if(isset(Yii::app()->user->havePermissionOn['indirect_transfer_view']) ||  Yii::app()->user->authorised_user == 1)
            // {
            // $div ='<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'iwarehouse/indirectcreate&type=view&id='.$row['id'].'\',\'Indirect Transfer\',\'xl\')"><i class="fa fa-eye"></i></button>';
            // }
            if (isset(Yii::app()->user->havePermissionOn['hiring_indirect_transfer_add']) || Yii::app()->user->authorised_user == 1) {
                $div .= ' <button class="btn btn-primary btn-xs" title="Convert" onclick="loadPopupModal(\'checkin/Create&status=HIDTCK&id=' . $row['id'] . '\',\'Hire External Transfer\',\'xl\')"><i class="fa fa-retweet"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["hiring_inv_indirecttransfer_pdf"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintHireInDirectTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            $rowData[] = array($row['id'], $row['warehouseFrom']['warehouse_name'], $row['intermediate_location'], $row['indirect_transfer_description'], $row['reference'], $req_date, '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionGetHireIndirecttransactionlist()
    {

        $model = new HireInventoryIndirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            //1 =>'warehouseTo.warehouse_name',
            //2 =>'warehouseFrom.warehouse_name',                                     
            //3 =>'direct_transfer_description',
            //4 =>'reference', 
            //5 =>'transfer_date', 
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 AND is_complete="Y"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = '1=1 AND is_complete="Y"';
            $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%' OR t.indirect_transfer_description LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('warehouseTo', 'warehouseFrom')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        // $model=Yii::app()->db->createCommand("select * from erp_inventory_indirect_transfer where $condition")->queryAll();
        $count = count($model);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row['transfer_date']) && ($row['transfer_date'] != ""))
                $req_date = date("d/m/Y", strtotime($row['transfer_date']));//,$row['warehouseTo']['warehouse_name']
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["hiring_inv_indirecttransfer_pdf"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintHireInDirectTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            $rowData[] = array($row['id'], $row['warehouseFrom']['warehouse_name'], $row['intermediate_location'], $row['indirect_transfer_description'], $row['reference'], $req_date, '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionHireInDirectCreate()
    {
        $model = new HireInventoryIndirectTransfer();
        $model_items = array(new HireInventoryIndirectTransferItem());
        $id = (int) Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        if ($id > 0) {

            $model = $model->findByPk($id);
            $transfer_date = str_replace('/', '-', $model->transfer_date);
            $transfer_date = date('d/m/Y', strtotime($transfer_date));
            $model->transfer_date = $transfer_date;
            $model_items = HireInventoryIndirectTransferItem::model()->findAll(array('condition' => 'indirect_transfer_id="' . $id . '"'));
            if (empty($model_items)) {
                $model_items = array(new HireInventoryIndirectTransferItem());
            }

        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('hire_indirecttransfer_create', array('model' => $model, 'model_items' => $model_items, 'type' => $type));
    }
    public function actionGetHireProducts()
    {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $warehouse_id = 0;
        if (isset($_GET['term']) && $_GET['term'] != "") {
            $warehouse_id = $_GET['frm_warehouse_id'];
        }
        $searchTerm = $_GET['term'];
        $condition = 'isActive = "Y" AND ( inventory_item_type =1 OR inventory_item_type=3) AND (hiring_part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';

        $model = new Store();
        $model = $model->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {

            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->hiring_part_number . ' : ' . $eachModel->description;
            $data[$i]['part_number'] = $eachModel->hiring_part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            //$data[$i]['supercede_id'] = $eachModel->supercede_id;
            //$data[$i]['supercede_name'] = $eachModel->supercede->part_number;
            //$data[$i]['supercede_des'] = $eachModel->supercede->description;
            //$data[$i]['supercede_unit_name'] = $eachModel->supercede->unit->symbol;
            //$data[$i]['supercede_unit_id'] = $eachModel->supercede->unit->id;
            $total_allocated_product = AllocatedMaterial::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $eachModel->id . '"'))->quantity;
            $total_available_product = StockLedgerHiringDetails::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $eachModel->id . '"'))->quantity;
            $available_qty = 0;
            if ($warehouse_id > 0) {
                $available_qty = StockLedgerHiringDetails::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $eachModel->id . '" AND warehouse_id=' . $warehouse_id))->quantity;
            }
            $data[$i]['total_qty'] = (float) $total_available_product;
            $data[$i]['allocated_qty'] = (float) $total_allocated_product;
            $data[$i]['other'] = (float) $available_qty;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actionSaveHireIndirectTransfer()
    {

        $model = new HireInventoryIndirectTransfer();
        $other_errors = array();

        if (isset($_POST['HireInventoryIndirectTransfer'])) {

            if ((int) @$_POST['HireInventoryIndirectTransfer']['id'] > 0) {

                $id = (int) @$_POST['HireInventoryIndirectTransfer']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('y-m-d');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('y-m-d');
            }

            $model->attributes = $_POST['HireInventoryIndirectTransfer'];
            $model->indirect_transfer_description = $_POST['HireInventoryIndirectTransfer']['indirect_transfer_description'];
            $model->intermediate_location = $_POST['HireInventoryIndirectTransfer']['intermediate_location'];
            $model->reference = $_POST['HireInventoryIndirectTransfer']['reference'];
            if ($_POST['HireInventoryIndirectTransfer']['transfer_date'] != '' && $_POST['HireInventoryIndirectTransfer']['transfer_date'] != '0000-00-00') {
                $model->transfer_date = str_replace('/', '-', $_POST['HireInventoryIndirectTransfer']['transfer_date']);
                $model->transfer_date = date("Y-m-d", strtotime($model->transfer_date));
            }
            $valid = $model->validate();
            if (isset($_POST['HireInventoryIndirectTransferItem'])) {

                foreach ($_POST['HireInventoryIndirectTransferItem'] as $i => $items) {

                    if ($items['id'] > 0) {
                        $model_item[$i] = HireInventoryIndirectTransferItem::model()->findByPK($items['id']);

                    } else {
                        $model_item[$i] = new HireInventoryIndirectTransferItem();
                    }

                    $model_item[$i]->item_id = $items['item_id'];
                    $model_item[$i]->item_description = $items['item_description'];
                    $model_item[$i]->item_name = $items['item_name'];
                    $model_item[$i]->transfer_qty = $items['transfer_qty'];
                    $model_item[$i]->unit = $items['unit'];
                    $valid = $model_item[$i]->validate() && $valid;
                    $model_item[$i]->available_qty = 0;
                }

            }

            if ($valid) {
                $model->save();
                foreach ($model_item as $each) {
                    $each->indirect_transfer_id = $model->id;
                    $each->save();
                }

                $jsonData['id'] = $model->id;
                ;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_item[0]->item_id))
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other_errors));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionPrintHireInDirectTransferPDF()
    {
        $model = new HireInventoryIndirectTransfer();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.hiring_inv_transfer_indirect', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionGetBinsWithItems()
    {

        $row_id = $_POST['row_id'];
        $id = (int) $_POST['id'];

        echo CHtml::dropdownlist('Data[' . $row_id . '][to_bin_id]', '', MasInvBin::getBins_rackwise($id), array('class' => 'qty go', 'prompt' => 'select', 'options' => array($defaultProBinId => array('selected' => true))));
    }

    public function actionGetAllProducts()
    {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $warehouse_id = $_GET['from_warehouse_id'];
        $to_warehouse_id = $_GET['to_warehouse_id'];
        $type = $_GET['type'];
        $warehouse_type = MasInventoryWarehouse::getWarehouseCodeById($to_warehouse_id);
        $searchTerm = $_GET['term'];
        if ($warehouse_type == 'RW') {
            $condition = 'isActive = "Y" AND ( inventory_item_type =1 OR inventory_item_type =3 OR inventory_item_type =4 OR inventory_item_type =5) AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        } else {
            $condition = 'isActive = "Y" AND  (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        }
        if ($type == 'issue') {
            $condition .= ' AND inventory_item_type = 3 ';
        }
        $model = new Store();
        $model = $model->findAll(array('condition' => $condition, 'limit' => 50));
        $i = 0;
        foreach ($model as $eachModel) {
            $available_qty = 0;
            if ($warehouse_id > 0) {
                $available_qty = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $eachModel->id . '" AND warehouse_id=' . $warehouse_id))->quantity;
            }
            $data[$i]['rate'] = $eachModel->rate;
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['bar_code'] = $eachModel->bar_code;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $data[$i]['label'] = $eachModel->part_number . ' : ' . $eachModel->description . ' : ' . (float) $available_qty . ' (Avail.Qty)';
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }



    public function actionGetProductOtherDetails()
    {
        $row = $_POST['row_field'];
        $product_id = $_POST['product_id'];
        $warehouse_id = $_POST['from_warehouse_id'];
        $returnData = array();

        //get unit details
        if ($_POST['type'] == 'direct') {
            $modelOrder = new InventoryDirectTransferItem;
        } else if ($_POST['type'] == 'HT') {
            $modelOrder = new InventoryHiringTransferItem;
        } else {
            $modelOrder = new InventoryIndirectTransferItem;
        }

        if ($product_id > 0) {
            $modelOrder->unit = UnitOfMeasurement::getBaseunit($product_id);
            $returnData['unitdrop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit", UnitOfMeasurement::getUnits($product_id), array('class' => 'unit go', 'onchange' => 'getFactor(this.id,this.value)'));
        }
        //end

        //get stock details
        $total_allocated_qty = AllocatedMaterial::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $product_id . '"'))->quantity;
        $total_available_qty = StockLedger::model()->find(array('select' => 'sum(quantity * unit_factor) as quantity', 'condition' => 'product_id="' . $product_id . '"'))->quantity;
        $warehouse_available_qty = 0;
        if ($warehouse_id > 0) {
            $warehouse_available_qty = StockLedger::model()->find(array('select' => 'sum(quantity * unit_factor) as quantity', 'condition' => 'product_id="' . $product_id . '" AND warehouse_id=' . $warehouse_id))->quantity;
        }
        $returnData['total_allocated_qty'] = (float) $total_allocated_qty;
        $returnData['total_available_qty'] = (float) $total_available_qty;
        $returnData['warehouse_available_qty'] = (float) $warehouse_available_qty;
        //end

        echo CJSON::encode($returnData);
    }
    public function actionPrintDirectTransferExcel()
    {

        $model = new InventoryDirectTransfer();
        $id = Yii::app()->request->getParam('id');

        $filename = 'inv_transfer_direct' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.views.front.pdf.inv_transfer_direct_excel', array('model' => $model, 'id' => $id), false, true);
        Yii::app()->end();
        return;

    }


    // -----------added by indhu 21_01_2023--------------
    public function actionDirectindex_sample()
    {
        $this->render('directindex_sample');
    }

    public function actionGetlistsample()
    {

        $model = new InventoryDirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            1 => 'warehouseTo.warehouse_name',
            2 => 'warehouseFrom.warehouse_name',
            3 => 'direct_transfer_description',
            4 => 'reference',
            5 => 'transfer_date',
            6 => 't.id'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        // $condition = 't.status="C"';
        //   --------added-by-indhu-21-01-2023--------------
        $condition = 't.status="C"   AND  t.added_from="ST"  '; //ST = sample transfer
        //   ---------------------------

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and t.id LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%'";
        }
        $count = $model->with('warehouseTo', 'warehouseFrom')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row->transfer_date) && ($row->transfer_date != "")) {
                $req_date = date("d/m/Y", strtotime($row->transfer_date));
            }

            $div = '';
            /*if (isset(Yii::app()->user->havePermissionOn['direct_transfer_view']) || Yii::app()->user->authorised_user == 1) {
                    $div = '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'iwarehouse/directcreate&type=view&id=' . $row['id'] . '\',\'Direct Transfer\',\'xl\')"><i class="fa fa-eye"></i></button>';
                }*/
            //if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inv_directtransfer_pdf"])) {
            $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintSampleTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            $div .= '&nbsp;<button class="btn btn-success  btn-xs" title="Excel" onclick="window.open(\'index.php?r=iwarehouse/PrintsampleTransferExcel&id=' . $row['id'] . '\')"><i class="fa fa-file-excel-o"></i></button> ';
            //}
            $rowData[] = array($row['id'], $row['warehouseFrom']['warehouse_name'], $row['warehouseTo']['warehouse_name'], $row['direct_transfer_description'], $row['reference'], $req_date, '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionDirectCreatesample()
    {
        $model = new InventoryDirectTransfer();
        $model_items = array(new InventoryDirectTransferItem());
        $id = (int) Yii::app()->request->getParam('id');
        $type = (int) Yii::app()->request->getParam('type');
        if ($id > 0) {

            $model = $model->findByPk($id);
            // print_r($model->transfer_date);die();
            $transfer_date = str_replace('/', '-', $model->transfer_date);
            $transfer_date = date('d/m/Y', strtotime($transfer_date));
            $model->transfer_date = $transfer_date;
            $model_items = InventoryDirectTransferItem::model()->findAll(array('condition' => 'direct_transfer_id="' . $id . '"'));
            if (empty($model_items)) {
                $model_items = array(new InventoryDirectTransferItem());
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('directtransfer_createsample', array('model' => $model, 'model_items' => $model_items, 'type' => $type));
    }






    public function actionSaveTransfersample()
    {

        $model = new InventoryDirectTransfer();

        /************ START Code for Save ***************/

        if (isset($_POST['InventoryDirectTransfer'])) {

            if ((int) @$_POST['InventoryDirectTransfer']['id'] > 0) {

                $id = (int) @$_POST['InventoryDirectTransfer']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('y-m-d');
                $audit_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('y-m-d h:m:s');
                $audit_type = 'CREATED';
            }

            $model->attributes = $_POST['InventoryDirectTransfer'];


            $model->direct_transfer_description = $_POST['InventoryDirectTransfer']['direct_transfer_description'];
            $model->reference = $_POST['InventoryDirectTransfer']['reference'];
            if ($_POST['InventoryDirectTransfer']['transfer_date'] != '' && $_POST['InventoryDirectTransfer']['transfer_date'] != '0000-00-00') {
                $model->transfer_date = str_replace('/', '-', $_POST['InventoryDirectTransfer']['transfer_date']);
                $model->transfer_date = date("Y-m-d", strtotime($model->transfer_date));
            }

            $model->added_from = 'ST'; //sample tranfer

            $valid = $model->validate();


            $other_errors = array();
            $total_sample = 0;

            //   ---------------------AccAuditClose check------------------------------------


            $transfer_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['InventoryDirectTransfer']['transfer_date'])));

            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
            $transfer_date = strtotime($transfer_datex);
            if ($transfer_date <= $existing_date) {
                $valid = false;
                $other_errors[] = ' Given Transfer date must be greater than Audit Close date  :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';

            }
            //   --------------------//-AccAuditClose check------------------------------------



            if (!empty($_POST['InventoryDirectTransferItem'])) {
                if (isset($_POST['InventoryDirectTransferItem'])) {

                    foreach ($_POST['InventoryDirectTransferItem'] as $i => $items) {
                        $model_item[$i] = new InventoryDirectTransferItem();
                        $model_item[$i]->item_id = $items['item_id'];
                        $model_item[$i]->item_description = $items['item_description'];
                        $model_item[$i]->item_name = $items['item_name'];
                        $model_item[$i]->transfer_qty = $items['transfer_qty'];
                        $model_item[$i]->sample_qty = $items['sample_qty'];
                        $model_item[$i]->unit = $items['unit'];
                        $model_item[$i]->rate = $items['rate'];
                        $total_sample += $items['sample_qty'];
                        // ---------GoodsIssueItem--------------
                        $warehouse_id = $_POST['InventoryDirectTransfer']['from_warehouse_id'];
                        if ($items['transfer_qty'] > 0 || $items['sample_qty'] > 0) {
                            $total_qty = $items['transfer_qty'];
                        }

                        if ($items['sample_qty'] > $items['transfer_qty']) {

                            $other_errors[] = 'Sample Qty must be less than Transfer Qty';
                            $valid = false;
                        }

                        if ($total_qty > 0) {
                            $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $items['item_id'] . ' AND warehouse_id=' . (int) $warehouse_id)->queryScalar();

                            $productModel = Store::model()->findByPk($items['item_id']);

                            if ((float) $total_qty > (float) $availble_qty) {

                                $other_errors[] = 'Available Quantity for ' . $productModel->part_number . ' is ' . (float) $availble_qty;
                                $valid = false;
                            }
                        }



                        // ------------------------------------------
                        $valid = $model_item[$i]->validate() && $valid;
                    }
                }
            }
            if ($total_sample == 0) {
                $other_errors[] = 'Please add atleast one sample';
                $valid = false;
            }

            if ($valid) {

                $model->save();


                // ---------GoodsIssue--------------
                $model_issue = new InventoryGoodsIssue();
                if ($model->transfer_date != '') {
                    $model_issue->goods_issue_date = $model->transfer_date;
                }
                $model_issue->reference = $model->reference . ' - Transfer No.' . $model->id;
                $model_issue->issue_type = 'S'; //sample
                $model_issue->warehouse_id = $model->to_warehouse_id;
                $model_issue->created_by = Yii::app()->user->id;
                $model_issue->created_date_time = date('Y-m-d H:i:s');
                $model_issue->save(false);
                $model_issue->refresh();
                // ----------------------

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'DIRECT_TRANSFER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with PKGNo: - {$model->id}  "
                );
                // end audit log 
                InventoryDirectTransferItem::model()->deleteAll('direct_transfer_id=:refer_id', array(':refer_id' => $model->id));
                foreach ($model_item as $each) {
                    $each->direct_transfer_id = $model->id;
                    $each->save();
                    // ---------GoodsIssueItem--------------
                    if ($each->sample_qty > 0) {
                        $model_issue_item = new InventoryGoodsIssueItem();
                        $model_issue_item->inventory_goods_issue_id = $model_issue->id;
                        $model_issue_item->created_by = Yii::app()->user->id;
                        $model_issue_item->created_date_time = date("Y-m-d H:i:s");
                        $model_issue_item->product_id = $each->item_id;
                        $model_issue_item->product_name = $each->item_name;
                        $model_issue_item->description = $each->item_description;
                        $model_issue_item->picked_qty = $each->sample_qty;
                        $model_issue_item->unit = $each->unit;
                        ;
                        $model_issue_item->rate = $each->rate;
                        $model_issue_item->save(false);
                    }

                    // --------------------------------
                }

                $jsonData['id'] = $model->id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_item[0]->item_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other_errors));
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }


    public function actionPrintSampleTransferPDF()
    {

        $model = new InventoryDirectTransfer();
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.inv_transfer_sample', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output("SampleTransferReceipt.pdf", 'I');
    }


    public function actionPrintsampleTransferExcel()
    {

        $model = new InventoryDirectTransfer();
        $id = Yii::app()->request->getParam('id');

        $filename = 'inv_transfer_direct' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.views.front.pdf.inv_transfer_sample_excel', array('model' => $model, 'id' => $id), false, true);
        Yii::app()->end();
        return;

    }


    public function actionGetProductsWithBarcode()
    {


        $from = $_GET['frm'];

        $searchTerm = $_POST['barcode'];

        $warehouse_id = $_POST['from_warehouse_id'];

        $condition = 'bar_code="' . $searchTerm . '"  and isActive="Y" AND ( inventory_item_type =1) ';//OR bar_code LIKE "%' . $searchTerm . '%"


        $limit = 1;


        $model = new Store();

        // $model = $model->findAll(array('condition' => $condition,'limit'=>50));





        $i = 0;

        $model = $model->find(array('condition' => $condition));

        if (!empty($model)) {

            $available_qty = 0;
            if ($warehouse_id > 0) {
                $available_qty = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'product_id="' . $model['id'] . '" AND warehouse_id=' . $warehouse_id))->quantity;
            }
            if ($available_qty == '' || $available_qty = 0) {
                $available_qty = 0;
            }





            $data['bar_code'] = $model['bar_code'];
            $data['available_qty'] = $available_qty;
            $data['rate'] = $model['rate'];
            $data['product_id'] = $model['id'];
            $data['part_number'] = $model['part_number'];

            $data['description'] = $model['description'];
            $data['unit_id'] = $model['unit']['id'];
            $data['unit_name'] = $model['unit']['symbol'];
            $data['label'] = $model['part_number'] . ' : ' . $model['description'] . ' : ' . (float) $available_qty . ' (Avail.Qty)';

            $data['msg'] = 'success';


        } else {
            $data['msg'] = 'failed';
        }



        echo CJSON::encode($data);


    }

    public function actionPackagingGetList()
    {
        $model = new InventoryIndirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = $_REQUEST['frm'];
        // var_dump($frm);
        if ($frm == 'IDTOUT') {
            $model = new InventoryIndirectTransfer();
        }
        if ($frm == 'DTOUT') {
            $model = new InventoryDirectTransfer();
        }
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.date', // Assuming you need a 'date' field
            2 => 't.warehouse_id', // Assuming warehouse_id is used here
            3 => 't.reference',
            4 => 't.status',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = "t.id DESC";

        $ModelUser = User::model()->findByPk((int) Yii::app()->user->id);
        $condition = '1=1 AND status="P"';
        // $condition .= ' AND from_warehouse_id IN(' . $ModelUser->available_warehouses . ')';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (t.id LIKE '%" . $searchString . "%' 
                          OR t.date LIKE '%" . $searchString . "%' 
                          OR t.warehouse_id LIKE '%" . $searchString . "%' 
                          OR t.reference LIKE '%" . $searchString . "%' 
                          OR t.status LIKE '%" . $searchString . "%')";
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;

        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            // Assuming you need the date to be formatted
            $formattedDate = date("d/m/Y", strtotime($row['transfer_date']));

            // Assuming we have a status field, modify if necessary
            $status = $row['status'] == 'P' ? 'Packing' : 'Completed';

            $div = '';
            $rowData[] = array(
                $row['id'],
                $formattedDate,
                $row['warehouseFrom']['warehouse_name'],
                $row['warehouseTo']['warehouse_name'],
                $row['reference'],
                $status,
                '<div class="btn-wrap text-center">' . $div . '</div>'
            );
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetIndirecttransactionlistIn()
    {

        $model = new InventoryIndirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            //1 =>'warehouseTo.warehouse_name',
            //2 =>'warehouseFrom.warehouse_name',                                     
            //3 =>'direct_transfer_description',
            //4 =>'reference', 
            //5 =>'transfer_date', 
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $ModelUser = User::model()->findByPk((int) Yii::app()->user->id);
        $condition = '1=1 AND is_complete="Y" ';
        $condition .= ' AND (from_warehouse_id IN (' . $ModelUser->available_warehouses . ') OR to_warehouse_id IN (' . $ModelUser->available_warehouses . '))';



        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = '1=1 AND is_complete="Y"';
            $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%' OR t.indirect_transfer_description LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('warehouseTo', 'warehouseFrom')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        // $model=Yii::app()->db->createCommand("select * from erp_inventory_indirect_transfer where $condition")->queryAll();
        $count = count($model);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row['transfer_date']) && ($row['transfer_date'] != ""))
                $req_date = date("d/m/Y", strtotime($row['transfer_date']));//,$row['warehouseTo']['warehouse_name']
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_in_print"]) || ((int) Yii::app()->user->havePermissionOn["direct_transfer_out_print"])) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintInDirectTransferPDF&frm=in&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            if ($row['status'] == 'P') {
                $status = 'Packaging';
            }
            if ($row['status'] == 'TO') {
                $status = 'Transfer Out';
            }
            if ($row['status'] == 'C') {
                $status = 'Check In';
            }
            if ($row['status'] == 'TI') {
                $status = 'Trasnfer IN';
            }
            $rowData[] = array($row['id'], $req_date, $row['warehouseFrom']['warehouse_name'], $row['warehouseTo']['warehouse_name'], $row['reference'], $row['indirect_transfer_description'], '<div class="btn-wrap text-center">' . $div . '</div>', $status, $row['status']);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actiongetDestinationwarehouseLocation()
    {
        $from_id = $_POST['from_id'];
        $to_id = $_POST['to_id'];
        $dest_id = $_POST['dest_id'];
        $data = array();
        $model = new InventoryIndirectTransfer;
        if ($from_id > 0) {
            if ($dest_id > 0) {
                $model->destination_warehouse = $dest_id;
                $data['towarehouse'] = CHtml::activedropDownList($model, 'to_warehouse_id', MasInventoryWarehouse::getDestinationWarehouses($from_id, $to_id), array('class' => '', 'data-label' => 'Destination <span style="color:red">*</span>', 'empty' => '--Select--'));

            } else {
                $data['towarehouse'] = CHtml::activedropDownList($model, 'to_warehouse_id', MasInventoryWarehouse::getDestinationWarehouses($from_id, $to_id), array('class' => '', 'data-label' => 'Destination <span style="color:red">*</span>', 'empty' => '--Select--'));

            }
            //echo $form->dropDownList($model,'to_warehouse_id',MasInventoryWarehouse::getWarehouses(),array('class' => '','data-label'=>'To Warehouse <span style="color:red">*</span>','empty'=>'--Select--')); 
        }
        echo CJSON::encode($data);
    }

    public function actionGetReferenceIds()
    {
        $id = (int) Yii::app()->request->getParam("from_id");
        $customer_id = (int) Yii::app()->request->getParam("customer_id");
        $model = new InventoryIndirectTransfer();
        if ($customer_id > 0) {
            $data = InventoryIndirectTransfer::getRefernceIdsWithCustomer($id, $customer_id);

        } else {
            $data = InventoryIndirectTransfer::getRefernceIds($id);

        }

        $drop = '<li class="col-sm-3">';
        $drop .= CHtml::activeDropDownList(
            $model,
            'reference',
            $data,
            array(
                'class' => 'tooltipster',
                'multiple' => 'multiple', // enable multi-select
                'data-label' => 'Reference <span style="color:red;">*</span>',
                'onChange' => 'getProductDetails'
            )
        );
        $drop .= '</li>';

        echo CJSON::encode(['dt' => $drop]);
    }


    public function actionGetItemDetails()
    {
        $referenceIds = Yii::app()->request->getPost('reference_ids', []);
        if (!is_array($referenceIds)) {
            $referenceIds = explode(',', $referenceIds); // fallback
        }
        $modelsInventoryIndirectTransfer = InventoryIndirectTransfer::model()->findAllByPk($referenceIds);

        $customerNames = []; // initialize array
        if (!empty($modelsInventoryIndirectTransfer)) {
            foreach ($modelsInventoryIndirectTransfer as $transfer) {
                if (!empty($transfer->customer_name)) {
                    $customerNames[] = $transfer->customer_name;
                }
            }
        }

        $customerNamesStr = implode(', ', $customerNames);
        $items = InventoryIndirectTransferItem::model()->findAll([
            'condition' => 'indirect_transfer_id IN (' . implode(',', array_map('intval', $referenceIds)) . ')'
        ]);

        if (!$items) {
            echo CJSON::encode(['success' => false]);
            Yii::app()->end();
        }

        $html = '';
        $i = 0;

        foreach ($items as $item) {
            $product = Store::model()->findByPk($item->item_id);
            $availableQty = (float) ProductLocation::model()->find([
                'select' => 'SUM(quantity) as quantity',
                'condition' => 'product_id="' . $item->item_id . '" AND warehouse_id=' . (int) $item->parent->from_warehouse_id
            ])->quantity;

            $units = UnitOfMeasurement::getUnits($item->item_id);
            $unitOptions = CHtml::dropDownList(
                "InventoryIndirectTransferItem[$i][unit]",
                '',
                $units,
                ['class' => 'qty go']
            );

            $html .= '<tr>';
            $html .= '<td><label>' . ($i + 1) . '</label></td>';
            $html .= '<td>' .
                CHtml::textField("InventoryIndirectTransferItem[$i][item_name]", $product->part_number, ['class' => 'tooltipster go', 'readonly' => true]) .
                CHtml::hiddenField("InventoryIndirectTransferItem[$i][id]", $item->id) .
                CHtml::hiddenField("InventoryIndirectTransferItem[$i][item_id]", $item->item_id) .
                CHtml::hiddenField("InventoryIndirectTransferItem[$i][indirect_transfer_id]", $item->indirect_transfer_id) .
                '</td>';

            $html .= '<td>' . CHtml::textArea("InventoryIndirectTransferItem[$i][item_description]", $product->description, ['class' => 'tooltipster desc go']) . '</td>';
            $html .= '<td>' . CHtml::textField("InventoryIndirectTransferItem[$i][transfer_qty]", $item->transfer_qty, ['class' => 'qty go cell-center text-right', 'readonly' => true]) . '</td>';
            $html .= '<td>' . CHtml::textField("InventoryIndirectTransferItem[$i][transferred_qty]", '', ['class' => 'qty go cell-center text-right']) . '</td>';
            $html .= '<td>' . CHtml::textField("InventoryIndirectTransferItem[$i][missing_qty]", '', ['class' => 'qty go cell-center text-right']) . '</td>';
            $html .= '<td>' . CHtml::textField("InventoryIndirectTransferItem[$i][damaged_qty]", '', ['class' => 'qty go cell-center text-right']) . '</td>';
            $html .= '<td>' . $unitOptions . '</td>';
            // $html .= '<td class="text-center nw"><a class="btn btn-sm btn-danger" href="javascript:void(0);" onclick="rmRow($(\'#transfer_item_table\'), this, this.id)"><i class="fa fa-times"></i></a></td>';
            $html .= '</tr>';

            $i++;
        }

        echo CJSON::encode(['success' => true, 'html' => $html, 'customerNamesStr' => $customerNamesStr]);
    }
    // -----------end--------------

    public function actionIndexMeterial()
    {
        if (
            Yii::app()->user->authorised_user == 1 || ( isset(Yii::app()->user->havePermissionOn['inventory_menu_view']) && isset(Yii::app()->user->havePermissionOn['direct_transfer_view']) && Yii::app()->user->havePermissionOn['inventory_menu_view'] && Yii::app()->user->havePermissionOn['direct_transfer_view'])) {
            $this->render('index_meterial');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function actionGetlistmeterial()
    {
        $model = new InventoryDirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'customer.customer_name',
            2 => 't.transfer_date',
            3 => 'warehouseTo.warehouse_name',
            4 => 'warehouseFrom.warehouse_name',
            5 => 'user_det.first_name',
            6 => 'direct_transfer_description',
            7 => 'reference',
            8 => 't.status',
            9 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = "t.id DESC";
        $condition = ' (t.status="T" OR t.status="C" ) AND  t.added_from="DT" AND type = "I" '; //DT = Direct transfer
        //   ---------------------------
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and t.id LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%'";
        }
        $count = $model->with('warehouseTo', 'warehouseFrom')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            if (!empty($row->transfer_date) && ($row->transfer_date != "")) {
                $req_date = date("d/m/Y", strtotime($row->transfer_date));
            }
            $div = '';
            if ($row['lead_owner_id'] > 0) {
                $user = $row['user_det']['first_name'] . ' ' . $row['user_det']['last_name'];
            } else {
                $user = '';
            }
            $statusIcon = '';
            if ($row['status'] == 'C') {
                $statusIcon = '<img src="uploads/correct.png" height="20" width="20" title="Completed" style="color:red;"/>';
            } else {
                $statusIcon = '<img src="uploads/tools.png" height="20" width="20" title="In Transit"/>';
            }
            $rowData[] = array( 
                $row['id'], 
                $row['customer']['customer_name'],
                $req_date, 
                $row['warehouseFrom']['warehouse_name'], 
                $row['warehouseTo']['warehouse_name'], 
                $user, 
                $row['direct_transfer_description'], 
                $row['reference'],
                $statusIcon,
                '<div class="btn-wrap text-center">' . $div . '</div>',
                $row['status'],
                $row['isApproved']
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreateMeterial()
    {
        $model = new InventoryDirectTransfer();
        $model_items = array(new InventoryDirectTransferItem());
        $modelOrderContractItem = array(new OrderContractItem);
        $modelContract = array(new OrderContractItem());
        $id = (int) Yii::app()->request->getParam('id');
       $job_id = (int) Yii::app()->request->getParam('job_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $type = (int) Yii::app()->request->getParam('type');
        $frm =   Yii::app()->request->getParam('frm');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $customer_id = $model->customer_id;
            $outlet_id   = $model->outlet_id;

            // Fetch all repair requests for this customer + outlet
            $modelRepairRequest = SaleRepairRequest::model()->findAll(array(
                'condition' => 'customer_id = :cid AND customer_shipping_id = :sid AND status_id != 2 AND (service_id = 1 OR service_id = 4) ',
                'params'    => array(
                    ':cid' => $customer_id,
                    ':sid' => $outlet_id,
                )
            ));
            $modelMachine = array();   // Will hold the final machine list
            foreach ($modelRepairRequest as $modelRepair) {
                $condition = 'header_id = :hid AND is_completed != "Y" AND status_id != 2';
                $machineList = SalesRepairRequestItem::model()->with('machine')->findAll(array( 'condition' => $condition, 'params'    => array(':hid' => $modelRepair->id)));
                if (!empty($machineList)) {
                    // merge into the result array (in case of multiple headers)
                    $modelMachine = array_merge($modelMachine, $machineList);
                }
            }

            // If still empty, return a single blank model
            if (empty($modelMachine)) {
                $modelMachine = array(new SalesRepairRequestItem());
            }
        }

        if ($id > 0) {
            $model = $model->findByPk($id);
            $transfer_date = str_replace('/', '-', $model->transfer_date);
            $transfer_date = date('d/m/Y', strtotime($transfer_date));
            $model->transfer_date = $transfer_date;
            $model_items = InventoryDirectTransferItem::model()->with('customer')->findAll(array('condition' => 'direct_transfer_id="' . $id . '"'));
            if (empty($model_items)) {
                $model_items = array(new InventoryDirectTransferItem());
            }
            if ($model->file_id > 0) {
                $condition = 'order_id = :hid';
                $modelContract = OrderContractItem::model()->findAll(array( 'condition' => $condition, 'params' => array(':hid' => $model->file_id)));
                if (empty($modelContract)) {
                    $modelContract = array(new OrderContractItem());
                }
            }
        }
        //////////////////////////////////////////////////////////////
        if($frm=="JO" && $job_id>0)
        {   
            $modelRequest = SaleRepairRequest::model()->findByPk($job_id);
            if(!empty($modelRequest))
            {
            $model = new InventoryDirectTransfer();
            $model_items = array(new InventoryDirectTransferItem());   
            $model->from_warehouse_id = MasInventoryWarehouse::getDefaultWarehouse()->id;
            $model->to_warehouse_id =  MasInventoryWarehouse::model()->getWarehouseIdByCode('RW');
            $model->lead_owner_id = $modelRequest->assigned_id;
            $model->customer_id =  $modelRequest->customer_id;
            $model->outlet_id =  $modelRequest->customer_shipping_id;
            $model->transfer_date = $modelRequest->request_date;
            $model->file_id =  $modelRequest->order_det->file_id;
            $model->reference =  $modelRequest->id;
            $model->job_id=  $modelRequest->id;
            $model->service_order_id=  $modelRequest->service_order_id;
            $modelItems = SalesRepairRequestItem::model()->with('machine')->findAll(['condition'=>'header_id='.$modelRequest->id.' AND machine.inventory_item_type!=4','group'=>'machine_id']);
           $i=0;
           $model_items = [];
            foreach($modelItems as $eachItem)
            {   
               // print_r($eachItem);
                $model_items[$i] = new InventoryDirectTransferItem;
                $machinecount = SalesRepairRequestItem::model()->count(['condition'=>'header_id='.$modelRequest->id.' AND machine_id='.$eachItem['machine_id']]);
                $model_items[$i]->available_qty = (int)$machinecount;
                $model_items[$i]->item_name = $eachItem->machine->part_number;
                $model_items[$i]->item_id = $eachItem->machine_id;
                $model_items[$i]->transfer_qty = $eachItem->quantity;
                $model_items[$i]->item_description =$eachItem->machine->description;
               // $model_items->available_qty =
               $i++;
            }
            }
            
        }
        ///////////////////////////////////////////////////
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('createmeterial_transfer', array('model' => $model, 'model_items' => $model_items, 'modelRepairRequest' => $modelRepairRequest, 'modelMachine' => $modelMachine, 'type' => $type,'frm'=>$frm,'job_id'=>$job_id ,'modelOrderContractItem' => $modelOrderContractItem, 'modelContract' => $modelContract), false, true);
    }

    public function actionConvertmeterial()
    {
        $model = new InventoryDirectTransfer();
        $model_items = array(new InventoryDirectTransferItem());
        $id = (int) Yii::app()->request->getParam('id');
        $type = (int) Yii::app()->request->getParam('type');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $transfer_date = str_replace('/', '-', $model->transfer_date);
            $transfer_date = date('d/m/Y', strtotime($transfer_date));
            $model->transfer_date = $transfer_date;
            $model_items = InventoryDirectTransferItem::model()->with('customer')->findAll(array('condition' => 'direct_transfer_id="' . $id . '"'));
            if (empty($model_items)) {
                $model_items = array(new InventoryDirectTransferItem());
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('convertmeterial_transfer', array('model' => $model, 'model_items' => $model_items, 'type' => $type));
    }

    public function actionGetInvoiceDropdown()
    {
        $customer_id = Yii::app()->request->getParam('customer_id');
        $lead_owner_id = Yii::app()->request->getParam('lead_owner_id');
        $type_of_invoice = Yii::app()->request->getParam('type_of_invoice', 'service');
        $row_index = Yii::app()->request->getParam('row_index', 0); // for form indexing
        $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');
        $type = Yii::app()->request->getparam("type");
        $row = Yii::app()->request->getparam("row");
        $condition = 'level1_approved_by > 0';//only approved service order
        // if ((int) Yii::app()->user->authorised_user != 1 && $warehouse_id > 0) {
        //     $condition .= ' AND warehouse_id=' . $warehouse_id;
        // }
        if ((int) $customer_id > 0) {
            $condition .= ' AND customer_id=' . $customer_id;
        }
        if (!empty($type_of_invoice)) {
            $condition .= ' AND order_type="' . $type_of_invoice . '"';
        }
        // Fetch invoices
        $modelInvoice = new Order();
        $invoices = $modelInvoice->findAll([
            'select' => 'id,file_id,sales_group_id,lead_owner_id',
            'condition' => $condition,
            'limit' => 200
        ]);
        // Prepare array for dropdown
        $invoiceArray = [];
        $salesGroupMap = [];
        $assignedUser = [];
        foreach ($invoices as $invoice) {
            $invoiceArray[$invoice->id] = $invoice->file_id . ' : ' . $invoice->id;
            $salesGroupMap[$invoice->id] = $invoice->sales_group_id;
            $assignedUser[$invoice->id] = $invoice->lead_owner_id;
        }
        // Create active dropdown
        $model = new InventoryDirectTransfer(); // or your form model that holds invoice_id
        $dropInvoice = '';
        $class = "tooltipster";
        if (empty($type)) {
            $class = 'invoice-dropdown';
            $dropInvoice = '<li class="col-sm-2">';
        }
        
        
        if($type=='transfer'){
            $change_type = 'LoadOrderDetails(this.value)';
        }
        else{
            $change_type = 'getContractFragranceDetails()';
        }
        
        
        $dropInvoice .= CHtml::activeDropDownList(
            $model,
            "file_id",
            $invoiceArray,
            [
                'empty' => '-Select Order-',
                'class' => $class,
                'title' => 'Please select Order',
                'data-label' => 'Contract / Job Sheet',
                'data-search' => true,
                'onChange' => $change_type,
            ]
        );
        if (empty($type)) {
            $dropInvoice .= '</li>';
        }
        echo CJSON::encode(['dropdown' => $dropInvoice, 'sales_groups' => $salesGroupMap, 'assigned_users' => $assignedUser]);
        Yii::app()->end();
    }

    public function actiongetCustomerShippingdetails()
    {
        $id = Yii::app()->request->getparam("id");
        $row_index = Yii::app()->request->getParam("row_index", 0);
        $type = Yii::app()->request->getparam("type");
        $row = Yii::app()->request->getparam("row");
        $model = new InventoryDirectTransfer();
        $models = CustomerOutletLocation::getShippingLocation($id);
        $drop = '';
        $class = "tooltipster";
        if (empty($type)) {
            $class = '';
            $drop = '<li class="col-sm-2">';
        }
        $drop .= CHtml::activedropDownList($model, "outlet_id", $models, array('class' => $class, 'title' => 'Please Select Outlet', 'data-label' => 'Outlet Location', 'data-search' => true, 'onChange' => 'js:getOutletLocationDetails(this);'));
        if (empty($type)) {
            $drop .= '</li>';
        }
        $status = array("dtship" => $drop);
        echo CJSON::encode($status);
    }

    public function actionSaveTransferMeterial()
    {
        $model = new InventoryDirectTransfer();
        /************ START Code for Save ***************/
        $from_warehouse_id = $to_warehouse_id = $lead_owner_id = '';
        if (isset($_POST['InventoryDirectTransfer'])) {
            $from_warehouse_id = $_POST['InventoryDirectTransfer']['from_warehouse_id'];
            $to_warehouse_id = $_POST['InventoryDirectTransfer']['to_warehouse_id'];
            $lead_owner_id = $_POST['InventoryDirectTransfer']['lead_owner_id'];
            if ((int) @$_POST['InventoryDirectTransfer']['id'] > 0) {
                $id = (int) @$_POST['InventoryDirectTransfer']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('y-m-d');
                $audit_type = 'UPDATED';
            } else {
                $model->type = 'I';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('y-m-d h:m:s');
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['InventoryDirectTransfer'];
            $model->direct_transfer_description = $_POST['InventoryDirectTransfer']['direct_transfer_description'];
            $model->reference = $_POST['InventoryDirectTransfer']['reference'];
            $model->lead_owner_id = $_POST['InventoryDirectTransfer']['lead_owner_id'];
            $model->customer_id = $_POST['InventoryDirectTransfer']['customer_id'];
            $model->file_id = $_POST['InventoryDirectTransfer']['file_id'];
            $model->outlet_id = $_POST['InventoryDirectTransfer']['outlet_id'];
            $model->job_id=  $_POST['InventoryDirectTransfer']['job_id'];
            $model->service_order_id=  $_POST['InventoryDirectTransfer']['service_order_id'];
            if ($_POST['InventoryDirectTransfer']['transfer_date'] != '' && $_POST['InventoryDirectTransfer']['transfer_date'] != '0000-00-00') {
                $model->transfer_date = str_replace('/', '-', $_POST['InventoryDirectTransfer']['transfer_date']);
                $model->transfer_date = date("Y-m-d", strtotime($model->transfer_date));
            }
            $valid = $model->validate();
            $other_errors = array();
            //   ---------------------AccAuditClose check------------------------------------
            $transfer_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['InventoryDirectTransfer']['transfer_date'])));
            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
            $transfer_date = strtotime($transfer_datex);
            if ($transfer_date <= $existing_date) {
                $valid = false;
                $other_errors[] = ' Given Transfer Date must be greater than Audit Close Date :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
            }
            //   --------------------//-AccAuditClose check------------------------------------
            if (isset($_POST['InventoryDirectTransferItem'])) {
                foreach ($_POST['InventoryDirectTransferItem'] as $i => $items) {
                    $model_item[$i] = new InventoryDirectTransferItem();
                    $model_item[$i]->item_id = $items['item_id'];
                    $model_item[$i]->item_description = $items['item_description'];
                    $model_item[$i]->item_name = $items['item_name'];
                    $model_item[$i]->transfer_qty = $items['transfer_qty'];
                    $model_item[$i]->unit = $items['unit'];
                    $valid = $model_item[$i]->validate() && $valid;
                    if($items['available_qty']<$items['transfer_qty']){
                        $valid = false;
                        $other_errors[] = ' Stock Not Available for'.$items['item_description'];
                    }
                }
            }
            if ($valid) {
                //$model->status = 'C';
                $model->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'DIRECT_TRANSFER - ISSUE',
                    Yii::app()->user->id,
                    $audit_type,
                    " with PKGNo: - {$model->id}  "
                );
                // end audit log 
                InventoryDirectTransferItem::model()->deleteAll('direct_transfer_id=:refer_id', array(':refer_id' => $model->id));
                if((int)$model->job_id >0){
                    SaleRepairRequest::model()->updateByPK((int)$model->job_id,["transfer_id"=>(int)$model->id]);
                }
                $warehouseNameTo = $warehouseNameFrom = '';
                $warehouseModel = MasInventoryWarehouse::model()->findByPk($from_warehouse_id);
                if ($warehouseModel) {
                    $warehouseNameFrom = $warehouseModel->warehouse_name;
                }
                $warehouseModel = MasInventoryWarehouse::model()->findByPk($to_warehouse_id);
                if ($warehouseModel) {
                    $warehouseNameTo = $warehouseModel->warehouse_name;
                }
                foreach ($model_item as $each) {
                    $processStatus = 'OIL_TRANSFERED';
                    $customerNameForRemarks = ($each->customer_id && !empty($each->customer->customer_name)) ? $each->customer->customer_name : '';
                    $remarks = $processStatus. '/' . $model->id . '/' . $customerNameForRemarks;                    
                    // Prepare new stock ledger OUT entry from Main warehouse
                    $stock = new StockLedger();
                    $stock->file_id = $model->file_id;
                    $stock->header_id = $model->id;
                    $stock->header_item_id = $each->id;
                    $stock->customer_vendor_id = $model->customer_id;
                    $stock->customer_vendor_name = $customerNameForRemarks;
                    $stock->product_id = $each->item_id;
                    $stock->product_name = $each->item_name;
                    $stock->product_description = $each->item_description;
                    // Try to pull brand info from store if available
                    $storeModel = Store::model()->findByPk($each->item_id);
                    $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                    $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                    $stock->warehouse_id = $from_warehouse_id;
                    $stock->warehouse_name = $warehouseNameFrom;
                    // Default rack/bin
                    $rack = new MasInvRack();
                    $stock->rack_id = $rack->getDefaultRackId();
                    $stock->rack_name = $rack->getRackName($stock->rack_id);
                    $bin = new MasInvBin();
                    $stock->bin_id = $bin->getDefaultBinId();
                    $stock->bin_name = $bin->getBinName($stock->bin_id);
                    // UOM and stock details
                    $stock->unit_id = $storeModel->unit_id;
                    $uomModel = UnitOfMeasurement::model()->findByPk($storeModel->unit_id);
                    $stock->unit_name = $uomModel ? $uomModel->name : '';
                    $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                    $stock->quantity = -$each->transfer_qty;
                    $stock->available_status = 'U'; // Mark unavailable as item is issued
                    $stock->batch_no = '';
                    $stock->serial_no = '';
                    $stock->cost_price = $storeModel->rate;
                    $stock->transaction_date = date('Y-m-d');
                    $stock->transaction_from = "OIL_TRANSFER_OUT";
                    $stock->transaction_type = "OUT";
                    $stock->master_stock_ledger_id = '';
                    $stock->stock_updated = 'Y';
                    $stock->created_by = Yii::app()->user->id;
                    $stock->created_date = date('Y-m-d H:i:s');
                    $stock->remarks = $remarks;
                    $stock->lead_owner_id = $model->lead_owner_id;
                    if (!$stock->save(false)) {
                        Yii::log("Failed to save stock ledger (OUT) for issued oil issue ID {$itemModel->product_id}", CLogger::LEVEL_ERROR);
                        Yii::app()->end();
                    }

                    // Prepare new stock ledger IN entry Van warehouse from Main warehouse
                    $stock = new StockLedger();
                    $stock->file_id = $model->file_id;
                    $stock->header_id = $model->id;
                    $stock->header_item_id = $each->id;
                    $stock->customer_vendor_id = $model->customer_id;
                    $stock->customer_vendor_name = $customerNameForRemarks;
                    $stock->product_id = $each->item_id;
                    $stock->product_name = $each->item_name;
                    $stock->product_description = $each->item_description;
                    // Try to pull brand info from store if available
                    $storeModel = Store::model()->findByPk($each->item_id);
                    $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                    $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                    $stock->warehouse_id = $to_warehouse_id;
                    $stock->warehouse_name = $warehouseNameTo;
                    // Default rack/bin
                    $rack = new MasInvRack();
                    $stock->rack_id = $rack->getDefaultRackId();
                    $stock->rack_name = $rack->getRackName($stock->rack_id);
                    $bin = new MasInvBin();
                    $stock->bin_id = $bin->getDefaultBinId();
                    $stock->bin_name = $bin->getBinName($stock->bin_id);
                    // UOM and stock details
                    $stock->unit_id = $storeModel->unit_id;
                    $uomModel = UnitOfMeasurement::model()->findByPk($storeModel->unit_id);
                    $stock->unit_name = $uomModel ? $uomModel->name : '';
                    $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                    $stock->quantity = $each->transfer_qty;
                    $stock->available_status = 'A'; // Mark unavailable as item is issued
                    $stock->batch_no = '';
                    $stock->serial_no = '';
                    $stock->cost_price = $storeModel->rate;
                    $stock->transaction_date = date('Y-m-d');
                    $stock->transaction_from = "OIL_TRANSFER_IN";
                    $stock->transaction_type = "IN";
                    $stock->master_stock_ledger_id = '';
                    $stock->stock_updated = 'Y';
                    $stock->created_by = Yii::app()->user->id;
                    $stock->created_date = date('Y-m-d H:i:s');
                    $stock->remarks = $remarks;
                    $stock->lead_owner_id = $model->lead_owner_id;
                    if (!$stock->save(false)) {
                        Yii::log("Failed to save stock ledger (IN) for issued oil issue ID {$itemModel->product_id}", CLogger::LEVEL_ERROR);
                        Yii::app()->end();
                    }

                    $each->direct_transfer_id = $model->id;
                    $each->stock_ledger_id = $stock->id;
                    $each->save();
                }
                $jsonData['id'] = $model->id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_item[0]->item_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other_errors));
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }

    public function actionSaveTransferIssue()
    {
        $model = new InventoryGoodsIssue();
        $valid = true;
        $other = [];
        $from_warehouse_id = $to_warehouse_id = $lead_owner_id = '';
        if (isset($_POST['InventoryDirectTransfer'])) {
            $id = (int) @$_POST['InventoryDirectTransfer']['id'];
            $from_warehouse_id = $_POST['InventoryDirectTransfer']['from_warehouse_id'];
            $to_warehouse_id = $_POST['InventoryDirectTransfer']['to_warehouse_id'];
            $lead_owner_id = $_POST['InventoryDirectTransfer']['lead_owner_id'];
            $customer_id = $_POST['InventoryDirectTransfer']['customer_id'];
            $outlet_id = $_POST['InventoryDirectTransfer']['outlet_id'];
            $file_id = $_POST['InventoryDirectTransfer']['file_id'];
            $model->goods_issue_date = date('Y-m-d');
            $model->file_id = $id;
            $model->warehouse_id = $from_warehouse_id;
            $model->lead_owner_id = $lead_owner_id;
            $model->notes = $_POST['InventoryDirectTransfer']['reference'];
            $model->reference = 'OIL_ISSUE';
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $audit_type = 'CREATED';
            if (empty($model->lead_owner_id)) {
                echo CJSON::encode([
                    'status' => 'error',
                    'message' => 'Technician cannot be blank'
                ]);
                Yii::app()->end();
            }
            $itemRows = $_POST['InventoryDirectTransferItem'] ?? [];
            if (empty($itemRows)) {
                echo CJSON::encode([
                    'status' => 'error',
                    'message' => 'No product items found.'
                ]);
                Yii::app()->end();
            }
            $itemModels = [];
            $stockLedgers = [];
            /*** Validate and Prepare Each Item ***/
            foreach ($itemRows as $i => $itemData) {
                $modelStore = Store::model()->findByPk($itemData['item_id']);
                $model->customer_id = $customer_id;
                $model->outlet_id = $outlet_id;
                $model->production_order_id = $file_id;
                // stock_ledger_id is passed as serial_no in the submitted data
                $sql = 'SELECT id,unit_id,warehouse_id FROM erp_stock_ledger L where L.product_id=' . $itemData['item_id'] . ' AND header_id = '.$id.' AND transaction_type = "IN" AND available_status = "A"';
                $modelStockLedger = Yii::app()->db->createCommand($sql)->queryRow();
                if (!$modelStockLedger) {
                    $valid = false;
                    $other[] = "Invalid stock ledger reference for item " . ($i + 1);
                    // push placeholder so indexes remain consistent but skip further processing for this row
                    $stockLedgers[] = null;
                    $itemModels[] = null;/////Invalid stock ledger reference
                    Yii::app()->end();
                }
                $modelUOM = UnitOfMeasurement::model()->findByPk((int) $modelStockLedger['unit_id']);
                $picked_qty = (int) $itemData['transfer_qty'] - (int) $itemData['balance_qty'];
                $modelIssueItem = new InventoryGoodsIssueItem();
                $modelIssueItem->product_id = $itemData['item_id'];
                $modelIssueItem->product_name = $modelStore ? $modelStore->part_number : '';
                $modelIssueItem->description = $modelStore ? $modelStore->description : '';
                $modelIssueItem->unit = (int) $modelStockLedger['unit_id'];
                $modelIssueItem->rate = 0; // temp
                $modelIssueItem->picked_qty = $picked_qty;
                $modelIssueItem->location_id = '';
                $modelIssueItem->created_by = Yii::app()->user->id;
                $modelIssueItem->created_date_time = date('Y-m-d H:i:s');
                $customer = Customer::model()->findByPk($model->customer_id);
                $no_of_days = 30;
                if ($customer && !empty($customer->no_of_days) && $customer->no_of_days > 0) {
                    $no_of_days = (int) $customer->no_of_days;
                }
                $lastService = date('Y-m-d');
                $nextService = date('Y-m-d', strtotime("+{$no_of_days} days", strtotime($lastService)));
                $valid = $modelIssueItem->validate();
                $itemModels[] = $modelIssueItem;
                $stockLedgers[] = $modelStockLedger;
                // Assign warehouse_id from last item
            }
            // validate header model too
            $valid = $model->validate();
            
        } else {
            $valid = false;
            $other[] = 'Form not posted';
        }
        if ($valid) {
            // Save header
            if (!$model->save(false)) {
                echo '<pre>';
                print_r($model->getErrors());
                echo '</pre>';
                Yii::app()->end();
            }
            /*** Save All Items and Corresponding Stock Ledgers ***/
            $warehouseNameTo = $warehouseNameFrom = '';
            $warehouseModel = MasInventoryWarehouse::model()->findByPk($from_warehouse_id);
            if ($warehouseModel) {
                $warehouseNameFrom = $warehouseModel->warehouse_name;
            }
            $warehouseModel = MasInventoryWarehouse::model()->findByPk($to_warehouse_id);
            if ($warehouseModel) {
                $warehouseNameTo = $warehouseModel->warehouse_name;
            }
            foreach ($itemModels as $index => $itemModel) {
                $transferQty = (int) $itemRows[$index]['transfer_qty'];
                $balanceQty = (int) $itemRows[$index]['balance_qty'];
                $usedQty = (int) $transferQty - (int) $balanceQty;
                // skip rows that were invalid earlier
                if (!$itemModel || !isset($stockLedgers[$index]) || !$stockLedgers[$index]) {
                    Yii::app()->end();
                }
                $itemModel->goods_issue_id = $model->id;
                $ledger = $stockLedgers[$index]; // associative array from queryRow
                $uom = UnitOfMeasurement::model()->findByPk((int) $ledger['unit_id']);
                /************** UPDATE ORIGINAL STOCK LEDGER TO MARK ISSUED **************/
                // Use the existing ledger id to update (that is the row we are issuing)
                $existingLedgerId = (int) $ledger['id'];
                $processStatus = 'OIL_TRANSFERED';
                $customerNameForRemarks = ($model->customer && !empty($model->customer->customer_name)) ? $model->customer->customer_name : '';
                $remarksUpdate = $processStatus . '/' . $model->id . '/' . $customerNameForRemarks;
                /************** STOCK LEDGER (OUT) ENTRY FOR MACHINE_ISSUE **************/
                $existingLedger = (object) $ledger; // cast for ->property access convenience
                $remarks = $processStatus.'/' . $model->id . '/' . $customerNameForRemarks;
                // Get warehouse name
                
                // Prepare new stock ledger OUT entry from Van warehouse with used quantity
                $stock = new StockLedger();
                $stock->file_id = $model->file_id;
                $stock->header_id = $model->id;
                $stock->header_item_id = $itemModel->id;
                $stock->customer_vendor_id = $model->customer_id;
                $stock->customer_vendor_name = $customerNameForRemarks;
                $stock->product_id = $itemModel->product_id;
                $stock->product_name = $itemModel->product_name;
                $stock->product_description = $itemModel->description;
                // Try to pull brand info from store if available
                $storeModel = Store::model()->findByPk($itemModel->product_id);
                $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                $stock->warehouse_id = $to_warehouse_id;
                $stock->warehouse_name = $warehouseNameTo;
                // Default rack/bin
                $rack = new MasInvRack();
                $stock->rack_id = $rack->getDefaultRackId();
                $stock->rack_name = $rack->getRackName($stock->rack_id);
                $bin = new MasInvBin();
                $stock->bin_id = $bin->getDefaultBinId();
                $stock->bin_name = $bin->getBinName($stock->bin_id);
                // UOM and stock details
                $stock->unit_id = $storeModel->unit_id;
                $uomModel = UnitOfMeasurement::model()->findByPk($storeModel->unit_id);
                $stock->unit_name = $uomModel ? $uomModel->name : '';
                $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                $stock->quantity = -$usedQty;
                $stock->available_status = 'U'; // Mark unavailable as item is issued
                $stock->batch_no = '';
                $stock->serial_no = '';
                $stock->cost_price = $storeModel->rate;
                $stock->transaction_date = date('Y-m-d');
                $stock->transaction_from = "OIL_TRANSFERED";
                $stock->transaction_type = "OUT";
                $stock->master_stock_ledger_id = $existingLedger->id;
                $stock->stock_updated = 'Y';
                $stock->created_by = Yii::app()->user->id;
                $stock->created_date = date('Y-m-d H:i:s');
                $stock->remarks = $remarks;
                $stock->lead_owner_id = $model->lead_owner_id;
                if (!$stock->save(false)) {
                    Yii::log("Failed to save stock ledger (OUT) for issued oil issue ID {$itemModel->product_id}", CLogger::LEVEL_ERROR);
                    Yii::app()->end();
                }
            if ($balanceQty > 0) {
                $processStatus = 'OIL_ISSUE_BALANCE';
                $remarksUpdate = $processStatus . '/' . $model->id . '/' . $customerNameForRemarks;
                $remarks = $processStatus.'/' . $model->id . '/' . $customerNameForRemarks;

                // Prepare new stock ledger OUT entry from Van warehouse for balance qunatity
                $stock = new StockLedger();
                $stock->file_id = $model->file_id;
                $stock->header_id = $model->id;
                $stock->header_item_id = $itemModel->id;
                $stock->customer_vendor_id = $model->customer_id;
                $stock->customer_vendor_name = $customerNameForRemarks;
                $stock->product_id = $itemModel->product_id;
                $stock->product_name = $itemModel->product_name;
                $stock->product_description = $itemModel->description;
                // Try to pull brand info from store if available
                $storeModel = Store::model()->findByPk($itemModel->product_id);
                $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                $stock->warehouse_id = $to_warehouse_id;
                $stock->warehouse_name = $warehouseNameTo;
                // Default rack/bin
                $rack = new MasInvRack();
                $stock->rack_id = $rack->getDefaultRackId();
                $stock->rack_name = $rack->getRackName($stock->rack_id);
                $bin = new MasInvBin();
                $stock->bin_id = $bin->getDefaultBinId();
                $stock->bin_name = $bin->getBinName($stock->bin_id);
                // UOM and stock details
                $stock->unit_id = $storeModel->unit_id;
                $uomModel = UnitOfMeasurement::model()->findByPk($storeModel->unit_id);
                $stock->unit_name = $uomModel ? $uomModel->name : '';
                $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                $stock->quantity = -$balanceQty;
                $stock->available_status = 'U'; // Mark unavailable as item is issued
                $stock->batch_no = '';
                $stock->serial_no = '';
                $stock->cost_price = $storeModel->rate;
                $stock->transaction_date = date('Y-m-d');
                $stock->transaction_from = $processStatus;
                $stock->transaction_type = "OUT";
                $stock->master_stock_ledger_id = $existingLedger->id;
                $stock->stock_updated = 'Y';
                $stock->created_by = Yii::app()->user->id;
                $stock->created_date = date('Y-m-d H:i:s');
                $stock->remarks = $remarks;
                $stock->lead_owner_id = $model->lead_owner_id;
                if (!$stock->save(false)) {
                    Yii::log("Failed to save stock ledger (OUT) for issued oil issue ID {$itemModel->product_id}", CLogger::LEVEL_ERROR);
                    Yii::app()->end();
                }
            
                $processStatus = 'OIL_ISSUE_BALANCE';
                $remarksUpdate = $processStatus . '/' . $model->id . '/' . $customerNameForRemarks;
                $remarks = $processStatus.'/' . $model->id . '/' . $customerNameForRemarks;
                // Prepare new stock ledger IN entry from Van warehouse to Main warehouse for balance qunatity
                $stock = new StockLedger();
                $stock->file_id = $model->file_id;
                $stock->header_id = $model->id;
                $stock->header_item_id = $itemModel->id;
                $stock->customer_vendor_id = 0;
                $stock->customer_vendor_name = '';
                $stock->product_id = $itemModel->product_id;
                $stock->product_name = $itemModel->product_name;
                $stock->product_description = $itemModel->description;
                // Try to pull brand info from store if available
                $storeModel = Store::model()->findByPk($itemModel->product_id);
                $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                $stock->warehouse_id = $from_warehouse_id;
                $stock->warehouse_name = $warehouseNameFrom;
                // Default rack/bin
                $rack = new MasInvRack();
                $stock->rack_id = $rack->getDefaultRackId();
                $stock->rack_name = $rack->getRackName($stock->rack_id);
                $bin = new MasInvBin();
                $stock->bin_id = $bin->getDefaultBinId();
                $stock->bin_name = $bin->getBinName($stock->bin_id);
                // UOM and stock details
                $stock->unit_id = $storeModel->unit_id;
                $uomModel = UnitOfMeasurement::model()->findByPk($storeModel->unit_id);
                $stock->unit_name = $uomModel ? $uomModel->name : '';
                $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                $stock->quantity = $balanceQty;
                $stock->available_status = 'A'; // Mark unavailable as item is issued
                $stock->batch_no = '';
                $stock->serial_no = '';
                $stock->cost_price = $storeModel->rate;
                $stock->transaction_date = date('Y-m-d');
                $stock->transaction_from = $processStatus;
                $stock->transaction_type = "IN";
                $stock->master_stock_ledger_id = $existingLedger->id;
                $stock->stock_updated = 'Y';
                $stock->created_by = Yii::app()->user->id;
                $stock->created_date = date('Y-m-d H:i:s');
                $stock->remarks = $remarks;
                $stock->lead_owner_id = $model->lead_owner_id;
                if (!$stock->save(false)) {
                    Yii::log("Failed to save stock ledger (OUT) for issued oil issue ID {$itemModel->product_id}", CLogger::LEVEL_ERROR);
                    Yii::app()->end();
                }
            }
                // Now link the newly created stock ledger id to the item and save the item
                //$itemModel->stock_ledger_id = $stock->id;
                if (!$itemModel->save(false)) {
                    Yii::log("Failed to save InventoryGoodsIssueItem for oil issue ID {$itemModel->product_id}", CLogger::LEVEL_ERROR);
                    echo '<pre>';
                    print_r($itemModel->getErrors());
                    echo '</pre>';
                    Yii::app()->end();
                }
                InventoryDirectTransfer::model()->updateByPk($id, ['status' => 'C' ]);
            }
            /************** AUDIT LOG **************/
            AuditLog::saveAuditLogs($audit_type, 'InventoryGoodsIssue', $model->id);
            echo CJSON::encode(['status' => 'success', 'id' => $model->id]);
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            // Merge CActiveForm errors with manual $other errors; make sure both are arrays
            $errorsMerged = array_merge_recursive((array) $error1, (array) $other);
            echo CJSON::encode($errorsMerged);
        }
    }

    public function actionGetmachinedetails()
    {
        $customer_id = (int) $_POST['id'];
        $outlet_id = (int) $_POST['outlet_id'];
        $modelrepair = new SalesRepairRequestItem();
        $modelMachine = array();   // Will hold the final machine list
        if ($customer_id > 0 && $outlet_id > 0) {
            // Fetch all repair requests for this customer + outlet
            $modelRepairRequest = SaleRepairRequest::model()->findAll(array(
                'condition' => 'customer_id = :cid AND customer_shipping_id = :sid AND status_id != 2 AND (service_id = 1 OR service_id = 4) ',
                'params'    => array(
                    ':cid' => $customer_id,
                    ':sid' => $outlet_id,
                )
            ));
            foreach ($modelRepairRequest as $modelRepair) {
                $condition = 'header_id = :hid AND is_completed != "Y" AND status_id != 2';
                $machineList = SalesRepairRequestItem::model()->with('machine')->findAll(array( 'condition' => $condition, 'params'    => array(':hid' => $modelRepair->id)));
                if (!empty($machineList)) {
                    // merge into the result array (in case of multiple headers)
                    $modelMachine = array_merge($modelMachine, $machineList);
                }
            }

            // If still empty, return a single blank model
            if (empty($modelMachine)) {
                $modelMachine = array(new SalesRepairRequestItem());
            }
        }
        $this->render('machine_details', [
            'modelrepair' => $modelrepair,
            'modelmachine' => $modelMachine, // <-- now this is the item list, not headers
        ], false, true);
    }

    public function actionGetContractFragranceDetails()
    {
        $order_id = (int) $_REQUEST['order_id'];
        if ($order_id > 0) {
            $condition = 'order_id = :hid';
            $modelContract = OrderContractItem::model()->findAll(array( 'condition' => $condition, 'params' => array(':hid' => $order_id)));

            // If still empty, return a single blank model
            if (empty($modelContract)) {
                $modelContract = array(new OrderContractItem());
            }
        }
        $this->render('contract_details', [
            'modelContract' => $modelContract, // <-- now this is the item list, not headers
        ], false, true);
    }

    public function actionApprove()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new InventoryDirectTransfer();
        $model = $model->findByPk($id);
        $model->isApproved = "Y";
        $model->approved_by = Yii::app()->user->id;
        $model->approved_date_time = date('Y-m-d H:i:s');
        $model->save(false);
        echo json_encode(array("status" => "success"));
    }

    public function actionPrintMachine()
    {
        $model = new InventoryDirectTransfer();
        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = new InventoryDirectTransfer();
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.returned_oil', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
    
    public function actionIndexMachineTransfer()
    {

        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['inventory_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['direct_transfer_view']) &&
                Yii::app()->user->havePermissionOn['inventory_menu_view'] &&
                Yii::app()->user->havePermissionOn['direct_transfer_view']
            )
        ) {
            $this->render('machine_transfer_index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }
    
    
    public function actionGetMachineTransferlist()
    {

        $model = new InventoryDirectTransfer();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',
            1 => 'warehouseTo.warehouse_name',
            2 => 'warehouseFrom.warehouse_name',
            3 => 'direct_transfer_description',
            4 => 'reference',
            5 => 'transfer_date',
            6 => 't.id'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = "t.id DESC";
        // $condition = 't.status="C"';
        //   --------added-by-indhu-21-01-2023--------------
        $condition = 't.status="C"   AND  t.added_from="DT" AND t.type = "T" '; //DT = Direct transfer
        //   ---------------------------


        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and t.id LIKE '%" . $searchString . "%' OR warehouseTo.warehouse_name LIKE '%" . $searchString . "%' OR warehouseFrom.warehouse_name LIKE '%" . $searchString . "%'";
        }
        $count = $model->with('warehouseTo', 'warehouseFrom')->count(array('condition' => $condition));
        $model = $model->with('warehouseTo', 'warehouseFrom')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            if (!empty($row->transfer_date) && ($row->transfer_date != "")) {
                $req_date = date("d/m/Y", strtotime($row->transfer_date));
            }

            $div = '';
            /*if (isset(Yii::app()->user->havePermissionOn['direct_transfer_view']) || Yii::app()->user->authorised_user == 1) {
                $div = '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'iwarehouse/directcreate&type=view&id=' . $row['id'] . '\',\'Direct Transfer\',\'xl\')"><i class="fa fa-eye"></i></button>';
            }*/
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_print"])) {
                //$div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=iwarehouse/PrintDirectTransferPDF&id=' . $row['id'] . ' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_transfer_excel"])) {
                // $div .= '&nbsp;<button class="btn btn-success  btn-xs" title="Excel" onclick="window.open(\'index.php?r=iwarehouse/PrintDirectTransferExcel&id='. $row['id'].'\')"><i class="fa fa-file-excel-o"></i></button> ';
            }
            if ($row['lead_owner_id'] > 0) {
                $user = $row['user_det']['first_name'] . ' ' . $row['user_det']['last_name'];

            } else {
                $user = '';
            }
            $rowData[] = array( $row['id'],
            $req_date, 
            $row['warehouseFrom']['warehouse_name'], 
            $row['warehouseTo']['warehouse_name'], 
            $user, 
            $row['direct_transfer_description'], 
            $row['reference'],  
            '<div class="btn-wrap text-center">' . $div . '</div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    
    
    public function actionCreateMachineTransfer()
    {
        $model = new InventoryDirectTransfer();
        $model_items = array(new InventoryDirectTransferItem());
        $id = (int) Yii::app()->request->getParam('id');
        $job_id = (int) Yii::app()->request->getParam('job_id');
        $customer_id = (int) Yii::app()->request->getParam('customer_id');
        $type = (int) Yii::app()->request->getParam('type');
        $frm =   Yii::app()->request->getParam('frm');
        if ($id > 0) {

            $model = $model->findByPk($id);
            // var_dump($model);die();
            $transfer_date = str_replace('/', '-', $model->transfer_date);
            $transfer_date = date('d/m/Y', strtotime($transfer_date));
            $model->transfer_date = $transfer_date;
            $model_items = InventoryDirectTransferItem::model()->findAll(array('condition' => 'direct_transfer_id="' . $id . '"'));
            if (empty($model_items)) {
                $model_items = array(new InventoryDirectTransferItem());
            }

        }
        if($frm=="JO" && $job_id>0)
        {   
            $modelRequest = SaleRepairRequest::model()->findByPk($job_id);
            if(!empty($modelRequest))
            {
            $model = new InventoryDirectTransfer();
            $model_items = array(new InventoryDirectTransferItem());   
            $model->from_warehouse_id = MasInventoryWarehouse::getDefaultWarehouse()->id;
            $model->to_warehouse_id =  MasInventoryWarehouse::model()->getWarehouseIdByCode('RW');
            $model->lead_owner_id = $modelRequest->assigned_id;
            $model->customer_id =  $modelRequest->customer_id;
            $model->transfer_date = $modelRequest->request_date;
            $model->outlet_id =  $modelRequest->customer_shipping_id;
            $model->file_id =  $modelRequest->order_det->file_id;
            $model->reference =  $modelRequest->id;
            $model->job_id=  $modelRequest->id;
            $model->service_order_id=  $modelRequest->service_order_id;
            $modelItems = SalesRepairRequestItem::model()->findAll(['condition'=>'header_id='.$modelRequest->id,'group'=>'machine_id']);
           $i=0;
           $model_items = [];
            foreach($modelItems as $eachItem)
            {   
               // print_r($eachItem);
                $model_items[$i] = new InventoryDirectTransferItem;
                $machinecount = SalesRepairRequestItem::model()->count(['condition'=>'header_id='.$modelRequest->id.' AND machine_id='.$eachItem['machine_id']]);
                $model_items[$i]->transfer_qty = (int) $machinecount;
                $model_items[$i]->available_qty = 0;
                $model_items[$i]->item_name = $eachItem->machine->part_number;
                $model_items[$i]->item_id = $eachItem->machine_id;
                $model_items[$i]->item_description =$eachItem->machine->description;
               // $model_items->available_qty =
               $i++;
            }
            }
            
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_machine_transfer', array('model' => $model, 'model_items' => $model_items, 'type' => $type,'frm'=>$frm,'job_id'=>$job_id));
    }
    
    


    public function actionSaveMachineTransfer()
    {

        $model = new InventoryDirectTransfer();

        /************ START Code for Save ***************/

        if (isset($_POST['InventoryDirectTransfer'])) {

            if ((int) @$_POST['InventoryDirectTransfer']['id'] > 0) {

                $id = (int) @$_POST['InventoryDirectTransfer']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('y-m-d');
                $audit_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('y-m-d h:m:s');
                $audit_type = 'CREATED';
            }

            $model->attributes = $_POST['InventoryDirectTransfer'];
            $model->direct_transfer_description = $_POST['InventoryDirectTransfer']['direct_transfer_description'];
            $model->reference = $_POST['InventoryDirectTransfer']['reference'];
            $model->lead_owner_id = $_POST['InventoryDirectTransfer']['lead_owner_id'];
            
            $model->customer_id = $_POST['InventoryDirectTransfer']['customer_id'];
            $model->file_id = $_POST['InventoryDirectTransfer']['file_id'];
            $model->outlet_id = $_POST['InventoryDirectTransfer']['outlet_id'];
            $model->job_id=  $_POST['InventoryDirectTransfer']['job_id'];
            $model->service_order_id=  $_POST['InventoryDirectTransfer']['service_order_id'];
            if ($_POST['InventoryDirectTransfer']['transfer_date'] != '' && $_POST['InventoryDirectTransfer']['transfer_date'] != '0000-00-00') {
                $model->transfer_date = str_replace('/', '-', $_POST['InventoryDirectTransfer']['transfer_date']);
                $model->transfer_date = date("Y-m-d", strtotime($model->transfer_date));
            }
            $valid = $model->validate();
            $other_errors = array();

            //   ---------------------AccAuditClose check------------------------------------


            $transfer_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['InventoryDirectTransfer']['transfer_date'])));

            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
            $transfer_date = strtotime($transfer_datex);
            if ($transfer_date <= $existing_date) {
                $valid = false;
                $other_errors[] = ' Given Transfer Date must be greater than Audit Close Date :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';

            }
            //   --------------------//-AccAuditClose check------------------------------------



            if (isset($_POST['InventoryDirectTransferItem'])) {

                foreach ($_POST['InventoryDirectTransferItem'] as $i => $items) {
                    $model_item[$i] = new InventoryDirectTransferItem();
                    $model_item[$i]->item_id = $items['item_id'];
                    $model_item[$i]->item_description = $items['item_description'];
                    $model_item[$i]->item_name = $items['item_name'];
                    $model_item[$i]->transfer_qty = $items['transfer_qty'];
                    $model_item[$i]->unit = $items['unit'];
                    $valid = $model_item[$i]->validate() && $valid;

                }

            }
            if ($valid) {

                $model->save();
                $model->refresh();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'DIRECT_TRANSFER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with PKGNo: - {$model->id}  "
                );
                // end audit log 
                InventoryDirectTransferItem::model()->deleteAll('direct_transfer_id=:refer_id', array(':refer_id' => $model->id));
                if((int)$model->job_id >0){
                    SaleRepairRequest::model()->updateByPK((int)$model->job_id,["transfer_id"=>(int)$model->id]);
                }
                foreach ($model_item as $each) {
                    $each->direct_transfer_id = $model->id;
                    $each->save();
                }
                $jsonData['id'] = $model->id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_item[0]->item_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other_errors));
                if ($error != '[]') {
                    echo $error;
                }

            }
        }
    }
    
    public function actionGetMachineOrderItemDetails(){
         $id = (int) Yii::app()->request->getParam('order_id');
         $warehouse_id = (int) Yii::app()->request->getParam('warehouse_id');
         
         
         $modelOrderItem = new OrderItem();
         
         $modelOrderItem = $modelOrderItem->with('product')->findAll(array('condition'=>'order_id='.$id.' AND inventory_item_type=4'));//machines only
         
         $modelTransferItem = array(new InventoryDirectTransferItem());
         
         foreach($modelOrderItem as $i=>$eachItem){
             $modelTransferItem[$i]                     = new InventoryDirectTransferItem();
             $modelTransferItem[$i]['item_id']          = $eachItem->product_id;
             $modelTransferItem[$i]['item_name']        = $eachItem->product->part_number;
             $modelTransferItem[$i]['item_description'] = $eachItem->description;
             $modelTransferItem[$i]['transfer_qty']     = $eachItem->quantity;
             $modelTransferItem[$i]['unit']             = $eachItem->unit_id;
         }
         
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('load_machine_order_items', array('modelTransferItem' => $modelTransferItem,'warehouse_id'=>$warehouse_id));
         
         
    }
}