<?php

class IssuesController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'Create',
                    'GetList',
                    'SaveIssue',
                    'DeleteIssue',
                    'GetProducts',
                    'DeleteIssueItem',
                    'Append',
                    'GetTotal',
                    'GetStockDetails',
                    'GetSortedStockDetails',
                    'Getunitdrop',
                    'GetFactor',
                    'PrintPDF',
                    'GetLeadOwners'
                ),
                'expression' => '$user->isMember()',
            ), /*             * copied by jisha from bouleward on 8-5-17* */
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {

        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['inventory_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['mov_issue_view']) &&
                Yii::app()->user->havePermissionOn['inventory_menu_view'] &&
                Yii::app()->user->havePermissionOn['mov_issue_view']
            )
        ) {
            $this->render('index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionGetList()
    {
        $model = new InventoryGoodsIssue();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = Yii::app()->request->getParam('frm');

        $columns = array(
            0 => 'goods_issue_date',
            1 => 'customer_id',
            2 => 'project'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.stock_updated="Y"';
        if ($frm == 'PR') {
            $condition .= ' AND t.issue_type="PR"';
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (id LIKE '%" . $searchString . "%' OR goods_issue_date LIKE '%" . $searchString . "%' OR project_id LIKE '%" . $searchString . "%')";
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array(
            'condition' => $condition,
            'limit' => $limit,
            'offset' => $offset,
            'order' => 'id DESC'
        ));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $date_d = date("d/m/Y", strtotime($row->goods_issue_date));
            $ticket = '';
            // $ticket = ((int) $row['ticket_id'] > 0) ? 'Y' : 'N';   this ticket_id is remove from table by arun sir

            // New status logic
            $status = '';
            if ($row['stock_updated'] === 'Y') {
                $status = 'Production Goods Issued';
            }

            $rowData[] = array(
                $row['id'],
                $date_d,
                $row->customer->customer_name,
                $row['reference'],
                $status,
                $row['posted'],
                $ticket
                // add status to the last column
            );
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }


    /*     * copied by jisha from bouleward on 8-5-17* */

    public function actionCreate()
    {
        $model = new InventoryGoodsIssue();
        $model_item = array(new InventoryGoodsIssueItem());
        $id = (int) Yii::app()->request->getParam('id');
        $ticket_id = (int) Yii::app()->request->getParam('ticket_id');
        $project_id = (int) Yii::app()->request->getParam('project_id');
        $frm = Yii::app()->request->getParam('frm');
        $page_frm = Yii::app()->request->getParam('page_frm');

        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_item = InventoryGoodsIssueItem::model()->findAll(array('condition' => 'inventory_goods_issue_id = ' . $model->id . ''));
        }
        if (!empty($ticket_id)) {
            /// when issue is generated from FM ticket module.
            $model->ticket_id = $ticket_id;
            $model->reference = "Job Order/" . $ticket_id;
            $ticket = TicketHeader::model()->findByPk($ticket_id);

            if (!empty($ticket)) {
                $customer_id = $ticket->unit_details->customer_id;
                $model->customer_id = $customer_id;
                $model->customer_name = $ticket->unit_details->customer->customer_name;
                $model->unit_id = $ticket->unit_id;
                $model->project_classification_id = $ticket->project_classification_id;
                $model->contract_id = $ticket->contract_id;

            }
        }
        if ($project_id > 0) {
            // echo 'hii';
            $modelProject = WsProject::model()->findByPk($project_id);
            // var_dump($modelProject->estimationDetails);
            foreach ($modelProject->estimationDetails as $i => $eachItem) {
                // var_dump($eachItem);
                $product_name = Store::model()->findBypk($eachItem->product_id)->part_number;
                $model_item[$i] = new InventoryGoodsIssueItem;
                $model_item[$i]->product_id = $eachItem->product_id;
                $model_item[$i]->product_name = $product_name;
                $model_item[$i]->description = $eachItem->description;
                $model_item[$i]->unit = $eachItem->unit;
                $model_item[$i]->free_qty = $eachItem->quantity;
                $model_item[$i]->picked_qty = $eachItem->quantity;
            }
        }
        if ($page_frm == 'workspace') {
            $item_id = Yii::app()->request->getParam('item_id');
            $modelWorkspaceNote = WorkspaceNote::model()->findByPk($item_id);
            $customer_name = Customer::model()->findByPK($modelWorkspaceNote->customer_id)->customer_name;

            $model->customer_id = $modelWorkspaceNote->customer_id;
            $model->customer_name = $customer_name;
            $model->reference_id = $modelWorkspaceNote->po_id;

            $modelProject = ProductionOrder::model()->findByPk($modelWorkspaceNote->po_id);

            foreach ($modelProject->items as $i => $eachItem) {
                // var_dump($eachItem);
                $product_name = Store::model()->findBypk($eachItem->product_id)->part_number;
                $model_item[$i] = new InventoryGoodsIssueItem;
                $model_item[$i]->product_id = $eachItem->product_id;
                $model_item[$i]->product_name = $product_name;
                $model_item[$i]->description = $eachItem->description;
                $model_item[$i]->unit = $eachItem->unit;
                $model_item[$i]->free_qty = $eachItem->quantity;
                $model_item[$i]->picked_qty = $eachItem->quantity;
            }


        }
        if ($frm == 'PR') {

            $po_id = (int) Yii::app()->request->getParam('po_id');
            $modelorder = new ProductionOrder();
            $modelorder = $modelorder->findByPk($po_id);
            $items = ProductionOrderItem::model()->findAll(array('condition' => 'production_order_id ="' . $po_id . '"'));
            $customer_name = Customer::model()->findByPK($modelorder->customer_id)->customer_name;
            $i = 0;
            $model->customer_id = $modelorder->customer_id;
            $model->customer_name = $modelorder->customerdetails->customer_name;
            $model->reference = $modelorder->reference;

            $model->reference_id = $modelorder->id;
            foreach ($items as $j => $eachPOItem) {
                $order_qty = $eachPOItem->quantity;
                $po_item_id = $eachPOItem->id;
                $product = Store::model()->findByPk($eachPOItem->product_id);
                $modelGoodsIssueItem = new InventoryGoodsIssueItem;
                $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . (int) $eachPOItem->product_id)->queryScalar();
                $availble_qty = number_format((float) $availble_qty, 2);
                $SQL_ISSUE = 'SELECT SUM(picked_qty) FROM `erp_inventory_goods_issue_item` GII INNER JOIN erp_inventory_goods_issue GI ON GI.id=GII.inventory_goods_issue_id WHERE product_id=' . (int) $eachPOItem->product_id . ' AND reference_id=' . (int) $po_id . ' AND GI.stock_updated="Y"';
                $goods_issue_qty = Yii::app()->db->createCommand($SQL_ISSUE)->queryScalar();
                $balance_qty = number_format((float) ($eachPOItem->quantity - $goods_issue_qty), 2);
                if ($eachPOItem->quantity > 0) {
                    $model_item[$i] = new InventoryGoodsIssueItem;
                    $model_item[$i]->product_id = $eachPOItem->product_id;
                    $model_item[$i]->product_name = $eachPOItem->product_name;
                    $model_item[$i]->description = $eachPOItem->description;
                    $model_item[$i]->unit = $eachPOItem->unit;
                    $model_item[$i]->free_qty = $availble_qty;
                    $model_item[$i]->picked_qty = $eachPOItem->quantity;
                    $model_item[$i]->bom_qty = $eachPOItem->quantity;
                    $model_item[$i]->balance_qty = $balance_qty;
                    $i++;
                }


            }

        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('issues_form', array('model' => $model, 'model_item' => $model_item, 'frm' => $frm, 'project_id' => $project_id), false, false);
    }

    public function actionSaveIssue()
    {
        // die();
        $otherErrors = array();
        $model = new InventoryGoodsIssue();
        $scenario = '';

        //added by priya 0n 11.9.24 check stocklockflag
        $modelCompanySettings = new MasCompanySettings();
        $condition = 'crm_company_id = ' . (int) Yii::app()->user->master_user_company_id;
        $modelCompanySettings = $modelCompanySettings->find(array('condition' => $condition));
        $stock_lock_flag = $modelCompanySettings->stock_lock_flag;
        if ($stock_lock_flag == "N") {
            /////////////

            if ((int) @$_POST['InventoryGoodsIssue']['id'] > 0) {
                $id = (int) @$_POST['InventoryGoodsIssue']['id'];
                $model = $model->findByPk($id);
                $old_warehouse_id = $model->warehouse_id;
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $scenario = 'update';
                $audit_type = 'UPDATED';
            } else {
                $old_warehouse_id = 0;
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $scenario = 'add';
                $audit_type = 'CREATED';
            }


            $warehouse_id = (int) @$_POST['InventoryGoodsIssue']['warehouse_id'];

            $model->attributes = $_POST['InventoryGoodsIssue'];
            // $model->project_classification_id = $_POST['InventoryGoodsIssue']['project_classification_id']; field commented, not using
            $model->contract_id = $_POST['InventoryGoodsIssue']['contract_id'];
            // $model->reference_id = $_POST['InventoryGoodsIssue']['reference_id'];// field name changed
             $model->reference = $_POST['InventoryGoodsIssue']['reference'];
           
            $model->lead_owner_id = $_POST['InventoryGoodsIssue']['lead_owner_id'];
            $model->goods_issue_date = (count(explode('/', $_POST['InventoryGoodsIssue']['goods_issue_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['InventoryGoodsIssue']['goods_issue_date']))) : date('Y-m-d');
            $valid = $model->validate();
            $model_item = array();
            $k = 0;
            foreach ($_POST['InventoryGoodsIssueItem'] as $rowItem) {

                if ($rowItem['product_id'] > 0) {
                    $model_item[$k] = new InventoryGoodsIssueItem();
                    $model_item[$k]->created_by = Yii::app()->user->id;
                    $model_item[$k]->created_date_time = date('Y-m-d H:i:s');
                    $model_item[$k]->product_id = $rowItem['product_id'];
                    $model_item[$k]->product_name = $rowItem['product_name'];
                    $model_item[$k]->description = $rowItem['description'];
                    $model_item[$k]->picked_qty = $rowItem['picked_qty'];
                    $model_item[$k]->unit = $rowItem['unit'];
                    $model_item[$k]->rate = $rowItem['rate'];
                    $valid = $model_item[$k]->validate() && $valid;
                    $productModel = Store::model()->findByPk($rowItem['product_id']);

                    $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $rowItem['product_id'] . ' AND warehouse_id=' . (int) $warehouse_id)->queryScalar();

                    if ((float) $rowItem['picked_qty'] > (float) $availble_qty) {
                        $otherErrors[] = 'Available Quantity for ' . $productModel->part_number . ' is ' . (float) $availble_qty;
                        $valid = false;
                    }
                    $k++;


                    $projectId = (int) $_POST['InventoryGoodsIssue']['project_id'];
                    $productId = (int) $rowItem['product_id'];
                    $pickedQty = (float) $rowItem['picked_qty'];

                    $estimationDetail = WsProjectEstimationDetails::model()->findByAttributes([
                        'project_id' => $projectId,
                        'product_id' => $productId,
                    ]);

                    if ($estimationDetail !== null) {
                        $estimationDetail->quantity -= $pickedQty;
                        if ($estimationDetail->quantity < 0) {
                            $estimationDetail->quantity = 0;
                        }
                        $estimationDetail->updated_by = Yii::app()->user->id;
                        $estimationDetail->updated_date_time = date('Y-m-d H:i:s');
                        $estimationDetail->save(false); // Save without validation
                    }
                }
            }



            //   ---------------------AccAuditClose check------------------------------------


            $goods_issue_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['InventoryGoodsIssue']['goods_issue_date'])));

            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
            $goods_issue_date = strtotime($goods_issue_datex);
            if ($goods_issue_date <= $existing_date) {
                $valid = false;
                $otherErrors[] = ' Given GoodsIssue date must be Greater than Audit Close Date :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
            }
            //   --------------------//-AccAuditClose check------------------------------------




            if ($valid && count($model_item) > 0) {
                $model->issue_type = $_POST['InventoryGoodsIssue']['issue_type'];
                echo CJSON::encode(array('status' => 'success'));
                $model->save();

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'ISSUES',
                    Yii::app()->user->id,
                    $audit_type,
                    " with PKG No: - {$model->id}  "
                );
                // end audit log


                $modeInventoryGoodsIssueItem = new InventoryGoodsIssueItem();
                $modeInventoryGoodsIssueItem->deleteAll('goods_issue_id=:refer_id', array(':refer_id' => $model->id));

                foreach ($model_item as $eachitem) {
                    $eachitem->goods_issue_id  = $model->id;
                    $eachitem->save();
                }
                /* if($scenario=='add'){
                  $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="20"'));
                  Yii::import('application.controllers.front.MasternotificationController');
                  if($model_mail_setting->mail_required=='Y'){
                  // MasternotificationController::sendmail(20,$model->id);
                  }
                  if($model_mail_setting->notification_required=='Y'){
                  // MasternotificationController::sendnotification(20,$model->id);
                  }
                  if($model_mail_setting->sms_required=='Y'){
                  // MasternotificationController::sendsms(20,$model->id);
                  }
                  } */
            } else {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (count($model_item) > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                echo CJSON::encode(array_merge_recursive($error1, $error2, $otherErrors));
            }
        } else {
            echo CJSON::encode(array('error' => ' Transactions are already locked!'));
        }
    }

    public function actionDeleteIssue()
    {
        $id = $_POST['id'];
        $model = new InventoryGoodsIssue();
        $model->deleteByPk($id);
        echo "success";
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionDeleteIssueItem()
    {

        $id = $_POST['id'];

        $model = new InventoryGoodsIssueItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionGetProducts()
    {
        $from = $_GET['frm'];
        $warehouse_id = (int) $_GET['warehouse_id'];
        $searchTerm = $_GET['term'];
       // $condition = 'isActive = "Y" AND ( inventory_item_type =1 OR inventory_item_type=3) AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")'; old condition

        $condition = 'isActive = "Y" AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        $model = new Store();
        $model = $model->findAll(array('condition' => $condition, 'limit' => 5));
        $i = 0;
        foreach ($model as $eachModel) {
            //$warehouse_id = (int)Yii::app()->user->getState('user_warehouse_id');
            if ($warehouse_id > 0) {
                $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $eachModel->id . ' AND warehouse_id=' . (int) $warehouse_id)->queryScalar();
            } else {
                $availble_qty = $eachModel->totalQuantity - (float) $eachModel->total_allocated_quantity;
            }

            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number . ' : ' . $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $data[$i]['free_qty'] = (float) $availble_qty;
            $data[$i]['rate'] = $eachModel->rate;
            $data[$i]['warehouse_id'] = $warehouse_id;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionAppend()
    {
        $id = Yii::app()->request->getparam("id");
        $i = Yii::app()->request->getparam("order");
        $model = new InventoryGoodsIssueItem();
        $data = ProductLocation::getProductWarehouses($id);
        $drop = CHtml::activedropDownList($model, '[' . $i . ']product_location_id', $data, array('class' => 'go', 'prompt' => '--select--', 'title' => '--select--', 'data-label' => 'Location *', 'onChange' => 'getQuantity(this.id,this.value)'));
        $status = array("drop" => $drop);
        echo CJSON::encode($status);
    }

    /*     * copied by jisha from bouleward on 8-11-17* */

    public function actionGetTotal()
    {
        $product = $_POST['product_id'];
        $warehouse = $_POST['warehouse'];
        $status = array();
        if ($product > 0 && $warehouse > 0) {
            $loc = ProductLocation::model()->find(array('condition' => 'stock_id =' . $product . ' AND warehouse_id=' . $warehouse));
            if (!empty($loc))
                $status['total'] = $loc->quantity;
            else
                $status['total'] = 0;
        }
        echo CJSON::encode($status);
    }

    public function actionGetStockDetails()
    {

        $product_id = $_POST['product_id'];
        $quantity = $_POST['Qty'];
        $length = $_POST['length'];
        $stock_details = array(new MaterialReceiptStockDetails);

        if ((int) $product_id > 0) {
            $product = Store::model()->findBypk($product_id);
            $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id = ' . $product_id . ' AND quantity > 0'));
        }

        $table = '';
        if ($stock_details[0]->id > 0) {

            foreach ($stock_details as $each) {
                //                    $mod_alloc=new AllocatedMaterial();
                //                    $alloc_qty=$mod_alloc->find(array('select'=>'SUM(quantity)AS quantity ','condition'=>'product_id = '.$product_id.' AND warehouse_id ='.$each->warehousename->id))->quantity;
                //                    $free_qty=(float)((float)$each->quantity-(float)$alloc_qty);
                $class = '';
                if ($each->expiry_date != '0000-00-00') {
                    $expire = date('d/m/Y', strtotime($each->expiry_date));
                    if (strtotime($each->expiry_date) < strtotime(date('Y-m-d'))) {
                        $class = 'bg-danger';
                    }
                } else {
                    $expire = '-';
                }
                if ($each->stock_affect_date != '0000-00-00') {
                    $purchased = date('d/m/Y', strtotime($each->stock_affect_date));
                } else {
                    $purchased = '-';
                }

                $table .= '<tr class="' . $class . ' TR-' . $length . '">';
                $table .= '<td>' . $each->warehousename->warehouse_name . '</td>';
                $table .= '<td>' . $product->part_number . CHtml::hiddenfield('Data[' . $length . '][product_id]', $product_id) . CHtml::hiddenfield('Data[' . $length . '][material_receipt_id]', $each->id) . '</td>';
                $table .= '<td>' . $each->rack->name . CHtml::hiddenfield('Data[' . $length . '][rack_id]', $each->rack_id) . '</td>';
                $table .= '<td>' . $each->bin->name . CHtml::hiddenfield('Data[' . $length . '][bin_id]', $each->bin_id) . '</td>';
                $table .= '<td>' . $each->batch_no . '</td>';
                $table .= '<td>' . $each->serial_no . '</td>';
                $table .= '<td>' . $purchased . '</td>';
                $table .= '<td>' . $expire . '</td>';
                $table .= '<td>' . CHtml::textfield('Data[' . $length . '][bill_of_exit]', '', array('class' => 'form-control')) . '</td>';
                $table .= '<td>' . CHtml::textfield('Data[' . $length . '][qty_available]', $each->quantity, array('class' => 'form-control text-right', 'readonly' => 'readonly')) . '</td>';
                $table .= '<td>' . CHtml::textfield('Data[' . $length . '][picked_qty]', '', array('class' => 'form-control text-right', 'onkeyup' => 'verifyQty(this.id,this.value);')) . '</td>';
                $table .= '</tr>';
                $length++;
            }
        } else {
            if ($length == 0)
                $table .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }

        echo $table;
    }

    public function actionGetSortedStockDetails()
    {

        $products = array();
        if (is_array($_POST['products'])) {
            foreach ($_POST['products'] as $i => $each) {
                $products[$i] = (int) $each;
            }
        }

        $attr = $_POST['attr'];

        if ($_POST['toggle'] == 1)
            $toggle = 'DESC';
        else
            $toggle = 'ASC';


        if (!empty($products))
            $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id IN (' . implode(',', $products) . ') AND quantity > 0', 'order' => $attr . ' ' . $toggle));
        else
            $stock_details = array(new MaterialReceiptStockDetails);

        $table = '';
        if ($stock_details[0]->id > 0) {

            foreach ($stock_details as $length => $each) {

                $class = '';
                if ($each->expiry_date != '0000-00-00') {
                    $expire = date('d/m/Y', strtotime($each->expiry_date));
                    if (strtotime($each->expiry_date) < strtotime(date('Y-m-d'))) {
                        $class = 'bg-danger';
                    }
                } else {
                    $expire = '-';
                }
                if ($each->stock_affect_date != '0000-00-00') {
                    $purchased = date('d/m/Y', strtotime($each->stock_affect_date));
                } else {
                    $purchased = '-';
                }

                $table .= '<tr class="' . $class . ' TR-' . $length . '">';
                $table .= '<td>' . $each->warehousename->warehouse_name . '</td>';
                $table .= '<td>' . $each->product->part_number . CHtml::hiddenfield('Data[' . $length . '][product_id]', $each->product_id) . CHtml::hiddenfield('Data[' . $length . '][material_receipt_id]', $each->id) . '</td>';
                $table .= '<td>' . $each->rack->name . CHtml::hiddenfield('Data[' . $length . '][rack_id]', $each->rack_id) . '</td>';
                $table .= '<td>' . $each->bin->name . CHtml::hiddenfield('Data[' . $length . '][bin_id]', $each->bin_id) . '</td>';
                $table .= '<td>' . $each->batch_no . '</td>';
                $table .= '<td>' . $each->serial_no . '</td>';
                $table .= '<td>' . $purchased . '</td>';
                $table .= '<td>' . $expire . '</td>';
                $table .= '<td>' . CHtml::textfield('Data[' . $length . '][bill_of_exit]', '', array('class' => 'form-control')) . '</td>';
                $table .= '<td>' . CHtml::textfield('Data[' . $length . '][qty_available]', $each->quantity, array('class' => 'form-control text-right', 'readonly' => 'readonly')) . '</td>';
                $table .= '<td>' . CHtml::textfield('Data[' . $length . '][picked_qty]', '', array('class' => 'form-control text-right', 'onkeyup' => 'verifyQty(this.id,this.value);')) . '</td>';
                $table .= '</tr>';
                $length++;
            }
        } else {
            if ($length == 0)
                $table .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }

        echo $table;
    }

    /* jo */

    public function actionGetunitdrop()
    {
        $row = $_POST['row_field'];
        $product = $_POST['product_id'];
        $drop = array();
        $modelOrder = new InventoryGoodsIssueItem;
        if ($product > 0) {
            $modelOrder->unit = UnitOfMeasurement::getBaseunit($product);
            $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit", UnitOfMeasurement::getUnits($product), array('class' => 'unit go', 'onchange' => 'getFactor(this.id,this.value)'));
        }
        echo CJSON::encode($drop);
    }

    public function actionGetFactor()
    {
        $factor = 1;
        if ((int) $_POST['value'] > 0) {
            $factor = UnitOfMeasurement::getFactor($_POST['value']);
        }
        echo $factor;
    }

    public function actionPrintPDF()
    {

        //$model = new PurchasingRequisition();
        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = InventoryGoodsIssue::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.issues_print', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output("GoodsIssue.pdf", 'I');
    }


    public function actionGetLeadOwners()
    {
        $warehouseId = Yii::app()->request->getPost('warehouse_id');
        $warehouse = MasInventoryWarehouse::model()->findByPk($warehouseId);

        // Check if warehouse exists and code is RW
        if (!$warehouse ||  $warehouse->warehouse_type != 'M') {
            echo '<select><option value="">No Lead Owners (Not RW)</option></select>';
            Yii::app()->end();
        }

        // Fetch lead owners
        $leadOwners = User::getUser();

        // Render dropdown (no form-control class)
        echo CHtml::activeDropDownList(
            new InventoryGoodsIssue(),
            'lead_owner_id',
            $leadOwners,
            array(
                'prompt' => '--Select--',
                'data-label' => 'Technician'
                //',onchange' => 'js:transferGoodsDetails(this.value);'
            )
        );
    }




    /* end */
}
