<?php

class InventoryController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Service', 'Create', 'GetList', 'CreateService', 'GetServiceList', 'Save', 'SaveService', 'SaveEquipment',
                    'UploadInventoryImage', 'DeleteImage', 'CheckExistance', 'History', 'GetHistory', 'StockHelper', 'PrintSalesPriceListPDF', 'DeleteInvItem',
                    'purchaseOrderDetails', 'GetDetails', 'GetTabDetails', 'AddSerialNo', 'FetchSerialNoItems', 'SaveSerialNo', 'RemoveSerialNo', 'FetchRemoveSerialNoItems', 'SaveRemoveSerialNo',
                    'AddBatchNo', 'FetchBatchItems', 'SaveAddBatchNo', 'SaveRemoveBatchNo', 'AddBatchSplitDetails', 'editserialno', 'updateserialno', 'CreateService', 'GetRawMaterialList', 'RawMaterial',
                    'BatchSplit', 'GetProductBatchNo', 'fetchBatchNoItems', 'saveBatchSplit', 'CheckProductInQC', 'GetSearchServiceItems', 'LoadsalepurchaseHistory', 'LoadsalepurchaseHistory', 'GetAvaibaleQty',
                    'GetSerialNoList', 'ChangeSerialNo', 'GetLocationDetails', 'GetdemoPartnumber', 'GetMachineOnly', 'Memo', 'GetMemoList', 'SaveMemo', 'Dummy', 'GetDummyList', 'SaveDummy', 'GetPurchaseHistoryList',
                    'ApproveInventoryItem', 'ViewExpiryList', 'AllocateMaterials', 'SaveAllocateMaterial',
                    'BlockInventoryItem', 'DeleteUOMItem', 'PrintInventoryBarcode', 'GetWarehouseProduct', 'selectBarcodeHeading', 'Equipment', 'GetEquipmentList'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users$model
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

 public function actionIndex()
        {
            
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['inventory_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['stock_view']) &&
            Yii::app()->user->havePermissionOn['inventory_menu_view'] && 
            Yii::app()->user->havePermissionOn['stock_view']
        )
    ) {
        $this->render('product_index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
        }

    public function actionService() {
        $this->render('service_index');
    }

    public function actionEquipment() {
        $this->render('equipment_index');
    }

    public function actionGetList() {
        $model = new Store();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $display_type = $_POST['display_type'];
        $brand_id = $_POST['brand_id'];
        //$approved = $_POST['approved'];
        $warehouse_id = (int) $_POST['warehouse_id'];
        $item_type = (int) $_POST['item_type'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'product_id',
            1 => 'part_number',
            2 => 'description',
            3 => 'bar_code',
            4 => 'brand',
            5 => 'quantity',
            6 => 'rate',
            7 => 'selling_price_1',
            8 => 'isActive',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        //$condition = 'inventory_item_type=1';
        $condition = '1=1';

        /* if($approved=='N'){
          $condition.=' AND isActive="N"';
          }
          else{
          $condition.=' AND isActive="Y"';
          } */

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = " (product_id LIKE '%" . $searchString . "%' OR part_number LIKE '%" . $searchString . "%' OR description LIKE '%" . $searchString . "%' OR bar_code LIKE '%" . $searchString . "%' OR brand LIKE '%" . $searchString . "%') ";
        }

        if ((int) $brand_id > 0)
            $condition .= ' AND brand_id = ' . (int) $brand_id;
        $qtycondition = '';
        if ($display_type == 1) {
            $qtycondition = ' WHERE quantity >0 ';
        }
        if ((int) $warehouse_id > 0) {
            $condition .= ' AND (warehouse_id = ' . (int) $warehouse_id . ' OR warehouse_id=0)';
        }
        if ((int) $item_type > 0) {
            $condition .= ' AND (inventory_item_type = ' . (int) $item_type . ')';
        }
        $query = 'SELECT * FROM (SELECT product_id,generic_id,part_number,description,bar_code,brand_id,brand,SUM(quantity) AS quantity,isActive,inventory_item_type,rate,selling_price_1,item_type
            FROM view_warehousewise_stock
            WHERE ' . $condition . '
            GROUP BY product_id
            )A' . $qtycondition . '
            ORDER BY ' . $orderBy . ' LIMIT ' . $limit . ' OFFSET ' . $offset . ' ';
        $countquery = 'SELECT COUNT(product_id) FROM (SELECT product_id,part_number,description,bar_code,brand_id,brand,SUM(quantity) AS quantity,isActive,inventory_item_type,rate,selling_price_1,item_type
            FROM view_warehousewise_stock
            WHERE ' . $condition . '
            GROUP BY product_id
            )A' . $qtycondition . '
            ORDER BY ' . $orderBy;

        //$query = 'SELECT * FROM view_all_stock_items WHERE '.$condition.' ORDER BY '.$orderBy.' LIMIT '.$limit.' OFFSET '.$offset.' ';
        //echo $query;
        $count = Yii::app()->db->createCommand($countquery)->queryScalar();
        //$count = Yii::app()->db->createCommand('SELECT COUNT(id) FROM view_all_stock_items WHERE '.$condition.' ')->queryScalar();
        $model = Yii::app()->db->createCommand($query)->queryAll();

        /* $count = $model->count(array('condition'=>$condition));
          $model = $model->findAll(array('condition'=>$condition)); */



        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
         $rowData = array();
        $m = 1;
        $gross_weight = 0;
        $type_array = array('1' => "stock item", '2'=> "service item", '3'=> "raw material",'4'=>"Equipments");
        foreach ($model as $row) {
            $arr_product_UOM = new UnitOfMeasurement();

            $arr_product_UOM = $arr_product_UOM->find(array('condition' => 'product_id=' . $row['product_id'], 'limit' => 4));
            //$quantity = number_format($availble_qty,2);
            $unit = $arr_product_UOM->name;

            $modelMasGeneric = new MasGeneric();
            $modelMasGeneric = $modelMasGeneric->findByPk($row['generic_id']);
            $generic_name = $modelMasGeneric->generic_name;

            //$rowData[]=array($row['id'],$m, $part_no, $row['generic_name'], '<span class="info-btn" title="'.$row['description'].'">'.$row['description'].'</span> ', $row['brand'], (float) $row['quantity'], $row['unit'],$row['have_serial_no'],$row['machine_type'],$row['isActive'],$purchase_from,(int) Yii::app()->user->havePermissionOn["inv_detail_pohis_view"]);
            $rowData[] = array(
                $m,
                $row['part_number'],
                '<span class="info-btn" title="' . $row['description'] . '">' . $row['description'] . '</span> ',
                $generic_name,
                $row['brand'],
                $row['quantity'] . " " . $unit,
                number_format($row['rate'], 2),
                $row['item_type'],
                $row['product_id'],
                $row['isActive'],
            );
            $m++;
        }

        $data['data'] = $rowData;
        $data['q'] = $query;
        echo json_encode($data);
    }

    public function actionGetListOld() {
        $model = new Store();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $display_type = $_POST['display_type'];
        $brand_id = $_POST['brand_id'];
        $machine_type = $_POST['machine_type'];
        $approved = $_POST['approved'];
        $warehouse_id = (int) $_POST['warehouse_id'];

        //$machine_id = $_POST['machine_id'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'part_number',
            2 => 'description',
            3 => 'capacity',
            4 => 'packing',
            5 => 'quantity',
            6 => 'quantity',
            7 => 'rate',
            8 => 'selling_price_1',
            9 => 'selling_price_2',
            10 => 'cbm',
            11 => 'weight',
            12 => 'id',
            13 => 'isActive',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 'type=1';

        if ($approved == 'N') {
            $condition .= ' AND isActive="N"';
        } else {
            $condition .= ' AND isActive="Y"';
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = "type=1 AND (id LIKE '%" . $searchString . "%' OR part_number LIKE '%" . $searchString . "%' OR description LIKE '%" . $searchString . "%' OR capacity LIKE '%" . $searchString . "%' OR oem_number LIKE '%" . $searchString . "%' OR brand LIKE '%" . $searchString . "%' OR unit LIKE '%" . $searchString . "%' OR generic_name LIKE '%" . $searchString . "%') ";
        }

        if ($brand_id > 0)
            $condition .= ' AND brand_id = ' . $brand_id;

        if ($display_type == 1) {
            $condition .= ' AND quantity >0';
        }
        /* if($warehouse_id>0){
          $condition .= ' AND ('.$warehouse_id. ' IN (item_warehouse) OR )';
          } */

        $query = 'SELECT * FROM view_all_stock_items WHERE ' . $condition . ' ORDER BY ' . $orderBy . ' LIMIT ' . $limit . ' OFFSET ' . $offset . ' ';
        //echo $query;
        $count = Yii::app()->db->createCommand('SELECT COUNT(id) FROM view_all_stock_items WHERE ' . $condition . ' ')->queryScalar();
        $model = Yii::app()->db->createCommand($query)->queryAll();

        /* $count = $model->count(array('condition'=>$condition));
          $model = $model->findAll(array('condition'=>$condition)); */



        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        $gross_weight = 0;
        foreach ($model as $row) {

            $storeModel = new store();
            $storeModel = $storeModel->findbyPk($row['id']);

            $second_unit_factor = $row['second_unit_factor'];
            if ((int) $second_unit_factor == 0) {
                $second_unit_factor = 1;
            }

            if ((int) $row['weight'] > 0) {
                $weight = $row['weight'];
            } else {
                $weight = 0;
            }

            $gross_weight = (($row['quantity'] / $second_unit_factor) * $weight);

            $part_no = $row['part_number'];
            $arr_price_list = SalesPriceGroup::model()->find(array('condition' => 'product_id=' . (int) $row['id']));
            $sales_price = $arr_price_list->sales_price;
            $sales_price1 = '';

            $modelMasInventoryWarehouse = new MasInventoryWarehouse();

            $damage_warehouse_id = $modelMasInventoryWarehouse->find(array('condition' => 'warehouse_code="DAM"'))->id;

            $SQL = "SELECT SUM(quantity * unit_factor) AS damage_quantity FROM erp_stock_ledger WHERE product_id=" . (int) $row['id'] . ' AND warehouse_id=' . $damage_warehouse_id;
            //echo $SQL;
            $total_damage_qty = (float) Yii::app()->db->createCommand($SQL)->queryScalar();

            $total_qty = $row['quantity'] - $total_damage_qty;

            // -----------------------------
            //  $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id='.$row['id'].' AND warehouse_id='.(int)$warehouse_id)->queryScalar();


            $sql_data = 'SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $row['id'] . '';
            if ($warehouse_id > 0) {
                //$warehouse_id = (int)Yii::app()->user->getState('user_warehouse_id');
                $sql_data .= ' AND warehouse_id=' . $warehouse_id;
            }


            //echo $sql_data;
            $availble_qty = Yii::app()->db->createCommand($sql_data)->queryScalar();

            // -----------------------------


            $arr_product_UOM = new UnitOfMeasurement();

            $arr_product_UOM = $arr_product_UOM->find(array('condition' => 'product_id=' . $row['id'], 'limit' => 4));
            $quantity = number_format($availble_qty, 2);
            $unit = $arr_product_UOM->name;

            //$rowData[]=array($row['id'],$m, $part_no, $row['generic_name'], '<span class="info-btn" title="'.$row['description'].'">'.$row['description'].'</span> ', $row['brand'], (float) $row['quantity'], $row['unit'],$row['have_serial_no'],$row['machine_type'],$row['isActive'],$purchase_from,(int) Yii::app()->user->havePermissionOn["inv_detail_pohis_view"]);
            $rowData[] = array(
                $m,
                $part_no,
                '<span class="info-btn" title="' . $row['description'] . '">' . $row['description'] . '</span> ',
                $storeModel->bar_code,
                $row['brand'],
                $quantity . " " . $unit,
                $row['id'],
                $row['isActive']
            );
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetServiceList() {
        $model = new Store();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'part_number',
            1 => 'generic_name',
            2 => 'description',
            3 => 'brand_class_id',
            4 => 'default_warehouse_id',
            5 => 'inventory_item_type'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" AND inventory_item_type=2';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = "inventory_item_type=2 AND ( part_number LIKE '%" . $searchString . "%' OR description LIKE '%" . $searchString . "%' )";
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $m => $row) {

            $rowData[] = array($m + 1, $row['part_number'], $row['description'], $row->genericdetails->generic_name, $row['id'], $row['default_service_item']);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetEquipmentList() {
        $model = new Store();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'part_number',
            1 => 'generic_name',
            2 => 'description',
            3 => 'brand_class_id',
            4 => 'default_warehouse_id',
            5 => 'inventory_item_type'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" AND inventory_item_type=4';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = "inventory_item_type=2 AND ( part_number LIKE '%" . $searchString . "%' OR description LIKE '%" . $searchString . "%' )";
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $m => $row) {

            $rowData[] = array($m + 1, $row['part_number'], $row['description'], $row->genericdetails->generic_name, $row['id'], $row['default_service_item']);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $edit_flag = 0;
        $model = new Store();
        $id = (int) Yii::app()->request->getParam('id');
        $view = Yii::app()->request->getParam('view');
        $approved = Yii::app()->request->getParam('approved');
        if ($id > 0) {
            $model = $model->findByPk($id);
            //$mod_his=StockLedger::model()->findAll(array('condition'=>'product_id='.(int)$id.' AND transaction_from!="OPENING_STOCK"'));
            $mod_his = StockLedger::model()->findAll(array('condition' => 'product_id=' . (int) $id . ' '));
            //echo '<pre>';print_r($mod_his);
            if (!empty($mod_his)) {
                $edit_flag = 1;
            }
        }



        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render($view, array('model' => $model, 'approved' => $approved, 'edit_flag' => $edit_flag), false, false);
    }

    /* public function ChanageDB($database = MasCompany::DB_ACE){
      Yii::app()->db->setActive(false);
      Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $database;
      Yii::app()->db->tablePrefix = 'erp_';
      Yii::app()->db->setActive(true);
      } */

    public function actionSave() {
        $model = new Store();
        $scenario = '';
        if ((int) $_POST['Store']['id'] > 0) {

            $id = $_POST['Store']['id'];

            $model = $model->findByPk($id);
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d h:i:s');
            $scenario = 'update';
            $audit_type = 'UPDATED';
        } else {
            $scenario = 'add';
            $audit_type = 'CREATED';
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->scenario = 'add';
        }
        $model->attributes = $_POST['Store'];
        $model->part_number = $_POST['Store']['part_number'];
        $model->inventory_item_type = $_POST['Store']['inventory_item_type'];
        
        
        if ((float) $_POST['Store']['rate'] > 0)
            $model->rate = $_POST['Store']['rate'];

        if ($_POST['Store']['bar_code'] == '') {
            $model->bar_code = $model->part_number;
        }
        if ($_POST['Store']['oem_number'] == '') {
            $model->oem_number = $model->part_number;
        }
        if(!empty($_POST['Store']['markup_percent']))
        {
          $model->markup_percent= $_POST['Store']['markup_percent'];  
        }
        else{
            $model->markup_percent=1; 
          }
        
         if(!empty($_POST['Store']['mark_up_final_rate']))
        {
          $model->mark_up_final_rate= $_POST['Store']['mark_up_final_rate'];  
        }  
          
        $valid = $model->validate();
        if (is_array($_POST['UnitOfMeasurement'])) {
            $uom_flag = 0;
            $uom_factor_flag = 0;
            $uom_secondary_flag = 0;
            $uom_val = 0;

            $arr_uom = array();
            $arr_second_unit = array();
            $UOM = array(new UnitOfMeasurement);
            foreach ($_POST['UnitOfMeasurement'] as $i => $each) {
                if ($each['unit_id'] != '') {
                    if (in_array($each['unit_id'], $arr_uom)) {
                        $uom_flag = 1;
                    } else {
                        $arr_uom[] = $each['unit_id'];
                    }
                    if (in_array($each['unit_id'], $arr_second_unit)) {
                        $uom_secondary_flag = 1;
                    } else {
                        if ($each['is_secondary_unit'] == 'Y') {
                            $arr_second_unit[] = $each['unit_id'];
                        }
                    }
                    if ($each['factor'] < 0) {
                        $uom_factor_flag = 1;
                    }


                    if ((int) $each['id'] > 0) {
                        $UOM[$i] = UnitOfMeasurement::model()->findBypk($each['id']);
                    } else {
                        $UOM[$i] = new UnitOfMeasurement();
                    }

                    $UOM[$i]->attributes = $each;
                    $UOM[$i]->product_id = 0;
                    $UOM[$i]->unit_id = $each['unit_id'];
                    if ($each['factor'] == 0) {
                        $UOM[$i]->factor = 1;
                    }
                    if ($each['unit_id'] != "") {
                        $UOM[$i]->name = Unit::model()->findByPk($each['unit_id'])->symbol;
                    }
                    $UOM[$i]->base_unit = $_POST['Store']['unit_id'];
                    //code added by mereena on 21/07/2022 to update sales price

                    //end
                    $UOM[$i]->created_by = Yii::app()->user->id;
                    $UOM[$i]->created_date_time = date('Y-m-d H:i:s');
                    $valid = $UOM[$i]->validate() && $valid;
                }
            }
        }
        if (COUNT($arr_second_unit) > 1) {
            $uom_secondary_flag = 1;
            $valid = false;
        }

        /* echo $uom_secondary_flag;
          echo '<pre>';
          print_r($arr_second_unit);exit; */

        if ($valid && $uom_flag == 0 && $uom_factor_flag == 0 && $uom_secondary_flag == 0) {
            $model->save();
            $uom_id = 0;
            if (!empty($UOM)) {

                foreach ($UOM as $each) {
                    $each->product_id = $model->id;
                    if ($each->price == '') {
                        $each->price = 0;
                    }
                    $each->save(false);
                    $uom_id = $each->id;
                }
            }
            // -------------added by indhu 07_02_2023------------------
            /*if ($scenario == 'add') {
                $modelwarehouse = new MasInventoryWarehouse();

                $modelwarehouse = $modelwarehouse->findAll(array('condition' => 'isActive="Y"'));
                foreach ($modelwarehouse as $eachwarehouse) {
                    $modelreorder = new StockReorderLevel();
                    $modelreorder->product_id = $model->id;
                    $modelreorder->warehouse_id = $eachwarehouse->id;
                    $modelreorder->reorder_quantity = 0;
                    $modelreorder->created_by = Yii::app()->user->id;
                    $modelreorder->created_datetime = date('Y-m-d h:i:s');
                    $modelreorder->save(false);

                    // ------------stock ledger-------------------------
                    $stockLedger = new StockLedger;
                    $stockLedger->header_id = '';
                    $stockLedger->header_item_id = '';
                    $stockLedger->transaction_date = '2022-12-31';
                    $stockLedger->transaction_type = "IN";
                    $stockLedger->transaction_from = "OPENING_STOCK";
                    $stockLedger->product_id = $model->id;
                    $stockLedger->brand_id = $model->brand_class_id;
                    $stockLedger->cost_price = $model->rate;
                    $stockLedger->buying_price = $model->rate;
                    $stockLedger->unit_id = $uom_id;

                    $stockLedger->warehouse_id = $eachwarehouse->id;
                    $stockLedger->warehouse_name = $eachwarehouse->warehouse_name;
                    $stockLedger->created_by = Yii::app()->user->id;
                    $stockLedger->created_date = date('Y-m-d h:i:s');
                    $stockLedger->save(false);
                }
            }*/
            //end


            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);


            switch ($_POST['Store']['inventory_item_type']) {
                case '1':
                    AuditLog::saveAuditLogs(
                            'FINISHED_PRODUCTS',
                            Yii::app()->user->id,
                            $audit_type,
                            " with FP No: - {$model->id} & Part No: - {$_POST['Store']['part_number']}  "
                    );
                    break;
                case '3':
                    AuditLog::saveAuditLogs(
                            'RAW_MATERIAL',
                            Yii::app()->user->id,
                            $audit_type,
                            " with RM No: - {$model->id} & Part No: - {$_POST['Store']['part_number']}  "
                    );
                    break;
                default:
                    # code...
                    break;
            }

            // end audit log


            if ($scenario == 'add') {
                $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="19"'));
                Yii::import('application.controllers.front.MasternotificationController');
                if ($model_mail_setting->mail_required == 'Y') {
                    // MasternotificationController::sendmail(19,$model->id);
                }
                if ($model_mail_setting->notification_required == 'Y') {
                    // MasternotificationController::sendnotification(19,$model->id);
                }
                if ($model_mail_setting->sms_required == 'Y') {
                    // MasternotificationController::sendsms(19,$model->id);
                }
            }
        } else {
            $error2 = array();
            $error3 = array();
            $error4 = array();
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            if ($UOM[0]->name > 0)
                $error2 = json_decode(CActiveForm::validateTabular($UOM, '', false), true);

            if ($uom_flag == 1) {
                $error3[] = "UOM should be unique";
            }
            if ($uom_secondary_flag == 1) {
                $error3[] = "Secondary Unit should be unique";
            }
            if ($uom_factor_flag == 1) {
                $error3[] = "Factor should be greater than 0";
            }
            $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4));
            if ($error != '[]')
                echo $error;
        }
    }

    /* public function actionSave()
      {
      $model = new Store();
      $part_number_new='';
      $scenario='';
      if ( (int) $_POST['Store']['id'] > 0){

      $id = $_POST['Store']['id'];

      $model=$model->findByPk($id);
      $model->updated_by = Yii::app()->user->id;
      $model->updated_date_time = date('Y-m-d h:i:s');
      $edit_flag=1;
      $scenario='update';
      $audit_type = 'UPDATED';
      }else{
      $scenario='add';
      $audit_type = 'CREATED';
      $model->created_by = Yii::app()->user->id;
      $model->created_date_time = date('Y-m-d h:i:s');
      $model->scenario = 'add';
      $edit_flag=0;
      $model_max_partnumber= Store::model()->find(array('select' => 'max(id) as id','condition'=>'inventory_item_type="1" and brand_class_id="'.$_POST['Store']['brand_class_id'].'"'));
      if($model_max_partnumber->id!=''){
      $model_existing_part_no = Store::model()->findByPk($model_max_partnumber->id);
      $existing_part_no=  explode('-', $model_existing_part_no->part_number);
      $part_number_new=$existing_part_no[2]+1;
      if($part_number_new<=99999){
      $part_number_new= str_pad($part_number_new,5, "0", STR_PAD_LEFT);
      }
      }else{
      $part_number_new='00001';
      }
      $model_brand_class = ProductClass::model()->findByPk($_POST['Store']['brand_class_id']);
      $part_no='';
      $machine_type=$_POST['Store']['machine_type'];
      if($model_brand_class->id>0){
      $value_machine_type = ($machine_type=='M')? '02': '04';
      $brand_class_auto_generated_no=0;
      if(count($model_brand_class->auto_generated_no)==1){
      $brand_class_auto_generated_no= str_pad($model_brand_class->auto_generated_no,2, "0", STR_PAD_LEFT);
      } else {
      $brand_class_auto_generated_no=$model_brand_class->auto_generated_no;
      }
      $part_no=$brand_class_auto_generated_no.'-'.$value_machine_type.'-'.$part_number_new;
      }

      }
      $model->attributes=$_POST['Store'];
      $model->machine_id = $_POST['Store']['machine_id'];
      $model->html_description = $_POST['html_description'];
      $model->service_product_type ='NL';
      if( (float) $_POST['Store']['rate'] > 0 )
      $model->rate = $_POST['Store']['rate'];

      if(!$model->id>0){
      $model->part_number =$part_no;
      $part_number      = explode('-',$model->part_number);
      $mc_spare=$part_number[1];
      $value_machine_type = ($mc_spare=='02')? '01': '03';
      $model->hiring_part_number =$part_number[0].'-'.$value_machine_type.'-'.$part_number[2];
      }
      if($model->hiring_part_number==''){
      $part_number      = explode('-',$model->part_number);
      $mc_spare=$part_number[1];
      $value_machine_type = ($mc_spare=='01')? '02': '04';
      $model->hiring_part_number =$part_number[0].'-'.$value_machine_type.'-'.$part_number[2];
      }
      if($_POST['Store']['bar_code']==''){
      $model->bar_code=$model->part_number;
      }
      if($_POST['Store']['oem_number']==''){
      $model->oem_number=$model->part_number;
      }
      if(is_array($_POST['UnitOfMeasurement'])){
      foreach ($_POST['UnitOfMeasurement'] as $i => $each){
      if($each['name'] != ''){
      $UOM[$i] = new UnitOfMeasurement;
      if((int) $each['id'] > 0)
      $UOM[$i] = $UOM[$i]->findBypk($each['id']);
      $UOM[$i]->attributes = $each;
      $UOM[$i]->product_id = 0;
      if($each['isBase'] == "Y"){
      $UOM[$i]->name =  Unit::model()->findByPk($_POST['Store']['unit_id'])->symbol;
      }
      $UOM[$i]->base_unit  = $_POST['Store']['unit_id'];
      $UOM[$i]->created_by = Yii::app()->user->id;
      $UOM[$i]->created_date_time = date('Y-m-d H:i:s');
      $valid = $UOM[$i]->validate() && $valid;
      }
      }
      }

      if ( $model->validate() ){
      $jsonData['status'] = 'success';
      echo CJSON::encode($jsonData);
      $model->save();

      // inserting to audit log
      switch ($_POST['Store']['inventory_item_type']) {
      case '1':
      AuditLog::saveAuditLogs(
      'FINISHED_PRODUCTS',
      Yii::app()->user->id,
      $audit_type,
      " with FP No: - {$model->id} & Part No: - {$_POST['Store']['part_number']}  "
      );
      break;
      case '3':
      AuditLog::saveAuditLogs(
      'RAW_MATERIAL',
      Yii::app()->user->id,
      $audit_type,
      " with RM No: - {$model->id} & Part No: - {$_POST['Store']['part_number']}  "
      );
      break;
      default:
      # code...
      break;
      }

      // end audit log


      if($scenario=='add'){
      $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="19"'));
      Yii::import('application.controllers.front.MasternotificationController');
      if($model_mail_setting->mail_required=='Y'){
      // MasternotificationController::sendmail(19,$model->id);
      }
      if($model_mail_setting->notification_required=='Y'){
      // MasternotificationController::sendnotification(19,$model->id);
      }
      if($model_mail_setting->sms_required=='Y'){
      // MasternotificationController::sendsms(19,$model->id);
      }
      }
      if(!empty($UOM)){
      foreach($UOM as $each){
      $each->product_id = $model->id;
      $each->save();
      }
      }
      if($edit_flag==0){
      $default = new UnitOfMeasurement;
      $default->product_id = $model->id;
      $default->base_unit  = $_POST['Store']['unit_id'];
      $default->name =  Unit::model()->findByPk($_POST['Store']['unit_id'])->symbol;
      $default->factor = 1;
      $default->isBase = "Y";
      $default->created_by = Yii::app()->user->id;
      $default->created_date_time = date('Y-m-d H:i:s');
      $default->save(false);
      }
      if($edit_flag==0)
      {
      $this->ChanageDB(MasCompany::DB_ARK);
      $arkProduct = new Store;
      $arkProduct->id=$model->id;
      $arkProduct->attributes = $model->attributes;
      $arkProduct->save(false);
      $this->ChanageDB(MasCompany::DB_ACE);
      }
      else {
      $this->ChanageDB(MasCompany::DB_ARK);
      $arkProduct = Store::model()->findByPk($model->id);
      $arkProduct->attributes = $model->attributes;
      $arkProduct->save(false);
      $this->ChanageDB(MasCompany::DB_ACE);
      }
      // ACE ARK
      $this->ChanageDB(MasCompany::DB_ARK);
      $UOM=array();
      if(is_array($_POST['UnitOfMeasurement'])){
      foreach ($_POST['UnitOfMeasurement'] as $i => $each){
      if($each['name'] != ''){
      $UOM[$i] = new UnitOfMeasurement;
      if((int) $each['id'] > 0)
      $UOM[$i] = $UOM[$i]->findBypk($each['id']);
      $UOM[$i]->attributes = $each;
      $UOM[$i]->product_id = 0;
      if($each['isBase'] == "Y"){
      $UOM[$i]->name =  Unit::model()->findByPk($_POST['Store']['unit_id'])->symbol;
      }
      $UOM[$i]->base_unit  = $_POST['Store']['unit_id'];
      $UOM[$i]->created_by = Yii::app()->user->id;
      $UOM[$i]->created_date_time = date('Y-m-d H:i:s');
      }
      }
      }
      if(!empty($UOM)){
      foreach($UOM as $each){
      $each->product_id = $model->id;
      $each->save();
      }
      }
      if($edit_flag==0){
      $default = new UnitOfMeasurement;
      $default->product_id = $model->id;
      $default->base_unit  = $_POST['Store']['unit_id'];
      $default->name =  Unit::model()->findByPk($_POST['Store']['unit_id'])->symbol;
      $default->factor = 1;
      $default->isBase = "Y";
      $default->created_by = Yii::app()->user->id;
      $default->created_date_time = date('Y-m-d H:i:s');
      $default->save(false);
      }
      $this->ChanageDB(MasCompany::DB_ACE);

      }else{
      $error2 = array();
      $error1 = json_decode(CActiveForm::validate($model, '', false), true);
      if($UOM[0]->name > 0)
      $error2 = json_decode(CActiveForm::validateTabular($UOM, '', false), true);
      $error = CJSON::encode(array_merge_recursive($error1, $error2));
      if ($error != '[]')
      echo $error;
      }
      } */

    public function actionUploadInventoryImage($folder = null, $filename = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $field_id = "";
        if (isset($_GET['field_id'])) {
            $field_id = Yii::app()->request->getParam('field_id');
        }
        if (empty($filename)) {
            $filename = 'inventory_' . date('YmdHis');
        }

        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array("jpg", "jpeg", "gif", "png"); //array("jpg","jpeg","gif","exe","mov" and etc...
        $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder, FALSE, $filename);
        //$result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $imagename = Yii::app()->basePath . '/../uploads/inventoryimages/' . $fileName;
        $imagename_thumb = Yii::app()->basePath . '/../uploads/inventoryimages/thumbs/' . $fileName;
        Yii::import("ext.EPhpThumb.EPhpThumb");
        $thumb = new EPhpThumb();
        $thumb->init(); //this is needed
        //chain functions
        $thumb->create($imagename)->resize(120, 120)->save($imagename_thumb);
        echo $return; // it's array
    }

    public function actionDeleteImage() {
        $id = (int) $_POST['id'];
        $model = Store::model()->findByPk($id);
        if ($model->item_image != '') {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/inventoryimages/" . $model->item_image;
            if (file_exists($path)) {
                unlink($path);
            }
        }

        $model->item_image = '';
        $model->save(false);
        echo "success";
    }

    public function actionCheckExistance() {
        $terms = $_POST['item'];
        $term = ltrim($terms);
        $status = array();
        if ($term != '') {
            $store = Store::model()->findAll(array('condition' => 'part_number = "' . $term . '"'));
            if (!empty($store)) {
                $status['status'] = 'exist';
            } else {
                $status['status'] = 'not_exist';
            }
        }
        echo CJSON::encode($status);
    }

    public function actionStockHelper() {
        $product_id = (int) $_POST['id'];
        $this->renderPartial('stock_helper', array('id' => $product_id), false, true);
    }

    public function actionPrintSalesPriceListPDF() {
        $model = new Store();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0)
            $model = new Store();

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.pdf.inventory_price_list_individual', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mpdf->Output("PriceList.pdf", 'I');
    }

    public function actionpurchaseOrderDetails() {
        $product_id = (int) $_POST['id'];
        $this->renderPartial('purchase_order_helper', array('id' => $product_id), false, true);
    }

    public function actionGetDetails() {
        $product_id = (int) Yii::app()->request->getParam('product_id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('get_details', array('product_id' => $product_id), false, true);
    }

    public function actionGetTabDetails() {
        $id = (int) Yii::app()->request->getParam('id');
        $product_id = (int) Yii::app()->request->getParam('product_id');
        if ($id == 1) {
            $this->renderPartial('get_stock_helper_details', array('product_id' => $product_id), false, true);
        }
        if ($id == 2) {
            $this->renderPartial('get_allocation_details', array('product_id' => $product_id), false, true);
        }
        if ($id == 3) {
            $this->renderPartial('get_po_details', array('product_id' => $product_id), false, true);
        }
        if ($id == 4) {
            $this->renderPartial('get_so_details', array('product_id' => $product_id), false, true);
        }
        if ($id == 5) {
            $this->renderPartial('get_price_helper', array('id' => $product_id), false, true);
        }
        if ($id == 6) {
            $this->renderPartial('get_so_history', array('product_id' => $product_id), false, true);
        }
        if ($id == 7) {
            $this->renderPartial('get_po_history', array('product_id' => $product_id), false, true);
        }
        if ($id == 8) {
            $this->renderPartial('get_quote_rate', array('product_id' => $product_id), false, true);
        }
    }

    public function actionAddSerialNo() {
        $pid = (int) Yii::app()->request->getParam('pid');
        $total_qty_ace = Yii::app()->request->getParam('total_qty_ace');
        $total_qty_ark = Yii::app()->request->getParam('total_qty_ark');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('serial_no_form', array('pid' => $pid, 'total_qty_ace' => $total_qty_ace, 'total_qty_ark' => $total_qty_ark), false, false);
    }

    public function actionRemoveSerialNo() {
        $pid = (int) Yii::app()->request->getParam('pid');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('serial_no_form_remove', array('pid' => $pid), false, false);
    }

    public function actionFetchSerialNoItems() {
        $prefix = $_POST['prefix'];
        $product_id = $_POST['product_id'];
        $startfrom = $_POST['startfrom'];
        $increment = $_POST['increment'];

        $condition = 't.product_id ="' . $product_id . '" AND quantity > 0 AND t.isActive="Y"';
        $stock_details = array(new StockLedger);
        $ark_stock_details = array(new StockLedger);
        if ((int) $product_id > 0) {
            $stock_details = StockLedger::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));

            //code added by mereena on 26/03/2020
            $this->ChanageDB(MasCompany::DB_ARK);
            $ark_stock_details = StockLedger::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
            $this->ChanageDB(MasCompany::DB_ACE);
            //end
        }
        $data['table'] = '';
        $data['table'] .= '<table class="table table-hover table-bordered personal-task" id="serialno_items_table" style="margin-top : 10px;">
                            <tr>
                                <th>Sno</th>
                                <th>Serial No</th>
                            </tr>';
        if ($stock_details[0]->id > 0) {
            $sno = 1;
            $length = 0;
            foreach ($stock_details as $s => $rowitem) {
                $each_qty = $rowitem->quantity;
                if ($each_qty > 0) {
                    for ($s = 1; $s <= $each_qty; $s++) {
                        $data['table'] .= '<tr class="">
                                            <td>' . ($length + 1) . '</td>
                                            <td>' . CHtml::activeTextfield($rowitem, "[" . $length . "]serial_no", array('class' => 'form-control addserialno', 'onkeyup' => '', 'onkeypress' => '', 'value' => $prefix . "" . $startfrom))
                                . CHtml::activeHiddenfield($rowitem, "[" . $length . "]header_id")
                                . CHtml::activeHiddenfield($rowitem, "[" . $length . "]header_item_id")
                                //.CHtml::activeHiddenfield($rowitem, "[" . $length . "]material_receipt_date")
                                //.CHtml::activeHiddenfield($rowitem, "[" . $length . "]stock_affect_date")
                                . CHtml::activeHiddenfield($rowitem, "[" . $length . "]bill_of_entry")
                                //.CHtml::activeHiddenfield($rowitem, "[" . $length . "]bill_exit")
                                . CHtml::activeHiddenfield($rowitem, "[" . $length . "]warehouse_id")
                                . CHtml::activeHiddenfield($rowitem, "[" . $length . "]rack_id")
                                . CHtml::activeHiddenfield($rowitem, "[" . $length . "]bin_id")
                                . CHtml::activeHiddenfield($rowitem, "[" . $length . "]batch_no")
                                . CHtml::activeHiddenfield($rowitem, "[" . $length . "]manufacturing_date")
                                . CHtml::activeHiddenfield($rowitem, "[" . $length . "]expiry_date")
                                . CHtml::activeHiddenfield($rowitem, "[" . $length . "]transaction_type")
                                . CHtml::activeHiddenfield($rowitem, "[" . $length . "]rowno", array('value' => $rowitem->id))
                                . '</td>
                                        </tr>';
                        $startfrom = $startfrom + $increment;
                        $length++;
                    }
                }
            }
        } else {
            if ($length == 0)
                $data['table'] .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }
        $data['table'] .= '</table>';

        //code added by mereena on 26/03/2020

        $data['arktable'] = '';
        $data['arktable'] .= '<table class="table table-hover table-bordered personal-task" id="serialno_items_table_ark" style="margin-top : 10px;">
                            <tr>
                                <th>Sno</th>
                                <th>Serial No</th>
                            </tr>';
        if ($ark_stock_details[0]->id > 0) {
            $sno = 0;
            foreach ($ark_stock_details as $s => $rowarkitem) {
                $each_qty = $rowarkitem->quantity;
                if ($each_qty > 0) {
                    for ($s = 1; $s <= $each_qty; $s++) {
                        $data['arktable'] .= '<tr class="">
                                                                <td>' . ($sno + 1) . '</td>
                                                                <td>' . CHtml::activeTextfield($rowarkitem, "[" . $length . "]serial_no", array('class' => 'form-control addserialno', 'onkeyup' => '', 'onkeypress' => '', 'value' => $prefix . "" . $startfrom))
                                . CHtml::activeHiddenfield($rowarkitem, "[" . $length . "]header_id")
                                . CHtml::activeHiddenfield($rowarkitem, "[" . $length . "]header_item_id")
                                . CHtml::activeHiddenfield($rowarkitem, "[" . $length . "]bill_of_entry")
                                . CHtml::activeHiddenfield($rowarkitem, "[" . $length . "]warehouse_id")
                                . CHtml::activeHiddenfield($rowarkitem, "[" . $length . "]rack_id")
                                . CHtml::activeHiddenfield($rowarkitem, "[" . $length . "]bin_id")
                                . CHtml::activeHiddenfield($rowarkitem, "[" . $length . "]batch_no")
                                . CHtml::activeHiddenfield($rowarkitem, "[" . $length . "]manufacturing_date")
                                . CHtml::activeHiddenfield($rowarkitem, "[" . $length . "]expiry_date")
                                . CHtml::activeHiddenfield($rowarkitem, "[" . $length . "]transaction_type")
                                . CHtml::activeHiddenfield($rowarkitem, "[" . $length . "]rowno", array('value' => $rowarkitem->id))
                                . '</td>
                                                            </tr>';
                        $startfrom = $startfrom + $increment;
                        $length++;
                        $sno++;
                    }
                }
            }
        } else {
            if ($length == 0)
                $data['arktable'] .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }
        $data['arktable'] .= '</table>';

        //end


        echo CJSON::encode($data);
    }

    public function actionFetchRemoveSerialNoItems() {
        $product_id = $_POST['product_id'];
        $condition = 't.product_id ="' . $product_id . '" AND quantity > 0 AND t.isActive="Y"';
        $stock_details = array(new StockLedger);
        $ace_total_item_qty = 0;
        $ark_total_item_qty = 0;
        if ((int) $product_id > 0)
            $stock_details = StockLedger::model()->findAll(array('select' => '*, SUM(quantity) as quantity',
                'condition' => $condition, 'order' => 'id ASC',
                'group' => 'warehouse_id,rack_id,bin_id'));



        $data['table'] = '';
        $data['table'] .= '<table class="table table-hover table-bordered personal-task" id="serialno_remove_items_table" style="margin-top : 10px;">
                            <tr style="background-color: rgb(31,103,178);"><td colspan="11" style="color:white"><b>ACE</b></td></tr>
                            <tr>
                                <th>Sno</th>
                                <th>Warehoue</th>
                                <th>Rack</th>
                                <th>Bin</th>
                                <th>Qty</th>
                            </tr>';
        if ($stock_details[0]->id > 0) {
            $sno = 1;
            $length = 0;
            foreach ($stock_details as $rowitem) {
                $model_wh = MasInventoryWarehouse::model()->findBypk($rowitem->warehouse_id);
                $model_rack = MasInvRack::model()->findBypk($rowitem->rack_id);
                $model_bin = MasInvBin::model()->findBypk($rowitem->bin_id);
                $data['table'] .= '<tr class="">
                                        <td>' . ($length + 1) . '</td>
                                        <td>' . $model_wh->warehouse_name
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]header_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]header_item_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]bill_of_entry")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]warehouse_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]rack_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]bin_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]batch_no")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]manufacturing_date")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]expiry_date")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]quantity", array('value' => $rowitem->quantity))
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]transaction_type")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]rowno", array('value' => $rowitem->id))
                        . '</td>
                                        <td>' . $model_rack->name . '</td>
                                        <td>' . $model_bin->name . '</td>
                                        <td>' . $rowitem->quantity . '</td>
                                    </tr>';
                $length++;
                $ace_total_item_qty++;
            }
        } else {
            if ($length == 0)
                $data['table'] .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }
        $data['table'] .= '</table>';
        //code added by mereena on 26/03/2020

        $this->ChanageDB(MasCompany::DB_ARK);
        $ark_stock_details = StockLedger::model()->findAll(array('select' => '*, SUM(quantity) as quantity',
            'condition' => $condition, 'order' => 'id ASC',
            'group' => 'warehouse_id,rack_id,bin_id'));
        $data['arktable'] = '';
        $data['arktable'] .= '<table class="table table-hover table-bordered personal-task" id="serialno_remove_items_table_ark" style="margin-top : 10px;">
                            <tr style="background-color: rgb(31,103,178);"><td colspan="11" style="color:white"><b>ARK</b></td></tr>
                            <tr>
                                <th>Sno</th>
                                <th>Warehoue</th>
                                <th>Rack</th>
                                <th>Bin</th>
                                <th>Qty</th>
                            </tr>';
        if ($ark_stock_details[0]->id > 0) {
            $sno = 0;
            foreach ($ark_stock_details as $rowitem) {
                $this->ChanageDB(MasCompany::DB_ARK);
                $model_wh = MasInventoryWarehouse::model()->findBypk($rowitem->warehouse_id);
                $model_rack = MasInvRack::model()->findBypk($rowitem->rack_id);
                $model_bin = MasInvBin::model()->findBypk($rowitem->bin_id);
                $data['arktable'] .= '<tr class="">
                                        <td>' . ($sno + 1) . '</td>
                                        <td>' . $model_wh->warehouse_name
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]header_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]header_item_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]bill_of_entry")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]warehouse_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]rack_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]bin_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]batch_no")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]manufacturing_date")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]expiry_date")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]quantity", array('value' => $rowitem->quantity))
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]transaction_type")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]rowno", array('value' => $rowitem->id))
                        . '</td>
                                        <td>' . $model_rack->name . '</td>
                                        <td>' . $model_bin->name . '</td>
                                        <td>' . $rowitem->quantity . '</td>
                                    </tr>';
                $length++;
                $sno++;
                $ark_total_item_qty++;
            }
        } else {
            if ($ark_total_item_qty == 0)
                $data['arktable'] .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }
        $data['arktable'] .= '</table>';
        $this->ChanageDB(MasCompany::DB_ACE);
        //end
        $data['ace_total_item_qty'] = $ace_total_item_qty;
        $data['ark_total_item_qty'] = $ark_total_item_qty;

        echo CJSON::encode($data);
    }

    public function actionSaveSerialNo() {
        $product_id = $_POST['product_id'];
        //code added by mereena on 26/03/2020
        $total_qty_ace = $_POST['total_qty_ace'];
        $total_qty_ark = $_POST['total_qty_ark'];
        //end
        if (!empty($_POST['StockLedger'])) {
            $k = 0;
            foreach ($_POST['StockLedger'] as $i => $item) {
                if (!empty($item['serial_no'])) {

                    if ($i < $total_qty_ace) {
                        $modelProLocDetails[$i] = new StockLedger;
                        $modelProLocDetails[$i]->attributes = $_POST['StockLedger'][$i];
                        $modelProLocDetails[$i]->header_id = $item['header_id'];
                        $modelProLocDetails[$i]->header_item_id = $item['header_item_id'];
                        $modelProLocDetails[$i]->product_id = $product_id;
                        $modelProLocDetails[$i]->bill_of_entry = $item['bill_of_entry'];
                        $modelProLocDetails[$i]->warehouse_id = $item['warehouse_id'];
                        $modelProLocDetails[$i]->rack_id = $item['rack_id'];
                        $modelProLocDetails[$i]->bin_id = $item['bin_id'];
                        $modelProLocDetails[$i]->batch_no = $item['batch_no'];
                        $modelProLocDetails[$i]->serial_no = $item['serial_no'];
                        $modelProLocDetails[$i]->quantity = 1;
                        $modelProLocDetails[$i]->transaction_type = $item['transaction_type'];
                        $modelProLocDetails[$i]->created_by = Yii::app()->user->id;
                        $modelProLocDetails[$i]->created_date = date('Y-m-d');
                        $modelProLocDetails[$i]->isActive = "Y";
                        $modelProLocDetails[$i]->manufacturing_date = $item['manufacturing_date'];
                        $modelProLocDetails[$i]->expiry_date = $item['expiry_date'];
                        $modelProLocDetails[$i]->rowno = $item['rowno'];
                        $valid = $modelProLocDetails[$i]->validate();
                    } else {
                        $modelArkProLocDetails[$k] = new StockLedger;
                        $modelArkProLocDetails[$k]->attributes = $_POST['StockLedger'][$i];
                        $modelArkProLocDetails[$k]->header_id = $item['header_id'];
                        $modelArkProLocDetails[$k]->header_item_id = $item['header_item_id'];
                        $modelArkProLocDetails[$k]->product_id = $product_id;
                        $modelArkProLocDetails[$k]->bill_of_entry = $item['bill_of_entry'];
                        $modelArkProLocDetails[$k]->warehouse_id = $item['warehouse_id'];
                        $modelArkProLocDetails[$k]->rack_id = $item['rack_id'];
                        $modelArkProLocDetails[$k]->bin_id = $item['bin_id'];
                        $modelArkProLocDetails[$k]->batch_no = $item['batch_no'];
                        $modelArkProLocDetails[$k]->serial_no = $item['serial_no'];
                        $modelArkProLocDetails[$k]->quantity = 1;
                        $modelArkProLocDetails[$k]->transaction_type = $item['transaction_type'];
                        $modelArkProLocDetails[$k]->created_by = Yii::app()->user->id;
                        $modelArkProLocDetails[$k]->created_date = date('Y-m-d');
                        $modelArkProLocDetails[$k]->isActive = "Y";
                        $modelArkProLocDetails[$k]->manufacturing_date = $item['manufacturing_date'];
                        $modelArkProLocDetails[$k]->expiry_date = $item['expiry_date'];
                        $modelArkProLocDetails[$k]->rowno = $item['rowno'];
                        $k++;

                        //$valid = $valid & $modelArkProLocDetails[$k]->validate();
                    }
                }
            }
        }
        /* echo '<pre>';
          print_r($modelProLocDetails);

          print_r($modelArkProLocDetails);
          exit; */
        if ($valid) {


            if (!empty($modelProLocDetails)) {

                $history = new SerialnoChangeHistory();
                $history->product_id = $product_id;
                $history->change_from = "N";
                $history->change_to = "Y";
                $history->created_by = Yii::app()->user->id;
                $history->created_datetime = date('Y-m-d h:i:s');
                $history->save(false);

                Store::model()->updateByPK($product_id, array('have_serial_no' => 'Y'));
                $this->ChanageDB(MasCompany::DB_ARK);
                //update serial no yes in ARK
                Store::model()->updateByPK($product_id, array('have_serial_no' => 'Y'));
                $this->ChanageDB(MasCompany::DB_ACE);
                $model_pl = StockLedger::model()->findAll(array('condition' => 'product_id="' . $product_id . '" AND quantity>0'));
                if (!empty($model_pl)) {
                    foreach ($model_pl as $each_mr) {

                        /*                         * ***************** Stock Ledger ****************************** */
                        $modelStore = Store::model()->findBypk($each_item['product_id']);
                        if ($each_mr->id > 0) {
                            $modelStockLedger = StockLedger::model()->find(array('condition' => 'product_location_id=' . $each_mr->id));
                            $cost_price = $modelStockLedger->cost_price;
                        }
                        $stockLedger = new StockLedger;
                        $stockLedger->header_id = $each_mr['header_id'];
                        $stockLedger->header_item_id = $each_mr['header_item_id'];
                        $stockLedger->transaction_date = $modelInvoice->invoice_date;
                        $stockLedger->transaction_type = "CHANGE_SERIALNO";
                        $stockLedger->product_id = $each_mr['product_id'];
                        $stockLedger->quantity = -1 * $each_mr->quantity;
                        $stockLedger->product_location_id = $each_mr->id;
                        $stockLedger->unit_id = $modelStore['unit_id'];
                        $stockLedger->warehouse_id = $each_mr['warehouse_id'];
                        $stockLedger->rack_id = $each_mr['rack_id'];
                        $stockLedger->bin_id = $each_mr['bin_id'];
                        $stockLedger->created_by = Yii::app()->user->id;
                        $stockLedger->created_date = date('Y-m-d h:i:s');
                        $stockLedger->cost_price = $cost_price;
                        $stockLedger->save(false);
                        /*                         * ***************** End Stock Ledger ****************************** */
                        /*                         * ***************   history  ******************** */
                        $modelHistory = new SerialnoChangeHistoryDetails();
                        $modelHistory->history_id = $history->id;
                        $modelHistory->product_location = $each_mr->id;
                        //$modelHistory->old_stock_ledger_ids = $modelStockLedger->id;
                        $modelHistory->stock_ledger_id = $stockLedger->id;
                        $modelHistory->qty = $each_mr->quantity;
                        $modelHistory->action = "U";
                        $modelHistory->save(false);
                        /*                         * ***************** End History ****************************** */
                    }
                    StockLedger::model()->updateAll(array('quantity' => '0', 'isActive' => 'N'), 'product_id =' . $product_id);
                }

                $new_product_location_id = array();
                foreach ($modelProLocDetails as $each_item) {
                    $id = $each_item['rowno'];
                    $each_item->save(false);
                    $new_product_location_id[] = $each_item->id;

                    $modelStore = Store::model()->findBypk($each_item['product_id']);

                    if ($id > 0) {
                        $modelStockLedger = StockLedger::model()->find(array('condition' => 'product_location_id=' . $id));
                        $cost_price = $modelStockLedger->cost_price;
                    }
                    $stockLedger = new StockLedger;
                    $stockLedger->header_id = $each_item['header_id'];
                    $stockLedger->header_item_id = $each_item['header_item_id'];
                    $stockLedger->transaction_date = $modelInvoice->invoice_date;
                    $stockLedger->transaction_type = "CHANGE_SERIALNO";
                    $stockLedger->product_id = $each_item['product_id'];
                    $stockLedger->quantity = 1;
                    $stockLedger->product_location_id = $each_item->id;
                    $stockLedger->unit_id = $modelStore['unit_id'];
                    $stockLedger->warehouse_id = $each_item['warehouse_id'];
                    $stockLedger->rack_id = $each_item['rack_id'];
                    $stockLedger->bin_id = $each_item['bin_id'];
                    $stockLedger->created_by = Yii::app()->user->id;
                    $stockLedger->created_date = date('Y-m-d h:i:s');
                    $stockLedger->cost_price = $cost_price;
                    $stockLedger->save(false);

                    /*                     * ***************   history  ******************** */
                    $modelHistory = new SerialnoChangeHistoryDetails();
                    $modelHistory->history_id = $history->id;
                    $modelHistory->product_location = $each_item->id;
                    //$modelHistory->old_stock_ledger_ids = $modelStockLedger->id;
                    $modelHistory->stock_ledger_id = $stockLedger->id;
                    $modelHistory->qty = 1;
                    $modelHistory->action = "A";
                    $modelHistory->save(false);
                    /*                     * ***************** End History ****************************** */
                }
            }

            //code added by mereena on 26/03/2020




            if (!empty($modelArkProLocDetails)) {

                //code added by mereena on 26/03/2020
                $this->ChanageDB(MasCompany::DB_ARK);

                $history = new SerialnoChangeHistory();
                $history->product_id = $product_id;
                $history->change_from = "N";
                $history->change_to = "Y";
                $history->created_by = Yii::app()->user->id;
                $history->created_datetime = date('Y-m-d h:i:s');
                $history->save(false);

                $model_pl = StockLedger::model()->findAll(array('condition' => 'product_id="' . $product_id . '" AND quantity>0'));
                if (!empty($model_pl)) {
                    foreach ($model_pl as $each_mr) {

                        /*                         * ***************** Stock Ledger ****************************** */
                        $modelStore = Store::model()->findBypk($each_item['product_id']);
                        if ($each_mr->id > 0) {
                            $modelStockLedger = StockLedger::model()->find(array('condition' => 'product_location_id=' . $each_mr->id));
                            $cost_price = $modelStockLedger->cost_price;
                        }
                        $stockLedger = new StockLedger;
                        $stockLedger->header_id = $each_mr['header_id'];
                        $stockLedger->header_item_id = $each_mr['header_item_id'];
                        $stockLedger->transaction_date = $modelInvoice->invoice_date;
                        $stockLedger->transaction_type = "CHANGE_SERIALNO";
                        $stockLedger->product_id = $each_mr['product_id'];
                        $stockLedger->quantity = -1 * $each_mr->quantity;
                        $stockLedger->product_location_id = $each_mr->id;
                        $stockLedger->unit_id = $modelStore['unit_id'];
                        $stockLedger->warehouse_id = $each_mr['warehouse_id'];
                        $stockLedger->rack_id = $each_mr['rack_id'];
                        $stockLedger->bin_id = $each_mr['bin_id'];
                        $stockLedger->created_by = Yii::app()->user->id;
                        $stockLedger->created_date = date('Y-m-d h:i:s');
                        $stockLedger->cost_price = $cost_price;
                        $stockLedger->save(false);
                        /*                         * ***************** End Stock Ledger ****************************** */
                        /*                         * ***************   history  ******************** */
                        $modelHistory = new SerialnoChangeHistoryDetails();
                        $modelHistory->history_id = $history->id;
                        $modelHistory->product_location = $each_mr->id;
                        //$modelHistory->old_stock_ledger_ids = $modelStockLedger->id;
                        $modelHistory->stock_ledger_id = $stockLedger->id;
                        $modelHistory->qty = $each_mr->quantity;
                        $modelHistory->action = "U";
                        $modelHistory->save(false);
                        /*                         * ***************** End History ****************************** */
                    }
                    StockLedger::model()->updateAll(array('quantity' => '0', 'isActive' => 'N'), 'product_id =' . $product_id);
                }

                $new_product_location_id = array();
                foreach ($modelArkProLocDetails as $each_item) {
                    $id = $each_item['rowno'];
                    $each_item->save(false);
                    $new_product_location_id[] = $each_item->id;

                    $modelStore = Store::model()->findBypk($each_item['product_id']);

                    if ($id > 0) {
                        $modelStockLedger = StockLedger::model()->find(array('condition' => 'product_location_id=' . $id));
                        $cost_price = $modelStockLedger->cost_price;
                    }
                    $stockLedger = new StockLedger;
                    $stockLedger->header_id = $each_item['header_id'];
                    $stockLedger->header_item_id = $each_item['header_item_id'];
                    $stockLedger->transaction_date = date('Y-m-d');
                    $stockLedger->transaction_type = "CHANGE_SERIALNO";
                    $stockLedger->product_id = $each_item['product_id'];
                    $stockLedger->quantity = 1;
                    $stockLedger->product_location_id = $each_item->id;
                    $stockLedger->unit_id = $modelStore['unit_id'];
                    $stockLedger->warehouse_id = $each_item['warehouse_id'];
                    $stockLedger->rack_id = $each_item['rack_id'];
                    $stockLedger->bin_id = $each_item['bin_id'];
                    $stockLedger->created_by = Yii::app()->user->id;
                    $stockLedger->created_date = date('Y-m-d h:i:s');
                    $stockLedger->cost_price = $cost_price;
                    $stockLedger->save(false);

                    /*                     * ***************   history  ******************** */
                    $modelHistory = new SerialnoChangeHistoryDetails();
                    $modelHistory->history_id = $history->id;
                    $modelHistory->product_location = $each_item->id;
                    //$modelHistory->old_stock_ledger_ids = $modelStockLedger->id;
                    $modelHistory->stock_ledger_id = $stockLedger->id;
                    $modelHistory->qty = 1;
                    $modelHistory->action = "A";
                    $modelHistory->save(false);
                    /*                     * ***************** End History ****************************** */
                }

                $this->ChanageDB(MasCompany::DB_ACE);
                //end
            }
            //end
            $jsonData['status'] = 'success';
            $product = Store::model()->findBypk($product_id);
            $jsonData['pid'] = $product_id;
            $jsonData['pname'] = $product->part_number;
            echo CJSON::encode($jsonData);
        } else {
            $error1 = array();
            if (!empty($modelProLocDetails)) {
                $error1 = json_decode(CActiveForm::validate($modelProLocDetails, '', false), true);
            }
            $error = CJSON::encode(array_merge_recursive($error1));
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionSaveRemoveSerialNo() {

        $product_id = $_POST['productid'];
        $ace_total_item_qty = $_POST['ace_total_item_qty'];
        $ark_total_item_qty = $_POST['ark_total_item_qty'];

        if (!empty($_POST['StockLedger'])) {

            $k = 0;
            foreach ($_POST['StockLedger'] as $i => $item) {
                if ($item['quantity'] > 0) {

                    if ($i < $ace_total_item_qty) {
                        $modelProLocDetails[$i] = new StockLedger;
                        $modelProLocDetails[$i]->attributes = $_POST['StockLedger'][$i];
                        $modelProLocDetails[$i]->header_id = $item['header_id'];
                        $modelProLocDetails[$i]->header_item_id = $item['header_item_id'];
                        $modelProLocDetails[$i]->product_id = $product_id;
                        $modelProLocDetails[$i]->bill_of_entry = $item['bill_of_entry'];
                        $modelProLocDetails[$i]->warehouse_id = $item['warehouse_id'];
                        $modelProLocDetails[$i]->rack_id = $item['rack_id'];
                        $modelProLocDetails[$i]->bin_id = $item['bin_id'];
                        $modelProLocDetails[$i]->batch_no = $item['batch_no'];
                        $modelProLocDetails[$i]->quantity = $item['quantity'];
                        $modelProLocDetails[$i]->transaction_type = $item['transaction_type'];
                        $modelProLocDetails[$i]->created_by = Yii::app()->user->id;
                        $modelProLocDetails[$i]->created_date = date('Y-m-d');
                        $modelProLocDetails[$i]->isActive = "Y";
                        $modelProLocDetails[$i]->manufacturing_date = $item['manufacturing_date'];
                        $modelProLocDetails[$i]->expiry_date = $item['expiry_date'];
                        $modelProLocDetails[$i]->rowno = $item['rowno'];
                        $valid = $modelProLocDetails[$i]->validate();
                    } else {
                        $modelArkProLocDetails[$k] = new StockLedger;
                        $modelArkProLocDetails[$k]->attributes = $_POST['StockLedger'][$i];
                        $modelArkProLocDetails[$k]->header_id = $item['header_id'];
                        $modelArkProLocDetails[$k]->header_item_id = $item['header_item_id'];
                        $modelArkProLocDetails[$k]->product_id = $product_id;
                        $modelArkProLocDetails[$k]->bill_of_entry = $item['bill_of_entry'];
                        $modelArkProLocDetails[$k]->warehouse_id = $item['warehouse_id'];
                        $modelArkProLocDetails[$k]->rack_id = $item['rack_id'];
                        $modelArkProLocDetails[$k]->bin_id = $item['bin_id'];
                        $modelArkProLocDetails[$k]->batch_no = $item['batch_no'];
                        $modelArkProLocDetails[$k]->quantity = $item['quantity'];
                        $modelArkProLocDetails[$k]->transaction_type = $item['transaction_type'];
                        $modelArkProLocDetails[$k]->created_by = Yii::app()->user->id;
                        $modelArkProLocDetails[$k]->created_date = date('Y-m-d');
                        $modelArkProLocDetails[$k]->isActive = "Y";
                        $modelArkProLocDetails[$k]->manufacturing_date = $item['manufacturing_date'];
                        $modelArkProLocDetails[$k]->expiry_date = $item['expiry_date'];
                        $modelArkProLocDetails[$k]->rowno = $item['rowno'];
                        $k++;

                        //$valid = $valid & $modelArkProLocDetails[$k]->validate();
                    }





                    //$valid = $modelProLocDetails[$i]->validate();
                }
            }
        }



        if ($valid) {
            if (!empty($modelProLocDetails)) {


                $history = new SerialnoChangeHistory();
                $history->product_id = $product_id;
                $history->change_from = "Y";
                $history->change_to = "N";
                $history->created_by = Yii::app()->user->id;
                $history->created_datetime = date('Y-m-d h:i:s');
                $history->save(false);

                Store::model()->updateByPK($product_id, array('have_serial_no' => 'N'));
                $model_pl = StockLedger::model()->findAll(array('condition' => 'product_id="' . $product_id . '" AND quantity>0'));
                if (!empty($model_pl)) {
                    foreach ($model_pl as $each_mr) {

                        /*                         * ***************** Stock Ledger ****************************** */
                        $modelStore = Store::model()->findBypk($each_item['product_id']);
                        if ($each_mr->id > 0) {
                            $modelStockLedger = StockLedger::model()->find(array('condition' => 'product_location_id=' . $each_mr->id));
                            $cost_price = $modelStockLedger->cost_price;
                        }
                        $stockLedger = new StockLedger;
                        $stockLedger->header_id = $each_mr['header_id'];
                        $stockLedger->header_item_id = $each_mr['header_item_id'];
                        $stockLedger->transaction_date = $modelInvoice->invoice_date;
                        $stockLedger->transaction_type = "CHANGE_SERIALNO";
                        $stockLedger->product_id = $each_mr['product_id'];
                        $stockLedger->quantity = -1 * $each_mr->quantity;
                        $stockLedger->product_location_id = $each_mr->id;
                        $stockLedger->unit_id = $modelStore['unit_id'];
                        $stockLedger->warehouse_id = $each_mr['warehouse_id'];
                        $stockLedger->rack_id = $each_mr['rack_id'];
                        $stockLedger->bin_id = $each_mr['bin_id'];
                        $stockLedger->created_by = Yii::app()->user->id;
                        $stockLedger->created_date = date('Y-m-d h:i:s');
                        $stockLedger->cost_price = $cost_price;
                        $stockLedger->save(false);
                        /*                         * ***************** End Stock Ledger ****************************** */
                        /*                         * ***************   history  ******************** */
                        $modelHistory = new SerialnoChangeHistoryDetails();
                        $modelHistory->history_id = $history->id;
                        $modelHistory->product_location = $each_mr->id;
                        //$modelHistory->old_stock_ledger_ids = "";
                        $modelHistory->stock_ledger_id = $stockLedger->id;
                        $modelHistory->qty = $each_mr->quantity;

                        $modelHistory->action = "U";
                        $modelHistory->created_by = Yii::app()->user->id;
                        ;
                        $modelHistory->created_date_time = date('Y-m-d H:i:s');
                        $modelHistory->save(false);
                        /*                         * ***************** End History ****************************** */
                    }
                    StockLedger::model()->updateAll(array('quantity' => '0', 'serial_no' => '', 'isActive' => 'N'), 'product_id =' . $product_id);
                }

                $new_product_location_id = array();
                foreach ($modelProLocDetails as $each_item) {

                    $id = $each_item['rowno'];
                    $qty = $each_item['quantity'];
                    $each_item->save(false);
                    $new_product_location_id[] = $each_item->id;

                    $modelStore = Store::model()->findBypk($each_item['product_id']);

                    if ($id > 0) {
                        $modelStockLedger = StockLedger::model()->find(array('condition' => 'product_location_id=' . $id));
                        $cost_price = $modelStockLedger->cost_price;
                    }
                    $stockLedger = new StockLedger;
                    $stockLedger->header_id = $each_item['header_id'];
                    $stockLedger->header_item_id = $each_item['header_item_id'];
                    $stockLedger->transaction_date = $modelInvoice->invoice_date;
                    $stockLedger->transaction_type = "CHANGE_SERIALNO";
                    $stockLedger->product_id = $each_item['product_id'];
                    $stockLedger->quantity = $each_item['quantity'];
                    $stockLedger->product_location_id = $each_item->id;
                    $stockLedger->unit_id = $modelStore['unit_id'];
                    $stockLedger->warehouse_id = $each_item['warehouse_id'];
                    $stockLedger->rack_id = $each_item['rack_id'];
                    $stockLedger->bin_id = $each_item['bin_id'];
                    $stockLedger->created_by = Yii::app()->user->id;
                    $stockLedger->created_date = date('Y-m-d h:i:s');
                    $stockLedger->cost_price = $cost_price;
                    $stockLedger->save(false);

                    /*                     * ***************   history  ******************* */
                    $modelHistory = new SerialnoChangeHistoryDetails();
                    $modelHistory->history_id = $history->id;
                    $modelHistory->product_location = $each_item->id;
                    //$modelHistory->old_stock_ledger_ids = $modelStockLedger->id;
                    $modelHistory->stock_ledger_id = $stockLedger->id;
                    $modelHistory->qty = $qty;
                    $modelHistory->action = "A";
                    $modelHistory->created_by = Yii::app()->user->id;
                    ;
                    $modelHistory->created_date_time = date('Y-m-d H:i:s');
                    $modelHistory->save(false);

                    /*                     * ***************  End history  ******************* */
                }
                if (is_array($new_product_location_id)) {
                    //$arr_new_product_location_id = implode(",",array_filter($new_product_location_id));
                }
            }


            //code added by mereena on 26/03/2020
            if (!empty($modelArkProLocDetails)) {

                $this->ChanageDB(MasCompany::DB_ARK);
                $history = new SerialnoChangeHistory();
                $history->product_id = $product_id;
                $history->change_from = "Y";
                $history->change_to = "N";
                $history->created_by = Yii::app()->user->id;
                $history->created_datetime = date('Y-m-d h:i:s');
                $history->save(false);

                Store::model()->updateByPK($product_id, array('have_serial_no' => 'N'));
                $model_pl = StockLedger::model()->findAll(array('condition' => 'product_id="' . $product_id . '" AND quantity>0'));
                if (!empty($model_pl)) {
                    foreach ($model_pl as $each_mr) {

                        /*                         * ***************** Stock Ledger ****************************** */
                        $modelStore = Store::model()->findBypk($each_item['product_id']);
                        if ($each_mr->id > 0) {
                            $modelStockLedger = StockLedger::model()->find(array('condition' => 'product_location_id=' . $each_mr->id));
                            $cost_price = $modelStockLedger->cost_price;
                        }
                        $stockLedger = new StockLedger;
                        $stockLedger->header_id = $each_mr['header_id'];
                        $stockLedger->header_item_id = $each_mr['header_item_id'];
                        $stockLedger->transaction_date = $modelInvoice->invoice_date;
                        $stockLedger->transaction_type = "CHANGE_SERIALNO";
                        $stockLedger->product_id = $each_mr['product_id'];
                        $stockLedger->quantity = -1 * $each_mr->quantity;
                        $stockLedger->product_location_id = $each_mr->id;
                        $stockLedger->unit_id = $modelStore['unit_id'];
                        $stockLedger->warehouse_id = $each_mr['warehouse_id'];
                        $stockLedger->rack_id = $each_mr['rack_id'];
                        $stockLedger->bin_id = $each_mr['bin_id'];
                        $stockLedger->created_by = Yii::app()->user->id;
                        $stockLedger->created_date = date('Y-m-d h:i:s');
                        $stockLedger->cost_price = $cost_price;
                        $stockLedger->save(false);
                        /*                         * ***************** End Stock Ledger ****************************** */
                        /*                         * ***************   history  ******************** */
                        $modelHistory = new SerialnoChangeHistoryDetails();
                        $modelHistory->history_id = $history->id;
                        $modelHistory->product_location = $each_mr->id;
                        //$modelHistory->old_stock_ledger_ids = "";
                        $modelHistory->stock_ledger_id = $stockLedger->id;
                        $modelHistory->qty = $each_mr->quantity;

                        $modelHistory->action = "U";
                        $modelHistory->created_by = Yii::app()->user->id;
                        ;
                        $modelHistory->created_date_time = date('Y-m-d H:i:s');
                        $modelHistory->save(false);
                        /*                         * ***************** End History ****************************** */
                    }
                    StockLedger::model()->updateAll(array('quantity' => '0', 'serial_no' => '', 'isActive' => 'N'), 'product_id =' . $product_id);
                }

                $new_product_location_id = array();
                foreach ($modelArkProLocDetails as $each_item) {

                    $id = $each_item['rowno'];
                    $qty = $each_item['quantity'];
                    $each_item->save(false);
                    $new_product_location_id[] = $each_item->id;

                    $modelStore = Store::model()->findBypk($each_item['product_id']);

                    if ($id > 0) {
                        $modelStockLedger = StockLedger::model()->find(array('condition' => 'product_location_id=' . $id));
                        $cost_price = $modelStockLedger->cost_price;
                    }
                    $stockLedger = new StockLedger;
                    $stockLedger->header_id = $each_item['header_id'];
                    $stockLedger->header_item_id = $each_item['header_item_id'];
                    $stockLedger->transaction_date = $modelInvoice->invoice_date;
                    $stockLedger->transaction_type = "CHANGE_SERIALNO";
                    $stockLedger->product_id = $each_item['product_id'];
                    $stockLedger->quantity = $each_item['quantity'];
                    $stockLedger->product_location_id = $each_item->id;
                    $stockLedger->unit_id = $modelStore['unit_id'];
                    $stockLedger->warehouse_id = $each_item['warehouse_id'];
                    $stockLedger->rack_id = $each_item['rack_id'];
                    $stockLedger->bin_id = $each_item['bin_id'];
                    $stockLedger->created_by = Yii::app()->user->id;
                    $stockLedger->created_date = date('Y-m-d h:i:s');
                    $stockLedger->cost_price = $cost_price;
                    $stockLedger->save(false);

                    /*                     * ***************   history  ******************* */
                    $modelHistory = new SerialnoChangeHistoryDetails();
                    $modelHistory->history_id = $history->id;
                    $modelHistory->product_location = $each_item->id;
                    //$modelHistory->old_stock_ledger_ids = $modelStockLedger->id;
                    $modelHistory->stock_ledger_id = $stockLedger->id;
                    $modelHistory->qty = $qty;
                    $modelHistory->action = "A";
                    $modelHistory->created_by = Yii::app()->user->id;
                    ;
                    $modelHistory->created_date_time = date('Y-m-d H:i:s');
                    $modelHistory->save(false);

                    /*                     * ***************  End history  ******************* */
                }
                if (is_array($new_product_location_id)) {
                    //$arr_new_product_location_id = implode(",",array_filter($new_product_location_id));
                }

                $this->ChanageDB(MasCompany::DB_ACE);
            }
            //end
            $jsonData['status'] = 'success';
            $product = Store::model()->findBypk($product_id);
            $jsonData['pid'] = $product_id;
            $jsonData['pname'] = $product->part_number;
            echo CJSON::encode($jsonData);
        } else {
            $error1 = array();

            if (!empty($modelProLocDetails)) {
                $error1 = json_decode(CActiveForm::validate($modelProLocDetails, '', false), true);
            }
            $error = CJSON::encode(array_merge_recursive($error1));
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionAddBatchNo() {
        $pid = (int) Yii::app()->request->getParam('pid');
        $type = Yii::app()->request->getParam('type');
        $total_qty_ace = Yii::app()->request->getParam('total_qty_ace');
        $total_qty_ark = Yii::app()->request->getParam('total_qty_ark');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('batch_no_form', array('pid' => $pid, 'total_qty_ace' => $total_qty_ace, 'total_qty_ark' => $total_qty_ark), false, false);
    }

    public function actionFetchBatchItems() {
        $product_id = $_POST['product_id'];
        $condition = 't.product_id ="' . $product_id . '" AND quantity > 0';
        $stock_details = array(new StockLedger);
        if ((int) $product_id > 0) {
            $stock_details = StockLedger::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
            /* //code added by mereena on 26/03/2020
              $this->ChanageDB(MasCompany::DB_ARK);
              $ark_stock_details = StockLedger::model()->findAll(array('condition' => $condition,'order'=>'id ASC'));
              $this->ChanageDB(MasCompany::DB_ACE);
              //end */
        }
        $ace_total_item_qty = 0;
        /* $ark_total_item_qty=0; */
        $data['table'] = '';
        $data['table'] .= '<table class="table table-hover table-bordered personal-task" id="batchno_items_table" style="margin-top : 10px;">
                            <thead><tr>
                                <th>Warehoue</th>
                                <th>Rack</th>
                                <th>Bin</th>
                                <th>Qty</th>
                                <th>Batch No</th>
                                <th>Expiry Date</th>
                            </tr></thead><tbody id="tbody_material">';
        if ($stock_details[0]->id > 0) {

            $sno = 1;
            $length = 0;
            foreach ($stock_details as $rowitem) {
                $model_wh = MasInventoryWarehouse::model()->findBypk($rowitem->warehouse_id);
                $model_rack = MasInvRack::model()->findBypk($rowitem->rack_id);
                $model_bin = MasInvBin::model()->findBypk($rowitem->bin_id);

                if ($rowitem->expiry_date == '0000-00-00' OR $rowitem->expiry_date == '1970-01-01') {
                    $expiry_date = "";
                } else {
                    $expiry_date = date("d/m/Y", strtotime($rowitem->expiry_date));
                }
                $actual_qty = $rowitem->quantity;

                $data['table'] .= '<tr class="">
                                                <td>' . $model_wh->warehouse_name
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]id") . '</td>
                                                <td>' . $model_rack->name . '</td>
                                                <td>' . $model_bin->name . '</td>
                                                <td>' . CHtml::activeTextfield($rowitem, "[" . $length . "]quantity", array('class' => 'form-control', 'readonly' => true)) . '</td>
                                                <td>' . CHtml::activeTextfield($rowitem, "[" . $length . "]batch_no", array('class' => 'form-control')) . '</td>
                                                <td>' . CHtml::activeTextfield($rowitem, "[" . $length . "]expiry_date", array('class' => 'form-control datepicker', 'value' => $expiry_date))
                        . '</td>
                                           </tr>';
                $length++;
                $ace_total_item_qty++;
            }
        } else {
            if ($length == 0)
                $data['table'] .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }
        $data['table'] .= '</tbody></table>';

        /* //code added by mereena on 30/03/2020
          $this->ChanageDB(MasCompany::DB_ARK);
          if((int) $product_id > 0){
          //code added by mereena on 26/03/2020
          $ark_stock_details = StockLedger::model()->findAll(array('condition' => $condition,'order'=>'id ASC'));
          //end
          }
          $data['arktable']  = '';
          $data['arktable'] .= '<table class="table table-hover table-bordered personal-task" id="batchno_items_table_ark" style="margin-top : 10px;">
          <thead><tr>
          <th>Warehoue</th>
          <th>Rack</th>
          <th>Bin</th>
          <th>Qty</th>
          <th>Batch No</th>
          <th>Expiry Date</th>
          </tr></thead><tbody id="tbody_material">';
          if($ark_stock_details[0]->id > 0){

          $sno  = 1;
          foreach($ark_stock_details as $rowitem){
          $model_wh   = MasInventoryWarehouse::model()->findBypk($rowitem->warehouse_id);
          $model_rack = MasInvRack::model()->findBypk($rowitem->rack_id);
          $model_bin  = MasInvBin::model()->findBypk($rowitem->bin_id);

          if($rowitem->expiry_date =='0000-00-00' OR $rowitem->expiry_date =='1970-01-01'){
          $expiry_date  = "";
          }
          else{
          $expiry_date  = date("d/m/Y",strtotime($rowitem->expiry_date));
          }
          $actual_qty   = $rowitem->quantity;

          $data['arktable'] .= '<tr class="">
          <td>'.$model_wh->warehouse_name
          .CHtml::activeHiddenfield($rowitem, "[" . $length . "]id").'</td>
          <td>'.$model_rack->name.'</td>
          <td>'.$model_bin->name.'</td>
          <td>'.CHtml::activeTextfield($rowitem, "[" . $length . "]quantity",array('class' => 'form-control','readonly'=>true)).'</td>
          <td>'.CHtml::activeTextfield($rowitem, "[" . $length . "]batch_no",array('class' => 'form-control')).'</td>
          <td>'.CHtml::activeTextfield($rowitem, "[" . $length . "]expiry_date",array('class' => 'form-control datepicker','value'=>$expiry_date))
          .'</td>
          </tr>';
          $length++;
          $ark_total_item_qty++;
          }
          }
          else{
          if($ark_total_item_qty == 0)
          $data['arktable'] .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
          }
          $data['arktable'] .= '</tbody></table>';
          //end */
        $data['ace_total_item_qty'] = $ace_total_item_qty;
        /* $data['ark_total_item_qty']= $ark_total_item_qty;
          $this->ChanageDB(MasCompany::DB_ACE); */
        echo CJSON::encode($data);
    }

    public function actionSaveAddBatchNo() {

        $product_id = $_POST['productid'];
        $status = $_POST['expirydate_status']; //code added by mereena on 26/03/2020
        $total_qty_ace = $_POST['total_qty_ace'];
        /* $total_qty_ark   = $_POST['total_qty_ark']; */
        //end
        if (!empty($_POST['StockLedger'])) {
            $k = 0;
            Store::model()->updateByPK($product_id, array('have_expiry_date' => 'Y'));
            //code added by mereena on 26/03/2020
            /* $this->ChanageDB(MasCompany::DB_ARK);
              Store::model()->updateByPK($product_id, array('have_expiry_date' => 'Y'));
              $this->ChanageDB(MasCompany::DB_ACE); */
            //end

            foreach ($_POST['StockLedger'] as $i => $item) {
                $modelProLocDetails = new StockLedger();
                $update_id = $item['id'];
                if ($update_id > 0) {

                    if ($i < $total_qty_ace) {
                        $modelProLocDetails = $modelProLocDetails->findByPk($update_id);
                        $modelProLocDetails->batch_no = $item['batch_no'];
                        if ($item['expiry_date'] != '00/00/0000' AND $item['expiry_date'] != '01/01/1970') {
                            $expiry_date = str_replace('/', '-', $item['expiry_date']);
                            $expiry_date = date("Y-m-d", strtotime($expiry_date));
                        }
                        $modelProLocDetails->expiry_date = $expiry_date;
                        $modelProLocDetails->save(false);
                    }
                    /* else{
                      //code added by mereena on 26/03/2020
                      $this->ChanageDB(MasCompany::DB_ARK);
                      $modelArkProLocDetails  = new StockLedger();
                      $modelArkProLocDetails               = $modelArkProLocDetails->findByPk($update_id);
                      $modelArkProLocDetails->batch_no  = $item['batch_no'];
                      if($item['expiry_date'] !='00/00/0000' AND $item['expiry_date'] !='01/01/1970'){
                      $expiry_date = str_replace('/', '-', $item['expiry_date']);
                      $expiry_date = date("Y-m-d", strtotime($expiry_date));
                      }
                      $modelArkProLocDetails->expiry_date  = $expiry_date;
                      $modelArkProLocDetails->save(false);
                      $this->ChanageDB(MasCompany::DB_ACE);
                      } */
                }
            }
            $jsonData['status'] = 'success';
            $product = Store::model()->findBypk($product_id);
            $jsonData['pid'] = $product_id;
            $jsonData['pname'] = $product->part_number;
            echo CJSON::encode($jsonData);
        }
    }

    public function actionSaveRemoveBatchNo() {

        $product_id = $_POST['product_id'];

        Store::model()->updateByPK($product_id, array('have_expiry_date' => 'N'));
        StockLedger::model()->updateAll(array('batch_no' => '', 'expiry_date' => '0000-00-00'), 'product_id ="' . $product_id . '" AND quantity > 0');
        //code added by mereena on 26/03/2020
        /* $this->ChanageDB(MasCompany::DB_ARK);
          Store::model()->updateByPK($product_id, array('have_expiry_date' => 'N'));
          StockLedger::model()->updateAll(array('batch_no' => '','expiry_date'=>'0000-00-00'),'product_id ="'.$product_id.'" AND quantity > 0 ');
          $this->ChanageDB(MasCompany::DB_ACE); */
        //end
        $jsonData['status'] = 'success';
        $product = Store::model()->findBypk($product_id);
        $jsonData['pid'] = $product_id;
        $jsonData['pname'] = $product->part_number;
        echo CJSON::encode($jsonData);
    }

    public function actionAddBatchSplitDetails() {

        $product_id = filter_var($_POST['product_id'], FILTER_VALIDATE_INT);
        $order_id = filter_var($_POST['order_id'], FILTER_VALIDATE_INT);
        //$quantity      = filter_var($_POST['quantity'], FILTER_VALIDATE_INT);
        $quantity = number_format((float) $_POST['quantity'], 2, '.', '');
        //$quantity      = $_POST['quantity'];
        $totalquantity = $_POST['totalquantity'];
        $newId = filter_var($_POST['newId'], FILTER_VALIDATE_INT);
        //$field_id      = filter_var($_POST['field_id'], FILTER_VALIDATE_INT);
        //$model_material_stock=new MaterialReceiptStockDetails();
        $model_product = Store::model()->findbyPK($product_id);
        $batch_mandty = 0;
        $serial_mandty = 0;
        $color_mandatory = "";
        $color_mandatory_1 = "";
        if ($model_product->have_expiry_date == "Y") {
            $batch_mandty = 1;
            $color_mandatory = "bg-danger";
        }
        if ($model_product->have_serial_no == "Y") {
            $serial_mandty = 1;
            $color_mandatory_1 = "bg-danger";
        }



        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('batch_no_MR_details', array('model_material_stock' => $model_material_stock, 'product_id' => $product_id, 'quantity' => $quantity, 'newId' => $newId, 'batch_mandty' => $batch_mandty, 'serial_mandty' => $serial_mandty, 'color_mandatory' => $color_mandatory, 'color_mandatory_1' => $color_mandatory_1, 'totalquantity' => $totalquantity, 'field_id' => $field_id, 'order_id' => $order_id));
        /* if($model_product->have_serial_no=="Y"){
          $this->render('batch_no_MR_serial_details', array('model_material_stock' => $model_material_stock,'product_id' => $product_id,'quantity' => $quantity,'newId' => $newId,'batch_mandty' => $batch_mandty,'serial_mandty' => $serial_mandty,'color_mandatory'=>$color_mandatory,'color_mandatory_1'=>$color_mandatory_1,'totalquantity'=>$totalquantity,'field_id'=>$field_id,'order_id'=>$order_id));
          }else{
          //$this->render('batch_no_MR_details', array('model_material_stock' => $model_material_stock,'product_id' => $product_id,'quantity' => $quantity,'newId' => $newId,'batch_mandty' => $batch_mandty,'serial_mandty' => $serial_mandty,'color_mandatory'=>$color_mandatory,'color_mandatory_1'=>$color_mandatory_1,'totalquantity'=>$totalquantity,'field_id'=>$field_id,'mr_id'=>$mr_id));
          $this->render('batch_no_MR_details', array('model_material_stock' => $model_material_stock,'product_id' => $product_id,'quantity' => $quantity,'newId' => $newId,'batch_mandty' => $batch_mandty,'serial_mandty' => $serial_mandty,'color_mandatory'=>$color_mandatory,'color_mandatory_1'=>$color_mandatory_1,'totalquantity'=>$totalquantity,'field_id'=>$field_id,'order_id'=>$order_id));
          } */
    }

    public function actionEditserialno() {
        $model = new StockLedger();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('serial_no_edit_form', array('model' => $model), false, true);
    }

    public function actionUpdateserialno() {
        $model = new StockLedger();
        if (isset($_POST['StockLedger'])) {

            $product_id = $_POST['serialno_product_id'];
            $serial_no = $_POST['StockLedger']['serial_no'];
            $id = (int) @$_POST['StockLedger']['id'];

            $check_serialno = StockLedger::model()->find(array('condition' => '
                                                                                product_id="' . $product_id . '"
                                                                                AND serial_no="' . $serial_no . '"
                                                                                AND id !="' . $id . '"'));

            if (empty($check_serialno)) {

                $model = $model->findByPk($id);
                $model->serial_no = $_POST['StockLedger']['serial_no'];
                $model->save(false);
                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'fail';
            }
            echo CJSON::encode($jsonData);
        }
    }

    public function actionSaveService() {
        $model = new Store();
        $scenario = '';
        if ((int) $_POST['Store']['id'] > 0) {
            $id = $_POST['Store']['id'];
            $model = $model->findByPk($id);
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d h:i:s');
            $scenario = 'update';
            $audit_type = 'UPDATED';
            $edit_flag = 1;
        } else {
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            $model->scenario = 'add';
            $scenario = 'add';
            $audit_type = 'CREATED';
        }
        $model->attributes = $_POST['Store'];
        $model->service_product_type = $_POST['Store']['service_product_type'];
        $model->ledger_id = $_POST['Store']['ledger_id'];

        $model->inventory_item_type =  2;  //Service
        //defaullt section sadded

        if ($_POST['Store']['default_service_item'] == "Y") {
            $sql = "UPDATE `erp_store` SET `default_service_item`='N'  WHERE default_service_item='Y' AND inventory_item_type='2' ";
            Yii::app()->db->createCommand($sql)->execute();
        }
        $model->default_service_item = $_POST['Store']['default_service_item'];
        if ($model->validate()) {
            $jsonData['stasstus'] = 'success';
            echo CJSON::encode($jsonData);
            $model->save();

            if (!empty($_POST['Store']['unit_id']) && (int) $_POST['Store']['id'] == 0) {
                $modelUnitMeasurement = new UnitOfMeasurement();
                $modelUnitMeasurement->product_id = $model->id;
                $modelUnitMeasurement->factor = 1;
                $modelUnitMeasurement->isBase = "Y";
                $modelUnitMeasurement->name = Unit::model()->findByPk($_POST['Store']['unit_id'])->symbol;
                $modelUnitMeasurement->base_unit = $_POST['Store']['unit_id'];
                $modelUnitMeasurement->created_by = Yii::app()->user->id;
                $modelUnitMeasurement->created_date_time = date('Y-m-d H:i:s');
                $modelUnitMeasurement->save(false);
            } else if (!empty($_POST['Store']['unit_id']) && (int) $_POST['Store']['id'] > 0) {
                $uomservice = UnitOfMeasurement::model()->find(array('condition' => 'product_id=' . $_POST['Store']['id']));
                $modelUnitMeasurement = UnitOfMeasurement::model()->findByPk((int) $uomservice->id);
                if (!empty($modelUnitMeasurement)) { //condition add to solve the erroro empty product id
                    $modelUnitMeasurement->product_id = $model->id;
                    $modelUnitMeasurement->factor = 1;
                    $modelUnitMeasurement->isBase = "Y";
                    $modelUnitMeasurement->name = Unit::model()->findByPk($_POST['Store']['unit_id'])->symbol;
                    $modelUnitMeasurement->base_unit = $_POST['Store']['unit_id'];
                    $modelUnitMeasurement->created_by = Yii::app()->user->id;
                    $modelUnitMeasurement->created_date_time = date('Y-m-d H:i:s');
                    $modelUnitMeasurement->save(false);
                }
            }

            // inserting to audit log
            AuditLog::saveAuditLogs(
                    'SERVICE',
                    Yii::app()->user->id,
                    $audit_type,
                    " with No: - {$model->id} & Part No: - {$_POST['Store']['part_number']}  "
            );
            // end audit log
            // $model->save_ledger();
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            $error = CJSON::encode($error1);
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionSaveEquipment() {
        $model = new Store();
        $scenario = '';
        if ((int) $_POST['Store']['id'] > 0) {
            $id = $_POST['Store']['id'];
            $model = $model->findByPk($id);
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d h:i:s');
            $scenario = 'update';
            $audit_type = 'UPDATED';
            $edit_flag = 1;
        } else {
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            $model->scenario = 'add';
            $scenario = 'add';
            $audit_type = 'CREATED';
        }
        $model->attributes = $_POST['Store'];
        $model->service_product_type = $_POST['Store']['service_product_type'];
        $model->ledger_id = $_POST['Store']['ledger_id'];

        $model->inventory_item_type = 4;  //Equipment
        //defaullt section sadded

        if ($_POST['Store']['default_service_item'] == "Y") {
            $sql = "UPDATE `erp_store` SET `default_service_item`='N'  WHERE default_service_item='Y' AND inventory_item_type='4' ";
            Yii::app()->db->createCommand($sql)->execute();
        }
        $model->default_service_item = $_POST['Store']['default_service_item'];
        if ($model->validate()) {
            $jsonData['stasstus'] = 'success';
            echo CJSON::encode($jsonData);
            $model->save();

            if (!empty($_POST['Store']['unit_id']) && (int) $_POST['Store']['id'] == 0) {
                $modelUnitMeasurement = new UnitOfMeasurement();
                $modelUnitMeasurement->product_id = $model->id;
                $modelUnitMeasurement->factor = 1;
                $modelUnitMeasurement->isBase = "Y";
                $modelUnitMeasurement->name = Unit::model()->findByPk($_POST['Store']['unit_id'])->symbol;
                $modelUnitMeasurement->base_unit = $_POST['Store']['unit_id'];
                $modelUnitMeasurement->created_by = Yii::app()->user->id;
                $modelUnitMeasurement->created_date_time = date('Y-m-d H:i:s');
                $modelUnitMeasurement->save(false);
            } else if (!empty($_POST['Store']['unit_id']) && (int) $_POST['Store']['id'] > 0) {
                $uomservice = UnitOfMeasurement::model()->find(array('condition' => 'product_id=' . $_POST['Store']['id']));
                $modelUnitMeasurement = UnitOfMeasurement::model()->findByPk((int) $uomservice->id);
                if (!empty($modelUnitMeasurement)) { //condition add to solve the erroro empty product id
                    $modelUnitMeasurement->product_id = $model->id;
                    $modelUnitMeasurement->factor = 1;
                    $modelUnitMeasurement->isBase = "Y";
                    $modelUnitMeasurement->name = Unit::model()->findByPk($_POST['Store']['unit_id'])->symbol;
                    $modelUnitMeasurement->base_unit = $_POST['Store']['unit_id'];
                    $modelUnitMeasurement->created_by = Yii::app()->user->id;
                    $modelUnitMeasurement->created_date_time = date('Y-m-d H:i:s');
                    $modelUnitMeasurement->save(false);
                }
            }

            // inserting to audit log
            AuditLog::saveAuditLogs(
                    'SERVICE',
                    Yii::app()->user->id,
                    $audit_type,
                    " with No: - {$model->id} & Part No: - {$_POST['Store']['part_number']}  "
            );
            // end audit log
            // $model->save_ledger();
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            $error = CJSON::encode($error1);
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionRawMaterial() {
        $this->render('raw_material_index');
    }

    public function actionGetRawMaterialList() {
        $model = new Store();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $display_type = $_POST['display_type'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'part_number',
            1 => 'generic_name',
            2 => 'description',
            3 => 'brand_class_id',
            4 => 'default_warehouse_id',
            5 => 'inventory_item_type',
        );

        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 'isActive="Y" AND type=3';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = "type=3 AND (id LIKE '%" . $searchString . "%' OR part_number LIKE '%" . $searchString . "%' OR description LIKE '%" . $searchString . "%' OR alias_name LIKE '%" . $searchString . "%') ";
        }

        if ($display_type == 1)
            $condition .= ' AND quantity > 0';

        $query = 'SELECT * FROM view_all_stock_items WHERE ' . $condition . ' LIMIT ' . $limit . ' OFFSET ' . $offset . ' ';
        $count = Yii::app()->db->createCommand('SELECT COUNT(id) FROM view_all_stock_items WHERE ' . $condition . ' ')->queryScalar();
        $model = Yii::app()->db->createCommand($query)->queryAll();

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $row) {
            $part_no = $row['part_number'];
            $rowData[] = array($row['id'], $part_no, $row['description'], $row['brand'], (float) $row['quantity'], $row['unit']);
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionBatchSplit() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('batch_split_form', array(), false, false);
    }

    public function actionGetProductBatchNo() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $productid = $_GET['product_id'];
        $condition = 'product_id="' . $productid . '" AND quantity>0 AND t.batch_no LIKE "%' . $searchTerm . '%"';
        $model = new StockLedger();
        $model = $model->findAll(array('condition' => $condition, 'group' => 'batch_no'));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->batch_no;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionFetchBatchNoItems() {
        $product_id = $_POST['product_id'];
        $batchno = $_POST['batchno'];

        $modelStore = Store::model()->findByPk($product_id);
        if ($modelStore->have_serial_no == 'Y') {
            $readonly = true;
        } else {
            $readonly = false;
        }
        $condition = 't.product_id ="' . $product_id . '" AND quantity > 0 AND batch_no="' . $batchno . '"';
        $stock_details = array(new StockLedger);
        if ((int) $product_id > 0) {
            $stock_details = StockLedger::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
        }

        $data['table'] = '';
        $data['table'] .= '<table class="table table-hover table-bordered personal-task" id="batchno_split_items_table" style="margin-top : 10px;">
                            <thead>
                                <tr>
                                    <th>Warehoue</th>
                                    <th>Rack</th>
                                    <th>Bin</th>
                                    <th>Qty</th>
                                    <th>Batch</th>
                                    <th>Expiry Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                                <tbody id="tbody_material">';
        if ($stock_details[0]->id > 0) {

            $sno = 1;
            $length = 0;
            $total_qty = 0;
            foreach ($stock_details as $rowitem) {
                $model_wh = MasInventoryWarehouse::model()->findBypk($rowitem->warehouse_id);
                $model_rack = MasInvRack::model()->findBypk($rowitem->rack_id);
                $model_bin = MasInvBin::model()->findBypk($rowitem->bin_id);

                if ($rowitem->expiry_date == '0000-00-00' OR $rowitem->expiry_date == '1970-01-01') {
                    $expiry_date = "";
                } else {
                    $expiry_date = date("d/m/Y", strtotime($rowitem->expiry_date));
                }
                $actual_qty = $rowitem->quantity;

                $expiry_date = '';
                if ($rowitem->expiry_date != '0000-00-00' AND $rowitem->expiry_date != '1970-01-01') {
                    $expiry_date = date("d/m/Y", strtotime($rowitem->expiry_date));
                }

                //date("d/m/Y",strtotime($row['qtn_start_date']))
                //.CHtml::activeHiddenfield($rowitem, "[" . $length . "]bill_of_entry").
                $data['table'] .= '<tr class="">
                                                <td>' . $model_wh->warehouse_name
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]file_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]header_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]header_item_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]customer_vendor_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]customer_vendor_name")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]product_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]product_name")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]product_description")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]brand_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]brand_name")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]warehouse_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]warehouse_name")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]rack_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]rack_name")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]bin_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]bin_name")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]unit_id")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]unit_name")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]unit_factor")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]available_status")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]serial_no")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]manufacturing_date")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]cost_price")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]sales_price")
                        . CHtml::activeHiddenfield($rowitem, "[" . $length . "]master_stock_ledger_id")
                        . '</td>
                                                <td>' . $model_rack->name . '</td>
                                                <td>' . $model_bin->name . '</td>
                                                <td>' . CHtml::activeTextfield($rowitem, "[" . $length . "]quantity", array('class' => 'form-control', 'readonly' => $readonly)) . '</td>
                                                <td>' . CHtml::activeTextfield($rowitem, "[" . $length . "]batch_no", array('class' => 'form-control')) . '</td>
                                                <td>' . CHtml::activeTextfield($rowitem, "[" . $length . "]expiry_date", array('class' => 'form-control datepicker', 'value' => $expiry_date)) . '</td>
                                                <td>' . CHtml::link('<i class="fa fa-paper-plane-o"></i>', 'javascript:void(0);', array('class' => 'btn btn-sm btn-danger', 'title' => 'Create Next Row', 'onclick' => 'rowSplit($("#batchno_split_items_table"), this,this.id);', 'id' => 'batchsplit_' . $length)) . '</td>
                                           </tr>';
                $length++;
                $total_qty += $rowitem->quantity;
            }
        } else {
            if ($length == 0)
                $data['table'] .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }
        $data['table'] .= '</tbody></table>';
        $data['total_qty'] = $total_qty;
        echo CJSON::encode($data);
    }

    public function actionSaveBatchSplit() {

        $product_id = $_POST['product_id'];
        $batchno = $_POST['batchno'];

        if (!empty($_POST['StockLedger'])) {

            $history = new InventoryBatchSplitHistory();
            $history->product_id = $product_id;
            $history->batch_name = $batchno;
            $history->created_by = Yii::app()->user->id;
            ;
            $history->created_datetime = date('Y-m-d H:i:s');
            $history->save(false);

            // inserting to audit log
            AuditLog::saveAuditLogs(
                    'BATCH_SPLIT',
                    Yii::app()->user->id,
                    'CREATED',
                    " with PRDT ID: - {$product_id} - and Batch: - {$batchno}"
            );
            // end audit log

            $condition = 't.product_id ="' . $product_id . '" AND quantity > 0 AND batch_no="' . $batchno . '"';
            $stock_details = StockLedger::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));
            if (!empty($stock_details)) {
                foreach ($stock_details as $i => $stock_details) {
                    $modelHistory = new InventoryBatchSplitHistoryDetail();
                    $modelHistory->batch_split_history_id = $history->id;
                    $modelHistory->status = "O_UPD";
                    $modelHistory->batch_name = $stock_details->batch_no;
                    $modelHistory->product_location_id = $stock_details->id;
                    $modelHistory->quantity = $stock_details->quantity;
                    $modelHistory->save(false);
                }
            }

            foreach ($_POST['StockLedger'] as $i => $item) {
                $modelStockLedger = new StockLedger;
                if ($item['id'] > 0) {
                    $modelStockLedger = StockLedger::model()->findByPk($item['id']);
                } else {

                    $modelStockLedger->attributes = $_POST['StockLedger'];

                    $modelStockLedger->file_id = $item['file_id'];
                    $modelStockLedger->header_id = $history->id;
                    $modelStockLedger->header_item_id = 0;
                    $modelStockLedger->customer_vendor_id = $item['customer_vendor_id'];
                    $modelStockLedger->customer_vendor_name = $item['customer_vendor_name'];
                    $modelStockLedger->product_id = $item['product_id'];
                    $modelStockLedger->product_name = $item['product_name'];
                    $modelStockLedger->product_description = $item['product_description'];
                    $modelStockLedger->brand_id = $item['brand_id'];
                    $modelStockLedger->brand_name = $item['brand_name'];
                    $modelStockLedger->warehouse_id = $item['warehouse_id'];
                    $modelStockLedger->warehouse_name = $item['warehouse_name'];
                    $modelStockLedger->rack_id = $item['rack_id'];
                    $modelStockLedger->rack_name = $item['rack_name'];
                    $modelStockLedger->bin_id = $item['bin_id'];
                    $modelStockLedger->bin_name = $item['bin_name'];
                    $modelStockLedger->serial_no = trim($item['serial_no']);
                    $modelStockLedger->unit_name = $item['unit_name'];
                    $modelStockLedger->unit_id = $item['unit_id'];
                    $modelStockLedger->cost_price = $item['cost_price'];
                    $modelStockLedger->sales_price = $item['sales_price'];
                    $modelStockLedger->transaction_date = date('Y-m-d');
                    $modelStockLedger->transaction_from = "BATCH_SPLIT";
                    $modelStockLedger->transaction_type = "IN";
                    $modelStockLedger->master_stock_ledger_id = $item['master_stock_ledger_id'];
                    $modelStockLedger->created_by = Yii::app()->user->id;
                    $modelStockLedger->created_date = date('Y-m-d h:i:s');
                    $modelStockLedger->stock_updated = "Y";
                }

                if ($item['expiry_date'] != '00/00/0000' AND $item['expiry_date'] != '01/01/1970') {
                    $expiry_date = str_replace('/', '-', $item['expiry_date']);
                    $expiry_date = date("Y-m-d", strtotime($expiry_date));
                }
                $modelStockLedger->quantity = $item['quantity'];
                $modelStockLedger->batch_no = $item['batch_no'];
                $modelStockLedger->expiry_date = $expiry_date;
                $modelStockLedger->save(false);

                $modelHistory = new InventoryBatchSplitHistoryDetail();
                $modelHistory->batch_split_history_id = $history->id;
                $modelHistory->status = "N_ADD";
                $modelHistory->batch_name = $item['batch_no'];
                $modelHistory->product_location_id = $modelStockLedger->id;
                $modelHistory->quantity = $item['quantity'];
                $modelHistory->save(false);
            }


            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    public function actionCheckProductInQC() {
        $from = $_GET['frm'];

        $product_id = $_POST['product_id'];
        if ($product_id > 0) {

            $sql = "SELECT
                      COUNT(*)
                    FROM
                      erp_purchasing_material_receipt_item AS MRI
                    LEFT JOIN
                      erp_purchasing_material_receipt AS MR ON MR.`id` = MRI.`purchasing_materialreceipt_id`
                    LEFT JOIN
                      erp_master_file AS FILE ON FILE.`id` = MR.`file_id`
                    WHERE
                      MRI.product_id = " . $product_id . " AND(
                        FILE.current_process_status = 'Q_C' OR FILE.current_process_status = 'M_R'
                      )";

            $command = Yii::app()->db->createCommand($sql);

            $count = $command->queryScalar();
            $jsonData['status'] = 'success';
            $jsonData['count'] = $count;
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionGetSearchServiceItems() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = '(part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") AND inventory_item_type=2';
        $model = new Store();
        $model = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number . ' : ' . $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $data[$i]['tax_code'] = $eachModel->tax;
            $data[$i]['part_no'] = $eachModel->part_number;
            $data[$i]['other'] = $eachModel->inventory_item_type;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionLoadsalepurchaseHistory() {
        $type = (int) Yii::app()->request->getParam('type');
        $product_id = (int) Yii::app()->request->getParam('product_id');
        $customer_vendor_id = (int) Yii::app()->request->getParam('customer_vendor_id');
        if ($type == 1) {
            $this->renderPartial('get_sale_history', array('product_id' => $product_id, 'customer_id' => $customer_vendor_id), false, true);
        } else if ($type == 2) {
            $this->renderPartial('get_purchase_history', array('product_id' => $product_id, 'vendor_id' => $customer_vendor_id), false, true);
        } else if ($type == 3) {
            $this->renderPartial('get_quote_rate_details', array('product_id' => $product_id, 'customer_id' => $customer_vendor_id), false, true);
        }
    }

    public function actionGetAvaibaleQty() {
        $product_id = (int) $_POST['id'];
        $type = $_POST['type'];
        $availble_qty = 0;
        $availble_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) as availble_qty FROM `view_all_stock_items` WHERE id=' . $product_id . ' GROUP BY id')->queryScalar();
        echo "<span style='color:red;'><b>" . Yii::app()->numberFormatter->formatCurrency($availble_qty, "") . "</b></span>";
        //echo "<span class='sh-close' onclick='$(\"#stockhelper\").hide();'><i class='fa fa-times'></i></span><b>Available Qty: <span style='color:red;'>".Yii::app()->numberFormatter->formatCurrency($availble_qty,"")."</span></b>";
        Yii::app()->end();
    }

    public function actionGetSerialNoList() {
        $model = new StockLedger();
        $id = (int) Yii::app()->request->getParam('id');

        if ($id > 0) {
            $condition = 'product_id =    "' . $id . '" AND quantity>0 AND available_status="A" AND stock_updated="Y"';
            $model = StockLedger::model()->with('warehouse')->findAll(array('condition' => $condition));
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('edit_serial_no', array('model' => $model, 'product_id' => $id), false, false);
    }

    public function actionChangeSerialNo() {
        $db_flag = 0;

        if (is_array($_POST['StockLedger'])) {
            $arr_serial_exist_product = array();
            foreach ($_POST['StockLedger'] as $i => $item) {
                //echo "id=".$item['id']."=>".$item['serial_no']."<br>";
                if ($item['id'] > 0) {
                    $condition = "product_location_id=" . $item['id'];
                    $arr_serial_no_exist = StockLedger::model()->find(array('condition' => 'serial_no="' . trim($item['serial_no'] . '" AND product_id=' . trim($item['product_id']) . ' AND id<>' . $item['id'])));
                    if (count($arr_serial_no_exist) == 0) {
                        StockLedger::model()->updateByPk($item['id'], array('serial_no' => trim($item['serial_no'])));
                    } else {
                        $arr_serial_exist_product[] = $item['serial_no'];
                    }
                }
            }
            if (count($arr_serial_exist_product) > 0) {
                $jsonData['status'] = 'error';
                $jsonData['serial_no'] = implode(',', $arr_serial_exist_product);
            } else {
                $jsonData['status'] = 'success';
            }

            echo CJSON::encode($jsonData);
        }
    }

    public function actionGetLocationDetails() {
        $product_id = (int) $_POST['id'];
        $this->renderPartial('location_details', array('id' => $product_id), false, true);
    }

    public function actionGetdemoPartnumber() {
        $brand_id = (int) $_POST['brand_id'];
        $machine_type = $_POST['mc_type'];
        $part_no = '-';
        if ($brand_id > 0) {
            $model_max_partnumber = Store::model()->find(array('select' => 'max(id) as id', 'condition' => 'inventory_item_type="1" and brand_class_id="' . $brand_id . '"'));
            if ($model_max_partnumber->id != '') {
                $model_existing_part_no = Store::model()->findByPk($model_max_partnumber->id);
                $existing_part_no = explode('-', $model_existing_part_no->part_number);
                $part_number_new = $existing_part_no[2] + 1;
                if ($part_number_new <= 99999) {
                    $part_number_new = str_pad($part_number_new, 5, "0", STR_PAD_LEFT);
                }
            } else {
                $part_number_new = '00001';
            }
            $model_brand_class = MasInvBrand::model()->findByPk($brand_id);
            $part_no = '';
            if ($model_brand_class->id > 0) {
                $value_machine_type = ($machine_type == 'M') ? '02' : '04';
                $brand_class_auto_generated_no = 0;
                if (count($model_brand_class->auto_generated_no) == 1) {
                    $brand_class_auto_generated_no = str_pad($model_brand_class->auto_generated_no, 2, "0", STR_PAD_LEFT);
                } else {
                    $brand_class_auto_generated_no = $model_brand_class->auto_generated_no;
                }
                $part_no = $brand_class_auto_generated_no . '-' . $value_machine_type . '-' . $part_number_new;
            }
        }
        $jsonData['part_number'] = $part_no;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionGetMachineOnly() {
        $searchTerm = $_GET['term'];
        $condition = '(t.part_number LIKE "%' . $searchTerm . '%" OR t.description LIKE "%' . $searchTerm . '%") AND t.machine_type="M"';
        $model = Store::model()->findAll(array('select' => 'id,hiring_part_number,description', 'condition' => $condition, 'limit' => 200));
        $data = array();
        foreach ($model as $i => $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->description;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionMemo() {
        $this->render('memo_index');
    }

    public function actionGetMemoList() {
        $model = new Store();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'part_number',
            1 => 'description',
            2 => 'inventory_item_type'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" AND inventory_item_type=3';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = "inventory_item_type=3 AND ( part_number LIKE '%" . $searchString . "%' OR description LIKE '%" . $searchString . "%' )";
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $m => $row) {
            $rowData[] = array($m + 1, $row['part_number'], $row['description'], $row['id']);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionSaveMemo() {
        $model = new Store();
        $scenario = '';
        if ((int) $_POST['Store']['id'] > 0) {
            $id = $_POST['Store']['id'];
            $model = $model->findByPk($id);
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d h:i:s');
            $scenario = 'update';
            $audit_type = 'UPDATED';
            $edit_flag = 1;
        } else {
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            $model->scenario = 'add';
            $scenario = 'add';
            $audit_type = 'CREATED';
        }
        $model->attributes = $_POST['Store'];
        $model->inventory_item_type = 3;  //Memo
        $model->purchase_from = "L";
        $model->tax_code = 0;
        $model->unit_id = 0;
        if ($model->validate()) {
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
            $model->save();

            // inserting to audit log
            AuditLog::saveAuditLogs(
                    'SERVICE',
                    Yii::app()->user->id,
                    $audit_type,
                    " with No: - {$model->id} & Part No: - {$_POST['Store']['part_number']}  "
            );
            // end audit log
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            $error = CJSON::encode($error1);
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionDummy() {
        $this->render('dummy_index');
    }

    public function actionGetDummyList() {
        $model = new Store();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'part_number',
            1 => 'description',
            2 => 'inventory_item_type'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" AND inventory_item_type=4';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = "inventory_item_type=4 AND ( part_number LIKE '%" . $searchString . "%' OR description LIKE '%" . $searchString . "%' )";
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $m => $row) {
            $rowData[] = array($m + 1, $row['part_number'], $row['description'], $row['id']);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionSaveDummy() {
        $model = new Store();
        $scenario = '';
        if ((int) $_POST['Store']['id'] > 0) {
            $id = $_POST['Store']['id'];
            $model = $model->findByPk($id);
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d h:i:s');
            $scenario = 'update';
            $audit_type = 'UPDATED';
            $edit_flag = 1;
        } else {
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            $model->scenario = 'add';
            $scenario = 'add';
            $audit_type = 'CREATED';
        }
        $model->attributes = $_POST['Store'];
        $model->inventory_item_type = 4;  //Dummy
        $model->purchase_from = "L";
        if ($model->validate()) {
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
            $model->save();
            if (!empty($_POST['Store']['unit_id']) && (int) $_POST['Store']['id'] == 0) {
                $modelUnitMeasurement = new UnitOfMeasurement();
                $modelUnitMeasurement->product_id = $model->id;
                $modelUnitMeasurement->factor = 1;
                $modelUnitMeasurement->isBase = "Y";
                $modelUnitMeasurement->name = Unit::model()->findByPk($_POST['Store']['unit_id'])->symbol;
                $modelUnitMeasurement->base_unit = $_POST['Store']['unit_id'];
                $modelUnitMeasurement->created_by = Yii::app()->user->id;
                $modelUnitMeasurement->created_date_time = date('Y-m-d H:i:s');
                $modelUnitMeasurement->save(false);
            } else if (!empty($_POST['Store']['unit_id']) && (int) $_POST['Store']['id'] > 0) {
                $uomservice = UnitOfMeasurement::model()->find(array('condition' => 'product_id=' . $_POST['Store']['id']));
                if (empty($uomservice)) {
                    $modelUnitMeasurement = new UnitOfMeasurement();
                } else
                    $modelUnitMeasurement = UnitOfMeasurement::model()->findByPk($uomservice->id);
                $modelUnitMeasurement->product_id = $model->id;
                $modelUnitMeasurement->factor = 1;
                $modelUnitMeasurement->isBase = "Y";
                $modelUnitMeasurement->name = Unit::model()->findByPk($_POST['Store']['unit_id'])->symbol;
                $modelUnitMeasurement->base_unit = $_POST['Store']['unit_id'];
                $modelUnitMeasurement->created_by = Yii::app()->user->id;
                $modelUnitMeasurement->created_date_time = date('Y-m-d H:i:s');
                $modelUnitMeasurement->save(false);
            }


            // inserting to audit log
            AuditLog::saveAuditLogs(
                    'DUMMY',
                    Yii::app()->user->id,
                    $audit_type,
                    " with No: - {$model->id} & Part No: - {$_POST['Store']['part_number']}  "
            );
            // end audit log
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            $error = CJSON::encode($error1);
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionGetPurchaseHistoryList() {
        $product_id = (int) Yii::app()->request->getParam('id');

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('get_purchase_history_list', array('product_id' => $product_id), false, true);
    }

    public function actionApproveInventoryItem() {
        $product_id = (int) Yii::app()->request->getParam('id');
        if ($product_id > 0) {
            Store::model()->updateByPK($product_id, array('isActive' => 'Y'));
            $data['status'] = 'success';
        } else {
            $data['status'] = 'failed';
        }

        echo json_encode($data);
    }

    public function actionViewExpiryList() {
        $product_id = (int) Yii::app()->request->getParam('id');
        $condition = 't.product_id ="' . $product_id . '" AND quantity > 0';
        $stock_details = array(new StockLedger);
        if ((int) $product_id > 0) {
            $stock_details = StockLedger::model()->findAll(array('condition' => $condition, 'order' => 'expiry_date ASC'));
        }

        $this->render('view_expiry_list', array('arr_stock_details' => $stock_details));
    }

    public function actionAllocateMaterials() {
        $allocated_from = Yii::app()->request->getParam('frm');
        $header_id = (int) Yii::app()->request->getParam('id');
        $file_id = (int) Yii::app()->request->getParam('file_id');

        $modelAllocatedMaterial = new AllocatedMaterial();

        $SQL = 'SELECT GROUP_CONCAT(product_id) as product_ids FROM `erp_allocated_materials` WHERE header_id=' . $header_id;
        //echo $query;
        $allocate_products = Yii::app()->db->createCommand($SQL)->queryRow();

        $arr_product_ids = explode(",", $allocate_products['product_ids']);

        $cnt_allocated = (int) Yii::app()->db->createCommand('SELECT COUNT(id) FROM erp_allocated_materials  WHERE header_id=' . $header_id)->queryScalar();

        $arr_product_details = array();
        //echo $header_id;
        if ($allocated_from == 'Q') {
            $modelQuotesItem = new QuotesItem();
            $modelQuotesItem = $modelQuotesItem->findAll(array('condition' => 'quotes_id=' . $header_id, 'order' => 't.id'));

            $i = 0;
            foreach ($modelQuotesItem as $eachItem) {
                if ($eachItem->product->inventory_item_type == 1) {
                    $arr_product_details[$i]['product_id'] = $eachItem->product_id;
                    $arr_product_details[$i]['part_number'] = $eachItem->product->part_number;
                    $arr_product_details[$i]['description'] = $eachItem->description;
                    $arr_product_details[$i]['file_id'] = $eachItem->quotes->file_id;
                    $arr_product_details[$i]['header_id'] = $header_id;
                    $arr_product_details[$i]['warehouse_id'] = 0;
                    $arr_product_details[$i]['quantity'] = $eachItem->quantity;
                    $arr_product_details[$i]['allocation_start_date'] = date('d/m/Y');
                    $arr_product_details[$i]['allocation_end_date'] = date('d/m/Y', strtotime($eachItem->quotes->qtn_validity));
                    if (in_array($eachItem->product_id, $arr_product_ids)) {
                        $arr_product_details[$i]['checked'] = 1;
                    } else {
                        $arr_product_details[$i]['checked'] = 0;
                    }
                    $i++;
                }
            }
        } else {
            $modelOrderItem = new OrderItem();
            $modelOrderItem = $modelOrderItem->findAll(array('condition' => 'order_id=' . $header_id, 'order' => 't.id'));
            $i = 0;
            foreach ($modelOrderItem as $eachItem) {
                if ($eachItem->product->inventory_item_type == 1) {
                    $arr_product_details[$i]['product_id'] = $eachItem->product_id;
                    $arr_product_details[$i]['part_number'] = $eachItem->product->part_number;
                    $arr_product_details[$i]['description'] = $eachItem->description;
                    $arr_product_details[$i]['file_id'] = $eachItem->order->file_id;
                    $arr_product_details[$i]['header_id'] = $header_id;
                    $arr_product_details[$i]['warehouse_id'] = 0;
                    $arr_product_details[$i]['quantity'] = $eachItem->quantity;
                    $arr_product_details[$i]['allocation_start_date'] = date('d/m/Y');
                    $arr_product_details[$i]['allocation_end_date'] = date('d/m/Y', strtotime($eachItem->order->delivery_date));
                    if (in_array($eachItem->product_id, $arr_product_ids)) {
                        $arr_product_details[$i]['checked'] = 1;
                    } else {
                        $arr_product_details[$i]['checked'] = 0;
                    }
                    $i++;
                }
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('view_allocation_details', array('allocated_from' => $allocated_from, 'header_id' => $header_id, 'arr_product_details' => $arr_product_details, 'file_id' => $file_id, 'cnt_allocated' => $cnt_allocated));
    }

    public function actionSaveAllocateMaterial() {

        AllocatedMaterial::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $_POST['header_id']));

        foreach ($_POST['AllocatedMaterial'] as $i => $eachItem) {

            if (isset($_POST['checkproducts_' . $i]) && $_POST['checkproducts_' . $i] != "") {
                $allocation_start_date = "0000-00-00";
                if ($eachItem['allocation_date'] != '') {
                    $allocation_start_date = str_replace('/', '-', $eachItem['allocation_date']);
                    $allocation_start_date = date("Y-m-d", strtotime($allocation_start_date));
                }
                $allocation_end_date = "0000-00-00";
                if ($eachItem['allocation_end_date'] != '') {
                    $allocation_end_date = str_replace('/', '-', $eachItem['allocation_end_date']);
                    $allocation_end_date = date("Y-m-d", strtotime($allocation_end_date));
                }

                if ($eachItem['quantity'] > 0) {
                    $modelAllocatedMaterial = new AllocatedMaterial();
                    $modelAllocatedMaterial->product_id = $eachItem['product_id'];
                    $modelAllocatedMaterial->file_id = $eachItem['file_id'];
                    $modelAllocatedMaterial->header_id = $eachItem['header_id'];
                    $modelAllocatedMaterial->quantity = $eachItem['quantity'];
                    $modelAllocatedMaterial->allocation_date = $allocation_start_date;
                    $modelAllocatedMaterial->allocation_end_date = $allocation_end_date;
                    $modelAllocatedMaterial->allocated_from = Yii::app()->user->id;
                    $modelAllocatedMaterial->created_by = Yii::app()->user->id;
                    $modelAllocatedMaterial->created_datetime = date('Y-m-d H:i:s');

                    $modelAllocatedMaterial->save(false);
                }
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);

        //
    }

    /* Created By Jisha on 10/05/2022 for blocking inventory items */

    public function actionBlockInventoryItem() {
        $product_id = (int) Yii::app()->request->getParam('id');
        if ($product_id > 0) {
            Store::model()->updateByPK($product_id, array('isActive' => 'N'));
            $data['status'] = 'success';
        } else {
            $data['status'] = 'failed';
        }

        echo json_encode($data);
    }

    public function actionDeleteUOMItem() {
        $uom_id = (int) Yii::app()->request->getParam('id');
        $sales_price_group_id = (int) Yii::app()->request->getParam('sales_price_group_id');
        $qtn_count = (int) QuotesItem::model()->count(array('condition' => 'unit_id=' . $uom_id));
        $order_count = (int) OrderItem::model()->count(array('condition' => 'unit_id=' . $uom_id));
        $delivery_count = (int) DeliveryNoteItem::model()->count(array('condition' => 'unit=' . $uom_id));
        $invoice_count = (int) InvoiceItem::model()->count(array('condition' => 'unit_id=' . $uom_id));

        $enquiry_count = (int) PurchasingEnquiryStockItem::model()->count(array('condition' => 'stock_item_unit=' . $uom_id));
        $po_count = (int) PurchasingOrderStockItem::model()->count(array('condition' => 'stock_item_unit=' . $uom_id));
        $mr_count = (int) PurchasingMaterialreceiptItem::model()->count(array('condition' => 'unit_id=' . $uom_id));
        $po_invoice_count = (int) PurchasingInvoiceItem::model()->count(array('condition' => 'unit=' . $uom_id));

        $stock_ledger_count = (int) StockLedger::model()->count(array('condition' => 'unit_id=' . $uom_id));

        if ($qtn_count == 0 && $order_count == 0 && $delivery_count == 0 && $invoice_count == 0 && $enquiry_count == 0 && $po_count == 0 && $mr_count == 0 && $po_invoice_count == 0 && $stock_ledger_count == 0) {
            if ($uom_id > 0) {
                $modelUnitOfMeasurement = new UnitOfMeasurement();
                $modelUnitOfMeasurement->deleteByPk($uom_id);
            }
            if ($sales_price_group_id > 0) {
                $modelSalesPriceGroup = new SalesPriceGroup();
                $modelSalesPriceGroup->deleteByPk($sales_price_group_id);
            }

            $data['status'] = 'success';
        } else {
            $data['status'] = 'failed';
        }
        echo json_encode($data);
    }

    public function actionPrintInventoryBarcode() {
        $product_id = (int) Yii::app()->request->getParam('id');
        $head_id = (int) Yii::app()->request->getParam('head_id');
        $model = new Store();
        $model = $model->findByPk($product_id);
        $barcode = $model->bar_code;
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A11');

        /* $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
          $mPDF1->WriteHTML($stylesheet, 1); */
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.inventory_barcode', array('model' => $model, 'id' => $product_id, 'barcode' => $barcode, 'head_id' => $head_id, 'mpdf' => $mPDF1), true));

        $mPDF1->Output("INVENTORY_" . $product_id . ".pdf", 'I');
    }

    public function actionGetWarehouseProduct() {
        $warehouse_id = (int) Yii::app()->request->getParam('warehouse_id');
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'isActive="Y" AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        $model = new Store();
        $model = $model->findAll(array('select' => 'id, part_number, description', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $eachModel->id . ' AND warehouse_id=' . (int) $warehouse_id)->queryScalar();
            $data[$i]['value'] = $eachModel->part_number;
            $data[$i]['label'] = $eachModel->part_number . ' : ' . $eachModel->description;
            $data[$i]['product_id'] = $eachModel->id;
            $data[$i]['quantity'] = $availble_qty;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionSelectBarcodeHeading() {
        $product_id = (int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('select_barcode_heading', array('product_id' => $product_id), false, false);
    }

}
