<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of industryController
 *
 * @author bluesky
 */
class industryController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveIndustry', 'DeleteIndustry', 'DirectAdd', 'UnBlockindustry','Blockindustry','Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

public function actionIndex() {
    Yii::app()->clientScript->scriptMap = array(
        '*jquery.js' => false,
        '*jquery.min.js' => false,
        'jquery.min.js' => false,
        '*jquery-ui.js' => false,
        '*jquery-ui.min.js' => false,
    );

   if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['cus_master_industry_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['cus_master_industry_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
                $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
}
    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new MasIndustry();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 =>'t.id',
            1 => 'name'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " (name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'name ASC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["cus_master_industry_edit"])) {
                //$div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'industry/create&id=' . $row['id'] . '\',\'Edit Industry\')"><i class="fa fa-pencil"></i></button> ';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["cus_master_industry_delete"])) {
                //$div .=  ' <a href ="#" onclick="deleteIndustry('.$row['id'].')"><button class="btn btn-danger btn-xs"><i class="fa fa-trash-o "></i></button></a>';
            }

            if(isset(Yii::app()->user->havePermissionOn['cus_master_industry_disable']) ||  Yii::app()->user->authorised_user == 1)
                {

                  if ($row->isActive == "Y") 
                  {
                    //$div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disableindustry(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                  }
                  if ($row->isActive == 'N') 
                  {
                       // $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enableindustry(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                  }            
                
                }
            $rowData[] = array($m,
                $row['name'],
                $row['is_base_industry'],
                '<div class="btn-wrap">' . $div . '</div>',
                //$row['isActive'],
                 array('id' => $row['id'],'code'=>$row['name'], 'status' => $row->isActive)
            );


            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasIndustry();
        $id = (int) Yii::app()->request->getParam('id');
        $from = Yii::app()->request->getParam('from');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('industry_form', array('model' => $model, 'from' => $from), false, false);
    }

    public function actionSaveIndustry() {
        $model = new MasIndustry();
        if (isset($_POST['MasIndustry'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['MasIndustry']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasIndustry']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            if($_POST['MasIndustry']['is_base_industry'] == "Y"){
                MasIndustry::model()->updateAll(array( 'is_base_industry' => 'N' ), 'is_base_industry = "Y"' );
            }
            $model->is_base_industry = $_POST['MasIndustry']['is_base_industry'];
            
            $model->attributes = $_POST['MasIndustry'];
            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'INDUSTRY', Yii::app()->user->id, $audit_type, " with name : - {$model->name} "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['industry_form'];
                $jsonData['id'] = $model->id;
                $jsonData['from'] = $_POST['from'];
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteIndustry() {
        $id = $_POST['id'];
        $model_c = Customer::model()->findAll(array('condition' => 'customer_industry=' . $id . ' '));
        if (empty($model_c)) {
            $model = new MasIndustry();
            $del = $model->findByPk($id);
            $model->deleteByPk($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                    'INDUSTRY', Yii::app()->user->id, 'DELETED', " with name : - {$del->name} "
            );
            // end audit log
            echo "success";
        } else {
            echo "fail";
        }
    }

    public function actionDirectAdd() {
        $from = $_POST['from'];
        $name = $_POST['name'];
        if ($name != '') {
            $modelIndustry = new MasIndustry();
            $modelIndustry->created_by = Yii::app()->user->id;
            $modelIndustry->created_datetime = date('Y-m-d h:i:s');
            $modelIndustry->name = $name;
            if ($modelIndustry->save()) {
                if ($from == 'customer') {
                    $model = new Customer;
                    $data = MasIndustry::getIndustries();
                    $field_name = 'customer_industry';
                }
                $model->$field_name = $modelIndustry->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Industry'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelIndustry, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    // public function actionBlockindustry() {
    //     $id = $_POST['id'];
    //     if ($id > 0) {
    //         MasIndustry::model()->updateByPK($id, array('isActive' => "N"));
    //          // inserting to audit log
    //          $model=new MasIndustry();
    //          $upt = $model->findByPk($id); // audit log changes
    //          AuditLog::saveAuditLogs(
    //              'INDUSTRY',
    //              Yii::app()->user->id,
    //              'BLOCKED',
    //              " with name: - {$upt->name}  "
    //          );
    //         // end audit log
    //         $status['status'] = 'success';
    //     } else {
    //         $status['status'] = 'error';
    //     }
    //     echo CJSON::encode($status);
    // }

    // public function actionUnBlockindustry() {
    //     $id = $_POST['id'];
    //     if ($id > 0) {
    //         MasIndustry::model()->updateByPK($id, array('isActive' => "Y"));
    //          // inserting to audit log
    //          $model=new MasIndustry();
    //          $upt = $model->findByPk($id); // audit log changes
    //          AuditLog::saveAuditLogs(
    //              'INDUSTRY',
    //              Yii::app()->user->id,
    //              'UNBLOCKED',
    //              " with name: - {$upt->name}  "
    //          );
    //         // end audit log
    //         $status['status'] = 'success';
    //     } else {
    //         $status['status'] = 'error';
    //     }
    //     echo CJSON::encode($status);
    // }
    
     public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasIndustry();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

}
