<?php

class EmiratesController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','Save','Delete'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}

	// Uncomment the following methods and override them if needed
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetList()
        {
                $model=new MasEmiratesList();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'emirates_name',
                   1 =>'id',
                   1 =>'created_datetime',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (emirates_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 foreach ($model as $row)
                {
                    $div = '';
                    $div .=   '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'emirates/create&id='.$row['id'].'\',\'Edit\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    $rowData[]=array($m,$row['emirates_name'],'<div class="btn-wrap text-center">'.$div.'</div>');
                    $m++;
                    
                }

                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasEmiratesList();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('emirates_form', array('model' => $model), false, false);
        }
  
  
        public function actionSave()
        {
            $model = new MasEmiratesList();
            if (isset($_POST['MasEmiratesList']))
            {
    		$model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
    		if ((int) @$_POST['MasEmiratesList']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasEmiratesList']['id'];
                    $model=$model->findByPk($id);  
                }
                $model->country_id ="143";
                $model->attributes=$_POST['MasEmiratesList'];
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['emirates-form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        public function actionDelete(){
       
		$id = $_POST['id'];
                
                 if($id>0){
                        $model=new MasEmiratesList();
                        $model->deleteByPk($id);
                        echo "success";
                 }   
                 else{
                     echo "fail";
                 }
               
    }
         
}