<?php

class EmicategoryController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'DeleteItem'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new EmiCategory();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
// datatable column index  => database column title
            0 => 'id',
            1 => 'name',
            2 => 'name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (t.name LIKE '%" . $searchString . "%' )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_Emi_edit"])) {
//  $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Emi/create&id='.$row['id'].'\',\'Edit Emi\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            }
            $rowData[] = array($m,
                $row->name,
                $row->isActive,
                array('id' => $row['id'], 'code' => $row['name']));


            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new EmiCategory();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSave() {
        $model = new EmiCategory();
        if (isset($_POST['EmiCategory'])) {
            if ((int) @$_POST['EmiCategory']['id'] > 0) {
                $id = (int) @$_POST['EmiCategory']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }

            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d h:i:s');
            $model->attributes = $_POST['EmiCategory'];
            if ($model->save()) {
                echo json_encode([
                    'id' => $model->id,
                    'status' => 'success'
                        ]
                );
            } else {
                echo CActiveForm::validate($model, '', false);
            }
        }
    }

    function actionDeleteItem() {
        $id = Yii::app()->request->getParam('id');
        $model = new EmiCategory();
        $del = $model->findByPk($id); // audit log changes
        $model->deleteByPk($id);
        echo "success";
    }

}
