<?php

class EmiController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveEmi', 'DeleteItem','Deleteemi'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new FinanceEmi();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column title
            /*0 => 'id',
            1 => 'id',
            2 => 't.name',
            3 => 'starting_date',
            4 => 'starting_date'*/
            
            0 => 'id',
            1 => 't.id',
            2 => 't.name',
            3 => 't.id',
            4 => 'starting_date',
            5 => 'Num_of_installment',
            6 => 'amount'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (t.name LIKE '%" . $searchString . "%' )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_Emi_edit"])) {
                //  $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Emi/create&id='.$row['id'].'\',\'Edit Emi\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            }
            $rowData[] = array($m,
                $row->id,
                $row->name,
                $row->type->name,
                date("d/m/Y", strtotime($row->starting_date)),
                "<div class = 'text-right' >{$row->Num_of_installment}</div>",
                "<div class = 'text-right' >" . number_format($row->amount, 2) . "</div>",
                array('id' => $row['id'], 'code' => $row['name']));


            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new FinanceEmi();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSaveEmi() {
        $model = new FinanceEmi();
        if (isset($_POST['FinanceEmi'])) {
            if ((int) @$_POST['FinanceEmi']['id'] > 0) {
                $id = (int) @$_POST['FinanceEmi']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }

            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d h:i:s');
            $model->attributes = $_POST['FinanceEmi'];

            $valid = $model->validate();
            $period = 0;
            $installment_array = array();
            if ($valid) {
                if ($model->starting_date != "") {
                    //21/04/2020
                    $date_array = explode("/", $model->starting_date);
                    $model->starting_date = $date_array[2] . "-" . $date_array[1] . "-" . $date_array[0];
                }

                $installment_amt = $model->amount / $model->Num_of_installment;
                $typeModel = FinanceEmiType::model()->findByPk($model->type_id);
                $period = $typeModel->period;
                $num_of_installment = $model->Num_of_installment;
                $current_installment = (int) $model->current_installment;
                $installments = [];
                if (isset($_POST["FinanceEmiInstallment"])) {
                    $installments = $_POST["FinanceEmiInstallment"];
                    if (count($installments) != $model->Num_of_installment) {
                        $json = [
                            "Num_of_installment" => ["Instalment count not matched"]
                        ];
                        echo json_encode($json);
                        die();
                    }
                }


                for ($index = 0; $index < $num_of_installment; $index++) {
                      $month = ($index + 1) * $period;
                    $installment_array[$index] = new FinanceEmiInstallment();
                    $installment_array[$index]->created_by = Yii::app()->user->id;
                    $installment_array[$index]->created_date_time = date('Y-m-d h:i:s');
                    $installment_array[$index]->updated_by = Yii::app()->user->id;
                    $installment_array[$index]->updated_date_time = date('Y-m-d h:i:s');
                    $installment_array[$index]->emi_id = 0;
                    $installment_array[$index]->attributes = $installments[$index];
                    
                    if (empty($installment_array[$index]->amount)) {
                        $installment_array[$index]->amount = $installment_amt;
                        $effectiveDate = date('Y-m-d', strtotime("+ {$month} months", strtotime($model->starting_date)));
//                        $due_date_array = explode("/", $installments[$index]['due_date']);
//                        $effectiveDate = $due_date_array[2] . "-" . $due_date_array[1] . "-" . $due_date_array[0];
                    } else {
                        $due_date_array = explode("/", $installments[$index]['due_date']);
                        $due_date = $due_date_array[2] . "-" . $due_date_array[1] . "-" . $due_date_array[0];
                        $effectiveDate = $due_date;
                    }
                    $installment_array[$index]->isActive = ($current_installment > $index) ? "Y" : "N";
                  


                    $installment_array[$index]->due_date = $effectiveDate;

                    if (isset($installments[$index]) && !empty($installments[$index]['id'])) {
                        $installment_array[$index] = FinanceEmiInstallment::model()->findByPk($installments[$index]['id']);
                        $installment_array[$index]->attributes = $installments[$index];

                        $installment_array[$index]->amount = $installments[$index]["amount"];
                        $due_date_array = explode("/", $installments[$index]['due_date']);
                        $due_date = $due_date_array[2] . "-" . $due_date_array[1] . "-" . $due_date_array[0];
                        $installment_array[$index]->due_date = $due_date;
                    }

                    $valid = $valid && $installment_array[$index]->validate();
                }
            }
            if ($valid) {
                $model->save();
                // inserting to audit log
                // end audit log
                foreach ($installment_array as $value) {
                    $value->emi_id = $model->id;
                    $value->save();
                }
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['Emi_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($installment_array, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteItem() {
        $id = Yii::app()->request->getParam('id');

        $model = new FinanceEmiInstallment();
        $del = $model->findByPk($id); // audit log changes
        $model->deleteByPk($id);
        // inserting to audit log
        // end audit log
        echo "success";
    }
    
    public function actionDeleteemi() {
        $id = Yii::app()->request->getParam('id');

        $model = new FinanceEmi();
        $del = $model->findByPk($id); 
        if(!empty($del))
        {
        $model->deleteByPk($id);
        FinanceEmiInstallment::model()->deleteAll(array('condition'=>'emi_id='.$id));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
        }
        else {
        $jsonData['status'] = 'fail';
        echo CJSON::encode($jsonData);
        }
    }
}
