<?php

class DeallocationController extends Controller
{

        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetFilesForDeallocation','GetFileDetails','Deallocatefiles','GetAllocationDetails'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
		$this->render('index');
	}

	// Uncomment the following methods and override them if needed
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
    public function actionGetFilesForDeallocation() 
    {
     
        $searchTerm = $_GET['term'];
        $file_string ='"Q", "O"';
        $criteria  = new cdbCriteria;
        $condition  = 'isActive="Y"';
        if($file_string!="")
        {
            $condition.=' AND current_process_status in (' . $file_string . ')';
        }
        $condition .= 'AND id LIKE "%' . $searchTerm . '%" OR t.current_process_status LIKE "%' . $searchTerm . '%"';
        $model = new MasterFile();
        $model = $model->findAll(array('condition' => $condition, 'order' => 'id DESC,current_process_status'));
        //return CHtml::listData($model, 'id', 'id_with_status');
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->id.' : '.$eachModel->status;            
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();    
         
            
    }
    public function actionGetFileDetails($id=0)
    {
            $file_id = (int) Yii::app()->request->getParam('file_id');
            $modelFile = new MasterFile();
            $modelAllocation =array(new AllocatedMaterial());
            $modelFile 		= $modelFile->with('quote.items', 'order.items1')->findByPK($file_id, array('order' => 'items.id ASC,items1.id ASC'));
            $addition_amount = 0;
            $deduction_amount = 0;
            switch ($modelFile->current_process_status) {
                    case 'Q':
                            $model = $modelFile->quote;
                            $model->items =$modelAllocation[0]->findAll(array('condition'=>'file_id ='.$file_id));
                            break;
                    default:
                            $model = $modelFile->order;
                            $model->items =$modelAllocation[0]->findAll(array('condition'=>'file_id ='.$file_id));
                            break;
            }
            Yii::app()->clientScript->scriptMap = array( '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->renderPartial('file_details', array('file_id'=>$id,'model'=>$model,'modelFile'=>$modelFile), false, true);
		
    }
     public function actionGetAllocationDetails()
    {
        $product_id = (int) Yii::app()->request->getParam('product_id');
        $modelStore = new Store();
        $modelStore = $modelStore->findByPk($product_id);
        $modelAllocation =new AllocatedMaterial();
        $arr_allocated_products=$modelAllocation->findAll(array('condition'=>'product_id ='.$product_id));
        Yii::app()->clientScript->scriptMap = array( '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('product_allocation_details', array('product_id'=>$product_id,'model'=>$modelAllocation,'arr_allocated_products'=>$arr_allocated_products,'modelStore'=>$modelStore), false, true);
		
    }
    public function actionDeallocatefiles() {
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $arr_deallocate_ids=array();
        $arr_deallocate_ids=$_POST['deallocateids'];
        if(!empty($arr_deallocate_ids)){
            foreach ($arr_deallocate_ids as $id){
                AllocatedMaterial::model()->deleteByPK((int) $id);
            }    
            $data['status']="success";
        }else{
            $data['status']="fail";
        }
        echo CJSON::encode($data);
        Yii::app()->end(); 
    }
}