<?php

class DashboardmatrixEmployeeController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow',
                'actions' => array('LoadSalesDetails', 'Index', 'LoadSalesInvoiceDetails', 'CustomerSales', 'ProductSales','VehicleSales','LoadEmployeeDetails','LoadEmployeeSalaryDetails'),
                'expression' => '$user->isMember()',
            ),
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex()
    {
        $this->render('index');
    }


    public function actionLoadSalesDetails()
    {
        $yearStart = date('Y-01-01 00:00:00');
        $yearEnd = date('Y-12-31 23:59:59');
        $currentYear = date("Y");
        $lastYear = $currentYear - 1;

        $lastYearStart = $lastYear . '-01-01 00:00:00';
        $lastYearEnd = $lastYear . '-12-31 23:59:59';

        if (Yii::app()->request->isPostRequest) {
            $employeeId = isset($_POST['employee_id']) ? (int) $_POST['employee_id'] : 0;

            $userIds = [];
            if ($employeeId != 0) {
                $users = User::model()->findAllByAttributes(['hr_connected_employee_id' => $employeeId]);
                foreach ($users as $u) {
                    $userIds[] = (int) $u->id;
                }
            }

            $conditionCustomer = "created_date_time BETWEEN :start AND :end";
            $conditionLead = "enq_date BETWEEN :start AND :end";
            $conditionQuote = "qtn_start_date BETWEEN :start AND :end";
            $conditionOrder = "order_date BETWEEN :start AND :end";
            $conditionInvoice = "invoice_date BETWEEN :start AND :end";
            $conditionCredit = "credited_date BETWEEN :start AND :end";
            if (!empty($userIds)) {
                $inList = implode(',', $userIds);

                $conditionCustomer .= " AND lead_owner_id IN ($inList)";
                $conditionLead .= " AND lead_owner_id IN ($inList)";
                $conditionQuote .= " AND lead_owner_id IN ($inList)";
                $conditionOrder .= " AND lead_owner_id IN ($inList)";
                $conditionInvoice .= " AND lead_owner_id IN ($inList)";
                $conditionCredit .= " AND crm_user_id IN ($inList)";
            }
            $params = function ($start, $end) {
                return [':start' => $start, ':end' => $end];
            };

            // ---------- Customers ----------
            $yearCustomerCount = Customer::model()->count($conditionCustomer, $params($yearStart, $yearEnd));
            $lastYearCustomerCount = Customer::model()->count($conditionCustomer, $params($lastYearStart, $lastYearEnd));

            // ---------- Leads ----------
            $yearLead = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(value),0) as total")
                ->from("erp_lead")
                ->where($conditionLead, $params($yearStart, $yearEnd))
                ->queryRow();

            $lastYearLead = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(value),0) as total")
                ->from("erp_lead")
                ->where($conditionLead, $params($lastYearStart, $lastYearEnd))
                ->queryRow();

            // ---------- Quotes ----------
            $yearQuote = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_quotes")
                ->where($conditionQuote, $params($yearStart, $yearEnd))
                ->queryRow();

            $lastYearQuote = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_quotes")
                ->where($conditionQuote, $params($lastYearStart, $lastYearEnd))
                ->queryRow();

            // ---------- Orders ----------
            $yearOrder = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_order")
                ->where($conditionOrder, $params($yearStart, $yearEnd))
                ->queryRow();

            $lastYearOrder = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_order")
                ->where($conditionOrder, $params($lastYearStart, $lastYearEnd))
                ->queryRow();

            // ---------- Invoices ----------
            $yearInvoice = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_invoice")
                ->where($conditionInvoice, $params($yearStart, $yearEnd))
                ->queryRow();

            $lastYearInvoice = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_invoice")
                ->where($conditionInvoice, $params($lastYearStart, $lastYearEnd))
                ->queryRow();

            // ---------- Credit Notes ----------
            $yearCreditNote = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(credited_amount * exchange_rate),0) as total")
                ->from("erp_creditnote")
                ->where($conditionCredit, $params($yearStart, $yearEnd))
                ->queryRow();

            $lastYearCreditNote = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(credited_amount * exchange_rate),0) as total")
                ->from("erp_creditnote")
                ->where($conditionCredit, $params($lastYearStart, $lastYearEnd))
                ->queryRow();

            $this->renderPartial('sales_details', [
                'yearCustomerCount' => $yearCustomerCount,
                'lastYearCustomerCount' => $lastYearCustomerCount,
                'yearLead' => $yearLead,
                'lastYearLead' => $lastYearLead,
                'yearQuote' => $yearQuote,
                'lastYearQuote' => $lastYearQuote,
                'yearOrder' => $yearOrder,
                'lastYearOrder' => $lastYearOrder,
                'yearInvoice' => $yearInvoice,
                'lastYearInvoice' => $lastYearInvoice,
                'yearCreditNote' => $yearCreditNote,
                'lastYearCreditNote' => $lastYearCreditNote,
            ], false, true);

        } else {
            throw new CHttpException(400, 'Invalid request.');
        }
    }
    public function actionCustomerSales()
    {
        $employeeId = isset($_POST['employee_id']) ? (int) $_POST['employee_id'] : 0;
        $userIds = array();

        if ($employeeId != 0) {
            $users = User::model()->findAllByAttributes(array('hr_connected_employee_id' => $employeeId));
            foreach ($users as $user) {
                $userIds[] = (int) $user->id;
            }
        }

        $currentYear = date("Y");
        $lastYear = $currentYear - 1;

        $currentYearStart = $currentYear . "-01-01 00:00:00";
        $currentYearEnd = $currentYear . "-12-31 23:59:59";

        $lastYearStart = $lastYear . "-01-01 00:00:00";
        $lastYearEnd = $lastYear . "-12-31 23:59:59";

        $customerSales = array();
        $invoiceCounts = array();

        foreach (['last', 'current'] as $yearType) {
            if ($yearType == 'last') {
                $startDate = $lastYearStart;
                $endDate = $lastYearEnd;
            } else {
                $startDate = $currentYearStart;
                $endDate = $currentYearEnd;
            }

            $criteria = new CDbCriteria();
            $criteria->condition = "t.transaction_from = 'DELIVERY_NOTE'";

            $criteria->with = array(
                'invoice' => array('on' => 'invoice.id = t.reference_no', 'together' => true),
                'customer',
                'product'
            );

            if (!empty($userIds)) {
                $criteria->addInCondition('invoice.lead_owner_id', $userIds);
            }

            $criteria->addCondition("invoice.invoice_date >= :startDate AND invoice.invoice_date <= :endDate");
            $criteria->params[':startDate'] = $startDate;
            $criteria->params[':endDate'] = $endDate;

            $entries = StockLedger::model()->findAll($criteria);

            $salesData = array();
            $invoiceTracker = array();

            foreach ($entries as $entry) {
                $customerName = isset($entry->invoice->customer) ? $entry->invoice->customer->customer_name : 'Unknown Customer';
                $invoiceId = $entry->invoice->id;
                $value = abs($entry->quantity * $entry->sales_price);

                if (!isset($salesData[$customerName])) {
                    $salesData[$customerName] = 0;
                    $invoiceTracker[$customerName] = array();
                }

                $salesData[$customerName] += $value;
                $invoiceTracker[$customerName][$invoiceId] = true;
            }

            // Sort by sales amount descending (optional)
            arsort($salesData);

            $invoiceCountsForYear = array();
            foreach ($salesData as $customerName => $amount) {
                $invoiceCountsForYear[$customerName] = isset($invoiceTracker[$customerName]) ? count($invoiceTracker[$customerName]) : 0;
            }

            $customerSales[$yearType] = $salesData;
            $invoiceCounts[$yearType] = $invoiceCountsForYear;
        }

        $this->render('customer_sales_details', array(
            'lastYearSales' => $customerSales['last'],
            'currentYearSales' => $customerSales['current'],
            'lastYearInvoiceCounts' => $invoiceCounts['last'],
            'currentYearInvoiceCounts' => $invoiceCounts['current'],
        ));
    }

    public function actionProductSales()
    {
        $employeeId = isset($_POST['employee_id']) ? (int) $_POST['employee_id'] : 0;
        $userIds = [];

        if ($employeeId != 0) {
            $users = User::model()->findAllByAttributes(['hr_connected_employee_id' => $employeeId]);
            foreach ($users as $user) {
                $userIds[] = (int) $user->id;
            }
        }

        $currentYear = date("Y");
        $lastYear = $currentYear - 1;

        $yearRanges = [
            'last' => [
                'start' => "$lastYear-01-01 00:00:00",
                'end' => "$lastYear-12-31 23:59:59",
            ],
            'current' => [
                'start' => "$currentYear-01-01 00:00:00",
                'end' => "$currentYear-12-31 23:59:59",
            ],
        ];

        $productSales = [];

        foreach ($yearRanges as $yearType => $range) {
            // Build the base SQL query
            $sql = "
            SELECT 
                sl.product_id, 
                p.description AS product_description, 
                SUM(sl.quantity) AS qty, 
                SUM(ABS(sl.cost_price)) AS total_cost_price, 
                SUM(ABS(sl.sales_price)) AS total_sales_price
            FROM erp_stock_ledger sl
            LEFT JOIN erp_invoice i ON sl.reference_no = i.id
            LEFT JOIN erp_store p ON p.id = sl.product_id
            WHERE sl.transaction_from = 'DELIVERY_NOTE'
            AND i.invoice_date BETWEEN :startDate AND :endDate
        ";

            if (!empty($userIds)) {
                // Prepare user filter string for SQL IN clause
                $inCondition = implode(',', array_map('intval', $userIds));
                $sql .= " AND i.lead_owner_id IN ($inCondition)";
            }

            $sql .= " GROUP BY sl.product_id ORDER BY sl.product_id";

            $command = Yii::app()->db->createCommand($sql);
            $command->bindValue(':startDate', $range['start'], PDO::PARAM_STR);
            $command->bindValue(':endDate', $range['end'], PDO::PARAM_STR);

            $rows = $command->queryAll();

            $data = [];

            foreach ($rows as $row) {
                $gp = $row['total_sales_price'] - $row['total_cost_price'];
                $gpPercent = $row['total_cost_price'] != 0 ? ($gp / $row['total_cost_price']) * 100 : 0;

                $data[$row['product_description']] = [
                    'qty' => abs($row['qty']),
                    'sales_value' => (float) $row['total_sales_price'],
                    'cost_value' => (float) $row['total_cost_price'],
                    'gp' => $gp,
                    'gp_percent' => $gpPercent,
                ];
            }

            $productSales[$yearType] = $data;
        }

        $this->render('product_sales_details', [
            'lastYearProductSales' => $productSales['last'],
            'currentYearProductSales' => $productSales['current'],
        ]);
    }
    
    
     public function actionVehicleSales()
    {
        $employeeId = isset($_POST['employee_id']) ? (int) $_POST['employee_id'] : 0;
        $vehicleDetails = [];
        $VehicleCostDetails = [];
         $CurrentVehicleCostDetails = [];

        // if ($employeeId != 0) {
             $vehicleDetails = VehicleAllotment::model()->with('vehicle')->findAll(['condition' => 'employee_id='.$employeeId,'group'=>'t.vehicle_id']);
        //      foreach($vehicleDetails as $eachDetails)
        //     {
        //     $vehicleCostData = MasMaintainanceService::model()->find(array('select'=>'SUM(total_cost) as total_cost','condition'=>'vehicle_name='.$eachDetails['vehicle_id']));
        //     $VehicleCostDetails[$eachDetails['vehicle_id']] = $vehicleCostData->total_cost;
        //     }
            
             $sql = "SELECT va.vehicle_id, va.employee_id, va.from_date, va.to_date
                        FROM erp_vehicle_allotment va
                        INNER JOIN (
                            SELECT vehicle_id, MAX(to_date) AS max_to_date
                            FROM erp_vehicle_allotment
                            GROUP BY vehicle_id
                        ) latest ON va.vehicle_id = latest.vehicle_id
                                AND va.to_date = latest.max_to_date;";
            $rows = Yii::app()->db->createCommand($sql)->queryAll();
             
        //}
         
        
       $this->render('vehicle_sales_details', [
            'vehicleDetails' => $vehicleDetails,
            'VehicleCostDetails' => $VehicleCostDetails,'CurrentVehicleCostDetails'=>$CurrentVehicleCostDetails,'CurrentVehicleDetails'=>$rows,'employeeId'=>$employeeId
        ]);
    }
    public function actionLoadEmployeeDetails() {
        $employeeId = isset($_POST['employee_id']) ? (int) $_POST['employee_id'] : 0;
        if($employeeId>0){
            $modelemployee = Employee::model()->findByPk($employeeId);
        }
        $this->render('employee_details', [
            'employeeDetails' => $modelemployee,'employeeId' => $employeeId
        ]);
    }
    public function actionLoadEmployeeSalaryDetails() {
        $employeeId = isset($_POST['employee_id']) ? (int) $_POST['employee_id'] : 0;
        if($employeeId>0){
            $modelemployee = Employee::model()->findByPk($employeeId);
            $current_date =date('Y-m-d');
            $current_year=date('Y');
            $previous_year=date('Y')-1;
           // $current_date =date('Y-m-d');
            $salary_current_year = SalarySlip::model()->with('processing')->find(array('select' => 'sum(total_salary_amount) as total_salary_amount,sum(salary_advance_amount) as salary_advance_amount,sum(gratuity_amount) as gratuity_amount,sum(loan_amount) as loan_amount','condition' => 'employee_id="' . $employeeId . '" and YEAR(processing.payroll_enddate)= "' . $current_year . '"'));
            $salary_current_previous = SalarySlip::model()->with('processing')->find(array('select' => 'sum(total_salary_amount) as total_salary_amount,sum(salary_advance_amount) as salary_advance_amount,sum(gratuity_amount) as gratuity_amount,sum(loan_amount) as loan_amount','condition' => 'employee_id="' . $employeeId . '" and YEAR(processing.payroll_enddate)= "' . $previous_year . '"'));
            $model_leave_details = EmployeeLeaveDetail::model()->find(array('select' => 'sum(normal_leave) as normal_leave', 'condition' => 'YEAR(leave_start_date)="' . $current_year . '" AND employee_id="' . $employeeId . '" and leave_status="12"'));
            if ($model_leave_details->normal_leave > 0) {
                $leave_taken_current = $model_leave_details->normal_leave;
            }
            $model_ticket_encashed_previous = EmployeeTicketEncashment::model()->find(array('select' => 'sum(ticket_amt) as ticket_amt' ,'condition' => 'employee_id="' . $employeeId . '" and year="' . $previous_year . '" and (status!="3" OR status!="5" OR status!="7" OR status!="9" OR status!="11" OR status!="13")'));
            $model_ticket_encashed = EmployeeTicketEncashment::model()->find(array('select' => 'sum(ticket_amt) as ticket_amt' ,'condition' => 'employee_id="' . $employeeId . '" and year="' . $current_year . '" and (status!="3" OR status!="5" OR status!="7" OR status!="9" OR status!="11" OR status!="13")'));
            $model_ticket_current = EmployeeTicket::model()->find(array('select' => 'sum(ticket_amt) as ticket_amt' ,'condition' =>'employee_id="' . $employeeId . '" and year="' . $current_year . '" AND ticket_type="E" and (status!="3" OR status!="5" OR status!="7" OR status!="9" OR status!="11" OR status!="13")'));
            $model_ticket_previous = EmployeeTicket::model()->find(array('select' => 'sum(ticket_amt) as ticket_amt' ,'condition' =>'employee_id="' . $employeeId . '" and year="' . $previous_year . '" AND ticket_type="E" and (status!="3" OR status!="5" OR status!="7" OR status!="9" OR status!="11" OR status!="13")'));
            $ticket_amount_current =$model_ticket_encashed->ticket_amt+$model_ticket_current->ticket_amt;
            $ticket_amount_prev =$model_ticket_encashed_previous->ticket_amt+$model_ticket_previous->ticket_amt;
            Yii::import('application.modules.hr.controllers.EosdetailsController');
            $gratuity_amt = EosdetailsController::geteos($employeeId, $current_date, 1);
         //   $gratuity_amt_prev = EosdetailsController::geteos($employeeId->id, $current_date, 1);
            $model_leavetaken_current = EmployeeAttendance::model()->count(array('condition' => 'employee_id="' . $employeeId . '" and YEAR(attendance_date)="' . $current_year . '" AND (status=3 AND status=3)'));
            $model_leavetakece_prev = EmployeeAttendance::model()->count(array('condition' => 'employee_id="' . $employeeId . '" and YEAR(attendance_date)="' . $previous_year . '" AND (status=3 AND status=3)'));
            }
        $this->render('employee_salary_details', ['ticket_amount_current'=>$ticket_amount_current,'ticket_amount_prev'=>$ticket_amount_prev,'gratuity_amt'=>$gratuity_amt,'gratuity_amt_prev'=>$gratuity_amt_prev,
            'employeeDetails' => $modelemployee,'salary_current_year'=>$salary_current_year,'salary_current_previous'=>$salary_current_previous,'leave_taken_current_year'=>$leave_taken_current,'model_ticket'=>$model_ticket,
            'model_leavetaken_current'=>$model_leavetaken_current,'model_leavetakece_prev'=>$model_leavetakece_prev
        ]);
    }
}