<?php

class CurrencyController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetCurrencyList', 'SaveCurrency', 'DisableCurrency', 'DirectAdd','UploadEmployeecsv',
                'Uploadcurrency',
                'DownloadSampleCsv','readCurrencyCSV','DownloadErrorCsv','SaveCurrencyUploadCsv'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['currency_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['currency_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetCurrencyList() {
        $model = new MasCurrency();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'currency',
            2 => 'currency_code',
            3 => 'exchange_rate',
            4 => 'isBaseCurrency' // <-- New column
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        // $condition = 't.isActive="Y"';
    
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $condition = "1=1 ";
            $searchString = $_POST['search']['value'];
            $condition .= " and (currency LIKE '%" . $searchString . "%' OR currency_code LIKE '%" . $searchString . "%')";
        }
    
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array(
            'condition' => $condition,
            'limit' => $limit,
            'offset' => $offset,
            'order' => $orderBy
        ));
    
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
    
        $rowData = array();
        $m = 1;
    
        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["currency_edit"])) {
                // $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'currency/create&id='.$row['id'].'\',\'Edit Currency\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["currency_delete"])) {
                // $div .= '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCurrency('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            }
    
            $rowData[] = array(
                $m,
                $row['currency'],
                $row['currency_code'],
                $row['exchange_rate'],
                $row['isBaseCurrency'], // <-- Include the value
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['currency'], 'isActive' => $row['isActive'])
            );
            $m++;
        }
    
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    

    public function actionCreate() {
        $model = new MasCurrency();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('currency_form', array('model' => $model), false, false);
    }

    public function actionSaveCurrency() {
        $model = new MasCurrency();
        if (isset($_POST['MasCurrency'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['MasCurrency']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasCurrency']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            if($_POST['MasCurrency']['isBaseCurrency'] == "Y"){
                MasCurrency::model()->updateAll(array( 'isBaseCurrency' => 'N' ), 'isBaseCurrency = "Y"' );
            }
            $model->attributes = $_POST['MasCurrency'];
            $model->isBaseCurrency=$_POST['MasCurrency']['isBaseCurrency'];
            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'CURRENCIES', Yii::app()->user->id, $audit_type, " with code: - {$model->currency_code}  "
                );
                // end audit log 
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['currency_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
                // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
            // $this->render('currency_form', array('model' => $model), false, true);
        }
    }

    public function actionDisableCurrency() {
        date_default_timezone_set("Asia/Dubai");
        $id = $_POST['id'];
        /* $model_c = Customer::model()->findAll(array('condition' =>'customer_currency_id = '.$id.' '));
          $model_com = Company::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_cr = Creditnote::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_in = Invoice::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_l = Lead::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_o = Order::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_pi = PurchasingInvoice::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_po = PurchasingOrder::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_q = Quotes::model()->findAll(array('condition' =>'currency = '.$id.' '));
          $model_v = Vendor::model()->findAll(array('condition' =>'vendor_currency_id = '.$id.' '));
          if(empty($model_c) && empty($model_com) && empty($model_cr) && empty($model_in) && empty($model_l) && empty($model_o) && empty($model_pi) && empty($model_po) && empty($model_q) && empty($model_v)){
         */
        if (!empty($id)) {
            $model = new MasCurrency();
            $model = $model->findByPk($id);
            print_r($model) ;
            if ($model->isActive == 'N') {
                $model->isActive = 'Y';
            }else{
                $model->isActive = 'N';            
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_datetime = date('Y-m-d h:i:s');
            $model->save(FALSE);
            echo "success";
        } else {
            echo "fail";
        }
    }

    public function actionDirectAdd() {
        $from = $_POST['from'];
        $name = $_POST['name'];
        $code = $_POST['code'];
        $rate = $_POST['rate'];
        if ($name != '' && $code != '' && $rate != '') {
            $modelCurrency = new MasCurrency;
            $modelCurrency->created_by = Yii::app()->user->id;
            $modelCurrency->created_datetime = date('Y-m-d h:i:s');
            $modelCurrency->currency = $name;
            $modelCurrency->currency_code = $code;
            $modelCurrency->exchange_rate = $rate;
            if ($modelCurrency->save()) {
                $data = MasCurrency::getCurrency();
                if ($from == 'customer') {
                    $model = new Customer;
                    $field_name = 'customer_currency_id';
                }
                if ($from == 'lead') {
                    $model = new Lead;
                    $field_name = 'currency';
                }
                if ($from == 'quote') {
                    $model = new Quotes;
                    $field_name = 'currency';
                }
                if ($from == 'order') {
                    $model = new Order;
                    $field_name = 'currency';
                }
                if ($from == 'invoice') {
                    $model = new Invoice;
                    $field_name = 'currency';
                }
                if ($from == 'vendor') {
                    $model = new Vendor;
                    $field_name = 'vendor_currency_id';
                }
                $model->$field_name = $modelCurrency->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Currency'));
                $status = array("status" => "success", "drop" => $drop, "rate" => $modelCurrency->exchange_rate);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelCurrency, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionUploadcurrency(){
        //added by nisha on 28-02-2023
        $model=new MasCurrency();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_currency', array('model' => $model), false, true);
    }
    public function actionSaveCurrencyUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');
        $url = Yii::app()->basePath . '/../uploads/currency_csv/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/currency_csv/error/' . $file_name;
    
        if (!file_exists($url)) {
            echo CJSON::encode([
                'status' => 'error',
                'message' => 'Uploaded CSV file not found: ' . $file_name
            ]);
            return;
        }
    
        $currency_list = $this->readcurrencyCSV("uploads/currency_csv/" . $file_name);
        if (empty($currency_list) || count($currency_list) < 2) {
            echo CJSON::encode([
                'status' => 'error',
                'message' => 'CSV file is empty or missing header.'
            ]);
            return;
        }
    
        $validate = true;
        $error_list = array();
        $currency_error_names = array();
        $currency_models = array();
    
        foreach (array_slice($currency_list, 1) as $i => $data) {
            if (!empty($data[0])) {
                $currency_models[$i] = new MasCurrency();
                $currency_models[$i]->scenario = "excelupload";
    
                $currency_models[$i]->currency = trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]));
                $currency_models[$i]->currency_code = trim($data[1]);
                $currency_models[$i]->exchange_rate = trim($data[2]);
                $currency_models[$i]->isActive = 'Y';
                $currency_models[$i]->isBaseCurrency = 'N';
                $currency_models[$i]->created_by = Yii::app()->user->id;
                $currency_models[$i]->created_datetime = date('Y-m-d h:i:s');
                $currency_error_names[$i] = $currency_models[$i]->currency;
                $validate = $currency_models[$i]->validate() && $validate;
            }
        }
    
        function array_not_unique($raw_array) {
            $dupes = array();
            natcasesort($raw_array);
            reset($raw_array);
            $old_key = null;
            $old_value = null;
            foreach ($raw_array as $key => $value) {
                if ($value === null) continue;
                if ($old_value !== null && strcasecmp($old_value, $value) === 0) {
                    $dupes[$old_key] = $old_value;
                    $dupes[$key] = $value;
                }
                $old_value = $value;
                $old_key = $key;
            }
            return $dupes;
        }
    
        $dup_currency = array_not_unique($currency_error_names);
    
        if ($validate) {
            foreach ($currency_models as $eachModel) {
                $eachModel->save();
            }
            $jsonData['error'] = "";
        } else {
            foreach ($currency_models as $s => $data_model) {
                $error_list[$s]['currency'] = $data_model->currency;
                $error_list[$s]['currency_code'] = $data_model->currency_code;
                $error_list[$s]['exchange_rate'] = $data_model->exchange_rate;
                $error_list[$s]['errors'] = [];
    
                if (!$data_model->validate()) {
                    foreach ($data_model->getErrors() as $field => $messages) {
                        foreach ($messages as $msg) {
                            $error_list[$s]['errors'][] = "$field: $msg";
                        }
                    }
                }
            }
        }
    
        if (!empty($error_list)) {
            $file_error = fopen($error_url, "w+");
            fputcsv($file_error, ['Currency*', 'Currency Code*', 'Exchange Rate*', 'Errors']);
    
            foreach ($error_list as $i => $error_detail) {
                $error_message = implode(" / ", $error_detail['errors']);
                if (in_array($error_detail['currency'], $dup_currency)) {
                    $error_message .= " / Duplicate currency in CSV";
                }
                fputcsv($file_error, [
                    $error_detail['currency'],
                    $error_detail['currency_code'],
                    $error_detail['exchange_rate'],
                    $error_message
                ]);
            }
            fclose($file_error);
        }
    
        $jsonData['status'] = "success";
        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('currency/DownloadErrorCsv', 'id' => $file_name), array(
            'target' => '_blank',
            'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
        ));
    
        echo CJSON::encode($jsonData);
    }
    
    public function actionDownloadSampleCsv()
    {
        $filename = 'currencytemplate.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Currency*,Currency Code*,Exchange Rate *';
        Yii::app()->end();
    }
    public function readcurrencyCSV($csvFile)
    {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }
    public function actionDownloadErrorCsv() {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/currency_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
}
