<?php

class CheckinController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'UpdateStockDetails'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex()
    {
        $frm = Yii::app()->request->getParam('frm');
        $hire = Yii::app()->request->getParam('hire');
        $this->render('index', array('frm' => $frm, 'hire' => $hire));
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionGetList()
    {
        $model = new CheckinList();

        $frm = Yii::app()->request->getParam('frm');
        $hire = Yii::app()->request->getParam('hire');
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        //  $warehouse_id = $_POST['warehouse_id'];
        $warehouse_id = Yii::app()->request->getParam('warehouse_id');

        $columns = array(
            // datatable column index  => database column name
            0 => 't.transaction_id',
            1 => 't.file_id',
            2 => 't.customer_name',
            4 => 't.transaction_date',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';


        if ($warehouse_id > 0) {
            $condition .= 'AND t.warehouse_id=' . $warehouse_id;
        }

        if (!empty($frm)) {
            /*if ($frm == 'PR') {
                $condition = ' t.status="IGR" AND t.issue_type="PR" ';
            } else {*/
            $condition = "t.status='" . $frm . "'";
            //}
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            if($frm=="IGR")
            {
                $condition .= " AND (t.transaction_id LIKE '%" . $searchString . "%'   OR  receiptdetails.reference_id  LIKE '%" . $searchString . "%' OR  receiptdetails.service_order_id  LIKE '%" . $searchString . "%' OR  receiptdetails.file_id  LIKE '%" . $searchString . "%'  OR t.customer_name LIKE '%" . $searchString . "%' OR t.checkin_frm LIKE '%" . $searchString . "%')";
                //$condition .= " AND (t.transaction_id LIKE '%" . $searchString . "%'  OR  t.file_id  LIKE '%" . $searchString . "%'  OR t.customer_name LIKE '%" . $searchString . "%' OR t.checkin_frm LIKE '%" . $searchString . "%')";
            }
            else{
                $condition .= " AND (t.transaction_id LIKE '%" . $searchString . "%'  OR  t.file_id  LIKE '%" . $searchString . "%'  OR t.customer_name LIKE '%" . $searchString . "%' OR t.checkin_frm LIKE '%" . $searchString . "%')";
            }
            
       
        }

        if ($frm == 'CN' && $hire == '1') {
            //  $count = $model->with('creditdetails')->count(array('condition'=>$condition));
            //   $model=$model->with('creditdetails')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.transaction_date desc'));
            $SQL = "SELECT t.* FROM `view_checkin_list` `t` LEFT OUTER JOIN `erp_creditnote` `creditdetails` ON ( `t`.`transaction_id` = `creditdetails`.`id` ) WHERE ( $condition ) ORDER BY t.transaction_date DESC,t.transaction_id DESC LIMIT $limit ";
            $model = Yii::app()->db->createCommand($SQL)->queryAll();
            $count = count($model);
        } else if ($frm == 'IGR') {
            //  $count = $model->with('creditdetails')->count(array('condition'=>$condition));
            //   $model=$model->with('creditdetails')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.transaction_date desc'));
            $SQL = "SELECT t.* FROM `view_checkin_list` `t` LEFT  JOIN `erp_inventory_goods_receipt` `receiptdetails` ON ( `t`.`transaction_id` = `receiptdetails`.`id` ) WHERE ( $condition ) ORDER BY t.transaction_date DESC,t.transaction_id DESC LIMIT $limit ";
            $model = Yii::app()->db->createCommand($SQL)->queryAll();
            $count = count($model);
        } else {
            $count = $model->count(array('condition' => $condition));
            $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.transaction_date desc,t.transaction_id DESC'));
        }
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $transaction_date = date("d/m/Y", strtotime($row['transaction_date']));
            if(($row['status'] == "IGR")){
                $rowData[] = array(
                $row['transaction_id'],
                $row['receiptdetails']['reference_id'],
                $transaction_date,
                $row['customer_name'],
                $row['receiptdetails']['file_id'],
                $row['receiptdetails']['service_order_id'],
                $row['status']
                );
            }else{
                $rowData[] = array(
                $row['transaction_id'],
                '',
                $transaction_date,
                //$row['reference_id'],
                $row['customer_name'],
                '',//$row['reference'],
                ($row['status'] == "IGR") ? "Quality Check Not Done" : $row['checkin_frm'],
                $row['status']
            );
            }
            
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate_09_02_2023()
    {
        $model = new CheckinList();
        $transaction_id = (int) Yii::app()->request->getParam('id');
        $status = Yii::app()->request->getParam('status');
        if ($status != '') {
            $cndn = 'transaction_id=' . $transaction_id . ' AND status="' . $status . '"';
        } else {
            $cndn = 'transaction_id=' . $transaction_id;
        }
        $model = $model->find(array('condition' => $cndn));
        $status = $model->status;
        $warehouse = 0;
        $transaction_date = date('Y-m-d');
        if ($status == 'CN') {
            $transaction_from = 'CREDIT_NOTE';
            $model_master = Creditnote::model()->findByPk($transaction_id);
            $modelItems = CreditnoteItem::model()->findAll(array('condition' => 'creditnote_id =' . $transaction_id . ' AND returned_quantity>0'));
            if ($model_master->credited_date != "0000-00-00") {
                $transaction_date = $model_master->credited_date;
            }

        } else if ($status == 'PGR') {
            $transaction_from = 'PROD_GOODS_RECEIPT';
            $model_master = ProductionGoodsReceipt::model()->findByPk($transaction_id);
            $modelItems = ProductionGoodsReceiptItem::model()->findAll(array('condition' => 'PROD_GOODS_RECEIPT_id =' . $transaction_id));
            if ($model_master->goods_receipt_date != "0000-00-00") {
                $transaction_date = $model_master->goods_receipt_date;
            }
        } else if ($status == 'IGR') {
            $transaction_from = 'GOODS_RECEIPT';
            $model_master = InventoryGoodsReceipt::model()->findByPk($transaction_id);
            $modelItems = InventoryGoodsReceiptItem::model()->findAll(array('condition' => 'goods_receipt_id =' . $transaction_id));

            if ($model_master->goods_receipt_date != "0000-00-00") {
                $transaction_date = $model_master->goods_receipt_date;
            }
            $warehouse = $model_master->warehouse_id;
        } else if ($status == 'DTCK') {
            $transaction_from = 'TRANSFER_IN';
            $model_master = InventoryDirectTransfer::model()->findByPk($transaction_id);
            $modelItems = InventoryDirectTransferItem::model()->findAll(array('condition' => 'direct_transfer_id =' . $transaction_id));

            $warehouse = $model_master->to_warehouse_id;

            if ($model_master->transfer_date != "0000-00-00") {
                $transaction_date = $model_master->transfer_date;
            }
        } else if ($status == 'IDTCK') {
            $transaction_from = 'INDIRECT_TRANSFER_IN';
            $model_master = InventoryIndirectTransfer::model()->findByPk($transaction_id);
            $modelItems = InventoryIndirectTransferItem::model()->findAll(array('condition' => 'indirect_transfer_id =' . $transaction_id, 'order' => 'item_id'));
            $warehouse = $model_master->to_warehouse_id;

            if ($model_master->transfer_date != "0000-00-00") {
                $transaction_date = $model_master->transfer_date;
            }
        }
        $k = 0;
        if (!empty($modelItems)) {
            foreach ($modelItems as $eachItem) {
                $modelItems[$k] = new StockLedger;


                $modelItems[$k]->cost_price = "";

                if ($status == 'DTCK' || $status == 'IDTCK') {
                    $modelItems[$k]->product_id = $eachItem->item_id;
                } else {
                    $modelItems[$k]->product_id = $eachItem->product_id;
                }
                if (isset($eachItem->quantity) && $status != 'CN') {
                    $modelItems[$k]->quantity = $eachItem->quantity;
                } elseif (isset($eachItem->picked_qty)) {
                    $modelItems[$k]->quantity = $eachItem->picked_qty;
                } elseif (isset($eachItem->returned_quantity) && $status == 'CN') {
                    //$modelItems[$k]->quantity   = $eachItem->returned_quantity+$eachItem->returned_bonus_qty;
                    $modelItems[$k]->quantity = $eachItem->returned_quantity;
                } else if (isset($eachItem->transfer_qty) && ($status == 'DTCK' || $status == 'IDTCK')) {
                    $modelItems[$k]->quantity = $eachItem->transfer_qty;
                }

                if (isset($eachItem->rate) && $status == 'IGR') {//Inventory Goods Receipt
                    $modelItems[$k]->cost_price = $eachItem->rate;
                    $modelItems[$k]->unit_id = $eachItem->unit;
                    $modelItems[$k]->unit_name = $eachItem->unitdetails->name;
                    $modelItems[$k]->unit_factor = $eachItem->unitdetails->factor;

                } else if (isset($eachItem->rate) && $status == 'PGR') {//Production Goods receipt
                    $modelItems[$k]->cost_price = $eachItem->rate;
                    $modelItems[$k]->unit_id = $eachItem->unit;
                    $modelItems[$k]->unit_name = $eachItem->unitdetails_mes->name;
                    $modelItems[$k]->unit_factor = $eachItem->unitdetails_mes->factor;
                } elseif ($status == 'DTCK' && isset($eachItem->stock->rate)) {

                    $modelItems[$k]->cost_price = $eachItem->stock->rate;
                    $modelItems[$k]->unit_id = $eachItem->stock->unit_id;
                    $modelItems[$k]->unit_name = $eachItem->stock->unit->symbol;
                    $modelItems[$k]->unit_factor = 1;
                } elseif ($status == 'CN') {

                    $arr_product_details = Store::model()->findByPk($eachItem->product_id);
                    $modelItems[$k]->cost_price = $eachItem->rate;
                    $modelItems[$k]->unit_id = $eachItem->orderunit->id;
                    $modelItems[$k]->unit_name = $eachItem->orderunit->name;
                    $modelItems[$k]->unit_factor = $eachItem->orderunit->factor;
                } else {
                    $arr_product_details = Store::model()->findByPk($eachItem->product_id);
                    $modelItems[$k]->cost_price = $arr_product_details->rate;
                    $modelItems[$k]->unit_id = $arr_product_details->unit_id;
                    $modelItems[$k]->unit_name = $arr_product_details->unit->symbol;
                    $modelItems[$k]->unit_factor = 1;
                }

                $modelItems[$k]->id = $eachItem->id;
                $modelItems[$k]->header_id = $transaction_id;
                $modelItems[$k]->header_item_id = $eachItem->id;
                $modelItems[$k]->transaction_from = $transaction_from;
                $modelItems[$k]->customer_vendor_id = 0;
                $modelItems[$k]->customer_vendor_name = "";

                $k++;
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model_master, 'status' => $status, 'items' => $modelItems, 'warehouse' => $warehouse, 'transaction_date' => $transaction_date));
    }

    public function actionCreate()
    {
        $model = new CheckinList();
        $transaction_id = (int) Yii::app()->request->getParam('id');
        $status = Yii::app()->request->getParam('status');
        if ($status != '') {
            $cndn = 'transaction_id=' . $transaction_id . ' AND status="' . $status . '"';
        } else {
            $cndn = 'transaction_id=' . $transaction_id;
        }
        $model = $model->find(array('condition' => $cndn));
        $status = $model->status;
        $warehouse = 0;
        $transaction_date = date('Y-m-d');
        if ($status == 'CN') {
            $transaction_from = 'CREDIT_NOTE';
            $model_master = Creditnote::model()->findByPk($transaction_id);
            $modelheader_items = CreditnoteItem::model()->findAll(array('condition' => 'creditnote_id =' . $transaction_id . ' AND returned_quantity>0'));
            if ($model_master->credited_date != "0000-00-00") {
                $transaction_date = $model_master->credited_date;
            }

        } else if ($status == 'PGR') {
            $transaction_from = 'PROD_GOODS_RECEIPT';
            $model_master = ProductionGoodsReceipt::model()->findByPk($transaction_id);
            $modelheader_items = ProductionGoodsReceiptItem::model()->findAll(array('condition' => 'PROD_GOODS_RECEIPT_id =' . $transaction_id));
            if ($model_master->goods_receipt_date != "0000-00-00") {
                $transaction_date = $model_master->goods_receipt_date;
            }
        } else if ($status == 'IGR') {
            $transaction_from = 'GOODS_RECEIPT';
            $model_master = InventoryGoodsReceipt::model()->findByPk($transaction_id);
            $modelheader_items = InventoryGoodsReceiptItem::model()->findAll(array('condition' => 'goods_receipt_id=' . $transaction_id));

            if ($model_master->goods_receipt_date != "0000-00-00") {
                $transaction_date = $model_master->goods_receipt_date;
            }
            $warehouse = $model_master->warehouse_id;
        } else if ($status == 'DTCK') {
            $transaction_from = 'TRANSFER__IN';
            $model_master = InventoryDirectTransfer::model()->findByPk($transaction_id);
            $modelheader_items = InventoryDirectTransferItem::model()->findAll(array('condition' => 'direct_transfer_id =' . $transaction_id));

            $warehouse = $model_master->to_warehouse_id;

            if ($model_master->transfer_date != "0000-00-00") {
                $transaction_date = $model_master->transfer_date;
            }
        } else if ($status == 'IDTCK') {
            $transaction_from = 'INDIRECT_TRANSFER_IN';
            $model_master = InventoryIndirectTransfer::model()->findByPk($transaction_id);
            $modelheader_items = InventoryIndirectTransferItem::model()->findAll(array('condition' => 'indirect_transfer_id =' . $transaction_id, 'order' => 'item_id'));
            $warehouse = $model_master->to_warehouse_id;

            if ($model_master->transfer_date != "0000-00-00") {
                $transaction_date = $model_master->transfer_date;
            }
        }
        $k = 0;
        if (!empty($modelheader_items)) {
            foreach ($modelheader_items as $eachItem) {
                $modelItems[$k] = new StockLedger;


                $modelItems[$k]->cost_price = "";

                if ($status == 'DTCK' || $status == 'IDTCK') {
                    $modelItems[$k]->product_id = $eachItem->item_id;
                } else {
                    $modelItems[$k]->product_id = $eachItem->product_id;
                }
                if (isset($eachItem->quantity) && $status != 'CN') {
                    $modelItems[$k]->quantity = $eachItem->quantity;
                } elseif (isset($eachItem->picked_qty)) {
                    $modelItems[$k]->quantity = $eachItem->picked_qty;
                } elseif (isset($eachItem->returned_quantity) && $status == 'CN') {
                    //$modelItems[$k]->quantity   = $eachItem->returned_quantity+$eachItem->returned_bonus_qty;
                    $modelItems[$k]->quantity = $eachItem->returned_quantity;
                } else if (isset($eachItem->transfer_qty) && ($status == 'DTCK' || $status == 'IDTCK')) {
                    $modelItems[$k]->quantity = $eachItem->transfer_qty;
                }

                if (isset($eachItem->rate) && $status == 'IGR') {//Inventory Goods Receipt
                    $modelItems[$k]->cost_price = $eachItem->rate;
                    $modelItems[$k]->unit_id = $eachItem->unit;
                    $modelItems[$k]->unit_name = $eachItem->unitdetails->name;
                    $modelItems[$k]->unit_factor = $eachItem->unitdetails->factor;
                } else if (isset($eachItem->rate) && $status == 'PGR') {//Production Goods receipt
                    $modelItems[$k]->cost_price = $eachItem->rate;
                    $modelItems[$k]->unit_id = $eachItem->unit;
                    $modelItems[$k]->unit_name = $eachItem->unitdetails_mes->name;
                    $modelItems[$k]->unit_factor = $eachItem->unitdetails_mes->factor;
                } elseif ($status == 'DTCK' && isset($eachItem->stock->rate)) {

                    $modelItems[$k]->cost_price = $eachItem->stock->rate;
                    $modelItems[$k]->unit_id = $eachItem->stock->unit_id;
                    $modelItems[$k]->unit_name = $eachItem->stock->unit->symbol;
                    $modelItems[$k]->unit_factor = 1;
                } elseif ($status == 'IDTCK' && isset($eachItem->stock->rate)) {

                    $modelItems[$k]->cost_price = $eachItem->stock->rate;
                    $modelItems[$k]->unit_id = $eachItem->stock->unit_id;
                    $modelItems[$k]->unit_name = $eachItem->stock->unit->symbol;
                    $modelItems[$k]->unit_factor = 1;
                } elseif ($status == 'CN') {

                    $arr_product_details = Store::model()->findByPk($eachItem->product_id);
                    $modelItems[$k]->cost_price = $eachItem->rate;
                    $modelItems[$k]->unit_id = $eachItem->orderunit->id;
                    $modelItems[$k]->unit_name = $eachItem->orderunit->name;
                    $modelItems[$k]->unit_factor = $eachItem->orderunit->factor;
                    $modelItems[$k]->sales_price = $eachItem->rate;
                } else {
                    $arr_product_details = Store::model()->findByPk($eachItem->product_id);
                    $modelItems[$k]->cost_price = $arr_product_details->rate;
                    $modelItems[$k]->unit_id = $arr_product_details->unit_id;
                    $modelItems[$k]->unit_name = $arr_product_details->unit->symbol;
                    $modelItems[$k]->unit_factor = 1;
                }

                $modelItems[$k]->id = $eachItem->id;
                $modelItems[$k]->header_id = $transaction_id;
                if ($status == 'IGR' && !empty($model_master->reference)) {
                    $modelItems[$k]->batch_no = $model_master->customer->customer_name . '#' . $model_master->reference;
                } else {
                    $modelItems[$k]->batch_no = $transaction_id;
                }
                //$modelItems[$k]->batch_no   = $transaction_id;
                $modelItems[$k]->header_item_id = $eachItem->id;
                $modelItems[$k]->transaction_from = $transaction_from;
                $modelItems[$k]->customer_vendor_id = 0;
                $modelItems[$k]->customer_vendor_name = "";

                $k++;
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model_master, 'status' => $status, 'items' => $modelItems, 'warehouse' => $warehouse, 'transaction_date' => $transaction_date));
    }



    public function actionUpdateStockDetails()
    {
        $valid = true;
        $other = array();

        $transaction_id = $_POST['transaction_id'];
        $checkin_status = $_POST['checkin_status'];

        $file_id = 0;
        $customer_vendor_id = 0;
        $customer_vendor_name = "";

        if ($checkin_status == 'CN') {
            $model = new Creditnote();
            $transaction_from = 'CREDIT_NOTE';
            if ($transaction_id > 0) {
                $modelmas = $model->findByPk($transaction_id);
                if ($modelmas->is_updated_store == 'Y') {
                    $valid = false;
                    $other[] = "Credit Note alredy done [Transaction No:$transaction_id]";
                } else {
                    $file_id = $modelmas->file_id;
                    $customer_vendor_id = $modelmas->customer_id;
                    $customer_vendor_name = $modelmas->customer->customer_name;
                }
            }
        } else if ($checkin_status == 'PGR') {
            $model = new ProductionGoodsReceipt();
            $transaction_from = 'PROD_GOODS_RECEIPT';
        } else if ($checkin_status == 'IGR') {
            $model = new InventoryGoodsReceipt();
            $transaction_from = 'GOODS_RECEIPT';
            if ($transaction_id > 0) {
                $modelmas = $model->findByPk($transaction_id);
                if ($modelmas->stock_updated == 'Y') {
                    $valid = false;
                    $other[] = "Goods Receipt alredy done [Transaction No:$transaction_id]";
                } else {
                    $file_id = $modelmas->file_id;
                    $customer_vendor_id = $modelmas->customer_id;
                    $customer_vendor_name = $modelmas->customer->customer_name;
                }
            }
        } else if ($checkin_status == 'DTCK') {
            $model = new InventoryDirectTransfer();
            $transaction_from = 'TRANSFER_IN';
        } else if ($checkin_status == 'IDTCK') {
            $model = new InventoryIndirectTransfer();
            if ($transaction_id > 0) {
                $modelmas = $model->findByPk($transaction_id);
                $file_id = $modelmas->id;
                $customer_vendor_id = $modelmas->customer_id;
                $customer_vendor_name = $modelmas->customer_name;
            }
            $modelItems = InventoryIndirectTransferItem::model()->findAllByAttributes([
                'indirect_transfer_id' => $transaction_id
            ]);
            $transaction_from = 'INDIRECT_TRANSFER_IN';
            $expectedQtyMap = [];
            foreach ($modelItems as $item) {
                $expectedQtyMap[$item->item_id] = [
                    'transferred_qty' => $item->transferred_qty,
                    'missing_qty' => $item->missing_qty,
                    'damaged_qty' => $item->damaged_qty,
                ];
            }
        }

        $damageWarehouseId = MasInventoryWarehouse::getWarehouseIdByCode('DAM');
        $missingWarehouseId = MasInventoryWarehouse::getWarehouseIdByCode('MIS');
        $wnameMis = MasInventoryWarehouse::getWarehouseName($missingWarehouseId);
        $wnameDam = MasInventoryWarehouse::getWarehouseName($damageWarehouseId);

        $productWarehouseQty = [];
        $actualQtyMap = [];
        $modelStockLedger = [];

        if (is_array($_POST['StockLedger'])) {
            foreach ($_POST['StockLedger'] as $i => $item) {

                if ($item['product_id'] > 0 && $item['quantity'] > 0) {

                    $productId = (int) $item['product_id'];
                    $warehouseId = (int) $item['warehouse_id'];
                    $qty = (float) $item['quantity'];
                    $headerId = (int) $item['header_id'];
                    if ($headerId != $transaction_id) {
                        continue;
                    }

                    if (!isset($actualQtyMap[$productId])) {
                        $actualQtyMap[$productId] = [
                            'transferred_qty' => 0,
                            'missing_qty' => 0,
                            'damaged_qty' => 0,
                        ];
                    }
                    $missingWarehouseId = MasInventoryWarehouse::getWarehouseIdByCode('TRAN');

                    // --- Main StockLedger Entry ---

                    // trasaction out from instastist
                    if ($checkin_status == 'IDTCK'):
                        $modelStockLedgerOut[$i] = new StockLedger;
                        $modelStockLedgerOut[$i]->attributes = $item;
                        $modelStockLedgerOut[$i]->file_id = $file_id;
                        $modelStockLedgerOut[$i]->header_id = $item['header_id'];
                        $modelStockLedgerOut[$i]->header_item_id = $item['header_item_id'];
                        $modelStockLedgerOut[$i]->reference_id = $item['header_id'];
                        $modelStockLedgerOut[$i]->customer_vendor_id = $customer_vendor_id;
                        $modelStockLedgerOut[$i]->customer_vendor_name = $customer_vendor_name;
                        if ($checkin_status == 'IGR') {
                            $modelStockLedgerOut[$i]->reference_no = $model->reference;
                        }
                        if ($checkin_status == 'CN') {
                            $modelStockLedgerOut[$i]->reference_no = $modelmas->invoice_id;
                        }
                        $modelStockLedgerOut[$i]->product_id = $item['product_id'];
                        $modelStockLedgerOut[$i]->product_name = $item['product_name'];
                        $modelStockLedgerOut[$i]->product_description = $item['product_description'];
                        $modelStockLedgerOut[$i]->brand_id = $item['brand_id'];
                        $modelStockLedgerOut[$i]->brand_name = $item['brand_name'];
                        $modelStockLedgerOut[$i]->warehouse_id = $missingWarehouseId;
                        $modelMasInventoryWarehouse = new MasInventoryWarehouse();
                        $modelStockLedgerOut[$i]->warehouse_name = $modelMasInventoryWarehouse->getWarehouseName($missingWarehouseId);
                        $modelStockLedgerOut[$i]->rack_id = $item['rack_id'];
                        $modelMasInvRack = new MasInvRack();
                        $modelStockLedgerOut[$i]->rack_name = $modelMasInvRack->getRackName($item['rack_id']);
                        $modelStockLedgerOut[$i]->bin_id = $item['bin_id'];
                        $modelMasInvBin = new MasInvBin();
                        $modelStockLedgerOut[$i]->bin_name = $modelMasInvBin->getBinName($item['bin_id']);
                        $modelStockLedgerOut[$i]->batch_no = $item['batch_no'];
                        $modelStockLedgerOut[$i]->serial_no = $item['serial_no'];
                        $modelStockLedgerOut[$i]->quantity = $item['quantity'];
                        $modelStockLedgerOut[$i]->transaction_from = 'INDIRECT_TRANSFER_OUT';
                        $modelStockLedgerOut[$i]->transaction_type = 'OUT';
                        $modelStockLedgerOut[$i]->unit_name = $item['unit_name'];
                        $modelStockLedgerOut[$i]->unit_id = $item['unit_id'];
                        $modelStockLedgerOut[$i]->unit_factor = $item['unit_factor'];
                        $modelStockLedgerOut[$i]->cost_price = $item['cost_price'];
                        $modelStockLedgerOut[$i]->buying_price = ($checkin_status == 'IGR' || $checkin_status == 'PGR') ? ($item['cost_price'] / max(1, $item['unit_factor'])) : $item['cost_price'];
                        $modelStockLedgerOut[$i]->sales_price = $item['sales_price'];
                        $modelStockLedgerOut[$i]->transaction_date = $item['transaction_date'];
                        $modelStockLedgerOut[$i]->created_by = Yii::app()->user->id;
                        $modelStockLedgerOut[$i]->created_date = date('Y-m-d H:i:s');
                        $modelStockLedgerOut[$i]->stock_updated = "Y";
                        if ($modelStockLedgerOut[$i]->validate()) {
                            $modelStockLedgerOut[$i]->save(false);
                        } else {
                            $valid = false;
                            $other[] = "Error saving OUT transaction for product: " . $item['product_name'];
                        }
                    else:
                        $k = count($modelStockLedger);
                        $modelStockLedger[$k] = new StockLedger;
                        $modelStockLedger[$k]->attributes = $item;
                        $modelStockLedger[$k]->file_id = $file_id;
                        $modelStockLedger[$k]->header_id = $item['header_id'];
                        $modelStockLedger[$k]->header_item_id = $item['header_item_id'];
                        $modelStockLedger[$k]->reference_id = $item['header_id'];
                        $modelStockLedger[$k]->customer_vendor_id = $customer_vendor_id;
                        $modelStockLedger[$k]->customer_vendor_name = $customer_vendor_name;
                        if ($checkin_status == 'IGR') {
                            $modelStockLedger[$k]->reference_no = $model->reference;
                        }
                        if ($checkin_status == 'CN') {
                            $modelStockLedger[$k]->reference_no = $modelmas->invoice_id;
                        }
                        $modelStockLedger[$k]->product_id = $item['product_id'];
                        $modelStockLedger[$k]->product_name = $item['product_name'];
                        $modelStockLedger[$k]->product_description = $item['product_description'];
                        $modelStockLedger[$k]->brand_id = $item['brand_id'];
                        $modelStockLedger[$k]->brand_name = $item['brand_name'];
                        $modelStockLedger[$k]->warehouse_id = $item['warehouse_id'];
                        $modelMasInventoryWarehouse = new MasInventoryWarehouse();
                        $modelStockLedger[$k]->warehouse_name = $modelMasInventoryWarehouse->getWarehouseName($item['warehouse_id']);
                        $modelStockLedger[$k]->rack_id = $item['rack_id'];
                        $modelMasInvRack = new MasInvRack();
                        $modelStockLedger[$k]->rack_name = $modelMasInvRack->getRackName($item['rack_id']);
                        $modelStockLedger[$k]->bin_id = $item['bin_id'];
                        $modelMasInvBin = new MasInvBin();
                        $modelStockLedger[$k]->bin_name = $modelMasInvBin->getBinName($item['bin_id']);
                        $modelStockLedger[$k]->batch_no = $item['batch_no'];
                        $modelStockLedger[$k]->serial_no = $item['serial_no'];
                        $modelStockLedger[$k]->quantity = $item['quantity'];
                        $modelStockLedger[$k]->transaction_from = $item['transaction_from'];
                        $modelStockLedger[$k]->transaction_type = $item['transaction_type'];
                        $modelStockLedger[$k]->unit_name = $item['unit_name'];
                        $modelStockLedger[$k]->unit_id = $item['unit_id'];
                        $modelStockLedger[$k]->unit_factor = $item['unit_factor'];
                        $modelStockLedger[$k]->cost_price = $item['cost_price'];
                        $modelStockLedger[$k]->buying_price = ($checkin_status == 'IGR' || $checkin_status == 'PGR') ? ($item['cost_price'] / max(1, $item['unit_factor'])) : $item['cost_price'];
                        $modelStockLedger[$k]->sales_price = $item['sales_price'];
                        $modelStockLedger[$k]->transaction_date = $item['transaction_date'];
                        $modelStockLedger[$k]->created_by = Yii::app()->user->id;
                        $modelStockLedger[$k]->created_date = date('Y-m-d H:i:s');
                        $modelStockLedger[$k]->stock_updated = "Y";
                    endif;
                    // --- Missing Entry ---
                    if (!empty($item['missing']) && $item['missing'] > 0) {
                        $stockLedgerMis = new StockLedger();
                        $stockLedgerMis->attributes = $item;
                        $stockLedgerMis->quantity = $item['missing'];
                        $stockLedgerMis->warehouse_id = $missingWarehouseId;
                        $stockLedgerMis->warehouse_name = $wnameMis;
                        $stockLedgerMis->transaction_from = 'INDIRECT_TRANSFER_IN';
                        $stockLedgerMis->transaction_type = 'IN';
                        $stockLedgerMis->stock_updated = "Y";
                        $stockLedgerMis->save(false);

                        $actualQtyMap[$productId]['missing_qty'] += $item['missing'];
                    }

                    // --- Damaged Entry ---
                    if (!empty($item['damages']) && $item['damages'] > 0) {
                        $stockLedgerDam = new StockLedger();
                        $stockLedgerDam->attributes = $item;
                        $stockLedgerDam->quantity = $item['damages'];
                        $stockLedgerDam->warehouse_id = $damageWarehouseId;
                        $stockLedgerDam->warehouse_name = $wnameDam;
                        $stockLedgerDam->transaction_from = 'INDIRECT_TRANSFER_IN';
                        $stockLedgerDam->transaction_type = 'IN';
                        $stockLedgerDam->stock_updated = "Y";
                        $stockLedgerDam->save(false);

                        $actualQtyMap[$productId]['damaged_qty'] += $item['damages'];
                    }

                    // --- Update transferred qty ---
                    $actualQtyMap[$productId]['transferred_qty'] += $item['quantity'];

                    // --- Validate serial no ---
                    if (!empty($item['serial_no']) && $checkin_status != 'IDTCK') {
                        $checkItemSerialNo = StockLedger::model()->find([
                            'select' => 'sum(quantity) as quantity',
                            'condition' => 'serial_no="' . trim($item['serial_no']) . '" AND product_id="' . $item['product_id'] . '"'
                        ])->quantity;
                        if ($checkItemSerialNo > 0) {
                            $valid = false;
                            $repeated_item = Store::model()->findByPk($item['product_id'])->part_number;
                            $other[] = "$repeated_item : Serial No (" . $item['serial_no'] . ") Already Exist";
                        }
                    }

                    $valid = $modelStockLedger[$i]->validate() && $valid;
                }
            }

            // --- Compare expected vs actual for IDTCK ---
            foreach ($expectedQtyMap as $productId => $expected) {
                $actual = $actualQtyMap[$productId] ?? [
                    'transferred_qty' => 0,
                    'missing_qty' => 0,
                    'damaged_qty' => 0,
                ];
                if (
                    $expected['transferred_qty'] != $actual['transferred_qty'] ||
                    $expected['missing_qty'] != $actual['missing_qty'] ||
                    $expected['damaged_qty'] != $actual['damaged_qty']
                ) {
                    $productName = Store::model()->findByPk($productId)->part_number ?? "Product ID: $productId";
                    $valid = false;
                    $other[] = "$productName - Quantities do not match. Expected (T/M/D): " .
                        "{$expected['transferred_qty']}/{$expected['missing_qty']}/{$expected['damaged_qty']}, " .
                        "Got: {$actual['transferred_qty']}/{$actual['missing_qty']}/{$actual['damaged_qty']}";
                }
            }

            // --- Save Transaction and Update Stock ---
            if ($valid) {
                if ($transaction_id > 0) {
                    $model = $model->findByPk($transaction_id);
                    if ($checkin_status == 'IGR') {
                        $model->stock_updated = "Y";
                    } else if ($checkin_status == 'DTCK') {
                        $model->status = "C";
                    } else if ($checkin_status == 'IDTCK') {
                        $model->status = "TI";
                        $model->is_complete = "Y";
                    } else {
                        $model->is_updated_store = "Y";
                    }

                    $model->save(false);



                    $randomBatch = $checkin_status . rand(100, 10000);
                    if (!empty($modelStockLedger)) {
                        foreach ($modelStockLedger as $eachItem) {
                            $arr_product_details = Store::model()->findbyPk($eachItem->product_id);
                            $existing_store_rate = $arr_product_details->rate;

                            if ($checkin_status == 'IGR' || $checkin_status == 'PGR') {
                                $rate = $existing_store_rate;
                                $existing_qty = $arr_product_details->totalQuantity;
                                $new_cost_price = round($eachItem->cost_price * $eachItem->quantity, 6);
                                $quantity_with_unit_factor = $eachItem->quantity * max(1, $eachItem->unit_factor);
                                $variance_value = ($quantity_with_unit_factor > 0) ? round($new_cost_price / $quantity_with_unit_factor, 6) : 0;
                                $cur_total = $variance_value * $quantity_with_unit_factor;
                                $existing_amount = $rate * $existing_qty;
                                $total_quantity = $existing_qty + $quantity_with_unit_factor;
                                $total_amount = $existing_amount + $cur_total;
                                $new_amount = ($total_quantity > 0) ? round($total_amount / $total_quantity, 6) : $existing_store_rate;
                                $eachItem->cost_price = $new_amount;
                                Store::model()->updateByPk($eachItem->product_id, array('rate' => $new_amount));
                            } else if ($checkin_status == 'DTCK') {
                                Yii::app()->db->createCommand("UPDATE erp_stock_ledger SET stock_updated='Y' WHERE header_id={$eachItem->header_id} AND header_item_id={$eachItem->header_item_id} AND product_id={$eachItem->product_id} AND transaction_from='TRANSFER_OUT'")->execute();
                            } else if ($checkin_status == 'IDTCK') {
                                Yii::app()->db->createCommand("UPDATE erp_stock_ledger SET stock_updated='Y' WHERE header_id={$eachItem->header_id} AND header_item_id={$eachItem->header_item_id} AND product_id={$eachItem->product_id} AND transaction_from='INDIRECT_TRANSFER_OUT'")->execute();
                            } else {
                                $eachItem->cost_price = $existing_store_rate;
                            }

                            if (empty($eachItem->batch_no)) {
                                $eachItem->batch_no = $randomBatch;
                            }
                            $eachItem->save(false);
                        }
                    }
                    if ($checkin_status == 'CN') {
                        $modelCreditNote = new Creditnote();
                        $modelCreditNote->updateByPk($transaction_id, array('creditnote_no' => $transaction_id));
                        Yii::import('application.modules.accounts.controllers.PostingController');
                        $from = 'creditnote';
                        PostingController::DirectPost((int) $transaction_id, $from);
                    }

                }
                echo CJSON::encode(array('status' => 'success'));
            } else {
                $error2 = !empty($modelStockLedger) ? json_decode(CActiveForm::validateTabular($modelStockLedger, '', false), true) : [];
                $error = CJSON::encode(array_merge_recursive([], $error2, $other));
                if ($error != '[]' || $error != '')
                    echo $error;
            }
        }
    }

    public function ChanageDB($database = MasCompany::DB_ACE)
    {
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $database;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
    }
}