<?php

class CanceldeliveryController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Create','savecanceldelivery','Savecanceldeliverypacking'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionCreate(){
        $id=(int) Yii::app()->request->getParam('id');
        $model=DeliveryNote::model()->findByPk($id);
        $model_items= DeliveryNoteItem::model()->findAll(array('condition' => 'delivery_note_id="'. $id.'" and picked_qty>0'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);       
        $this->renderPartial('create', array('model' => $model,'model_items'=>$model_items), false, true);
                                             
    }
    public function actionSavecanceldelivery() {
      if (isset($_POST['DeliveryNote'])) {
            $id =$_POST['DeliveryNote']['id'];   
            $file_id =$_POST['DeliveryNote']['file_id'];   
            $order_id =$_POST['DeliveryNote']['order_id'];   
            DeliveryNote::model()->updateByPK($id, array('status' =>'CN','remarks_cancel'=>$_POST['DeliveryNote']['remarks_cancel'],'updated_by'=>Yii::app()->user->id,'updated_datetime'=> date('Y-m-d h:i:s'))); 
            $model_delivery_exist= DeliveryNote::model()->findAll(array('condition' => 'order_id="'. $order_id.'" and id!="'.$id.'" AND status!="CN"'));
            
                $model_delivery_item_exist= DeliveryNoteItem::model()->with('deliveryNote')->find(array('select'=>'sum(picked_qty) as picked_qty','condition' => 'deliveryNote.order_id="'. $order_id.'" AND deliveryNote.status!="CN"'));
                $model_order_item_exist= OrderItem::model()->find(array('select'=>'sum(quantity) as quantity','condition' => 'order_id="'. $order_id.'"'));
                $delivered_qty=$model_delivery_item_exist->picked_qty;
                $ordered_qty=$model_order_item_exist->quantity;
                $balance_qty=$ordered_qty-$delivered_qty;

                if(empty($model_delivery_exist) && ($balance_qty==$ordered_qty)){
                    MasterFile::model()->updateByPk($file_id, array('current_process_status'=>'O'));
                }else if(!empty($model_delivery_exist) || $balance_qty>0){
                    MasterFile::model()->updateByPk($file_id, array('current_process_status'=>'PD'));
                }else{
                    MasterFile::model()->updateByPk($file_id, array('current_process_status'=>'O'));
                }
            
            AuditLog::saveAuditLogs(
                        'DELIVERY_NOTE_CANCELLED',
                        Yii::app()->user->id,
                        'CANCELLED',
                        " with ID: - {$id}  "
            );
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);          
      }
  }
public function actionSavecanceldeliverypacking() {
      if (isset($_POST['DeliveryNote'])) {
            $id =$_POST['DeliveryNote']['id'];   
            $file_id =$_POST['DeliveryNote']['file_id'];   
            $order_id =$_POST['DeliveryNote']['order_id'];   
            $delivery_type =$_POST['DeliveryNote']['delivery_type'];   
            DeliveryNote::model()->updateByPK($id, array('status' =>'CN','remarks_cancel'=>$_POST['DeliveryNote']['remarks_cancel'],'updated_by'=>Yii::app()->user->id,'updated_datetime'=> date('Y-m-d h:i:s'))); 
            $model_delivery_exist= DeliveryNote::model()->findAll(array('condition' => 'order_id="'. $order_id.'" and id!="'.$id.'" AND status!="CN"'));
            $model_delivery_item_exist= DeliveryNoteItem::model()->with('deliveryNote')->find(array('select'=>'sum(picked_qty) as picked_qty','condition' => 'deliveryNote.order_id="'. $order_id.'" AND deliveryNote.status!="CN"'));
            $model_order_item_exist= OrderItem::model()->find(array('select'=>'sum(quantity) as quantity','condition' => 'order_id="'. $order_id.'"'));
            $delivered_qty=$model_delivery_item_exist->picked_qty;
            $ordered_qty=$model_order_item_exist->quantity;
            $balance_qty=$ordered_qty-$delivered_qty;

                if(empty($model_delivery_exist) && ($balance_qty==$ordered_qty)){
                    MasterFile::model()->updateByPk($file_id, array('current_process_status'=>'O'));
                }else if(!empty($model_delivery_exist) || $balance_qty>0){
                    MasterFile::model()->updateByPk($file_id, array('current_process_status'=>'PD'));
                }else{
                    MasterFile::model()->updateByPk($file_id, array('current_process_status'=>'O'));
                }
            
 
                //Updating to Product Location
                $model_stock_ledger_exist= StockLedger::model()->findAll(array('condition' => 'header_id="'.$id.'" and transaction_from="DELIVERY_NOTE"'));
                foreach ($model_stock_ledger_exist as $key_1 => $eachModel) {
                            $modelTransferInStockLedger                         =   new StockLedger();
                            $modelTransferInStockLedger->file_id                =   $eachModel->file_id;   
                            $modelTransferInStockLedger->header_id              =   $eachModel->header_id;   
                            $modelTransferInStockLedger->header_item_id         =   $eachModel->header_item_id;  
                            $modelTransferInStockLedger->customer_vendor_id     =   $eachModel->customer_vendor_id;
                            $modelTransferInStockLedger->customer_vendor_name   =   $eachModel->customer_vendor_name;  
                            $modelTransferInStockLedger->product_id             =   $eachModel->product_id;
                            $modelTransferInStockLedger->product_name           =   $eachModel->product_name;  
                            $modelTransferInStockLedger->product_description    =   $eachModel->product_description;
                            $modelTransferInStockLedger->brand_id               =   $eachModel->brand_id;  
                            $modelTransferInStockLedger->brand_name             =   $eachModel->brand_name;
                            $modelTransferInStockLedger->warehouse_id           =   $eachModel->warehouse_id;  
                            $modelTransferInStockLedger->warehouse_name         =   MasInventoryWarehouse::getWarehouseName($eachModel->warehouse_id);;
                            $modelTransferInStockLedger->rack_id                =   $eachModel->rack_id;  
                            $modelTransferInStockLedger->rack_name              =   MasInvRack::getRackName($eachModel->rack_id);
                            $modelTransferInStockLedger->bin_id                 =   $eachModel->bin_id;  
                            $modelTransferInStockLedger->bin_name               =   MasInvBin::getBinName($eachModel->bin_id);
                            $modelTransferInStockLedger->unit_id                =   $eachModel->unit_id;  
                            $modelTransferInStockLedger->unit_name              =   $eachModel->unit_name;
                            $modelTransferInStockLedger->unit_factor            =   $eachModel->unit_factor;  
                            $modelTransferInStockLedger->quantity               =   abs($eachModel->quantity);
                            $modelTransferInStockLedger->available_status       =   'A';
                            $modelTransferInStockLedger->batch_no               =   $eachModel->batch_no;  
                            $modelTransferInStockLedger->serial_no              =   $eachModel->serial_no;
                            $modelTransferInStockLedger->manufacturing_date     =   $eachModel->manufacturing_date;  
                            $modelTransferInStockLedger->expiry_date            =   $eachModel->expiry_date;
                            $modelTransferInStockLedger->cost_price             =   $eachModel->cost_price;  
                            $modelTransferInStockLedger->sales_price            =   $eachModel->sales_price;
                            $modelTransferInStockLedger->transaction_date       =   date('Y-m-d');
                            $modelTransferInStockLedger->transaction_from       =   'DELIVERY_NOTE_CANCEL';
                            $modelTransferInStockLedger->transaction_type       =   "IN";
                            $modelTransferInStockLedger->created_by             =   Yii::app()->user->id;
                            $modelTransferInStockLedger->created_date           =   date("Y-m-d H:i:s");     
                            $modelTransferInStockLedger->master_stock_ledger_id =   $eachModel->id;
                            $modelTransferInStockLedger->save(false);    
                }
                
            
            AuditLog::saveAuditLogs(
                        'DELIVERY_NOTE_CANCELLED',
                        Yii::app()->user->id,
                        'CANCELLED',
                        " with ID: - {$id}  "
            );
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);          
      }
  }
}
