<?php

class CalendarController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetEvents', 'GetEventsAll','Calendar','hrcalendar','GetEvent'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['mis_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['calendar_view']) &&
            Yii::app()->user->havePermissionOn['mis_menu_view'] && 
            Yii::app()->user->havePermissionOn['calendar_view']
        )
    ) {
        // Authorized: render the main view
        $this->render('index');
    } else {
        // Unauthorized: show custom unauthorized page
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }
    
     public function actionCalendar() {
        $this->render('calendar');
    }

    public function actionGetEventsAll() {
        $jasonevents = array(
            array(
                'title' => 'Event 1',
                'start' => '2018-02-01',
                'school' => '1',
                'type'=>'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2018-02-02',
                'school' => '1',
                'type'=>'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2018-02-03',
                'school' => '1',
                'type'=>'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2018-02-04',
                'school' => '1',
                'type'=>'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2018-02-05',
                'school' => '1',
                'type'=>'Notes'
            ),
        );
        echo CJSON::encode($jasonevents);
         Yii::app()->end();
    }

    public function actionGetEvents() {

        $start = Yii::app()->request->getParam('start');
        $end = Yii::app()->request->getParam('end');
        $filter_val = Yii::app()->request->getParam('filter_val');
        $activity_type = Yii::app()->request->getParam('activity_type');
        
        $jasonevents=$jasontaskevents=array();
        
        if ($filter_val=="A" || $filter_val == "all") {
        
            $condition = 't.isActive="Y"';
            if(((int) Yii::app()->user->havePermissionOn["activity_view_all"]) == 0){
                    $condition.= ' AND (t.assigned_from="'.Yii::app()->user->id.'" OR t.assigned_to="'.Yii::app()->user->id.'")';
            }
            
            if ($start != '' && $end!="") {
                    $condition .= ' AND (DATE(t.task_date_time) >="' . $start . '" AND DATE(t.task_date_time) <="' . $end . '")';
            }
            
            if($activity_type=='DI'){
                $condition .= ' AND added_from="DI"';
            }
            
            if($activity_type=='TA'){
                $condition .= ' AND added_from!="DI"';
            }
            
            $condition.= ' AND taskstatus.status_code!="C"';
            
            $model = new Activity();
            $modelActivity = $model->with('taskstatus','tasktype','customer')->findAll(array('condition' => $condition, 'order' => 't.task_date_time DESC'));
            
            $jo_task_list_color = "";
            $jo_dispute_list_color = "";
            foreach($modelActivity as $eachActivity){
                $type = $eachActivity->tasktype->type;
                $jasontaskevents['url'] = "javascript:void(0);";
                $jasontaskevents['date'] = $jasontaskevents['start'] = $jasontaskevents['end'] = date('Y-m-d', strtotime($eachActivity->task_date_time));
                $jasontaskevents['backgroundColor'] = ""; 
                $date = $eachActivity->task_date_time;
                $date2 = $eachActivity->deadline_date_time;
                $person = $eachActivity->assignedTo->de_first_name; 
                // var_dump($eachActivity->assignedTo);
                // die();
                if($eachActivity->added_from=="DI"){
                    $label_activity="Dispute";
                    $jasontaskevents['backgroundColor'] = $jo_dispute_list_color; 
                }
                else{
                    // $label_activity="Task";
                     $label_activity="";
                    $jasontaskevents['backgroundColor'] = $jo_task_list_color; 
                }
                $jasontaskevents['id'] = $eachActivity->id;
                // $jasontaskevents['title'] = $label_activity." : ".$eachActivity->tasktype->type. " - " . $person;
                $customerName = isset($eachActivity->customer->customer_name) ? $eachActivity->customer->customer_name : '';
$jasontaskevents['title'] = $label_activity . " " . $eachActivity->tasktype->type . " - " . $customerName . " - " . $person;

                
                // $jasontaskevents['description'] = "Added by - " . $eachActivity->assignedTo->fullname . '<br>
                //     '.$label_activity.' : ' . $eachActivity->notes . " <br/>                        
                //     Date/Time : " . $date;
                $jasontaskevents['description'] = "Added by - " . $eachActivity->assignedTo->de_first_name . '<br>' .
                    $label_activity . ' : ' . $eachActivity->notes . '<br>' .
                    "Task Date/Time : " . $date . '<br>' .
                    "Deadline Date/Time : " . $date2;
                if ($eachActivity->customer_id > 0)
                    $jasontaskevents['description'] .= '<br> Customer : ' . $eachActivity->customer->customer_name;
                $jasontaskevents['allDay'] = false;
                $jasontaskevents['type'] = $eachActivity->added_from;
                
                $jasontaskevents['customer_id']=(int) $eachActivity->customer_id;
                $jasonevents[] = $jasontaskevents;
            }
         }
        //End Activity
        //Lead Start
        if(((int) Yii::app()->user->havePermissionOn["lead_view"]) || Yii::app()->user->authorised_user==1){
            if($filter_val=="Lead" || $filter_val == "all"){            
              $criteriaLead = new CDbCriteria;         
              $criteriaLead->addCondition(' file.current_process_status="L"', 'AND');
              $criteriaLead->addCondition(' status!="C"', 'AND');
              if(Yii::app()->user->authorised_user!=1){
                $criteriaLead->addCondition(' t.lead_owner_id=' . Yii::app()->user->id, 'AND'); /*. ' OR t.lead_owner_id in (' . implode(',', $userModel->subordinates) . ')'*/
              }
              $criteriaLead->addCondition('(closing_date BETWEEN "' . $start . '" AND "' . $end . '")', 'AND');          
              $modelLead = new Lead();        
              $arr_lead_details = $modelLead->with('file')->findAll($criteriaLead);      
                  foreach ($arr_lead_details as $eachLeads) {
                      $jasoneventsLead['type'] = "SLE";
                      $jasoneventsLead['backgroundColor'] = '#5DB5A4'; //#6ad3ff';'#47D1FF';
                      $jasoneventsLead['url'] = "javascript:;";
                      $jasoneventsLead['date'] = $jasoneventsLead['start'] = date('Y-m-d', strtotime($eachLeads->closing_date));
                      $jasoneventsLead['id'] = $eachLeads->id;
                      $jasoneventsLead['title'] = "SL - ".$eachLeads->id; //$type . " - " . $eachActivity->company->company_name;
                      $jasoneventsLead['description'] = "Lead: " . $eachLeads->id." / ".$eachLeads->file->file_title . '<br/> Lead Owner: ' . $eachLeads->leadowner->fullname . '<br/>Customer: ' . $eachLeads->customer->customer_name;
                      $jasoneventsLead['allDay'] = false;
                      $jasonevents[] = $jasoneventsLead;
                  }
            }  
        }
        //End Lead
        //Quotation Start
        if((int) Yii::app()->user->havePermissionOn['quotes_view'] || Yii::app()->user->authorised_user==1){
            if($filter_val=="Quotation" || $filter_val == "all"){            
                $criteriaQtn = new CDbCriteria;
                $criteriaQtn->addCondition(' file.current_process_status="Q"', 'AND');
                if(Yii::app()->user->authorised_user!=1){
                  $criteriaQtn->addCondition(' t.lead_owner_id=' . Yii::app()->user->id, 'AND'); /*. ' OR t.lead_owner_id in (' . implode(',', $userModel->subordinates) . ')'*/
                }
                $criteriaQtn->addCondition('(qtn_validity BETWEEN "' . $start . '" AND "' . $end . '")', 'AND');          
                $modelQuotes = new Quotes();
                $arr_quotation_details = $modelQuotes->with('file')->findAll($criteriaQtn);
                    foreach ($arr_quotation_details as $eachQuotation) {
                        $jasoneventsQtn['type'] = "SQE";
                        $jasoneventsQtn['backgroundColor'] = '#88CFC2'; //#6ad3ff';'#4256e7';
                        $jasoneventsQtn['url'] = "javascript:;";
                        $jasoneventsQtn['date'] = $jasoneventsQtn['start'] = date('Y-m-d', strtotime($eachQuotation->qtn_validity));
                        $jasoneventsQtn['id'] = $eachQuotation->id;
                        $jasoneventsQtn['title'] = "Quotation - ".$eachQuotation->id; //$type . " - " . $eachActivity->company->company_name;
                        $jasoneventsQtn['description'] = "Quotation: " . $eachQuotation->id." / ".$eachQuotation->file_title . '<br/> Lead Owner: ' . $eachQuotation->leadowner->fullname . '<br/>Customer: ' . $eachQuotation->customer->customer_name;
                        $jasoneventsQtn['allDay'] = false;
                        $jasonevents[] = $jasoneventsQtn;
                    }
            }
        }
        //End Quotation
        //Start Order
        if((int) Yii::app()->user->havePermissionOn['order_view'] || Yii::app()->user->authorised_user==1){
            if($filter_val=="Order"  || $filter_val == "all"){
                $criteria2 = new CDbCriteria;
                $criteria2->addCondition(' file.current_process_status="O"', 'AND');
                if(Yii::app()->user->authorised_user!=1){
                  $criteria2->addCondition(' t.lead_owner_id=' . Yii::app()->user->id, 'AND'); /*. ' OR t.lead_owner_id in (' . implode(',', $userModel->subordinates) . ')'*/
                }
                $criteria2->addCondition('(delivery_date BETWEEN "' . $start . '" AND "' . $end . '")', 'AND');
                $modelOrder = new Order();
                $arr_order_details = $modelOrder->with('file')->findAll($criteria2);
                foreach ($arr_order_details as $eachOrder) {
                    $jasoneventsOrder['type'] = "SOD";
                    $jasoneventsOrder['backgroundColor'] = '#A2DCD0'; //'#fced89';#3dd2c7
                    $jasoneventsOrder['url'] = "javascript:void(0);";
                    $jasoneventsOrder['date'] = $jasonevents5['start'] = date('Y-m-d', strtotime($eachOrder->delivery_date));
                    $jasoneventsOrder['id'] = $eachOrder->id;
                    $jasoneventsOrder['title'] = "SO | ".$eachOrder->id." | ".$eachOrder->customer->customer_name; //$type . " - " . $eachActivity->company->company_name;
                    $jasoneventsOrder['description'] = "Order: " . $eachOrder->id." / ". $eachOrder->file->file_title . '<br/> Lead Owner: ' . $eachOrder->leadowner->fullname . '<br/>Customer:' . $eachOrder->customer->customer_name;
                    $jasoneventsOrder['allDay'] = false;
                    $jasonevents[] = $jasoneventsOrder;


                }
            }
        }
        //End Order
        //Start Invoice
        if((int) Yii::app()->user->havePermissionOn['invoice_view'] || Yii::app()->user->authorised_user==1){
            if($filter_val=="Invoice"  || $filter_val == "all"){
                $criteria2 = new CDbCriteria;
                if(Yii::app()->user->authorised_user!=1){
                  $criteria2->addCondition(' t.lead_owner_id=' . Yii::app()->user->id, 'AND'); /*. ' OR t.lead_owner_id in (' . implode(',', $userModel->subordinates) . ')'*/
                }
                $criteria2->addCondition('(invoice_date BETWEEN "' . $start . '" AND "' . $end . '")', 'AND');
                $files = MasterFile::model()->with('invoices')->findAll($criteria2); // need to put condition here
                $modelInvoice = new Invoice();
                $arr_invoice_details = $modelInvoice->with('file')->findAll($criteria2);
                    foreach ($arr_invoice_details as $eachInvoice) {
                      $paymentTerm=$eachInvoice->paymentTerm->no_of_days;
                      if($paymentTerm>0){
                        $inv_date = date('Y-m-d', strtotime('+'.$paymentTerm.' days', strtotime($eachInvoice->invoice_date)));
                      }
                      else{
                        $inv_date = date('Y-m-d', strtotime($eachInvoice->invoice_date));
                      }
                      $jasoneventsInvoice['type'] = "SIP";
                      $jasoneventsInvoice['backgroundColor'] = '#47988B'; //'#f4a1d2';#8AC8F2
                      $jasoneventsInvoice['url'] = "javascript:void(0);";
                      $jasoneventsInvoice['date'] = $jasonevents3['start'] = $inv_date;
                      $jasoneventsInvoice['id'] = $eachInvoice->id;
                      $jasoneventsInvoice['title'] = "SI | ".$eachInvoice->id." | ".$eachInvoice->customer->customer_name; //$type . " - " . $eachActivity->company->company_name;
                    //   $jasoneventsInvoice['hiring']=$eachInvoice->is_hiring_invoice;
                      $jasoneventsInvoice['description'] = "Invoice: " . $eachInvoice->file_id." / ".$eachInvoice->invoice_no  . '<br/> Lead Owner: ' . $eachInvoice->file->leadowner->fullname . '<br/>Customer: ' . $eachInvoice->customer->customer_name;
                      $jasoneventsInvoice['allDay'] = false;
                      $jasonevents[] = $jasoneventsInvoice;
                  }
            }
        }
        //End Invoice
        //Start -Sales Delivery Tracker
        if((int) Yii::app()->user->havePermissionOn['sales_deliverytracker_view'] || Yii::app()->user->authorised_user==1){
             if($filter_val=="salestracker"  || $filter_val == "all"){
                // $condition = "expected_delivery_date>='" .$start. "' and expected_delivery_date<='" .$end. "' and convert_to_delivery_note='N' AND order.order_type='S'";  //convert_to_delivery_note and order_type not defined //so commented
                $condition = "expected_delivery_date>='" .$start. "' 
              AND expected_delivery_date<='" .$end. "'";

                if(Yii::app()->user->authorised_user!=1){
                  $condition.= " AND order.lead_owner_id='".Yii::app()->user->id."'";
                }
                $model_sales_deliverytracker= OrderItem::model()->with('order')->findAll(array('condition' => $condition, 'group' => 'expected_delivery_date'));
                
                foreach ($model_sales_deliverytracker as $eachtracker) {  
                    // print_r($eachtracker);
                  $jsonsalestracker['type'] = "SDT";
                  $jsonsalestracker['backgroundColor'] = '#3E8278'; //'#f4a1d2';#E59494
                  $jsonsalestracker['url'] = "javascript:void(0);";
                  $jsonsalestracker['date'] = $jsonsalestracker['start'] =date('Y-m-d', strtotime($eachtracker->expected_delivery_date));;
                  $jsonsalestracker['id'] = $eachtracker->id;
                  $jsonsalestracker['title'] = "SD |".$eachtracker->order_id." | ".$eachtracker->order->customer->customer_name;
                  $jsonsalestracker['description'] = "Sales Delivery";
                  $jsonsalestracker['allDay'] = false;
                  $jasonevents[] = $jsonsalestracker;
              }
            //   die();
            }
        }
        //End-sales Delivery Tracker
        //Start -Purchase Delivery Tracker
        if((int) Yii::app()->user->havePermissionOn['pur_deliverytrack_view'] || Yii::app()->user->authorised_user==1){
             if($filter_val=="purchasetracker"  || $filter_val == "all"){
                $condition = "C.stock_item_quantity!=0  AND expected_delivery_date  <= '".date('Y-m-d')."' AND expected_delivery_date != '0000-00-00'"; 
                $model_settings        = MasCompanySettings::model()->find();
                if(!empty($model_settings)){
                    $qualitycontrol = $model_settings->qualitycontrol;
                    $stock_update_on     = $model_settings->stock_updates_on;
                }
                if($stockupdate == "PI"){// Purchase Invoice
                    $sql_quantity=' SELECT IFNULL(SUM(quantity),0)as quantity,order_item_id
                                    FROM erp_purchasinginvoice_item
                                    GROUP BY order_item_id ';
                }
                else{//Material Receipt
                    if($qualitycontrol == "N")
                        $sql_quantity=' SELECT IFNULL(SUM(received_quantity),0)as quantity,order_item_id
                                        FROM erp_purchasing_material_receipt_item
                                        GROUP BY order_item_id
                                    ';
                    if($qualitycontrol == "Y")//QC
                        $sql_quantity=' SELECT IFNULL(SUM(qc_checked_quantity),0)as quantity,order_item_id
                                        FROM erp_purchasing_material_receipt_item
                                        GROUP BY order_item_id ';
                }
                $sql   = 'SELECT * FROM
                                (SELECT (A.stock_item_quantity-IFNULL(B.quantity,0))AS stock_item_quantity,A.id,
                                        purchasing_order_id,stock_item_name,stock_item_unit,
                                        A.expected_delivery_date,PO.file_id,V.vendor_name,PO.convert_status,PO.completed
                                FROM erp_purchasing_order_stock_item A
                                INNER JOIN erp_purchasing_order PO
                                    ON PO.id=A.purchasing_order_id
                                INNER JOIN erp_vendor V
                                    ON PO.vendor_id=V.id
                                LEFT JOIN ('.$sql_quantity.')B
                                ON A.id =B.order_item_id WHERE PO.completed != "C" AND PO.completed != "Y"
                                )C
                              WHERE '.$condition.' 
                          GROUP BY expected_delivery_date'; 
                $model_purchase_deliverytracker = Yii::app()->db->createCommand($sql)->queryAll();                
                foreach ($model_purchase_deliverytracker as $b=>$eachtracker) {                 
                  $jsonpurchasetracker['type'] = "PDT";
                  $jsonpurchasetracker['backgroundColor'] = '#5DAFB5'; //'#f4a1d2';#F28ADD
                  $jsonpurchasetracker['url'] = "javascript:void(0);";
                  $jsonpurchasetracker['date'] = $jsonpurchasetracker['start'] =date('Y-m-d', strtotime($eachtracker['expected_delivery_date']));
                  $jsonpurchasetracker['id'] = $eachtracker['id'];
                  $jsonpurchasetracker['title'] = "PD | ".$eachtracker['purchasing_order_id']." | ".$eachtracker['vendor_name'];
                  $jsonpurchasetracker['description'] = "Purchase Delivery";
                  $jsonpurchasetracker['allDay'] = false;
                  $jasonevents[] = $jsonpurchasetracker;
              }
            }
        }
        //End-Purchase Delivery Tracker
        //Start -Sales Payment Tracker
        if((int) Yii::app()->user->havePermissionOn['sales_deliverytracker_view'] || Yii::app()->user->authorised_user==1){
             if($filter_val=="salespayment"  || $filter_val == "all"){
                $condition = 't.isActive="Y" ';
                if(!isset(Yii::app()->user->havePermissionOn["invoice_view_all"]) &&  Yii::app()->user->authorised_user != 1)
                {
                    $condition.= ' AND (t.lead_owner_id= "'.Yii::app()->user->id.'")';// OR file.lead_owner_id="'.Yii::app()->user->id.'"
                }    
                $model_sales_paymenttracker= Invoice::model()->findAll(array('condition' => $condition, 'group' => 'invoice_date'));
                foreach ($model_sales_paymenttracker as $eachtracker) {                   
                  $jsonsalespaymenttracker['type'] = "SPT";
                  $jsonsalespaymenttracker['backgroundColor'] = '#5DB590'; //'#f4a1d2';#ff0000
                  $jsonsalespaymenttracker['url'] = "javascript:void(0);";
                  $jsonsalespaymenttracker['date'] = $jsonsalespaymenttracker['start'] =date('Y-m-d', strtotime($eachtracker->invoice_date));;
                  $jsonsalespaymenttracker['id'] = $eachtracker->id;
                  $jsonsalespaymenttracker['title'] = "SP | ".$eachtracker->id." | ".$eachtracker->customer->customer_name;
                  $jsonsalespaymenttracker['description'] = "Sales-Payment";
                  $jsonsalespaymenttracker['allDay'] = false;
                  $jasonevents[] = $jsonsalespaymenttracker;
              }
            }
        }
        //End-sales Payment Tracker
        //Start -Purchase Payment Tracker
        if((int) Yii::app()->user->havePermissionOn['purchasetracker'] || Yii::app()->user->authorised_user==1){
             if($filter_val=="purchasepayment"  || $filter_val == "all"){
                $condition = 't.isActive="Y" ';
                if(!isset(Yii::app()->user->havePermissionOn["invoice_view_all"]) &&  Yii::app()->user->authorised_user != 1)
                {
                    $condition.= ' AND (t.lead_owner_id= "'.Yii::app()->user->id.'" OR file.lead_owner_id="'.Yii::app()->user->id.'")';
                }    
                $model_purchase_paymenttracker= PurchasingInvoice::model()->findAll(array('condition' => $condition, 'group' => 'invoice_date'));
                foreach ($model_purchase_paymenttracker as $eachtracker) {                   
                  $jsonpurchasepaymenttracker['type'] = "PPT";
                  $jsonpurchasepaymenttracker['backgroundColor'] = '#4F9C8F'; //'#f4a1d2';#ECB869
                  $jsonpurchasepaymenttracker['url'] = "javascript:void(0);";
                  $jsonpurchasepaymenttracker['date'] = $jsonpurchasepaymenttracker['start'] =date('Y-m-d', strtotime($eachtracker->invoice_date));
                  $jsonpurchasepaymenttracker['id'] = $eachtracker->id;
                  $jsonpurchasepaymenttracker['title'] = "Purchase-Payment";
                  $jsonpurchasepaymenttracker['description'] = "Purchase-Payment";
                  $jsonpurchasepaymenttracker['allDay'] = false;
                  $jasonevents[] = $jsonpurchasepaymenttracker;
              }
            }
        }
        //End-Purchase Payment Tracker
        //HR Calendar Details-Start
        $model_settings = HrGenerelSettings::model()->find();
        if($model_settings->general_calendar== "Y"){  
         if($filter_val=="Leave"  || $filter_val == "all"){           
               $model_leave_details= EmployeeLeaveDetail::model()->findAll();
                 if((int) Yii::app()->user->havePermissionOn['calendar_view'] || Yii::app()->user->authorised_user==1){
                   foreach ($model_leave_details as $leavedetail) {
                       $leave_start_date='';
                       $leave_end_date='';
                         if ($leavedetail->leave_start_date!= '' && $leavedetail->leave_start_date!= '0000-00-00') {
                             $leave_start_date =date("d/m/Y", strtotime($leavedetail->leave_start_date));;
                         }
                         if ($leavedetail->leave_end_date != '' && $leavedetail->leave_end_date != '0000-00-00') {
                             $leave_end_date =date("d/m/Y", strtotime($leavedetail->leave_end_date));;
                         }
                       $jasoneventsLeave['type'] = "Leave";
                       $jasoneventsLeave['backgroundColor'] = '#E39A9A'; //'#f4a1d2';#FF6347
                       $jasoneventsLeave['url'] = "javascript:void(0);";
                       $jasoneventsLeave['date'] = $jasoneventsLeave['start'] = $leavedetail->leave_start_date;
                       $jasoneventsLeave['end'] =date('Y-m-d', strtotime('+1 days', strtotime($leavedetail->leave_end_date)));
                       $jasoneventsLeave['title'] =ucwords(strtolower($this->ciphertext($leavedetail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($leavedetail->employeedetail->last_name, "d"))). '-' .$leavedetail->leavetype->leave_name.'-'.EmployeeLeaveDetail::getleavestatus($leavedetail->leave_status); 
                       $jasoneventsLeave['description'] = ucwords(strtolower($this->ciphertext($leavedetail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($leavedetail->employeedetail->last_name, "d"))).' on '.$leavedetail->leavetype->leave_name.' from '.$leave_start_date.' to '.$leave_end_date.'-'.EmployeeLeaveDetail::getleavestatus($leavedetail->leave_status);
                       $jasoneventsLeave['allDay'] = false;


                       $jasonevents[] = $jasoneventsLeave;
                   }
               }

             }
            $model_notification= CalendarNotification::model()->findAll();
            foreach ($model_notification as $detail) {
                $start_date='';
                $end_date='';
                  if ($detail->start_date!= '' && $detail->start_date!= '0000-00-00') {
                      $start_date =date("d/m/Y", strtotime($detail->start_date));;
                  }
                  if ($detail->end_date != '' && $detail->end_date != '0000-00-00') {
                      $end_date =date("d/m/Y", strtotime($detail->end_date));;
                  }
                $notify['type'] = "Leave";
                $notify['backgroundColor'] = '#B37575'; //'#f4a1d2';#ff8c00
                $notify['url'] = "javascript:void(0);";
                $notify['date'] = $notify['start'] = $detail->start_date;
                $notify['end'] = $detail->end_date;
                $notify['title'] =$start_date.'-'.$end_date; 
                $notify['description'] =$detail->notification;
                $notify['allDay'] = false;
                $jasonevents[] = $notify;
            }
        }
        if($filter_val=="todolist"  || $filter_val == "all"){           
          $model_todolist= Todolist::model()->findAll();
            if((int) Yii::app()->user->havePermissionOn['calendar_view'] || Yii::app()->user->authorised_user==1){
              foreach ($model_todolist as $task) {
                    $todo_date='';
                    if($task->todo_date!='' && $task->todo_date!='0000-00-00'){
                        $todo_date=date("d/m/Y",strtotime($task->todo_date));
                    }
                    if($task->start_time!='' && $task->start_time!='00:00:00'){
                        $start_time=date("H:i",strtotime($task->start_time));
                    }
                    if($task->end_time!='' && $task->end_time!='00:00:00'){
                        $end_time=date("H:i",strtotime($task->end_time));
                    }
                  $jsontodolist['type'] = "Todo";
                  $jsontodolist['backgroundColor'] = '#A95B5B'; //'#f4a1d2';#F3547E
                  $jsontodolist['url'] = "javascript:void(0);";
                  $jsontodolist['id'] = $task->id;
                  $jsontodolist['date'] = $jasoneventsLeave['start'] = $task->todo_date;
                  $jsontodolist['end'] =  $task->todo_date;
                  $jsontodolist['title'] ='Todo List'; 
                  $jsontodolist['description'] =$task->userdetail->Fullname.'-'.$todo_date.'('.$start_time.' - '.$end_time.')';
                  $jsontodolist['allDay'] = false;


                  $jasonevents[] = $jsontodolist;
              }
          }

        }
        if($filter_val=="schedules"  || $filter_val == "all"){           
            $model_schedules= ServiceSchedules::model()->findAll();
            if((int) Yii::app()->user->havePermissionOn['schedules_calendar_view'] || Yii::app()->user->authorised_user==1){
              foreach ($model_schedules as $task) {
                    $todo_date='';
                    if($task->scheduled_date!='' && $task->scheduled_date!='0000-00-00'){
                        $todo_date=date("d/m/Y",strtotime($task->scheduled_date));
                    }                    
                  $jsontodolist['type'] = "Schedule";
                  $jsontodolist['backgroundColor'] = '#D67272'; //'#f4a1d2';#f9a6ff
                  $jsontodolist['url'] = "javascript:void(0);";
                  $jsontodolist['id'] = $task->order_id;
                  $jsontodolist['date'] = $jasoneventsLeave['start'] = $task->scheduled_date;
                  $jsontodolist['end'] =  $task->scheduled_date;
                  $jsontodolist['title'] ='Schedule - '.$task->order_id; 
                  $jsontodolist['description'] =$task->description;
                  $jsontodolist['allDay'] = false;


                  $jasonevents[] = $jsontodolist;
              }
          }

        }
        echo CJSON::encode($jasonevents);
        Yii::app()->end();
    }
    public function actionHrcalendar() {
        $this->render('hr_index');
    }
    public function actionGetEvent() {      
        $model_leave_details= EmployeeLeaveDetail::model()->findAll();
            foreach ($model_leave_details as $leavedetail) {
                $leave_start_date='';
                $leave_end_date='';
                  if ($leavedetail->leave_start_date!= '' && $leavedetail->leave_start_date!= '0000-00-00') {
                      $leave_start_date =date("d/m/Y", strtotime($leavedetail->leave_start_date));;
                  }
                  if ($leavedetail->leave_end_date != '' && $leavedetail->leave_end_date != '0000-00-00') {
                      $leave_end_date =date("d/m/Y", strtotime($leavedetail->leave_end_date));;
                  }
                $leave['type'] = "Leave";
                $leave['backgroundColor'] = '#FF6347'; //'#f4a1d2';
                $leave['url'] = "javascript:void(0);";
                $leave['date'] = $leave['start'] = $leavedetail->leave_start_date;
                $leave['end'] = $leavedetail->leave_end_date;
                $leave['title'] =ucwords(strtolower($this->ciphertext($leavedetail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($leavedetail->employeedetail->last_name, "d"))). '-' .$leavedetail->leavetype->leave_name.'-'.EmployeeLeaveDetail::getleavestatus($leavedetail->leave_status); 
                $leave['description'] = ucwords(strtolower($this->ciphertext($leavedetail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($leavedetail->employeedetail->last_name, "d"))).' on '.$leavedetail->leavetype->leave_name.' from '.$leave_start_date.' to '.$leave_end_date.'-'.EmployeeLeaveDetail::getleavestatus($leavedetail->leave_status);
                $leave['allDay'] = false;


                $jsonevents[] = $leave;
            }
        $model_notification= CalendarNotification::model()->findAll();
            foreach ($model_notification as $detail) {
                $start_date='';
                $end_date='';
                  if ($detail->start_date!= '' && $detail->start_date!= '0000-00-00') {
                      $start_date =date("d/m/Y", strtotime($detail->start_date));;
                  }
                  if ($detail->end_date != '' && $detail->end_date != '0000-00-00') {
                      $end_date =date("d/m/Y", strtotime($detail->end_date));;
                  }
                $notify['type'] = "Leave";
                $notify['backgroundColor'] = '#ff8c00'; //'#f4a1d2';
                $notify['url'] = "javascript:void(0);";
                $notify['date'] = $notify['start'] = $detail->start_date;
                $notify['end'] = $detail->end_date;
                $notify['title'] =$start_date.'-'.$end_date; 
                $notify['description'] =$detail->notification;
                $notify['allDay'] = false;
                $jsonevents[] = $notify;
            }
        echo CJSON::encode($jsonevents);
        Yii::app()->end();
    }
}
