<?php

class BrandController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveBrand', 'DeleteBrand', 'DirectAdd', 'UnBlockBrand','BlockBrand','Disable', 'UploadBrand', 'DownloadSampleCsv', 'DownloadSampleCsv', 'SaveBrandUploadCsv', 'UploadBrandCsv', 'DownloadErrorCsv'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex()
    {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['mas_inv_brand_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['mas_inv_brand_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }



    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionGetList()
    {
        $model = new MasInvBrand();
        $draw     = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'brand_name',
            2 => 'is_default',
            3 => 'id',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " brand_name LIKE '%" . $searchString . "%'";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            // if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_brand_edit"])) {
            //     $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'brand/create&id=' . $row['id'] . '\',\'Brand - ' . $row['brand_name'] . ' \',\'lg\')"><i class="fa fa-pencil"></i></button>';
            // }
            // if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_brand_delete"])) {
            //     //  $div .=  ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteBrand('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            // }
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_brand_edit"])){
                $div.='<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'brand/create&id='.$row['id'].'\',\'Brand - '.$row['brand_name'].' \',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            }
            // if(isset(Yii::app()->user->havePermissionOn['mas_inv_brand_disable']) ||  Yii::app()->user->authorised_user == 1)
            //     {

            //       if ($row->isActive == "Y") 
            //       {
            //         $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disablebrand(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
            //       }
            //       if ($row->isActive == 'N') 
            //       {
            //             $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enablebrand(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
            //       }            
                
            //     }
            $rowData[] = array(
                $m,
                $row['brand_name'],
                // '<div class="btn-wrap">' . $div . '</div>',
                $row['is_default'],
                $row['isActive'],
                array('id' => $row['id'], 'code' => $row['brand_name'], 'status' => $row['isActive']),
            );

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model = new MasInvBrand();
        $id = (int) Yii::app()->request->getParam('id');
        $arr_brand =  $model->find(array('order' => 'id DESC'));
        
        if($id > 0){
            $model = $model->findByPk($id);
        }
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('brand_form', array('model' => $model), false, false);
    }

    public function actionSaveBrand()
    {
        $model = new MasInvBrand();
        $date = date("Y-m-d H:i:s");
        if (isset($_POST['MasInvBrand'])) {

            if ((int) @$_POST['MasInvBrand']['id'] > 0) {

                $id = (int) @$_POST['MasInvBrand']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
                $edit_flag=1;
            } else {
                $audit_type = 'CREATED';
            }
            if($_POST['MasInvBrand']['is_default'] == "Y"){
                MasInvBrand::model()->updateAll(array( 'is_default' => 'N' ), 'is_default = "Y"' );
            }
            
            $model->attributes = $_POST['MasInvBrand'];

            if ($model->save()) {
                                
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'BRAND_MASTER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with name: - {$model->brand_name}  "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['brand_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteBrand()
    {
        $id = $_POST['id'];
        $store = Yii::app()->db->createCommand('SELECT COUNT(*) FROM crm_store WHERE brand_class_id = ' . $id . ' ')->queryScalar();
        if ($store > 0) {
            echo "fail";
        } else {
            $model = new MasInvBrand();
            $pro = $model->findByPk($id); // audit log changes
            $model->deleteByPk($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'BRAND_MASTER',
                Yii::app()->user->id,
                'DELETED',
                " with name: - {$pro->brand_name}  "
            );
            // end audit log
            echo "success";
        }
    }

    public function actionDirectAdd()
    {
        $from = $_POST['from'];
        $name = $_POST['name'];
        $des = $_POST['des'];
        if ($name != '') {
            $modelBrand = new MasInvBrand;
            $modelBrand->brand_name = $name;
            $modelBrand->description = $des;
            if ($modelBrand->save()) {
                $model_productbrand_details = MasInvBrand::model()->find(array('order' => 'id DESC'));
                $data  = MasInvBrand::getAllMasInvBrand();
                if ($from == 'inventory') {
                    $model = new Store;
                    $field_name = 'brand_class_id';
                }
                $model->$field_name = $modelBrand->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data,  array('class' => 'tooltipster', 'data-label' => 'Brand'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelBrand, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }



    public function actionBlockBrand() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasInvBrand::model()->updateByPK($id, array('isActive' => "N"));
             // inserting to audit log
             $model=new MasInvBrand();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'BRAND_MASTER',
                 Yii::app()->user->id,
                 'BLOCKED',
                 " with name: - {$upt->brand_name}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlockBrand() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasInvBrand::model()->updateByPK($id, array('isActive' => "Y"));
             // inserting to audit log
             $model=new MasInvBrand();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'BRAND_MASTER',
                 Yii::app()->user->id,
                 'UNBLOCKED',
                 " with name: - {$upt->brand_name}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasInvBrand();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

     public function actionUploadBrand()
    {
        //added by nisha on 28-02-2023
        $model = new MasInvBrand();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_brand', array('model' => $model), false, true);
    }

    public function actionDownloadSampleCsv()
    {
        $filename = 'brand_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Brand Name*';
        Yii::app()->end();
    }

    public function readBrandCSV($csvFile)
    {
        if (!file_exists($csvFile)) {
            throw new Exception("File not found: $csvFile");
        }

        $file_handle = fopen($csvFile, 'r');
        $line_of_text = [];
        while (($contents = fgetcsv($file_handle, 1024, ',')) !== false) {
            $line_of_text[] = $contents;
        }
        fclose($file_handle);

        return $line_of_text;
    }
    public function actionSaveBrandUploadCsv()
    {
        $file_name = Yii::app()->request->getParam('filename');
        $batch = (int) Yii::app()->request->getParam('batch', 1);
        $url = Yii::app()->basePath . '/../uploads/brand_csv/' . $file_name;
        $mas_brand_list = $this->readBrandCSV($url);
        $error_url = Yii::app()->basePath . '/../uploads/brand_csv/error/' . $file_name;
        $error_list = [];
        $error_occurred = false;
        $batch_size = 200;
        $success_count = 0;
        $error_count = 0;
        $non_empty_row_count = 0;
        if (!empty($mas_brand_list)) {
            $header = array_shift($mas_brand_list); // Remove header row only once
        }
        $total_records = count($mas_brand_list);
        $start_index = ($batch - 1) * $batch_size;
        $batch_data = array_slice($mas_brand_list, $start_index, $batch_size);
        // print_r($batch_data);
        // die();
        foreach ($mas_brand_list as $index => $data) {
            if (!empty($data)) {
                $line_number = $index + 2; // Adjust for header row
                $log_remarks = [];

                // Sanitize and validate data

                if ($batch == 1) {
                    $log_remarks = $this->validateAndPrepareLog($data, $log_remarks);
                }


                if (empty($log_remarks)) {
                    $error_list[$line_number] = [
                        'brand_name' => $data[0],
                        'log_remarks' => ''
                    ];
                } else {
                    $error_occurred = true;
                    $error_count++;
                    $error_list[$line_number] = [
                        'brand_name' => $data[0],
                        'log_remarks' => implode(" | ", $log_remarks)
                    ];
                }
            }
        }
        // var_dump($log_remarks);
        // die();
        if ($error_occurred) {
            // echo 'hii';
            $file_error = fopen($error_url, "w+");
            $error_directory = Yii::app()->basePath . '/../uploads/brand_csv/error/';

            if (!is_dir($error_directory)) {
                mkdir($error_directory, 0777, true);  // Create the directory with appropriate permissions
            }
            if ($file_error === false) {
                // Handle the error if the file cannot be opened
                throw new Exception("Unable to open file for writing: $error_url");
            }
            // Add headers to the CSV file
            $headers = ['Brand Name', 'Log Remarks'];
            fputcsv($file_error, $headers);

            // Add each line from the original CSV, including rows with no errors
            foreach ($error_list as $error_detail) {
                $line = [
                    $error_detail['brand_name'],
                    $error_detail['log_remarks'], // Include log remarks, empty if no error
                ];
                fputcsv($file_error, $line);
            }
            fclose($file_error);

            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download Log', array('brand/DownloadErrorCsv', 'id' => $file_name), array(
                'target' => '_blank',
                'style' => '
                display: inline-block; border: 2px solid #ff4d4f; padding: 5px 15px;border-radius: -3px;font-size: 12px;
                font-weight: bold; background: #ff4d4f; color: #fff;text-decoration: none;text-align: center; margin-bottom: 10px;'
            )) . '</div>
            <div style="
                font-size: 12px;
                font-weight: bold;
                color: #ff4d4f;
                margin-top: 10px; 
            ">
                Data updation failed. Please see this file.
            </div>';
            echo json_encode($jsonData);

            return; // Return to stop further execution
        }

        foreach ($batch_data as $index => $data) {

            $non_empty_row_count++;
            if (!empty($data)) {
                $line_number = $start_index + $index + 2;
                $log_remarks = [];

                // Sanitize and validate data
                $brand_name = $this->sanitizeData($data[0]);
                if ($this->isTypeNameExists($brand_name)) {
                    $existing_count++;
                } else {
                    $model = new MasInvBrand();
                    $model->brand_name = ucfirst(strtolower($brand_name));
                    $model->is_default = 'N';
                    if ($model->save()) {
                        $success_count++;
                    }
                }
                // Save to DB


            }
        }
        // $existing_count = ($batch - 1) * $batch_size;

        // Yii::app()->session['batch_no'] = $batch + 1;

        if ($start_index + $batch_size < $total_records) {
            $next_batch = $batch + 1;
            echo json_encode([
                'status' => 'success',
                'message' => '',
                'flag' => 'continue',
                'next_button' => '<a href="javascript:void(0);" 
                            id="next-batch-btn" 
                            data-url="' . Yii::app()->createUrl('brand/SaveBrandUploadCsv', [
                        'filename' => $file_name,
                        'batch' => $next_batch

                    ]) . '"
                            style="display: inline-block; border: 2px solid #000080; padding: 5px 15px; font-size: 12px; font-weight: bold; background: #000080; color: #fff; text-decoration: none;">
                            Upload Next 200
                          </a>',
                'total_records' => $total_records,
                'success_count' => $success_count,
                'error_count' => $error_count,
                'non_empty_row_count' => $non_empty_row_count,
                'existing_count' => $existing_count,
            ]);
        } else {
            echo json_encode([
                'status' => 'success',
                'message' => '',
                'success_count' => $success_count,
                'error_count' => $error_count,
                'non_empty_row_count' => $non_empty_row_count,
                'existing_count' => $existing_count,
                'total_records' => $total_records,
            ]);
        }
    }
    public function actionDownloadErrorCsv()
    {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/brand_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    private function sanitizeData($data)
    {
        return !empty($data) ? trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data), '"') : '';
    }

    private function sanitizeNumber($data)
    {
        $sanitizedData = str_replace(',', '', trim($data));
        return is_numeric($sanitizedData) ? (float) $sanitizedData : 0.0;
    }
    private function validateAndPrepareLog($data, &$log_remarks)
    {
        $log_remarks = [];

        // Sanitize and assign data
        $brand_name = $this->sanitizeData($data[0]);



        // Validate 'code'
        if (empty($brand_name)) {

            $log_remarks[] = "Brand Name is required.";
        } else {
            // if ($this->isTypeNameExists($brand_name)) {
            //     $log_remarks[] = "Code must be unique.";
            // }
        }
        // var_dump($log_remarks);

        return $log_remarks;
    }
    private function isTypeNameExists($code)
    {
        $code = strtolower(trim($code));
        return MasInvBrand::model()->exists('LOWER(TRIM(brand_name)) = :code', [':code' => $code]);
    }

    public function actionUploadBrandCsv($folder = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // Check if directory exists or create it
        if (!is_dir($folder)) {
            mkdir($folder, 0777, true);
        }

        // Define allowed extensions and size limit
        $allowedExtensions = array();
        $sizeLimit = 2 * 1024 * 1024; // 2MB

        // Handle file upload
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

        // Return JSON response
        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }
}
