<?php

class BinController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','SaveBin','DeleteBin','DirectAdd', 'Getbins', 'UnBlockbin','Blockbin','Disable'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['mas_inv_bin_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['mas_inv_bin_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
	}

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetList()
        {
                $model=new MasInvBin();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $warehouse_type = isset($_POST['warehouse_type']) ? $_POST['warehouse_type'] : '';
                $rack_type = isset($_POST['rack_type']) ? $_POST['rack_type'] : '';
                $columns = array(
                // datatable column index  => database column bin_name
                0 =>'t.id',
                1 => 'rack.warehouse_id',
                2 =>'bin_name',
                3 =>'rack_id',
                );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (bin_name LIKE '%".$searchString."%' OR rack_id LIKE '%".$searchString."%')";
                }
                if (!empty( $warehouse_type)) {
                    $condition .= " AND rack.warehouse_id = $warehouse_type";
                 
                }
        
                if (!empty($rack_type)) {
                    $condition .= " AND t.rack_id = $rack_type";
                 
                }
                $count = $model->with('rack')->count(array('condition'=>$condition));
                $model=$model->with('rack')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                 
                foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_bin_edit"])){
                      $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'bin/create&id=' . $row['id'] . '\',\'Edit Bin\',\'lg\')"><i class="fa fa-edit"></i></button>';             

                    }

                    // if(isset(Yii::app()->user->havePermissionOn['mas_inv_bin_disable']) ||  Yii::app()->user->authorised_user == 1)
                    // {

                    // if ($row->isActive == "Y") 
                    // {
                    //     $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disablebin(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                    // }
                    // if ($row->isActive == 'N') 
                    // {
                    //         $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enablebin(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                    // }            
                    
                    // }
                    $rowData[]=array($m,
                        $row['rack']['mas_warehouse_det']['warehouse_name'],
                        $row['rack']['rack_name'],
                        $row['bin_name'],
                        $row['is_base_bin'],
                        array('id' => $row['id'],'code'=>$row['bin_name'], 'status' => $row->isActive),);
   
                
                    $m++;
                    
                }
                
                $data['data'] = $rowData;
                echo json_encode($data);
        }

        public function actionCreate()
        {
            $model=new MasInvBin();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('bin_form', array('model' => $model), false, false);
        }
  
  
        public function actionSaveBin()
        {
            $model = new MasInvBin();
            if (isset($_POST['MasInvBin']))
            {
    		$model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
    		if ((int) @$_POST['MasInvBin']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasInvBin']['id'];
                    $model=$model->findByPk($id);  
                    $audit_type = 'UPDATED';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                }
                if($_POST['MasInvBin']['is_base_bin'] == "Y"){
                	MasInvBin::model()->updateAll(array( 'is_base_bin' => 'N' ), 'is_base_bin = "Y"' );
            	}
                $model->is_base_bin = $_POST['MasInvBin']['is_base_bin'];
                $model->attributes=$_POST['MasInvBin'];
                if ($model->save())
                {    
                    // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'BIN_MASTER',
                            Yii::app()->user->id,
                            $audit_type,
                            " with bin_name: - {$model->bin_name}  "
                        );
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['bin_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        public function actionDeleteBin(){
		$id = $_POST['id'];
                $model=new MasInvBin();
                $del = $model->findByPk($id); // audit log changes
                $model->deleteByPk($id);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'BIN_MASTER',
                    Yii::app()->user->id,
                    'DELETED',
                    " with bin_name: - {$del->bin_name}  "
                );
                // end audit log
                echo "success";
    }
    
     public function actionDirectAdd(){
           $from = $_POST['from'];
           $bin_name = $_POST['bin_name'];
           $rack = $_POST['rack'];
           if($bin_name != ''){
               $modelBin = new MasInvBin;
               $modelBin->bin_name = $bin_name;
               $modelBin->rack_id = $rack;
               if($modelBin->save()){
                    $data  = MasInvBin::getBins();
                    if($from == 'inventory'){
                        $model = new ProductLocation;
                        $field_bin_name = 'bin';
                    }
                    $model->$field_bin_name = $modelBin->id;
                    $drop=CHtml::activedropDownList($model,$field_bin_name, $data,  array('class' => 'tooltipster','data-label'=>'Bin'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
               }else{
                    $error = CActiveForm::validate($modelBin, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
           
            
         }
    public function actionGetbins(){
        $model = $_POST['model'];
        $field_id = $_POST['field_id'];
        $id = (int) $_POST['id'];
        echo CHtml::activedropDownList(new $model, $field_id,MasInvBin::getBins_rackwise($id), array('data-label'=>'Bin'));
    }


    public function actionBlockbin() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasInvBin::model()->updateByPK($id, array('isActive' => "N"));
              // inserting to audit log
              $model=new MasInvBin();
              $upt = $model->findByPk($id); // audit log changes
              AuditLog::saveAuditLogs(
                  'BIN_MASTER',
                  Yii::app()->user->id,
                  'BLOCKED',
                  " with bin_name: - {$upt->bin_name}  "
              );
             // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlockbin() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasInvBin::model()->updateByPK($id, array('isActive' => "Y"));
             // inserting to audit log
             $model=new MasInvBin();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'BIN_MASTER',
                 Yii::app()->user->id,
                 'UNBLOCKED',
                 " with bin_name: - {$upt->bin_name}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasInvBin();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}

