<?php

class AssignmentsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Setstatus'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new Assignments;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.date',
            2 => 'assignedUser.first_name',
            3 => 'customerDetails.customer_name',
            4 => 't.remarks',
            5 => 't.isComplete',
            6 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isComplete = "N"';
        if (Yii::app()->user->authorised_user != 1)
            $condition .= ' AND t.user_id=' . Yii::app()->user->id;
        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            if (Yii::app()->user->authorised_user != 1)
                $condition = 't.user_id=' . Yii::app()->user->id;
            else
                $condition = '1=1';
            $condition .= " AND ( assignedUser.first_name LIKE '%" . $searchString . "%' OR customerDetails.customer_name LIKE '%" . $searchString . "%' OR t.remarks ) ";
        }
        $count = $model->with('assignedUser', 'customerDetails')->count(array('condition' => $condition));
        $model = $model->with('assignedUser', 'customerDetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $row) {
            $div = '<button class="btn btn-primary btn-xs" title="View Task" onclick="loadPopupModal(\'assignments/create&id=' . $row['id'] . '\',\' ' . $row['customerDetails']['customer_name'] . ' \',\'lg\')"><i class="fa fa-eye"></i></button>';
            if (strtotime($row['date']) <= strtotime(date('Y-m-d')) && $row['isComplete'] == 'N')
                $div .= ' <a href ="#" title="Mark as Completed" class="btn btn-primary btn-xs" onclick="setStatus(' . $row['id'] . ')"><i class="fa fa-check-circle"></i></a>';
            $rowData[] = array($row['id'], date('d/m/Y', strtotime($row['date'])), $row['assignedUser']['first_name'] . ' ' . $row['assignedUser']['last_name'], $row['customerDetails']['customer_name'], $row['remarks'], ( $row['isComplete'] == 'Y' ) ? 'Yes' : 'No', '<div class="btn-wrap text-center">' . $div . '</div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new Assignments();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSave() {
        $model = new Assignments;
        $otherErrors = array();
        if ((int) $_POST['Assignments']['id'] > 0)
            $model = $model->findBypk((int) $_POST['Assignments']['id']);
        $model->attributes = $_POST['Assignments'];
        $model->created_by = Yii::app()->user->id;
        $model->created_datetime = date('Y-m-d h:i:s');
        $model->date = ( count(explode('/', $_POST['Assignments']['date'])) == 3 ) ? date('Y-m-d', strtotime(str_replace('/', '-', $_POST['Assignments']['date']))) : date('Y-m-d');
        $valid = $model->validate();
        if (strtotime($model->date) < strtotime(date('Y-m-d'))) {
            $otherErrors[] = 'Previous Date is Not Allowed!';
            $valid = false;
        }

        if ($valid) {
            echo json_encode(array('status' => 'success'));
            $model->save(false);
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            echo CJSON::encode(array_merge_recursive($error1, $otherErrors));
        }
    }

    public function actionSetstatus() {
        $id = (int) $_POST['id'];
        $activityType = array(1 => 'M', 2 => 'V', 3 => 'C', 4 => 'C');
        if ($id > 0) {

            $assignment = Assignments::model()->findbypk($id);
            $assignment->isComplete = 'Y';
            $assignment->save(false);

            $model = new Activity;
            $model->crm_user_id = $assignment->user_id;
            $model->company_id = $assignment->customer_id;
            $model->notes = $assignment->remarks;
            $model->typ_of_activity = $activityType[$assignment->type];
            $model->date_to_do = $assignment->date;
            $model->date_of_activity = $assignment->date;
            $model->isComplete = 'Y';
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            $model->save(false);
        }
        echo 'success';
    }

}
