<?php

class ApprovalController extends Controller
{
	public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','GetApprovalList','saveApproval','AddApproval'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
    
    public function actionIndex() {
        $model   = new ApprovalLevelGeneral();      
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

            $this->render('index');
    }
    
    public function actionGetApprovalList()
        {
                $model=new ApprovalLevelGeneral();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                        0=>'t.level_type',
        1=>'t.id',
        2=>'t.item_type',
        3=>'t.created_date_time',                                       
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = "t.id DESC";
                $condition = 't.id !=""';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  //$searchString = $_POST['search']['value'];
                  //$condition.=" and (event_name LIKE '%".$searchString."%' OR location LIKE '%".$searchString."%') AND category_name !='movie'";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                
                //$now                = date("d-m-Y H:i:s");
                //$nowstr             = strtotime($now);
               
                foreach ($model as $row)
                {
                    if($row['level_type']=='1')
                        $level_type="Sales";
                    else if($row['level_type']=='2')
                        $level_type="Purchase Enquiry";
                    
                        
                    if($row['item_type']=='1')
                        $item_type="Quotation";
                    else if($row['item_type']=='2')
                        $item_type="Order";
                    if($row['item_type']=='3')
                        $item_type="Enquiry";
                    else if($row['item_type']=='4')
                        $item_type="Purchase Order";
                    
                    
                    /*$rowData[]=array($m,$row['event_name'],$row['location'],date('d/m/Y',strtotime($row['event_start_date'])),date('d/m/Y',strtotime($row['event_end_date'])),'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'events/create&id='.$row['id'].'\',\'Update Events\',\'xl\')"><i class="fa fa-pencil"></i></button> '
                .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteEvent('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
                    $m++;*/
                    
                    $rowData[]=array($m,$level_type,$item_type,date('d/m/Y',strtotime($row['created_date_time'])),'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'approval/AddApproval&id='.$row['id'].'\',\'Edit Approval List\',\'xl\')"><i class="fa fa-pencil"></i></button></div>');
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
        
        
        public function actionAddApproval() {
        
         $model_ApprovalLevelGeneral  = new ApprovalLevelGeneral();
         $model_ApprovalLevelDetails  = new ApprovalLevelDetails();
         
         $id = (int) Yii::app()->request->getParam('id');
         if ($id > 0) {
            $model_ApprovalLevelGeneral  = $model_ApprovalLevelGeneral->findByPK($id);
            
            $model_ApprovalLevelDetail = ApprovalLevelDetails::model()->findAll(array('condition'=>'approval_level_id="'.$id.'"'));
            $level1_array   = array();
            foreach($model_ApprovalLevelDetail as $i=>$value){
               $level1_array[]= $value->level1_user_id;
            }
            $model_ApprovalLevelDetails->level1_user_id=$level1_array;
            
            $level_2_array   = array();
            foreach($model_ApprovalLevelDetail as $i=>$value){
               $level_2_array[]= $value->level2_user_id;
            }
            $model_ApprovalLevelDetails->level2_user_id=$level_2_array; 
            
            $level_3_array   = array();
            foreach($model_ApprovalLevelDetail as $i=>$value){
               $level_3_array[]= $value->level3_user_id;
            }
            $model_ApprovalLevelDetails->level3_user_id=$level_3_array; 
            
            
            if(empty($model_ApprovalLevelDetail)){

                $model_ApprovalLevelDetails = array(new ApprovalLevelDetails);

            }
         }
         else
         {
            $id  = 0;
         }
         Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
         $this->render('approval_form', array('model_ApprovalLevelGeneral' => $model_ApprovalLevelGeneral,'model_ApprovalLevelDetails'=>$model_ApprovalLevelDetails,'id'=>$id), false, true);
         
    }
    
    
    
    
    
    
    
     public function actionsaveApproval() {


        $model_ApprovalLevelGeneral  = new ApprovalLevelGeneral();
        
        
        
        
        if (isset($_POST['ApprovalLevelGeneral'])) {
            
            //$model_ApprovalLevelGeneral->attributes        = $_POST['ApprovalLevelGeneral'];
            
                $model_ApprovalLevelGeneral->created_by        = Yii::app()->user->id;
                $model_ApprovalLevelGeneral->created_date_time = date('Y-m-d h:i:s');                 
                $model_ApprovalLevelGeneral->updated_by        = "0";
                $model_ApprovalLevelGeneral->updated_date_time ="0000-00-00";
            
            
            if ((int) @$_POST['ApprovalLevelGeneral']['id'] > 0)
            {
                //ApprovalLevelGeneral::model()->deleteAll('id=:refer_id', array(':refer_id' => $_POST['ApprovalLevelGeneral']['id']));
                //ApprovalLevelDetails::model()->deleteAll('approval_level_id=:refer_id', array(':refer_id' => $_POST['ApprovalLevelGeneral']['id']));
                $id= (int) @$_POST['ApprovalLevelGeneral']['id']; 
                $model_ApprovalLevelGeneral = $model_ApprovalLevelGeneral->findByPk($id); 
                $model_ApprovalLevelGeneral->updated_by        = Yii::app()->user->id;
                $model_ApprovalLevelGeneral->updated_date_time = date('Y-m-d h:i:s');
            }
            
            $model_ApprovalLevelGeneral->attributes = $_POST['ApprovalLevelGeneral']; 
            
            //print_r($_POST); die();
            
            if($model_ApprovalLevelGeneral->validate())
            {
                
                
                
                
                
                
                $model_ApprovalLevelGeneral->level1_amount        = $_POST['ApprovalLevelGeneral']['level1_amount'];
                $model_ApprovalLevelGeneral->level2_amount        = $_POST['ApprovalLevelGeneral']['level2_amount'];
                $model_ApprovalLevelGeneral->level3_amount        = $_POST['ApprovalLevelGeneral']['level3_amount'];
                
                if($model_ApprovalLevelGeneral->save()){
                    
                    
                    $level_1_count = count($_POST['level1_user_list']);
                    $level_2_count = count($_POST['level2_user_list']);
                    $level_3_count = count($_POST['level3_user_list']);
                    
                    if($level_1_count >0 || $level_2_count >0 || $level_3_count >0)
                    {
                        //ApprovalLevelDetails::model()->deleteAll('approval_level_id=:refer_id', array(':refer_id' => $model_ApprovalLevelGeneral->id));
                    }
                    
                    if($level_1_count >0)
                    {
                        ApprovalLevelDetails::model()->deleteAll('approval_level_id=:refer_id', array(':refer_id' => $model_ApprovalLevelGeneral->id));
                        
                        foreach($_POST['level1_user_list'] as $eachArray){
                            $model_ApprovalLevelDetails  = new ApprovalLevelDetails();
                            $model_ApprovalLevelDetails->level1_user_id = $eachArray;
                            $model_ApprovalLevelDetails->approval_level_id = $model_ApprovalLevelGeneral->id;
                            $model_ApprovalLevelDetails->save();
                        }
                    }
                    
                    if($level_2_count >0)
                    {
                        foreach($_POST['level2_user_list'] as $eachArray)
                        {
                            $model_ApprovalLevelDetails  = new ApprovalLevelDetails();
                            $model_ApprovalLevelDetails->level2_user_id = $eachArray;
                            $model_ApprovalLevelDetails->approval_level_id = $model_ApprovalLevelGeneral->id;
                            $model_ApprovalLevelDetails->save();
                        }
                    }
                    
                    if($level_3_count >0)
                    {
                        foreach($_POST['level3_user_list'] as $eachArray)
                        {
                            $model_ApprovalLevelDetails  = new ApprovalLevelDetails();
                            $model_ApprovalLevelDetails->level3_user_id = $eachArray;
                            $model_ApprovalLevelDetails->approval_level_id = $model_ApprovalLevelGeneral->id;
                            $model_ApprovalLevelDetails->save();
                        }
                    }
                    
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                }
                
            }
            else
            {
                
                $error = CActiveForm::validate($model_ApprovalLevelGeneral, '', false);                 
                    if ($error != '[]')
                    echo $error;
                
            }
            
            
        }
        
        

    }
    
    

       
	
}