<?php
class ApiserviceController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('getlist','UploadImage','GetServiceRequestDetails','StartServiceJob','EndServiceJob','CompleteServiceJob','SaveServiceJob','UploadSignature'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(''),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                // 'users' => array('*'),
            ),
        );
    }



    public function filters()
    {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function beforeAction($action)
    {
        $this->ChangeDB();
        return parent::beforeAction($action);
    }
    public function actiongetlist()
    {
       // try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $condition = "1=1";
                if (isset($data_array['status_id']) && !empty($data_array['status_id'])) {
                    if($data_array['status_id']==3)
                         $condition .= " AND  status_id IN(1,3)";
                     else
                        $condition .= " AND  status_id = " . $data_array['status_id'];
                }//
                
                if (isset($data_array['user_id']) && !empty($data_array['user_id'])) {
                    $condition .= " AND (t.assigned_id = " . (int) $data_array['user_id'] . " OR customer.created_by = " . (int) $data_array['user_id'] . ')';
                }
                if (isset($data_array['term']) && !empty($data_array['term'])) {
                    $condition .= " AND (customer.customer_name LIKE '%{$data_array['term']}%'  OR sales_cust.customer_phone_no LIKE '%{$data_array['term']}%'  OR t.remark LIKE '%{$data_array['term']}%') ";
                }
                 
                
                $models = SaleRepairRequest::model()->with('sales_cust', 'status','customer')->findAll(['condition' => $condition, 'order' => 't.schedule_date ASC']);
 
                $data = [];

                foreach ($models as $key => $row) {                    
                 
                    if ($row->request_from != 'MI') {
                            $scheduleDate = (!empty($row->schedule_date) && $row->schedule_date != '0000-00-00')
                                ? date('d/m/Y', strtotime($row->schedule_date))
                                : '';
                        }else{
                            $scheduleDate ='';
                        }
                        $type_array = array(1=> 'repair', 2 => 'schedule');
                     $actualDate = (!empty($row->completed_date) && $row->completed_date != '0000-00-00')
                ? date('d/m/Y', strtotime($row->completed_date))
                : (!empty($row->completed_date_time && $row->completed_date_time != '0000-00-00 00:00:00') ? date('d/m/Y', strtotime($row->completed_date_time)) : '');
                $totalItems =  (int)SalesRepairRequestItem::model()->count(['condition'=>'header_id='.(int)$row->id]);
                $CompletedItems =(int) SalesRepairRequestItem::model()->count(['condition'=>'header_id='.(int)$row->id.' AND status_id=2']);
                $PendingItems = (int) SalesRepairRequestItem::model()->count(['condition'=>'header_id='.(int)$row->id.' AND status_id=3']);
                 $count= [];
                 $count = [
                        "total_machine_count" => $totalItems,
                        "total_machine_pending" => $PendingItems,
                        "total_machine_completed" => $CompletedItems 
                    ];
                    $job_status="";
                    if($row->status_id == 3)
                        $job_status ="started";
                    else if($row->status_id == 2)
                        $job_status ="stopped";
                    $start_time = $end_time ="";
                    $job_status_type = "PENDING";
                    if($row->process_status==1)
                        $job_status_type = "STARTED";
                    if($row->process_status==2)
                        $job_status_type = "STOPPED";
                    if($row->status_id==2 && $row->is_completed=="Y")
                        $job_status_type = "COMPLETED";

                    if($row->start_time!="0000-00-00 00:00:00")
                        $start_time = date('d/m/Y h:i A',strtotime($row->start_time));
                    if($row->end_time!="0000-00-00 00:00:00")
                        $end_time = date('d/m/Y h:i A',strtotime($row->end_time));
                    $data[] = [
                        "id" => $row->id,
                        "customer" => $row->customer->customer_name,
                        "customer_id" => $row->customer_id,
                        "service_id" => $row->service_id,
                        "service_name" => $row->service ? $row->service->name:"",
                        "actual_date" => $actualDate,
                        "schedule_date" => $scheduleDate,
                        "assigned_id" => $row->assigned_id,
                        "assigned" => (!empty($row->assigned_id) && $row->assigned) ? $row->assigned->first_name . ' ' . $row->assigned->last_name : '',
                        "type" =>  $type_array[$row->type_id],
                        "type_id" => $row->type_id,
                        "remark" => $row->remark,
                        "submit_invoice" => $row->submit_invoice,
                        "technician_status" => $row->technician_status,
                        "status_id" => ($row->status_id == 2) ? 2 : 1,
                        "job_status"=>$job_status,
                        "start_time" =>$start_time,
                        "end_time" =>$end_time,
                        "job_status_type"=>$job_status_type,
                        "count" => $count
                    ];
                     
                }
                $response = array('status' => "success", "message" => "success", "data" => $data );
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
        // } catch (Exception $e) {
        //     header("HTTP/1.1 404 not found");
        //     header('Content-Type: application/json');
        //     $response = array('status' => "error", "message" => "Unexpected Server error");
        // }
        echo json_encode($response);
    }
      public function actionGetServiceRequestDetails()
    {
       // try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $condition =$con = "1=1";
                $data = [];
                $request_id = $data_array['request_id'] ;
                $status_id = $data_array['status_id'] ;
                if($request_id>0){
                $condition .= " AND  header_id = " . $data_array['request_id'];
                $con .= " AND  header_id = " . $data_array['request_id'];
                if($status_id>0)
                $con .= " AND  status_id = " . $data_array['status_id'];
                $models = SalesRepairRequestItem::model()->findAll(['condition' => $con]);
                $pending_count = (int)SalesRepairRequestItem::model()->count(['condition' => $condition.' AND status_id=3']);
                $complete_count = (int)SalesRepairRequestItem::model()->count(['condition' => $condition.' AND status_id=2']);
                $count = [
                    "pending"=>$pending_count,
                    "complete"=>$complete_count,
                ];
                    foreach ($models as $key => $row) {                    
                   
 
                    $data[] = [
                        "id" => $row->id,
                        "machine" => $row->machine->part_number,
                        "machine_id" => $row->machine_id,
                        "serial_no" => $row->serial_no,
                        "request_id" => $row->header_id,
                        "description" => $row->machine->description,
                        "service_id" => $row->service_id,
                        "service_type" => $row->service ? $row->service->name:"",
                        "issue_item_id" => $row->issue_item_id,
                        "location_id" => $row->location_id,
                        "location" => $row->outlet_location->location_name,
                        "fragrance_id" => $row->new_fragrance_id,
                        "fragrance_name" => $row->new_fragrance ?$row->new_fragrance->name:'',
                        "is_completed" => $row->is_completed ,
                        "remark" => $row->remark ,
                        "status_id" => $row->status_id
                    ];
                }}
                $response = array('status' => "success", "message" => "success", "data" => $data,'count'=>$count);
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
        // } catch (Exception $e) {
        //     header("HTTP/1.1 404 not found");
        //     header('Content-Type: application/json');
        //     $response = array('status' => "error", "message" => "Unexpected Server error");
        // }
        echo json_encode($response);
    }
    function createThumbnail($srcPath, $destPath, $thumbWidth = 250)
    {
        // Get image info
        list($width, $height, $imageType) = getimagesize($srcPath);

        // Create image resource from source
        switch ($imageType) {
            case IMAGETYPE_JPEG:
                $srcImage = imagecreatefromjpeg($srcPath);
                break;
            case IMAGETYPE_PNG:
                $srcImage = imagecreatefrompng($srcPath);
                break;
            case IMAGETYPE_GIF:
                $srcImage = imagecreatefromgif($srcPath);
                break;
            default:
                return false; // unsupported format
        }

        // Calculate new height while keeping aspect ratio
        $thumbHeight = floor($height * ($thumbWidth / $width));

        // Create blank image with new dimensions
        $thumbImage = imagecreatetruecolor($thumbWidth, $thumbHeight);

        // Preserve transparency for PNG & GIF
        if ($imageType == IMAGETYPE_PNG || $imageType == IMAGETYPE_GIF) {
            imagecolortransparent($thumbImage, imagecolorallocatealpha($thumbImage, 0, 0, 0, 127));
            imagealphablending($thumbImage, false);
            imagesavealpha($thumbImage, true);
        }

        // Copy and resize
        imagecopyresampled($thumbImage, $srcImage, 0, 0, 0, 0, $thumbWidth, $thumbHeight, $width, $height);

        // Save thumbnail to destination path
        switch ($imageType) {
            case IMAGETYPE_JPEG:
                imagejpeg($thumbImage, $destPath);
                break;
            case IMAGETYPE_PNG:
                imagepng($thumbImage, $destPath);
                break;
            case IMAGETYPE_GIF:
                imagegif($thumbImage, $destPath);
                break;
        }

        // Free memory
        imagedestroy($srcImage);
        imagedestroy($thumbImage);

        return true;
    }
    
    
        public function actionUploadImage()
            {
               // try {
                    $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
                    $userModel = User::model()->findBytoken($token);
                    $response = array();
                    if (!empty($userModel) && $userModel->id > 0) {
                        //$data_array = json_decode(file_get_contents('php://input'), true);
                        $service_id = 1;//$_REQUEST['service_id'];
                        $model = new SaleRepairRequest();
                        //$model = $model->findByPk($service_id);
                      //  if (!empty($model)) {
                            $parentDirectory = 'uploads/tmpservice/'; // Replace this with the actual path to the parent directory
        
                            $mainDirectory = 'uploads/service/';
        
                            $filename = $_FILES["file"]["name"]; //
        
                            $extension = pathinfo($filename, PATHINFO_EXTENSION);
        
        
                            $new_filename = 'SR_' . $service_id . "_" . date('d_m_Y') . '_' . uniqid() . "." . $extension;
        
        
        
                            if (!is_dir($parentDirectory)) {
                                mkdir($parentDirectory, 0777, TRUE);
                            }
        
                            if (!is_dir($mainDirectory)) {
                                mkdir($mainDirectory, 0777, TRUE);
                            }
        
                            $fullPath = $parentDirectory . '/' . $filename;
        
                            if (move_uploaded_file($_FILES["file"]["tmp_name"], $fullPath)) {
        
                                $actual_resized_path = 'uploads/service/' . $new_filename;
        
                                if ($this->createThumbnail($fullPath, $actual_resized_path)) {
        
        
        
                                    //unlink($fullPath); 
        
                                    $response = [
                                        "status" => "success",
                                        "filepath" => $new_filename
                                    ];
                                } else {
                                    //unlink($fullPath);
                                    $response = [
                                        "status" => "error",
                                        "message" => "Resize failed"
                                    ];
                                }
        
                                $response = ["status" => "success", "filepath" => $new_filename];
                            } else {
                                $response = ["status" => "error", "message" => "Upload Failed"];
                            }
                        // } else {
                        //     $response = ["status" => "error", "message" => "Service Not Found"];
                        // }
                    } else {
                        header("HTTP/1.1 401 Unauthorized");
                        header('Content-Type: application/json');
                        $response = array('status' => "error", "message" => "Unauthorized user");
                    }
                // } catch (Exception $e) {
                //     header("HTTP/1.1 404 not found");
                //     header('Content-Type: application/json');
                //     $response = array('status' => "error", "message" => "Unexpected Server error");
                // }
                echo json_encode($response);
            }
    public function actionStartServiceJob()
    {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                 if (!empty($data_array['id'])) {
                    $id = (int) $data_array['id'];
                    $model = SaleRepairRequest::model()->findByPk($id);
                   // $model->type_id = 2;
                    $model->status_id = 3;
                    $model->updated_by = $data_array['created_by'];
                    $modelLog = new SalesRequestLog();
                    $log_count= (int)$modelLog->count(array('condition'=>'job_id='.$id));
                    //if($log_count==0)
                    $model->start_time = date('Y-m-d H:i:s');
                    $model->process_status = 1;
                    $model->updated_date_time = date('Y-m-d H:i:s');
                    $model->save(false);

                    $modelLog = new SalesRequestLog();
                    $modelLog->job_id = $id;
                    $modelLog->start_date = date('Y-m-d');
                    $modelLog->start_time = date('H:i:s');
                    $modelLog->created_by = 0;
                    $modelLog->created_date_time = date('Y-m-d H:i:s');
                    $modelLog->save(false);


                 
                $response = ["status" => "success", "message" => "Service Job Started", "id" => $model->id];
                }  
                else
                {
                    $response = ["status" => "failed", "message" => "Job ID required"];
                }
                
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
            echo json_encode($response);
    }    
    public function actionEndServiceJob()
    {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $machineIds = $data_array['machine_id'];
                $id =  $data_array['id'];
                 if (!empty($data_array['id'])) {
                    $id = (int) $data_array['id']; 
                        $saleRequest = SaleRepairRequest::model()->findByPk($id);
                        if ($saleRequest) {
                            $saleRequest->process_status = 2;
                            //$saleRequest->copy_id = 0;
                            //$saleRequest->end_time = date('Y-m-d H:i:s'); 
                            $saleRequest->save(false);

                            $modelLog = new SalesRequestLog();
                            $modelLog = $modelLog->find(array('condition'=>'job_id='.$id.' AND start_time!="00:00:00"','order'=>'id DESC'));
                            if(!empty($modelLog))
                            {
                                $modelLog->job_id = $id;
                                $modelLog->end_date = date('Y-m-d');
                                $modelLog->end_time = date('H:i:s');
                                $modelLog->created_by = 0;
                                $modelLog->created_date_time = date('Y-m-d H:i:s');
                                $modelLog->save(false);
                            }
                        }
                

                $response = ["status" => "success", "message" => "Service Job Stopped"];
                }  
                else
                {
                    $response = ["status" => "failed", "message" => "Job ID required"];
                }
                
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
            echo json_encode($response);
    }    


    public function actionSaveServiceJob()
    {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                 if (!empty($data_array['request_id'])) {
                    $id = (int) $data_array['request_id'];
                    //$items = $data_array['items'];
                        // print_r($model);
                    $model = SaleRepairRequest::model()->findByPk($id);
                    if (!$model) {
                        $response =['status' => 'error', 'message' => 'Record not found.'];
                        
                    }
                    else
                    {
                        
                        if(!empty($model))
                        {
                            
                            $modelItem = new SalesRepairRequestItem();
                            $modelItem = $modelItem->findByPk($data_array['machine_id']);
                            if(!empty($modelItem))
                            {
                                //$modelItem->service_type     = $eachItem['service_type'];
                                $modelItem->new_fragrance_id = $data_array['fragrance_id'];
                                $modelItem->file_name        = $data_array['file_name'];
                                $modelItem->remark           = $data_array['remark'];
                                $modelItem->is_completed     =  "Y";
                                $modelItem->status_id        =  2 ;
                                $modelItem->save(false);
                            }
                            }
                        }
                    
                         $response = [
                            'status' => 'success',
                            'message' => 'success'
                        ];
                    }
                
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
            echo json_encode($response);
    }    

    public function actionCompleteServiceJob()
    {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                 if (!empty($data_array['request_id'])) {
                    $id = (int) $data_array['request_id'];
                    $model = SaleRepairRequest::model()->findByPk($id);
                        // print_r($model);
                    if (!$model) {
                        $response =['status' => 'error', 'message' => 'Record not found.'];
                        
                    }
                    else
                    {
                    $remainingItems = (int)SalesRepairRequestItem::model()->count(
                        'header_id = :headerId AND status_id !=2',
                        [':headerId' => $id]
                    );
                      if ($remainingItems == 0) {
                        $model = SaleRepairRequest::model()->findByPk($id);
                        $model->is_completed = 'Y';
                        $model->is_Visited = 'Y';
                        $model->status_id = '2';
                        $model->completed_by = 0;
                        $model->completed_date_time = date('Y-m-d H:i:s');
                        $model->end_time = date('Y-m-d H:i:s');
                        $model->completed_date = date('Y-m-d');
                        $model->schedule_status = 'C';
                        $model->process_status = 2;
                        $model->sign = $data_array['signature'];
                        $model->remark = $data_array['remark'];
                        $model->save(false);
                         $response = [
                                    'status' => 'success',
                                    'message' => 'Service request completed successfully.'
                                ];
                    }
                     else {
                               $response = [
                                    'status' => 'error',
                                    'message' => $remainingItems . ' machine(s) are still not completed.'
                                ];
                            }
                        }
                
            }
            // echo "111";
        } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
            echo json_encode($response);
    }    
     public function actionUploadSignature()
            {
               // try {
                    $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
                    $userModel = User::model()->findBytoken($token);
                    $response = array();
                    if (!empty($userModel) && $userModel->id > 0) {
                        $data_array = json_decode(file_get_contents('php://input'), true);
                        $service_id = $_REQUEST['service_id'];
                        $model = new SaleRepairRequest();
                        $model = $model->findByPk($service_id);
                        if (!empty($model)) {
                            //$parentDirectory = 'uploads/tmpservice/'; // Replace this with the actual path to the parent directory
        
                            $mainDirectory = 'uploads/service/';
        
                            $filename = $_FILES["file"]["name"]; //
        
                            $extension = pathinfo($filename, PATHINFO_EXTENSION);
        
        
                            $new_filename = 'SR_' .  date('d_m_Y') . '_' . uniqid() . "." . $extension;
        
        
        
                            // if (!is_dir($parentDirectory)) {
                            //     mkdir($parentDirectory, 0777, TRUE);
                            // }
        
                            if (!is_dir($mainDirectory)) {
                                mkdir($mainDirectory, 0777, TRUE);
                            }
        
                            $fullPath = $mainDirectory . '/' . $new_filename;
        
                            if (move_uploaded_file($_FILES["file"]["tmp_name"], $fullPath)) {
        
                                 $actual_resized_path = 'uploads/service/' . $new_filename;
                                 $response = [
                                        "status" => "success",
                                        "filepath" => $new_filename
                                    ];
                                
        
                                $response = ["status" => "success", "filepath" => $new_filename];
                            } else {
                                $response = ["status" => "error", "message" => "Upload Failed"];
                            }
                        } else {
                            $response = ["status" => "error", "message" => "Service Not Found"];
                        }
                    } else {
                        header("HTTP/1.1 401 Unauthorized");
                        header('Content-Type: application/json');
                        $response = array('status' => "error", "message" => "Unauthorized user");
                    }
                // } catch (Exception $e) {
                //     header("HTTP/1.1 404 not found");
                //     header('Content-Type: application/json');
                //     $response = array('status' => "error", "message" => "Unexpected Server error");
                // }
                echo json_encode($response);
            }
     
}
    