<?php



class ApiorderController extends Controller {



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array("GetList","SaveOrder","GetItemDetails","GetDetailsFromOderId","PrintOrderReportPDF","GetCategoryOrder","GetListOrder","UploadSignature","ProductClass"),

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    public function beforeAction($action) {

         $this->ChangeDB();
        return parent::beforeAction($action);

    }

    /**

     * API to get all order list

     * Author  : Ramesh

     * Modified :  28/06/2022

     * url https://cumuluserp.me/alaqsar/index.php?r=apiorder/GetList

     * input parameters HTTP_TOKEN

     */

    public function actionGetList() {

        try {

            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

            $userModel = User::model()->findBytoken($token);



            //if ($userModel->id > 0) {

            if (1==1) {

                //$condition = '(t.isActive="Y"  AND (file.current_process_status="O" OR file.current_process_status="PD" OR file.current_process_status="PI"))  AND t.order_type="sale" AND completed!="C"';

                $condition = '(t.isActive="Y")  AND t.order_type="sale"';



                $created_by = 0;

                $term = $_REQUEST['term'];

                if(isset($_REQUEST['created_by']))

                    $created_by = $_REQUEST['created_by'];

                if (!empty($term)&&$term!='') {

                    $condition = " ( t.id  LIKE '{$term}%' ) OR ( t.file_id  LIKE '%{$term}%' )  OR ( customer.customer_name  LIKE '%{$term}%' )";

                }

                $completed = $_REQUEST['completed'];

                if($completed!=''){

                    $condition .= ' AND t.completed="'.$completed.'"';

                } else {

                    $condition .= ' AND t.completed!="C"';

                }

                $convert_status = $_REQUEST['convert_status'];

                if($convert_status!=''){

                    $condition .= ' AND t.convert_status="'.$convert_status.'"';

                }

                $order_date = $_REQUEST['order_date'];

                $order_date_to = $_REQUEST['order_date_to'];

                if($order_date!=''){

                    $condition .= ' AND t.order_date="'.$order_date.'"';

                } else if($order_date!='' && $order_date_to!=''){

                    $condition .= ' AND t.order_date >="'.$order_date.'" AND t.order_date <="'.$order_date_to.'"';

                }else{

                    $condition .= ' AND t.order_date="'.date('Y-m-d').'"';

                }

                if($created_by  > 0) {

                    $condition .= ' AND t.created_by="'.$created_by.'"'; 

                }

                //echo $condition;

                $models = Order::model()->with('customer', 'file')->findAll([

                    "condition" => $condition,"order"=>"t.id DESC"

                ]);

                $count = Order::model()->count(array('condition'=>$condition));

                $list = [];

                foreach ($models as $key => $row) {

                    $list[] = array(

                        "id" => $row->id,

                        "file_id" => $row['file_id'],

                        "customer_name" => $row['customer']['customer_name'],

                        "order_date" => date("d/m/Y", strtotime($row['order_date'])),

                        "vat_amount" => $row['total_tax_amount'],

                        "grand_total" => $row['grand_total'],

                        "current_process_status"=>$row['file']['current_process_status'],

                        "completed"=>$row['completed']

                    );

                }

                $data = array('status' => "success", "count"=>$count, "data"=>$list,"message"=>$count." Records");

                header("HTTP/1.1 200 OK");

                header('Content-Type: application/json');

            }

            else {

                header("HTTP/1.1 401 Unauthorized");

                header('Content-Type: application/json');

                $data = array('status' => "error", "message"=>"Unauthorized user"); 

            }

	    }

	    catch(Exception $e) {

            header("HTTP/1.1 404 not found");

           header('Content-Type: application/json');

        $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	    }

        echo json_encode($data);

    }



  /**

     * API to get all order list invoice

     * Author  : Nisha

     * Modified :  30/06/2022

     * url https://cumuluserp.me/alaqsar/index.php?r=apiorder/GetList

     * input parameters HTTP_TOKEN

     */

    public function actionGetListOrder() {

        try {

            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
         
           error_log($token);

            if ($userModel->id > 0) {

            // if (1==1) {

                //$condition = '(t.isActive="Y"  AND (file.current_process_status="O" OR file.current_process_status="PD" OR file.current_process_status="PI"))  AND t.order_type="sale" AND completed!="C"';

                $condition = '(t.isActive="Y")  AND t.order_type="sale"';


                $created_by = 0;

                $term = $_REQUEST['term'];


                if(isset($_REQUEST['created_by']))

                    $created_by = $_REQUEST['created_by'];

                if (!empty($term)&&$term!='') {
                 $condition = " ( t.id  LIKE '{$term}%' ) OR ( t.file_id  LIKE '%{$term}%' )  OR ( customer.customer_name  LIKE '%{$term}%' ) ";

                }
                $completed = $_REQUEST['completed'];

                if($completed!=''){

                    $condition .= ' AND t.completed="'.$completed.'"';

                } else {

                    $condition .= ' AND t.completed!="C"';

                }

                $convert_status = $_REQUEST['convert_status'];

                if($convert_status!=''){

                    $condition .= ' AND t.convert_status="'.$convert_status.'"';

                }
                $invoice_status = $_REQUEST['invoice_status'];

                if($invoice_status!=''){

                    $condition .= ' AND file.current_process_status="'.$invoice_status.'"';

                }
                $order_date = $_REQUEST['order_date'];

                $order_date_to = $_REQUEST['order_date_to'];

                 if($order_date!='' && $order_date_to!=''){

                    $condition .= ' AND t.order_date >="'.$order_date.'" AND t.order_date <="'.$order_date_to.'"';

                } else if($order_date!=''){

                    $condition .= ' AND t.order_date="'.$order_date.'"';

                }else{

                    $condition .= ' AND t.order_date="'.date('Y-m-d').'"';

                }

                if($created_by  > 0) {

                    $condition .= ' AND t.created_by="'.$created_by.'"'; 

                }

               // code added sarika on 8-11-2022
                    if ($userModel->level!= 0 ){
                        if(!empty($userModel->location_id)){
                            $condition  .= ' OR customer.location_id IN ('.$userModel->location_id.') ';
                        }
                        
                    }

                //end code

             //   $models = Order::model()->with('customer', 'file')->findAll(array('condition'=>$condition,"order"=>"t.id DESC"));
               // findAll(["condition" => $condition,"order"=>"t.id DESC"]);

                $models = Order::model()->with('customer', 'file')->findAll([

                    "condition" => $condition,"order"=>"t.id DESC"

                ]);

                $count = Order::model()->with('customer', 'file')->count(array('condition'=>$condition));

                $list = [];

                foreach ($models as $key => $row) {

                    $list[] = array(

                        "id" => $row->id,

                        "file_id" => $row['file_id'],

                        "customer_name" => $row['customer']['customer_name'],

                        "order_date" => date("d/m/Y", strtotime($row['order_date'])),

                        "vat_amount" => $row['total_tax_amount'],

                        "grand_total" => $row['grand_total'],

                        "current_process_status"=>$row['file']['current_process_status'],

                        "completed"=>$row['completed']

                    );

                }

                $data = array('status' => "success", "count"=>$count, "data"=>$list,"message"=>$count." Records");

                header("HTTP/1.1 200 OK");

                header('Content-Type: application/json');

            }

            else {

                header("HTTP/1.1 401 Unauthorized");

                header('Content-Type: application/json');

                $data = array('status' => "error", "message"=>"Unauthorized user"); 

            }

        }

        catch(Exception $e) {
        //    print_r($e);
            header("HTTP/1.1 404 not found");

           header('Content-Type: application/json');

        $data = array('status' => "error", "message"=>"Unexpected Server error"); 

        }

        echo json_encode($data);

    }




     /**

     * API to get order details

     * Author  : Ramesh

     * Modified :  28/06/2022

     * url https://cumuluserp.me/alaqsar/index.php?r=apiOrder/GetList

     * input parameters HTTP_TOKEN

     */

    public function actionGetItemDetails() {

        try {

        /*$token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

        $userModel = User::model()->findBytoken($token);



        if ($userModel->id > 0) {*/

            $condition = " 1= 1";

            $term = Yii::app()->request->getParam('term');

            if (!empty($term)) {

                $condition = " ( t.part_number  LIKE '{$term}%' ) OR ( t.description  LIKE '%{$term}%' )   ";

            }

            $models = Store::model()->findAll([

                "condition" => $condition,'order'=>'part_number ASC','limit'=>10

            ]);

            $data = [];

            foreach ($models as $key => $row) {

                $query = 'SELECT quantity FROM view_all_stock_items WHERE id='.$row->id;

                $quantity = Yii::app()->db->createCommand($query)->queryScalar();

                $data[] = [

                    "id" => $row->id,

                    "part_number" => $row->part_number,

                    "description" => $row->description,

                    "brand_id" => $row->brand_class_id,

                    "brand_name" => $row->brand_detail->product_class,

                    "generic_id" => $row->generic_id,

                    "generic_name" => $row->genericdetails->generic_name,

                    "unit_id" => $row->unit_id,

                    "unit_name" => '',

                    "tax_code" => $row->tax_code,

                    "active" =>  $row->isActive,

                    "quantity"=>$quantity,

                    "rate"=>$row->rate,

                    "alias_name"=>$row->alias_name,

                    "selling_price_1" => $row['selling_price_1'],

                    "selling_price_2" => $row['selling_price_2']

                ];

            }

        /*}else{

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 

        }*/

        }

	    catch(Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	    }

        echo json_encode($data);

    }

    /**

     * API to save order details

     * Author  : Ramesh

     * Modified :  27/06/2022

     * url https://cumuluserp.me/alaqsar/index.php?r=apiorder/SaveOrder

     * input parameters HTTP_TOKEN

        {"customerid": 1001,"contactid": 1,"paymentid": 1,"invoicedate": "27/06/2022","orderdate": "27/06/2022","invoicetype":2,"billingaddress": "","termsandconditions": "","items": [{"part_number ": "003 - 36 PC ","product_id": 11,"description": "GLASS","unit_name": "Pcs","unit_id": 1,"quantity": 15,"rate": 0.555556,"vat": 0.00,"net": 8.333340000000002}]

        }

     */

    public function actionSaveOrder(){ 

        try {

            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

            $userModel = User::model()->findBytoken($token);

    

            //if ($userModel->id > 0) {

            if (1==1) {

                $input = file_get_contents('php://input');

                error_log('order');

                $variables = json_decode($input, true);

                //$user_id   = (int)$userModel->id;

                $user_id   = (int)$variables['created_by'];

                $modelOrder = new Order;

                $other = array();

                $modelOrderItem = array(new OrderItem());

                $flag = 0;

                $flag_dummy_item=0;

                $tax_type = 1;

                $scenario='';

                $flag = 0;

                $flag_dummy_item=0;

                $order_id = (int)$variables['id'];

                if ((int)$order_id > 0) {

                    $modelOrder = $modelOrder->findByPK($order_id);
                    
                    $current_process_status = $modelOrder->file->current_process_status;

                    $scenario='update';

                    $modelOrder->scenario = 'update';

                    $audit_type = 'UPDATED';

                    $flag = 1;                

                    $modelOrder->updated_by = $user_id;

                    $modelOrder->updated_datetime = date('Y-m-d H:i:s');

                } else {
                    
                    $current_process_status="O";

                    $file = new MasterFile;

                    $file->crm_user_id = $user_id;

                    $file->start_from = 'O';

                    $file->current_process_status = 'O';

                    $file->customer_id = $variables['customerid'];

                    $file->is_approved = 'Y';

                    $file->date_of_approval = date('Y-m-d');

                    $file->approved_by = $user_id;

                    $scenario='add';

                    $audit_type = 'CREATED';

                    $modelOrder->created_by = $user_id;

                    $modelOrder->created_datetime = date('Y-m-d H:i:s');

                }

                $modelOrder->exchange_rate = 1;

                if((int)$variables['file_id']>0)

                {

                    $mod_mas_file = MasterFile::model()->findByPk((int)$variables['file_id']);

                }

                //code signature added by nisha on 14-10-2022
                $modelOrder->signature = $variables['signature'];
                
                $modelOrder->crm_user_id = $user_id;

                $modelOrder->lead_owner_id=$user_id;

                $modelOrder->customer_id = $variables['customerid'];

                $modelOrder->contact_id = 2;

               
                $modelOrder->payment_terms = 1;

                $modelOrder->invoice_type = 1;
                
                $modelOrder->completed  ="Y";


                $modelOrder->remarks = $variables['remarks'];


                if ($variables['orderdate']  != '') {

                    $modelOrder->order_date = str_replace('/', '-', $variables['orderdate'] );

                    $modelOrder->order_date = date("Y-m-d", strtotime($modelOrder->order_date));
                    
                      $modelOrder->delivery_date = date("Y-m-d", strtotime($modelOrder->order_date . "+3 days"));


                }
                //code added by mereena on 29/09/2022
                 if ($variables['delivery_date']  != '') {

                    $modelOrder->delivery_date = str_replace('/', '-', $variables['delivery_date'] );

                    $modelOrder->delivery_date = date("Y-m-d", strtotime($modelOrder->delivery_date));
                    
                }
                //end



                $modelOrder->sales_group = 1;

                $modelOrder->shipping_by = MasShipping::getDefault() ;

                $modelOrder->currency=1;

                $valid = $modelOrder->validate();
                
                if($current_process_status!='O'){
                    $other[] = "Order already converted";
                    $valid=false;
                }

                

                $arr_items = $variables['items'];

                $p=0;

                if(!empty($arr_items)){

                    foreach($arr_items as $item){
                     //code added sarika
                        $arr_item_colors=$item['arr_colors'];
                        /*$k=0;
                        foreach($arr_item_colors  as $item_color){
                             $modelOrderColorItem[$k] = new OrderItemColour();
                             $modelOrderColorItem[$k]->inventory_color_id =  $item_color['color_id'];
                             $modelOrderColorItem[$k]->quantity =  $item_color['color_quantity'];
                            $k++;
                        }*/
                        //echo '<pre>';print_r($modelOrderColorItem);
                    //end code
                        if (($item['product_id'] > 0 && $item['part_number'] != 'memo') || $item['part_number'] == 'memo') {

                            $modelOrderItem[$p] = new OrderItem();

                            $modelOrderItem[$p]->product_id = $item['product_id'];

                            $mod_store=Store::model()->findByPK((int) $item['product_id']);

                            $modelOrderItem[$p]->description = $item['description'];

                            $modelOrderItem[$p]->rate = $item['selling_price'];

                            $modelOrderItem[$p]->quantity = $item['quantity'];

                            $modelOrderItem[$p]->amount =  $item['quantity'] * ($item['selling_price'] - (float) $item['deduction_amount']);

                            $modelOrderItem[$p]->brand_class_id = $mod_store->brand_class_id;

                            $modelOrderItem[$p]->product_generic_name = $mod_store->genericdetails->generic_name;

                            $modelOrderItem[$p]->deduction_percentage = 0;

                            $modelOrderItem[$p]->deduction_amount = $item['deduction_amount'];
                            

                            $modelOrderItem[$p]->unit_id = $item['unit_id'];
                            
                            //code added by mereena on 29/09/2022
                            $modelOrderItem[$p]->inventory_item_color_id =  $item['color_id'];
                            
                            $modelOrderItem[$p]->inventory_type = $mod_store->inventory_item_type;

                             if($mod_store->inventory_item_type==4){

                                $flag_dummy_item=1;

                            }
                            
                            if($modelOrder->delivery_date!=''){
                                $modelOrderItem[$p]->expected_delivery_date = $modelOrder->delivery_date;
                            }

                            

                            //$arr_mas_invoice_type = MasInvoiceType::model()->findByPk($variables['invoicetype']);

                            if((int) $mod_store->tax_code > 0){
                                $modelOrderItem[$p]->tax_vat_percentage = $mod_store->tax->percentage;
                                $modelOrderItem[$p]->tax_vat_amount     = ($mod_store->tax->percentage*$modelOrderItem[$p]->amount)/100;
                            }
                            else{
                                $modelOrderItem[$p]->tax_vat_percentage =   0;
                                $modelOrderItem[$p]->tax_vat_amount     =   0;
                            }
                           

                            $modelOrderItem[$p]->net_amount = $modelOrderItem[$p]->amount ;

                            if ($item['product_name'] == 'memo') {

                                $modelOrderItem[$p]->product_id = '999999';

                                $modelOrderItem[$p]->quantity = 0;

                                $modelOrderItem[$p]->amount = 0;

                                $modelOrderItem[$p]->net_amount = 0;

                            }

                            $modelOrderItem[$p]->order_id = 0;

                            $modelOrderItem[$p]->created_datetime=date('Y-m-d H:i:s');

                            $modelOrderItem[$p]->updated_datetime=date('Y-m-d H:i:s');

                            $modelOrderItem[$p]->created_by=$user_id;

                            $modelOrderItem[$p]->updated_by=$user_id;
                            
                            $modelOrderItem[$p]->item_colours = $item['arr_colors'];
                            

                            $valid = $modelOrderItem[$p]->validate() && $valid;

                            $p++;

                        }


                    }
                    
                  /*  echo '<pre>';
                    print_r($modelOrderItem);
                    exit;*/
                    
                } else{$valid=0;}



                if($valid){

                    $grand_total = 0;

                    

                    if ($audit_type=='CREATED') {

                        $file->save(false);

                        $file->refresh();

                        $modelOrder->file_id = $file->id;

                    }

                    $modelOrder->save(false);



                    // inserting to audit log

                    AuditLog::saveAuditLogs(

                        'ORDERS',

                        $user_id,

                        $audit_type,

                        " with No: - {$modelOrder->id}  "

                    );

                    // end audit log 

    

                    $modelOrder->refresh();

    

                    $order_id = $modelOrder->id;

                    OrderItem::model()->deleteAll('order_id=:refer_id', array(':refer_id' => $modelOrder->id));

                    $total_tax_amount = 0;

    

                    foreach ($modelOrderItem as $eachModel) {

                        $eachModel->order_id = $order_id;

                        $total_tax_amount += $eachModel->tax_vat_amount;

                        // $eachModel->save(false);
                        //code to save order item color sarika 31/10/2022
                           
                               // if($item['arr_colors']){
                            if($eachModel->save(false)){
                                foreach($eachModel->item_colours  as $eachItemColor){
                                        $modelItemColor = new OrderItemColour();
                                        $modelItemColor->order_id = $order_id;
                                        $modelItemColor->order_item_id =  $eachModel->id;
                                        $modelItemColor->inventory_color_id=$eachItemColor['color_id'];
                                        $modelItemColor->quantity=$eachItemColor['color_quantity'];
                                        if($scenario=='add'){
                                            $modelItemColor->created_by=$user_id;
                                            $modelItemColor->created_date_time=date('Y-m-d H:i:s');
                                        }
                                        else{
                                            $modelItemColor->updated_by=$user_id;
                                            $modelItemColor->updated_date_time=date('Y-m-d H:i:s');
                                        }
                                        $modelItemColor->save(false);
                                }
                            }
                            //end code

                        $grand_total += $eachModel->net_amount;

                    }
                   
                    //Allocate Item

                    $modelAllocate = new AllocatedMaterial();

                    $modelAllocate = $modelAllocate->findAll(array('condition'=>'file_id='.$modelOrder->file_id));

                    if(count($modelAllocate) > 0){

                        foreach($modelAllocate as $eachAllocatedItem){

                            AllocatedMaterial::model()->updateByPk($eachAllocatedItem->id, array('allocated_from' => 'O', 'header_id' => $modelOrder->id,'allocation_date' => $modelOrder->order_date,'allocation_end_date' => $modelOrder->delivery_date));

                        }

                    }

                    //End

                    

                    $grand_total += $total_tax_amount;

                    $modelOrder->updateByPk($modelOrder->id, array('grand_total' => $grand_total, 'total_tax_amount' => $total_tax_amount,'net_amount'=>$grand_total-$total_tax_amount));

                    

                     $data = array('status' => "success", "id"=>$modelOrder->id, "file_id"=>$modelOrder->file_id, "message" => "New Order Created");

        

                } else {



                    $error1 = json_decode(CActiveForm::validate($modelOrder, '', false), true);

                    if (!empty($modelOrderItem[0]->product_id))

                        $error2 = json_decode(CActiveForm::validateTabular($modelOrderItem, '', false), true);

                    else

                        $error2[] = "Please add atleast one line item";

                    if($flag_dummy_item==1){

                        $other[] = "Dummy item could not save";

                    }    

                    $error = array_merge_recursive($error1, $error2);

                    foreach($error as $a=>$eacherror){

                        $other[]= $eacherror;

                    }      

                    if ($error != '[]')

                        $error_message =implode(',',$other);

                    $data = array('status' => "error", "message"=>$error_message); 

                }

                header("HTTP/1.1 200 OK");

                header('Content-Type: application/json');

                

            }else{

                header("HTTP/1.1 401 Unauthorized");

                header('Content-Type: application/json');

                $data = array('status' => "failed", "msg"=>"Unauthorized user"); 

            }

        }

	    catch(Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	    }

        echo json_encode($data);

    }

    /**

     * API to get oder details from order id

     * Author  : Ramesh

     * Modified :  28/06/2022

     * url https://cumuluserp.me/alaqsar/index.php?r=apiorder/GetDetailsFromOderId

     * input parameters HTTP_TOKEN,order_id

     */

    public function actionGetDetailsFromOderId() {

        try {

                $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

                $userModel = User::model()->findBytoken($token);

        

                //if ($userModel->id > 0) {

                if (1==1) {



                    $order_id = (int)$_REQUEST['order_id'];

                    $modelOrder = Order::model()->with('customer', 'file')->findByPK($order_id);

                    $list = [];
                    
                    if(!empty($modelOrder)){

                        $modelOrderItem = OrderItem::model()->findAll(array('condition'=>'order_id='.$order_id));

                        $arr_items=[];
                        $arr_item_colors=[];

                        foreach($modelOrderItem as $row){
                            //code to get color list array
                            $modelOrderColorItem = new OrderItemColour();
                            $modelOrderColorItem = $modelOrderColorItem->findAll(array('condition'=>'order_id="'.$order_id.'" AND order_item_id"'.$row->id.'"'  ));
                            if(!empty($modelOrderColorItem)){
                                foreach($modelOrderColorItem as $rowColor){
                                    $arr_item_colors[]=[
                                        "id" => $rowColor->id,
                                        "color_id" => $rowColor->inventory_color_id,
                                        "color_name"=>$rowColor->color_name->color_name,
                                        "color_quantity" => $rowColor->quantity?$rowColor->quantity:0,
                                    ];
                                }
                            }
                            //end code
                            $net_amount =$row->net_amount+$row->tax_vat_amount;

                            $arr_items[] = [

                                "id" => $row->id,

                                "product_id" => $row->product_id,

                                "part_number" => $row->product->part_number,

                                "description" => $row->description,

                                "rate" => $row->rate,

                                "quantity" => $row->quantity,

                                "amount" => $row->amount,

                                "discount" => $row->deduction_amount,

                                "unit_id" => $row->unit_id,

                                "unit_name" => $row->orderunit->name,

                                "net_amount" => $row->net_amount,

                                "tax_vat_amount" =>  $row->tax_vat_amount,

                                "tax_vat_percentage" => $row->tax_vat_percentage,
                                
                                "item_color" => $arr_item_colors,

                            ];

                            

                        }

                        $list[] = [

                            "id" => $modelOrder->id,

                            "file_id" => $modelOrder['file_id'],

                            "company_name" => "AL SHAMSHI",

                            "address_line_1" => "Add 1",

                            "address_line_2" => "Add 2",

                            "company_phone" => "Phone12345",

                            "company_trn" => "XXXX-XXXXX",

                            "customer_name" => $modelOrder['customer']['customer_name'],

                            "order_date" => date("d/m/Y", strtotime($modelOrder['order_date'])),

                            "vat_amount" => $modelOrder['total_tax_amount'],

                            "grand_total" => $modelOrder['grand_total'],

                            "current_process_status"=>$modelOrder['file']['current_process_status'],

                            "completed"=>$modelOrder['completed'],

                            "payment_terms"=>$modelOrder->paymentTerm->payment_terms,

                            "terms_and_conditions"=>$modelOrder->terms_and_conditions,

                            "notes"=>$modelOrder->notes,

                            "items"=>$arr_items

                        ];

                        $data = array('status' => "success", "data"=>$list,"message"=>"Order Details");

                    }else{

                        $data = array('status' => "success", "data"=>$list,"message"=>" Order does not exists!");

                        

                    }

                    header("HTTP/1.1 200 OK");

                    header('Content-Type: application/json');

                }else{

                    header("HTTP/1.1 401 Unauthorized");

                    header('Content-Type: application/json');

                    $data = array('status' => "error", "message"=>"Unauthorized user"); 

                }

        }

	    catch(Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	    }

        echo json_encode($data);

    }
        /**

     * API to order Items list including all items

     * Author  : Nisha

     * Modified :  29/06/2022

     * url https://cumuluserp.me/alaqsar/index.php?r=apiorder/getcategoryorder

     * input parameters HTTP_TOKEN,order_id,type

     */

     public function actionGetCategoryOrder() {
        //try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            //$token = '1-1663831471';
            $from_date = '';
            $user_id = 0;
            $order_id = (int)$_REQUEST['order_id'];
            $modelOrder = Order::model()->with('customer', 'file')->findByPK($order_id);
            $customer_id = (int) $modelOrder->customer_id;
            //code added sarika on 1/11/2022
               $sig_destination='';
               $sig_filename=$modelOrder->signature;
               if($sig_filename!=''){
                   $sig_destination = "uploads/order_signature/" . $sig_filename;
                }
            //end
            
            //code added by mereena on 29/09/2022
            $term ='';
            if(isset($_REQUEST['term'])){
                $term   =   trim($_REQUEST['term']);
            }
            
            //end
            
            
            $storemodel = new Store();
            $model = new MasGeneric();
            
            $current_process_status="O";
           
            //$from_date = '2022-06-19';

            $userModel = User::model()->findBytoken($token);//checking user token
            $userGroups = MasUserGroup::model()->find('id in (' . $userModel->user_group_id . ')');
	        $permissionArray = CJSON::decode($userGroups->permissions);    
            //usergoup permissions
            
            if (array_key_exists('avail_qty_app',$permissionArray)) {
                $permission_avail_qty_app ='Y';
            }else{
                $permission_avail_qty_app ='N';
            }
            
             //if ($userModel->id > 0) {
            if (1==1) {
                       

            $payment_term_type='';
            if($payment_term_id > 0){
                    $payment_term_type = MasPaymentTerm::model()->findByPk($payment_term_id)->payment_type;
            }   
                $condition = "is_Active='Y'";
                $list = array();
                //if($from_date!='') $condition .= " AND created_date_time >= '".$from_date."' OR updated_date_time >= '".$from_date."'";
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition));
                $recordsTotal = $count;
                
                if(!empty($model)) {
                    foreach ($model as $row) { 
                        
                        if($row['generic_image']!='') 
                            $image = "/uploads/category/".$row['generic_image'];
                        else 
                            $image = "/uploads/no-image-icon.png";
                    
                        $condition = "isActive='Y' AND generic_id=".$row['id'].' AND type=1';
                        if(!empty($term)){
                            $condition.=' AND part_number LIKE "%'.$term.'"';
                        }
                        $SQL = 'SELECT * FROM view_all_stock_items WHERE '.$condition.' ORDER BY part_number';
                        $records = Yii::app()->db->createCommand($SQL)->queryAll();
                        $item_list = array();
                        
                        $modelSalesPriceGroupName = new SalesPriceGroupName();
                        $arr_sales_price_group= $modelSalesPriceGroupName->find(array('condition'=>'default_pricing_group="Y"'));
                        
                        
                        if(!empty($records)) {
                            foreach ($records AS $key => $item) {
                                if($item['item_image']!='') 
                                    $item_image = "/uploads/inventoryimages/".$item['item_image'];
                                else 
                                    $item_image = "/uploads/no-image-icon.png";
                                    
                                    
                                
                               
                                
                                if($sales_price=='' || $sales_price==0)
                                  $sales_price = number_format(($item['rate'] * $second_unit_factor),2);
                                  
                                $second_unit_factor = $item['second_unit_factor'];            
                                if((int) $second_unit_factor==0){
                                    $second_unit_factor=1;
                                }
                
                                $modelUnits = UnitOfMeasurement::model()->findAll(array('condition' => 'product_id='.(int) $item['id'],'order'=>'is_secondary_unit'));
                
                                $unit_data=[];
                                if( !empty( $modelUnits ) ){ 
                                    foreach( $modelUnits as $i => $each){
                                        
                                         //code added by mereena on 19/07/2022 for   new pricing concept base on unit id
                                        $pricing_condition = 'product_id='.$item['id'].' AND uom_id='.(int) $each['id'];
                                        if((int) $arr_sales_price_group->id > 0){
                                            $pricing_condition.= ' AND pricing_group_id='.(int) $arr_sales_price_group->id;
                                        }
                                        //echo $pricing_condition;
                                        $arr_price_list = SalesPriceGroup::model()->find(array('condition'=>$pricing_condition));
                                        
                                        //$sales_price = $arr_price_list->sales_price;
                                        $product_tax_amount=0;
                                        if((int) $item['tax_code'] > 0){
                                            $product_tax_amount = (($sales_price * $item['tax_code']) / 100);
                                        }
                                        $customer_last_sales_price=0;
                                         if((int) $item['id'] > 0 && $customer_id > 0){
                                            $SQL_stock_ledger = 'SELECT sales_price FROM erp_stock_ledger WHERE product_id='.(int) $item['id'].' AND customer_vendor_id='.$customer_id.' AND unit_id='.(int) $each['unit_id'].' ORDER BY id DESC LIMIT 0,1';
                                           
                                            $customer_last_sales_price = (float) Yii::app()->db->createCommand($SQL_stock_ledger)->queryScalar();
                                             //echo $SQL_stock_ledger; 
                                        }
                                        
                                        if($customer_last_sales_price > 0){
                                            $sales_price = (float) $customer_last_sales_price;
                                        }
                                        else{
                                            $sales_price = (float) $arr_price_list->sales_price;
                                        }
                                        
                                        
                                       // $unit_price=number_format(($each['factor']*$cash_credit_price),2);
                                        $unit_data[] =[
                                            "id" => $each['id'],
                                            "unit_name" => $each['name'],
                                            "unit_factor" => $each['factor'],
                                            "unit_id" => $each['unit_id'],
                                            "unit_price" => (float) $sales_price,
                                            "tax_amount" => round($product_tax_amount,2)
                                        ];
                                    }
                                }
                                
                                $arr_secondary_unit = UnitOfMeasurement::getSecondaryBaseUnitWithName((int) $item['id']);
                                
                                
                                //code added by mereena on 07/09/2022 to get default sales unit_id
                                $modelStore = new Store();
                                $modelStore = $modelStore->findByPk((int) $item['id']);
                                $default_sales_unit_id = (int) $modelStore->default_sales_unit_id;
                                //end
                                
                                
                                if($default_sales_unit_id > 0){
                                     $unit_id = $default_sales_unit_id;
                                     $unit_name = $modelStore->salesunit->name;
                                }//end
                                else{
                                    if($from=='inventory'){
                                        $unit_name = $item['unit'];
                                        $unit_id = $item['unit_id'];
                                    }
                                    else{
                                        $unit_name = $arr_secondary_unit->name;
                                        $unit_id = $arr_secondary_unit->unit_id;
                                        
                                    }
                                }
                                
                                 //echo "unit_id=".$unit_id."<br>";
                                   //echo "unit_name=".$unit_name."<br>";
                
                                $delivery_date = '0000-00-00';
                                if(!empty($modelOrder)){
                                    
                                    $modelMasterFile = new MasterFile();
                                    $current_process_status = $modelOrder->file->current_process_status;
                                    $deduction_amount=0;
                                    $aval_quantity =0;
                                    $query = 'SELECT quantity FROM view_all_stock_items WHERE id='.(int) $item['id'];
                                    $aval_quantity = Yii::app()->db->createCommand($query)->queryScalar();
                                    $modelOrderItem = OrderItem::model()->find(array('condition'=>'order_id='.$order_id.' and product_id='.(int) $item['id']));
                                    if($modelOrder->delivery_date!='' && $modelOrder->delivery_date!='0000-00-00'){
                                        $delivery_date = date('d/m/Y',strtotime($modelOrder->delivery_date));
                                    }
                                    
                                  /*  if($item['id'] == 11){
                                        echo '<pre>';
                                        print_r($modelOrderItem);
                                    }*/
                                         $item_color_data=[];
                                        if(!empty($modelOrderItem)){
                                            $order_quantity = 0;
                                            $unit_id = $modelOrderItem->unit_id;
                                            $unit_name = $modelOrderItem->orderunit->name;
                                            $quantity = $modelOrderItem->quantity;$pricing_condition = 'product_id='.$item['id'].' AND uom_id='.(int) $unit_id;
                                            $deduction_amount = $modelOrderItem->deduction_amount;
                                            $selected_color = $modelOrderItem->inventory_item_color_id;
                                          //code added sarika on 31/10/2022
                                        $arr_item_colors = OrderItemColour::model()->findAll(array('condition'=>'order_id="'.$order_id.'" AND order_item_id="'.$modelOrderItem->id.'"' ));
                                         
                                        if( !empty($arr_item_colors) ){ 
                                            foreach( $arr_item_colors as  $eachItemColors){        
                                                $item_color_data[] =[
                                                    
                                                    "color_id" => $eachItemColors->inventory_color_id,
                                                    "color_quantity" => (int)$eachItemColors->quantity,
                                                    "color_name" => $eachItemColors->color_name->color_name,
                                                ];
                                            }

                                        }
                                
                                        //end code
                                           
                                        }
                                        else{
                                           $quantity= 0; 
                                           $pricing_condition = 'product_id='.$item['id'].' AND mas_unit_id='.(int) $item['unit_id'];
                                           $selected_color = '';
                                        }
                                        
                                          


                                    }
                                    
                                     //code added by mereena on 19/07/2022 for   new pricing concept base on unit id
                                //$pricing_condition = 'product_id='.$item['id'].' AND uom_id='.(int) $unit_id;
                                if((int) $arr_sales_price_group->id > 0){
                                    $pricing_condition.= ' AND pricing_group_id='.(int) $arr_sales_price_group->id;
                                }
                                //echo $pricing_condition;
                                $arr_price_list = SalesPriceGroup::model()->find(array('condition'=>$pricing_condition));
                                
                                //$selling_price = $arr_price_list->sales_price;
                                
                               
                                //end
                                
                                
                              //code added by mereena on 14/09/2022
                              $customer_last_sales_price=0;
                                if((int) $item['id'] > 0 && $customer_id > 0){
                                    $SQL_stock_ledger = 'SELECT sales_price FROM erp_stock_ledger WHERE product_id='.(int) $item['id'].' AND customer_vendor_id='.$customer_id.' AND unit_id='.(int) $unit_id.' ORDER BY id DESC LIMIT 0,1';
                                   
                                    $customer_last_sales_price = (float) Yii::app()->db->createCommand($SQL_stock_ledger)->queryScalar();
                                     //echo $SQL_stock_ledger; 
                                }
                                
                                if($customer_last_sales_price > 0){
                                    $selling_price = (float) $customer_last_sales_price;
                                }
                                else{
                                    $selling_price = (float) $arr_price_list->sales_price;
                                }
                                
                                 $item_tax_amount=0;
                                if((int) $item['tax_code'] > 0){
                                    $item_tax_amount = round((($selling_price * $item['tax_code']) / 100),2);
                                }
                                        
                              
                              //end
                              
                             /* $color_data=[];
                                if($modelStore->item_colours!=''){
                                    $arr_colors = MasInvItemColor::model()->findAll(array('condition' => 'id IN('.$modelStore->item_colours.')'));
                                    if( !empty( $arr_colors ) ){ 
                                        foreach( $arr_colors as $i => $eachColors){        
                                            $color_data[] =[
                                                "color_id" => $eachColors['id'],
                                                "color_name" => $eachColors['color_name'],
                                            ];
                                        }
                                    }
                                }*/
                               

                                        
                                $item_list[] = [
                                    "id" => $item['id'],
                                    "part_number" => $item['part_number'],
                                    "description" => $item['description'],
                                    "brand_id" => $item['brand_id'],
                                    "brand_name" => $item['brand_name'],
                                    "generic_id" => $item['generic_id'],
                                    "generic_name" => $item['generic_name'],
                                    //"unit_id" => $row['unit_id,
                                    //"unit_name" => $row['unit->unit_name,
                                    //"quantity"=>$item['quantity'],
                                    "quantity"=> (int)$quantity,
                                    "unit_name" =>$unit_name ?$unit_name :$item['unit'],
                                    "unit_id" => $unit_id ? $unit_id : $item['unit_id'],
                                    "available_quantity" =>(int)$aval_quantity,
                                    "secondary_quantity"=>'',
                                    "secondary_unit_id" => $arr_secondary_unit->unit_id,
                                    "secondary_unit_name" => $arr_secondary_unit->name,
                                    "tax_code" => $item['tax_code'],
                                    "tax_amount" => $item_tax_amount,
                                    "active" =>  $item['isActive'],
                                    "rate"=> $order_rate ? number_format($order_rate,2):number_format(($item['rate'] * $second_unit_factor),2),
                                    //"rate" => number_format(($cash_credit_price * $second_unit_factor),2),
                                    "alias_name"=>$item['alias_name'],
                                    "selling_price" => (float) $selling_price,
                                    "location" => $locations_data,
                                    "arr_units"=>$unit_data,
                                    "item_image"=>$item_image,
                                    "suggestion"=>false,
                                    "permission_avail_qty_app" =>$permission_avail_qty_app,
                                    "deduction_amount"=>(float)$deduction_amount,
                                    // "arr_colors" => $color_data,
                                    'selected_color'=>$selected_color,
                                 
                                    "arr_colors" => $item_color_data

                                ];

                            }

                            
                        }
                        if(!empty($item_list)){
                            $list[] = array("_id"=>$row['id'],"title"=>$row['generic_name'],"description"=>$row['generic_description'],"image"=>$image,"itemslist"=>$item_list);
                        }
                    }
                    $orderlist[] = [

                                "id" => $modelOrder->id,

                                "signature"=>$sig_destination,

                                "file_id" => $modelOrder['file_id'],

                                "company_name" => "AL SHAMSHI",

                                "address_line_1" => "Add 1",

                                "address_line_2" => "Add 2",

                                "company_phone" => "Phone12345",

                                "company_trn" => "XXXX-XXXXX",

                                "customer_id" => $modelOrder['customer_id'],

                                "customer_name" => $modelOrder['customer']['customer_name'],

                                "customer_email" => $modelOrder['customer']['customer_email_id'],

                                "customer_phone" => $modelOrder['customer']['customer_phone_no'],

                                "customer_location" => $modelOrder['customer']['customer_location'],

                                "order_date" => date("d/m/Y", strtotime($modelOrder['order_date'])),
                                
                                "delivery_date" => $delivery_date,

                                "vat_amount" => $modelOrder['total_tax_amount'],

                                "grand_total" => $modelOrder['grand_total'],

                                "current_process_status"=>$modelOrder['file']['current_process_status'],

                                "completed"=>$modelOrder['completed'],

                                "payment_terms"=>$modelOrder->paymentTerm->payment_terms,

                                "payment_term_id" => $modelOrder->paymentTerm->id,

                                "terms_and_conditions"=>$modelOrder->terms_and_conditions,

                                "notes"=>$modelOrder->notes,


                        ];
                }
                $data = array('status' => "success", "count"=>$recordsTotal,"order"=>$orderlist ,"data"=>$list,"message"=>$recordsTotal." Records",'current_process_status'=>$current_process_status);
                header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $data = array('status' => "error", "message"=>"Unauthorized user"); 
            }
        //}
       // catch(Exception $e) {
        //    header("HTTP/1.1 404 not found");
        //    header('Content-Type: application/json');
        //    $data = array('status' => "error", "message"=>"Unexpected Server error"); 
       // }
        echo json_encode($data);

    }

    /* added by nisha 01-07-2022 */

    public function actionCancelOrder(){ 

        try {

            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

            $userModel = User::model()->findBytoken($token);


            if (1==1) {

                $id = $_REQUEST['id'];

                error_log('order');


                //$user_id   = (int)$userModel->id;

                $modelOrder = new Order;

                $other = array();

                $order_id = (int) $id;

                if ((int)$order_id > 0) {

                    $modelOrder = $modelOrder->findByPK($order_id);

                    $modelOrder->updateByPk($modelOrder->id, array('completed' => "C", 'updated_by' => $user_id,'updated_datetime'=>date('Y-m-d H:i:s')));
                
                } 

                    // inserting to audit log

                    AuditLog::saveAuditLogs(

                        'ORDERS',

                        $user_id,

                        $audit_type,

                        " with No: - {$modelOrder->id}  "

                    );

                    // end audit log 

                    

                     $data = array('status' => "success", "id"=>$modelOrder->id, "file_id"=>$modelOrder->file_id, "message" => "Order Cancelled");


                header("HTTP/1.1 200 OK");

                header('Content-Type: application/json');

                

            }else{

                header("HTTP/1.1 401 Unauthorized");

                header('Content-Type: application/json');

                $data = array('status' => "failed", "msg"=>"Unauthorized user"); 

            }

        }

        catch(Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message"=>"Unexpected Server error"); 

        }

        echo json_encode($data);

    }
 
    /**

     * API to order report in PDF

     * Author  : Ramesh

     * Modified :  28/06/2022

     * url https://cumuluserp.me/alaqsar/index.php?r=apiorder/PrintOrderReportPDF

     * input parameters HTTP_TOKEN,order_id,type

     */

    public function actionPrintOrderReportPDF() {

        //try {

                $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

                $userModel = User::model()->findBytoken($token);

                //if ($userModel->id > 0) {

                if (1==1) {

                    $model = new Order();

                    $order_id = $_REQUEST['order_id'];

                    $type = $_REQUEST['type'];

                    //$company_id=$userModel->company_id;

                    $company_id=1;

                

                    $pdf_name = "";

                    if($order_id > 0){

                        $model = $model->findByPk($order_id);

                        if($type=='A5'){

                            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A5');

                            $page_name = "order_list_individual_A5";

                            $pdf_name = "Order_".$order_id."_".$model->customer->customer_name."_A5".'.pdf';

                        }

                        else{

                            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

                            $page_name = "order_list_individual";

                            $pdf_name = "Order_".$order_id."_".$model->customer->customer_name."_A4".'.pdf';

                        }

                    }

                

                    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

                    $mPDF1->WriteHTML($stylesheet, 1);

                    $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.'.$page_name, array('model' => $model, 'id' => $order_id,'company_id'=>$company_id, 'title' => $title,'mpdf'=>$mPDF1), true));

                    $mPDF1->Output('uploads/apppdf/'.$pdf_name, 'F');

                

                   $data = array('status' => "success", "file_path"=>"/uploads/apppdf/".$pdf_name,"file_name"=>$pdf_name); 

                   header("HTTP/1.1 200 OK");

                   header('Content-Type: application/json');

                

            }

            else{

                header("HTTP/1.1 401 Unauthorized");

                header('Content-Type: application/json');

                $data = array('status' => "error", "message"=>"Unauthorized user"); 

            }

        //}

	    //catch(Exception $e) {

        //    header("HTTP/1.1 404 not found");

        //    header('Content-Type: application/json');

        //    $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	    //}

        echo json_encode($data);

    }

    

    public function actionUnlinkPDF(){

        

        /*$token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

        //$token = "3-1637919046";

        $userModel = User::model()->findBytoken($token);

        if ($userModel->id > 0) {*/

            $id = $_REQUEST['id'];

            $file_name = $_REQUEST['file_name'];

            $path = Yii::getPathOfAlias('webroot')."/uploads/apppdf/".$file_name;

            if(file_exists($path)){

                unlink($path);

            }

            $data = array('status' => "success");

        /*}

        else{

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 

        }*/

        echo json_encode($data);

        

    }
    //code signature added by nisha on 14-10-2022
     public function actionUploadSignature() {
        $responseData = ["status" => false];
        $today = date("Y-m-d");
        $filename = $today . "_" . rand(0, getrandmax()) . "_" . basename($_FILES["file"]["name"]);
        $destination = "uploads/order_signature/" . $filename;
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $destination)) {
            $responseData = ["status" =>"success", "filename" => $filename];
        } else {
            $responseData = ["status" => "failed"];    
        }
        echo json_encode($responseData);
    }
//code added sarika on 1/11/2022
    public function actionProductClass(){
        $condition = "isActive='Y'";
        $ModelProductClass = ProductClass::model()->findAll(array('condition' =>$condition,'order' => 'id desc'));
        if(!empty($ModelProductClass)){
            foreach ($ModelProductClass as $i => $each) {
                    $data[] = [
                        "id" => $each->id,
                        "name"=>$each->product_class,
                    ];
             }
            $dt = array('status' => "success",'data'=>$data);
        }
        else{
            $data=[];
            $dt = array('status' => "success",'data'=>$data);
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        echo json_encode($dt);
       

    }
    /*public function actionGetProductClassList(){
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $brand_id =trim($variables['brand_id']);
        $condition = "isActive='Y' AND id='".$brand_id."' ";
        $ModelProductClass = ProductClass::model()->findAll(array('condition' =>$condition));
        if(!empty($ModelProductClass)){
            foreach ($ModelProductClass as $i => $each) {
                    $data[] = [
                        "id" => $each->id,
                        "name"=>$each->product_class,
                    ];
             }
        }
        else{
            $data=[];
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        echo json_encode($data);
       

    }*/

//end code



}

