<?php

class ApimasterController extends Controller {



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array("GetInvoiceTypeList","GetPaymentTermsList","GetFragranceList" ),

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    } 
  
 
      public function actionGetInvoiceTypeList() {
             $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $condition = "isActive='Y' AND  type = 'SR'";
                $models = MasSalesGroup::model()->findAll([
                    "condition" => $condition,
                    "order" => "group_name desc"
                ]);
                $data = [];
                foreach ($models as $key => $row) {
                    $data[] = [
                        "id" => $row->id,
                        "group_name" => $row->group_name 
                    ];
                }
                $response = array('status' => "success", "message" => "success", "data" => $data);
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
            echo json_encode($response);
        }
        
      public function actionGetPaymentTermsList() {
             $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $condition = "isActive='Y' ";
                $models = MasPaymentTerm::model()->findAll([
                    "condition" => $condition,
                    "order" => "payment_terms desc"
                ]);
                $data = [];
                foreach ($models as $key => $row) {
                    $data[] = [
                        "id" => $row->id,
                        "payment_terms" => $row->payment_terms 
                    ];
                }
                $response = array('status' => "success", "message" => "success", "data" => $data);
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
            echo json_encode($response);
        }
        
        public function actionGetFragranceList() {
             $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $condition = "isActive='Y' ";
                 if (isset($data_array['term']) && !empty($data_array['term'])) {
                    $condition .= " AND (name LIKE '%{$data_array['term']}%') ";
                }
                $models = MasFragrance::model()->findAll([
                    "condition" => $condition,
                    "order" => "name desc"
                ]);
                $data = [];
                foreach ($models as $key => $row) {
                    $data[] = [
                        "id" => $row->id,
                        "name" => $row->name 
                    ];
                }
                $response = array('status' => "success", "message" => "success", "data" => $data);
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
            echo json_encode($response);
        }
        

}

