<?php

class ApimachineController extends Controller {



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array("GetMachineIssualList","SaveMachineIssual","SaveWarehouseReturn","SavemachineReturn","GetCustomerDetails","GetOilToBeReturnDetails",
                                    "GetCustomerOutletLocations","GetCustomerOrderItems","GetMachineBySerialNo","GetCustomerReturnMachines","GetToBeReturnedMachinesList",
                                    "GetOilReturnDetails","GetReturnMachineBySerialNo","GetReturnList","GetReturnedMachinesList","GetReturnedOilList","ReturnMachineToUsedWarehouse",
                "GetApprovalList", "GetApprovalView", "SaveApproval", "UploadSignature"),

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    public function beforeAction($action) {

         $this->ChangeDB();
        return parent::beforeAction($action);

    }
 
    public function actionGetMachineIssualList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $term = $data_array['term'];
            $condition = " t.issue_type = 'MH' AND items.is_issued = 'Y' ";
             if (!empty($term)) {
                $condition .= " AND (items.serial_no LIKE '%{$term}%') ";
            }
            $models = InventoryGoodsIssue::model()->with('customer', 'items','outlet','owner')->findAll([
                "condition" => $condition,
                "order" => "t.id DESC"
            ]);
            $data = [];
            foreach ($models as $key => $row) {
                $sales_group_id = Order::model()->findByPk($row->production_order_id)->sales_group_id;
                $data[] = [
                    "id" => $row->id,
                    "customer_id" => $row->customer_id,
                    "customer_name" => isset($row->customer) ? $row->customer->customer_name : '',
                    "lead_owner_id" => $row->lead_owner_id,
                    "lead_owner" => isset($row->lead_owner_id) ? $row->owner->first_name . ' ' . $row->owner->last_name : '',
                    "outlet" => $row->outlet_id,
                    "outlet_id" =>  isset($row->outlet_id) ? $row->outlet->outlet_location : '',
                    "sales_group_id" => $sales_group_id,
                    "sales_group" => isset($sales_group_id) ? MasSalesGroup::model()->findByPk($sales_group_id)->group_name: '',
                    ];
            }
            $response = array('status' => "success", "message" => "success", "data" => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);
    }
    
    
     public function actionSaveMachineIssual()
          {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $model = new InventoryGoodsIssue(); 
                $id = $data_array['id'];
                 $isUpdate = $id > 0;
                if ($isUpdate) {
                    $model = InventoryGoodsIssue::model()->findByPk($id);
                    if (!$model) {
                    echo CJSON::encode(['status' => 'error', 'message' => 'Record not found']);
                    Yii::app()->end();
                }
                     $model->updated_by = $data_array['created_by'];
                    $model->updated_date_time = date('Y-m-d H:i:s');
                }else{
                    $model->created_by = $data_array['created_by'];
                    $model->created_date_time = date('Y-m-d H:i:s');
                }
                // $model->attributes = $data_array;
                $model->goods_issue_date = date('Y-m-d');
                $model->issue_type = 'MH';
                $model->customer_id = $data_array['customer_id'];
                $model->outlet_id = $data_array['outlet_id'];
                $model->production_order_id  = $data_array['file_id'];
                $model->lead_owner_id = $data_array['lead_owner_id'];
                $model->warehouse_id = $data_array['warehouse_id'];
                $model->file_id = $data_array['file_id']; 
                $model->reference = 'MACHINE_ISSUE';
                if (empty($model->lead_owner_id)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'Salesman cannot be blank'
                    ]);
                    Yii::app()->end();
                }
                $itemRows = $data_array['items'] ?? [];
                if (empty($itemRows)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'No machine items found.'
                    ]);
                    Yii::app()->end();
                }
                $itemModels = [];
                $stockLedgers = [];
                
                $invoiceProductIds = [];
                
                 foreach ($itemRows as $i => $itemData) {
                        $machine_id = (int) ($itemData['product_id'] ?? 0);
                        $serial_no_input = $itemData['serial_no'] ?? null;
                        $modelStore = $machine_id ? Store::model()->findByPk($machine_id) : null;

                        if ($invoiceId && !in_array($machine_id, $invoiceProductIds)) {
                            echo CJSON::encode([
                                'status' => 'error',
                                'message' => "Product at row " . ($i + 1) . " does not match any item from the selected invoice. Please select the correct product."
                            ]);
                            Yii::app()->end();
                        }
                        if (!$modelStore) {
                            echo CJSON::encode([
                                'status' => 'error',
                                'message' => "Invalid product selected at row " . ($i + 1)
                            ]); 
                            Yii::app()->end();
                        } 

                       
                        //Yii::app()->end();
                         if ((int) $itemData['location_id'] <= 0) {
                            echo CJSON::encode([
                                'status' => 'error',
                                'message' => "Please enter location for row " . ($i + 1)
                            ]); 
                            Yii::app()->end();
                        }

                        // stock_ledger_id is passed as serial_no in the submitted data
                        $stock_ledger_id =  $serial_no_input;
                        $sql = 'SELECT serial_no,id,unit_id,warehouse_id FROM erp_stock_ledger L where L.serial_no="' . $serial_no_input . '"';
                        //$sql = 'SELECT serial_no,id,unit_id,warehouse_id FROM erp_stock_ledger L where L.id="' . $stock_ledger_id . '"';
                        $modelStockLedger = Yii::app()->db->createCommand($sql)->queryRow();
                        if (!$modelStockLedger) {
                            $valid = false;
                            $other[] = "Invalid stock ledger reference for item " . ($i + 1);
                            // push placeholder so indexes remain consistent but skip further processing for this row
                            $stockLedgers[] = null;
                            $itemModels[] = null; 
                        }

                        $modelUOM = UnitOfMeasurement::model()->findByPk((int) $modelStockLedger['unit_id']);
                        $serial_no = $modelStockLedger['serial_no'];
                        if (empty($serial_no)) {
                            $valid = false;
                            $other[] = "Serial number missing for item " . ($i + 1);
                        }
                        // Either load existing or create new item
                        if ($isUpdate) {
                            $modelIssueItem = InventoryGoodsIssueItem::model()->find(
                                'header_id=:hid AND product_id=:mid',
                                [':hid' => $model->id, ':mid' => $machine_id]
                            );
                            if (!$modelIssueItem)
                                $modelIssueItem = new InventoryGoodsIssueItem();
                            $modelIssueItem->updated_by = $data_array['created_by'];
                            $modelIssueItem->updated_date_time = date('Y-m-d H:i:s');
                        } else {
                            $modelIssueItem = new InventoryGoodsIssueItem();
                            $modelIssueItem->created_by = $data_array['created_by'];
                            $modelIssueItem->created_date_time = date('Y-m-d H:i:s');
                        }

                        $modelIssueItem->product_id = $machine_id;
                        $modelIssueItem->product_name = $modelStore ? $modelStore->part_number : '';
                        $modelIssueItem->unit = (int) $modelStockLedger['unit_id'];
                        $modelIssueItem->description = $itemData['description'] ? $itemData['description']: ($modelStore ? $modelStore->description : '');
                        $modelIssueItem->location_id = $itemData['location_id'] ?? null;
                        $modelIssueItem->picked_qty = 1;
                        $modelIssueItem->rate = 0;  
                        $modelIssueItem->serial_no = $serial_no;
                        $customer = Customer::model()->findByPk($model->customer_id);
                        $no_of_days = 30;
                        if ($customer && !empty($customer->no_of_days) && $customer->no_of_days > 0) {
                            $no_of_days = (int) $customer->no_of_days;
                        }
                        $lastService = date('Y-m-d');
                        $nextService = date('Y-m-d', strtotime("+{$no_of_days} days", strtotime($lastService)));
                        $valid = $modelIssueItem->validate();
                        $itemModels[] = $modelIssueItem;
                        $stockLedgers[] = $modelStockLedger; 
                        $model->warehouse_id = $modelStockLedger['warehouse_id'];
                    }
                     $valid = $model->validate();
                     
                ///////////// 
                if ($valid) {
                    if (!$model->save(false)) {
                         $response = ["status" => "error", "message" =>$model->getErrors()];
                        Yii::app()->end();
                    }
                     foreach ($itemModels as $index => $itemModel) {
                         
                        $itemModel->goods_issue_id = $model->id;
                        $ledger = $stockLedgers[$index]; 
                        $uom = UnitOfMeasurement::model()->findByPk((int) $ledger['unit_id']); 
                        $existingLedgerId = (int) $ledger['id'];
                        $customerNameForRemarks = ($model->customer && !empty($model->customer->customer_name)) ? $model->customer->customer_name : '';
                        $remarksUpdate = 'MACHINE_ISSUED' . '/' . $model->id . '/' . $customerNameForRemarks;
                        // Update original ledger entry
                        StockLedger::model()->updateByPk($existingLedgerId, [
                            'customer_vendor_id' => $model->customer_id,
                            'customer_vendor_name' => $customerNameForRemarks,
                            'customer_location_id' => $model->outlet_id,
                            'remarks' => $remarksUpdate,
                            'available_status' => 'U'
                        ]);
                        /************** STOCK LEDGER (OUT) ENTRY FOR MACHINE_ISSUE **************/
                        $existingLedger = (object) $ledger; // cast for ->property access convenience
                        $remarks = 'MACHINE_ISSUED/' . $model->id . '/' . $customerNameForRemarks;
                        $warehouse = $existingLedger->warehouse_id;
                        // Get warehouse name
                        $warehouseName = '';
                        $warehouseModel = MasInventoryWarehouse::model()->findByPk($warehouse);
                        if ($warehouseModel) {
                            $warehouseName = $warehouseModel->warehouse_name;
                        }
                     $stock = new StockLedger();
                        $stock->file_id = $model->file_id;
                        $stock->header_id = $model->id;
                        $stock->header_item_id = $itemModel->id;
                        $stock->customer_vendor_id = $model->customer_id;
                        $stock->customer_vendor_name = $customerNameForRemarks;
                        $stock->product_id = $itemModel->product_id;
                        $stock->product_name = $itemModel->product_name;
                        $stock->product_description = $itemModel->description;
                        // Try to pull brand info from store if available
                        $storeModel = Store::model()->findByPk($itemModel->product_id);
                        $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                        $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                        $stock->warehouse_id = $warehouse;
                        $stock->warehouse_name = $warehouseName;
                        // Default rack/bin
                        $rack = new MasInvRack();
                        $stock->rack_id = $rack->getDefaultRackId();
                        $stock->rack_name = $rack->getRackName($stock->rack_id);
                        $bin = new MasInvBin();
                        $stock->bin_id = $bin->getDefaultBinId();
                        $stock->bin_name = $bin->getBinName($stock->bin_id);
                        // UOM and stock details
                        $stock->unit_id = $existingLedger->unit_id;
                        $uomModel = UnitOfMeasurement::model()->findByPk($existingLedger->unit_id);
                        $stock->unit_name = $uomModel ? $uomModel->name : '';
                        $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                        $stock->quantity = -1;
                        $stock->available_status = 'U'; // Mark unavailable as item is issued
                        $stock->batch_no = '';
                        $stock->serial_no = $existingLedger->serial_no;
                        $stock->cost_price = 0;
                        $stock->transaction_date = date('Y-m-d');
                        $stock->transaction_from = "MACHINE_ISSUE";
                        $stock->transaction_type = "OUT";
                        $stock->master_stock_ledger_id = $existingLedger->id;
                        $stock->stock_updated = 'Y';
                        $stock->created_by = Yii::app()->user->id;
                        $stock->created_date = date('Y-m-d H:i:s');
                        $stock->remarks = $remarks;
                        $stock->lead_owner_id = $model->lead_owner_id;
                        if (!$stock->save(false)) {
                            Yii::log("Failed to save stock ledger (OUT) for issued machine ID {$itemModel->product_id}", CLogger::LEVEL_ERROR);
                            Yii::app()->end();
                        }
                        // Now link the newly created stock ledger id to the item and save the item
                        //$itemModel->stock_ledger_id = $stock->id;
                        if (!$itemModel->save(false)) {
                             $response = ["status" => "error", "message" => "error"];
                        }
                    }
                     
                     $currentTime = date('H:i:s');
                    /************** CREATE REPAIR REQUEST **************/
                    $modelRequest = new SaleRepairRequest();
                    $modelRequest->type_id = 2;
                    $modelRequest->customer_id = $model->customer_id;
                    $modelRequest->customer_shipping_id = $model->outlet_id;
                    $modelRequest->service_id = MasServices::getIdByCode('S2');
                    $modelRequest->request_date = date('Y-m-d');
                    $modelRequest->schedule_date = date('Y-m-d');
                    $modelRequest->start_time = date('Y-m-d H:i:s');
                    $modelRequest->end_time = date('Y-m-d H:i:s');
                    $modelRequest->status_id = 2;
                    $modelRequest->completed_date = date('Y-m-d');
                    $modelRequest->assigned_id = $model->lead_owner_id;
                    $modelRequest->submit_invoice = 'Y';
                    $modelRequest->technician_status = 'Y';
                    $modelRequest->is_Visited = 'Y';
                    $modelRequest->schedule_status = 'C';
                    $modelRequest->request_from = 'MI';
                    $modelRequest->created_by = $data_array['created_by'];
                    $modelRequest->created_date_time = date('Y-m-d H:i:s');
                    $modelRequest->save(false);
                     /************** CREATE REPAIR REQUEST ITEMS **************/
                    foreach ($itemModels as $itemModel) {
                        // skip invalid rows
                        if (!$itemModel)
                            Yii::app()->end();
                        $repairItem = new SalesRepairRequestItem();
                        $repairItem->machine_id = $itemModel->product_id;
                        $repairItem->serial_no = $itemModel->serial_no;
                        $repairItem->issue_item_id = $itemModel->id;
                        $repairItem->location_id = $itemModel->location_id;
                        $repairItem->status_id = 2;
                        $repairItem->service_id = MasServices::getIdByCode('S2');
                        $repairItem->header_id = $modelRequest->id;
                        $repairItem->activity_changed = 'N'; 
                        $repairItem->save(false);
                    }
                    $response = ["status" => "success", "message" => "success", "id" => $model->id];
                } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                // Merge CActiveForm errors with manual $other errors; make sure both are arrays
                $errorsMerged = array_merge_recursive((array) $error1, (array) $other);
                    $response = ["status" => "error", "message" => $errorsMerged];
                }
                
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
            echo json_encode($response);
        }
    public function actionSaveMachineReturn()
          {
            $valid = true;
            $other = [];
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $model = new InventoryGoodsReceipt();
                $customer_name = $data_array['customer_name'];
                $model_id = $data_array['id'];
                $customer_id = (int) $data_array['customer_id'];
                $lead_owner_ids = (array) ($data_array['lead_owner_id'] ?? []);
                $lead_owner_id = (int) ($data_array['lead_owner_id'] ?? '');
                $outlet_id = $data_array['outlet_id'];
                $selectedItems = $data_array['items'] ?? [];
                 
                if (!$customer_id) {
                   echo CJSON::encode(['status' => 'error', 'message' => 'No customer selected for return.']);
                    Yii::app()->end();
                }
                if (!$lead_owner_id) {
                   echo CJSON::encode(['status' => 'error', 'message' => 'No user selected for return.']);
                    Yii::app()->end();
                }
                if (!$outlet_id) {
                   echo CJSON::encode(['status' => 'error', 'message' => 'No outlet selected for return.']);
                   Yii::app()->end();
                }
 
                $warehouse = MasInventoryWarehouse::model()->getWarehouseIdByCode('RUW');
                $warehouseName = MasInventoryWarehouse::model()->getWarehouseName($warehouse);
                if (!$warehouse) {
                    echo CJSON::encode(['status' => 'error', 'message' => 'Return warehouse not configured (RUW missing).']);
                    Yii::app()->end();
                }
                $rack = new MasInvRack();
                $bin = new MasInvBin();
                $defaultRackId = $rack->getDefaultRackId();
                $defaultBinId = $bin->getDefaultBinId();


                $modelReceipt = new InventoryGoodsReceipt();
                $modelReceipt->goods_receipt_date = date('Y-m-d');
                $modelReceipt->customer_id = $customer_id;
                $modelReceipt->warehouse_id = $warehouse;
                $modelReceipt->outlet_id = $outlet_id;
                $modelReceipt->reference = 'MACHINE_RETURN';
                $modelReceipt->receipt_type = 'MH';
                $modelReceipt->reference_id = $data_array['reference_id'];
                $modelReceipt->lead_owner_id = $lead_owner_id;
                $modelReceipt->created_by = 0;//
                $modelReceipt->created_date_time = date('Y-m-d H:i:s');
                if (!$modelReceipt->save(false)) {
                     echo CJSON::encode(['status' => 'error', 'message' => $modelReceipt->getErrors()]);
                     Yii::app()->end();
                }
                $msg_item="";
                foreach ($selectedItems as $id => $item) {
                     $modelReceiptItem = new InventoryGoodsReceiptItem();
                    // if (empty($item['selected'])) {
                    //     continue;
                    // }
                    $item_id = $item['item_id'];
                    $machineModel = InventoryGoodsIssueItem::model()->findByPk($item_id);
                    if (!$machineModel) {
                        echo CJSON::encode(['status' => 'error', 'message' => "Machine record not found for item ID {$id}."]);
                        Yii::app()->end();
                    }
                    $machineModel->updateByPk($machineModel->id, [
                        'is_issued' => 'N',
                        'updated_by' => 0,//
                        'updated_date_time' => date('Y-m-d H:i:s'),
                    ]);
                    
                    $SQL = 'SELECT id FROM `erp_stock_ledger` WHERE serial_no = "' . $machineModel->serial_no .'" ORDER BY master_stock_ledger_id DESC LIMIT 1 ';
                    $stock_ledger_id = Yii::app()->db->createCommand($SQL)->queryScalar();
                    $existingLedger = StockLedger::model()->findByPk($stock_ledger_id);
                    if (!$existingLedger) {
                        echo CJSON::encode(['status' => 'error', 'message' => "No stock ledger found for machine <b>{$machineModel->serial_no}</b>."]);
                        Yii::app()->end();
                    }
                    $remarks = trim($item['remarks']) ? trim($item['remarks']) : 'MACHINE_RETURN/'.$machineModel->goods_issue_id.'/'.$existingLedger->customer_vendor_name;
                    $return_lead_owner_id = (int) ($item['return_lead_owner_id'] ?? 0);
                    if (empty($return_lead_owner_id) && !empty($lead_owner_ids)) {
                        $return_lead_owner_id = reset($lead_owner_ids);
                    }
                    $modelReceiptItem->product_id = $machineModel->product_id;
                    $modelReceiptItem->product_name = $machineModel->product_name;
                    $modelReceiptItem->description = $machineModel->description;
                    $modelReceiptItem->serial_no = $machineModel->serial_no;
                    $modelReceiptItem->unit = $machineModel->unit;
                    $modelReceiptItem->rate = $machineModel->rate;
                    $modelReceiptItem->picked_qty = $machineModel->picked_qty;
                    $modelReceiptItem->location_id = $machineModel->location_id;
                    $modelReceiptItem->goods_receipt_id = $modelReceipt->id;
                    $modelReceiptItem->created_by = Yii::app()->user->id;
                    $modelReceiptItem->created_date_time = date('Y-m-d H:i:s');
                    $msg_item .= $machineModel->product_name.',';
                    if (!$modelReceiptItem->save(false)) {
                           echo CJSON::encode(['status' => 'error', 'message' => $modelReceiptItem->getErrors()]);
                           Yii::app()->end();
                    }
                    // Create stock ledger entry (IN - Return)
                    $stock = new StockLedger();
                    $stock->attributes = [
                        'file_id' => $modelReceipt->id,
                        'header_id' => $modelReceipt->id,
                        'header_item_id' => $modelReceiptItem->id,
                        'customer_vendor_id' => $existingLedger->customer_vendor_id,
                        'customer_vendor_name' => $existingLedger->customer_vendor_name,
                        'product_id' => $machineModel->product_id,
                        'product_name' => $machineModel->product_name,
                        'product_description' => $machineModel->description,
                        'brand_id' => $existingLedger->brand_id,
                        'brand_name' => $existingLedger->brand_name,
                        'warehouse_id' => $warehouse,
                        'warehouse_name' => $warehouseName,
                        'rack_id' => $defaultRackId,
                        'rack_name' => $rack->getRackName($defaultRackId),
                        'bin_id' => $defaultBinId,
                        'bin_name' => $bin->getBinName($defaultBinId),
                        'unit_id' => $existingLedger->unit_id,
                        'unit_name' => $existingLedger->unit_name,
                        'unit_factor' => $existingLedger->unit_factor,
                        'quantity' => 1,
                        'available_status' => 'A',
                        'batch_no' => $existingLedger->batch_no,
                        'serial_no' => $machineModel->serial_no,
                        'cost_price' => 0,
                        'transaction_date' => date('Y-m-d'),
                        'transaction_from' => 'MACHINE_RETURN',
                        'transaction_type' => 'IN',
                        'master_stock_ledger_id' => $existingLedger->id,
                        'stock_updated' => 'Y',
                        'created_by' => Yii::app()->user->id,
                        'created_date' => date('Y-m-d H:i:s'),
                        'remarks' => $remarks,
                        'lead_owner_id' => $return_lead_owner_id,
                    ];
                    if (!$stock->save(false)) {
                         echo CJSON::encode(['status' => 'error', 'message' => "Failed to save return stock for serial <b>{$machineModel->serial_no}</b>."]);
                        Yii::app()->end();
                    }
                }
                $msg_item=rtrim($msg_item,',');
                 $response  = ['status' => 'success', 'message' => $msg_item.' machines returned successfully.'];
               
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
             echo json_encode($response);
        }
  
 public function actionGetOilReturnDetails() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $model = new InventoryDirectTransfer();
            $model_items = array(new InventoryDirectTransferItem());
            $id = $data_array['id'];
            $type = $data_array['type'];
            if (!$id) {
                   echo CJSON::encode(['status' => 'error', 'message' => 'ID cannot be blank']);
                    Yii::app()->end();
                }
            $condition = " t.issue_type = 'MH' AND items.is_issued = 'Y' ";
            $model = $model->findByPk($id);
            $transfer_date = $model->transfer_date;
            $model_items = InventoryDirectTransferItem::model()->with('customer')->findAll(array('condition' => 'direct_transfer_id="' . $id . '"'));
            // if (empty($model_items)) {
            //     $model_items = array(new InventoryDirectTransferItem());
            // }
             $item_data = [];
             foreach ($model_items as $i => $modeltransfer) {
               if ((int) $model->id > 0) {
               $modeltransfer->available_qty = (float) ProductLocation::model()->find(array('select' => 'SUM(quantity) as quantity', 'condition' => 'product_id="' . $modeltransfer->item_id . '" AND warehouse_id=' . $model->from_warehouse_id))->quantity;
                  }
                $item_data[] = [
                    "id" => $modeltransfer->id,
                    "item_name" => $modeltransfer->item_name,
                    "item_id" => $modeltransfer->item_id,
                    "item_description" => $modeltransfer->item_description,
                    "transfer_qty" => (int)$modeltransfer->transfer_qty,
                    "balance_qty" => (int)$modeltransfer->balance_qty,
                    "used_qty" =>  0,
                    "unit" => ($modeltransfer->item_id > 0) ? UnitOfMeasurement::getUnits($modeltransfer->item_id) :array(),
                    "transfer_qty" => (int)$modeltransfer->transfer_qty,
                    ];
            }

            $data = [];
            $erpsettings = MasCompany::getCurrentUserERPSettingApp($userModel->company_id);
            if ($erpsettings == 'E') {
                $warehouseArray = MasInventoryWarehouse::getWarehouses();
            }
            if ($erpsettings == 'C') {
                $warehouseArray = MasInventoryWarehouse::getWarehousesCRM();
            } 
             $userArray = User::getUserByApp($userModel->company_id);

            $data = [
                    "id"                => $model->id,
                    "to_warehouse_id"=> $model->to_warehouse_id,
                    "to_warehouse_name"=>$warehouseArray[$model->to_warehouse_id],
                    "from_warehouse_id"=> $model->from_warehouse_id,
                    "from_warehouse_name"=>$warehouseArray[$model->from_warehouse_id],
                    "lead_owner_id"=> $model->lead_owner_id,
                    "lead_owner_name"=> $userArray[$model->lead_owner_id],
                    "customer_id"=> $model->customer_id,
                    "customer_name"=> ($model->customer_id > 0) ? $model->customer->customer_name : '',
                    "outlet_id"=> $model->outlet_id,
                    "outlet_name"=> CustomerOutletLocation::getShippingLocationById($model->outlet_id)[$model->outlet_id],
                    "file_id"=> $model->file_id,
                    "transfer_date"=> $transfer_date ,
                    "items"=>$item_data
                ];
           
             $response = array('status' => "success", "message" => "success", "data" => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);
    }
    public function actionGetOilToBeReturnDetails() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $model = new InventoryDirectTransfer();
            $model_items = array(new InventoryDirectTransferItem());
            $id = $data_array['id'];
            $type = $data_array['type'];
            $condition = " t.issue_type = 'MH' AND items.is_issued = 'Y' ";
            $model = $model->findByPk($id);
            $transfer_date = $model->transfer_date;
            $model_items = InventoryDirectTransferItem::model()->with('customer')->findAll(array('condition' => 'direct_transfer_id="' . $id . '"'));
            // if (empty($model_items)) {
            //     $model_items = array(new InventoryDirectTransferItem());
            // }
             $item_data = [];
             foreach ($model_items as $i => $modeltransfer) {
               if ((int) $model->id > 0) {
               $modeltransfer->available_qty = (float) ProductLocation::model()->find(array('select' => 'SUM(quantity) as quantity', 'condition' => 'product_id="' . $modeltransfer->item_id . '" AND warehouse_id=' . $model->from_warehouse_id))->quantity;
                  }
                $item_data[] = [
                    "id" => $modeltransfer->id,
                    "item_name" => $modeltransfer->item_name,
                    "item_id" => $modeltransfer->item_id,
                    "item_description" => $modeltransfer->item_description,
                    "transfer_qty" => (int)$modeltransfer->transfer_qty,
                    "balance_qty" => (int)$modeltransfer->balance_qty,
                    "used_qty" =>  0,
                    "unit" => ($modeltransfer->item_id > 0) ? UnitOfMeasurement::getUnits($modeltransfer->item_id) :array(),
                    "transfer_qty" => (int)$modeltransfer->transfer_qty,
                    ];
            }

            $data = [];
            $erpsettings = MasCompany::getCurrentUserERPSettingApp($userModel->company_id);
            if ($erpsettings == 'E') {
                $warehouseArray = MasInventoryWarehouse::getWarehouses();
            }
            if ($erpsettings == 'C') {
                $warehouseArray = MasInventoryWarehouse::getWarehousesCRM();
            } 
             $userArray = User::getUserByApp($userModel->company_id);

            $data = [
                    "id"                => $model->id,
                    "to_warehouse_id"=> $model->to_warehouse_id,
                    "to_warehouse_name"=>$warehouseArray[$model->to_warehouse_id],
                    "from_warehouse_id"=> $model->from_warehouse_id,
                    "from_warehouse_name"=>$warehouseArray[$model->from_warehouse_id],
                    "lead_owner_id"=> $model->lead_owner_id,
                    "lead_owner_name"=> $userArray[$model->lead_owner_id],
                    "customer_id"=> $model->customer_id,
                    "customer_name"=> ($model->customer_id > 0) ? $model->customer->customer_name : '',
                    "outlet_id"=> $model->outlet_id,
                    "outlet_name"=> CustomerOutletLocation::getShippingLocationById($model->outlet_id)[$model->outlet_id],
                    "file_id"=> $model->file_id,
                    "transfer_date"=> $transfer_date ,
                    "items"=>$item_data
                ];
           
             $response = array('status' => "success", "message" => "success", "data" => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);
    }
  public function actionSaveWarehouseReturn()
          {
            $valid = true;
            $other = [];
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $model = new InventoryGoodsIssue();
                $id = (int)$data_array['id'];
                 $file_id= 0;
                // if($id>0)
                // {
                //     $modelTransfer = InventoryDirectTransfer::model()->findByPk($id);
                //     $file_id = (int)$modelTransfer->file_id;
                // }
                $main_warehouse_model =MasInventoryWarehouse::getDefaultWarehouse();
                $from_warehouse_id = MasInventoryWarehouse::model()->getWarehouseIdByCode('RW');//$data_array['from_warehouse_id'];
                $to_warehouse_id = $main_warehouse_model->id;//$data_array['to_warehouse_id'];
                $lead_owner_id = $data_array['lead_owner_id'];
                $customer_id = $data_array['customer_id'];
                $outlet_id = $data_array['outlet_id'];
                //$file_id = $data_array['file_id'];
                $model->goods_issue_date = date('Y-m-d');
                $model->file_id = $id;
                $model->warehouse_id = $from_warehouse_id;
                $model->lead_owner_id = $lead_owner_id;
                $model->notes = $data_array['reference'];
                $model->reference = 'OIL_ISSUE';
                $model->created_by = 0;
                $model->created_date_time = date('Y-m-d H:i:s');
                if (empty($model->lead_owner_id)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'Technician cannot be blank'
                    ]);
                    Yii::app()->end();
                }
                $itemRows = $data_array['items'] ?? [];
                if (empty($itemRows)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'No product items found.'
                    ]);
                    Yii::app()->end();
                }

                $itemModels = [];
                $stockLedgers = [];
                $id=0;
                 foreach ($itemRows as $i => $itemData) {
                     $id = $itemData['transfer_header_id'];
                   
                    $modelStore = Store::model()->findByPk($itemData['item_id']);
                    $model->customer_id = $customer_id;
                    $model->outlet_id = $outlet_id;
                    $model->production_order_id = $file_id;
                    // stock_ledger_id is passed as serial_no in the submitted data
                    $sql = 'SELECT id,unit_id,warehouse_id FROM erp_stock_ledger L where L.product_id=' . $itemData['item_id'] . ' AND header_id = '.$itemData['transfer_header_id'].' AND transaction_type = "IN" AND available_status = "A"';
                    $modelStockLedger = Yii::app()->db->createCommand($sql)->queryRow();
                    if (!$modelStockLedger) {
                       $valid = false;
                           
                           echo CJSON::encode([
                                'status' => 'error',
                                'message' => "Invalid stock ledger reference for item " . ($i + 1)]);
                        $other[] = "Invalid stock ledger reference for item " . ($i + 1);
                        // push placeholder so indexes remain consistent but skip further processing for this row
                        $stockLedgers[] = null;
                        $itemModels[] = null;/////Invalid stock ledger reference
                      Yii::app()->end();
                    }

                    $modelUOM = UnitOfMeasurement::model()->findByPk((int) $modelStockLedger['unit_id']);
                    $picked_qty = (int) $itemData['transfer_qty'] - (int) $itemData['balance_qty'];
                    $modelIssueItem = new InventoryGoodsIssueItem();
                    $modelIssueItem->product_id = $itemData['item_id'];
                    $modelIssueItem->product_name = $modelStore ? $modelStore->part_number : '';
                    $modelIssueItem->description = $modelStore ? $modelStore->description : '';
                    $modelIssueItem->unit = (int) $modelStockLedger['unit_id'];
                    $modelIssueItem->rate = 0; // temp
                    $modelIssueItem->picked_qty = $picked_qty;
                    $modelIssueItem->location_id = '';
                    $modelIssueItem->created_by = 0;
                    $modelIssueItem->created_date_time = date('Y-m-d H:i:s');
                    $customer = Customer::model()->findByPk($model->customer_id);
                    $no_of_days = 30;
                    if ($customer && !empty($customer->no_of_days) && $customer->no_of_days > 0) {
                        $no_of_days = (int) $customer->no_of_days;
                    }
                    $lastService = date('Y-m-d');
                    $nextService = date('Y-m-d', strtotime("+{$no_of_days} days", strtotime($lastService)));
                    $valid = $modelIssueItem->validate();
                    $itemModels[] = $modelIssueItem;
                    $stockLedgers[] = $modelStockLedger;
                     
                }
                 $valid = $model->validate();
                if ($valid) {
                    // Save header
                    if (!$model->save(false)) {
                        echo json_encode(['status' => 'error', 'message' =>$model->getErrors()]); 
                          Yii::app()->end();  
                    }

                $warehouseNameTo = $warehouseNameFrom = '';
                        $warehouseModel = MasInventoryWarehouse::model()->findByPk($from_warehouse_id);
                        if ($warehouseModel) {
                            $warehouseNameFrom = $warehouseModel->warehouse_name;
                        }
                        $warehouseModel = MasInventoryWarehouse::model()->findByPk($to_warehouse_id);
                        if ($warehouseModel) {
                            $warehouseNameTo = $warehouseModel->warehouse_name;
                        }
                        foreach ($itemModels as $index => $itemModel) {
                            $transferQty = (int) $itemRows[$index]['transfer_qty'];
                            $balanceQty = (int) $itemRows[$index]['balance_qty'];
                            $usedQty = (int) $transferQty - (int) $balanceQty;
                            // skip rows that were invalid earlier
                            if (!$itemModel || !isset($stockLedgers[$index]) || !$stockLedgers[$index]) {
                                Yii::app()->end();
                            }
                            $itemModel->goods_issue_id = $model->id;
                            $ledger = $stockLedgers[$index]; // associative array from queryRow
                            $uom = UnitOfMeasurement::model()->findByPk((int) $ledger['unit_id']);
                            /************** UPDATE ORIGINAL STOCK LEDGER TO MARK ISSUED **************/
                            // Use the existing ledger id to update (that is the row we are issuing)
                            $existingLedgerId = (int) $ledger['id'];
                            $processStatus = 'OIL_TRANSFERED';
                            $customerNameForRemarks = ($model->customer && !empty($model->customer->customer_name)) ? $model->customer->customer_name : '';
                            $remarksUpdate = $processStatus . '/' . $model->id . '/' . $customerNameForRemarks;
                            /************** STOCK LEDGER (OUT) ENTRY FOR MACHINE_ISSUE **************/
                            $existingLedger = (object) $ledger; // cast for ->property access convenience
                            $remarks = $processStatus.'/' . $model->id . '/' . $customerNameForRemarks;
                            // Get warehouse name
                            
                            // Prepare new stock ledger OUT entry from Van warehouse with used quantity
                            $stock = new StockLedger();
                            $stock->file_id = $model->file_id;
                            $stock->header_id = $model->id;
                            $stock->header_item_id = $itemModel->id;
                            $stock->customer_vendor_id = $model->customer_id;
                            $stock->customer_vendor_name = $customerNameForRemarks;
                            $stock->product_id = $itemModel->product_id;
                            $stock->product_name = $itemModel->product_name;
                            $stock->product_description = $itemModel->description;
                            // Try to pull brand info from store if available
                            $storeModel = Store::model()->findByPk($itemModel->product_id);
                            $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                            $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                            $stock->warehouse_id = $to_warehouse_id;
                            $stock->warehouse_name = $warehouseNameTo;
                            // Default rack/bin
                            $rack = new MasInvRack();
                            $stock->rack_id = $rack->getDefaultRackId();
                            $stock->rack_name = $rack->getRackName($stock->rack_id);
                            $bin = new MasInvBin();
                            $stock->bin_id = $bin->getDefaultBinId();
                            $stock->bin_name = $bin->getBinName($stock->bin_id);
                            // UOM and stock details
                            $stock->unit_id = $storeModel->unit_id;
                            $uomModel = UnitOfMeasurement::model()->findByPk($storeModel->unit_id);
                            $stock->unit_name = $uomModel ? $uomModel->name : '';
                            $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                            $stock->quantity = -$usedQty;
                            $stock->available_status = 'U'; // Mark unavailable as item is issued
                            $stock->batch_no = '';
                            $stock->serial_no = '';
                            $stock->cost_price = $storeModel->rate;
                            $stock->transaction_date = date('Y-m-d');
                            $stock->transaction_from = "OIL_TRANSFERED";
                            $stock->transaction_type = "OUT";
                            $stock->master_stock_ledger_id = $existingLedger->id;
                            $stock->stock_updated = 'Y';
                            $stock->created_by = 0;
                            $stock->created_date = date('Y-m-d H:i:s');
                            $stock->remarks = $remarks;
                            $stock->lead_owner_id = $model->lead_owner_id;
                            if (!$stock->save(false)) {
                               echo json_encode(['status' => 'error', 'message' =>"Failed to save stock ledger (OUT) for issued oil issue ID {$itemModel->product_id}"]);

                               Yii::app()->end();
                            }
                        if ($balanceQty > 0) {
                            $processStatus = 'OIL_ISSUE_BALANCE';
                            $remarksUpdate = $processStatus . '/' . $model->id . '/' . $customerNameForRemarks;
                            $remarks = $processStatus.'/' . $model->id . '/' . $customerNameForRemarks;

                            // Prepare new stock ledger OUT entry from Van warehouse for balance qunatity
                            $stock = new StockLedger();
                            $stock->file_id = $model->file_id;
                            $stock->header_id = $model->id;
                            $stock->header_item_id = $itemModel->id;
                            $stock->customer_vendor_id = $model->customer_id;
                            $stock->customer_vendor_name = $customerNameForRemarks;
                            $stock->product_id = $itemModel->product_id;
                            $stock->product_name = $itemModel->product_name;
                            $stock->product_description = $itemModel->description;
                            // Try to pull brand info from store if available
                            $storeModel = Store::model()->findByPk($itemModel->product_id);
                            $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                            $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                            $stock->warehouse_id = $to_warehouse_id;
                            $stock->warehouse_name = $warehouseNameTo;
                            // Default rack/bin
                            $rack = new MasInvRack();
                            $stock->rack_id = $rack->getDefaultRackId();
                            $stock->rack_name = $rack->getRackName($stock->rack_id);
                            $bin = new MasInvBin();
                            $stock->bin_id = $bin->getDefaultBinId();
                            $stock->bin_name = $bin->getBinName($stock->bin_id);
                            // UOM and stock details
                            $stock->unit_id = $storeModel->unit_id;
                            $uomModel = UnitOfMeasurement::model()->findByPk($storeModel->unit_id);
                            $stock->unit_name = $uomModel ? $uomModel->name : '';
                            $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                            $stock->quantity = -$balanceQty;
                            $stock->available_status = 'U'; // Mark unavailable as item is issued
                            $stock->batch_no = '';
                            $stock->serial_no = '';
                            $stock->cost_price = $storeModel->rate;
                            $stock->transaction_date = date('Y-m-d');
                            $stock->transaction_from = $processStatus;
                            $stock->transaction_type = "OUT";
                            $stock->master_stock_ledger_id = $existingLedger->id;
                            $stock->stock_updated = 'Y';
                            $stock->created_by = 0;
                            $stock->created_date = date('Y-m-d H:i:s');
                            $stock->remarks = $remarks;
                            $stock->lead_owner_id = $model->lead_owner_id;
                            if (!$stock->save(false)) {
                                echo json_encode(['status' => 'error', 'message' =>"Failed to save stock ledger (OUT) for issued oil issue ID {$itemModel->product_id}"]);  
                                Yii::app()->end();
                            }
                        
                            $processStatus = 'OIL_ISSUE_BALANCE';
                            $remarksUpdate = $processStatus . '/' . $model->id . '/' . $customerNameForRemarks;
                            $remarks = $processStatus.'/' . $model->id . '/' . $customerNameForRemarks;
                            // Prepare new stock ledger IN entry from Van warehouse to Main warehouse for balance qunatity
                            $stock = new StockLedger();
                            $stock->file_id = $model->file_id;
                            $stock->header_id = $model->id;
                            $stock->header_item_id = $itemModel->id;
                            $stock->customer_vendor_id = 0;
                            $stock->customer_vendor_name = '';
                            $stock->product_id = $itemModel->product_id;
                            $stock->product_name = $itemModel->product_name;
                            $stock->product_description = $itemModel->description;
                            // Try to pull brand info from store if available
                            $storeModel = Store::model()->findByPk($itemModel->product_id);
                            $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                            $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                            $stock->warehouse_id = $from_warehouse_id;
                            $stock->warehouse_name = $warehouseNameFrom;
                            // Default rack/bin
                            $rack = new MasInvRack();
                            $stock->rack_id = $rack->getDefaultRackId();
                            $stock->rack_name = $rack->getRackName($stock->rack_id);
                            $bin = new MasInvBin();
                            $stock->bin_id = $bin->getDefaultBinId();
                            $stock->bin_name = $bin->getBinName($stock->bin_id);
                            // UOM and stock details
                            $stock->unit_id = $storeModel->unit_id;
                            $uomModel = UnitOfMeasurement::model()->findByPk($storeModel->unit_id);
                            $stock->unit_name = $uomModel ? $uomModel->name : '';
                            $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                            $stock->quantity = $balanceQty;
                            $stock->available_status = 'A'; // Mark unavailable as item is issued
                            $stock->batch_no = '';
                            $stock->serial_no = '';
                            $stock->cost_price = $storeModel->rate;
                            $stock->transaction_date = date('Y-m-d');
                            $stock->transaction_from = $processStatus;
                            $stock->transaction_type = "IN";
                            $stock->master_stock_ledger_id = $existingLedger->id;
                            $stock->stock_updated = 'Y';
                            $stock->created_by = Yii::app()->user->id;
                            $stock->created_date = date('Y-m-d H:i:s');
                            $stock->remarks = $remarks;
                            $stock->lead_owner_id = $model->lead_owner_id;
                            if (!$stock->save(false)) {
                                 echo json_encode(['status' => 'error', 'message' =>"Failed to save stock ledger (OUT) for issued oil issue ID {$itemModel->product_id}"]); 
                                Yii::app()->end();
                            }
                        }
                            // Now link the newly created stock ledger id to the item and save the item
                            //$itemModel->stock_ledger_id = $stock->id;
                            if (!$itemModel->save(false)) {
                                 echo json_encode(['status' => 'error', 'message' => "Failed to save InventoryGoodsIssueItem for oil issue ID {$itemModel->product_id}"]);
                                 Yii::app()->end();
                            }
                            InventoryDirectTransfer::model()->updateByPk($itemRows[$index]['transfer_header_id'], ['status' => 'C' ]);
                        }
                 $response  = ['status' => 'success', 'message' =>  'success', 'id' => $model->id];
                 } else {
                    $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                     $errorsMerged = array_merge_recursive((array) $error1, (array) $other);
                      $response  = ['status' => 'success', 'message' =>  $errorsMerged]; 
                }
               
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
             echo json_encode($response);
        }
  


  public function actionGetCustomerDetails()
  {
      $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $customer_id = $data_array['customer_id'];
            $condition = "1=1";
            if($customer_id>0)
            {
                 $condition .= ' AND customer_id=' . $customer_id;
                
                $modelOrder = new Order();
                $orders = $modelOrder->findAll([
                    'select' => 'id,file_id,sales_group_id,lead_owner_id',
                    'condition' => $condition,
                    'limit' => 200
                ]);
                $orderdata = [];
                foreach ($orders as $eachOrder) {
                    $orderdata[]=
                    [
                        "id"=>$eachOrder->id,
                        "file_id"=> $eachOrder->file_id
                    ];
                }
                //////////////////////////////////////////////////////////////////
                $modelOutlets = new CustomerOutletLocation();
                $Outlets = $modelOutlets->findAll([
                    'select' => '*',
                    'condition' => $condition,
                    'limit' => 200
                ]);
                $outletdata = [];
                foreach ($Outlets as $eachOutlet) {
                    $outletdata[]=
                    [
                        "id"=>$eachOutlet->id,
                        "outlet"=> $eachOutlet->outlet_location
                    ];
                }
                $data =
                [
                    "orders"=>$orderdata,
                    "outlets"=>$outletdata
                ];

                 
                $response = array('status' => "success", "message" => "success", "data" => $data);
            }
            else
                 $response = array('status' => "error", "message" => " Customer is required");
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);

  }

  public function actionGetCustomerOutletLocations()
  {
      $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $customer_id = $data_array['customer_id'];
            $outlet_id = $data_array['outlet_id'];
            $condition = "1=1";
            if($customer_id>0 && $outlet_id>0)
            {
                 $condition .= ' AND customer_id=' . $customer_id;
                 $condition .= ' AND customer_outlet_location_id=' . $outlet_id;
                
                $modelLocations = new ServiceCustomerLocation();
                $OutletLocations = $modelLocations->findAll([
                    'select' => '*',
                    'condition' => $condition,
                    'limit' => 200
                ]);
                $locdata = [];
                foreach ($OutletLocations as $eachLocation) {
                    $locdata[]=
                    [
                        "id"=>$eachLocation->id,
                        "location"=> $eachLocation->location_name
                    ];
                }
                 
                // $data =
                // [
                //     "orders"=>$orderdata,
                //     "outlets"=>$outletdata
                // ]

                 
                $response = array('status' => "success", "message" => "success", "data" => $locdata);
            }
            else
                 $response = array('status' => "error", "message" => "Customer&Outet are required");
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);

  }
  public function actionGetCustomerOrderItems()
  {
      $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $customer_id = $data_array['customer_id'];
            $file_id = $data_array['file_id'];
            $lead_owner_id = $data_array['lead_owner_id'];

            $condition = "1=1";
                if (empty($lead_owner_id)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'Assigned User cannot be blank'
                    ]);
                    Yii::app()->end();
                }
                 if (empty($file_id)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'File Id cannot be blank'
                    ]);
                    Yii::app()->end();
                }
                 if (empty($customer_id)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'Customer cannot be blank'
                    ]);
                    Yii::app()->end();
                }
                $productIds = OrderItem::getProductIds($file_id);
                $serial_no = '';
                $condition = '';
                if (!empty($productIds)) {
                    $condition = ' AND L.product_id IN (' . $productIds . ')';
                }
                 $serialnqry = '
                SELECT L.serial_no, L.id, L.product_name
                FROM erp_stock_ledger L
                WHERE L.lead_owner_id = ' . (int) $lead_owner_id . '
                AND L.serial_no != ""
                ' . $condition . '
                AND L.location_id = "0"
                AND L.customer_vendor_id = "0"
                AND L.id NOT IN (
                    SELECT master_stock_ledger_id
                    FROM erp_stock_ledger
                    WHERE master_stock_ledger_id <> 0
                )
            ';

                $modelserial = Yii::app()->db->createCommand($serialnqry)->queryAll();

                // Prepare listData with serial_no | product_name
                $formatted = [];
                foreach ($modelserial as $each) {
                    $formatted[] = [
                        'id' => $each['id'],
                        'serial_display' => $each['serial_no'] . ' | ' . $each['product_name'],
                    ];
                }
                 
                 
                $response = array('status' => "success", "message" => "success", "data" => $formatted);
            
            
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);

  }

  public function actionGetMachineBySerialNo()
  {
       $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $customer_id = $data_array['customer_id'];
            $serial_no = $data_array['serial_id'];
            $order_id = $data_array['order_id'];
            $condition = "1=1";
             if (empty($customer_id)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'Customer cannot be blank'
                    ]);
                    Yii::app()->end();
                }
                 if (empty($serial_no)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'Serial No cannot be blank'
                    ]);
                    Yii::app()->end();
                }
                 if (empty($order_id)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'Order Id cannot be blank'
                    ]);
                    Yii::app()->end();
                }

                 $data = [];
                //$machineData = StockLedger::getMachinebySerialno($serial_no);
                $machinenqry = 'SELECT product_id,product_name FROM erp_stock_ledger L where L.serial_no="' . $serial_no . '"';
                $modelmachine = Yii::app()->db->createCommand($machinenqry)->queryRow();
                 $modelOrder = Order::model()->findByPk($order_id);
                 $flag=0;
                if(!empty($modelOrder) && !empty($modelmachine))
                {
                    $modelItems = (int)OrderItem::model()->count(array('condition'=>'product_id='.$modelmachine['product_id'].' AND order_id='.$modelOrder->id));
                    if($modelItems > 0)
                    {
                        if (!empty($modelmachine) && is_array($modelmachine)) {
                            $data['machine_id'] = $modelmachine['product_id'];
                            $data['machine_name'] = $modelmachine['product_name'];
                            $data['serial_no'] = $serial_no;
                        }
                    }
                    else
                    {
                         echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'Item not exist in given Order '
                    ]);
                    Yii::app()->end();

                    }

                }               
                 
                $response = array('status' => "success", "message" => "success", "data" => $data);
            
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }   
        echo json_encode($response);

  }

   public function actionGetCustomerReturnMachines()
  {
       $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $customer_id = $data_array['customer_id'];
            $outlet_id = $data_array['outlet_id'];
             if (empty($customer_id)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'Customer cannot be blank'
                    ]);
                    Yii::app()->end();
                }
            $criteria = new CDbCriteria();
            $criteria->alias = 't';
            $criteria->addCondition('is_issued = :is_issued');
            $criteria->params[':is_issued'] = 'Y';
            $criteria->addCondition('inventorygoodsissue.issue_type = :issue_type');
            $criteria->params[':issue_type'] = "MH";
            $criteria->addCondition('inventorygoodsissue.customer_id = :customer_id');
            $criteria->params[':customer_id'] = $customer_id;
            if ($outlet_id > 0) {
                $criteria->addCondition('inventorygoodsissue.outlet_id = :outlet_id');
                $criteria->params[':outlet_id'] = $outlet_id;
            }
            $criteria->with = ['inventorygoodsissue', 'location'];
            $criteria->group = 'inventorygoodsissue.id, t.product_id';
            $machineList = InventoryGoodsIssueItem::model()->findAll($criteria);
            $data = [];
            foreach($machineList as $machine)
            {
                $serialNo = $machine->serial_no ?: '-';
                $machine_name = $machine->product_name ?: '-';
                $outletName = isset($machine->inventorygoodsissue->outlet_id) && !empty($machine->inventorygoodsissue->outlet->outlet_location) ? $machine->inventorygoodsissue->outlet->outlet_location : '-';
                $locationName = isset($machine->location_id) && !empty($machine->location->location_name) ? $machine->location->location_name : '-';

                $data[]=[
                    "id"     => $machine->id,
                    "machine_name"   => $machine_name,
                    "serial_no"     => $serialNo,
                    "outlet_name"     => $outletName,
                    "location_name"     => $locationName,
                    "product_id"     =>$machine->product_id,
                    "goods_issue_id"     =>$machine->goods_issue_id 
                ];
            }
                 
                $response = array('status' => "success", "message" => "success", "data" => $data);
            
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);

  }
   public function actionGetReturnMachineBySerialNo()
  {
         $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $customer_id = $data_array['customer_id'];
            $outlet_id = $data_array['outlet_id'];
            $serial_no = $data_array['serial_no'];
             if (empty($customer_id)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'Customer cannot be blank'
                    ]);
                    Yii::app()->end();
                }
                if (empty($serial_no)) {
                    echo CJSON::encode([
                        'status' => 'error',
                        'message' => 'Serial No cannot be blank'
                    ]);
                    Yii::app()->end();
                }

            $condition = 'is_issued="Y"  AND inventorygoodsissue.customer_id='.$customer_id .' AND inventorygoodsissue.issue_type="MH"' ;
             if ($outlet_id > 0) {
                 $condition .= ' AND inventorygoodsissue.outlet_id='.$outlet_id.'' ;
            }
            if ($serial_no > 0) {
                 $condition .= ' AND serial_no="'.$serial_no.'"' ;
            }
            $machine = InventoryGoodsIssueItem::model()->with('inventorygoodsissue', 'location')->find(['condition'=>$condition,'group'=>'inventorygoodsissue.id, t.product_id']);
            $data = [];
            if(!empty($machine))
            {
                $serialNo = $machine->serial_no ?: '-';
                $machine_name = $machine->product_name ?: '-';
                $outletName = isset($machine->inventorygoodsissue->outlet_id) && !empty($machine->inventorygoodsissue->outlet->outlet_location) ? $machine->inventorygoodsissue->outlet->outlet_location : '-';
                $locationName = isset($machine->location_id) && !empty($machine->location->location_name) ? $machine->location->location_name : '-';
                $data=[
                    "item_id"        => $machine->id,
                    "machine_id"     => $machine->product_id,
                    "machine_name"   => $machine_name,
                    "serial_no"      => $serialNo,
                    "outlet_id"      => $machine->inventorygoodsissue->outlet_id,
                    "outlet_name"    => $outletName,
                    "location_id"    => $machine->location_id,
                    "location_name"  => $locationName,
                    
                   // "goods_issue_id"     =>$machine->goods_issue_id 
                ];
                
                $response = array('status' => "success", "message" => "success", "data" => $data);
            }
            else
            {
                $response = array('status' => "error", "message" => "Machine not exist");
            }
            
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);

  }
  public function actionGetReturnList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $term = $data_array['term'];
            $customer_id = $data_array['customer_id'];
            $outlet_id = $data_array['outlet_id'];
          
            ///////////////////////////////////////////////////
            $data_for_oil_issual = [];
            $data_for_machine_issual = [];
            
             ////////////////////////////////////////////////////////////////////
            $criteria = new CDbCriteria();
            $criteria->alias = 't';
            $criteria->addCondition('is_issued = :is_issued');
            $criteria->params[':is_issued'] = 'N';
            $criteria->addCondition('inventorygoodsissue.issue_type = :issue_type');
            $criteria->params[':issue_type'] = "MH";
            $criteria->addCondition('inventorygoodsissue.customer_id = :customer_id');
            $criteria->params[':customer_id'] = $customer_id;
            $criteria->addCondition('inventorygoodsissue.lead_owner_id = :lead_owner_id');
            $criteria->params[':lead_owner_id'] = $userModel->id;
            if ($outlet_id > 0) {
                $criteria->addCondition('inventorygoodsissue.outlet_id = :outlet_id');
                $criteria->params[':outlet_id'] = $outlet_id;
            }
            $criteria->with = ['inventorygoodsissue', 'location'];
            //$criteria->group = 'inventorygoodsissue.id, t.product_id';
            //print_r($criteria);
            $machineList = InventoryGoodsIssueItem::model()->findAll($criteria);
            $data = [];
            foreach($machineList as $machine)
            {
                $serialNo = $machine->serial_no ?: '-';
                $machine_name = $machine->product_name ?: '-';
                $outletName = isset($machine->inventorygoodsissue->outlet_id) && !empty($machine->inventorygoodsissue->outlet->outlet_location) ? $machine->inventorygoodsissue->outlet->outlet_location : '-';
                //$locationName = isset($machine->location_id) && !empty($machine->location->location_name) ? $machine->location->location_name : '-';
                  $transaction_date = "";
                if (!empty($machine->inventorygoodsissue->goods_issue_date) && ($machine->inventorygoodsissue->goods_issue_date != "")) {
                $transaction_date = date("d/m/Y", strtotime($machine->inventorygoodsissue->goods_issue_date));
                }
                $data_for_machine_issual[]=[
                    "id"     => $machine->id,
                    "product_id"   => $machine->product_id,
                    "product_name"   => $machine_name,
                    "product_description"   => $machine->description,
                    "serial_no"     => $serialNo,
                    "unit_id"     => $machine->unit ,
                    "transaction_date"=> $transaction_date
                ];
            }
           
              $condition = '(parent.status="T" ) AND  parent.added_from="DT" AND parent.type = "I" AND parent.lead_owner_id='.(int)$userModel->id;
             if (!empty($term)) {
                $condition .= " and parent.id LIKE '%" . $term . "%' OR warehouseTo.warehouse_name LIKE '%" . $term . "%' OR warehouseFrom.warehouse_name LIKE '%" . $term . "%'   
                                OR customer.customer_name LIKE '%" . $term . "%'";
            }
            if ($customer_id > 0) {
                 $condition .= ' AND parent.customer_id='.$customer_id.'' ;
            }
             if ($outlet_id > 0) {
                 $condition .= ' AND parent.outlet_id='.$outlet_id.'' ;
            }
            // echo $condition;
            // die;
            $models = InventoryDirectTransferItem::model()->with('parent','parent.warehouseTo', 'parent.warehouseFrom','parent.customer')->findAll([
                "condition" => $condition,
                "order" => "parent.id DESC"
            ]);
            // print_r($models);
            foreach ($models as $row) {
                if (!empty($row->parent->transfer_date) && ($row->parent->transfer_date != "")) {
                $req_date = date("d/m/Y", strtotime($row->parent->transfer_date));
                }
                $div = '';
                if ($row['parent']['lead_owner_id'] > 0) {
                    $user = $row['parent']['user_det']['first_name'] . ' ' . $row['parent']['user_det']['last_name'];
                } else {
                    $user = '';
                }

                $data_for_oil_issual[] = [
                    "id" => $row['id'],
                    "product_id"=>$row->item_id,
                    "product_name"=>$row->item_name,
                    "product_description"=>$row->item_description,
                    "transfer_qty"=>$row->transfer_qty,
                    "balance_qty"=> (int)0,
                    "unit_id"=>$row->unit,
                    "unit_name"=>$row->unitdetails->name,
                    "tranfer_id"=>$row->parent->id,
                    "customer_id" => $row->parent->customer_id,
                    "customer_name" => isset($row->parent->customer) ? $row->parent->customer->customer_name : '',
                    "req_date" => $req_date,
                    "from_warehouse_id" => $row->parent->from_warehouse_id,
                    "from_warehouse_name" => $row->parent->warehouseFrom->warehouse_name,
                    "to_warehouse_id" => $row->parent->to_warehouse_id,
                    "to_warehouse_name" =>  $row->parent->warehouseTo->warehouse_name,
                    "lead_owner_id" => $row->parent->lead_owner_id,
                    "lead_owner_name" => $user,
                    "outlet_id" => $row->parent->outlet_id,
                    "outlet_name" =>CustomerOutletLocation::getShippingLocationById($row->parent->outlet_id)[$row->parent->outlet_id],
                    "description" => $row->parent->direct_transfer_description,
                    "reference" => $row->parent->reference, 
                    ];
            }
            $data['oil_issual'] = $data_for_oil_issual;
            $data['machine_issual'] = $data_for_machine_issual;
            $response = array('status' => "success", "message" => "success", "data" => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);
    }
    
       
    public function actionGetReturnedMachinesList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $term = $data_array['term'];
            $condition = " inventorygoodsreceipt.receipt_type = 'MH'  ";
             if (!empty($term)) {
                $condition .= " AND (t.serial_no LIKE '%{$term}%' OR customer.customer_name LIKE '%{$term}%') ";
            }
            $models = InventoryGoodsReceiptItem::model()->with('inventorygoodsreceipt.customer', 'inventorygoodsreceipt')->findAll([
                "condition" => $condition,
                "order" => "t.id DESC"
            ]);
            $data = [];
            foreach ($models as $key => $row) {
                $data[] = [
                    "id" => $row->id,
                    "customer_id" => $row->inventorygoodsreceipt->customer_id,
                    "customer_name" => isset($row->inventorygoodsreceipt->customer) ? $row->inventorygoodsreceipt->customer->customer_name : '',
                    "lead_owner_id" => $row->inventorygoodsreceipt->lead_owner_id,
                    "lead_owner" => isset($row->inventorygoodsreceipt->lead_owner_id) ? $row->inventorygoodsreceipt->owner->first_name . ' ' . $row->inventorygoodsreceipt->owner->last_name : '',
                    "outlet_id" => $row->inventorygoodsreceipt->outlet_id,
                    "outlet_name" =>  isset($row->inventorygoodsreceipt->outlet_id) ? $row->inventorygoodsreceipt->outlet->outlet_location : '',
                    "serial_no" => isset($row->serial_no) ? $row->serial_no : '',
                    "machine_id" =>  $row->product_id ,
                    "machine_name" => isset($row->product_name) ? $row->product_name : '',
                    ];
            }
            $response = array('status' => "success", "message" => "success", "data" => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);
    }
    
     public function actionGetToBeReturnedMachinesList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $term = $data_array['term'];
            $customer_id = $data_array['customer_id'];
            $outlet_id = $data_array['outlet_id'];
            $condition = " inventorygoodsreceipt.receipt_type = 'MH' AND t.isApproved = 'N' AND inventorygoodsreceipt.lead_owner_id=".$userModel->id;
             if (!empty($term)) {
                $condition .= " AND (t.serial_no LIKE '%{$term}%' OR customer.customer_name LIKE '%{$term}%') ";
            }
             if ($customer_id > 0) {
                 $condition .= ' AND inventorygoodsreceipt.customer_id='.$customer_id.'' ;
            }
             if ($outlet_id > 0) {
                 $condition .= ' AND inventorygoodsreceipt.outlet_id='.$outlet_id.'' ;
            }
            //echo $condition;
            $models = InventoryGoodsReceiptItem::model()->with('inventorygoodsreceipt.customer', 'inventorygoodsreceipt')->findAll([
                "condition" => $condition,
                "order" => "t.id DESC"
            ]);
            $data = [];
            foreach ($models as $key => $row) {
                $data[] = [
                    "id" => $row->id,
                    "customer_id" => $row->inventorygoodsreceipt->customer_id,
                    "customer_name" => isset($row->inventorygoodsreceipt->customer) ? $row->inventorygoodsreceipt->customer->customer_name : '',
                    "lead_owner_id" => $row->inventorygoodsreceipt->lead_owner_id,
                    "lead_owner" => isset($row->inventorygoodsreceipt->lead_owner_id) ? $row->inventorygoodsreceipt->owner->first_name . ' ' . $row->inventorygoodsreceipt->owner->last_name : '',
                    "outlet_id" => $row->inventorygoodsreceipt->outlet_id,
                    "outlet_name" =>  isset($row->inventorygoodsreceipt->outlet_id) ? $row->inventorygoodsreceipt->outlet->outlet_location : '',
                    "serial_no" => isset($row->serial_no) ? $row->serial_no : '',
                    "product_id" =>  $row->product_id ,
                    "product_name" => isset($row->product_name) ? $row->product_name : '',
                    "product_description" => isset($row->description) ? $row->description : '',
                    ];
            }
            $response = array('status' => "success", "message" => "success", "data" => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);
    }
    public function actionGetReturnedOilList() {
        // $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        // $userModel = User::model()->findBytoken($token);
        // $response = array();
        // if (!empty($userModel) && $userModel->id > 0) {
        //     $data_array = json_decode(file_get_contents('php://input'), true);
        //     $term = $data_array['term'];
        //      $condition = " inventorygoodsreceipt.issue_type = 'MH'  ";
        //      if (!empty($term)) {
        //         $condition .= " and t.id LIKE '%" . $term . "%' OR customer.customer_name LIKE '%" . $term . "%'  ";
        //     }
            
        //     $models = InventoryGoodsIssueItem::model()->with('inventorygoodsissue', 'inventorygoodsissue.customer','owner')->findAll([
        //         "condition" => $condition,
        //         "order" => "t.id DESC"
        //     ]);
        //     $data = [];
        //     foreach ($models as  $row) {
        //         $req_date="";
        //         if (!empty($row->inventorygoodsissue->goods_issue_date ) && ($row->inventorygoodsissue->goods_issue_date  != "")) {
        //             $req_date = date("d/m/Y", strtotime($row->inventorygoodsissue->goods_issue_date ));
        //         }
        //         if ($row['lead_owner_id'] > 0) {
        //             $user = $row['owner']['first_name'] . ' ' . $row['owner']['last_name'];
        //         } else {
        //             $user = '';
        //         }
        //         $data[] = [
        //             "id" => $row->id,
        //             "customer_id" => $row->customer_id,
        //             "customer_name" => $row->inventorygoodsissue->customer->customer_name,
        //             "req_date" => $req_date,
        //             "warehouse_id" =>$row['warehouse_id'],
        //             "warehouse_name" =>$row['warehouse_det']['warehouse_name'],
        //             "outlet_id" =>  $row['outlet_id'],
        //             "outlet_name" =>$row['warehouseTo']['warehouse_name'],
        //             "lead_owner_id" =>  $row['lead_owner_id'],
        //             "lead_owner_name" => $user,
        //             "description" => $row['direct_transfer_description'],
        //             "reference" =>$row['reference'] 
        //             ];
        //     }
        //     $response = array('status' => "success", "message" => "success", "data" => $data);
        // } else {
        //     header("HTTP/1.1 401 Unauthorized");
        //     header('Content-Type: application/json');
        //     $response = array('status' => "failed", "message" => "Unauthorized user");
        // }
        // echo json_encode($response);
    }
    
    public function actionReturnMachineToUsedWarehouse()
    {
         $valid = true;
            $other = [];
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $model = new InventoryDirectTransfer();
                $customer_name = $data_array['customer_name'];
                $id = $data_array['id'];
                $customer_id = (int) $data_array['customer_id'];
                $lead_owner_id = (int) ($userModel->id ?? '');
                $outlet_id = $data_array['outlet_id'];
                $selectedItems = $data_array['items'] ?? [];
                 
                if (!$customer_id) {
                   echo CJSON::encode(['status' => 'error', 'message' => 'No customer selected for return.']);
                    Yii::app()->end();
                }
                // if (!$lead_owner_id) {
                //   echo CJSON::encode(['status' => 'error', 'message' => 'No user selected for return.']);
                //     Yii::app()->end();
                // }
                // if (!$outlet_id) {
                //   echo CJSON::encode(['status' => 'error', 'message' => 'No outlet selected for return.']);
                //   Yii::app()->end();
                // }
 
                $from_warehouse = MasInventoryWarehouse::model()->getWarehouseIdByCode('RUW');
                $from_warehouseName = MasInventoryWarehouse::model()->getWarehouseName($from_warehouse);
                $to_warehouse = MasInventoryWarehouse::model()->getWarehouseIdByCode('UW');
                $to_warehouseName = MasInventoryWarehouse::model()->getWarehouseName($to_warehouse);
                // if (!$from_warehouse) {
                //     echo CJSON::encode(['status' => 'error', 'message' => 'Return warehouse not configured (RUW missing).']);
                //     Yii::app()->end();
                // }
                 
                
                $model = new InventoryDirectTransfer();
                $model->transfer_date = date('Y-m-d');
                $model->customer_id = $customer_id;
                $model->from_warehouse_id = $from_warehouse;
                $model->to_warehouse_id = $to_warehouse;
                $model->reference = '';
                $model->lead_owner_id = $lead_owner_id;
                $model->created_by =$userModel->id;
                $model->status ='C';
                $model->created_date_time = date('Y-m-d H:i:s');
                if (!$model->save(false)) {
                     echo CJSON::encode(['status' => 'error', 'message' => $model->getErrors()]);
                     Yii::app()->end();
                }
                foreach ($selectedItems as $i => $item) {
                     $modelTransferItem[$i] = new InventoryDirectTransferItem();
                  
                    $machineModel = InventoryGoodsIssueItem::model()->findByPk($item['item_id']);
                    if (!$machineModel) {
                        echo CJSON::encode(['status' => 'error', 'message' => "Machine record not found for item ID {$item['item_id']}."]);
                        Yii::app()->end();
                    }
                    $machineModel->updateByPk($machineModel->id, [
                        'is_issued' => 'C',
                        'updated_by' => Yii::app()->user->id,
                        'updated_date_time' => date('Y-m-d H:i:s'),
                    ]);
                    $SQL = 'SELECT id FROM `erp_stock_ledger` WHERE serial_no = "' . $item['serial_no'] .'" ORDER BY master_stock_ledger_id DESC LIMIT 1 ';
                    $stock_ledger_id = Yii::app()->db->createCommand($SQL)->queryScalar();
                    $existingLedger = StockLedger::model()->findByPk($stock_ledger_id);
                    if (!$existingLedger) {
                        echo CJSON::encode(['status' => 'error', 'message' => "No stock ledger found for machine <b>{$machineModel->serial_no}</b>."]);
                        Yii::app()->end();
                    }
                     $storeModel = Store::model()->findByPk($item['product_id']);
                    $modelTransferItem[$i]->item_id =$item['product_id'];
                    $modelTransferItem[$i]->item_name = $storeModel->part_number;
                    $modelTransferItem[$i]->item_description = $storeModel->description;
                    $modelTransferItem[$i]->unit = $item['unit'];
                    $modelTransferItem[$i]->transfer_qty =  1;
                    // $modelTransferItem->created_by = Yii::app()->user->id;
                    // $modelTransferItem->created_date_time = date('Y-m-d H:i:s');
                }
                $model->save();
                 foreach ($modelTransferItem as $itemModel) {
                    
                    $itemModel->direct_transfer_id = $model->id;
                    $itemModel->save();
                            //////////////////////////////////////////from Van used Warehouse////////////////////////
                            $stock = new StockLedger();
                            $stock->file_id = $model->file_id;
                            $stock->header_id = $model->id;
                            $stock->header_item_id = $itemModel->id;
                            $stock->customer_vendor_id = $model->customer_id;
                            $stock->customer_vendor_name =  "";
                            $stock->product_id = $itemModel->item_id;
                            $stock->product_name = $existingLedger->product_name;
                            $stock->product_description = $existingLedger->product_description;
                            // Try to pull brand info from store if available
                            $storeModel = Store::model()->findByPk($itemModel->item_id);
                            $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                            $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                            $stock->warehouse_id = $from_warehouse;
                            $stock->warehouse_name = $from_warehouseName;
                            // Default rack/bin
                            $rack = new MasInvRack();
                            $stock->rack_id = $rack->getDefaultRackId();
                            $stock->rack_name = $rack->getRackName($stock->rack_id);
                            $bin = new MasInvBin();
                            $stock->bin_id = $bin->getDefaultBinId();
                            $stock->bin_name = $bin->getBinName($stock->bin_id);
                            // UOM and stock details
                            $stock->unit_id = $storeModel->unit_id;
                            $uomModel = UnitOfMeasurement::model()->findByPk($storeModel->unit_id);
                            $stock->unit_name = $uomModel ? $uomModel->name : '';
                            $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                            $stock->quantity = -1;
                            $stock->available_status = 'U'; // Mark unavailable as item is issued
                            $stock->batch_no = '';
                            $stock->serial_no = $item['serial_no'];
                            $stock->transaction_date = date('Y-m-d');
                            $stock->transaction_from = "TRANSFER_OUT";
                            $stock->transaction_type = "OUT";
                            $stock->master_stock_ledger_id = $existingLedger->id;
                            $stock->stock_updated = 'Y';
                            $stock->created_by = 0;
                            $stock->created_date = date('Y-m-d H:i:s');
                            $stock->remarks = "";
                            $stock->lead_owner_id = $model->lead_owner_id;
                            if (!$stock->save(false)) {
                                echo json_encode(['status' => 'error', 'message' =>"Failed to save stock ledger (OUT) for ID {$itemModel->product_id}"]);  
                                Yii::app()->end();
                            }
                            //////////////////////////////////to Used Warehouse////////////////////////
                             $stock = new StockLedger();
                            $stock->file_id = $model->file_id;
                            $stock->header_id = $model->id;
                            $stock->header_item_id = $itemModel->id;
                            $stock->customer_vendor_id = $model->customer_id;
                            $stock->customer_vendor_name =  "";
                            $stock->product_id = $itemModel->item_id;
                            $stock->product_name = $existingLedger->product_name;
                            $stock->product_description = $existingLedger->product_description;
                            // Try to pull brand info from store if available
                            $storeModel = Store::model()->findByPk($itemModel->item_id);
                            $stock->brand_id = $storeModel ? ($storeModel->brand_class_id ?? null) : null;
                            $stock->brand_name = ($storeModel && isset($storeModel->brand_detail)) ? $storeModel->brand_detail->brand_name : null;
                            $stock->warehouse_id = $to_warehouse;
                            $stock->warehouse_name = $to_warehouseName;
                            // Default rack/bin
                            $rack = new MasInvRack();
                            $stock->rack_id = $rack->getDefaultRackId();
                            $stock->rack_name = $rack->getRackName($stock->rack_id);
                            $bin = new MasInvBin();
                            $stock->bin_id = $bin->getDefaultBinId();
                            $stock->bin_name = $bin->getBinName($stock->bin_id);
                            // UOM and stock details
                            $stock->unit_id = $storeModel->unit_id;
                            $uomModel = UnitOfMeasurement::model()->findByPk($storeModel->unit_id);
                            $stock->unit_name = $uomModel ? $uomModel->name : '';
                            $stock->unit_factor = $uomModel ? $uomModel->factor : 1;
                            $stock->quantity = 1;
                            $stock->available_status = 'A'; // Mark unavailable as item is issued
                            $stock->batch_no = '';
                            $stock->serial_no = $item['serial_no'];
                            $stock->transaction_date = date('Y-m-d');
                            $stock->transaction_from = "DIRECT_TRANSFER_IN";
                            $stock->transaction_type = "IN";
                            $stock->master_stock_ledger_id = $existingLedger->id;
                            $stock->stock_updated = 'Y';
                            $stock->created_by = 0;
                            $stock->created_date = date('Y-m-d H:i:s');
                            $stock->remarks = "";
                            $stock->lead_owner_id = $model->lead_owner_id;
                            if (!$stock->save(false)) {
                                echo json_encode(['status' => 'error', 'message' =>"Failed to save stock ledger (IN) for ID {$itemModel->product_id}"]);  
                                Yii::app()->end();
                            }
                            ////////////////////////////////////////////////////////////
                }
                 $response  = ['status' => 'success', 'message' => 'saved successfully.','id'=>$model->id];
               
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
             echo json_encode($response);
    }

    public function actionGetApprovalList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data = [];
            $data_array = json_decode(file_get_contents('php://input'), true);
            $term = $data_array['term'];
            $lead_owner = $data_array['lead_owner'];
            $customer_id = $data_array['customer_id'];
            $lead_owner_id = $userModel->id;
            $data_for_oil_issual = [];
            $data_for_machine_issual = [];
            $criteria = new CDbCriteria();
            $criteria->alias = 't';
            $criteria->addCondition('status = :status');
            $criteria->params[':status'] = 'C';
            $criteria->addCondition('added_from = :added_from');
            $criteria->params[':added_from'] = 'DT';
            $criteria->addCondition('type = :type');
            $criteria->params[':type'] = 'I';
            if ($customer_id > 0) {
                $criteria->addCondition('t.customer_id = :customer_id');
                $criteria->params[':customer_id'] = $customer_id;
            }
            if ($lead_owner == 'Y' && $lead_owner_id > 0) {
                $criteria->addCondition('t.lead_owner_id = :lead_owner_id');
                $criteria->params[':lead_owner_id'] = $lead_owner_id;
            }
            $criteria->order = 't.id DESC';
            $criteria->with = ['warehouseTo', 'warehouseFrom'];
            $oil_materials = InventoryDirectTransfer::model()->findAll($criteria);
            foreach ($oil_materials as $row) {
                if (!empty($row->transfer_date) && ($row->transfer_date != "")) {
                    $req_date = date("d/m/Y", strtotime($row->transfer_date));
                }
                if ($row['lead_owner_id'] > 0) {
                    $user = $row['user_det']['first_name'] . ' ' . $row['user_det']['last_name'];
                } else {
                    $user = '';
                }
                $data_for_oil_issual[] = [
                    "id" => $row['id'],
                    "customer_name" => isset($row['customer_id']) ? $row['customer']['customer_name'] : '',
                    "req_date" => $req_date,
                    "from_warehouse_id" => $row['from_warehouse_id'],
                    "from_warehouse_name" => $row['warehouseFrom']['warehouse_name'],
                    "to_warehouse_id" => $row['to_warehouse_id'],
                    "to_warehouse_name" =>  $row['warehouseTo']['warehouse_name'],
                    "lead_owner_id" => $row['lead_owner_id'],
                    "lead_owner_name" => $user,
                    "description" => $row['direct_transfer_description'],
                    "reference" => $row['reference'], 
                    //"status" => $row['status'], 
                    "approved_status" => $row['isApproved']
                ];
            }
            $data['oil_issual'] = $data_for_oil_issual;
            $criteria = new CDbCriteria;
            $criteria->addCondition('inventorygoodsreceipt.receipt_type = :receipt_type');
            $criteria->params[':receipt_type'] = 'MH';
            $criteria->addCondition('isApproved = :isApproved');
            $criteria->params[':isApproved'] = 'N';
            if ($customer_id > 0) {
                $criteria->addCondition('inventorygoodsreceipt.customer_id = :customer_id');
                $criteria->params[':customer_id'] = $customer_id;
            }
            if ($lead_owner == 'Y' && $lead_owner_id > 0) {
                $criteria->addCondition('inventorygoodsreceipt.lead_owner_id = :lead_owner_id');
                $criteria->params[':lead_owner_id'] = $lead_owner_id;
            }
            $criteria->order = 't.id DESC';
            $criteria->with = array('inventorygoodsreceipt');
            $criteria->together = true;
            $machine_materials = InventoryGoodsReceiptItem::model()->findAll($criteria);
            foreach ($machine_materials as $row) {
                $data_for_machine_issual[] = [
                    "id" => $row->inventorygoodsreceipt->id,
                    "customer_id" => $row->inventorygoodsreceipt->customer_id,
                    "customer_name" => isset($row->inventorygoodsreceipt->customer_id) ? $row->inventorygoodsreceipt->customer->customer_name : '',
                    "lead_owner_id" => $row->inventorygoodsreceipt->lead_owner_id,
                    "lead_owner_name" => isset($row->inventorygoodsreceipt->lead_owner_id) ? $row->inventorygoodsreceipt->owner->first_name . ' ' . $row->inventorygoodsreceipt->owner->last_name : '',
                    "outlet_id" => $row->inventorygoodsreceipt->outlet_id,
                    "outlet_name" => isset($row->inventorygoodsreceipt->outlet_id) ? $row->inventorygoodsreceipt->outlet->outlet_location : '',
                    "serial_no" => isset($row->serial_no) ? $row->serial_no : '',
                    "product_id" => $row->product_id,
                    "product_name" => isset($row->product_name) ? $row->product_name : '',
                    "returned_date" => isset($row->inventorygoodsreceipt->goods_receipt_date) ? date('d/m/Y', strtotime($row->inventorygoodsreceipt->goods_receipt_date)) : '',
                ];
            }
            $data['machine_issual'] = $data_for_machine_issual;
            $response = array('status' => "success", "message" => "success", "data" => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);
    }

    public function actionGetApprovalView() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data = [];
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array['id'];
            $type = $data_array['type'];
            $lead_owner_id = $userModel->id;
            $model = new InventoryDirectTransfer();
            $model_items = array(new InventoryDirectTransferItem());
            $warehouseArray = MasInventoryWarehouse::getWarehousesCRM();
            if ($id > 0 && $type == 'MH') {
                $model = new InventoryGoodsReceipt();
                $model_items = array(new InventoryGoodsReceiptItem());
                $return_data = array();
                $return_items = array();
                $model = $model->findByPk($id);
                if ($model) {
                    $criteria = new CDbCriteria();
                    $criteria->addCondition('goods_receipt_id = :header_id');
                    $criteria->params = [':header_id' => $id];
                    $model_items = InventoryGoodsReceiptItem::model()->findAll($criteria);
                    if ($model_items) {
                        $modelLocation = ServiceCustomerLocation::model()->find(array('condition' => ' customer_id = '.$model->customer_id.' AND customer_outlet_location_id = '.$model->outlet_id, 'order' => 'location_name'));
                        foreach ($model_items as $i => $modeltransfer) {
                            $return_items[$i]['id'] = $modeltransfer['id'];
                            $return_items[$i]['serial_no'] = $modeltransfer['serial_no'];
                            $return_items[$i]['product_name'] = $modeltransfer['product_name'];
                            $return_items[$i]['location_id'] = $modeltransfer['location_id'];
                            $return_items[$i]['location_name'] = $modelLocation->location_name;
                            $return_items[$i]['description'] = $modeltransfer['description'];
                        }
                    }
                    $data = $return_items;
                }
            } else if ($id > 0) {
                $return_data = array();
                $return_items = array();
                $model = $model->findByPk($id);
                if ($model) {
                    $transfer_date = str_replace('/', '-', $model->transfer_date);
                    $transfer_date = date('d/m/Y', strtotime($transfer_date));
                    $model->transfer_date = $transfer_date;
                    $model_items = InventoryDirectTransferItem::model()->with('customer')->findAll(array('condition' => 'direct_transfer_id="' . $id . '"'));
                    if (empty($model_items)) {
                        $model_items = array(new InventoryDirectTransferItem());
                    }
                    $return_data['from_warehouse_id'] = $model->from_warehouse_id;
                    $return_data['from_warehouse_name'] = $warehouseArray[$model->from_warehouse_id];
                    $return_data['to_warehouse_id'] = $model->to_warehouse_id;
                    $return_data['to_warehouse_name'] = $warehouseArray[$model->to_warehouse_id];
                    $return_data['lead_owner_id'] = $model->lead_owner_id;
                    $return_data['lead_owner_name'] = User::model()->getName($model->lead_owner_id);
                    $return_data['customer_id'] = $model->customer_id;
                    $return_data['customer_name'] = $model->customer->customer_name;
                    //$data['return_data'] = $return_data;
                    if ($model_items) {
                        foreach ($model_items as $i => $modeltransfer) {
                            $returnedQty = $usedQty = 0;
                            if ($modeltransfer->stock_ledger_id && $model->status == 'C') {
                                $modeltransfer->balance_qty = (float) StockLedger::model()->find(array('select' => 'SUM(quantity) as quantity', 'condition' => 'master_stock_ledger_id="' . $modeltransfer->stock_ledger_id . '" AND transaction_type="IN"'))->quantity;
                            }
                            if ((int) $model->id > 0) {
                                $modeltransfer->available_qty = (float) ProductLocation::model()->find(array('select' => 'SUM(quantity) as quantity', 'condition' => 'product_id="' . $modeltransfer->item_id . '" AND warehouse_id=' . $model->from_warehouse_id))->quantity;
                            }
                            $modelUnit = UnitOfMeasurement::model()->find(array('condition' => 'product_id=' . $modeltransfer->item_id . ' AND isBase="Y"'));
                            $return_items[$i]['id'] = $modeltransfer['id'];
                            $return_items[$i]['item_name'] = $modeltransfer['item_name'];
                            $return_items[$i]['item_description'] = $modeltransfer['item_description'];
                            $return_items[$i]['transfer_qty'] = number_format($modeltransfer['transfer_qty'],2);
                            $return_items[$i]['balance_qty'] = number_format($modeltransfer['balance_qty'],2);
                            $return_items[$i]['used_qty'] = number_format(((int) $modeltransfer->transfer_qty - (int) $modeltransfer->balance_qty ),2);
                            $return_items[$i]['unit'] = $modelUnit->name;
                        }
                    }
                    $data = $return_items;
                }
            }
            $response = array('status' => "success", "message" => "success", "data" => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);
    }

    public function actionSaveApproval() {
        echo "Save Approval";exit;
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data = [];
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array['id'];
            $lead_owner_id = $userModel->id;
            $response = array('status' => "success", "message" => "success", "data" => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);
    }

    public function actionUploadSignature()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array['id'];
            $type = $data_array['type'];
            $prefix = 'APR';
            /*if ($id > 0 && $type == 'MH') {
                $prefix = 'MH';
                $model = new InventoryDirectTransfer();
                $model = $model->findByPk($id);
            } else if ($id > 0) {
                $prefix = 'OIL';
                $model = new InventoryGoodsReceiptItem();
                $model = $model->findByPk($id);
            }
            if (!empty($model)) {*/
                $mainDirectory = 'uploads/approval/';        
                $filename = $_FILES["file"]["name"]; //        
                $extension = pathinfo($filename, PATHINFO_EXTENSION);        
                $new_filename = $prefix.'_' .  date('d_m_Y') . '_' . uniqid() . "." . $extension;
                if (!is_dir($mainDirectory)) {
                    mkdir($mainDirectory, 0777, TRUE);
                }
                $fullPath = $mainDirectory . '/' . $filename;
                if (move_uploaded_file($_FILES["file"]["tmp_name"], $fullPath)) {        
                    $actual_resized_path = 'uploads/approval/' . $new_filename;
                    $response = [
                        "status" => "success",
                        "filepath" => $new_filename
                    ];        
                    $response = ["status" => "success", "filepath" => $new_filename];
                } else {
                    $response = ["status" => "error", "message" => "Upload Failed"];
                }
            /*} else {
                $response = ["status" => "error", "message" => "Approval Not Found"];
            }*/
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "error", "message" => "Unauthorized user");
        }
        echo json_encode($response);
    }
}