<?php

class ApidirectorderController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('save', 'load'),
                'users' => array('*'),
            ),
//            array('allow', // allow authenticated user to perform 'create' and 'update' actions
//                'actions' => array(''),
//                'expression' => '$user->isMember()',
//            ),
            array('deny', // deny all users
            // 'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
         $this->ChangeDB();
        return parent::beforeAction($action);
    }

    public function actionSave() {
        $data_array = json_decode(file_get_contents('php://input'), true);
        $items = $data_array['items'];
        $seat = $data_array['seat'];
        $itemModel = [];

        foreach ($items as $key => $value) {
            $itemModel[$key] = new TableOrder();
            $itemModel[$key]->is_billed = "N";
            $itemModel[$key]->item_id = $value["id"];
            $itemModel[$key]->qty = $value["qty"];
            $itemModel[$key]->table_id = $seat["table_id"];
            $itemModel[$key]->seat_num = $seat["id"];
            $itemModel[$key]->save();
        }
        echo json_encode([
            "id" => "0",
            "status" => true,
            "message" => ""
        ]);
    }

    public function actionLoad() {
        $data_array = json_decode(file_get_contents('php://input'), true);
        $condition = "";
        $conditionArray = [];
        foreach ($data_array as $value) {
            $conditionArray[] = " ( table_id = {$value['table_id']} AND seat_num = {$value['id']} ) ";
        }
        $condition = "is_billed= 'N' AND ( " . implode(" OR ", $conditionArray) . ")  ";

        $sql = " SELECT sum(qty) as qty ,`item_id` FROM `erp_table_order` where {$condition} GROUP by item_id ";
        $rawDate = Yii::app()->db->createCommand($sql)->queryAll();
        $data = [];
        foreach ($rawDate as $value) {
            $ItemModel = Store::model()->findByPk($value['item_id']);
            $data[] = [
                "id" => $value['item_id'],
                "qty" => $value['qty']
            ];
        }
        echo json_encode([
            'status' => true,
            'data' => $data
        ]);
    }

}
