<?php

class ApicustomerController extends Controller {



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array("GetList","GetOutletList","GetLocationList","SaveCustomer","SaveCustomerOutlets","SaveLocation","GetCustomerMachineList" ),

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    // public function beforeAction($action) {

    //      $this->ChangeDB();
    //     return parent::beforeAction($action);

    // }
 
    public function actionGetList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $term = $data_array['term'];
            // $staff_id = $data_array['staff_id'];
            // $full = $data_array['full'];
            $condition = " 1=1 ";
            $limit = 500;
            // if ($full == "N") {
            //     $schedule_date = date("Y-m-d");
            //     //assigned_id = 0 OR
            //     $condition .= "AND (FIND_IN_SET({$staff_id},lead_owner_id) OR t.created_by={$staff_id} OR 
            //                     t.id IN ( select customer_id from {{sale_repair_request}} WHERE (assigned_id = {$staff_id}) 
            //                     AND schedule_date='$schedule_date' )) ";
            // }
            $payment_type_array = MasPaymentTerm::getPaymentTerms();
            if (!empty($term)) {
                $condition .= " AND (t.customer_name LIKE '%{$term}%' OR t.customer_phone_no LIKE '%{$term}%') ";
            }
            $models = Customer::model()->findAll([
                "condition" => $condition,
                "order" => "customer_name",
                "limit" => $limit
            ]);
            $data = [];
            foreach ($models as $key => $row) {
                $modelcontact = new CustomerContact();
                $concondition= 'customer_id = "'.$row->id.'"';
                $modelcontact = $modelcontact ->findAll(array("condition" => $concondition));
                $contact_details =array();
                foreach ($modelcontact as $key => $contact) {
                    $contact_details[] =[
                       "contact_id" => $contact->id,  
                       "contact_name" => $contact->person_name,  
                       "contact_phone_no" => $contact->contact_phone_no,  
                    ];
                }
                $condition_1= 'customer_id = "'.$row->id.'"';
                $modelshipping = CustomerShippingDetails::model()->findAll(array("condition" => $condition_1));
                $outlet_location=$outlet_id='';
                $shipping_details =array();
                if(!empty($modelshipping)){
                    foreach ($modelshipping as $key => $shipping) {
                        $shipping_details[] =[
                           "id" => $shipping->id,  
                           "outlet_customer_name" => $shipping->shipping_customer_name,
                           "outlet_location" => $shipping->street_address,
                        ];
                }                }
                $data[] = [
                    "id" => $row->id,
                    "name" => $row->customer_name,
                    "email" => $row->customer_email_id,
                    "address" => $row->customer_address,
                    "lattitude" => $row->lattitude,
                    "longitude" => $row->longitude,
                    "phone" => $row->customer_phone_no,
                    "contact" => $contact_details,
                    "location"=> $row->customer_location,
                    "payment_type_id"=> $row->customer_payment_term,
                    "payment_type"=> $payment_type_array[$row->customer_payment_term],
                    "outlets"=>$shipping_details
                    ];
            }
            $response = array('status' => "success", "message" => "success", "data" => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "message" => "Unauthorized user");
        }
        echo json_encode($response);
    }
 
      public function actionGetOutletList() {
             $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                 $data = [];
                $customer_id = $data_array['customer_id'];
                if($customer_id>0){
                $term = $data_array['term'];
                $condition = "t.customer_id = " . $customer_id;
                 if (!empty($term)) {
                    $condition .= " AND (t.shipping_customer_name LIKE '%{$term}%' OR t.outlet_location LIKE '%{$term}%') ";
                }
                $models = CustomerOutletLocation::model()->findAll([
                    "condition" => $condition,
                    "order" => "shipping_customer_name desc"
                ]);
               
                foreach ($models as $key => $row) {
                    $data[] = [
                        "id" => $row->id,
                        "customer_name" => $row->shipping_customer_name,
                        "outlet_name" => $row->outlet_location,
                    ];
                }}
                $response = array('status' => "success", "message" => "success", "data" => $data);
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
            echo json_encode($response);
        }
         public function actionGetLocationList() {
                     $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
                    $userModel = User::model()->findBytoken($token);
                    $response = array();
                    if (!empty($userModel) && $userModel->id > 0) {
                        $data_array = json_decode(file_get_contents('php://input'), true);
                        $data = [];
                        $customer_id = $data_array['customer_id'];
                         if($customer_id>0){
                        $term = $data_array['term'];
                        $outlet_id = $data_array['outlet_id'];
                        $condition = "t.customer_id = " . $customer_id;
                        if($outlet_id > 0)
                        $condition .= " AND t.customer_outlet_location_id = " . $outlet_id;
                     if (!empty($term)) {
                        $condition .= " AND (t.location_name LIKE '%{$term}%') ";
                    }
                        $models = ServiceCustomerLocation::model()->findAll([
                            "condition" => $condition,
                            "order" => "location_name desc"
                        ]);
                        
                        foreach ($models as $key => $row) {
                            $data[] = [
                                "id"                 => $row->id,
                                "outlet_id" => $row->customer_outlet_location_id,
                                "outlet_name" => $row->outlet->outlet_location,
                                "location_name"      => $row->location_name
                            ];
                        }}
                        $response = array('status' => "success", "message" => "success", "data" => $data);
                    } else {
                        header("HTTP/1.1 401 Unauthorized");
                        header('Content-Type: application/json');
                        $response = array('status' => "failed", "message" => "Unauthorized user");
                    }
                    echo json_encode($response);
                }
 
          public function actionSaveCustomer()
          {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $model = new Customer();
                $modelcontact = new CustomerContact();
                if (!empty($data_array['id'])) {
                    $id = (int) $data_array['id'];
                    $model = Customer::model()->findByPk($id);
                     $model->updated_by = $data_array['created_by'];
                    $model->updated_date_time = date('Y-m-d H:i:s');
                }else{
                    $model->created_by = $data_array['created_by'];
                    $model->created_date_time = date('Y-m-d H:i:s');
                }
                // $model->attributes = $data_array;
                $model->customer_name = $data_array['customer_name'];
                $model->customer_phone_no = $data_array['customer_phone'];
                $model->customer_email_id = $data_array['customer_email'];
                $model->customer_web = $data_array['customer_web'];
                $model->location_id  = $data_array['location'];
                $model->customer_industry = MasIndustry::base_industry_id();//$data_array['customer_industry'];
                $model->lead_owner_id = $data_array['created_by'];
                $model->customer_trn_no = $data_array['customer_trn_no'];
                $model->customer_remarks = $data_array['customer_remarks'];
                $model->customer_city = $data_array['customer_city'];
                $model->customer_state = $data_array['customer_state'];
                $model->customer_postal_code = $data_array['customer_postal_code'];
                $model->customer_country = MasCountry::getDefaultID();//$data_array['customer_country'];
                $model->customer_address = $data_array['address'];
                $model->customer_currency_id =  MasCurrency::base_currency_id();//$data_array['customer_currency_id'];
                $payment_term_id  =  MasPaymentTerm::model()->find(array('condition' => 'isActive =  "Y"','order'=>'isBasePaymentTerm,payment_terms ASC'))->id;
                $model->customer_payment_term= !empty($variables['customer_payment_term'])?$variables['customer_payment_term']:$payment_term_id;
                $model->no_of_days= 25 ;
                $model->customer_credit_limit = '99999';//$data_array['customer_credit_limit'];
                $model->customer_location = $data_array['location'];
                // $model->customer_currency_id = $data_array['customer_currency_id'];
                // $model->customer_payment_term = $data_array['customer_payment_term'];
                // $model->customer_credit_limit = $data_array['customer_credit_limit'];
                
                if($data_array['Contact_id']){
                    $modelcontact = $modelcontact->findByPK($data_array['Contact_id']);
                    $modelcontact->updated_by = $data_array['created_by'];
                     $modelcontact->updated_date_time = date('Y-m-d h:i:s');
                }else{
                    $modelcontact->created_by = $data_array['created_by'];
                    $modelcontact->created_date_time = date('Y-m-d h:i:s');
                }
                $modelcontact->person_name = $data_array['contact_person'];
                $modelcontact->contact_phone_no = $data_array['contact_number'];
                $modelcontact->isActive = 'Y';
                 
                if ($model->validate()) {
                    $model->save();
                    $modelcontact->customer_id = $model->id;
                    $modelcontact->save();
                    // $modelshipping = new CustomerShippingDetails();
                    // $modelshipping->shipping_customer_name = $model->customer_name;
                    // $modelshipping->street_address = '-';
                    // $modelshipping->customer_id = $model->id;
                    // $modelshipping->save();
                    $response = ["status" => "success", "message" => "success", "id" => $model->id];
                } else {
                        $arr_err = array();
                        foreach ($model->errors as $t => $value) {
                            $arr_err[] = $value[0];
                        }
                    $response = ["status" => "error", "message" => $arr_err];
                }
                
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
            echo json_encode($response);
        }
   
   
    public function actionSaveCustomerOutlets()
          {
              $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
                $userModel = User::model()->findBytoken($token);
                $response = array();
                if (!empty($userModel) && $userModel->id > 0) {
                    $data_array = json_decode(file_get_contents('php://input'), true);
                    $customer_id = $data_array['customer_id'];
                    if((int)$customer_id >0){
                        $customer_name = "";
                        $modelCustomer = Customer::model()->findByPk($customer_id);
                        if(!empty($modelCustomer))
                        $customer_name = $modelCustomer->customer_name;
                        $model = new CustomerOutletLocation();
                        if (!empty($data_array['id'])) {
                            $id = $data_array['id'];
                            $model = CustomerOutletLocation::model()->findByPk($id);
                        }
                        $model->customer_id = $data_array['customer_id'];
                        $model->shipping_customer_name = $customer_name;//$data_array['shipping_customer_name'];
                        $model->outlet_location = $data_array['outlet_name'];
                        if ($model->validate()) {
                            $model->save();
                            $response = ["status" => "success", "message" => "success", "id" => $model->id];
                        } else {
                            $arr_err = array();
                            foreach ($model->errors as $t => $value) {
                                $arr_err[] = $value[0];
                            }
                            $response = ["status" => "error", "message" => $arr_err];
                        }
                    }
                    else {
                            $response = ["status" => "error", "message" =>"Customer cannot be blank"];
                        }
                } else {
                    header("HTTP/1.1 401 Unauthorized");
                    header('Content-Type: application/json');
                    $response = array('status' => "failed", "message" => "Unauthorized user");
                }
                echo json_encode($response);
            }
            public function actionSaveLocation() {
                $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
                $userModel = User::model()->findBytoken($token);
                $response = array();
                if (!empty($userModel) && $userModel->id > 0) {
                    $data_array = json_decode(file_get_contents('php://input'), true);
                 //   print_r($data_array);
                    $model = new ServiceCustomerLocation();
                    if (!empty($data_array['id'])) {
                        $id = (int) $data_array['id'];
                        $model = ServiceCustomerLocation::model()->findByPk($id);
                    }
                    
                    $model->customer_id = $data_array['customer_id'];
                    $model->customer_outlet_location_id = $data_array['outlet_id'];
                    $model->location_name = $data_array['location_name'];
                    $model->is_default_location = "N";//$data_array['is_default_location'];
                    if ($model->validate()) {
                        $model->save();
                        $response = ["status" => "success", "message" => "success", "id" => $model->id];
                    } else {
                            $arr_err = array();
                            foreach ($model->errors as $t => $value) {
                                $arr_err[] = $value[0];
                            }
                        $response = ["status" => "error", "message" => $arr_err];
                    }
                } else {
                    header("HTTP/1.1 401 Unauthorized");
                    header('Content-Type: application/json');
                    $response = array('status' => "failed", "message" => "Unauthorized user");
                }
                echo json_encode($response);
            }

 public function actionGetCustomerMachineList() {
             $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            $response = array();
            if (!empty($userModel) && $userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $customer_id = $data_array['customer_id'];
                $outlet_id = $data_array['outlet_id'];
                $location_id = $data_array['location_id'];
                $main_con = 'customer_id= "' . $customer_id . '" AND isActive="Y" ';
                if((int)$outlet_id>0)
                    $main_con .=' AND outlet_id='.$outlet_id;
                $modelMachine = InventoryGoodsIssue::model()->findAll(array('condition' => $main_con)); 
                foreach ($modelMachine as $eachMachine) {
                    $con = 'goods_issue_id ='.(int) $eachMachine->id;
                    if((int)$location_id>0)
                    $con .=' AND location_id='.$location_id;
                    $items = InventoryGoodsIssueItem::model()->findAll([
                        'condition' => $con
                    ]);
                    if (!empty($items)) {
                        $modelMachineItems[$eachMachine->id] = $items;
                    }
                }
                ///////////////////////////////////////////////////////////
                $data = [];
                $serial = 1;
                 foreach ($modelMachine as $header){
                    if (!empty($modelMachineItems[$header->id])){
                        foreach ($modelMachineItems[$header->id] as $item){
                            $data[] = [
                                "product_id"   => $item->product_id,
                                "machine_name" => Store::getProductName($item->product_id),     
                                "serial_no"    => $item->serial_no,
                                "outlet_id"    => (int)$header->outlet_id,
                                "location_id"  => (int)$item->location_id ,
                                "outlet"       => ($header->outlet_id ? $header->outlet->outlet_location : ''),
                                "location"     => ($item->location_id ? $item->location->location_name : ''),
                            ];
                            $serial++;
                        }
                    }
                }
                if ($serial === 1)
                    $data = [];
                ///////////////////////////////////////////////////////////////



                
                $response = array('status' => "success", "message" => "success", "data" => $data);
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "message" => "Unauthorized user");
            }
            echo json_encode($response);
    }
    
    

}

