<?php

class ApiUserController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'Userlist', "autologin"),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(''),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
            // 'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
         $this->ChangeDB();
        return parent::beforeAction($action);
    }

    public function actionLogin() {
        //     header('Content-type: application/json');
        $userName = Yii::app()->request->getParam('username');
        $passWord = Yii::app()->request->getParam('password');
        $message = "";
        $model = new LoginForm;
        $model->company_code = "DTC";
        $model->username = $userName;
        $model->password = $passWord;
        $jsonData = [
            "status" => "error",
            "userId" => "",
            "userName" => $userName,
            "name" => "",
        ];
//        $jsonData['log'] =;
        $valid = $model->validate() && $model->login();
  
        if (!$valid) {
            $message = "Login Failed. Invalid Username/Password.";
        }
        if ($valid) {
            $userModel = User::model()->find("username = '" . $userName . "' ");
            $jsonData["status"] = "success";
            $jsonData["userId"] = $userModel->id;
            $jsonData["name"] = $userModel->fullname;
            $jsonData['token'] = $this->http_token;
            $jsonData['message'] = "";
            //$this->setTripDefault($userModel->id);
            echo CJSON::encode($jsonData);
        } else {
            $jsonData['status'] = 'error';
            $jsonData['message'] = $message;
            echo CJSON::encode($jsonData);
        }
    }

}
