<?php



class ApiTicketController extends Controller
{



    public function accessRules()
    {

        return array(

            array(
                'allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array("PrintMRF", "UploadSnaglistSignature", "UploadJobImage", 'SaveJobImages', 'GetJobImagesList'),

                'users' => array('*'),

            ),

        );
    }



    public function filters()
    {

        return array(

            'accessControl', // perform access control for CRUD operations

        );
    }



    public function beforeAction($action)
    {

        $this->ChangeDB();
        return parent::beforeAction($action);
    }

    /**

     * API to Get customer list

     * Author  : Indhu

     * Modified :  13/10/2023

     * 

     */



    public function actionPrintMRF()
    {

        try {
            $valid = true;
            $other = array();
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);


            if ($userModel->id > 0) {

                $input               = file_get_contents('php://input');
                $variables           = json_decode($input, true);
                $ticket_id = $variables['ticket_id'];
                if ((int)$ticket_id == 0) {
                    $valid = false;
                    $other[] = "Ticket ID Canont Be Null";
                }
                if ($valid) {

                    $param = array(
                        'id' => $ticket_id,
                        'company_id' => $userModel->company_id,
                    );
                    $pdf_name = "MaterialRequestForm_" . '.pdf';
                    $file_path = 'uploads/apppdf/' . $pdf_name;
                    $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
                    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
                    $mPDF1->WriteHTML($stylesheet, 1);

                    $mPDF1->WriteHTML($this->renderPartial('application.modules.fm.views.ticket.api_print_mrf', $param, true));
                    $mPDF1->Output($file_path, 'F');

                    header('Content-Type: application/json');
                    $data = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
                } else {
                    $err_msg = implode(',', $other);
                    $data = ['status' => "error", "message" => $err_msg];
                }
            } else {

                header("HTTP/1.1 401 Unauthorized");

                header('Content-Type: application/json');

                $data = array('status' => "failed", "msg" => "Unauthorized user");
            }
        } catch (Exception $e) {
            header("HTTP/1.1 500 Internal Server Error");
            header('Content-Type: application/json');
            $data = ['status' => "error", "message" => "Unexpected Server error"];
        }
        echo json_encode($data);
    }

    public function actionUploadSnaglistSignature()
    {

        $token     = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ((int)$userModel->id > 0) {
            /*  $today        = date("Y-m-d");
            $filename     = $today . "_" . rand(0, getrandmax()) . "_" . basename($_FILES["file"]["name"]); */

            $today = date("Y-m-d");
            $originalFileName = $_FILES["file"]["name"];
            $originalFileName = str_replace(array(' ', ','), '_', $originalFileName); // Replace spaces and commas with underscores
            $fileExtension = pathinfo($originalFileName, PATHINFO_EXTENSION); // Get the file extension
            // Generate a unique identifier (You can use a variety of methods)
            $uniqueIdentifier = uniqid();
            // Concatenate the timestamp, unique identifier, and original file extension
            $filename = $today . "_" . $uniqueIdentifier . "." . $fileExtension;

            $destination  = "uploads/snaglistsignature/" . $filename;
            if (move_uploaded_file($_FILES["file"]["tmp_name"], $destination)) {
                $data = ["status" => "success", "filename" => $filename];
            } else {
                $data = ["status" => "error", "message" => "Upload Failed"];
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message" => "Unauthorized user");
        }
        echo json_encode($data);
    }


    public function actionUploadJobImage()
    {

        $token     = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ((int)$userModel->id > 0) {
            $today        = date("Y-m-d");
            /*   $filename     = $today . "_" . rand(0, getrandmax()) . "_" . basename($_FILES["file"]["name"]);
            */

            $today = date("Y-m-d");
            $originalFileName = $_FILES["file"]["name"];
            $originalFileName = str_replace(array(' ', ','), '_', $originalFileName); // Replace spaces and commas with underscores
            $fileExtension = pathinfo($originalFileName, PATHINFO_EXTENSION); // Get the file extension
            // Generate a unique identifier (You can use a variety of methods)
            $uniqueIdentifier = uniqid();
            // Concatenate the timestamp, unique identifier, and original file extension
            $filename = $today . "_" . $uniqueIdentifier . "." . $fileExtension;
            $destination  = "uploads/job/" . $filename;
            if (move_uploaded_file($_FILES["file"]["tmp_name"], $destination)) {
                $data = ["status" => "success", "filename" => $filename];
            } else {
                $data = ["status" => "error", "message" => "Upload Failed"];
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    public function actionSaveJobImages()
    {

        $token     = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $other               = array();
        $valid               = true;
        if ((int)$userModel->id > 0) {
            $input               = file_get_contents('php://input');
            $variables           = json_decode($input, true);
            $ticket_id           = $variables['ticket_id'];

            $array_job_img_list  = $variables['job_img_list'];

            if ($ticket_id <= 0) {
                $other[] = 'Ticket ID is Null';
                $valid = false;
            }
            if (empty($array_job_img_list)) {
                $other[] = 'Please Upload At Least One Image';
                $valid = false;
            }
            if ($valid) {
                $p = 0;
                if (is_array($array_job_img_list)) {

                    foreach ($array_job_img_list as $i => $item) {
                        $modelupload[$p]                    = new FmTicketJobImages;
                        $modelupload[$p]->created_by        = (int)$userModel->id;
                        $modelupload[$p]->created_date_time = date('Y-m-d H:i:s');
                        $modelupload[$p]->ticket_id         = $ticket_id;
                        $modelupload[$p]->job_img           = $item['job_img'];
                        $valid                              = $modelupload[$p]->validate();
                        $p++;
                    }
                }
                if ($valid) {
                    if (!empty($modelupload)) {
                        foreach ($modelupload as $eachItem) {
                            $eachItem->save(false);
                        }
                    }
                    $data['status']    = 'success';
                    $data['ticket_id'] = $ticket_id;
                } else {
                    $data['status']    = 'error';
                    $error1 = $error2 = $error3  = array();
                    $error2 = json_decode(CActiveForm::validate($modelupload, '', false), true);
                    $error             = array_merge_recursive($error1, $error2, $error3, $other);
                    foreach ($error as $a => $eacherror) {
                        $other[] = $eacherror[0];
                    }
                    if ($error != '[]')
                        $data['msg'] = implode(',', $other);
                }
            } else {
                $err_msg = implode(',', $other);
                $data = ['status' => "error", "message" => $err_msg];
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message" => "Unauthorized user");
        }
        echo json_encode($data);
    }


    public function actionGetJobImagesList()
    {
        $token     = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $other               = array();
        $valid               = true;
        if ((int)$userModel->id > 0) {
            $input               = file_get_contents('php://input');
            $variables           = json_decode($input, true);
            $ticket_id           = $variables['ticket_id'];
            if ($ticket_id <= 0) {
                $other[] = 'Ticket ID is Null';
                $valid = false;
            }
            if ($valid) {
                $condition  = "ticket_id = " . $ticket_id . '';
                $model = new FmTicketJobImages();
                $img_lists =  $model->findAll(array('condition' => $condition, 'order' => 'id'));
                $list = [];
                $count = 0;
                if (!empty($img_lists)) {
                    foreach ($img_lists as $row) {
                        $item_image = "uploads/job/" . $row['job_img'];
                        $extension = pathinfo($row['job_img'], PATHINFO_EXTENSION);

                        $list[] = array(  
                            "id"                  => $row['id'],
                            "ticket_id"           => $row['ticket_id'],
                            "job_img"             => $item_image,
                            "image_extension"     => $extension,
                        );
                        $count++;
                    }
                    $data = array('status' => "success", "count" => $count, "data" => $list, "message" =>  "success");
                } else {
                    $data = array('status' => "success", "count" =>  $count, "data" => $list, "message" => "success");
                }
            } else {
                $err_msg = implode(',', $other);
                $data = ['status' => "error", "message" => $err_msg];
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message" => "Unauthorized user");
        }
        echo json_encode($data);
    }
    
    


}
