<?php

class ApiPurchaseOrderController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array("GetPurchaseOrderList", "PurchaseOrderpdf"),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $company_db_name = "blueskye_pos_dehnee";

        Yii::app()->db->setActive(false);

        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;

        Yii::app()->db->tablePrefix = 'erp_';

        Yii::app()->db->setActive(true);
        return true;
    }

    public function actionGetPurchaseOrderList() {
        try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);

            //    if ($userModel->id > 0) {
            $condition = "((file.current_process_status = 'P_O' OR t.convert_status = 'Y')  AND completed!='C' )";
            $sql = "SELECT t.id,t.file_id,t.title,t.order_date,t.required_date,t.expected_delivery_date,t.completed,t.stock_grand_total,t.nonstock_grandtotal,t.exchange_rate,t.convert_status,
                t.vendor_id,t.service_invoice,t.vendor_contact_id,t.created_by,currencyname.currency_code,vendor_details.vendor_name,t.approved_level,
                file.current_process_status,file.is_approved,IFNULL(A.nonlocal_qty,0) AS nonlocal_qty
                FROM `erp_purchasing_order` t
                LEFT JOIN
                (SELECT purchasing_order_id,IFNULL(COUNT(S.id),0) AS nonlocal_qty FROM erp_purchasing_order_stock_item PEI
                LEFT JOIN erp_store S ON (PEI.stock_item_id =S.id AND S.purchase_from!='L') GROUP BY purchasing_order_id)A
                ON t.id = A.purchasing_order_id
                LEFT JOIN {{master_file}} file ON file.id=t.file_id
                LEFT JOIN {{vendor}} vendor_details ON vendor_details.id=t.vendor_id
                LEFT JOIN {{mas_currency}} currencyname ON currencyname.id=t.currency
                WHERE A.purchasing_order_id=t.id";
            $SQL1 = $sql . " AND ($condition)   ";
            // echo $SQL1;
            $model = Yii::app()->db->createCommand($SQL1)->queryAll();

            $m = 1;
            foreach ($model as $key => $row) {
                $order_date = date("d/m/Y", strtotime($row['order_date']));
                $required_date = date("d/m/Y", strtotime($row['expected_delivery_date']));
                if ($row['nonlocal_qty'] == 0) {
                    $ptype = 'L';
                } else {
                    $ptype = 'I';
                }
                if ($row['current_process_status'] == 'P_O') {
                    $status = 'Order';
                } else if ($row['current_process_status'] == 'M_R') {
                    $status = 'Material Reciept';
                } else if ($row['current_process_status'] == 'Q_C') {
                    $status = 'Quality Checked';
                } else if ($row['current_process_status'] == 'P_I') {
                    $status = 'Invoice';
                } else {
                    $status = '';
                }
                if ($row['completed'] == 'P') {
                    $status = 'Material Reciept (Partial)';
                }
                if ($row['completed'] == 'C') {
                    $status = 'Short Closure';
                }

                $state = 0;
                if (strtotime($row['required_date']) < strtotime(date('Y-m-d'))) {
                    $state = 1;
                } elseif ($row['is_approved'] == 'N') {
                    $state = 2;
                }
                $created_user = User::model()->findByPK($row['created_by'])->fullname;
                $grand_total = $row['stock_grand_total'] + $row['nonstock_grandtotal'];
                $grand_total_bc = ($grand_total * $row['exchange_rate']);

                $data[] = [
                    "SI No" => $m,
                    "file_id" => $row['file_id'],
                    "id" => $row['id'],
                    "vendor_name" => $row['vendor_name'],
                    "order_date" => $order_date,
                    "required_date" => $required_date,
                    "currency" => $row['currency_code'],
                    "total_value" => Yii::app()->numberFormatter->formatCurrency($grand_total, ""),
                    "total_value(bc)" => Yii::app()->numberFormatter->formatCurrency($grand_total_bc, ""),
                    "status" => $status,
                    "is_approved" => $row["is_approved"],
                    "created_user" => $created_user,
                ];
                $m++;
            }

            $data = array('status' => "success", "items" => $data);
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            /*   } else {
              header("HTTP/1.1 401 Unauthorized");
              header('Content-Type: application/json');
              $data = array('status' => "failed", "msg" => "Unauthorized user");
              } */
            if (empty($data)) {
                $data[] = array('msg' => "No Data Available");
            }
        } catch (Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message" => "Unexpected Server error");
        }

        echo json_encode($data);
    }

    public function actionPurchaseOrderpdf() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

        $condition = '';

        $id = $_GET['id'];
        if ($id > 0) {
            $model = PurchasingOrder::model()->findByPk($id);

            $param = array('model' => $model, 'id' => $id);
            $pdf_name = "PurchaseOrder" . $id . "_" . '.pdf';
            $file_path = 'uploads/apppdf/' . $pdf_name;
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.purchase_order_list_individual', $param, true));
            $mPDF1->Output($file_path, 'F');

            header('Content-Type: application/json');
            $data = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
        } else {

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    public function actionSaveApproval() {
        $model = new PurchasingOrder();
        $input = file_get_contents('php://input');
        error_log($input);

        $variables = json_decode($input, true);
        $file_id = $variables['visitor_name'];
        $id = $variables['id'];
        $modelPurchasingOrder = new PurchasingOrder();
        if ($id > 0) {
            $modelPurchasingOrder = $modelPurchasingOrder->findByPk($id);
            $model->scenario = 'update';
        } else {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
        }
        $model->title = $modelPurchasingOrder->title;
        $model->supplier_type = $modelPurchasingOrder->supplier_type;
        $model->vendor_id = $modelPurchasingOrder->vendor_id;
        $model->vendor_contact_id = $modelPurchasingOrder->vendor_contact_id;
        $model->enquiry_id = $modelPurchasingOrder->enquiry_id;
        $model->req_id = $modelPurchasingOrder->req_id;
        $model->shipping_address = $modelPurchasingOrder->shipping_address;
        $model->shipping_by = $modelPurchasingOrder->shipping_by;
        $model->order_date = $modelPurchasingOrder->order_date;
        $model->required_date = $modelPurchasingOrder->required_date;
        $model->expected_delivery_date = $modelPurchasingOrder->expected_delivery_date;
        $model->updated_by = 1;
        ;
        $model->updated_datetime = date('Y-m-d h:i:s');

        $model->start_text = $modelPurchasingOrder->start_text;
        $model->approved_level = 2;
        //$model->terms_and_conditions = $_POST['PurchasingOrder']['terms_and_conditions'];
        //Code modified by mereena on-10/2/2020 for ckeditor
        $model->terms_and_conditions = $modelPurchasingOrder->terms_and_conditions;
        //end
        $model->remarks = $modelPurchasingOrder->remarks;
        $model->notes = $modelPurchasingOrder->notes;
        $model->currency = $modelPurchasingOrder->currency;
        $model->exchange_rate = $modelPurchasingOrder->exchange_rate;

        $model->invoice_type = $modelPurchasingOrder->invoice_type;
        $model->crm_user_id = 1;
        $model->file_id = $file_id;
        $valid = $model->validate();
        $total_tax_amount = 0;
        $p = 0;
    }

}
