<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity {

    private $_id;
    public $company_code;

    /**
     * Authenticates a user.
     * @return boolean whether authentication succeeds.
     */
    public function __construct($username, $password, $company_code) {
        $this->username = $username;
        $this->password = $password;
        $this->company_code = $company_code;
    }

    public function authenticate() {
        $username = strtolower($this->username);

        $company_id = MasCompany::getCompanyId($this->company_code);
        //$password = crypt($this->password, $this->password);
        //START Code modified on 08-04-2016 for secured password
        $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password = crypt($this->password, $salt);
        //END Code modified on 08-04-2016 for secured password
        //$user = User::model()->find('LOWER(username)=? AND isActive=? ', array($username, 'Y'));
        //$user = User::model()->find('LOWER(username)=? AND isActive=? AND company_id=?', array($username, 'Y',$company_id));
        $user = User::model()->find(array('condition' => 'LOWER(username)="' . $username . '" AND isActive="Y" AND company_id=' . (int) $company_id . ' AND level<=3'));


        if ($user == null)
            $this->errorCode = self::ERROR_USERNAME_INVALID;
        else if ($user->password != $password)
            $this->errorCode = self::ERROR_PASSWORD_INVALID;
        else {
            /* if((UserTypes::model()->findByPk( $user->type_id )->type) == 'admin' || (UserTypes::model()->findByPk( $user->type_id )->type)=='superadmin') // This is admin login
              {
              $this->setStateKeyPrefix('admin_');
              }
              else
              {
              $this->setStateKeyPrefix('front_');
              } */
            $this->_id = $user->id;
            $this->setState('fullname', $user->fullname);
            $this->setState('master_user_company_id', $user->company_id);

            //$this->setState('master_user_branch_id', $user->branch_id);
            /* if(isset($user->ownBranch->branch_name))
              $this->setState('user_branch', $user->ownBranch->branch_name);
              else */
            $this->setState('user_branch', "");
            $this->setState('user_email_id', $user->email);

            //$this->setState('company_logo', $user->own_company->company_logo);
            //$company_branch_id		=	$user->branch_id;
            //$company_branch_id		=	$userGroups{0}->company_branch_id;
            //$user_group_parent_id	=	$userGroups{0}->parent_id;
            $authorised_user = 0;
            //if($company_branch_id==0 && $user_group_parent_id==0)
            if ($user->level == 0)
                $authorised_user = 1;

            $this->setState('authorised_user', $authorised_user);
            //$arr_company = MasCompany::model()->findAll('id='.$user->company_id);
            $arr_company = MasCompany::getMasCompanyDetails($user->company_id);
            //echo '<pre>';
            //print_r($arr_company);
            //exit;
            $master_company_name = $arr_company->company_name;
            $company_db_name = $arr_company->company_db_name;
            $company_head_user = $arr_company->crm_user_id;
            $company_logo = $arr_company->company_logo;
            $company_footer_logo = $arr_company->footer_logo;
            $footer_line_1 = $arr_company->footer_line_one;
            $footer_line_2 = $arr_company->footer_line_two;
            $auto_generated = $arr_company->footer_autogenerated;
            $fin_year = $arr_company->fin_year;
            $company_level_id = (int) $arr_company->company_level_id;
            $this->setState('master_company_code', $this->company_code);
            $this->setState('master_company_name', $master_company_name);
            $this->setState('main_db_name', 'blueskye_pos_dehnee_main'); //cumulusc_unipro_main
            $this->setState('company_db_name', trim($company_db_name));
            $this->setState('company_head_user', trim($company_head_user));
            $this->setState('company_logo', $company_logo);
            $this->setState('pdf_company_logo', $company_logo);
            $this->setState('master_company_name', $master_company_name);
            $this->setState('footer_line_1', $footer_line_1);
            $this->setState('footer_line_2', $footer_line_2);
            $this->setState('footer_autogenerated', $auto_generated);
            $this->setState('fin_year', $fin_year);
            $this->setState('level', $user->level);
            $this->setState('haveFinanceModule', true);

            $this->setState('user_warehouse_id', $user->available_warehouses);
            $this->setState('user_mis_accessible_branches', $user->mis_accessible_branches);
            if (isset($arr_company->genral_email))
                $this->setState('company_general_email', $arr_company->genral_email);
            else
                $this->setState('company_general_email', "test@mailbluesky.com");

            if (isset($arr_company->genral_web))
                $this->setState('company_general_web', $arr_company->genral_web);
            else
                $this->setState('company_general_web', "");

            if (isset($arr_company->genral_phno))
                $this->setState('company_general_phone_no', $arr_company->genral_phno);
            else
                $this->setState('company_general_phone_no', "");


            $this->setState('company_footer_logo', $company_footer_logo);
            $this->setState('company_base_currency', $arr_company->currency_id);



            if ($company_db_name != "") {
                $this->setState('database', trim($company_db_name));
                Yii::app()->db->setActive(false);
                Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
                Yii::app()->db->tablePrefix = 'erp_';
                Yii::app()->db->setActive(true);
                $mod_usergrp = new MasUserGroup();
                $mod_usergrp = $mod_usergrp->findByPk($user->user_group_id);
                $this->setState('qtn_approval_limit', (float) $mod_usergrp->qtn_approval_val_limit);
                $this->setState('order_approval_limit', (float) $mod_usergrp->order_approval_val_limit);
                $this->setState('min_profit_percentage', (float) $mod_usergrp->min_profit_percentage);

                $userGroups = MasUserGroup::model()->findAll('id in (' . $user->user_group_id . ')');
                $permissionArray = $hrpermissionArray =$formatted_array= $hr_formatted_array=array();
                foreach ($userGroups as $eachUserGroup) {
                    if (!empty($eachUserGroup->permissions)) {
                        $permissionArray = CJSON::decode($eachUserGroup->permissions);
                        $formatted_array = array_map(function($num) {
                            return (is_numeric(trim($num)) ? number_format(floatval($num), 0, '', '') : $num);
                        }, $permissionArray);
                    }
                    if (!empty($eachUserGroup->hr_permissions)) {
                        $hrpermissionArray = CJSON::decode($eachUserGroup->hr_permissions);
                        $hr_formatted_array = array_map(function($num) {
                            return (is_numeric(trim($num)) ? number_format(floatval($num), 0, '', '') : $num);
                        }, $hrpermissionArray);
                    }
                }
                $this->setState('havePermissionOn', array_merge($formatted_array));
                $this->setState('haveHrPermissionOn', array_merge($hr_formatted_array));
                
                
                //code added by mereena on 27/05/2025 to get level permission
                $level_permission_array = array();
                $level_formatted_array = array();
                if($company_level_id > 0){
                    $arr_company_level = MasCompanyLevel::model()->findByPk($company_level_id);
                    
                    if (!empty($arr_company_level)) {
                        $level_permission_array = CJSON::decode($arr_company_level->permissions);
                        $level_formatted_array = array_map(function($num) {
                            return (is_numeric(trim($num)) ? number_format(floatval($num), 0, '', '') : $num);
                        }, $level_permission_array);
                    }
                    
                    
                }
                
                $this->setState('haveLevelPermissionOn', array_merge($level_formatted_array));
                //echo '<pre>';
                //print_r($level_formatted_array);exit;
                //end


                //code added by mereena on 11/01/2024

                $modelMasCompanySettings = new MasCompanySettings();
                $modelMasCompanySettings = $modelMasCompanySettings->find(array('condition' => 'crm_company_id=' . (int) $arr_company->id));

                $this->setState('projects_menu', $modelMasCompanySettings->projects_menu);
                $this->setState('fm_menu', $modelMasCompanySettings->fm_menu);

                $outlet_id = 0;
                if ($modelMasCompanySettings->generate_invoice_no == 'OUTLET') {
                    $outlet_id = $user->outlet_id;
                }
                $this->setState('outlet_id', $outlet_id);


                $this->username = $user->username;
                $this->errorCode = self::ERROR_NONE;
            } else {
                $this->errorCode = 'You are not authorized person';
            }
        }
        return $this->errorCode == self::ERROR_NONE;
    }

    public function getId() {
        return $this->_id;
    }

}
