<?php

class EWebUser extends CWebUser {

    protected $_model;
    function isAdmin() {
        $user = $this->loadUser();
        if ($user && $user->level == 0) {
            return true;
        }
        return false;
    }

    function isMember() {
        $user = $this->loadUser();
        if ($user) {
            return true;
        }
        return false;
    }

    function userDepartment() {
        $user = $this->loadUser();
        if ($user) {
            return (Department::model()->findByPK($user->department_id)->department);
        }
        return 0;
    }

    // Load user model.
    protected function loadUser() {
        if ($this->_model === null) {
            $this->_model = User::model()->findByPk($this->id);
        }
        return $this->_model;
    }

}