$.fn.hasAttr = function(attribute){
    var attr = this.attr(attribute);
    if (typeof attr !== typeof undefined && attr !== false){
        return true;}
        else{return false;}
    }
function isValidType($el){
    var type = $el.attr('type');
    return (type != 'hidden' && type != 'submit' && type != 'reset' && type != 'range' && type != 'checkbox' && type != 'radio' && type != 'file' ? 1 : 0);
}
function isType($el, type){
    var el_type = $el.attr('type');
    return (el_type == type);
}
function addFilled($el){
    if($el.val() || $el.attr('placeholder'))
        $el.addClass('filled');
    else
        $el.removeClass('filled');
}
function materializing(divSelector) {
    $(divSelector).each(function(q){
        if (!$(this).hasClass("material")) {
            $(this).addClass("material");
        }
        $(this).find('input, textarea').each(function(i){
            if ($(this).hasClass('go') || $(this).hasClass('form-control') || $(this).hasClass('material-done')) {
                return true;
            }
            if(isValidType($(this)) && !$(this).hasClass("material-done") && !$(this).hasClass("go") && !$(this).parents('.multiselect-container').length){
                $(this).addClass('material-done');
                var name = $(this).attr('name');
                var theme = $(this).attr('theme');
                if (!theme) {
                    theme = "spinner-default"
                }
                var $wrap = $(this).wrap("<div class='material-input'></div>").parent();
                $wrap.append("<span class='material-bar'></span>");
                var tagName = $(this).prop("tagName").toLowerCase();
                $wrap.addClass(tagName);
                var placeholder = $(this).attr('data-label');
                if(placeholder){
                    $wrap.append("<label for='"+name+"'>"+placeholder+"</label>");
                }
                if ($(this).hasClass('spinner')) {
                    var spinner ='<div class="spinner-div '+theme+'"><button class="spinner-btn sup" type="button"><i class="fa fa-caret-up"></i></button><button class="spinner-btn sdown" type="button"><i class="fa fa-caret-down"></i></button></div>';
                    $wrap.append(spinner);
                }
                addFilled($(this));
            }
            if(isType($(this), 'file') && !$(this).hasClass('go')){
                // var placeholder = $(this).attr('data-label');
                // var name = $(this).attr('name');
                // var $wrap = $(this).wrap("<div class='material-input'></div>").parent();
                // $(this).addClass('filled');
                // $wrap.append("<span class='material-bar'></span>");
                // if(placeholder){
                //  $wrap.append("<label for='"+name+"'>"+placeholder+"</label>");
                // }
            }
            if(isType($(this), 'radio') || isType($(this), 'checkbox') && !$(this).hasClass("material-done") && !$(this).hasClass("go")){
                $(this).addClass('material-done');
                if($(this).parents('.multiselect-container').length){
                }
                else if ($(this).hasClass('switch')) {
                    var bt = $(this).attr('beforeText');
                    var at = $(this).attr('afterText');
                    var placeholder = $(this).attr('data-label');
                    if(!bt){bt = 'No';}
                    if(!at){at = 'Yes';}
                    if(placeholder){
                        var $switch_holder = $(this).wrap("<div class='switch-holder'></div>").parent();
                        $switch_holder.prepend('<label>'+placeholder+'</label>');
                    }
                    var $wrap = $(this).wrap("<div class='switch'><label></label></div>").parent();
                    $wrap.append(bt);
                    $wrap.append('<span class="lever"></span>');
                    $wrap.append(at);
                }
                else{
                    var name = $(this).attr('name').replace('[]','');
                    var placeholder = $(this).attr('data-label');
                    var id = $(this).attr('id');
                    var $forlabel = $(this).parents('.material').find("label[for='"+id+"']");
                    var heading = $(this).attr('data-heading');
                    var item_id = name+ '-' + i;
                    var $label = $('<label for="'+item_id+'">'+placeholder+'</label>');
                    var $heading_input = $('<span class="label-heading">'+heading+'</span>');
                    var $wrap = $(this).wrap("<div class='material-group-item'></div>").parent();
                    if (placeholder) {
                        $wrap.append($label);
                        $(this).attr('id', item_id);
                    }else if(id) {
                        $forlabel.addClass('test');
                        $wrap.append($forlabel);
                    }
                    if (heading) {
                        $wrap.append($heading_input);
                    }
                    if(isType($(this), 'radio'))
                        var $input_type = $('<div class="material-radio"></div>');
                    else
                        var $input_type = $('<div class="material-checkbox"></div>');
                    $wrap.append($input_type);
                }
            }
            }); // End Finding input & textareas
        $(this).find('input, textarea').on('blur', function(){
            if(isValidType($(this)))
                addFilled($(this))
        });
            // Selects
            $(this).find('select').each(function(i){
                if ($(this).hasClass('go') || $(this).hasClass('form-control') || $(this).hasClass('material-done')) {
                    return true;
                }
                $(this).addClass('material-done');
                if ($(this).hasClass("go")) {

                }
                else{
                    var placeholder = $(this).attr('data-label');
                    var search =false;
                    search = $(this).attr('data-search');
                    var $label = $('<label class="material-select-label">'+placeholder+'</label>');
                    var $wrap = $(this).wrap("<div class='material-select'></div>").parent();
                    $wrap.append($label);
                    if (search) {
                        $(this).multiselect({
                            enableClickableOptGroups: true,
                            enableCollapsibleOptGroups: true,
                            enableFiltering: true,
                            includeSelectAllOption: true,
                            enableCaseInsensitiveFiltering: true,
                        });
                    }else{
                        $(this).multiselect({
                            enableClickableOptGroups: true,
                        });
                    }
                }
            });// Selects end
    }); // each

} // materializing function end
$(document).ready(function(){
    materializing(".material");
    var select_scroll = {
        cursorcolor:"#37a0d9",
        cursoropacitymin:"0.3",
        cursoropacitymax:"0.9",
        cursorwidth:"4px",
        cursorborder:"0",
        cursorborderradius:"0",
        mousescrollstep:"10",
        //touchbehavior:true,
        //autohidemode:true,
        background:"#ccc"
    };
    try{
        $(".multiselect-container").niceScroll(select_scroll);
        $(".multiselect-container").getNiceScroll().hide()
        $(".multiselect").click(function(){
            if ($(this).parent(".btn-select-group").hasClass("open")) {
                $(this).getNiceScroll().show();
                $(this).getNiceScroll().resize();
            }
            else{
                $(this).getNiceScroll().hide();
            }
        });
        $(".btn-select-group").on("shown.bs.dropdown", function(event){
            $(".multiselect-container").getNiceScroll().show();
            $(".multiselect-container").getNiceScroll().resize();
        });
        $(".btn-select-group").on("hide.bs.dropdown", function(event){
            $(".multiselect-container").getNiceScroll().hide();
        });
        $(".multiselect-container").hover(function() {
            $(this).getNiceScroll().resize();
        }, function() {
            $(this).getNiceScroll().resize();
        });
    }catch(err){
        console.error(err.message);
        console.info("Install niceScrollbar for better experience");
    }
});
$(document).ajaxComplete(function(){
    materializing(".material");
});
$(window).load(function(){
    $('.sup').on('click',function() {
        var value = $(this).parents('.material-input').children( ".spinner" ).val();
        $(this).parents('.material-input').children( ".spinner" ).val( parseInt(++value));
    });
    $('.sdown').on('click',function() {
        var value = $(this).parents('.material-input').children( ".spinner" ).val();
        $(this).parents('.material-input').children( ".spinner" ).val( parseInt(--value));
    });
});