<!-- dashboard.php -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Dashboard - Sage Media Group</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <style>
        /* ===== RESET AND BASE STYLES ===== */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html, body {
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            font-size: 14px;
            line-height: 1.6;
            color: #333;
            background-color: #f5f6f5;
        }

        /* ===== LAYOUT CONTAINERS ===== */
        .container {
            max-width: 1200px;
            margin: 20px auto;
            padding: 0 15px;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            margin: 0 -15px;
        }

        .col-4, .col-8 {
            padding: 0 15px;
        }

        .col-4 {
            flex: 0 0 33.333333%;
            max-width: 33.333333%;
        }

        .col-8 {
            flex: 0 0 66.666667%;
            max-width: 66.666667%;
        }

        /* ===== HEADER STYLES ===== */
        .dashboard-header {
            background: linear-gradient(135deg, #2c3e50 0%, #5db5a4 100%);
            color: white;
            padding: 20px 30px;
            border-radius: 10px;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .dashboard-header h1 {
            font-size: 28px;
            font-weight: 300;
            margin: 0;
        }

        .header-stats {
            display: flex;
            gap: 20px;
        }

        .header-stats .stat {
            text-align: center;
        }

        .header-stats .stat .number {
            font-size: 20px;
            font-weight: 600;
        }

        .header-stats .stat .label {
            font-size: 12px;
            opacity: 0.8;
        }

        /* ===== CARD STYLES ===== */
        .card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.08);
            padding: 20px;
            margin-bottom: 20px;
            border-left: 4px solid #5db5a4;
        }

        .card h3 {
            font-size: 18px;
            margin-bottom: 15px;
            color: #2c3e50;
            border-bottom: 2px solid #5db5a4;
            padding-bottom: 10px;
        }

        .card p {
            margin: 5px 0;
            font-size: 14px;
        }

        .card p strong {
            color: #2c3e50;
            display: inline-block;
            width: 150px;
        }

        /* ===== GRID VIEW STYLES ===== */
        .grid-view {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.08);
            overflow: hidden;
            margin-bottom: 20px;
        }

        .grid-view table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
        }

        .grid-view thead {
            background: #f5f6f5;
        }

        .grid-view thead th {
            padding: 15px;
            color: #333;
            font-weight: bold;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }

        .grid-view tbody tr:nth-child(even) {
            background-color: #fff;
        }

        .grid-view tbody tr:hover {
            background-color: #e3f2fd;
        }

        .grid-view tbody td {
            padding: 15px;
            border-bottom: 1px solid #dee2e6;
            vertical-align: middle;
        }

        /* ===== BUTTON STYLES ===== */
        .btn {
            display: inline-block;
            padding: 10px 20px;
            font-size: 14px;
            font-weight: 500;
            text-align: center;
            border-radius: 6px;
            text-decoration: none;
            transition: all 0.3s;
        }

        .btn-primary {
            color: #fff;
            background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
            border: none;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #2980b9 0%, #21618c 100%);
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(52, 152, 219, 0.4);
        }

        .btn-success {
            color: #fff;
            background: linear-gradient(135deg, #27ae60 0%, #229954 100%);
            border: none;
        }

        .btn-success:hover {
            background: linear-gradient(135deg, #229954 0%, #1e8449 100%);
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(39, 174, 96, 0.4);
        }

        .btn-default {
            color: #333;
            background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%);
            border: 1px solid #ced4da;
        }

        .btn-default:hover {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.15);
        }

        .buttons {
            margin-top: 20px;
            text-align: right;
        }

        .buttons .btn {
            margin-left: 10px;
        }

        /* Utility Classes */
        .text-right {
            text-align: right;
        }

        .mb-3 {
            margin-bottom: 1rem;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .col-4, .col-8 {
                flex: 0 0 100%;
                max-width: 100%;
                margin-bottom: 20px;
            }

            .dashboard-header {
                flex-direction: column;
                align-items: flex-start;
            }

            .header-stats {
                margin-top: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <?php
        // Database connection
         // Database connection
        $host = 'localhost';
        $dbname = 'blueskyerp_erp_demo_new';
        $username = 'blueskyerp_demoerp'; // Replace with your database username
        $password = '8WsKoWcI04SU'; // Replace with your database password


        try {
            $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            die("Connection failed: " . $e->getMessage());
        }

        // Fetch customer data (assuming ID 1 for Sage Media Group)
        $customerId = 1001;
        $stmt = $pdo->prepare("SELECT * FROM erp_customer WHERE id = :id");
        $stmt->execute([':id' => $customerId]);
        $customer = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$customer) {
            die("Customer not found.");
        }

        // Fetch contacts
        $stmt = $pdo->prepare("SELECT * FROM erp_customer_contact WHERE customer_id = :customer_id");
        $stmt->execute([':customer_id' => $customerId]);
        $contacts = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Count leads
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM erp_lead WHERE customer_id = :customer_id");
        $stmt->execute([':customer_id' => $customerId]);
        $leadsCount = $stmt->fetchColumn();

        // Count invoices
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM erp_invoice WHERE customer_id = :customer_id");
        $stmt->execute([':customer_id' => $customerId]);
        $invoicesCount = $stmt->fetchColumn();

        // Notes count (simplified)
        $notesCount = !empty($customer['customer_remarks']) ? 1 : 0;
        ?>

        <!-- Header -->
        <div class="dashboard-header">
            <h1><?php echo htmlspecialchars($customer['customer_name']); ?></h1>
            <div class="header-stats">
                <div class="stat">
                    <div class="number"><?php echo $leadsCount; ?></div>
                    <div class="label">Leads</div>
                </div>
                <div class="stat">
                    <div class="number"><?php echo $invoicesCount; ?></div>
                    <div class="label">Invoices</div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="row">
            <!-- Left Side: Customer Details -->
            <div class="col-4">
                <div class="card">
                    <h3>Customer Details</h3>
                    <p><strong>ID:</strong> <?php echo htmlspecialchars($customer['id']); ?></p>
                    <p><strong>Address:</strong> <?php echo htmlspecialchars($customer['customer_address']); ?></p>
                    <p><strong>City:</strong> <?php echo htmlspecialchars($customer['customer_city']); ?></p>
                    <p><strong>Country:</strong> <?php echo htmlspecialchars($customer['customer_country']); ?></p>
                    <p><strong>Phone No:</strong> <?php echo htmlspecialchars($customer['customer_phone_no']); ?></p>
                    <p><strong>Email ID:</strong> <?php echo htmlspecialchars($customer['customer_email_id']); ?></p>
                    <p><strong>Location:</strong> <?php echo htmlspecialchars($customer['customer_location']); ?></p>
                    <p><strong>Payment Term:</strong> <?php echo htmlspecialchars($customer['customer_payment_term']); ?></p>
                    <p><strong>Website:</strong> <?php echo htmlspecialchars($customer['customer_web']); ?></p>
                    <p><strong>TRN No:</strong> <?php echo htmlspecialchars($customer['customer_trn_no'] ?: '-'); ?></p>
                </div>
            </div>

            <!-- Right Side: Related Information -->
            <div class="col-8">
                <!-- Quick Stats -->
                <div class="card">
                    <h3>Quick Stats</h3>
                    <div class="row">
                        <div class="col-4">
                            <div class="stats-card">
                                <div class="number"><?php echo $leadsCount; ?></div>
                                <div class="label">Leads</div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="stats-card">
                                <div class="number"><?php echo $notesCount; ?></div>
                                <div class="label">Notes</div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="stats-card">
                                <div class="number"><?php echo $invoicesCount; ?></div>
                                <div class="label">Invoices</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contacts Table -->
                <div class="card">
                    <h3>Contacts</h3>
                    <div class="grid-view">
                        <table>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Date</th>
                                    <th>Notes</th>
                                    <th>Invoices</th>
                                    <th>Leads</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($contacts as $index => $contact): ?>
                                    <tr>
                                        <td><?php echo $index + 1; ?></td>
                                        <td><?php echo htmlspecialchars($contact['person_name']); ?></td>
                                        <td><?php echo htmlspecialchars($contact['created_date_time'] ? date('Y-m-d', strtotime($contact['created_date_time'])) : '-'); ?></td>
                                        <td><?php echo htmlspecialchars($contact['notes'] ?: '-'); ?></td>
                                        <td>1</td> <!-- Placeholder -->
                                        <td>0</td> <!-- Placeholder -->
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="card">
                    <h3>Recent Activity</h3>
                    <p><strong>Last Updated:</strong> <?php echo htmlspecialchars($customer['updated_date_time']); ?> by User ID <?php echo htmlspecialchars($customer['updated_by']); ?></p>
                    <p><strong>Created:</strong> <?php echo htmlspecialchars($customer['created_date_time']); ?> by User ID <?php echo htmlspecialchars($customer['created_by']); ?></p>
                </div>

                <!-- Buttons -->
                <div class="buttons">
                    <button class="btn btn-primary" data-toggle="modal" data-target="#previewModal">Preview</button>
                    <a href="#" class="btn btn-success">Save</a>
                    <a href="#" class="btn btn-default">Close</a>
                </div>
            </div>
        </div>

        <!-- Preview Modal -->
        <div class="modal fade" id="previewModal" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Customer Preview</h5>
                        <button type="button" class="close" data-dismiss="modal">
                            <span>×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p><strong>Company:</strong> <?php echo htmlspecialchars($customer['customer_name']); ?></p>
                        <p><strong>Phone:</strong> <?php echo htmlspecialchars($customer['customer_phone_no']); ?></p>
                        <p><strong>Email:</strong> <?php echo htmlspecialchars($customer['customer_email_id']); ?></p>
                        <p><strong>Website:</strong> <?php echo htmlspecialchars($customer['customer_web']); ?></p>
                        <p><strong>Address:</strong> <?php echo htmlspecialchars($customer['customer_address']); ?>, 
                            <?php echo htmlspecialchars($customer['customer_city']); ?>, 
                            <?php echo htmlspecialchars($customer['customer_state']); ?>, 
                            <?php echo htmlspecialchars($customer['customer_postal_code']); ?>, 
                            <?php echo htmlspecialchars($customer['customer_country']); ?></p>
                        <p><strong>Industry:</strong> <?php echo htmlspecialchars($customer['customer_industry']); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>